% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObtainingDIC.R
\name{ObtainingDIC}
\alias{ObtainingDIC}
\title{Writting the loglikelihood of the dirichlet}
\usage{
ObtainingDIC(cadenas, MatrizPBmodelo, E, Tt, especiemodi)
}
\arguments{
\item{cadenas}{Matrix with the iterations (in rows) of all the Markov Chains obtained in th estimation. It is the output of "StudyingParam" adding "$AllChainsJoined".}

\item{MatrizPBmodelo}{Matrix with the covariates of the model. In an example with two SPBal and three time points, the covariates are written in the following  order:
 \tabular{rrr}{
 1 \tab  1  \tab  1\cr
\eqn{ SPBal_{1,t-1}} \tab  \eqn{SPBal_{1,t-2}} \tab   \eqn{SPBal_{1,t-3}} \cr
 \eqn{SPBal_{2,t-1}} \tab  \eqn{SPBal_{2,t-2}} \tab   \eqn{SPBal_{2,t-3}} }}

\item{E}{Number f bacteria in the dataset.}

\item{Tt}{Number of time points available}

\item{especiemodi}{Matrix that contains at row i the bacterial taxa of bacteria i at time points t=2,...,\code{Tt}.}
}
\value{
Returns a data.frame with the DIC value (using the rule, pD = var/2).
}
\description{
This function calculates the loglikelihood of the dirichlet for the BPBM model. Then, it calculates the loglikelihood with the parameters of each iteration of the MCMC chains and introduces the values in a vector called vectorD. DIC=(1/2)*var(vectorD)+mean(VectorD)
}
\examples{


set.seed(314)
especie=t(gtools::rdirichlet(n=2, c(1,2,3)))
E=3
Tt=2
MatrizPBmodelo=rbind(c(1,1),c(-0.3,0.4),c(0.3,0.5))
set.seed(314)
est=Estimating_BPBM(especie,
                   Tt,
                   E,
                   MatrizPBmodelo,
                   nn.chain=3,
                   nn.burnin=1000,
                   nn.sample=5000,
                   nn.thin=10)
SumFinal=StudyingParam(est$R2jagsOutput$BUGSoutput$summary   ,est$SamplesAllChains)
cadenas=SumFinal$AllChainsJoined
especiemodi=especie[,-1]

ObtainingDIC(cadenas,MatrizPBmodelo,E,Tt,especiemodi)
}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2022). Bayesian hierarchical compositional models for analysing longitudinal abundance data from microbiome studies. Complexity, 2022.
}
