% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.R
\name{aggregate_timeseries}
\alias{aggregate_timeseries}
\title{Aggregate multiple timeseries columns to a single one}
\usage{
aggregate_timeseries(dtf, varname, omit = NULL)
}
\arguments{
\item{dtf}{data.frame or tibble, first column of name \code{datetime} being
of class datetime and rest of columns being numeric}

\item{varname}{character, name of the aggregation column}

\item{omit}{character, name of columns to not aggregate}
}
\value{
tibble
}
\description{
The first column \code{datetime} will be kept.
}
\examples{
building_flows <- data.frame(
  datetime = as.POSIXct("2024-01-01 00:00:00", tz = "UTC") + 0:3 * 3600,
  building1 = c(2.1, 2.5, 2.3, 2.0),
  building2 = c(1.0, 1.1, 0.9, 1.2)
)
aggregate_timeseries(building_flows, varname = "total_building")

}
