/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.server.engine.ClassLoaderDelegate;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001b\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0005*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\b\u0010\u0007\u001a\u0019\u0010\u000b\u001a\u0004\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ljava/lang/ClassLoader;", "", "Ljava/net/URL;", "allURLs", "(Ljava/lang/ClassLoader;)Ljava/util/Set;", "", "urlClassPath", "(Ljava/lang/ClassLoader;)Ljava/util/List;", "urlClassPathByPackagesList", "Ljava/lang/Class;", "Ljava/lang/reflect/Field;", "findURLClassPathField", "(Ljava/lang/Class;)Ljava/lang/reflect/Field;", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nClassLoaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassLoaders.kt\nio/ktor/server/engine/ClassLoadersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1563#2:79\n1634#2,3:80\n1460#2,2:83\n1563#2:85\n1634#2,3:86\n1462#2,3:89\n1056#2:92\n1374#2:93\n1460#2,5:94\n1669#2,8:99\n1310#3,2:107\n1#4:109\n*S KotlinDebug\n*F\n+ 1 ClassLoaders.kt\nio/ktor/server/engine/ClassLoadersKt\n*L\n56#1:79\n56#1:80,3\n57#1:83,2\n59#1:85\n59#1:86,3\n57#1:89,3\n60#1:92\n62#1:93\n62#1:94,5\n63#1:99,8\n67#1:107,2\n*E\n"})
public final class ClassLoadersKt {
    @NotNull
    public static final Set<URL> allURLs(@NotNull ClassLoader $this$allURLs) {
        Object parentUrls;
        Intrinsics.checkNotNullParameter((Object)$this$allURLs, (String)"<this>");
        Object object = $this$allURLs.getParent();
        if (object == null || (object = ClassLoadersKt.allURLs((ClassLoader)object)) == null) {
            object = parentUrls = SetsKt.emptySet();
        }
        if ($this$allURLs instanceof URLClassLoader) {
            URL[] uRLArray = ((URLClassLoader)$this$allURLs).getURLs();
            Intrinsics.checkNotNullExpressionValue((Object)uRLArray, (String)"getURLs(...)");
            Set urls = CollectionsKt.toSet((Iterable)ArraysKt.filterNotNull((Object[])uRLArray));
            return SetsKt.plus((Set)urls, (Iterable)((Iterable)parentUrls));
        }
        List<URL> list = ClassLoadersKt.urlClassPath($this$allURLs);
        if (list == null) {
            return parentUrls;
        }
        List<URL> ucp = list;
        return SetsKt.plus((Set)parentUrls, (Iterable)ucp);
    }

    private static final List<URL> urlClassPath(ClassLoader $this$urlClassPath) {
        try {
            Field field = ClassLoadersKt.findURLClassPathField($this$urlClassPath.getClass());
            if (field == null) {
                return null;
            }
            Field ucpField = field;
            ucpField.setAccessible(true);
            Object object = ucpField.get($this$urlClassPath);
            if (object == null) {
                return null;
            }
            Object ucpInstance = object;
            Method method = ucpInstance.getClass().getMethod("getURLs", new Class[0]);
            if (method == null) {
                return null;
            }
            Method getURLsMethod = method;
            getURLsMethod.setAccessible(true);
            Object[] urls = (URL[])getURLsMethod.invoke(ucpInstance, new Object[0]);
            return urls != null ? ArraysKt.toList((Object[])urls) : null;
        }
        catch (Throwable throwable) {
            List<URL> list;
            try {
                list = ClassLoadersKt.urlClassPathByPackagesList($this$urlClassPath);
            }
            catch (Throwable throwable2) {
                list = null;
            }
            return list;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<URL> urlClassPathByPackagesList(ClassLoader $this$urlClassPathByPackagesList) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMapTo$iv;
        char[] it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = new ClassLoaderDelegate($this$urlClassPathByPackagesList).packagesList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, (char)'.', (char)'/', (boolean)false, (int)4, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$mapTo$iv$iv2;
            String packageName = (String)element$iv;
            boolean bl = false;
            it = new char[]{'/'};
            List segments = StringsKt.split$default((CharSequence)packageName, (char[])it, (boolean)false, (int)0, (int)6, null);
            Iterable $this$map$iv2 = (Iterable)new IntRange(1, segments.size());
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator = $this$mapTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                void it2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(CollectionsKt.joinToString$default((Iterable)segments.subList(0, (int)it2), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
            }
            Iterable list$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv2), (Object)packageName);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Iterable $this$sortedBy$iv = destination$iv;
        boolean $i$f$sortedBy = false;
        List allPackagePaths = CollectionsKt.plus((Collection)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl;
                char character;
                char element$iv;
                int n;
                String it = (String)a;
                boolean bl2 = false;
                CharSequence $this$count$iv = it;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (n = 0; n < $this$count$iv.length(); ++n) {
                    character = element$iv = $this$count$iv.charAt(n);
                    bl = false;
                    if (!(character == '/')) continue;
                    ++count$iv;
                }
                it = (String)b;
                Comparable comparable = Integer.valueOf(count$iv);
                bl2 = false;
                $this$count$iv = it;
                $i$f$count = false;
                count$iv = 0;
                for (n = 0; n < $this$count$iv.length(); ++n) {
                    character = element$iv = $this$count$iv.charAt(n);
                    bl = false;
                    if (!(character == '/')) continue;
                    ++count$iv;
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(count$iv));
            }
        }), (Object)"");
        Iterable $this$flatMap$iv = allPackagePaths;
        boolean $i$f$flatMap = false;
        Iterable $i$f$flatMapTo22 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Object object;
            block8: {
                block7: {
                    String path = (String)element$iv$iv;
                    boolean bl = false;
                    object = $this$urlClassPathByPackagesList.getResources(path);
                    if (object == null) break block7;
                    ArrayList<URL> arrayList = Collections.list(object);
                    Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                    object = arrayList;
                    if (object != null) break block8;
                }
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            URL it3 = (URL)e$iv;
            boolean bl = false;
            String string = it3.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String key$iv = StringsKt.substringBefore$default((String)string, (char)'!', null, (int)2, null);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    private static final Field findURLClassPathField(Class<?> $this$findURLClassPathField) {
        Object object;
        block3: {
            Field[] fieldArray = $this$findURLClassPathField.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Object[] $this$firstOrNull$iv = fieldArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"ucp") && Intrinsics.areEqual((Object)it.getType().getSimpleName(), (Object)"URLClassPath"))) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        Field field = (Field)object;
        if (field != null) {
            Field it = field;
            boolean bl = false;
            return it;
        }
        AnnotatedElement annotatedElement = $this$findURLClassPathField.getSuperclass();
        if (annotatedElement == null || (annotatedElement = ClassLoadersKt.findURLClassPathField(annotatedElement)) == null) {
            return null;
        }
        return annotatedElement;
    }
}

