/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.util;

import com.intellij.openapi.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class GradleTreeTraverserUtil {
    public static <T> void depthFirstTraverseTree(@NotNull T root, @NotNull Function<T, Collection<? extends T>> action) {
        if (root == null) {
            GradleTreeTraverserUtil.$$$reportNull$$$0(0);
        }
        if (action == null) {
            GradleTreeTraverserUtil.$$$reportNull$$$0(1);
        }
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.addFirst(root);
        while (!stack.isEmpty()) {
            Object parent = stack.removeFirst();
            ArrayList<T> children = new ArrayList<T>(action.apply(parent));
            for (int i = children.size() - 1; i >= 0; --i) {
                stack.addFirst(children.get(i));
            }
        }
    }

    public static <T> void breadthFirstTraverseTree(@NotNull T root, @NotNull Function<T, Collection<? extends T>> action) {
        if (root == null) {
            GradleTreeTraverserUtil.$$$reportNull$$$0(2);
        }
        if (action == null) {
            GradleTreeTraverserUtil.$$$reportNull$$$0(3);
        }
        ArrayDeque<T> queue = new ArrayDeque<T>();
        queue.addLast(root);
        while (!queue.isEmpty()) {
            Object parent = queue.removeFirst();
            Collection<T> children = action.apply(parent);
            for (T child : children) {
                queue.addLast(child);
            }
        }
    }

    public static <T> void backwardTraverseTree(@NotNull T root, @NotNull Function<T, Collection<? extends T>> getChildren, @NotNull Consumer<T> action) {
        if (root == null) {
            GradleTreeTraverserUtil.$$$reportNull$$$0(4);
        }
        if (getChildren == null) {
            GradleTreeTraverserUtil.$$$reportNull$$$0(5);
        }
        if (action == null) {
            GradleTreeTraverserUtil.$$$reportNull$$$0(6);
        }
        Object previous = root;
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.addFirst(root);
        while (!stack.isEmpty()) {
            Object current = stack.peekFirst();
            ArrayList<T> children = new ArrayList<T>(getChildren.apply(current));
            if (children.isEmpty() || children.get(children.size() - 1) == previous) {
                current = stack.removeFirst();
                action.accept(current);
                previous = current;
                continue;
            }
            for (int i = children.size() - 1; i >= 0; --i) {
                stack.addFirst(children.get(i));
            }
        }
    }

    public static <T> void depthFirstTraverseTreeWithPath(@NotNull T root, @NotNull BiFunction<? super List<? extends T>, T, Collection<? extends T>> action) {
        if (root == null) {
            GradleTreeTraverserUtil.$$$reportNull$$$0(7);
        }
        if (action == null) {
            GradleTreeTraverserUtil.$$$reportNull$$$0(8);
        }
        ArrayList treePath = new ArrayList();
        GradleTreeTraverserUtil.depthFirstTraverseTree(new Pair((Object)0, root), node -> {
            Object oldParent;
            Object v0 = oldParent = treePath.isEmpty() ? null : treePath.get(treePath.size() - 1);
            while (oldParent != null && treePath.size() > (Integer)node.first) {
                treePath.remove(treePath.size() - 1);
                oldParent = treePath.isEmpty() ? null : treePath.get(treePath.size() - 1);
            }
            Collection children = (Collection)action.apply(treePath, node.second);
            treePath.add(node.second);
            ArrayList<Pair> childrenWithDepth = new ArrayList<Pair>();
            for (Object child : children) {
                childrenWithDepth.add(new Pair((Object)((Integer)node.first + 1), child));
            }
            return childrenWithDepth;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getChildren";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/util/GradleTreeTraverserUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "depthFirstTraverseTree";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "breadthFirstTraverseTree";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "backwardTraverseTree";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "depthFirstTraverseTreeWithPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

