/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenGroovyConsoleFilter;
import org.jetbrains.idea.maven.project.MavenScalaConsoleFilter;
import org.jetbrains.idea.maven.project.MavenTestConsoleFilter;

public final class MavenConsoleFilterProvider
implements ConsoleFilterProvider {
    private static final String MAVEN_PREFIX = "(?:^|(?:\\[\\w+\\]\\s*)( /)?)";
    private static final String CONSOLE_FILTER_REGEXP = "(?:^|(?:\\[\\w+\\]\\s*)( /)?)$FILE_PATH$:\\[$LINE$,$COLUMN$]";
    private static final String CONSOLE_FILTER_REGEXP_KT = "(?:^|(?:\\[\\w+\\]\\s*)( /)?)$FILE_PATH$: \\($LINE$, $COLUMN$\\)";

    public Filter @NotNull [] getDefaultFilters(@NotNull Project project) {
        if (project == null) {
            MavenConsoleFilterProvider.$$$reportNull$$$0(0);
        }
        Filter[] filterArray = new Filter[]{new RegexpFilterMaven(project, CONSOLE_FILTER_REGEXP), new RegexpFilterMaven(project, CONSOLE_FILTER_REGEXP_KT), new MavenGroovyConsoleFilter(project), new MavenScalaConsoleFilter(project), new MavenTestConsoleFilter()};
        if (filterArray == null) {
            MavenConsoleFilterProvider.$$$reportNull$$$0(1);
        }
        return filterArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenConsoleFilterProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenConsoleFilterProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFilters";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class RegexpFilterMaven
    extends RegexpFilter {
        private final Project project;

        private RegexpFilterMaven(Project project, String expression) {
            super(project, expression);
            this.project = project;
        }

        @Nullable
        protected HyperlinkInfo createOpenFileHyperlink(String fileName, int line, int column2) {
            String projectPath;
            VirtualFile[] roots;
            HyperlinkInfo res = super.createOpenFileHyperlink(fileName, line, column2);
            if (res == null && fileName.startsWith("\\") && SystemInfo.isWindows && (roots = ProjectRootManager.getInstance((Project)this.project).getContentRoots()).length > 0 && (projectPath = roots[0].getPath()).matches("[A-Z]:[\\\\/].+")) {
                res = super.createOpenFileHyperlink(projectPath.charAt(0) + ":" + fileName, line, column2);
            }
            return res;
        }
    }
}

