/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.git.frontend.widget;

import com.intellij.frontend.FrontendApplicationInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.impl.ExpandableComboAction;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.RowIcon;
import com.intellij.vcs.git.CwmUtilKt;
import com.intellij.vcs.git.branch.popup.GitBranchesPopup;
import com.intellij.vcs.git.frontend.widget.GitToolbarWidgetActionKt;
import com.intellij.vcs.git.frontend.widget.GitWidgetPlaceholder;
import com.intellij.vcs.git.frontend.widget.GitWidgetStateHolder;
import com.intellij.vcs.git.repo.GitRepositoriesHolder;
import com.intellij.vcs.git.repo.GitRepositoryModel;
import com.intellij.vcs.git.rpc.GitWidgetState;
import git4idea.i18n.GitBundle;
import icons.DvcsImplIcons;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\b\u0010$\u001a\u00020%H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0015\u001a\u00020(H\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/vcs/git/frontend/widget/GitToolbarWidgetAction;", "Lcom/intellij/openapi/wm/impl/ExpandableComboAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "event", "clarifyState", "Lcom/intellij/vcs/git/rpc/GitWidgetState;", "project", "Lcom/intellij/openapi/project/Project;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "updateCustomComponent", "component", "updateNoVcs", "updateWithReposNotLoadedGitRepo", "updateOnGitRepo", "state", "Lcom/intellij/vcs/git/rpc/GitWidgetState$OnRepository;", "getPopupForRepoSetup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "trustedProject", "", "getCreateRepoActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getInAndOutIcons", "Lcom/intellij/ui/RowIcon;", "Lcom/intellij/vcs/git/rpc/GitWidgetState$RepositoryPresentation;", "intellij.vcs.git.frontend"})
@SourceDebugExtension(value={"SMAP\nGitToolbarWidgetAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitToolbarWidgetAction.kt\ncom/intellij/vcs/git/frontend/widget/GitToolbarWidgetAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,180:1\n1#2:181\n37#3,2:182\n*S KotlinDebug\n*F\n+ 1 GitToolbarWidgetAction.kt\ncom/intellij/vcs/git/frontend/widget/GitToolbarWidgetAction\n*L\n166#1:182,2\n*E\n"})
public final class GitToolbarWidgetAction
extends ExpandableComboAction
implements ActionRemoteBehaviorSpecification.Frontend,
DumbAware {
    public GitToolbarWidgetAction() {
        this.getTemplatePresentation().setText(GitBundle.message("action.main.toolbar.git.Branches.text", new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null || CwmUtilKt.isCodeWithMe(FrontendApplicationInfo.INSTANCE)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GitWidgetState state2 = (GitWidgetState)GitWidgetStateHolder.Companion.getInstance(project).getState().getValue();
        if (state2 instanceof GitWidgetState.OnRepository) {
            GitWidgetPlaceholder.INSTANCE.updatePlaceholder(project, ((GitWidgetState.OnRepository)state2).getPresentationData().getText());
        }
        e.getPresentation().putClientProperty(GitToolbarWidgetActionKt.access$getGIT_WIDGET_STATE_KEY$p(), (Object)state2);
        GitWidgetState gitWidgetState = state2;
        if (Intrinsics.areEqual((Object)gitWidgetState, (Object)GitWidgetState.DoNotShow.INSTANCE)) {
            e.getPresentation().setEnabledAndVisible(false);
        } else if (gitWidgetState instanceof GitWidgetState.NoVcs) {
            this.updateNoVcs(project, e);
        } else if (Intrinsics.areEqual((Object)gitWidgetState, (Object)GitWidgetState.GitRepositoriesNotLoaded.INSTANCE)) {
            this.updateWithReposNotLoadedGitRepo(project, e);
        } else if (gitWidgetState instanceof GitWidgetState.OnRepository) {
            this.updateOnGitRepo((GitWidgetState.OnRepository)state2, e);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Nullable
    public JBPopup createPopup(@NotNull AnActionEvent event) {
        JBPopup jBPopup;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        GitWidgetState state2 = this.clarifyState(event, project2);
        if (state2 == null || Intrinsics.areEqual((Object)state2, (Object)GitWidgetState.DoNotShow.INSTANCE) || Intrinsics.areEqual((Object)state2, (Object)GitWidgetState.GitRepositoriesNotLoaded.INSTANCE)) {
            jBPopup = null;
        } else if (state2 instanceof GitWidgetState.NoVcs) {
            GitWidgetPlaceholder.INSTANCE.updatePlaceholder(project2, null);
            jBPopup = (JBPopup)this.getPopupForRepoSetup(((GitWidgetState.NoVcs)state2).getTrustedProject(), event);
        } else if (state2 instanceof GitWidgetState.OnRepository) {
            GitRepositoriesHolder holder = GitRepositoriesHolder.Companion.getInstance(project2);
            GitRepositoryModel repo = holder.get(((GitWidgetState.OnRepository)state2).getRepository());
            List<GitRepositoryModel> repositories = holder.getAll();
            jBPopup = (JBPopup)(repo == null || repositories.isEmpty() ? null : GitBranchesPopup.Companion.createDefaultPopup(project2, repo, repositories));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jBPopup;
    }

    private final GitWidgetState clarifyState(AnActionEvent event, Project project) {
        GitWidgetState gitWidgetState;
        GitWidgetState gitWidgetState2 = (GitWidgetState)event.getPresentation().getClientProperty(GitToolbarWidgetActionKt.access$getGIT_WIDGET_STATE_KEY$p());
        if (gitWidgetState2 == null) {
            return null;
        }
        GitWidgetState state2 = gitWidgetState2;
        if (state2 instanceof GitWidgetState.GitRepositoriesNotLoaded) {
            String string = GitBundle.message("action.Git.Loading.Branches.progress", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            TasksKt.runWithModalProgressBlocking((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
                int label;
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ComponentManager $this$service$iv = (ComponentManager)this.$project;
                            boolean $i$f$service = false;
                            Class<GitRepositoriesHolder> serviceClass$iv = GitRepositoriesHolder.class;
                            Object object2 = $this$service$iv.getService(serviceClass$iv);
                            if (object2 == null) {
                                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                            }
                            this.label = 1;
                            Object object3 = ((GitRepositoriesHolder)object2).awaitInitialization((Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            Object object = GitWidgetStateHolder.Companion.getInstance(project).getState().getValue();
            GitWidgetState it = (GitWidgetState)object;
            boolean bl = false;
            event.getPresentation().putClientProperty(GitToolbarWidgetActionKt.access$getGIT_WIDGET_STATE_KEY$p(), (Object)it);
            gitWidgetState = (GitWidgetState)object;
        } else {
            gitWidgetState = state2;
        }
        return gitWidgetState;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        JComponent $this$createCustomComponent_u24lambda_u240 = jComponent = super.createCustomComponent(presentation, place);
        boolean bl = false;
        $this$createCustomComponent_u24lambda_u240.setMaximumSize(new Dimension(Integer.MAX_VALUE, $this$createCustomComponent_u24lambda_u240.getMaximumSize().height));
        return jComponent;
    }

    public void updateCustomComponent(@NotNull JComponent component2, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        super.updateCustomComponent(component2, presentation);
    }

    private final void updateNoVcs(Project project, AnActionEvent e) {
        String placeholder = GitWidgetPlaceholder.INSTANCE.getPlaceholder(project);
        Presentation $this$updateNoVcs_u24lambda_u240 = e.getPresentation();
        boolean bl = false;
        $this$updateNoVcs_u24lambda_u240.setEnabledAndVisible(true);
        String string = placeholder;
        if (string == null) {
            String string2 = GitBundle.message("git.toolbar.widget.no.repo", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        $this$updateNoVcs_u24lambda_u240.setText(string);
        $this$updateNoVcs_u24lambda_u240.setIcon(placeholder != null ? GitToolbarWidgetActionKt.access$getWIDGET_ICON$p() : null);
        $this$updateNoVcs_u24lambda_u240.setDescription(GitBundle.message("git.toolbar.widget.no.repo.tooltip", new Object[0]));
    }

    private final void updateWithReposNotLoadedGitRepo(Project project, AnActionEvent e) {
        String placeholder = GitWidgetPlaceholder.INSTANCE.getPlaceholder(project);
        Presentation $this$updateWithReposNotLoadedGitRepo_u24lambda_u240 = e.getPresentation();
        boolean bl = false;
        $this$updateWithReposNotLoadedGitRepo_u24lambda_u240.setEnabledAndVisible(true);
        String string = placeholder;
        if (string == null) {
            String string2 = GitBundle.message("git.toolbar.widget.no.loaded.repo", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        $this$updateWithReposNotLoadedGitRepo_u24lambda_u240.setText(string);
        $this$updateWithReposNotLoadedGitRepo_u24lambda_u240.setIcon(GitToolbarWidgetActionKt.access$getWIDGET_ICON$p());
        $this$updateWithReposNotLoadedGitRepo_u24lambda_u240.setDescription(null);
    }

    private final void updateOnGitRepo(GitWidgetState.OnRepository state2, AnActionEvent e) {
        GitWidgetState.RepositoryPresentation presentation = state2.getPresentationData();
        Presentation $this$updateOnGitRepo_u24lambda_u240 = e.getPresentation();
        boolean bl = false;
        $this$updateOnGitRepo_u24lambda_u240.setEnabledAndVisible(true);
        Object object = presentation.getIcon();
        if (object == null || (object = IconIdKt.icon((IconId)object)) == null) {
            Icon icon = AllIcons.General.Vcs;
            object = icon;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Vcs");
        }
        $this$updateOnGitRepo_u24lambda_u240.setIcon((Icon)object);
        $this$updateOnGitRepo_u24lambda_u240.setText(presentation.getText());
        $this$updateOnGitRepo_u24lambda_u240.setDescription(presentation.getDescription());
        e.getPresentation().putClientProperty(ActionUtil.SECONDARY_ICON, (Object)this.getInAndOutIcons(presentation));
    }

    private final ListPopup getPopupForRepoSetup(boolean trustedProject, AnActionEvent event) {
        ActionGroup actionGroup;
        if (trustedProject) {
            actionGroup = this.getCreateRepoActionGroup();
        } else {
            Separator separator = new Separator(GitBundle.message("action.main.toolbar.git.project.not.trusted.separator.text", new Object[0]));
            AnAction trustProjectAction = ActionManager.getInstance().getAction("ShowTrustProjectDialog");
            AnAction[] anActionArray = new AnAction[]{separator, trustProjectAction};
            actionGroup = (ActionGroup)new DefaultActionGroup(anActionArray);
        }
        ActionGroup group = actionGroup;
        String string = ActionPlaces.getPopupPlace((String)"Vcs.Toolbar.Widget");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPopupPlace(...)");
        String place = string;
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, group, event.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, place);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        return listPopup;
    }

    private final ActionGroup getCreateRepoActionGroup() {
        AnAction anAction = ActionManager.getInstance().getAction("Vcs.ToolbarWidget.CreateRepository");
        ActionGroup actionGroup = anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
        if (actionGroup == null) {
            actionGroup = (ActionGroup)new DefaultActionGroup();
        }
        return actionGroup;
    }

    private final RowIcon getInAndOutIcons(GitWidgetState.RepositoryPresentation presentation) {
        RowIcon rowIcon;
        Icon icon;
        Object[] objectArray = new Icon[2];
        Icon icon2 = icon = DvcsImplIcons.Incoming;
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        boolean bl2 = presentation.getSyncStatus().getIncoming();
        objectArray2[n] = bl2 ? icon : null;
        Icon it = icon = DvcsImplIcons.Outgoing;
        n = 1;
        objectArray2 = objectArray;
        boolean bl3 = false;
        bl2 = presentation.getSyncStatus().getOutgoing();
        objectArray2[n] = bl2 ? icon : null;
        List inOutIcons = CollectionsKt.listOfNotNull((Object[])objectArray);
        if (inOutIcons.isEmpty()) {
            rowIcon = null;
        } else {
            Collection $this$toTypedArray$iv = inOutIcons;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Icon[0]);
            RowIcon rowIcon2 = new RowIcon((Icon[])Arrays.copyOf(objectArray, objectArray.length));
            rowIcon = rowIcon2;
        }
        return rowIcon;
    }
}

