/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI.types;

import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.members.MockConstructor;
import com.intellij.debugger.mockJDI.members.MockMethod;
import com.intellij.debugger.mockJDI.types.MockReferenceType;
import com.intellij.debugger.mockJDI.values.MockObjectReference;
import com.intellij.debugger.mockJDI.values.MockValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class MockClassType
extends MockReferenceType
implements ClassType {
    public MockClassType(MockVirtualMachine virtualMachine, Class type) {
        super(type, virtualMachine);
    }

    @Override
    protected List<ReferenceType> getThisAndAllSupers() {
        ArrayList<ReferenceType> referenceTypes = new ArrayList<ReferenceType>();
        ClassType type = this;
        do {
            referenceTypes.add(type);
        } while ((type = type.superclass()) != null);
        referenceTypes.addAll(this.allInterfaces());
        return referenceTypes;
    }

    @Override
    public ClassType superclass() {
        Class superclass = this.myType.getSuperclass();
        return superclass != null ? (MockClassType)this.myVirtualMachine.createReferenceType(superclass) : null;
    }

    @Override
    public List<InterfaceType> interfaces() {
        ArrayList<InterfaceType> interfaceTypes = new ArrayList<InterfaceType>();
        for (Class<?> aClass : this.myType.getInterfaces()) {
            interfaceTypes.add(this.myVirtualMachine.createInterfaceType(aClass));
        }
        return interfaceTypes;
    }

    @Override
    public List<ClassType> subclasses() {
        throw new UnsupportedOperationException("Not implemented: \"subclasses\" in " + this.getClass().getName());
    }

    @Override
    public boolean isEnum() {
        return this.myType.isEnum();
    }

    @Override
    public void setValue(Field field, Value value2) {
        throw new UnsupportedOperationException("Not implemented: \"setValue\" in " + this.getClass().getName());
    }

    @Override
    public Value invokeMethod(ThreadReference threadReference, Method method, List<? extends Value> list, int i2) throws InvocationException {
        try {
            Object[] args = MockClassType.values2Objects(list);
            java.lang.reflect.Method refMethod = ((MockMethod)method).getMethod();
            return MockValue.createValue(refMethod.invoke(null, args), refMethod.getReturnType(), this.myVirtualMachine);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InvocationException(null);
        }
    }

    public static Object[] values2Objects(List<? extends Value> list) {
        return list.stream().map(value2 -> ((MockValue)value2).getValue()).toArray();
    }

    @Override
    public ObjectReference newInstance(ThreadReference threadReference, Method method, List<? extends Value> list, int i2) throws InvocationException {
        Object[] args = MockClassType.values2Objects(list);
        Constructor constructor = ((MockConstructor)method).getConstructor();
        try {
            return MockObjectReference.createObjectReference(constructor.newInstance(args), this.myType, this.myVirtualMachine);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new InvocationException(null);
        }
    }

    @Override
    public Method concreteMethodByName(String string, String string1) {
        List<Method> methods = this.methodsByName(string, string1);
        if (methods.isEmpty()) {
            return null;
        }
        return methods.get(0);
    }

    @Override
    public List<ObjectReference> instances(long l) {
        throw new UnsupportedOperationException("Not implemented: \"instances\" in " + this.getClass().getName());
    }

    @Override
    public int majorVersion() {
        throw new UnsupportedOperationException("Not implemented: \"majorVersion\" in " + this.getClass().getName());
    }

    @Override
    public int minorVersion() {
        throw new UnsupportedOperationException("Not implemented: \"minorVersion\" in " + this.getClass().getName());
    }

    @Override
    public int constantPoolCount() {
        throw new UnsupportedOperationException("Not implemented: \"constantPoolCount\" in " + this.getClass().getName());
    }

    @Override
    public byte[] constantPool() {
        throw new UnsupportedOperationException("Not implemented: \"constantPool\" in " + this.getClass().getName());
    }
}

