; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefix=SI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefix=VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-FAKE16 %s

define <28 x float> @bitcast_v28i32_to_v28f32(<28 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v28i32_to_v28f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB0_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB0_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v28i32_to_v28f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB0_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB0_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v28i32_to_v28f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB0_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB0_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v28i32_to_v28f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB0_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB0_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <28 x i32> %a, splat (i32 3)
  %a2 = bitcast <28 x i32> %a1 to <28 x float>
  br label %end

cmp.false:
  %a3 = bitcast <28 x i32> %a to <28 x float>
  br label %end

end:
  %phi = phi <28 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x float> %phi
}

define inreg <28 x float> @bitcast_v28i32_to_v28f32_scalar(<28 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v28i32_to_v28f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v28, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB1_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB1_3
; SI-NEXT:  .LBB1_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB1_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v14, v28
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB1_4:
; SI-NEXT:    s_branch .LBB1_2
;
; VI-LABEL: bitcast_v28i32_to_v28f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v28, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB1_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB1_3
; VI-NEXT:  .LBB1_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v28, vcc, 3, v28
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB1_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v14, v28
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB1_4:
; VI-NEXT:    s_branch .LBB1_2
;
; GFX9-LABEL: bitcast_v28i32_to_v28f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v28, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB1_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB1_3
; GFX9-NEXT:  .LBB1_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v28, 3, v28
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB1_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v14, v28
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB1_4:
; GFX9-NEXT:    s_branch .LBB1_2
;
; GFX11-LABEL: bitcast_v28i32_to_v28f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB1_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB1_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB1_3:
; GFX11-NEXT:  .LBB1_4: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <28 x i32> %a, splat (i32 3)
  %a2 = bitcast <28 x i32> %a1 to <28 x float>
  br label %end

cmp.false:
  %a3 = bitcast <28 x i32> %a to <28 x float>
  br label %end

end:
  %phi = phi <28 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x float> %phi
}

define <28 x i32> @bitcast_v28f32_to_v28i32(<28 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v28f32_to_v28i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB2_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; SI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; SI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; SI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; SI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB2_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v28f32_to_v28i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB2_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; VI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; VI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; VI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; VI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; VI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; VI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; VI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB2_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v28f32_to_v28i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB2_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v27, 1.0, v27
; GFX9-NEXT:    v_add_f32_e32 v26, 1.0, v26
; GFX9-NEXT:    v_add_f32_e32 v25, 1.0, v25
; GFX9-NEXT:    v_add_f32_e32 v24, 1.0, v24
; GFX9-NEXT:    v_add_f32_e32 v23, 1.0, v23
; GFX9-NEXT:    v_add_f32_e32 v22, 1.0, v22
; GFX9-NEXT:    v_add_f32_e32 v21, 1.0, v21
; GFX9-NEXT:    v_add_f32_e32 v20, 1.0, v20
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB2_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v28f32_to_v28i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB2_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-NEXT:    v_dual_add_f32 v25, 1.0, v25 :: v_dual_add_f32 v24, 1.0, v24
; GFX11-NEXT:    v_dual_add_f32 v23, 1.0, v23 :: v_dual_add_f32 v22, 1.0, v22
; GFX11-NEXT:    v_dual_add_f32 v21, 1.0, v21 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  .LBB2_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <28 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <28 x float> %a1 to <28 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <28 x float> %a to <28 x i32>
  br label %end

end:
  %phi = phi <28 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x i32> %phi
}

define inreg <28 x i32> @bitcast_v28f32_to_v28i32_scalar(<28 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v28f32_to_v28i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v28, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB3_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB3_3
; SI-NEXT:  .LBB3_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; SI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; SI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; SI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; SI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB3_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v14, v28
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB3_4:
; SI-NEXT:    s_branch .LBB3_2
;
; VI-LABEL: bitcast_v28f32_to_v28i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v28, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB3_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB3_3
; VI-NEXT:  .LBB3_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; VI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; VI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; VI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; VI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; VI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; VI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; VI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB3_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v14, v28
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB3_4:
; VI-NEXT:    s_branch .LBB3_2
;
; GFX9-LABEL: bitcast_v28f32_to_v28i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v28, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB3_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB3_3
; GFX9-NEXT:  .LBB3_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v27, 1.0, v27
; GFX9-NEXT:    v_add_f32_e32 v26, 1.0, v26
; GFX9-NEXT:    v_add_f32_e32 v25, 1.0, v25
; GFX9-NEXT:    v_add_f32_e32 v24, 1.0, v24
; GFX9-NEXT:    v_add_f32_e32 v23, 1.0, v23
; GFX9-NEXT:    v_add_f32_e32 v22, 1.0, v22
; GFX9-NEXT:    v_add_f32_e32 v21, 1.0, v21
; GFX9-NEXT:    v_add_f32_e32 v20, 1.0, v20
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v28, 1.0, v28
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB3_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v14, v28
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB3_4:
; GFX9-NEXT:    s_branch .LBB3_2
;
; GFX11-LABEL: bitcast_v28f32_to_v28i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB3_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB3_3:
; GFX11-NEXT:  .LBB3_4: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-NEXT:    v_dual_add_f32 v25, 1.0, v25 :: v_dual_add_f32 v24, 1.0, v24
; GFX11-NEXT:    v_dual_add_f32 v23, 1.0, v23 :: v_dual_add_f32 v22, 1.0, v22
; GFX11-NEXT:    v_dual_add_f32 v21, 1.0, v21 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <28 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <28 x float> %a1 to <28 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <28 x float> %a to <28 x i32>
  br label %end

end:
  %phi = phi <28 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x i32> %phi
}

define <14 x i64> @bitcast_v28i32_to_v14i64(<28 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v28i32_to_v14i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB4_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB4_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v28i32_to_v14i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB4_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB4_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v28i32_to_v14i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB4_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB4_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v28i32_to_v14i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB4_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB4_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <28 x i32> %a, splat (i32 3)
  %a2 = bitcast <28 x i32> %a1 to <14 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <28 x i32> %a to <14 x i64>
  br label %end

end:
  %phi = phi <14 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <14 x i64> %phi
}

define inreg <14 x i64> @bitcast_v28i32_to_v14i64_scalar(<28 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v28i32_to_v14i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v28, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB5_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB5_3
; SI-NEXT:  .LBB5_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB5_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v14, v28
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB5_4:
; SI-NEXT:    s_branch .LBB5_2
;
; VI-LABEL: bitcast_v28i32_to_v14i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v28, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB5_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB5_3
; VI-NEXT:  .LBB5_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v28, vcc, 3, v28
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB5_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v14, v28
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB5_4:
; VI-NEXT:    s_branch .LBB5_2
;
; GFX9-LABEL: bitcast_v28i32_to_v14i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v28, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB5_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB5_3
; GFX9-NEXT:  .LBB5_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v28, 3, v28
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB5_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v14, v28
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB5_4:
; GFX9-NEXT:    s_branch .LBB5_2
;
; GFX11-LABEL: bitcast_v28i32_to_v14i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB5_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB5_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB5_3:
; GFX11-NEXT:  .LBB5_4: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <28 x i32> %a, splat (i32 3)
  %a2 = bitcast <28 x i32> %a1 to <14 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <28 x i32> %a to <14 x i64>
  br label %end

end:
  %phi = phi <14 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <14 x i64> %phi
}

define <28 x i32> @bitcast_v14i64_to_v28i32(<14 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v14i64_to_v28i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB6_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_addc_u32_e32 v27, vcc, 0, v27, vcc
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_addc_u32_e32 v25, vcc, 0, v25, vcc
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_addc_u32_e32 v23, vcc, 0, v23, vcc
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v21, vcc
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  .LBB6_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v14i64_to_v28i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB6_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_addc_u32_e32 v27, vcc, 0, v27, vcc
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_addc_u32_e32 v25, vcc, 0, v25, vcc
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_addc_u32_e32 v23, vcc, 0, v23, vcc
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v21, vcc
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  .LBB6_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v14i64_to_v28i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB6_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v26, vcc, 3, v26
; GFX9-NEXT:    v_addc_co_u32_e32 v27, vcc, 0, v27, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v24, vcc, 3, v24
; GFX9-NEXT:    v_addc_co_u32_e32 v25, vcc, 0, v25, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v22, vcc, 3, v22
; GFX9-NEXT:    v_addc_co_u32_e32 v23, vcc, 0, v23, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v20, vcc, 3, v20
; GFX9-NEXT:    v_addc_co_u32_e32 v21, vcc, 0, v21, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, 3, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, 3, v16
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  .LBB6_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v14i64_to_v28i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB6_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v26, vcc_lo, v26, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v27, null, 0, v27, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v24, vcc_lo, v24, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v25, null, 0, v25, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v22, vcc_lo, v22, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v23, null, 0, v23, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v20, vcc_lo, v20, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v21, null, 0, v21, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  .LBB6_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <14 x i64> %a, splat (i64 3)
  %a2 = bitcast <14 x i64> %a1 to <28 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <14 x i64> %a to <28 x i32>
  br label %end

end:
  %phi = phi <28 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x i32> %phi
}

define inreg <28 x i32> @bitcast_v14i64_to_v28i32_scalar(<14 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v14i64_to_v28i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v28, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB7_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB7_3
; SI-NEXT:  .LBB7_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_addc_u32_e32 v27, vcc, 0, v27, vcc
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_addc_u32_e32 v25, vcc, 0, v25, vcc
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_addc_u32_e32 v23, vcc, 0, v23, vcc
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v21, vcc
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  .LBB7_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v14, v28
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB7_4:
; SI-NEXT:    s_branch .LBB7_2
;
; VI-LABEL: bitcast_v14i64_to_v28i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v28, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB7_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB7_3
; VI-NEXT:  .LBB7_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_addc_u32_e32 v27, vcc, 0, v27, vcc
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_addc_u32_e32 v25, vcc, 0, v25, vcc
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_addc_u32_e32 v23, vcc, 0, v23, vcc
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v21, vcc
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; VI-NEXT:    v_add_u32_e32 v28, vcc, 3, v28
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  .LBB7_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v14, v28
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB7_4:
; VI-NEXT:    s_branch .LBB7_2
;
; GFX9-LABEL: bitcast_v14i64_to_v28i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v28, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB7_3
; GFX9-NEXT:  .LBB7_2: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v26, vcc, 3, v26
; GFX9-NEXT:    v_addc_co_u32_e32 v27, vcc, 0, v27, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v24, vcc, 3, v24
; GFX9-NEXT:    v_addc_co_u32_e32 v25, vcc, 0, v25, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v22, vcc, 3, v22
; GFX9-NEXT:    v_addc_co_u32_e32 v23, vcc, 0, v23, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v20, vcc, 3, v20
; GFX9-NEXT:    v_addc_co_u32_e32 v21, vcc, 0, v21, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, 3, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, 3, v16
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v28, vcc, 3, v28
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  .LBB7_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v14, v28
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB7_4:
; GFX9-NEXT:    s_branch .LBB7_2
;
; GFX11-LABEL: bitcast_v14i64_to_v28i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB7_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB7_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB7_3:
; GFX11-NEXT:  .LBB7_4: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v26, vcc_lo, v26, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v27, null, 0, v27, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v24, vcc_lo, v24, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v25, null, 0, v25, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v22, vcc_lo, v22, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v23, null, 0, v23, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v20, vcc_lo, v20, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v21, null, 0, v21, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <14 x i64> %a, splat (i64 3)
  %a2 = bitcast <14 x i64> %a1 to <28 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <14 x i64> %a to <28 x i32>
  br label %end

end:
  %phi = phi <28 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x i32> %phi
}

define <14 x double> @bitcast_v28i32_to_v14f64(<28 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v28i32_to_v14f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB8_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB8_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v28i32_to_v14f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB8_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB8_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v28i32_to_v14f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB8_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB8_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v28i32_to_v14f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB8_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB8_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <28 x i32> %a, splat (i32 3)
  %a2 = bitcast <28 x i32> %a1 to <14 x double>
  br label %end

cmp.false:
  %a3 = bitcast <28 x i32> %a to <14 x double>
  br label %end

end:
  %phi = phi <14 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <14 x double> %phi
}

define inreg <14 x double> @bitcast_v28i32_to_v14f64_scalar(<28 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v28i32_to_v14f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v28, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB9_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB9_3
; SI-NEXT:  .LBB9_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB9_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v14, v28
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB9_4:
; SI-NEXT:    s_branch .LBB9_2
;
; VI-LABEL: bitcast_v28i32_to_v14f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v28, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB9_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB9_3
; VI-NEXT:  .LBB9_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v28, vcc, 3, v28
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB9_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v14, v28
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB9_4:
; VI-NEXT:    s_branch .LBB9_2
;
; GFX9-LABEL: bitcast_v28i32_to_v14f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v28, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB9_3
; GFX9-NEXT:  .LBB9_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v28, 3, v28
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB9_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v14, v28
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB9_4:
; GFX9-NEXT:    s_branch .LBB9_2
;
; GFX11-LABEL: bitcast_v28i32_to_v14f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB9_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB9_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB9_3:
; GFX11-NEXT:  .LBB9_4: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <28 x i32> %a, splat (i32 3)
  %a2 = bitcast <28 x i32> %a1 to <14 x double>
  br label %end

cmp.false:
  %a3 = bitcast <28 x i32> %a to <14 x double>
  br label %end

end:
  %phi = phi <14 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <14 x double> %phi
}

define <28 x i32> @bitcast_v14f64_to_v28i32(<14 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v14f64_to_v28i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB10_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; SI-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; SI-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; SI-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; SI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; SI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  .LBB10_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v14f64_to_v28i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB10_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; VI-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; VI-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; VI-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; VI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; VI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; VI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB10_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v14f64_to_v28i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB10_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; GFX9-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; GFX9-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; GFX9-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX9-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB10_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v14f64_to_v28i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB10_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; GFX11-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; GFX11-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; GFX11-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; GFX11-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX11-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX11-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB10_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <14 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <14 x double> %a1 to <28 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <14 x double> %a to <28 x i32>
  br label %end

end:
  %phi = phi <28 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x i32> %phi
}

define inreg <28 x i32> @bitcast_v14f64_to_v28i32_scalar(<14 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v14f64_to_v28i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v29, v1
; SI-NEXT:    v_mov_b32_e32 v28, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB11_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB11_3
; SI-NEXT:  .LBB11_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; SI-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; SI-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; SI-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; SI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; SI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; SI-NEXT:    v_add_f64 v[28:29], v[28:29], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  .LBB11_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v14, v28
; SI-NEXT:    v_mov_b32_e32 v15, v29
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB11_4:
; SI-NEXT:    s_branch .LBB11_2
;
; VI-LABEL: bitcast_v14f64_to_v28i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v29, v1
; VI-NEXT:    v_mov_b32_e32 v28, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB11_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB11_3
; VI-NEXT:  .LBB11_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; VI-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; VI-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; VI-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; VI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; VI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; VI-NEXT:    v_add_f64 v[28:29], v[28:29], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB11_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v14, v28
; VI-NEXT:    v_mov_b32_e32 v15, v29
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB11_4:
; VI-NEXT:    s_branch .LBB11_2
;
; GFX9-LABEL: bitcast_v14f64_to_v28i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v29, v1
; GFX9-NEXT:    v_mov_b32_e32 v28, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB11_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB11_3
; GFX9-NEXT:  .LBB11_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; GFX9-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; GFX9-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; GFX9-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX9-NEXT:    v_add_f64 v[28:29], v[28:29], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB11_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v14, v28
; GFX9-NEXT:    v_mov_b32_e32 v15, v29
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB11_4:
; GFX9-NEXT:    s_branch .LBB11_2
;
; GFX11-LABEL: bitcast_v14f64_to_v28i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB11_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB11_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB11_3:
; GFX11-NEXT:  .LBB11_4: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; GFX11-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; GFX11-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; GFX11-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; GFX11-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX11-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX11-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <14 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <14 x double> %a1 to <28 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <14 x double> %a to <28 x i32>
  br label %end

end:
  %phi = phi <28 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x i32> %phi
}

define <56 x i16> @bitcast_v28i32_to_v56i16(<28 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v28i32_to_v56i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v29
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB12_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v29, v28, v27, 16
; SI-NEXT:    v_alignbit_b32 v30, v26, v25, 16
; SI-NEXT:    v_alignbit_b32 v31, v24, v23, 16
; SI-NEXT:    v_alignbit_b32 v32, v22, v21, 16
; SI-NEXT:    v_alignbit_b32 v33, v20, v19, 16
; SI-NEXT:    v_alignbit_b32 v34, v18, v17, 16
; SI-NEXT:    v_alignbit_b32 v37, v16, v15, 16
; SI-NEXT:    v_alignbit_b32 v39, v14, v13, 16
; SI-NEXT:    v_alignbit_b32 v49, v12, v11, 16
; SI-NEXT:    v_alignbit_b32 v51, v10, v9, 16
; SI-NEXT:    v_alignbit_b32 v54, v8, v7, 16
; SI-NEXT:    v_alignbit_b32 v40, v6, v5, 16
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_alignbit_b32 v42, v4, v3, 16
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_alignbit_b32 v44, v2, v1, 16
; SI-NEXT:    v_lshrrev_b32_e32 v35, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v50, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v52, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v55, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v41, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v43, 16, v10
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_lshrrev_b32_e32 v45, 16, v8
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_lshrrev_b32_e32 v46, 16, v6
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_lshrrev_b32_e32 v47, 16, v4
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v56, 16, v2
; SI-NEXT:  .LBB12_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB12_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_alignbit_b32 v29, v28, v27, 16
; SI-NEXT:    v_alignbit_b32 v30, v26, v25, 16
; SI-NEXT:    v_alignbit_b32 v31, v24, v23, 16
; SI-NEXT:    v_alignbit_b32 v32, v22, v21, 16
; SI-NEXT:    v_alignbit_b32 v33, v20, v19, 16
; SI-NEXT:    v_alignbit_b32 v34, v18, v17, 16
; SI-NEXT:    v_alignbit_b32 v37, v16, v15, 16
; SI-NEXT:    v_alignbit_b32 v39, v14, v13, 16
; SI-NEXT:    v_alignbit_b32 v49, v12, v11, 16
; SI-NEXT:    v_alignbit_b32 v51, v10, v9, 16
; SI-NEXT:    v_alignbit_b32 v54, v8, v7, 16
; SI-NEXT:    v_alignbit_b32 v40, v6, v5, 16
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_alignbit_b32 v42, v4, v3, 16
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_alignbit_b32 v44, v2, v1, 16
; SI-NEXT:    v_lshrrev_b32_e32 v35, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v50, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v52, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v55, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v41, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v43, 16, v10
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_lshrrev_b32_e32 v45, 16, v8
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_lshrrev_b32_e32 v46, 16, v6
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_lshrrev_b32_e32 v47, 16, v4
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v56, 16, v2
; SI-NEXT:  .LBB12_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v44, 16, v44
; SI-NEXT:    v_or_b32_e32 v1, v1, v44
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v56
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 4, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v42
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 8, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v47
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 12, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v40
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 16, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v46
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 20, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v7
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v54
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 24, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v8
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v45
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 28, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v9
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v51
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 32, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v10
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v43
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 36, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v11
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v49
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 40, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v12
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v41
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v13
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v39
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v14
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v55
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 52, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v15
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v37
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 56, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v16
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v53
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 60, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v17
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v34
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 64, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v18
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v52
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v19
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v33
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v20
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v50
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x4c, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v21
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v32
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x50, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v22
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v48
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x54, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v23
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v31
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x58, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v24
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v38
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x5c, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v25
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v30
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x60, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v26
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v36
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x64, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v27
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v29
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x68, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v28
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v35
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x6c, v0
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v28i32_to_v56i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr47
; VI-NEXT:    ; implicit-def: $vgpr46
; VI-NEXT:    ; implicit-def: $vgpr45
; VI-NEXT:    ; implicit-def: $vgpr44
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB12_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; VI-NEXT:  .LBB12_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB12_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; VI-NEXT:  .LBB12_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_lshlrev_b32_e32 v47, 16, v47
; VI-NEXT:    v_lshlrev_b32_e32 v46, 16, v46
; VI-NEXT:    v_lshlrev_b32_e32 v45, 16, v45
; VI-NEXT:    v_lshlrev_b32_e32 v44, 16, v44
; VI-NEXT:    v_lshlrev_b32_e32 v43, 16, v43
; VI-NEXT:    v_lshlrev_b32_e32 v42, 16, v42
; VI-NEXT:    v_lshlrev_b32_e32 v41, 16, v41
; VI-NEXT:    v_lshlrev_b32_e32 v40, 16, v40
; VI-NEXT:    v_or_b32_sdwa v0, v0, v47 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v46 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v45 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v44 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v43 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v42 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v41 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v40 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; VI-NEXT:    v_lshlrev_b32_e32 v55, 16, v55
; VI-NEXT:    v_lshlrev_b32_e32 v54, 16, v54
; VI-NEXT:    v_lshlrev_b32_e32 v53, 16, v53
; VI-NEXT:    v_lshlrev_b32_e32 v52, 16, v52
; VI-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; VI-NEXT:    v_lshlrev_b32_e32 v50, 16, v50
; VI-NEXT:    v_lshlrev_b32_e32 v49, 16, v49
; VI-NEXT:    v_lshlrev_b32_e32 v48, 16, v48
; VI-NEXT:    v_lshlrev_b32_e32 v39, 16, v39
; VI-NEXT:    v_lshlrev_b32_e32 v38, 16, v38
; VI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; VI-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; VI-NEXT:    v_lshlrev_b32_e32 v35, 16, v35
; VI-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; VI-NEXT:    v_lshlrev_b32_e32 v33, 16, v33
; VI-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; VI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; VI-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; VI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; VI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; VI-NEXT:    v_or_b32_sdwa v8, v8, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v9, v54 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v10, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v11, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v12, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v13, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v14, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v15, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v16, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v17, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v18, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v19, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v20, v20, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v21, v21, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v22, v22, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v23, v23, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v24, v24, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v25, v25, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v26, v26, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v27, v27, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v28i32_to_v56i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB12_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; GFX9-NEXT:  .LBB12_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB12_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; GFX9-NEXT:  .LBB12_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v47, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v46, v1, s4
; GFX9-NEXT:    v_perm_b32 v2, v45, v2, s4
; GFX9-NEXT:    v_perm_b32 v3, v44, v3, s4
; GFX9-NEXT:    v_perm_b32 v4, v43, v4, s4
; GFX9-NEXT:    v_perm_b32 v5, v42, v5, s4
; GFX9-NEXT:    v_perm_b32 v6, v41, v6, s4
; GFX9-NEXT:    v_perm_b32 v7, v40, v7, s4
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    v_perm_b32 v8, v55, v8, s4
; GFX9-NEXT:    v_perm_b32 v9, v54, v9, s4
; GFX9-NEXT:    v_perm_b32 v10, v53, v10, s4
; GFX9-NEXT:    v_perm_b32 v11, v52, v11, s4
; GFX9-NEXT:    v_perm_b32 v12, v51, v12, s4
; GFX9-NEXT:    v_perm_b32 v13, v50, v13, s4
; GFX9-NEXT:    v_perm_b32 v14, v49, v14, s4
; GFX9-NEXT:    v_perm_b32 v15, v48, v15, s4
; GFX9-NEXT:    v_perm_b32 v16, v39, v16, s4
; GFX9-NEXT:    v_perm_b32 v17, v38, v17, s4
; GFX9-NEXT:    v_perm_b32 v18, v37, v18, s4
; GFX9-NEXT:    v_perm_b32 v19, v36, v19, s4
; GFX9-NEXT:    v_perm_b32 v20, v35, v20, s4
; GFX9-NEXT:    v_perm_b32 v21, v34, v21, s4
; GFX9-NEXT:    v_perm_b32 v22, v33, v22, s4
; GFX9-NEXT:    v_perm_b32 v23, v32, v23, s4
; GFX9-NEXT:    v_perm_b32 v24, v31, v24, s4
; GFX9-NEXT:    v_perm_b32 v25, v30, v25, s4
; GFX9-NEXT:    v_perm_b32 v26, v29, v26, s4
; GFX9-NEXT:    v_perm_b32 v27, v28, v27, s4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v28i32_to_v56i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB12_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-TRUE16-NEXT:  .LBB12_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v28i32_to_v56i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr71
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr70
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr69
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr68
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr67
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr66
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr65
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr64
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr55
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr54
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr53
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr52
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr51
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr50
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr49
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr48
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB12_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v65, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v66, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v0
; GFX11-FAKE16-NEXT:  .LBB12_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB12_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v65, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v66, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v0
; GFX11-FAKE16-NEXT:  .LBB12_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v71, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v70, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v69, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v68, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v67, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v66, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v65, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v64, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v55, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v54, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v53, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v52, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v51, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v50, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v49, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v48, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v39, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v38, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v37, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v36, v19, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v20, v35, v20, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v21, v34, v21, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v22, v33, v22, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v23, v32, v23, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v24, v31, v24, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v25, v30, v25, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v26, v29, v26, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v27, v28, v27, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <28 x i32> %a, splat (i32 3)
  %a2 = bitcast <28 x i32> %a1 to <56 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <28 x i32> %a to <56 x i16>
  br label %end

end:
  %phi = phi <56 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <56 x i16> %phi
}

define inreg <56 x i16> @bitcast_v28i32_to_v56i16_scalar(<28 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v28i32_to_v56i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v15
; SI-NEXT:    v_readfirstlane_b32 s43, v1
; SI-NEXT:    v_readfirstlane_b32 s42, v2
; SI-NEXT:    v_readfirstlane_b32 s41, v3
; SI-NEXT:    v_readfirstlane_b32 s40, v4
; SI-NEXT:    v_readfirstlane_b32 s15, v5
; SI-NEXT:    v_readfirstlane_b32 s14, v6
; SI-NEXT:    v_readfirstlane_b32 s13, v7
; SI-NEXT:    v_readfirstlane_b32 s12, v8
; SI-NEXT:    v_readfirstlane_b32 s11, v9
; SI-NEXT:    v_readfirstlane_b32 s10, v10
; SI-NEXT:    v_readfirstlane_b32 s9, v11
; SI-NEXT:    v_readfirstlane_b32 s8, v12
; SI-NEXT:    v_readfirstlane_b32 s7, v13
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_readfirstlane_b32 s6, v14
; SI-NEXT:    s_cbranch_scc0 .LBB13_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    v_mov_b32_e32 v2, s9
; SI-NEXT:    v_mov_b32_e32 v3, s11
; SI-NEXT:    v_mov_b32_e32 v4, s13
; SI-NEXT:    v_mov_b32_e32 v5, s15
; SI-NEXT:    v_mov_b32_e32 v6, s41
; SI-NEXT:    v_mov_b32_e32 v7, s43
; SI-NEXT:    v_mov_b32_e32 v8, s28
; SI-NEXT:    v_mov_b32_e32 v9, s26
; SI-NEXT:    v_mov_b32_e32 v10, s24
; SI-NEXT:    v_mov_b32_e32 v11, s22
; SI-NEXT:    v_mov_b32_e32 v12, s20
; SI-NEXT:    v_mov_b32_e32 v13, s18
; SI-NEXT:    v_mov_b32_e32 v14, s16
; SI-NEXT:    v_alignbit_b32 v1, s6, v1, 16
; SI-NEXT:    v_alignbit_b32 v2, s8, v2, 16
; SI-NEXT:    v_alignbit_b32 v3, s10, v3, 16
; SI-NEXT:    v_alignbit_b32 v4, s12, v4, 16
; SI-NEXT:    v_alignbit_b32 v5, s14, v5, 16
; SI-NEXT:    v_alignbit_b32 v6, s40, v6, 16
; SI-NEXT:    v_alignbit_b32 v7, s42, v7, 16
; SI-NEXT:    v_alignbit_b32 v8, s29, v8, 16
; SI-NEXT:    v_alignbit_b32 v9, s27, v9, 16
; SI-NEXT:    v_alignbit_b32 v10, s25, v10, 16
; SI-NEXT:    v_alignbit_b32 v11, s23, v11, 16
; SI-NEXT:    v_alignbit_b32 v12, s21, v12, 16
; SI-NEXT:    v_alignbit_b32 v13, s19, v13, 16
; SI-NEXT:    v_alignbit_b32 v14, s17, v14, 16
; SI-NEXT:    s_lshr_b32 s44, s6, 16
; SI-NEXT:    s_lshr_b32 s45, s8, 16
; SI-NEXT:    s_lshr_b32 s46, s10, 16
; SI-NEXT:    s_lshr_b32 s47, s12, 16
; SI-NEXT:    s_lshr_b32 s56, s14, 16
; SI-NEXT:    s_lshr_b32 s57, s40, 16
; SI-NEXT:    s_lshr_b32 s58, s42, 16
; SI-NEXT:    s_lshr_b32 s59, s29, 16
; SI-NEXT:    s_lshr_b32 s60, s27, 16
; SI-NEXT:    s_lshr_b32 s61, s25, 16
; SI-NEXT:    s_lshr_b32 s62, s23, 16
; SI-NEXT:    s_lshr_b32 s63, s21, 16
; SI-NEXT:    s_lshr_b32 s72, s19, 16
; SI-NEXT:    s_lshr_b32 s73, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB13_3
; SI-NEXT:  .LBB13_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_add_i32 s43, s43, 3
; SI-NEXT:    s_add_i32 s41, s41, 3
; SI-NEXT:    s_add_i32 s15, s15, 3
; SI-NEXT:    s_add_i32 s13, s13, 3
; SI-NEXT:    s_add_i32 s11, s11, 3
; SI-NEXT:    s_add_i32 s9, s9, 3
; SI-NEXT:    s_add_i32 s7, s7, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    s_add_i32 s25, s25, 3
; SI-NEXT:    s_add_i32 s27, s27, 3
; SI-NEXT:    s_add_i32 s29, s29, 3
; SI-NEXT:    s_add_i32 s42, s42, 3
; SI-NEXT:    s_add_i32 s40, s40, 3
; SI-NEXT:    s_add_i32 s14, s14, 3
; SI-NEXT:    s_add_i32 s12, s12, 3
; SI-NEXT:    s_add_i32 s10, s10, 3
; SI-NEXT:    s_add_i32 s8, s8, 3
; SI-NEXT:    s_add_i32 s6, s6, 3
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    v_mov_b32_e32 v2, s9
; SI-NEXT:    v_mov_b32_e32 v3, s11
; SI-NEXT:    v_mov_b32_e32 v4, s13
; SI-NEXT:    v_mov_b32_e32 v5, s15
; SI-NEXT:    v_mov_b32_e32 v6, s41
; SI-NEXT:    v_mov_b32_e32 v7, s43
; SI-NEXT:    v_mov_b32_e32 v8, s28
; SI-NEXT:    v_mov_b32_e32 v9, s26
; SI-NEXT:    v_mov_b32_e32 v10, s24
; SI-NEXT:    v_mov_b32_e32 v11, s22
; SI-NEXT:    v_mov_b32_e32 v12, s20
; SI-NEXT:    v_mov_b32_e32 v13, s18
; SI-NEXT:    v_mov_b32_e32 v14, s16
; SI-NEXT:    v_alignbit_b32 v1, s6, v1, 16
; SI-NEXT:    v_alignbit_b32 v2, s8, v2, 16
; SI-NEXT:    v_alignbit_b32 v3, s10, v3, 16
; SI-NEXT:    v_alignbit_b32 v4, s12, v4, 16
; SI-NEXT:    v_alignbit_b32 v5, s14, v5, 16
; SI-NEXT:    v_alignbit_b32 v6, s40, v6, 16
; SI-NEXT:    v_alignbit_b32 v7, s42, v7, 16
; SI-NEXT:    v_alignbit_b32 v8, s29, v8, 16
; SI-NEXT:    v_alignbit_b32 v9, s27, v9, 16
; SI-NEXT:    v_alignbit_b32 v10, s25, v10, 16
; SI-NEXT:    v_alignbit_b32 v11, s23, v11, 16
; SI-NEXT:    v_alignbit_b32 v12, s21, v12, 16
; SI-NEXT:    v_alignbit_b32 v13, s19, v13, 16
; SI-NEXT:    v_alignbit_b32 v14, s17, v14, 16
; SI-NEXT:    s_lshr_b32 s44, s6, 16
; SI-NEXT:    s_lshr_b32 s45, s8, 16
; SI-NEXT:    s_lshr_b32 s46, s10, 16
; SI-NEXT:    s_lshr_b32 s47, s12, 16
; SI-NEXT:    s_lshr_b32 s56, s14, 16
; SI-NEXT:    s_lshr_b32 s57, s40, 16
; SI-NEXT:    s_lshr_b32 s58, s42, 16
; SI-NEXT:    s_lshr_b32 s59, s29, 16
; SI-NEXT:    s_lshr_b32 s60, s27, 16
; SI-NEXT:    s_lshr_b32 s61, s25, 16
; SI-NEXT:    s_lshr_b32 s62, s23, 16
; SI-NEXT:    s_lshr_b32 s63, s21, 16
; SI-NEXT:    s_lshr_b32 s72, s19, 16
; SI-NEXT:    s_lshr_b32 s73, s17, 16
; SI-NEXT:  .LBB13_3: ; %end
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, s4, v14
; SI-NEXT:    s_and_b32 s4, s17, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s73, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_mov_b32_e32 v15, s4
; SI-NEXT:    s_and_b32 s4, s18, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    buffer_store_dword v14, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v14, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v13, s4, v13
; SI-NEXT:    s_and_b32 s4, s19, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s72, 16
; SI-NEXT:    buffer_store_dword v15, v14, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v14, vcc, 8, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v13, v14, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v14, s4
; SI-NEXT:    s_and_b32 s4, s20, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v13, vcc, 12, v0
; SI-NEXT:    v_or_b32_e32 v12, s4, v12
; SI-NEXT:    s_and_b32 s4, s21, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s63, 16
; SI-NEXT:    buffer_store_dword v14, v13, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v13, vcc, 16, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v12, v13, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v13, s4
; SI-NEXT:    s_and_b32 s4, s22, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v12, vcc, 20, v0
; SI-NEXT:    v_or_b32_e32 v11, s4, v11
; SI-NEXT:    s_and_b32 s4, s23, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s62, 16
; SI-NEXT:    buffer_store_dword v13, v12, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v12, vcc, 24, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v11, v12, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v12, s4
; SI-NEXT:    s_and_b32 s4, s24, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v11, vcc, 28, v0
; SI-NEXT:    v_or_b32_e32 v10, s4, v10
; SI-NEXT:    s_and_b32 s4, s25, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s61, 16
; SI-NEXT:    buffer_store_dword v12, v11, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v11, vcc, 32, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v10, v11, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v11, s4
; SI-NEXT:    s_and_b32 s4, s26, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v10, vcc, 36, v0
; SI-NEXT:    v_or_b32_e32 v9, s4, v9
; SI-NEXT:    s_and_b32 s4, s27, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s60, 16
; SI-NEXT:    buffer_store_dword v11, v10, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v10, vcc, 40, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v9, v10, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v10, s4
; SI-NEXT:    s_and_b32 s4, s28, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v9, vcc, 44, v0
; SI-NEXT:    v_or_b32_e32 v8, s4, v8
; SI-NEXT:    s_and_b32 s4, s29, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s59, 16
; SI-NEXT:    buffer_store_dword v10, v9, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v9, vcc, 48, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v8, v9, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v9, s4
; SI-NEXT:    s_and_b32 s4, s43, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v8, vcc, 52, v0
; SI-NEXT:    v_or_b32_e32 v7, s4, v7
; SI-NEXT:    s_and_b32 s4, s42, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s58, 16
; SI-NEXT:    buffer_store_dword v9, v8, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v8, vcc, 56, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v7, v8, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v8, s4
; SI-NEXT:    s_and_b32 s4, s41, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v7, vcc, 60, v0
; SI-NEXT:    v_or_b32_e32 v6, s4, v6
; SI-NEXT:    s_and_b32 s4, s40, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s57, 16
; SI-NEXT:    buffer_store_dword v8, v7, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v7, vcc, 64, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v6, v7, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v7, s4
; SI-NEXT:    s_and_b32 s4, s15, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x44, v0
; SI-NEXT:    v_or_b32_e32 v5, s4, v5
; SI-NEXT:    s_and_b32 s4, s14, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s56, 16
; SI-NEXT:    buffer_store_dword v7, v6, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x48, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v5, v6, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v6, s4
; SI-NEXT:    s_and_b32 s4, s13, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x4c, v0
; SI-NEXT:    v_or_b32_e32 v4, s4, v4
; SI-NEXT:    s_and_b32 s4, s12, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s47, 16
; SI-NEXT:    buffer_store_dword v6, v5, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x50, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v4, v5, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v5, s4
; SI-NEXT:    s_and_b32 s4, s11, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x54, v0
; SI-NEXT:    v_or_b32_e32 v3, s4, v3
; SI-NEXT:    s_and_b32 s4, s10, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s46, 16
; SI-NEXT:    buffer_store_dword v5, v4, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x58, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v3, v4, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v4, s4
; SI-NEXT:    s_and_b32 s4, s9, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x5c, v0
; SI-NEXT:    v_or_b32_e32 v2, s4, v2
; SI-NEXT:    s_and_b32 s4, s8, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s45, 16
; SI-NEXT:    buffer_store_dword v4, v3, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x60, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v2, v3, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v3, s4
; SI-NEXT:    s_and_b32 s4, s7, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x64, v0
; SI-NEXT:    v_or_b32_e32 v1, s4, v1
; SI-NEXT:    s_and_b32 s4, s6, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s44, 16
; SI-NEXT:    buffer_store_dword v3, v2, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x68, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x6c, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s4
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB13_4:
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $sgpr73
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $sgpr72
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $sgpr63
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $sgpr62
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $sgpr61
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $sgpr60
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $sgpr59
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $sgpr58
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $sgpr57
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $sgpr56
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $sgpr47
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $sgpr46
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $sgpr45
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr44
; SI-NEXT:    s_branch .LBB13_2
;
; VI-LABEL: bitcast_v28i32_to_v56i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; VI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    s_mov_b64 exec, s[4:5]
; VI-NEXT:    v_writelane_b32 v28, s30, 0
; VI-NEXT:    v_writelane_b32 v28, s31, 1
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_writelane_b32 v28, s34, 2
; VI-NEXT:    v_readfirstlane_b32 s43, v0
; VI-NEXT:    v_readfirstlane_b32 s42, v1
; VI-NEXT:    v_readfirstlane_b32 s41, v2
; VI-NEXT:    v_readfirstlane_b32 s40, v3
; VI-NEXT:    v_readfirstlane_b32 s15, v4
; VI-NEXT:    v_readfirstlane_b32 s14, v5
; VI-NEXT:    v_readfirstlane_b32 s13, v6
; VI-NEXT:    v_readfirstlane_b32 s12, v7
; VI-NEXT:    v_readfirstlane_b32 s11, v8
; VI-NEXT:    v_readfirstlane_b32 s10, v9
; VI-NEXT:    v_readfirstlane_b32 s9, v10
; VI-NEXT:    v_readfirstlane_b32 s8, v11
; VI-NEXT:    v_readfirstlane_b32 s6, v12
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_readfirstlane_b32 s7, v13
; VI-NEXT:    v_writelane_b32 v28, s35, 3
; VI-NEXT:    s_cbranch_scc0 .LBB13_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s44, s7, 16
; VI-NEXT:    s_lshr_b32 s45, s6, 16
; VI-NEXT:    s_lshr_b32 s46, s8, 16
; VI-NEXT:    s_lshr_b32 s47, s9, 16
; VI-NEXT:    s_lshr_b32 s56, s10, 16
; VI-NEXT:    s_lshr_b32 s57, s11, 16
; VI-NEXT:    s_lshr_b32 s58, s12, 16
; VI-NEXT:    s_lshr_b32 s59, s13, 16
; VI-NEXT:    s_lshr_b32 s60, s14, 16
; VI-NEXT:    s_lshr_b32 s61, s15, 16
; VI-NEXT:    s_lshr_b32 s62, s40, 16
; VI-NEXT:    s_lshr_b32 s63, s41, 16
; VI-NEXT:    s_lshr_b32 s72, s42, 16
; VI-NEXT:    s_lshr_b32 s73, s43, 16
; VI-NEXT:    s_lshr_b32 s74, s29, 16
; VI-NEXT:    s_lshr_b32 s75, s28, 16
; VI-NEXT:    s_lshr_b32 s76, s27, 16
; VI-NEXT:    s_lshr_b32 s77, s26, 16
; VI-NEXT:    s_lshr_b32 s78, s25, 16
; VI-NEXT:    s_lshr_b32 s79, s24, 16
; VI-NEXT:    s_lshr_b32 s88, s23, 16
; VI-NEXT:    s_lshr_b32 s89, s22, 16
; VI-NEXT:    s_lshr_b32 s90, s21, 16
; VI-NEXT:    s_lshr_b32 s91, s20, 16
; VI-NEXT:    s_lshr_b32 s30, s19, 16
; VI-NEXT:    s_lshr_b32 s31, s18, 16
; VI-NEXT:    s_lshr_b32 s34, s17, 16
; VI-NEXT:    s_lshr_b32 s35, s16, 16
; VI-NEXT:    s_cbranch_execnz .LBB13_3
; VI-NEXT:  .LBB13_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s7, s7, 3
; VI-NEXT:    s_add_i32 s6, s6, 3
; VI-NEXT:    s_add_i32 s8, s8, 3
; VI-NEXT:    s_add_i32 s9, s9, 3
; VI-NEXT:    s_add_i32 s10, s10, 3
; VI-NEXT:    s_add_i32 s11, s11, 3
; VI-NEXT:    s_add_i32 s12, s12, 3
; VI-NEXT:    s_add_i32 s13, s13, 3
; VI-NEXT:    s_add_i32 s14, s14, 3
; VI-NEXT:    s_add_i32 s15, s15, 3
; VI-NEXT:    s_add_i32 s40, s40, 3
; VI-NEXT:    s_add_i32 s41, s41, 3
; VI-NEXT:    s_add_i32 s42, s42, 3
; VI-NEXT:    s_add_i32 s43, s43, 3
; VI-NEXT:    s_add_i32 s29, s29, 3
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    s_add_i32 s27, s27, 3
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_add_i32 s25, s25, 3
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_lshr_b32 s44, s7, 16
; VI-NEXT:    s_lshr_b32 s45, s6, 16
; VI-NEXT:    s_lshr_b32 s46, s8, 16
; VI-NEXT:    s_lshr_b32 s47, s9, 16
; VI-NEXT:    s_lshr_b32 s56, s10, 16
; VI-NEXT:    s_lshr_b32 s57, s11, 16
; VI-NEXT:    s_lshr_b32 s58, s12, 16
; VI-NEXT:    s_lshr_b32 s59, s13, 16
; VI-NEXT:    s_lshr_b32 s60, s14, 16
; VI-NEXT:    s_lshr_b32 s61, s15, 16
; VI-NEXT:    s_lshr_b32 s62, s40, 16
; VI-NEXT:    s_lshr_b32 s63, s41, 16
; VI-NEXT:    s_lshr_b32 s72, s42, 16
; VI-NEXT:    s_lshr_b32 s73, s43, 16
; VI-NEXT:    s_lshr_b32 s74, s29, 16
; VI-NEXT:    s_lshr_b32 s75, s28, 16
; VI-NEXT:    s_lshr_b32 s76, s27, 16
; VI-NEXT:    s_lshr_b32 s77, s26, 16
; VI-NEXT:    s_lshr_b32 s78, s25, 16
; VI-NEXT:    s_lshr_b32 s79, s24, 16
; VI-NEXT:    s_lshr_b32 s88, s23, 16
; VI-NEXT:    s_lshr_b32 s89, s22, 16
; VI-NEXT:    s_lshr_b32 s90, s21, 16
; VI-NEXT:    s_lshr_b32 s91, s20, 16
; VI-NEXT:    s_lshr_b32 s30, s19, 16
; VI-NEXT:    s_lshr_b32 s31, s18, 16
; VI-NEXT:    s_lshr_b32 s34, s17, 16
; VI-NEXT:    s_lshr_b32 s35, s16, 16
; VI-NEXT:  .LBB13_3: ; %end
; VI-NEXT:    s_and_b32 s4, 0xffff, s16
; VI-NEXT:    s_lshl_b32 s5, s35, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, 0xffff, s17
; VI-NEXT:    s_lshl_b32 s16, s34, 16
; VI-NEXT:    s_or_b32 s5, s5, s16
; VI-NEXT:    s_and_b32 s16, 0xffff, s18
; VI-NEXT:    s_lshl_b32 s17, s31, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    s_and_b32 s17, 0xffff, s19
; VI-NEXT:    s_lshl_b32 s18, s30, 16
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s18, 0xffff, s20
; VI-NEXT:    s_lshl_b32 s19, s91, 16
; VI-NEXT:    s_or_b32 s18, s18, s19
; VI-NEXT:    s_and_b32 s19, 0xffff, s21
; VI-NEXT:    s_lshl_b32 s20, s90, 16
; VI-NEXT:    s_or_b32 s19, s19, s20
; VI-NEXT:    s_and_b32 s20, 0xffff, s22
; VI-NEXT:    s_lshl_b32 s21, s89, 16
; VI-NEXT:    s_or_b32 s20, s20, s21
; VI-NEXT:    s_and_b32 s21, 0xffff, s23
; VI-NEXT:    s_lshl_b32 s22, s88, 16
; VI-NEXT:    s_or_b32 s21, s21, s22
; VI-NEXT:    s_and_b32 s22, 0xffff, s24
; VI-NEXT:    s_lshl_b32 s23, s79, 16
; VI-NEXT:    s_or_b32 s22, s22, s23
; VI-NEXT:    s_and_b32 s23, 0xffff, s25
; VI-NEXT:    s_lshl_b32 s24, s78, 16
; VI-NEXT:    s_or_b32 s23, s23, s24
; VI-NEXT:    s_and_b32 s24, 0xffff, s26
; VI-NEXT:    s_lshl_b32 s25, s77, 16
; VI-NEXT:    s_or_b32 s24, s24, s25
; VI-NEXT:    s_and_b32 s25, 0xffff, s27
; VI-NEXT:    s_lshl_b32 s26, s76, 16
; VI-NEXT:    s_or_b32 s25, s25, s26
; VI-NEXT:    s_and_b32 s26, 0xffff, s28
; VI-NEXT:    s_lshl_b32 s27, s75, 16
; VI-NEXT:    s_or_b32 s26, s26, s27
; VI-NEXT:    s_and_b32 s27, 0xffff, s29
; VI-NEXT:    s_lshl_b32 s28, s74, 16
; VI-NEXT:    s_or_b32 s27, s27, s28
; VI-NEXT:    s_and_b32 s28, 0xffff, s43
; VI-NEXT:    s_lshl_b32 s29, s73, 16
; VI-NEXT:    s_or_b32 s28, s28, s29
; VI-NEXT:    s_and_b32 s29, 0xffff, s42
; VI-NEXT:    s_lshl_b32 s42, s72, 16
; VI-NEXT:    s_or_b32 s29, s29, s42
; VI-NEXT:    s_and_b32 s41, 0xffff, s41
; VI-NEXT:    s_lshl_b32 s42, s63, 16
; VI-NEXT:    s_or_b32 s41, s41, s42
; VI-NEXT:    s_and_b32 s40, 0xffff, s40
; VI-NEXT:    s_lshl_b32 s42, s62, 16
; VI-NEXT:    s_or_b32 s40, s40, s42
; VI-NEXT:    s_and_b32 s15, 0xffff, s15
; VI-NEXT:    s_lshl_b32 s42, s61, 16
; VI-NEXT:    s_or_b32 s15, s15, s42
; VI-NEXT:    s_and_b32 s14, 0xffff, s14
; VI-NEXT:    s_lshl_b32 s42, s60, 16
; VI-NEXT:    s_or_b32 s14, s14, s42
; VI-NEXT:    s_and_b32 s13, 0xffff, s13
; VI-NEXT:    s_lshl_b32 s42, s59, 16
; VI-NEXT:    s_or_b32 s13, s13, s42
; VI-NEXT:    s_and_b32 s12, 0xffff, s12
; VI-NEXT:    s_lshl_b32 s42, s58, 16
; VI-NEXT:    s_or_b32 s12, s12, s42
; VI-NEXT:    s_and_b32 s11, 0xffff, s11
; VI-NEXT:    s_lshl_b32 s42, s57, 16
; VI-NEXT:    s_or_b32 s11, s11, s42
; VI-NEXT:    s_and_b32 s10, 0xffff, s10
; VI-NEXT:    s_lshl_b32 s42, s56, 16
; VI-NEXT:    s_or_b32 s10, s10, s42
; VI-NEXT:    s_and_b32 s9, 0xffff, s9
; VI-NEXT:    s_lshl_b32 s42, s47, 16
; VI-NEXT:    s_or_b32 s9, s9, s42
; VI-NEXT:    s_and_b32 s8, 0xffff, s8
; VI-NEXT:    s_lshl_b32 s42, s46, 16
; VI-NEXT:    s_or_b32 s8, s8, s42
; VI-NEXT:    s_and_b32 s6, 0xffff, s6
; VI-NEXT:    s_lshl_b32 s42, s45, 16
; VI-NEXT:    s_or_b32 s6, s6, s42
; VI-NEXT:    s_and_b32 s7, 0xffff, s7
; VI-NEXT:    s_lshl_b32 s42, s44, 16
; VI-NEXT:    s_or_b32 s7, s7, s42
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    v_mov_b32_e32 v3, s17
; VI-NEXT:    v_mov_b32_e32 v4, s18
; VI-NEXT:    v_mov_b32_e32 v5, s19
; VI-NEXT:    v_mov_b32_e32 v6, s20
; VI-NEXT:    v_mov_b32_e32 v7, s21
; VI-NEXT:    v_mov_b32_e32 v8, s22
; VI-NEXT:    v_mov_b32_e32 v9, s23
; VI-NEXT:    v_mov_b32_e32 v10, s24
; VI-NEXT:    v_mov_b32_e32 v11, s25
; VI-NEXT:    v_mov_b32_e32 v12, s26
; VI-NEXT:    v_mov_b32_e32 v13, s27
; VI-NEXT:    v_mov_b32_e32 v14, s28
; VI-NEXT:    v_mov_b32_e32 v15, s29
; VI-NEXT:    v_mov_b32_e32 v16, s41
; VI-NEXT:    v_mov_b32_e32 v17, s40
; VI-NEXT:    v_mov_b32_e32 v18, s15
; VI-NEXT:    v_mov_b32_e32 v19, s14
; VI-NEXT:    v_mov_b32_e32 v20, s13
; VI-NEXT:    v_mov_b32_e32 v21, s12
; VI-NEXT:    v_mov_b32_e32 v22, s11
; VI-NEXT:    v_mov_b32_e32 v23, s10
; VI-NEXT:    v_mov_b32_e32 v24, s9
; VI-NEXT:    v_mov_b32_e32 v25, s8
; VI-NEXT:    v_mov_b32_e32 v26, s6
; VI-NEXT:    v_mov_b32_e32 v27, s7
; VI-NEXT:    v_readlane_b32 s35, v28, 3
; VI-NEXT:    v_readlane_b32 s34, v28, 2
; VI-NEXT:    v_readlane_b32 s31, v28, 1
; VI-NEXT:    v_readlane_b32 s30, v28, 0
; VI-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; VI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    s_mov_b64 exec, s[4:5]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB13_4:
; VI-NEXT:    ; implicit-def: $sgpr35
; VI-NEXT:    ; implicit-def: $sgpr34
; VI-NEXT:    ; implicit-def: $sgpr31
; VI-NEXT:    ; implicit-def: $sgpr30
; VI-NEXT:    ; implicit-def: $sgpr91
; VI-NEXT:    ; implicit-def: $sgpr90
; VI-NEXT:    ; implicit-def: $sgpr89
; VI-NEXT:    ; implicit-def: $sgpr88
; VI-NEXT:    ; implicit-def: $sgpr79
; VI-NEXT:    ; implicit-def: $sgpr78
; VI-NEXT:    ; implicit-def: $sgpr77
; VI-NEXT:    ; implicit-def: $sgpr76
; VI-NEXT:    ; implicit-def: $sgpr75
; VI-NEXT:    ; implicit-def: $sgpr74
; VI-NEXT:    ; implicit-def: $sgpr73
; VI-NEXT:    ; implicit-def: $sgpr72
; VI-NEXT:    ; implicit-def: $sgpr63
; VI-NEXT:    ; implicit-def: $sgpr62
; VI-NEXT:    ; implicit-def: $sgpr61
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr59
; VI-NEXT:    ; implicit-def: $sgpr58
; VI-NEXT:    ; implicit-def: $sgpr57
; VI-NEXT:    ; implicit-def: $sgpr56
; VI-NEXT:    ; implicit-def: $sgpr47
; VI-NEXT:    ; implicit-def: $sgpr46
; VI-NEXT:    ; implicit-def: $sgpr45
; VI-NEXT:    ; implicit-def: $sgpr44
; VI-NEXT:    s_branch .LBB13_2
;
; GFX9-LABEL: bitcast_v28i32_to_v56i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    v_readfirstlane_b32 s6, v0
; GFX9-NEXT:    v_readfirstlane_b32 s7, v1
; GFX9-NEXT:    v_readfirstlane_b32 s8, v2
; GFX9-NEXT:    v_readfirstlane_b32 s9, v3
; GFX9-NEXT:    v_readfirstlane_b32 s10, v4
; GFX9-NEXT:    v_readfirstlane_b32 s11, v5
; GFX9-NEXT:    v_readfirstlane_b32 s12, v6
; GFX9-NEXT:    v_readfirstlane_b32 s13, v7
; GFX9-NEXT:    v_readfirstlane_b32 s14, v8
; GFX9-NEXT:    v_readfirstlane_b32 s15, v9
; GFX9-NEXT:    v_readfirstlane_b32 s40, v10
; GFX9-NEXT:    v_readfirstlane_b32 s41, v11
; GFX9-NEXT:    v_readfirstlane_b32 s42, v12
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_readfirstlane_b32 s43, v13
; GFX9-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s44, s43, 16
; GFX9-NEXT:    s_lshr_b32 s45, s42, 16
; GFX9-NEXT:    s_lshr_b32 s46, s41, 16
; GFX9-NEXT:    s_lshr_b32 s47, s40, 16
; GFX9-NEXT:    s_lshr_b32 s56, s15, 16
; GFX9-NEXT:    s_lshr_b32 s57, s14, 16
; GFX9-NEXT:    s_lshr_b32 s58, s13, 16
; GFX9-NEXT:    s_lshr_b32 s59, s12, 16
; GFX9-NEXT:    s_lshr_b32 s60, s11, 16
; GFX9-NEXT:    s_lshr_b32 s61, s10, 16
; GFX9-NEXT:    s_lshr_b32 s62, s9, 16
; GFX9-NEXT:    s_lshr_b32 s63, s8, 16
; GFX9-NEXT:    s_lshr_b32 s72, s7, 16
; GFX9-NEXT:    s_lshr_b32 s73, s6, 16
; GFX9-NEXT:    s_lshr_b32 s74, s29, 16
; GFX9-NEXT:    s_lshr_b32 s75, s28, 16
; GFX9-NEXT:    s_lshr_b32 s76, s27, 16
; GFX9-NEXT:    s_lshr_b32 s77, s26, 16
; GFX9-NEXT:    s_lshr_b32 s78, s25, 16
; GFX9-NEXT:    s_lshr_b32 s79, s24, 16
; GFX9-NEXT:    s_lshr_b32 s88, s23, 16
; GFX9-NEXT:    s_lshr_b32 s89, s22, 16
; GFX9-NEXT:    s_lshr_b32 s90, s21, 16
; GFX9-NEXT:    s_lshr_b32 s91, s20, 16
; GFX9-NEXT:    s_lshr_b32 s92, s19, 16
; GFX9-NEXT:    s_lshr_b32 s93, s18, 16
; GFX9-NEXT:    s_lshr_b32 s94, s17, 16
; GFX9-NEXT:    s_lshr_b32 s95, s16, 16
; GFX9-NEXT:    s_cbranch_execnz .LBB13_3
; GFX9-NEXT:  .LBB13_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s43, s43, 3
; GFX9-NEXT:    s_add_i32 s42, s42, 3
; GFX9-NEXT:    s_add_i32 s41, s41, 3
; GFX9-NEXT:    s_add_i32 s40, s40, 3
; GFX9-NEXT:    s_add_i32 s15, s15, 3
; GFX9-NEXT:    s_add_i32 s14, s14, 3
; GFX9-NEXT:    s_add_i32 s13, s13, 3
; GFX9-NEXT:    s_add_i32 s12, s12, 3
; GFX9-NEXT:    s_add_i32 s11, s11, 3
; GFX9-NEXT:    s_add_i32 s10, s10, 3
; GFX9-NEXT:    s_add_i32 s9, s9, 3
; GFX9-NEXT:    s_add_i32 s8, s8, 3
; GFX9-NEXT:    s_add_i32 s7, s7, 3
; GFX9-NEXT:    s_add_i32 s6, s6, 3
; GFX9-NEXT:    s_add_i32 s29, s29, 3
; GFX9-NEXT:    s_add_i32 s28, s28, 3
; GFX9-NEXT:    s_add_i32 s27, s27, 3
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    s_add_i32 s25, s25, 3
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_add_i32 s23, s23, 3
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_lshr_b32 s44, s43, 16
; GFX9-NEXT:    s_lshr_b32 s45, s42, 16
; GFX9-NEXT:    s_lshr_b32 s46, s41, 16
; GFX9-NEXT:    s_lshr_b32 s47, s40, 16
; GFX9-NEXT:    s_lshr_b32 s56, s15, 16
; GFX9-NEXT:    s_lshr_b32 s57, s14, 16
; GFX9-NEXT:    s_lshr_b32 s58, s13, 16
; GFX9-NEXT:    s_lshr_b32 s59, s12, 16
; GFX9-NEXT:    s_lshr_b32 s60, s11, 16
; GFX9-NEXT:    s_lshr_b32 s61, s10, 16
; GFX9-NEXT:    s_lshr_b32 s62, s9, 16
; GFX9-NEXT:    s_lshr_b32 s63, s8, 16
; GFX9-NEXT:    s_lshr_b32 s72, s7, 16
; GFX9-NEXT:    s_lshr_b32 s73, s6, 16
; GFX9-NEXT:    s_lshr_b32 s74, s29, 16
; GFX9-NEXT:    s_lshr_b32 s75, s28, 16
; GFX9-NEXT:    s_lshr_b32 s76, s27, 16
; GFX9-NEXT:    s_lshr_b32 s77, s26, 16
; GFX9-NEXT:    s_lshr_b32 s78, s25, 16
; GFX9-NEXT:    s_lshr_b32 s79, s24, 16
; GFX9-NEXT:    s_lshr_b32 s88, s23, 16
; GFX9-NEXT:    s_lshr_b32 s89, s22, 16
; GFX9-NEXT:    s_lshr_b32 s90, s21, 16
; GFX9-NEXT:    s_lshr_b32 s91, s20, 16
; GFX9-NEXT:    s_lshr_b32 s92, s19, 16
; GFX9-NEXT:    s_lshr_b32 s93, s18, 16
; GFX9-NEXT:    s_lshr_b32 s94, s17, 16
; GFX9-NEXT:    s_lshr_b32 s95, s16, 16
; GFX9-NEXT:  .LBB13_3: ; %end
; GFX9-NEXT:    s_pack_ll_b32_b16 s4, s16, s95
; GFX9-NEXT:    s_pack_ll_b32_b16 s5, s17, s94
; GFX9-NEXT:    s_pack_ll_b32_b16 s16, s18, s93
; GFX9-NEXT:    s_pack_ll_b32_b16 s17, s19, s92
; GFX9-NEXT:    s_pack_ll_b32_b16 s18, s20, s91
; GFX9-NEXT:    s_pack_ll_b32_b16 s19, s21, s90
; GFX9-NEXT:    s_pack_ll_b32_b16 s20, s22, s89
; GFX9-NEXT:    s_pack_ll_b32_b16 s21, s23, s88
; GFX9-NEXT:    s_pack_ll_b32_b16 s22, s24, s79
; GFX9-NEXT:    s_pack_ll_b32_b16 s23, s25, s78
; GFX9-NEXT:    s_pack_ll_b32_b16 s24, s26, s77
; GFX9-NEXT:    s_pack_ll_b32_b16 s25, s27, s76
; GFX9-NEXT:    s_pack_ll_b32_b16 s26, s28, s75
; GFX9-NEXT:    s_pack_ll_b32_b16 s27, s29, s74
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s6, s73
; GFX9-NEXT:    s_pack_ll_b32_b16 s7, s7, s72
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s8, s63
; GFX9-NEXT:    s_pack_ll_b32_b16 s9, s9, s62
; GFX9-NEXT:    s_pack_ll_b32_b16 s10, s10, s61
; GFX9-NEXT:    s_pack_ll_b32_b16 s11, s11, s60
; GFX9-NEXT:    s_pack_ll_b32_b16 s12, s12, s59
; GFX9-NEXT:    s_pack_ll_b32_b16 s13, s13, s58
; GFX9-NEXT:    s_pack_ll_b32_b16 s14, s14, s57
; GFX9-NEXT:    s_pack_ll_b32_b16 s15, s15, s56
; GFX9-NEXT:    s_pack_ll_b32_b16 s28, s40, s47
; GFX9-NEXT:    s_pack_ll_b32_b16 s29, s41, s46
; GFX9-NEXT:    s_pack_ll_b32_b16 s40, s42, s45
; GFX9-NEXT:    s_pack_ll_b32_b16 s41, s43, s44
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s16
; GFX9-NEXT:    v_mov_b32_e32 v3, s17
; GFX9-NEXT:    v_mov_b32_e32 v4, s18
; GFX9-NEXT:    v_mov_b32_e32 v5, s19
; GFX9-NEXT:    v_mov_b32_e32 v6, s20
; GFX9-NEXT:    v_mov_b32_e32 v7, s21
; GFX9-NEXT:    v_mov_b32_e32 v8, s22
; GFX9-NEXT:    v_mov_b32_e32 v9, s23
; GFX9-NEXT:    v_mov_b32_e32 v10, s24
; GFX9-NEXT:    v_mov_b32_e32 v11, s25
; GFX9-NEXT:    v_mov_b32_e32 v12, s26
; GFX9-NEXT:    v_mov_b32_e32 v13, s27
; GFX9-NEXT:    v_mov_b32_e32 v14, s6
; GFX9-NEXT:    v_mov_b32_e32 v15, s7
; GFX9-NEXT:    v_mov_b32_e32 v16, s8
; GFX9-NEXT:    v_mov_b32_e32 v17, s9
; GFX9-NEXT:    v_mov_b32_e32 v18, s10
; GFX9-NEXT:    v_mov_b32_e32 v19, s11
; GFX9-NEXT:    v_mov_b32_e32 v20, s12
; GFX9-NEXT:    v_mov_b32_e32 v21, s13
; GFX9-NEXT:    v_mov_b32_e32 v22, s14
; GFX9-NEXT:    v_mov_b32_e32 v23, s15
; GFX9-NEXT:    v_mov_b32_e32 v24, s28
; GFX9-NEXT:    v_mov_b32_e32 v25, s29
; GFX9-NEXT:    v_mov_b32_e32 v26, s40
; GFX9-NEXT:    v_mov_b32_e32 v27, s41
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB13_4:
; GFX9-NEXT:    ; implicit-def: $sgpr95
; GFX9-NEXT:    ; implicit-def: $sgpr94
; GFX9-NEXT:    ; implicit-def: $sgpr93
; GFX9-NEXT:    ; implicit-def: $sgpr92
; GFX9-NEXT:    ; implicit-def: $sgpr91
; GFX9-NEXT:    ; implicit-def: $sgpr90
; GFX9-NEXT:    ; implicit-def: $sgpr89
; GFX9-NEXT:    ; implicit-def: $sgpr88
; GFX9-NEXT:    ; implicit-def: $sgpr79
; GFX9-NEXT:    ; implicit-def: $sgpr78
; GFX9-NEXT:    ; implicit-def: $sgpr77
; GFX9-NEXT:    ; implicit-def: $sgpr76
; GFX9-NEXT:    ; implicit-def: $sgpr75
; GFX9-NEXT:    ; implicit-def: $sgpr74
; GFX9-NEXT:    ; implicit-def: $sgpr73
; GFX9-NEXT:    ; implicit-def: $sgpr72
; GFX9-NEXT:    ; implicit-def: $sgpr63
; GFX9-NEXT:    ; implicit-def: $sgpr62
; GFX9-NEXT:    ; implicit-def: $sgpr61
; GFX9-NEXT:    ; implicit-def: $sgpr60
; GFX9-NEXT:    ; implicit-def: $sgpr59
; GFX9-NEXT:    ; implicit-def: $sgpr58
; GFX9-NEXT:    ; implicit-def: $sgpr57
; GFX9-NEXT:    ; implicit-def: $sgpr56
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr46
; GFX9-NEXT:    ; implicit-def: $sgpr45
; GFX9-NEXT:    ; implicit-def: $sgpr44
; GFX9-NEXT:    s_branch .LBB13_2
;
; GFX11-LABEL: bitcast_v28i32_to_v56i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v10
; GFX11-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_readfirstlane_b32 s6, v2
; GFX11-NEXT:    v_readfirstlane_b32 s7, v3
; GFX11-NEXT:    v_readfirstlane_b32 s8, v4
; GFX11-NEXT:    v_readfirstlane_b32 s9, v5
; GFX11-NEXT:    v_readfirstlane_b32 s10, v6
; GFX11-NEXT:    v_readfirstlane_b32 s11, v7
; GFX11-NEXT:    v_readfirstlane_b32 s13, v8
; GFX11-NEXT:    v_readfirstlane_b32 s12, v9
; GFX11-NEXT:    s_mov_b32 s90, 0
; GFX11-NEXT:    s_and_b32 s14, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s14, s12, 16
; GFX11-NEXT:    s_lshr_b32 s15, s13, 16
; GFX11-NEXT:    s_lshr_b32 s40, s11, 16
; GFX11-NEXT:    s_lshr_b32 s41, s10, 16
; GFX11-NEXT:    s_lshr_b32 s42, s9, 16
; GFX11-NEXT:    s_lshr_b32 s43, s8, 16
; GFX11-NEXT:    s_lshr_b32 s44, s7, 16
; GFX11-NEXT:    s_lshr_b32 s45, s6, 16
; GFX11-NEXT:    s_lshr_b32 s46, s5, 16
; GFX11-NEXT:    s_lshr_b32 s47, s4, 16
; GFX11-NEXT:    s_lshr_b32 s56, s29, 16
; GFX11-NEXT:    s_lshr_b32 s57, s28, 16
; GFX11-NEXT:    s_lshr_b32 s58, s27, 16
; GFX11-NEXT:    s_lshr_b32 s59, s26, 16
; GFX11-NEXT:    s_lshr_b32 s60, s25, 16
; GFX11-NEXT:    s_lshr_b32 s61, s24, 16
; GFX11-NEXT:    s_lshr_b32 s62, s23, 16
; GFX11-NEXT:    s_lshr_b32 s63, s22, 16
; GFX11-NEXT:    s_lshr_b32 s72, s21, 16
; GFX11-NEXT:    s_lshr_b32 s73, s20, 16
; GFX11-NEXT:    s_lshr_b32 s74, s19, 16
; GFX11-NEXT:    s_lshr_b32 s75, s18, 16
; GFX11-NEXT:    s_lshr_b32 s76, s17, 16
; GFX11-NEXT:    s_lshr_b32 s77, s16, 16
; GFX11-NEXT:    s_lshr_b32 s78, s3, 16
; GFX11-NEXT:    s_lshr_b32 s79, s2, 16
; GFX11-NEXT:    s_lshr_b32 s88, s1, 16
; GFX11-NEXT:    s_lshr_b32 s89, s0, 16
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s90
; GFX11-NEXT:    s_cbranch_vccnz .LBB13_3
; GFX11-NEXT:  .LBB13_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s12, s12, 3
; GFX11-NEXT:    s_add_i32 s13, s13, 3
; GFX11-NEXT:    s_add_i32 s11, s11, 3
; GFX11-NEXT:    s_add_i32 s10, s10, 3
; GFX11-NEXT:    s_add_i32 s9, s9, 3
; GFX11-NEXT:    s_add_i32 s8, s8, 3
; GFX11-NEXT:    s_add_i32 s7, s7, 3
; GFX11-NEXT:    s_add_i32 s6, s6, 3
; GFX11-NEXT:    s_add_i32 s5, s5, 3
; GFX11-NEXT:    s_add_i32 s4, s4, 3
; GFX11-NEXT:    s_add_i32 s29, s29, 3
; GFX11-NEXT:    s_add_i32 s28, s28, 3
; GFX11-NEXT:    s_add_i32 s27, s27, 3
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    s_add_i32 s25, s25, 3
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    s_add_i32 s23, s23, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_add_i32 s21, s21, 3
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_lshr_b32 s14, s12, 16
; GFX11-NEXT:    s_lshr_b32 s15, s13, 16
; GFX11-NEXT:    s_lshr_b32 s40, s11, 16
; GFX11-NEXT:    s_lshr_b32 s41, s10, 16
; GFX11-NEXT:    s_lshr_b32 s42, s9, 16
; GFX11-NEXT:    s_lshr_b32 s43, s8, 16
; GFX11-NEXT:    s_lshr_b32 s44, s7, 16
; GFX11-NEXT:    s_lshr_b32 s45, s6, 16
; GFX11-NEXT:    s_lshr_b32 s46, s5, 16
; GFX11-NEXT:    s_lshr_b32 s47, s4, 16
; GFX11-NEXT:    s_lshr_b32 s56, s29, 16
; GFX11-NEXT:    s_lshr_b32 s57, s28, 16
; GFX11-NEXT:    s_lshr_b32 s58, s27, 16
; GFX11-NEXT:    s_lshr_b32 s59, s26, 16
; GFX11-NEXT:    s_lshr_b32 s60, s25, 16
; GFX11-NEXT:    s_lshr_b32 s61, s24, 16
; GFX11-NEXT:    s_lshr_b32 s62, s23, 16
; GFX11-NEXT:    s_lshr_b32 s63, s22, 16
; GFX11-NEXT:    s_lshr_b32 s72, s21, 16
; GFX11-NEXT:    s_lshr_b32 s73, s20, 16
; GFX11-NEXT:    s_lshr_b32 s74, s19, 16
; GFX11-NEXT:    s_lshr_b32 s75, s18, 16
; GFX11-NEXT:    s_lshr_b32 s76, s17, 16
; GFX11-NEXT:    s_lshr_b32 s77, s16, 16
; GFX11-NEXT:    s_lshr_b32 s78, s3, 16
; GFX11-NEXT:    s_lshr_b32 s79, s2, 16
; GFX11-NEXT:    s_lshr_b32 s88, s1, 16
; GFX11-NEXT:    s_lshr_b32 s89, s0, 16
; GFX11-NEXT:  .LBB13_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_pack_ll_b32_b16 s0, s0, s89
; GFX11-NEXT:    s_pack_ll_b32_b16 s1, s1, s88
; GFX11-NEXT:    s_pack_ll_b32_b16 s2, s2, s79
; GFX11-NEXT:    s_pack_ll_b32_b16 s3, s3, s78
; GFX11-NEXT:    s_pack_ll_b32_b16 s16, s16, s77
; GFX11-NEXT:    s_pack_ll_b32_b16 s17, s17, s76
; GFX11-NEXT:    s_pack_ll_b32_b16 s18, s18, s75
; GFX11-NEXT:    s_pack_ll_b32_b16 s19, s19, s74
; GFX11-NEXT:    s_pack_ll_b32_b16 s20, s20, s73
; GFX11-NEXT:    s_pack_ll_b32_b16 s21, s21, s72
; GFX11-NEXT:    s_pack_ll_b32_b16 s22, s22, s63
; GFX11-NEXT:    s_pack_ll_b32_b16 s23, s23, s62
; GFX11-NEXT:    s_pack_ll_b32_b16 s24, s24, s61
; GFX11-NEXT:    s_pack_ll_b32_b16 s25, s25, s60
; GFX11-NEXT:    s_pack_ll_b32_b16 s26, s26, s59
; GFX11-NEXT:    s_pack_ll_b32_b16 s27, s27, s58
; GFX11-NEXT:    s_pack_ll_b32_b16 s28, s28, s57
; GFX11-NEXT:    s_pack_ll_b32_b16 s29, s29, s56
; GFX11-NEXT:    s_pack_ll_b32_b16 s4, s4, s47
; GFX11-NEXT:    s_pack_ll_b32_b16 s5, s5, s46
; GFX11-NEXT:    s_pack_ll_b32_b16 s6, s6, s45
; GFX11-NEXT:    s_pack_ll_b32_b16 s7, s7, s44
; GFX11-NEXT:    s_pack_ll_b32_b16 s8, s8, s43
; GFX11-NEXT:    s_pack_ll_b32_b16 s9, s9, s42
; GFX11-NEXT:    s_pack_ll_b32_b16 s10, s10, s41
; GFX11-NEXT:    s_pack_ll_b32_b16 s11, s11, s40
; GFX11-NEXT:    s_pack_ll_b32_b16 s13, s13, s15
; GFX11-NEXT:    s_pack_ll_b32_b16 s12, s12, s14
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v16, s28 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_dual_mov_b32 v18, s4 :: v_dual_mov_b32 v19, s5
; GFX11-NEXT:    v_dual_mov_b32 v20, s6 :: v_dual_mov_b32 v21, s7
; GFX11-NEXT:    v_dual_mov_b32 v22, s8 :: v_dual_mov_b32 v23, s9
; GFX11-NEXT:    v_dual_mov_b32 v24, s10 :: v_dual_mov_b32 v25, s11
; GFX11-NEXT:    v_dual_mov_b32 v26, s13 :: v_dual_mov_b32 v27, s12
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB13_4:
; GFX11-NEXT:    ; implicit-def: $sgpr89
; GFX11-NEXT:    ; implicit-def: $sgpr88
; GFX11-NEXT:    ; implicit-def: $sgpr79
; GFX11-NEXT:    ; implicit-def: $sgpr78
; GFX11-NEXT:    ; implicit-def: $sgpr77
; GFX11-NEXT:    ; implicit-def: $sgpr76
; GFX11-NEXT:    ; implicit-def: $sgpr75
; GFX11-NEXT:    ; implicit-def: $sgpr74
; GFX11-NEXT:    ; implicit-def: $sgpr73
; GFX11-NEXT:    ; implicit-def: $sgpr72
; GFX11-NEXT:    ; implicit-def: $sgpr63
; GFX11-NEXT:    ; implicit-def: $sgpr62
; GFX11-NEXT:    ; implicit-def: $sgpr61
; GFX11-NEXT:    ; implicit-def: $sgpr60
; GFX11-NEXT:    ; implicit-def: $sgpr59
; GFX11-NEXT:    ; implicit-def: $sgpr58
; GFX11-NEXT:    ; implicit-def: $sgpr57
; GFX11-NEXT:    ; implicit-def: $sgpr56
; GFX11-NEXT:    ; implicit-def: $sgpr47
; GFX11-NEXT:    ; implicit-def: $sgpr46
; GFX11-NEXT:    ; implicit-def: $sgpr45
; GFX11-NEXT:    ; implicit-def: $sgpr44
; GFX11-NEXT:    ; implicit-def: $sgpr43
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr41
; GFX11-NEXT:    ; implicit-def: $sgpr40
; GFX11-NEXT:    ; implicit-def: $sgpr15
; GFX11-NEXT:    ; implicit-def: $sgpr14
; GFX11-NEXT:    s_branch .LBB13_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <28 x i32> %a, splat (i32 3)
  %a2 = bitcast <28 x i32> %a1 to <56 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <28 x i32> %a to <56 x i16>
  br label %end

end:
  %phi = phi <56 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <56 x i16> %phi
}

define <28 x i32> @bitcast_v56i16_to_v28i32(<56 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v56i16_to_v28i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v54, v2
; SI-NEXT:    v_mov_b32_e32 v55, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:96
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:92
; SI-NEXT:    v_mov_b32_e32 v53, v4
; SI-NEXT:    v_lshlrev_b32_e32 v58, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v52, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v57, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v51, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v56, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v50, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v46, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v45, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v39, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v37, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v36, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v34, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v43, 16, v25
; SI-NEXT:    v_lshlrev_b32_e32 v42, 16, v27
; SI-NEXT:    v_lshlrev_b32_e32 v40, 16, v29
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v60, 16, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:88
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:84
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v61, 16, v2
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:80
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:76
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v62, 16, v4
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:72
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:68
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v63, 16, v6
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:100
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:24
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:16
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:64
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:60
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_lshlrev_b32_e32 v47, 16, v8
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v10
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_lshlrev_b32_e32 v44, 16, v12
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v38, 16, v14
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_lshlrev_b32_e32 v48, 16, v16
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v49, 16, v18
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v41, 16, v20
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:56
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:40
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:48
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:52
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_lshlrev_b32_e32 v32, 16, v22
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v35, 16, v24
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v33, 16, v26
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:44
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:36
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:28
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:20
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:12
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB14_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v55
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v54
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v53
; SI-NEXT:    v_and_b32_e32 v16, 0xffff, v59
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    v_or_b32_e32 v0, v0, v58
; SI-NEXT:    v_or_b32_e32 v1, v1, v52
; SI-NEXT:    v_or_b32_e32 v2, v2, v57
; SI-NEXT:    v_or_b32_e32 v16, v16, v49
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; SI-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; SI-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    s_waitcnt vmcnt(13)
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    s_waitcnt vmcnt(12)
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; SI-NEXT:    s_waitcnt vmcnt(11)
; SI-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; SI-NEXT:    s_waitcnt vmcnt(9)
; SI-NEXT:    v_and_b32_e32 v23, 0xffff, v23
; SI-NEXT:    s_waitcnt vmcnt(8)
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_and_b32_e32 v24, 0xffff, v24
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_and_b32_e32 v25, 0xffff, v25
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v26, 0xffff, v26
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v27, 0xffff, v27
; SI-NEXT:    v_or_b32_e32 v3, v3, v51
; SI-NEXT:    v_or_b32_e32 v4, v4, v56
; SI-NEXT:    v_or_b32_e32 v5, v5, v50
; SI-NEXT:    v_or_b32_e32 v6, v6, v46
; SI-NEXT:    v_or_b32_e32 v7, v7, v45
; SI-NEXT:    v_or_b32_e32 v8, v8, v39
; SI-NEXT:    v_or_b32_e32 v9, v9, v37
; SI-NEXT:    v_or_b32_e32 v10, v10, v36
; SI-NEXT:    v_or_b32_e32 v11, v11, v34
; SI-NEXT:    v_or_b32_e32 v12, v12, v43
; SI-NEXT:    v_or_b32_e32 v13, v13, v42
; SI-NEXT:    v_or_b32_e32 v14, v14, v40
; SI-NEXT:    v_or_b32_e32 v15, v15, v47
; SI-NEXT:    v_or_b32_e32 v17, v17, v48
; SI-NEXT:    v_or_b32_e32 v18, v18, v38
; SI-NEXT:    v_or_b32_e32 v19, v19, v44
; SI-NEXT:    v_or_b32_e32 v20, v20, v35
; SI-NEXT:    v_or_b32_e32 v21, v21, v33
; SI-NEXT:    v_or_b32_e32 v22, v22, v32
; SI-NEXT:    v_or_b32_e32 v23, v23, v41
; SI-NEXT:    v_or_b32_e32 v24, v24, v63
; SI-NEXT:    v_or_b32_e32 v25, v25, v62
; SI-NEXT:    v_or_b32_e32 v26, v26, v61
; SI-NEXT:    v_or_b32_e32 v27, v27, v60
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr63
; SI-NEXT:    ; implicit-def: $vgpr62
; SI-NEXT:    ; implicit-def: $vgpr61
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:  .LBB14_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB14_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v55
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v54
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v53
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v59
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; SI-NEXT:    v_or_b32_e32 v0, v58, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v52, v1
; SI-NEXT:    v_or_b32_e32 v2, v57, v2
; SI-NEXT:    v_or_b32_e32 v16, v49, v16
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v16, vcc, s6, v16
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    s_waitcnt vmcnt(13)
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    s_waitcnt vmcnt(8)
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; SI-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; SI-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; SI-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; SI-NEXT:    v_and_b32_e32 v23, 0xffff, v23
; SI-NEXT:    v_and_b32_e32 v24, 0xffff, v24
; SI-NEXT:    v_and_b32_e32 v25, 0xffff, v25
; SI-NEXT:    v_and_b32_e32 v26, 0xffff, v26
; SI-NEXT:    v_and_b32_e32 v27, 0xffff, v27
; SI-NEXT:    v_or_b32_e32 v3, v51, v3
; SI-NEXT:    v_or_b32_e32 v4, v56, v4
; SI-NEXT:    v_or_b32_e32 v5, v50, v5
; SI-NEXT:    v_or_b32_e32 v6, v46, v6
; SI-NEXT:    v_or_b32_e32 v7, v45, v7
; SI-NEXT:    v_or_b32_e32 v8, v39, v8
; SI-NEXT:    v_or_b32_e32 v9, v37, v9
; SI-NEXT:    v_or_b32_e32 v10, v36, v10
; SI-NEXT:    v_or_b32_e32 v11, v34, v11
; SI-NEXT:    v_or_b32_e32 v12, v43, v12
; SI-NEXT:    v_or_b32_e32 v13, v42, v13
; SI-NEXT:    v_or_b32_e32 v14, v40, v14
; SI-NEXT:    v_or_b32_e32 v15, v47, v15
; SI-NEXT:    v_or_b32_e32 v17, v48, v17
; SI-NEXT:    v_or_b32_e32 v18, v38, v18
; SI-NEXT:    v_or_b32_e32 v19, v44, v19
; SI-NEXT:    v_or_b32_e32 v20, v35, v20
; SI-NEXT:    v_or_b32_e32 v21, v33, v21
; SI-NEXT:    v_or_b32_e32 v22, v32, v22
; SI-NEXT:    v_or_b32_e32 v23, v41, v23
; SI-NEXT:    v_or_b32_e32 v24, v63, v24
; SI-NEXT:    v_or_b32_e32 v25, v62, v25
; SI-NEXT:    v_or_b32_e32 v26, v61, v26
; SI-NEXT:    v_or_b32_e32 v27, v60, v27
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, s6, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, s6, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, s6, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, s6, v8
; SI-NEXT:    v_add_i32_e32 v9, vcc, s6, v9
; SI-NEXT:    v_add_i32_e32 v10, vcc, s6, v10
; SI-NEXT:    v_add_i32_e32 v11, vcc, s6, v11
; SI-NEXT:    v_add_i32_e32 v12, vcc, s6, v12
; SI-NEXT:    v_add_i32_e32 v13, vcc, s6, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, s6, v14
; SI-NEXT:    v_add_i32_e32 v15, vcc, s6, v15
; SI-NEXT:    v_add_i32_e32 v17, vcc, s6, v17
; SI-NEXT:    v_add_i32_e32 v18, vcc, s6, v18
; SI-NEXT:    v_add_i32_e32 v19, vcc, s6, v19
; SI-NEXT:    v_add_i32_e32 v20, vcc, s6, v20
; SI-NEXT:    v_add_i32_e32 v21, vcc, s6, v21
; SI-NEXT:    v_add_i32_e32 v22, vcc, s6, v22
; SI-NEXT:    v_add_i32_e32 v23, vcc, s6, v23
; SI-NEXT:    v_add_i32_e32 v24, vcc, s6, v24
; SI-NEXT:    v_add_i32_e32 v25, vcc, s6, v25
; SI-NEXT:    v_add_i32_e32 v26, vcc, s6, v26
; SI-NEXT:    v_add_i32_e32 v27, vcc, 0x30000, v27
; SI-NEXT:  .LBB14_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v56i16_to_v28i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    v_mov_b32_e32 v32, v27
; VI-NEXT:    v_mov_b32_e32 v33, v26
; VI-NEXT:    v_mov_b32_e32 v34, v25
; VI-NEXT:    v_mov_b32_e32 v35, v24
; VI-NEXT:    v_mov_b32_e32 v36, v23
; VI-NEXT:    v_mov_b32_e32 v37, v22
; VI-NEXT:    v_mov_b32_e32 v38, v21
; VI-NEXT:    v_mov_b32_e32 v39, v20
; VI-NEXT:    v_mov_b32_e32 v48, v19
; VI-NEXT:    v_mov_b32_e32 v49, v18
; VI-NEXT:    v_mov_b32_e32 v50, v17
; VI-NEXT:    v_mov_b32_e32 v51, v16
; VI-NEXT:    v_mov_b32_e32 v52, v15
; VI-NEXT:    v_mov_b32_e32 v53, v14
; VI-NEXT:    v_mov_b32_e32 v54, v13
; VI-NEXT:    v_mov_b32_e32 v55, v12
; VI-NEXT:    v_mov_b32_e32 v40, v11
; VI-NEXT:    v_mov_b32_e32 v41, v10
; VI-NEXT:    v_mov_b32_e32 v42, v9
; VI-NEXT:    v_mov_b32_e32 v43, v8
; VI-NEXT:    v_mov_b32_e32 v44, v7
; VI-NEXT:    v_mov_b32_e32 v45, v6
; VI-NEXT:    v_mov_b32_e32 v46, v5
; VI-NEXT:    v_mov_b32_e32 v47, v4
; VI-NEXT:    v_mov_b32_e32 v56, v3
; VI-NEXT:    v_mov_b32_e32 v57, v2
; VI-NEXT:    v_mov_b32_e32 v58, v1
; VI-NEXT:    v_mov_b32_e32 v59, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB14_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_mov_b32_e32 v27, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v27, v59 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v27, v58 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v27, v57 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v3, v27, v56 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v4, v27, v47 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v5, v27, v46 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v6, v27, v45 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v7, v27, v44 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v8, v27, v43 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v9, v27, v42 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v10, v27, v41 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v11, v27, v40 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v12, v27, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v13, v27, v54 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v14, v27, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v15, v27, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v16, v27, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v17, v27, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v18, v27, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v19, v27, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v20, v27, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v21, v27, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v22, v27, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v23, v27, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v24, v27, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v25, v27, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v26, v27, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v27, v27, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v59, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v58, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v57, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v56, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v47, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v46, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v45, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v44, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v43, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v42, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v41, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v40, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v55, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v54, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v53, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v52, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v51, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v50, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v49, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v48, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v20, v39, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v21, v38, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v22, v37, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v23, v36, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v24, v35, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v25, v34, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v26, v33, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v27, v32, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr59
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    ; implicit-def: $vgpr57
; VI-NEXT:    ; implicit-def: $vgpr56
; VI-NEXT:    ; implicit-def: $vgpr47
; VI-NEXT:    ; implicit-def: $vgpr46
; VI-NEXT:    ; implicit-def: $vgpr45
; VI-NEXT:    ; implicit-def: $vgpr44
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:  .LBB14_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB14_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v27, 3
; VI-NEXT:    v_add_u16_e32 v0, 3, v59
; VI-NEXT:    v_add_u16_sdwa v1, v59, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v2, 3, v58
; VI-NEXT:    v_add_u16_sdwa v3, v58, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_or_b32_e32 v1, v2, v3
; VI-NEXT:    v_add_u16_e32 v2, 3, v57
; VI-NEXT:    v_add_u16_sdwa v3, v57, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    v_add_u16_e32 v3, 3, v56
; VI-NEXT:    v_add_u16_sdwa v4, v56, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v47
; VI-NEXT:    v_add_u16_sdwa v5, v47, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v4, v5
; VI-NEXT:    v_add_u16_e32 v5, 3, v46
; VI-NEXT:    v_add_u16_sdwa v6, v46, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v5, v6
; VI-NEXT:    v_add_u16_e32 v6, 3, v45
; VI-NEXT:    v_add_u16_sdwa v7, v45, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v6, v6, v7
; VI-NEXT:    v_add_u16_e32 v7, 3, v44
; VI-NEXT:    v_add_u16_sdwa v8, v44, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v7, v7, v8
; VI-NEXT:    v_add_u16_e32 v8, 3, v43
; VI-NEXT:    v_add_u16_sdwa v9, v43, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v8, v8, v9
; VI-NEXT:    v_add_u16_e32 v9, 3, v42
; VI-NEXT:    v_add_u16_sdwa v10, v42, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v9, v9, v10
; VI-NEXT:    v_add_u16_e32 v10, 3, v41
; VI-NEXT:    v_add_u16_sdwa v11, v41, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v10, v10, v11
; VI-NEXT:    v_add_u16_e32 v11, 3, v40
; VI-NEXT:    v_add_u16_sdwa v12, v40, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v11, v11, v12
; VI-NEXT:    v_add_u16_e32 v12, 3, v55
; VI-NEXT:    v_add_u16_sdwa v13, v55, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v12, v12, v13
; VI-NEXT:    v_add_u16_e32 v13, 3, v54
; VI-NEXT:    v_add_u16_sdwa v14, v54, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v13, v13, v14
; VI-NEXT:    v_add_u16_e32 v14, 3, v53
; VI-NEXT:    v_add_u16_sdwa v15, v53, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v14, v14, v15
; VI-NEXT:    v_add_u16_e32 v15, 3, v52
; VI-NEXT:    v_add_u16_sdwa v16, v52, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v15, v15, v16
; VI-NEXT:    v_add_u16_e32 v16, 3, v51
; VI-NEXT:    v_add_u16_sdwa v17, v51, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v16, v16, v17
; VI-NEXT:    v_add_u16_e32 v17, 3, v50
; VI-NEXT:    v_add_u16_sdwa v18, v50, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v17, v17, v18
; VI-NEXT:    v_add_u16_e32 v18, 3, v49
; VI-NEXT:    v_add_u16_sdwa v19, v49, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v18, v18, v19
; VI-NEXT:    v_add_u16_e32 v19, 3, v48
; VI-NEXT:    v_add_u16_sdwa v20, v48, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v19, v19, v20
; VI-NEXT:    v_add_u16_e32 v20, 3, v39
; VI-NEXT:    v_add_u16_sdwa v21, v39, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v20, v20, v21
; VI-NEXT:    v_add_u16_e32 v21, 3, v38
; VI-NEXT:    v_add_u16_sdwa v22, v38, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v21, v21, v22
; VI-NEXT:    v_add_u16_e32 v22, 3, v37
; VI-NEXT:    v_add_u16_sdwa v23, v37, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v22, v22, v23
; VI-NEXT:    v_add_u16_e32 v23, 3, v36
; VI-NEXT:    v_add_u16_sdwa v24, v36, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v23, v23, v24
; VI-NEXT:    v_add_u16_e32 v24, 3, v35
; VI-NEXT:    v_add_u16_sdwa v25, v35, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v24, v24, v25
; VI-NEXT:    v_add_u16_e32 v25, 3, v34
; VI-NEXT:    v_add_u16_sdwa v26, v34, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v25, v25, v26
; VI-NEXT:    v_add_u16_e32 v26, 3, v33
; VI-NEXT:    v_add_u16_sdwa v28, v33, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v26, v26, v28
; VI-NEXT:    v_add_u16_e32 v28, 3, v32
; VI-NEXT:    v_add_u16_sdwa v27, v32, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v27, v28, v27
; VI-NEXT:  .LBB14_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v56i16_to_v28i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    v_mov_b32_e32 v59, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v27
; GFX9-NEXT:    buffer_store_dword v27, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v26
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v25, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v25
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v24
; GFX9-NEXT:    v_mov_b32_e32 v37, v22
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v23, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v23
; GFX9-NEXT:    v_mov_b32_e32 v38, v21
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v37
; GFX9-NEXT:    v_mov_b32_e32 v39, v20
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v38
; GFX9-NEXT:    v_mov_b32_e32 v48, v19
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v39
; GFX9-NEXT:    v_mov_b32_e32 v49, v18
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v48
; GFX9-NEXT:    v_mov_b32_e32 v50, v17
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v49
; GFX9-NEXT:    v_mov_b32_e32 v51, v16
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v50
; GFX9-NEXT:    v_mov_b32_e32 v52, v15
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v51
; GFX9-NEXT:    v_mov_b32_e32 v53, v14
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v52
; GFX9-NEXT:    v_mov_b32_e32 v54, v13
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v53
; GFX9-NEXT:    v_mov_b32_e32 v55, v12
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v54
; GFX9-NEXT:    v_mov_b32_e32 v40, v11
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v55
; GFX9-NEXT:    v_mov_b32_e32 v41, v10
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v40
; GFX9-NEXT:    v_mov_b32_e32 v42, v9
; GFX9-NEXT:    v_mov_b32_e32 v43, v8
; GFX9-NEXT:    v_mov_b32_e32 v44, v7
; GFX9-NEXT:    v_mov_b32_e32 v45, v6
; GFX9-NEXT:    v_mov_b32_e32 v46, v5
; GFX9-NEXT:    v_mov_b32_e32 v47, v4
; GFX9-NEXT:    v_mov_b32_e32 v56, v3
; GFX9-NEXT:    v_mov_b32_e32 v57, v2
; GFX9-NEXT:    v_mov_b32_e32 v58, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v41
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v42
; GFX9-NEXT:    v_lshrrev_b32_e32 v63, 16, v43
; GFX9-NEXT:    v_lshrrev_b32_e32 v60, 16, v44
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v45
; GFX9-NEXT:    v_lshrrev_b32_e32 v61, 16, v46
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v47
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v56
; GFX9-NEXT:    v_lshrrev_b32_e32 v62, 16, v57
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v58
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v59
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB14_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 16, v42
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v41
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 16, v40
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 16, v55
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 16, v54
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v53
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 16, v52
; GFX9-NEXT:    v_lshrrev_b32_e32 v16, 16, v51
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 16, v50
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v49
; GFX9-NEXT:    v_lshrrev_b32_e32 v19, 16, v48
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v39
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v38
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v37
; GFX9-NEXT:    v_perm_b32 v0, v36, v59, s6
; GFX9-NEXT:    v_perm_b32 v1, v35, v58, s6
; GFX9-NEXT:    v_perm_b32 v2, v62, v57, s6
; GFX9-NEXT:    v_perm_b32 v3, v34, v56, s6
; GFX9-NEXT:    v_perm_b32 v4, v33, v47, s6
; GFX9-NEXT:    v_perm_b32 v5, v61, v46, s6
; GFX9-NEXT:    v_perm_b32 v6, v32, v45, s6
; GFX9-NEXT:    v_perm_b32 v7, v60, v44, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v43, s6
; GFX9-NEXT:    v_perm_b32 v9, v9, v42, s6
; GFX9-NEXT:    v_perm_b32 v10, v10, v41, s6
; GFX9-NEXT:    v_perm_b32 v11, v11, v40, s6
; GFX9-NEXT:    v_perm_b32 v12, v12, v55, s6
; GFX9-NEXT:    v_perm_b32 v13, v13, v54, s6
; GFX9-NEXT:    v_perm_b32 v14, v14, v53, s6
; GFX9-NEXT:    v_perm_b32 v15, v15, v52, s6
; GFX9-NEXT:    v_perm_b32 v16, v16, v51, s6
; GFX9-NEXT:    v_perm_b32 v17, v17, v50, s6
; GFX9-NEXT:    v_perm_b32 v18, v18, v49, s6
; GFX9-NEXT:    v_perm_b32 v19, v19, v48, s6
; GFX9-NEXT:    v_perm_b32 v20, v20, v39, s6
; GFX9-NEXT:    v_perm_b32 v21, v21, v38, s6
; GFX9-NEXT:    v_perm_b32 v22, v22, v37, s6
; GFX9-NEXT:    ; implicit-def: $vgpr59
; GFX9-NEXT:    ; implicit-def: $vgpr58
; GFX9-NEXT:    ; implicit-def: $vgpr57
; GFX9-NEXT:    ; implicit-def: $vgpr56
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr60
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr61
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr62
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v23, v24, v23, s6
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v24, v25, v24, s6
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v25, v26, v25, s6
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v26, v27, v26, s6
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v27, v28, v27, s6
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:  .LBB14_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB14_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v36, v59, s6
; GFX9-NEXT:    v_perm_b32 v1, v35, v58, s6
; GFX9-NEXT:    v_perm_b32 v2, v62, v57, s6
; GFX9-NEXT:    v_perm_b32 v3, v34, v56, s6
; GFX9-NEXT:    v_perm_b32 v4, v33, v47, s6
; GFX9-NEXT:    v_perm_b32 v5, v61, v46, s6
; GFX9-NEXT:    v_perm_b32 v6, v32, v45, s6
; GFX9-NEXT:    v_perm_b32 v7, v60, v44, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v43, s6
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(15)
; GFX9-NEXT:    v_perm_b32 v9, v9, v42, s6
; GFX9-NEXT:    s_waitcnt vmcnt(14)
; GFX9-NEXT:    v_perm_b32 v10, v10, v41, s6
; GFX9-NEXT:    s_waitcnt vmcnt(13)
; GFX9-NEXT:    v_perm_b32 v11, v11, v40, s6
; GFX9-NEXT:    s_waitcnt vmcnt(12)
; GFX9-NEXT:    v_perm_b32 v12, v12, v55, s6
; GFX9-NEXT:    s_waitcnt vmcnt(11)
; GFX9-NEXT:    v_perm_b32 v13, v13, v54, s6
; GFX9-NEXT:    s_waitcnt vmcnt(10)
; GFX9-NEXT:    v_perm_b32 v14, v14, v53, s6
; GFX9-NEXT:    s_waitcnt vmcnt(9)
; GFX9-NEXT:    v_perm_b32 v15, v15, v52, s6
; GFX9-NEXT:    s_waitcnt vmcnt(8)
; GFX9-NEXT:    v_perm_b32 v16, v16, v51, s6
; GFX9-NEXT:    s_waitcnt vmcnt(7)
; GFX9-NEXT:    v_perm_b32 v17, v17, v50, s6
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_perm_b32 v18, v18, v49, s6
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_perm_b32 v19, v19, v48, s6
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_perm_b32 v20, v20, v39, s6
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_perm_b32 v21, v21, v38, s6
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_perm_b32 v22, v22, v37, s6
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v23, v24, v23, s6
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GFX9-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v20, v20, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v21, v21, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v22, v22, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v23, v23, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v24, v25, v24, s6
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-NEXT:    v_pk_add_u16 v24, v24, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v25, v26, v25, s6
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-NEXT:    v_pk_add_u16 v25, v25, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v26, v27, v26, s6
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-NEXT:    v_pk_add_u16 v26, v26, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v27, v28, v27, s6
; GFX9-NEXT:    v_pk_add_u16 v27, v27, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB14_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v56i16_to_v28i32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB14_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v20, v20, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v21, v21, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v22, v22, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v23, v23, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v24, v24, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v25, v25, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v26, v26, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v27, v27, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:  .LBB14_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v56i16_to_v28i32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v50, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v53, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v54, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v65, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v66, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 16, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v80, 16, v3
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v28
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v69, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v70, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v71, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v80, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v68, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v67, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v66, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v65, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v64, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v55, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v54, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v53, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v52, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v51, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v50, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v49, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v48, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v39, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v38, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v37, v19, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v20, v36, v20, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v21, v35, v21, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v22, v34, v22, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v23, v33, v23, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v24, v32, v24, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v25, v31, v25, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v26, v30, v26, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v27, v29, v27, 0x5040100
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB14_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v20, v20, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v21, v21, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v22, v22, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v23, v23, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v24, v24, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v25, v25, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v26, v26, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v27, v27, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:  .LBB14_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <56 x i16> %a, splat (i16 3)
  %a2 = bitcast <56 x i16> %a1 to <28 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <56 x i16> %a to <28 x i32>
  br label %end

end:
  %phi = phi <28 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x i32> %phi
}

define inreg <28 x i32> @bitcast_v56i16_to_v28i32_scalar(<56 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v56i16_to_v28i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v49, v12
; SI-NEXT:    v_mov_b32_e32 v50, v10
; SI-NEXT:    v_mov_b32_e32 v51, v8
; SI-NEXT:    v_mov_b32_e32 v52, v6
; SI-NEXT:    v_mov_b32_e32 v53, v4
; SI-NEXT:    v_mov_b32_e32 v54, v2
; SI-NEXT:    v_mov_b32_e32 v55, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:44
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:4
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:16
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:12
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:24
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:20
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v48, off, s[0:3], s32 offset:28
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:40
; SI-NEXT:    buffer_load_dword v39, off, s[0:3], s32 offset:36
; SI-NEXT:    v_mov_b32_e32 v32, v26
; SI-NEXT:    v_mov_b32_e32 v33, v24
; SI-NEXT:    v_mov_b32_e32 v34, v22
; SI-NEXT:    v_mov_b32_e32 v35, v20
; SI-NEXT:    v_mov_b32_e32 v36, v18
; SI-NEXT:    v_mov_b32_e32 v37, v16
; SI-NEXT:    v_mov_b32_e32 v38, v14
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v11
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v62, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v44, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v43, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v60, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v59, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v58, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v57, 16, v25
; SI-NEXT:    v_lshlrev_b32_e32 v56, 16, v27
; SI-NEXT:    v_lshlrev_b32_e32 v47, 16, v29
; SI-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v46, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v45, 16, v4
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    s_waitcnt vmcnt(13)
; SI-NEXT:    v_lshlrev_b32_e32 v31, 16, v6
; SI-NEXT:    s_waitcnt vmcnt(11)
; SI-NEXT:    v_lshlrev_b32_e32 v61, 16, v8
; SI-NEXT:    s_waitcnt vmcnt(9)
; SI-NEXT:    v_lshlrev_b32_e32 v29, 16, v10
; SI-NEXT:    s_waitcnt vmcnt(7) expcnt(6)
; SI-NEXT:    v_lshlrev_b32_e32 v63, 16, v12
; SI-NEXT:    s_cbranch_scc0 .LBB15_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v55
; SI-NEXT:    v_or_b32_e32 v7, v0, v20
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v53
; SI-NEXT:    v_or_b32_e32 v9, v0, v16
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v52
; SI-NEXT:    v_or_b32_e32 v10, v0, v14
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v51
; SI-NEXT:    v_or_b32_e32 v11, v0, v5
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v50
; SI-NEXT:    v_or_b32_e32 v12, v0, v3
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v49
; SI-NEXT:    v_or_b32_e32 v13, v0, v62
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v38
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_or_b32_e32 v14, v0, v44
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v37
; SI-NEXT:    v_or_b32_e32 v15, v0, v43
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v36
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_or_b32_e32 v16, v0, v60
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v35
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v54
; SI-NEXT:    v_or_b32_e32 v17, v0, v59
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v34
; SI-NEXT:    v_or_b32_e32 v8, v1, v18
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_or_b32_e32 v18, v0, v58
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v33
; SI-NEXT:    v_or_b32_e32 v19, v0, v57
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v32
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_or_b32_e32 v20, v0, v56
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v28
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    v_or_b32_e32 v21, v0, v47
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v30
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    v_or_b32_e32 v22, v0, v46
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v42
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    v_or_b32_e32 v23, v0, v45
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v41
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    v_or_b32_e32 v24, v0, v31
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v40
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    v_or_b32_e32 v25, v0, v61
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v48
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_or_b32_e32 v26, v0, v29
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v39
; SI-NEXT:    s_or_b32 s10, s10, s11
; SI-NEXT:    v_or_b32_e32 v27, v0, v63
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    s_cbranch_execnz .LBB15_3
; SI-NEXT:  .LBB15_2: ; %cmp.true
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v55
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    s_or_b32 s10, s11, s10
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:    s_add_i32 s10, s10, 0x30000
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v54
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v8, vcc, 0x30000, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v53
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v9, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v52
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v10, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v51
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v11, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v50
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v12, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v49
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v62, v0
; SI-NEXT:    v_add_i32_e32 v13, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v38
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v44, v0
; SI-NEXT:    v_add_i32_e32 v14, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v37
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v43, v0
; SI-NEXT:    v_add_i32_e32 v15, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v36
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v60, v0
; SI-NEXT:    v_add_i32_e32 v16, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v35
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v59, v0
; SI-NEXT:    v_add_i32_e32 v17, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v34
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v58, v0
; SI-NEXT:    v_add_i32_e32 v18, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v33
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v57, v0
; SI-NEXT:    v_add_i32_e32 v19, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v32
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v56, v0
; SI-NEXT:    v_add_i32_e32 v20, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v28
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v47, v0
; SI-NEXT:    v_add_i32_e32 v21, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v30
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v46, v0
; SI-NEXT:    v_add_i32_e32 v22, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v42
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v45, v0
; SI-NEXT:    v_add_i32_e32 v23, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v41
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v31, v0
; SI-NEXT:    v_add_i32_e32 v24, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v40
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v61, v0
; SI-NEXT:    v_add_i32_e32 v25, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v48
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v29, v0
; SI-NEXT:    v_add_i32_e32 v26, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v39
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v63, v0
; SI-NEXT:    v_add_i32_e32 v27, vcc, 0x30000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:  .LBB15_3: ; %end
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB15_4:
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v59, v56
; SI-NEXT:    v_mov_b32_e32 v56, v45
; SI-NEXT:    v_mov_b32_e32 v45, v29
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v44, v41
; SI-NEXT:    s_waitcnt vmcnt(8)
; SI-NEXT:    v_mov_b32_e32 v41, v39
; SI-NEXT:    v_mov_b32_e32 v39, v36
; SI-NEXT:    v_mov_b32_e32 v36, v33
; SI-NEXT:    v_mov_b32_e32 v33, v30
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v43, v55
; SI-NEXT:    v_mov_b32_e32 v55, v54
; SI-NEXT:    v_mov_b32_e32 v54, v53
; SI-NEXT:    v_mov_b32_e32 v53, v52
; SI-NEXT:    v_mov_b32_e32 v52, v51
; SI-NEXT:    v_mov_b32_e32 v51, v50
; SI-NEXT:    v_mov_b32_e32 v50, v49
; SI-NEXT:    v_mov_b32_e32 v49, v42
; SI-NEXT:    v_mov_b32_e32 v42, v48
; SI-NEXT:    v_mov_b32_e32 v48, v37
; SI-NEXT:    v_mov_b32_e32 v37, v34
; SI-NEXT:    v_mov_b32_e32 v34, v28
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v62, v60
; SI-NEXT:    v_mov_b32_e32 v60, v57
; SI-NEXT:    v_mov_b32_e32 v57, v46
; SI-NEXT:    v_mov_b32_e32 v46, v61
; SI-NEXT:    v_mov_b32_e32 v61, v58
; SI-NEXT:    v_mov_b32_e32 v58, v47
; SI-NEXT:    v_mov_b32_e32 v47, v31
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    v_mov_b32_e32 v31, v47
; SI-NEXT:    v_mov_b32_e32 v47, v58
; SI-NEXT:    v_mov_b32_e32 v58, v61
; SI-NEXT:    v_mov_b32_e32 v61, v46
; SI-NEXT:    v_mov_b32_e32 v46, v57
; SI-NEXT:    v_mov_b32_e32 v57, v60
; SI-NEXT:    v_mov_b32_e32 v60, v62
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v28, v34
; SI-NEXT:    v_mov_b32_e32 v34, v37
; SI-NEXT:    v_mov_b32_e32 v37, v48
; SI-NEXT:    v_mov_b32_e32 v48, v42
; SI-NEXT:    v_mov_b32_e32 v42, v49
; SI-NEXT:    v_mov_b32_e32 v49, v50
; SI-NEXT:    v_mov_b32_e32 v50, v51
; SI-NEXT:    v_mov_b32_e32 v51, v52
; SI-NEXT:    v_mov_b32_e32 v52, v53
; SI-NEXT:    v_mov_b32_e32 v53, v54
; SI-NEXT:    v_mov_b32_e32 v54, v55
; SI-NEXT:    v_mov_b32_e32 v55, v43
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v30, v33
; SI-NEXT:    v_mov_b32_e32 v33, v36
; SI-NEXT:    v_mov_b32_e32 v36, v39
; SI-NEXT:    v_mov_b32_e32 v39, v41
; SI-NEXT:    v_mov_b32_e32 v41, v44
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v29, v45
; SI-NEXT:    v_mov_b32_e32 v45, v56
; SI-NEXT:    v_mov_b32_e32 v56, v59
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    s_branch .LBB15_2
;
; VI-LABEL: bitcast_v56i16_to_v28i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s6, s29, 16
; VI-NEXT:    s_lshr_b32 s7, s28, 16
; VI-NEXT:    s_lshr_b32 s8, s27, 16
; VI-NEXT:    s_lshr_b32 s9, s26, 16
; VI-NEXT:    s_lshr_b32 s10, s25, 16
; VI-NEXT:    s_lshr_b32 s11, s24, 16
; VI-NEXT:    s_lshr_b32 s12, s23, 16
; VI-NEXT:    s_lshr_b32 s13, s22, 16
; VI-NEXT:    s_lshr_b32 s14, s21, 16
; VI-NEXT:    s_lshr_b32 s15, s20, 16
; VI-NEXT:    s_lshr_b32 s40, s19, 16
; VI-NEXT:    s_lshr_b32 s41, s18, 16
; VI-NEXT:    s_lshr_b32 s42, s17, 16
; VI-NEXT:    s_lshr_b32 s43, s16, 16
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v32, v13
; VI-NEXT:    v_mov_b32_e32 v33, v12
; VI-NEXT:    v_mov_b32_e32 v34, v11
; VI-NEXT:    v_mov_b32_e32 v35, v10
; VI-NEXT:    v_mov_b32_e32 v36, v9
; VI-NEXT:    v_mov_b32_e32 v37, v8
; VI-NEXT:    v_mov_b32_e32 v38, v7
; VI-NEXT:    v_mov_b32_e32 v39, v6
; VI-NEXT:    v_mov_b32_e32 v48, v5
; VI-NEXT:    v_mov_b32_e32 v49, v4
; VI-NEXT:    v_mov_b32_e32 v50, v3
; VI-NEXT:    v_mov_b32_e32 v51, v2
; VI-NEXT:    v_mov_b32_e32 v52, v1
; VI-NEXT:    v_mov_b32_e32 v53, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    s_cbranch_scc0 .LBB15_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, 0xffff, s16
; VI-NEXT:    s_lshl_b32 s5, s43, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, 0xffff, s17
; VI-NEXT:    s_lshl_b32 s44, s42, 16
; VI-NEXT:    v_mov_b32_e32 v0, 16
; VI-NEXT:    s_or_b32 s5, s5, s44
; VI-NEXT:    s_and_b32 s44, 0xffff, s18
; VI-NEXT:    s_lshl_b32 s45, s41, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s44, s44, s45
; VI-NEXT:    s_and_b32 s45, 0xffff, s19
; VI-NEXT:    s_lshl_b32 s46, s40, 16
; VI-NEXT:    v_or_b32_sdwa v14, v53, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s45, s45, s46
; VI-NEXT:    s_and_b32 s46, 0xffff, s20
; VI-NEXT:    s_lshl_b32 s47, s15, 16
; VI-NEXT:    v_or_b32_sdwa v16, v51, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s46, s46, s47
; VI-NEXT:    s_and_b32 s47, 0xffff, s21
; VI-NEXT:    s_lshl_b32 s56, s14, 16
; VI-NEXT:    v_or_b32_sdwa v17, v50, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s47, s47, s56
; VI-NEXT:    s_and_b32 s56, 0xffff, s22
; VI-NEXT:    s_lshl_b32 s57, s13, 16
; VI-NEXT:    v_or_b32_sdwa v18, v49, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s56, s56, s57
; VI-NEXT:    s_and_b32 s57, 0xffff, s23
; VI-NEXT:    s_lshl_b32 s58, s12, 16
; VI-NEXT:    v_or_b32_sdwa v19, v48, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s57, s57, s58
; VI-NEXT:    s_and_b32 s58, 0xffff, s24
; VI-NEXT:    s_lshl_b32 s59, s11, 16
; VI-NEXT:    v_or_b32_sdwa v20, v39, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s58, s58, s59
; VI-NEXT:    s_and_b32 s59, 0xffff, s25
; VI-NEXT:    s_lshl_b32 s60, s10, 16
; VI-NEXT:    v_or_b32_sdwa v21, v38, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s59, s59, s60
; VI-NEXT:    s_and_b32 s60, 0xffff, s26
; VI-NEXT:    s_lshl_b32 s61, s9, 16
; VI-NEXT:    v_or_b32_sdwa v22, v37, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s60, s60, s61
; VI-NEXT:    s_and_b32 s61, 0xffff, s27
; VI-NEXT:    s_lshl_b32 s62, s8, 16
; VI-NEXT:    v_or_b32_sdwa v23, v36, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s61, s61, s62
; VI-NEXT:    s_and_b32 s62, 0xffff, s28
; VI-NEXT:    s_lshl_b32 s63, s7, 16
; VI-NEXT:    v_or_b32_sdwa v24, v35, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s62, s62, s63
; VI-NEXT:    s_and_b32 s63, 0xffff, s29
; VI-NEXT:    s_lshl_b32 s72, s6, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v0, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v25, v34, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v0, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s63, s63, s72
; VI-NEXT:    v_or_b32_sdwa v15, v52, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v26, v33, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v27, v32, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s44
; VI-NEXT:    v_mov_b32_e32 v3, s45
; VI-NEXT:    v_mov_b32_e32 v4, s46
; VI-NEXT:    v_mov_b32_e32 v5, s47
; VI-NEXT:    v_mov_b32_e32 v6, s56
; VI-NEXT:    v_mov_b32_e32 v7, s57
; VI-NEXT:    v_mov_b32_e32 v8, s58
; VI-NEXT:    v_mov_b32_e32 v9, s59
; VI-NEXT:    v_mov_b32_e32 v10, s60
; VI-NEXT:    v_mov_b32_e32 v11, s61
; VI-NEXT:    v_mov_b32_e32 v12, s62
; VI-NEXT:    v_mov_b32_e32 v13, s63
; VI-NEXT:    s_cbranch_execnz .LBB15_3
; VI-NEXT:  .LBB15_2: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v1, 16
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v53
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v52
; VI-NEXT:    v_lshlrev_b32_sdwa v3, v1, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v14, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v15, vcc, 0x30000, v2
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v51
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v16, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v50
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v17, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v49
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v18, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v48
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_and_b32 s4, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s43, 16
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    v_add_u32_e32 v19, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v39
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s17, 0xffff
; VI-NEXT:    s_lshl_b32 s16, s42, 16
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s5, s16, s5
; VI-NEXT:    s_and_b32 s16, s18, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s41, 16
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    v_add_u32_e32 v20, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v38
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s16, s17, s16
; VI-NEXT:    s_and_b32 s17, s19, 0xffff
; VI-NEXT:    s_lshl_b32 s18, s40, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s17, s18, s17
; VI-NEXT:    s_and_b32 s18, s20, 0xffff
; VI-NEXT:    s_lshl_b32 s15, s15, 16
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    v_add_u32_e32 v21, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v37
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s15, s15, s18
; VI-NEXT:    s_and_b32 s18, s21, 0xffff
; VI-NEXT:    s_lshl_b32 s14, s14, 16
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s14, s14, s18
; VI-NEXT:    s_and_b32 s18, s22, 0xffff
; VI-NEXT:    s_lshl_b32 s13, s13, 16
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    v_add_u32_e32 v22, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v36
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s13, s13, s18
; VI-NEXT:    s_and_b32 s18, s23, 0xffff
; VI-NEXT:    s_lshl_b32 s12, s12, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s12, s12, s18
; VI-NEXT:    s_and_b32 s18, s24, 0xffff
; VI-NEXT:    s_lshl_b32 s11, s11, 16
; VI-NEXT:    s_add_i32 s25, s25, 3
; VI-NEXT:    v_add_u32_e32 v23, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v35
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s11, s11, s18
; VI-NEXT:    s_and_b32 s18, s25, 0xffff
; VI-NEXT:    s_lshl_b32 s10, s10, 16
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s10, s10, s18
; VI-NEXT:    s_and_b32 s18, s26, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    s_add_i32 s27, s27, 3
; VI-NEXT:    v_add_u32_e32 v24, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v34
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s9, s9, s18
; VI-NEXT:    s_and_b32 s18, s27, 0xffff
; VI-NEXT:    s_lshl_b32 s8, s8, 16
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s8, s8, s18
; VI-NEXT:    s_and_b32 s18, s28, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_add_i32 s29, s29, 3
; VI-NEXT:    v_add_u32_e32 v25, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v33
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s7, s7, s18
; VI-NEXT:    s_and_b32 s18, s29, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s6, s6, s18
; VI-NEXT:    v_add_u32_e32 v26, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v32
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v1, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_add_i32 s4, s4, 0x30000
; VI-NEXT:    s_add_i32 s5, s5, 0x30000
; VI-NEXT:    s_add_i32 s16, s16, 0x30000
; VI-NEXT:    s_add_i32 s17, s17, 0x30000
; VI-NEXT:    s_add_i32 s15, s15, 0x30000
; VI-NEXT:    s_add_i32 s14, s14, 0x30000
; VI-NEXT:    s_add_i32 s13, s13, 0x30000
; VI-NEXT:    s_add_i32 s12, s12, 0x30000
; VI-NEXT:    s_add_i32 s11, s11, 0x30000
; VI-NEXT:    s_add_i32 s10, s10, 0x30000
; VI-NEXT:    s_add_i32 s9, s9, 0x30000
; VI-NEXT:    s_add_i32 s8, s8, 0x30000
; VI-NEXT:    s_add_i32 s7, s7, 0x30000
; VI-NEXT:    s_add_i32 s6, s6, 0x30000
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v27, vcc, 0x30000, v0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    v_mov_b32_e32 v3, s17
; VI-NEXT:    v_mov_b32_e32 v4, s15
; VI-NEXT:    v_mov_b32_e32 v5, s14
; VI-NEXT:    v_mov_b32_e32 v6, s13
; VI-NEXT:    v_mov_b32_e32 v7, s12
; VI-NEXT:    v_mov_b32_e32 v8, s11
; VI-NEXT:    v_mov_b32_e32 v9, s10
; VI-NEXT:    v_mov_b32_e32 v10, s9
; VI-NEXT:    v_mov_b32_e32 v11, s8
; VI-NEXT:    v_mov_b32_e32 v12, s7
; VI-NEXT:    v_mov_b32_e32 v13, s6
; VI-NEXT:  .LBB15_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB15_4:
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_branch .LBB15_2
;
; GFX9-LABEL: bitcast_v56i16_to_v28i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v13
; GFX9-NEXT:    v_mov_b32_e32 v33, v12
; GFX9-NEXT:    v_mov_b32_e32 v34, v11
; GFX9-NEXT:    v_mov_b32_e32 v35, v10
; GFX9-NEXT:    v_mov_b32_e32 v36, v9
; GFX9-NEXT:    v_mov_b32_e32 v37, v8
; GFX9-NEXT:    v_mov_b32_e32 v38, v7
; GFX9-NEXT:    v_mov_b32_e32 v39, v6
; GFX9-NEXT:    v_mov_b32_e32 v48, v5
; GFX9-NEXT:    v_mov_b32_e32 v49, v4
; GFX9-NEXT:    v_mov_b32_e32 v50, v3
; GFX9-NEXT:    v_mov_b32_e32 v51, v2
; GFX9-NEXT:    v_mov_b32_e32 v52, v1
; GFX9-NEXT:    v_mov_b32_e32 v53, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    s_lshr_b32 s40, s29, 16
; GFX9-NEXT:    s_lshr_b32 s41, s28, 16
; GFX9-NEXT:    s_lshr_b32 s42, s27, 16
; GFX9-NEXT:    s_lshr_b32 s43, s26, 16
; GFX9-NEXT:    s_lshr_b32 s15, s25, 16
; GFX9-NEXT:    s_lshr_b32 s14, s24, 16
; GFX9-NEXT:    s_lshr_b32 s13, s23, 16
; GFX9-NEXT:    s_lshr_b32 s12, s22, 16
; GFX9-NEXT:    s_lshr_b32 s11, s21, 16
; GFX9-NEXT:    s_lshr_b32 s10, s20, 16
; GFX9-NEXT:    s_lshr_b32 s9, s19, 16
; GFX9-NEXT:    s_lshr_b32 s8, s18, 16
; GFX9-NEXT:    s_lshr_b32 s7, s17, 16
; GFX9-NEXT:    s_lshr_b32 s6, s16, 16
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v36
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v37
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s16, s6
; GFX9-NEXT:    s_pack_ll_b32_b16 s7, s17, s7
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s18, s8
; GFX9-NEXT:    s_pack_ll_b32_b16 s9, s19, s9
; GFX9-NEXT:    s_pack_ll_b32_b16 s10, s20, s10
; GFX9-NEXT:    s_pack_ll_b32_b16 s11, s21, s11
; GFX9-NEXT:    s_pack_ll_b32_b16 s12, s22, s12
; GFX9-NEXT:    s_pack_ll_b32_b16 s13, s23, s13
; GFX9-NEXT:    s_pack_ll_b32_b16 s14, s24, s14
; GFX9-NEXT:    s_pack_ll_b32_b16 s15, s25, s15
; GFX9-NEXT:    s_pack_ll_b32_b16 s16, s26, s43
; GFX9-NEXT:    s_pack_ll_b32_b16 s17, s27, s42
; GFX9-NEXT:    s_pack_ll_b32_b16 s18, s28, s41
; GFX9-NEXT:    s_pack_ll_b32_b16 s19, s29, s40
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v38
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v39
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v48
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v49
; GFX9-NEXT:    v_lshrrev_b32_e32 v56, 16, v50
; GFX9-NEXT:    v_lshrrev_b32_e32 v57, 16, v51
; GFX9-NEXT:    v_lshrrev_b32_e32 v58, 16, v52
; GFX9-NEXT:    v_lshrrev_b32_e32 v59, 16, v53
; GFX9-NEXT:    s_cbranch_scc0 .LBB15_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v53
; GFX9-NEXT:    v_lshl_or_b32 v14, v59, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v52
; GFX9-NEXT:    v_lshl_or_b32 v15, v58, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v51
; GFX9-NEXT:    v_lshl_or_b32 v16, v57, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v50
; GFX9-NEXT:    v_lshl_or_b32 v17, v56, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v49
; GFX9-NEXT:    v_lshl_or_b32 v18, v47, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v48
; GFX9-NEXT:    v_lshl_or_b32 v19, v46, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v39
; GFX9-NEXT:    v_lshl_or_b32 v20, v45, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v38
; GFX9-NEXT:    v_lshl_or_b32 v21, v44, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v37
; GFX9-NEXT:    v_lshl_or_b32 v22, v43, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v36
; GFX9-NEXT:    v_lshl_or_b32 v23, v42, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v35
; GFX9-NEXT:    v_lshl_or_b32 v24, v41, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v34
; GFX9-NEXT:    v_lshl_or_b32 v25, v40, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v33
; GFX9-NEXT:    v_lshl_or_b32 v26, v55, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v32
; GFX9-NEXT:    v_lshl_or_b32 v27, v54, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:    v_mov_b32_e32 v6, s12
; GFX9-NEXT:    v_mov_b32_e32 v7, s13
; GFX9-NEXT:    v_mov_b32_e32 v8, s14
; GFX9-NEXT:    v_mov_b32_e32 v9, s15
; GFX9-NEXT:    v_mov_b32_e32 v10, s16
; GFX9-NEXT:    v_mov_b32_e32 v11, s17
; GFX9-NEXT:    v_mov_b32_e32 v12, s18
; GFX9-NEXT:    v_mov_b32_e32 v13, s19
; GFX9-NEXT:    s_cbranch_execnz .LBB15_3
; GFX9-NEXT:  .LBB15_2: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v14, 0xffff, v53
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v52
; GFX9-NEXT:    v_and_b32_e32 v16, 0xffff, v51
; GFX9-NEXT:    v_and_b32_e32 v17, 0xffff, v50
; GFX9-NEXT:    v_and_b32_e32 v18, 0xffff, v49
; GFX9-NEXT:    v_and_b32_e32 v19, 0xffff, v48
; GFX9-NEXT:    v_and_b32_e32 v20, 0xffff, v39
; GFX9-NEXT:    v_and_b32_e32 v21, 0xffff, v38
; GFX9-NEXT:    v_and_b32_e32 v22, 0xffff, v37
; GFX9-NEXT:    v_and_b32_e32 v23, 0xffff, v36
; GFX9-NEXT:    v_and_b32_e32 v24, 0xffff, v35
; GFX9-NEXT:    v_and_b32_e32 v25, 0xffff, v34
; GFX9-NEXT:    v_and_b32_e32 v26, 0xffff, v33
; GFX9-NEXT:    v_and_b32_e32 v27, 0xffff, v32
; GFX9-NEXT:    v_lshl_or_b32 v14, v59, 16, v14
; GFX9-NEXT:    v_lshl_or_b32 v15, v58, 16, v15
; GFX9-NEXT:    v_lshl_or_b32 v16, v57, 16, v16
; GFX9-NEXT:    v_lshl_or_b32 v17, v56, 16, v17
; GFX9-NEXT:    v_lshl_or_b32 v18, v47, 16, v18
; GFX9-NEXT:    v_lshl_or_b32 v19, v46, 16, v19
; GFX9-NEXT:    v_lshl_or_b32 v20, v45, 16, v20
; GFX9-NEXT:    v_lshl_or_b32 v21, v44, 16, v21
; GFX9-NEXT:    v_lshl_or_b32 v22, v43, 16, v22
; GFX9-NEXT:    v_lshl_or_b32 v23, v42, 16, v23
; GFX9-NEXT:    v_lshl_or_b32 v24, v41, 16, v24
; GFX9-NEXT:    v_lshl_or_b32 v25, v40, 16, v25
; GFX9-NEXT:    v_lshl_or_b32 v26, v55, 16, v26
; GFX9-NEXT:    v_lshl_or_b32 v27, v54, 16, v27
; GFX9-NEXT:    v_pk_add_u16 v0, s6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, s8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, s9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, s10, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, s11, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, s12, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v7, s13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, s14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v9, s15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v10, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v11, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v12, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, s19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v20, v20, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v21, v21, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v22, v22, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v23, v23, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v24, v24, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v25, v25, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v26, v26, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v27, v27, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB15_3: ; %end
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB15_4:
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_branch .LBB15_2
;
; GFX11-TRUE16-LABEL: bitcast_v56i16_to_v28i32_scalar:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.h, 0
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v10
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.l, v9.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.l, v8.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v34.l, v7.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v34.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v35.l, v6.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v35.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v36.l, v5.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v36.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v37.l, v4.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v37.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v38.l, v3.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v38.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v39.l, v2.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v39.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v48.l, v1.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v48.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v49.l, v0.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v49.h, v32.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v67, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v66, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v65, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v64, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v55, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v54, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v53, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v52, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v51, 0xffff, v8
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v50, 0xffff, v9
; GFX11-TRUE16-NEXT:    s_lshr_b32 s40, s29, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s41, s28, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s42, s27, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s14, s26, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s13, s25, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s12, s24, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s11, s23, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s10, s22, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s9, s21, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s8, s20, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s7, s19, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s6, s18, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s5, s17, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s4, s16, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s43, s3, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s44, s2, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s45, s1, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s46, s0, 16
; GFX11-TRUE16-NEXT:    s_mov_b32 s15, 0
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s0, s0, s46
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s1, s1, s45
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s2, s2, s44
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s43
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s4, s16, s4
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s5, s17, s5
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s6, s18, s6
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s7, s19, s7
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s8, s20, s8
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s9, s21, s9
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s10, s22, s10
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s11, s23, s11
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s12, s24, s12
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s13, s25, s13
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s14, s26, s14
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s16, s27, s42
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s17, s28, s41
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s18, s29, s40
; GFX11-TRUE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-TRUE16-NEXT:    s_cbranch_scc0 .LBB15_4
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v49, 16, v67
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v48, 16, v66
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v20, v39, 16, v65
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v21, v38, 16, v64
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v22, v37, 16, v55
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v23, v36, 16, v54
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v24, v35, 16, v53
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v25, v34, 16, v52
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v26, v33, 16, v51
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v27, v32, 16, v50
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v8, s8 :: v_dual_mov_b32 v9, s9
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v10, s10 :: v_dual_mov_b32 v11, s11
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v12, s12 :: v_dual_mov_b32 v13, s13
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v14, s14 :: v_dual_mov_b32 v15, s16
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v16, s17 :: v_dual_mov_b32 v17, s18
; GFX11-TRUE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s15
; GFX11-TRUE16-NEXT:    s_cbranch_vccnz .LBB15_3
; GFX11-TRUE16-NEXT:  .LBB15_2: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v49, 16, v67
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v48, 16, v66
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v20, v39, 16, v65
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v21, v38, 16, v64
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v22, v37, 16, v55
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v23, v36, 16, v54
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v24, v35, 16, v53
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v25, v34, 16, v52
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v26, v33, 16, v51
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v27, v32, 16, v50
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v4, s4, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v5, s5, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v6, s6, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v7, s7, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v8, s8, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v9, s9, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v10, s10, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v11, s11, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v12, s12, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v13, s13, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v14, s14, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v15, s16, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v16, s17, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v17, s18, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v20, v20, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v21, v21, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v22, v22, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v23, v23, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v24, v24, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v25, v25, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v26, v26, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v27, v27, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:  .LBB15_3: ; %end
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB15_4:
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-TRUE16-NEXT:    s_branch .LBB15_2
;
; GFX11-FAKE16-LABEL: bitcast_v56i16_to_v28i32_scalar:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v67, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v66, 0xffff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v65, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v64, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v55, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v54, 0xffff, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v53, 0xffff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v52, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v51, 0xffff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v50, 0xffff, v9
; GFX11-FAKE16-NEXT:    s_lshr_b32 s40, s29, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s41, s28, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s42, s27, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s14, s26, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s13, s25, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s12, s24, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s11, s23, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s10, s22, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s9, s21, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s8, s20, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s7, s19, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s6, s18, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s5, s17, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s4, s16, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s43, s3, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s44, s2, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s45, s1, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s46, s0, 16
; GFX11-FAKE16-NEXT:    s_mov_b32 s15, 0
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s0, s0, s46
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s1, s1, s45
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s2, s2, s44
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s43
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s4, s16, s4
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s5, s17, s5
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s6, s18, s6
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s7, s19, s7
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s8, s20, s8
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s9, s21, s9
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s10, s22, s10
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s11, s23, s11
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s12, s24, s12
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s13, s25, s13
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s14, s26, s14
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s16, s27, s42
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s17, s28, s41
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s18, s29, s40
; GFX11-FAKE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-FAKE16-NEXT:    s_cbranch_scc0 .LBB15_4
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v49, 16, v67
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v48, 16, v66
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v20, v39, 16, v65
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v21, v38, 16, v64
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v22, v37, 16, v55
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v23, v36, 16, v54
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v24, v35, 16, v53
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v25, v34, 16, v52
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v26, v33, 16, v51
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v27, v32, 16, v50
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v8, s8 :: v_dual_mov_b32 v9, s9
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v10, s10 :: v_dual_mov_b32 v11, s11
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v12, s12 :: v_dual_mov_b32 v13, s13
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v14, s14 :: v_dual_mov_b32 v15, s16
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v16, s17 :: v_dual_mov_b32 v17, s18
; GFX11-FAKE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s15
; GFX11-FAKE16-NEXT:    s_cbranch_vccnz .LBB15_3
; GFX11-FAKE16-NEXT:  .LBB15_2: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v49, 16, v67
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v48, 16, v66
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v20, v39, 16, v65
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v21, v38, 16, v64
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v22, v37, 16, v55
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v23, v36, 16, v54
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v24, v35, 16, v53
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v25, v34, 16, v52
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v26, v33, 16, v51
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v27, v32, 16, v50
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v4, s4, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v5, s5, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v6, s6, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v7, s7, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v8, s8, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v9, s9, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v10, s10, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v11, s11, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v12, s12, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v13, s13, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v14, s14, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v15, s16, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v16, s17, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v17, s18, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v20, v20, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v21, v21, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v22, v22, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v23, v23, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v24, v24, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v25, v25, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v26, v26, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v27, v27, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:  .LBB15_3: ; %end
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB15_4:
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-FAKE16-NEXT:    s_branch .LBB15_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <56 x i16> %a, splat (i16 3)
  %a2 = bitcast <56 x i16> %a1 to <28 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <56 x i16> %a to <28 x i32>
  br label %end

end:
  %phi = phi <28 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x i32> %phi
}

define <56 x half> @bitcast_v28i32_to_v56f16(<28 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v28i32_to_v56f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr63
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr61
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr62
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB16_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v35, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v27
; SI-NEXT:    v_cvt_f32_f16_e32 v33, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v25
; SI-NEXT:    v_cvt_f32_f16_e32 v43, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v24
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v62, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v61, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v59, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v22
; SI-NEXT:    buffer_store_dword v29, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v45, v27
; SI-NEXT:    buffer_store_dword v29, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v47, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v57, v25
; SI-NEXT:    buffer_store_dword v29, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v18
; SI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v23, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v29, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v42, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v44, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v46, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v56, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v58, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v60, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v63, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v32, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v34, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v36, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v38, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v48, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v51, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v53, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v55, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v41, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v28
; SI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v21, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v19, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    v_cvt_f32_f16_e32 v37, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v39, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v49, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v50, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v52, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v54, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v40, v1
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:  .LBB16_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB16_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_lshrrev_b32_e32 v57, 16, v21
; SI-NEXT:    v_lshrrev_b32_e32 v55, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v54, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v57
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_lshrrev_b32_e32 v47, 16, v20
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v47
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_lshrrev_b32_e32 v45, 16, v19
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v45
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v25
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_lshrrev_b32_e32 v41, 16, v1
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v51, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v32, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v63, 16, v11
; SI-NEXT:    v_lshrrev_b32_e32 v60, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v58, 16, v13
; SI-NEXT:    v_lshrrev_b32_e32 v56, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v46, 16, v15
; SI-NEXT:    v_lshrrev_b32_e32 v44, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v42, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v43, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v59, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v61, 16, v23
; SI-NEXT:    v_lshrrev_b32_e32 v62, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v27
; SI-NEXT:    v_lshrrev_b32_e32 v35, 16, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v27
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v25
; SI-NEXT:    v_cvt_f32_f16_e32 v40, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v37, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v39, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v49, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v50, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v52, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v35, v35
; SI-NEXT:    v_cvt_f32_f16_e32 v33, v33
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v31
; SI-NEXT:    v_cvt_f32_f16_e32 v62, v62
; SI-NEXT:    v_cvt_f32_f16_e32 v61, v61
; SI-NEXT:    v_cvt_f32_f16_e32 v59, v59
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v43
; SI-NEXT:    v_cvt_f32_f16_e32 v42, v42
; SI-NEXT:    v_cvt_f32_f16_e32 v44, v44
; SI-NEXT:    v_cvt_f32_f16_e32 v46, v46
; SI-NEXT:    v_cvt_f32_f16_e32 v56, v56
; SI-NEXT:    v_cvt_f32_f16_e32 v58, v58
; SI-NEXT:    v_cvt_f32_f16_e32 v60, v60
; SI-NEXT:    v_cvt_f32_f16_e32 v63, v63
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v30
; SI-NEXT:    v_cvt_f32_f16_e32 v32, v32
; SI-NEXT:    v_cvt_f32_f16_e32 v34, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v36, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v38, v38
; SI-NEXT:    v_cvt_f32_f16_e32 v48, v48
; SI-NEXT:    v_cvt_f32_f16_e32 v51, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v53, v53
; SI-NEXT:    v_cvt_f32_f16_e32 v55, v55
; SI-NEXT:    v_cvt_f32_f16_e32 v41, v41
; SI-NEXT:    v_mov_b32_e32 v29, v28
; SI-NEXT:    v_mov_b32_e32 v57, v25
; SI-NEXT:    v_mov_b32_e32 v47, v26
; SI-NEXT:    v_mov_b32_e32 v45, v27
; SI-NEXT:    v_mov_b32_e32 v43, v1
; SI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v23, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v21, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v19, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:  .LBB16_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v41
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v40
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v55
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v54
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v2, v4, v2
; SI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v53
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v52
; SI-NEXT:    v_add_i32_e32 v3, vcc, 8, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v51
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v50
; SI-NEXT:    v_add_i32_e32 v3, vcc, 12, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v48
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v49
; SI-NEXT:    v_add_i32_e32 v3, vcc, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v38
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v39
; SI-NEXT:    v_add_i32_e32 v3, vcc, 20, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v36
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v37
; SI-NEXT:    v_add_i32_e32 v3, vcc, 24, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v34
; SI-NEXT:    v_add_i32_e32 v3, vcc, 28, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v32
; SI-NEXT:    v_add_i32_e32 v3, vcc, 32, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v30
; SI-NEXT:    v_add_i32_e32 v3, vcc, 36, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v63
; SI-NEXT:    v_add_i32_e32 v3, vcc, 40, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v60
; SI-NEXT:    v_add_i32_e32 v3, vcc, 44, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v58
; SI-NEXT:    v_add_i32_e32 v3, vcc, 48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v56
; SI-NEXT:    v_add_i32_e32 v3, vcc, 52, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v46
; SI-NEXT:    v_add_i32_e32 v3, vcc, 56, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v44
; SI-NEXT:    v_add_i32_e32 v3, vcc, 60, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v42
; SI-NEXT:    v_add_i32_e32 v3, vcc, 64, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x44, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x48, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x4c, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x50, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v59
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x54, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v61
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x58, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v62
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x5c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v43
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v57
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x60, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v31
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v47
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x64, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v33
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v45
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x68, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v35
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v29
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x6c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v28i32_to_v56f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr47
; VI-NEXT:    ; implicit-def: $vgpr46
; VI-NEXT:    ; implicit-def: $vgpr45
; VI-NEXT:    ; implicit-def: $vgpr44
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB16_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; VI-NEXT:  .LBB16_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB16_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v27, vcc, 3, v27
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_add_u32_e32 v25, vcc, 3, v25
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_add_u32_e32 v23, vcc, 3, v23
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_add_u32_e32 v21, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; VI-NEXT:  .LBB16_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_lshlrev_b32_e32 v47, 16, v47
; VI-NEXT:    v_lshlrev_b32_e32 v46, 16, v46
; VI-NEXT:    v_lshlrev_b32_e32 v45, 16, v45
; VI-NEXT:    v_lshlrev_b32_e32 v44, 16, v44
; VI-NEXT:    v_lshlrev_b32_e32 v43, 16, v43
; VI-NEXT:    v_lshlrev_b32_e32 v42, 16, v42
; VI-NEXT:    v_lshlrev_b32_e32 v41, 16, v41
; VI-NEXT:    v_lshlrev_b32_e32 v40, 16, v40
; VI-NEXT:    v_or_b32_sdwa v0, v0, v47 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v46 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v45 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v44 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v43 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v42 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v41 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v40 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; VI-NEXT:    v_lshlrev_b32_e32 v55, 16, v55
; VI-NEXT:    v_lshlrev_b32_e32 v54, 16, v54
; VI-NEXT:    v_lshlrev_b32_e32 v53, 16, v53
; VI-NEXT:    v_lshlrev_b32_e32 v52, 16, v52
; VI-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; VI-NEXT:    v_lshlrev_b32_e32 v50, 16, v50
; VI-NEXT:    v_lshlrev_b32_e32 v49, 16, v49
; VI-NEXT:    v_lshlrev_b32_e32 v48, 16, v48
; VI-NEXT:    v_lshlrev_b32_e32 v39, 16, v39
; VI-NEXT:    v_lshlrev_b32_e32 v38, 16, v38
; VI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; VI-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; VI-NEXT:    v_lshlrev_b32_e32 v35, 16, v35
; VI-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; VI-NEXT:    v_lshlrev_b32_e32 v33, 16, v33
; VI-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; VI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; VI-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; VI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; VI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; VI-NEXT:    v_or_b32_sdwa v8, v8, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v9, v54 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v10, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v11, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v12, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v13, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v14, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v15, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v16, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v17, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v18, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v19, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v20, v20, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v21, v21, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v22, v22, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v23, v23, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v24, v24, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v25, v25, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v26, v26, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v27, v27, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v28i32_to_v56f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB16_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; GFX9-NEXT:  .LBB16_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB16_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v27, 3, v27
; GFX9-NEXT:    v_add_u32_e32 v26, 3, v26
; GFX9-NEXT:    v_add_u32_e32 v25, 3, v25
; GFX9-NEXT:    v_add_u32_e32 v24, 3, v24
; GFX9-NEXT:    v_add_u32_e32 v23, 3, v23
; GFX9-NEXT:    v_add_u32_e32 v22, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v21, 3, v21
; GFX9-NEXT:    v_add_u32_e32 v20, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; GFX9-NEXT:  .LBB16_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v47, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v46, v1, s4
; GFX9-NEXT:    v_perm_b32 v2, v45, v2, s4
; GFX9-NEXT:    v_perm_b32 v3, v44, v3, s4
; GFX9-NEXT:    v_perm_b32 v4, v43, v4, s4
; GFX9-NEXT:    v_perm_b32 v5, v42, v5, s4
; GFX9-NEXT:    v_perm_b32 v6, v41, v6, s4
; GFX9-NEXT:    v_perm_b32 v7, v40, v7, s4
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    v_perm_b32 v8, v55, v8, s4
; GFX9-NEXT:    v_perm_b32 v9, v54, v9, s4
; GFX9-NEXT:    v_perm_b32 v10, v53, v10, s4
; GFX9-NEXT:    v_perm_b32 v11, v52, v11, s4
; GFX9-NEXT:    v_perm_b32 v12, v51, v12, s4
; GFX9-NEXT:    v_perm_b32 v13, v50, v13, s4
; GFX9-NEXT:    v_perm_b32 v14, v49, v14, s4
; GFX9-NEXT:    v_perm_b32 v15, v48, v15, s4
; GFX9-NEXT:    v_perm_b32 v16, v39, v16, s4
; GFX9-NEXT:    v_perm_b32 v17, v38, v17, s4
; GFX9-NEXT:    v_perm_b32 v18, v37, v18, s4
; GFX9-NEXT:    v_perm_b32 v19, v36, v19, s4
; GFX9-NEXT:    v_perm_b32 v20, v35, v20, s4
; GFX9-NEXT:    v_perm_b32 v21, v34, v21, s4
; GFX9-NEXT:    v_perm_b32 v22, v33, v22, s4
; GFX9-NEXT:    v_perm_b32 v23, v32, v23, s4
; GFX9-NEXT:    v_perm_b32 v24, v31, v24, s4
; GFX9-NEXT:    v_perm_b32 v25, v30, v25, s4
; GFX9-NEXT:    v_perm_b32 v26, v29, v26, s4
; GFX9-NEXT:    v_perm_b32 v27, v28, v27, s4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v28i32_to_v56f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB16_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-TRUE16-NEXT:  .LBB16_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v28i32_to_v56f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr71
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr70
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr69
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr68
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr67
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr66
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr65
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr64
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr55
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr54
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr53
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr52
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr51
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr50
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr49
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr48
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB16_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v65, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v66, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v0
; GFX11-FAKE16-NEXT:  .LBB16_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB16_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v25, 3, v25
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v24, 3, v24
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v23, 3, v23
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v22, 3, v22
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v21, 3, v21
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v20, 3, v20
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v65, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v66, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v0
; GFX11-FAKE16-NEXT:  .LBB16_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v71, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v70, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v69, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v68, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v67, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v66, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v65, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v64, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v55, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v54, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v53, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v52, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v51, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v50, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v49, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v48, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v39, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v38, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v37, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v36, v19, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v20, v35, v20, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v21, v34, v21, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v22, v33, v22, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v23, v32, v23, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v24, v31, v24, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v25, v30, v25, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v26, v29, v26, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v27, v28, v27, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <28 x i32> %a, splat (i32 3)
  %a2 = bitcast <28 x i32> %a1 to <56 x half>
  br label %end

cmp.false:
  %a3 = bitcast <28 x i32> %a to <56 x half>
  br label %end

end:
  %phi = phi <56 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <56 x half> %phi
}

define inreg <56 x half> @bitcast_v28i32_to_v56f16_scalar(<28 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v28i32_to_v56f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v15
; SI-NEXT:    v_readfirstlane_b32 s43, v1
; SI-NEXT:    v_readfirstlane_b32 s42, v2
; SI-NEXT:    v_readfirstlane_b32 s41, v3
; SI-NEXT:    v_readfirstlane_b32 s40, v4
; SI-NEXT:    v_readfirstlane_b32 s15, v5
; SI-NEXT:    v_readfirstlane_b32 s14, v6
; SI-NEXT:    v_readfirstlane_b32 s13, v7
; SI-NEXT:    v_readfirstlane_b32 s12, v8
; SI-NEXT:    v_readfirstlane_b32 s11, v9
; SI-NEXT:    v_readfirstlane_b32 s10, v10
; SI-NEXT:    v_readfirstlane_b32 s8, v11
; SI-NEXT:    v_readfirstlane_b32 s7, v12
; SI-NEXT:    v_readfirstlane_b32 s6, v13
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_readfirstlane_b32 s9, v14
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_cbranch_scc0 .LBB17_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s9, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    s_lshr_b32 s4, s6, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s4
; SI-NEXT:    s_lshr_b32 s4, s7, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s8, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s10, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s4
; SI-NEXT:    s_lshr_b32 s4, s11, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s4
; SI-NEXT:    s_lshr_b32 s4, s12, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s4
; SI-NEXT:    s_lshr_b32 s4, s13, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s4
; SI-NEXT:    s_lshr_b32 s4, s14, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s4
; SI-NEXT:    s_lshr_b32 s4, s15, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v18, s4
; SI-NEXT:    s_lshr_b32 s4, s40, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v20, s4
; SI-NEXT:    s_lshr_b32 s4, s41, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v22, s4
; SI-NEXT:    s_lshr_b32 s4, s42, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v24, s4
; SI-NEXT:    s_lshr_b32 s4, s43, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v26, s4
; SI-NEXT:    s_lshr_b32 s4, s29, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v28, s4
; SI-NEXT:    s_lshr_b32 s4, s28, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v30, s4
; SI-NEXT:    s_lshr_b32 s4, s27, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v32, s4
; SI-NEXT:    s_lshr_b32 s4, s26, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v35, s4
; SI-NEXT:    s_lshr_b32 s4, s25, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v37, s4
; SI-NEXT:    s_lshr_b32 s4, s24, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v39, s4
; SI-NEXT:    s_lshr_b32 s4, s23, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v49, s4
; SI-NEXT:    s_lshr_b32 s4, s22, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v51, s4
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v53, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v55, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_cvt_f32_f16_e32 v42, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_cvt_f32_f16_e32 v44, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_cvt_f32_f16_e32 v46, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v56, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s9
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s6
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s8
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s10
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s11
; SI-NEXT:    v_cvt_f32_f16_e32 v16, s12
; SI-NEXT:    v_cvt_f32_f16_e32 v17, s13
; SI-NEXT:    v_cvt_f32_f16_e32 v19, s14
; SI-NEXT:    v_cvt_f32_f16_e32 v21, s15
; SI-NEXT:    v_cvt_f32_f16_e32 v23, s40
; SI-NEXT:    v_cvt_f32_f16_e32 v25, s41
; SI-NEXT:    v_cvt_f32_f16_e32 v27, s42
; SI-NEXT:    v_cvt_f32_f16_e32 v29, s43
; SI-NEXT:    v_cvt_f32_f16_e32 v31, s29
; SI-NEXT:    v_cvt_f32_f16_e32 v33, s28
; SI-NEXT:    v_cvt_f32_f16_e32 v34, s27
; SI-NEXT:    v_cvt_f32_f16_e32 v36, s26
; SI-NEXT:    v_cvt_f32_f16_e32 v38, s25
; SI-NEXT:    v_cvt_f32_f16_e32 v48, s24
; SI-NEXT:    v_cvt_f32_f16_e32 v50, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v52, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v54, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v40, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v41, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v43, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v45, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v47, s16
; SI-NEXT:    s_cbranch_execnz .LBB17_3
; SI-NEXT:  .LBB17_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_add_i32 s25, s25, 3
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_add_i32 s27, s27, 3
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_add_i32 s29, s29, 3
; SI-NEXT:    s_add_i32 s43, s43, 3
; SI-NEXT:    s_add_i32 s42, s42, 3
; SI-NEXT:    s_add_i32 s41, s41, 3
; SI-NEXT:    s_add_i32 s40, s40, 3
; SI-NEXT:    s_add_i32 s15, s15, 3
; SI-NEXT:    s_add_i32 s14, s14, 3
; SI-NEXT:    s_add_i32 s13, s13, 3
; SI-NEXT:    s_add_i32 s12, s12, 3
; SI-NEXT:    s_add_i32 s11, s11, 3
; SI-NEXT:    s_add_i32 s10, s10, 3
; SI-NEXT:    s_add_i32 s8, s8, 3
; SI-NEXT:    s_add_i32 s7, s7, 3
; SI-NEXT:    s_add_i32 s6, s6, 3
; SI-NEXT:    s_add_i32 s9, s9, 3
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    s_lshr_b32 s5, s17, 16
; SI-NEXT:    s_lshr_b32 s44, s18, 16
; SI-NEXT:    s_lshr_b32 s45, s19, 16
; SI-NEXT:    s_lshr_b32 s46, s20, 16
; SI-NEXT:    s_lshr_b32 s47, s21, 16
; SI-NEXT:    s_lshr_b32 s56, s22, 16
; SI-NEXT:    s_lshr_b32 s57, s23, 16
; SI-NEXT:    s_lshr_b32 s58, s24, 16
; SI-NEXT:    s_lshr_b32 s59, s25, 16
; SI-NEXT:    s_lshr_b32 s60, s26, 16
; SI-NEXT:    s_lshr_b32 s61, s27, 16
; SI-NEXT:    s_lshr_b32 s62, s28, 16
; SI-NEXT:    s_lshr_b32 s63, s29, 16
; SI-NEXT:    s_lshr_b32 s72, s43, 16
; SI-NEXT:    s_lshr_b32 s73, s42, 16
; SI-NEXT:    s_lshr_b32 s74, s41, 16
; SI-NEXT:    s_lshr_b32 s75, s40, 16
; SI-NEXT:    s_lshr_b32 s76, s15, 16
; SI-NEXT:    s_lshr_b32 s77, s14, 16
; SI-NEXT:    s_lshr_b32 s78, s13, 16
; SI-NEXT:    s_lshr_b32 s79, s12, 16
; SI-NEXT:    s_lshr_b32 s88, s11, 16
; SI-NEXT:    s_lshr_b32 s89, s10, 16
; SI-NEXT:    s_lshr_b32 s90, s8, 16
; SI-NEXT:    s_lshr_b32 s91, s7, 16
; SI-NEXT:    s_lshr_b32 s92, s6, 16
; SI-NEXT:    s_lshr_b32 s93, s9, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s9
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s6
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s8
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s10
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s11
; SI-NEXT:    v_cvt_f32_f16_e32 v16, s12
; SI-NEXT:    v_cvt_f32_f16_e32 v17, s13
; SI-NEXT:    v_cvt_f32_f16_e32 v19, s14
; SI-NEXT:    v_cvt_f32_f16_e32 v21, s15
; SI-NEXT:    v_cvt_f32_f16_e32 v23, s40
; SI-NEXT:    v_cvt_f32_f16_e32 v25, s41
; SI-NEXT:    v_cvt_f32_f16_e32 v27, s42
; SI-NEXT:    v_cvt_f32_f16_e32 v29, s43
; SI-NEXT:    v_cvt_f32_f16_e32 v31, s29
; SI-NEXT:    v_cvt_f32_f16_e32 v33, s28
; SI-NEXT:    v_cvt_f32_f16_e32 v34, s27
; SI-NEXT:    v_cvt_f32_f16_e32 v36, s26
; SI-NEXT:    v_cvt_f32_f16_e32 v38, s25
; SI-NEXT:    v_cvt_f32_f16_e32 v48, s24
; SI-NEXT:    v_cvt_f32_f16_e32 v50, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v52, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v54, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v40, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v41, s19
; SI-NEXT:    s_waitcnt expcnt(5)
; SI-NEXT:    v_cvt_f32_f16_e32 v43, s18
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_cvt_f32_f16_e32 v45, s17
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v47, s16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s93
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s92
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s91
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s90
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s89
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s88
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s79
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s78
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s77
; SI-NEXT:    v_cvt_f32_f16_e32 v18, s76
; SI-NEXT:    v_cvt_f32_f16_e32 v20, s75
; SI-NEXT:    v_cvt_f32_f16_e32 v22, s74
; SI-NEXT:    v_cvt_f32_f16_e32 v24, s73
; SI-NEXT:    v_cvt_f32_f16_e32 v26, s72
; SI-NEXT:    v_cvt_f32_f16_e32 v28, s63
; SI-NEXT:    v_cvt_f32_f16_e32 v30, s62
; SI-NEXT:    v_cvt_f32_f16_e32 v32, s61
; SI-NEXT:    v_cvt_f32_f16_e32 v35, s60
; SI-NEXT:    v_cvt_f32_f16_e32 v37, s59
; SI-NEXT:    v_cvt_f32_f16_e32 v39, s58
; SI-NEXT:    v_cvt_f32_f16_e32 v49, s57
; SI-NEXT:    v_cvt_f32_f16_e32 v51, s56
; SI-NEXT:    v_cvt_f32_f16_e32 v53, s47
; SI-NEXT:    v_cvt_f32_f16_e32 v55, s46
; SI-NEXT:    v_cvt_f32_f16_e32 v42, s45
; SI-NEXT:    v_cvt_f32_f16_e32 v44, s44
; SI-NEXT:    v_cvt_f32_f16_e32 v46, s5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v56, s4
; SI-NEXT:  .LBB17_3: ; %end
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v56, v56
; SI-NEXT:    v_cvt_f16_f32_e32 v47, v47
; SI-NEXT:    v_cvt_f16_f32_e32 v46, v46
; SI-NEXT:    v_cvt_f16_f32_e32 v45, v45
; SI-NEXT:    v_cvt_f16_f32_e32 v44, v44
; SI-NEXT:    v_cvt_f16_f32_e32 v43, v43
; SI-NEXT:    v_cvt_f16_f32_e32 v42, v42
; SI-NEXT:    v_lshlrev_b32_e32 v56, 16, v56
; SI-NEXT:    v_cvt_f16_f32_e32 v41, v41
; SI-NEXT:    v_cvt_f16_f32_e32 v55, v55
; SI-NEXT:    v_or_b32_e32 v47, v47, v56
; SI-NEXT:    v_lshlrev_b32_e32 v46, 16, v46
; SI-NEXT:    v_cvt_f16_f32_e32 v40, v40
; SI-NEXT:    v_cvt_f16_f32_e32 v53, v53
; SI-NEXT:    buffer_store_dword v47, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v47, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v45, v45, v46
; SI-NEXT:    v_lshlrev_b32_e32 v44, 16, v44
; SI-NEXT:    v_cvt_f16_f32_e32 v54, v54
; SI-NEXT:    v_cvt_f16_f32_e32 v51, v51
; SI-NEXT:    buffer_store_dword v45, v47, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v45, vcc, 8, v0
; SI-NEXT:    v_or_b32_e32 v43, v43, v44
; SI-NEXT:    v_lshlrev_b32_e32 v42, 16, v42
; SI-NEXT:    v_cvt_f16_f32_e32 v52, v52
; SI-NEXT:    v_cvt_f16_f32_e32 v49, v49
; SI-NEXT:    buffer_store_dword v43, v45, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v43, vcc, 12, v0
; SI-NEXT:    v_or_b32_e32 v41, v41, v42
; SI-NEXT:    v_lshlrev_b32_e32 v55, 16, v55
; SI-NEXT:    v_cvt_f16_f32_e32 v50, v50
; SI-NEXT:    v_cvt_f16_f32_e32 v39, v39
; SI-NEXT:    buffer_store_dword v41, v43, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v41, vcc, 16, v0
; SI-NEXT:    v_or_b32_e32 v55, v40, v55
; SI-NEXT:    v_lshlrev_b32_e32 v53, 16, v53
; SI-NEXT:    v_cvt_f16_f32_e32 v48, v48
; SI-NEXT:    v_cvt_f16_f32_e32 v37, v37
; SI-NEXT:    buffer_store_dword v55, v41, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v55, vcc, 20, v0
; SI-NEXT:    v_or_b32_e32 v53, v54, v53
; SI-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; SI-NEXT:    v_cvt_f16_f32_e32 v38, v38
; SI-NEXT:    v_cvt_f16_f32_e32 v35, v35
; SI-NEXT:    buffer_store_dword v53, v55, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v53, vcc, 24, v0
; SI-NEXT:    v_or_b32_e32 v51, v52, v51
; SI-NEXT:    v_lshlrev_b32_e32 v49, 16, v49
; SI-NEXT:    v_cvt_f16_f32_e32 v36, v36
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v32
; SI-NEXT:    buffer_store_dword v51, v53, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v51, vcc, 28, v0
; SI-NEXT:    v_or_b32_e32 v49, v50, v49
; SI-NEXT:    v_lshlrev_b32_e32 v39, 16, v39
; SI-NEXT:    v_cvt_f16_f32_e32 v34, v34
; SI-NEXT:    buffer_store_dword v49, v51, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v49, vcc, 32, v0
; SI-NEXT:    v_or_b32_e32 v39, v48, v39
; SI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; SI-NEXT:    buffer_store_dword v39, v49, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v39, vcc, 36, v0
; SI-NEXT:    v_or_b32_e32 v37, v38, v37
; SI-NEXT:    v_lshlrev_b32_e32 v35, 16, v35
; SI-NEXT:    buffer_store_dword v37, v39, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v37, vcc, 40, v0
; SI-NEXT:    v_or_b32_e32 v35, v36, v35
; SI-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; SI-NEXT:    buffer_store_dword v35, v37, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v35, vcc, 44, v0
; SI-NEXT:    v_or_b32_e32 v32, v34, v32
; SI-NEXT:    v_cvt_f16_f32_e32 v30, v30
; SI-NEXT:    buffer_store_dword v32, v35, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v33
; SI-NEXT:    v_add_i32_e32 v33, vcc, 48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; SI-NEXT:    v_or_b32_e32 v30, v32, v30
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v28
; SI-NEXT:    buffer_store_dword v30, v33, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v30, v31
; SI-NEXT:    v_add_i32_e32 v31, vcc, 52, v0
; SI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; SI-NEXT:    v_or_b32_e32 v28, v30, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v26
; SI-NEXT:    buffer_store_dword v28, v31, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v29
; SI-NEXT:    v_add_i32_e32 v29, vcc, 56, v0
; SI-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; SI-NEXT:    v_or_b32_e32 v26, v28, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v24
; SI-NEXT:    buffer_store_dword v26, v29, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v27
; SI-NEXT:    v_add_i32_e32 v27, vcc, 60, v0
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; SI-NEXT:    v_or_b32_e32 v24, v26, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v22
; SI-NEXT:    buffer_store_dword v24, v27, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v25
; SI-NEXT:    v_add_i32_e32 v25, vcc, 64, v0
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; SI-NEXT:    v_or_b32_e32 v22, v24, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v20
; SI-NEXT:    buffer_store_dword v22, v25, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v23
; SI-NEXT:    v_add_i32_e32 v23, vcc, 0x44, v0
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; SI-NEXT:    v_or_b32_e32 v20, v22, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    buffer_store_dword v20, v23, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v21
; SI-NEXT:    v_add_i32_e32 v21, vcc, 0x48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; SI-NEXT:    v_or_b32_e32 v18, v20, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    buffer_store_dword v18, v21, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v19
; SI-NEXT:    v_add_i32_e32 v19, vcc, 0x4c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; SI-NEXT:    v_or_b32_e32 v15, v18, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    buffer_store_dword v15, v19, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v17
; SI-NEXT:    v_add_i32_e32 v17, vcc, 0x50, v0
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_or_b32_e32 v13, v15, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    buffer_store_dword v13, v17, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 0x54, v0
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_or_b32_e32 v11, v13, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    buffer_store_dword v11, v15, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 0x58, v0
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_or_b32_e32 v9, v11, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    buffer_store_dword v9, v13, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 0x5c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    buffer_store_dword v7, v11, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 0x60, v0
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v7, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    buffer_store_dword v5, v9, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x64, v0
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    buffer_store_dword v3, v7, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x68, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    buffer_store_dword v2, v5, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v4
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x6c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB17_4:
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    s_branch .LBB17_2
;
; VI-LABEL: bitcast_v28i32_to_v56f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; VI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    s_mov_b64 exec, s[4:5]
; VI-NEXT:    v_writelane_b32 v28, s30, 0
; VI-NEXT:    v_writelane_b32 v28, s31, 1
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_writelane_b32 v28, s34, 2
; VI-NEXT:    v_readfirstlane_b32 s43, v0
; VI-NEXT:    v_readfirstlane_b32 s42, v1
; VI-NEXT:    v_readfirstlane_b32 s41, v2
; VI-NEXT:    v_readfirstlane_b32 s40, v3
; VI-NEXT:    v_readfirstlane_b32 s15, v4
; VI-NEXT:    v_readfirstlane_b32 s14, v5
; VI-NEXT:    v_readfirstlane_b32 s13, v6
; VI-NEXT:    v_readfirstlane_b32 s12, v7
; VI-NEXT:    v_readfirstlane_b32 s11, v8
; VI-NEXT:    v_readfirstlane_b32 s10, v9
; VI-NEXT:    v_readfirstlane_b32 s9, v10
; VI-NEXT:    v_readfirstlane_b32 s8, v11
; VI-NEXT:    v_readfirstlane_b32 s6, v12
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_readfirstlane_b32 s7, v13
; VI-NEXT:    v_writelane_b32 v28, s35, 3
; VI-NEXT:    s_cbranch_scc0 .LBB17_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s44, s7, 16
; VI-NEXT:    s_lshr_b32 s45, s6, 16
; VI-NEXT:    s_lshr_b32 s46, s8, 16
; VI-NEXT:    s_lshr_b32 s47, s9, 16
; VI-NEXT:    s_lshr_b32 s56, s10, 16
; VI-NEXT:    s_lshr_b32 s57, s11, 16
; VI-NEXT:    s_lshr_b32 s58, s12, 16
; VI-NEXT:    s_lshr_b32 s59, s13, 16
; VI-NEXT:    s_lshr_b32 s60, s14, 16
; VI-NEXT:    s_lshr_b32 s61, s15, 16
; VI-NEXT:    s_lshr_b32 s62, s40, 16
; VI-NEXT:    s_lshr_b32 s63, s41, 16
; VI-NEXT:    s_lshr_b32 s72, s42, 16
; VI-NEXT:    s_lshr_b32 s73, s43, 16
; VI-NEXT:    s_lshr_b32 s74, s29, 16
; VI-NEXT:    s_lshr_b32 s75, s28, 16
; VI-NEXT:    s_lshr_b32 s76, s27, 16
; VI-NEXT:    s_lshr_b32 s77, s26, 16
; VI-NEXT:    s_lshr_b32 s78, s25, 16
; VI-NEXT:    s_lshr_b32 s79, s24, 16
; VI-NEXT:    s_lshr_b32 s88, s23, 16
; VI-NEXT:    s_lshr_b32 s89, s22, 16
; VI-NEXT:    s_lshr_b32 s90, s21, 16
; VI-NEXT:    s_lshr_b32 s91, s20, 16
; VI-NEXT:    s_lshr_b32 s30, s19, 16
; VI-NEXT:    s_lshr_b32 s31, s18, 16
; VI-NEXT:    s_lshr_b32 s34, s17, 16
; VI-NEXT:    s_lshr_b32 s35, s16, 16
; VI-NEXT:    s_cbranch_execnz .LBB17_3
; VI-NEXT:  .LBB17_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s7, s7, 3
; VI-NEXT:    s_add_i32 s6, s6, 3
; VI-NEXT:    s_add_i32 s8, s8, 3
; VI-NEXT:    s_add_i32 s9, s9, 3
; VI-NEXT:    s_add_i32 s10, s10, 3
; VI-NEXT:    s_add_i32 s11, s11, 3
; VI-NEXT:    s_add_i32 s12, s12, 3
; VI-NEXT:    s_add_i32 s13, s13, 3
; VI-NEXT:    s_add_i32 s14, s14, 3
; VI-NEXT:    s_add_i32 s15, s15, 3
; VI-NEXT:    s_add_i32 s40, s40, 3
; VI-NEXT:    s_add_i32 s41, s41, 3
; VI-NEXT:    s_add_i32 s42, s42, 3
; VI-NEXT:    s_add_i32 s43, s43, 3
; VI-NEXT:    s_add_i32 s29, s29, 3
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    s_add_i32 s27, s27, 3
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_add_i32 s25, s25, 3
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_lshr_b32 s44, s7, 16
; VI-NEXT:    s_lshr_b32 s45, s6, 16
; VI-NEXT:    s_lshr_b32 s46, s8, 16
; VI-NEXT:    s_lshr_b32 s47, s9, 16
; VI-NEXT:    s_lshr_b32 s56, s10, 16
; VI-NEXT:    s_lshr_b32 s57, s11, 16
; VI-NEXT:    s_lshr_b32 s58, s12, 16
; VI-NEXT:    s_lshr_b32 s59, s13, 16
; VI-NEXT:    s_lshr_b32 s60, s14, 16
; VI-NEXT:    s_lshr_b32 s61, s15, 16
; VI-NEXT:    s_lshr_b32 s62, s40, 16
; VI-NEXT:    s_lshr_b32 s63, s41, 16
; VI-NEXT:    s_lshr_b32 s72, s42, 16
; VI-NEXT:    s_lshr_b32 s73, s43, 16
; VI-NEXT:    s_lshr_b32 s74, s29, 16
; VI-NEXT:    s_lshr_b32 s75, s28, 16
; VI-NEXT:    s_lshr_b32 s76, s27, 16
; VI-NEXT:    s_lshr_b32 s77, s26, 16
; VI-NEXT:    s_lshr_b32 s78, s25, 16
; VI-NEXT:    s_lshr_b32 s79, s24, 16
; VI-NEXT:    s_lshr_b32 s88, s23, 16
; VI-NEXT:    s_lshr_b32 s89, s22, 16
; VI-NEXT:    s_lshr_b32 s90, s21, 16
; VI-NEXT:    s_lshr_b32 s91, s20, 16
; VI-NEXT:    s_lshr_b32 s30, s19, 16
; VI-NEXT:    s_lshr_b32 s31, s18, 16
; VI-NEXT:    s_lshr_b32 s34, s17, 16
; VI-NEXT:    s_lshr_b32 s35, s16, 16
; VI-NEXT:  .LBB17_3: ; %end
; VI-NEXT:    s_and_b32 s4, 0xffff, s16
; VI-NEXT:    s_lshl_b32 s5, s35, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, 0xffff, s17
; VI-NEXT:    s_lshl_b32 s16, s34, 16
; VI-NEXT:    s_or_b32 s5, s5, s16
; VI-NEXT:    s_and_b32 s16, 0xffff, s18
; VI-NEXT:    s_lshl_b32 s17, s31, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    s_and_b32 s17, 0xffff, s19
; VI-NEXT:    s_lshl_b32 s18, s30, 16
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s18, 0xffff, s20
; VI-NEXT:    s_lshl_b32 s19, s91, 16
; VI-NEXT:    s_or_b32 s18, s18, s19
; VI-NEXT:    s_and_b32 s19, 0xffff, s21
; VI-NEXT:    s_lshl_b32 s20, s90, 16
; VI-NEXT:    s_or_b32 s19, s19, s20
; VI-NEXT:    s_and_b32 s20, 0xffff, s22
; VI-NEXT:    s_lshl_b32 s21, s89, 16
; VI-NEXT:    s_or_b32 s20, s20, s21
; VI-NEXT:    s_and_b32 s21, 0xffff, s23
; VI-NEXT:    s_lshl_b32 s22, s88, 16
; VI-NEXT:    s_or_b32 s21, s21, s22
; VI-NEXT:    s_and_b32 s22, 0xffff, s24
; VI-NEXT:    s_lshl_b32 s23, s79, 16
; VI-NEXT:    s_or_b32 s22, s22, s23
; VI-NEXT:    s_and_b32 s23, 0xffff, s25
; VI-NEXT:    s_lshl_b32 s24, s78, 16
; VI-NEXT:    s_or_b32 s23, s23, s24
; VI-NEXT:    s_and_b32 s24, 0xffff, s26
; VI-NEXT:    s_lshl_b32 s25, s77, 16
; VI-NEXT:    s_or_b32 s24, s24, s25
; VI-NEXT:    s_and_b32 s25, 0xffff, s27
; VI-NEXT:    s_lshl_b32 s26, s76, 16
; VI-NEXT:    s_or_b32 s25, s25, s26
; VI-NEXT:    s_and_b32 s26, 0xffff, s28
; VI-NEXT:    s_lshl_b32 s27, s75, 16
; VI-NEXT:    s_or_b32 s26, s26, s27
; VI-NEXT:    s_and_b32 s27, 0xffff, s29
; VI-NEXT:    s_lshl_b32 s28, s74, 16
; VI-NEXT:    s_or_b32 s27, s27, s28
; VI-NEXT:    s_and_b32 s28, 0xffff, s43
; VI-NEXT:    s_lshl_b32 s29, s73, 16
; VI-NEXT:    s_or_b32 s28, s28, s29
; VI-NEXT:    s_and_b32 s29, 0xffff, s42
; VI-NEXT:    s_lshl_b32 s42, s72, 16
; VI-NEXT:    s_or_b32 s29, s29, s42
; VI-NEXT:    s_and_b32 s41, 0xffff, s41
; VI-NEXT:    s_lshl_b32 s42, s63, 16
; VI-NEXT:    s_or_b32 s41, s41, s42
; VI-NEXT:    s_and_b32 s40, 0xffff, s40
; VI-NEXT:    s_lshl_b32 s42, s62, 16
; VI-NEXT:    s_or_b32 s40, s40, s42
; VI-NEXT:    s_and_b32 s15, 0xffff, s15
; VI-NEXT:    s_lshl_b32 s42, s61, 16
; VI-NEXT:    s_or_b32 s15, s15, s42
; VI-NEXT:    s_and_b32 s14, 0xffff, s14
; VI-NEXT:    s_lshl_b32 s42, s60, 16
; VI-NEXT:    s_or_b32 s14, s14, s42
; VI-NEXT:    s_and_b32 s13, 0xffff, s13
; VI-NEXT:    s_lshl_b32 s42, s59, 16
; VI-NEXT:    s_or_b32 s13, s13, s42
; VI-NEXT:    s_and_b32 s12, 0xffff, s12
; VI-NEXT:    s_lshl_b32 s42, s58, 16
; VI-NEXT:    s_or_b32 s12, s12, s42
; VI-NEXT:    s_and_b32 s11, 0xffff, s11
; VI-NEXT:    s_lshl_b32 s42, s57, 16
; VI-NEXT:    s_or_b32 s11, s11, s42
; VI-NEXT:    s_and_b32 s10, 0xffff, s10
; VI-NEXT:    s_lshl_b32 s42, s56, 16
; VI-NEXT:    s_or_b32 s10, s10, s42
; VI-NEXT:    s_and_b32 s9, 0xffff, s9
; VI-NEXT:    s_lshl_b32 s42, s47, 16
; VI-NEXT:    s_or_b32 s9, s9, s42
; VI-NEXT:    s_and_b32 s8, 0xffff, s8
; VI-NEXT:    s_lshl_b32 s42, s46, 16
; VI-NEXT:    s_or_b32 s8, s8, s42
; VI-NEXT:    s_and_b32 s6, 0xffff, s6
; VI-NEXT:    s_lshl_b32 s42, s45, 16
; VI-NEXT:    s_or_b32 s6, s6, s42
; VI-NEXT:    s_and_b32 s7, 0xffff, s7
; VI-NEXT:    s_lshl_b32 s42, s44, 16
; VI-NEXT:    s_or_b32 s7, s7, s42
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    v_mov_b32_e32 v3, s17
; VI-NEXT:    v_mov_b32_e32 v4, s18
; VI-NEXT:    v_mov_b32_e32 v5, s19
; VI-NEXT:    v_mov_b32_e32 v6, s20
; VI-NEXT:    v_mov_b32_e32 v7, s21
; VI-NEXT:    v_mov_b32_e32 v8, s22
; VI-NEXT:    v_mov_b32_e32 v9, s23
; VI-NEXT:    v_mov_b32_e32 v10, s24
; VI-NEXT:    v_mov_b32_e32 v11, s25
; VI-NEXT:    v_mov_b32_e32 v12, s26
; VI-NEXT:    v_mov_b32_e32 v13, s27
; VI-NEXT:    v_mov_b32_e32 v14, s28
; VI-NEXT:    v_mov_b32_e32 v15, s29
; VI-NEXT:    v_mov_b32_e32 v16, s41
; VI-NEXT:    v_mov_b32_e32 v17, s40
; VI-NEXT:    v_mov_b32_e32 v18, s15
; VI-NEXT:    v_mov_b32_e32 v19, s14
; VI-NEXT:    v_mov_b32_e32 v20, s13
; VI-NEXT:    v_mov_b32_e32 v21, s12
; VI-NEXT:    v_mov_b32_e32 v22, s11
; VI-NEXT:    v_mov_b32_e32 v23, s10
; VI-NEXT:    v_mov_b32_e32 v24, s9
; VI-NEXT:    v_mov_b32_e32 v25, s8
; VI-NEXT:    v_mov_b32_e32 v26, s6
; VI-NEXT:    v_mov_b32_e32 v27, s7
; VI-NEXT:    v_readlane_b32 s35, v28, 3
; VI-NEXT:    v_readlane_b32 s34, v28, 2
; VI-NEXT:    v_readlane_b32 s31, v28, 1
; VI-NEXT:    v_readlane_b32 s30, v28, 0
; VI-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; VI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    s_mov_b64 exec, s[4:5]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB17_4:
; VI-NEXT:    ; implicit-def: $sgpr35
; VI-NEXT:    ; implicit-def: $sgpr34
; VI-NEXT:    ; implicit-def: $sgpr31
; VI-NEXT:    ; implicit-def: $sgpr30
; VI-NEXT:    ; implicit-def: $sgpr91
; VI-NEXT:    ; implicit-def: $sgpr90
; VI-NEXT:    ; implicit-def: $sgpr89
; VI-NEXT:    ; implicit-def: $sgpr88
; VI-NEXT:    ; implicit-def: $sgpr79
; VI-NEXT:    ; implicit-def: $sgpr78
; VI-NEXT:    ; implicit-def: $sgpr77
; VI-NEXT:    ; implicit-def: $sgpr76
; VI-NEXT:    ; implicit-def: $sgpr75
; VI-NEXT:    ; implicit-def: $sgpr74
; VI-NEXT:    ; implicit-def: $sgpr73
; VI-NEXT:    ; implicit-def: $sgpr72
; VI-NEXT:    ; implicit-def: $sgpr63
; VI-NEXT:    ; implicit-def: $sgpr62
; VI-NEXT:    ; implicit-def: $sgpr61
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr59
; VI-NEXT:    ; implicit-def: $sgpr58
; VI-NEXT:    ; implicit-def: $sgpr57
; VI-NEXT:    ; implicit-def: $sgpr56
; VI-NEXT:    ; implicit-def: $sgpr47
; VI-NEXT:    ; implicit-def: $sgpr46
; VI-NEXT:    ; implicit-def: $sgpr45
; VI-NEXT:    ; implicit-def: $sgpr44
; VI-NEXT:    s_branch .LBB17_2
;
; GFX9-LABEL: bitcast_v28i32_to_v56f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    v_readfirstlane_b32 s6, v0
; GFX9-NEXT:    v_readfirstlane_b32 s7, v1
; GFX9-NEXT:    v_readfirstlane_b32 s8, v2
; GFX9-NEXT:    v_readfirstlane_b32 s9, v3
; GFX9-NEXT:    v_readfirstlane_b32 s10, v4
; GFX9-NEXT:    v_readfirstlane_b32 s11, v5
; GFX9-NEXT:    v_readfirstlane_b32 s12, v6
; GFX9-NEXT:    v_readfirstlane_b32 s13, v7
; GFX9-NEXT:    v_readfirstlane_b32 s14, v8
; GFX9-NEXT:    v_readfirstlane_b32 s15, v9
; GFX9-NEXT:    v_readfirstlane_b32 s40, v10
; GFX9-NEXT:    v_readfirstlane_b32 s41, v11
; GFX9-NEXT:    v_readfirstlane_b32 s42, v12
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_readfirstlane_b32 s43, v13
; GFX9-NEXT:    s_cbranch_scc0 .LBB17_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s44, s43, 16
; GFX9-NEXT:    s_lshr_b32 s45, s42, 16
; GFX9-NEXT:    s_lshr_b32 s46, s41, 16
; GFX9-NEXT:    s_lshr_b32 s47, s40, 16
; GFX9-NEXT:    s_lshr_b32 s56, s15, 16
; GFX9-NEXT:    s_lshr_b32 s57, s14, 16
; GFX9-NEXT:    s_lshr_b32 s58, s13, 16
; GFX9-NEXT:    s_lshr_b32 s59, s12, 16
; GFX9-NEXT:    s_lshr_b32 s60, s11, 16
; GFX9-NEXT:    s_lshr_b32 s61, s10, 16
; GFX9-NEXT:    s_lshr_b32 s62, s9, 16
; GFX9-NEXT:    s_lshr_b32 s63, s8, 16
; GFX9-NEXT:    s_lshr_b32 s72, s7, 16
; GFX9-NEXT:    s_lshr_b32 s73, s6, 16
; GFX9-NEXT:    s_lshr_b32 s74, s29, 16
; GFX9-NEXT:    s_lshr_b32 s75, s28, 16
; GFX9-NEXT:    s_lshr_b32 s76, s27, 16
; GFX9-NEXT:    s_lshr_b32 s77, s26, 16
; GFX9-NEXT:    s_lshr_b32 s78, s25, 16
; GFX9-NEXT:    s_lshr_b32 s79, s24, 16
; GFX9-NEXT:    s_lshr_b32 s88, s23, 16
; GFX9-NEXT:    s_lshr_b32 s89, s22, 16
; GFX9-NEXT:    s_lshr_b32 s90, s21, 16
; GFX9-NEXT:    s_lshr_b32 s91, s20, 16
; GFX9-NEXT:    s_lshr_b32 s92, s19, 16
; GFX9-NEXT:    s_lshr_b32 s93, s18, 16
; GFX9-NEXT:    s_lshr_b32 s94, s17, 16
; GFX9-NEXT:    s_lshr_b32 s95, s16, 16
; GFX9-NEXT:    s_cbranch_execnz .LBB17_3
; GFX9-NEXT:  .LBB17_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s43, s43, 3
; GFX9-NEXT:    s_add_i32 s42, s42, 3
; GFX9-NEXT:    s_add_i32 s41, s41, 3
; GFX9-NEXT:    s_add_i32 s40, s40, 3
; GFX9-NEXT:    s_add_i32 s15, s15, 3
; GFX9-NEXT:    s_add_i32 s14, s14, 3
; GFX9-NEXT:    s_add_i32 s13, s13, 3
; GFX9-NEXT:    s_add_i32 s12, s12, 3
; GFX9-NEXT:    s_add_i32 s11, s11, 3
; GFX9-NEXT:    s_add_i32 s10, s10, 3
; GFX9-NEXT:    s_add_i32 s9, s9, 3
; GFX9-NEXT:    s_add_i32 s8, s8, 3
; GFX9-NEXT:    s_add_i32 s7, s7, 3
; GFX9-NEXT:    s_add_i32 s6, s6, 3
; GFX9-NEXT:    s_add_i32 s29, s29, 3
; GFX9-NEXT:    s_add_i32 s28, s28, 3
; GFX9-NEXT:    s_add_i32 s27, s27, 3
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    s_add_i32 s25, s25, 3
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_add_i32 s23, s23, 3
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_lshr_b32 s44, s43, 16
; GFX9-NEXT:    s_lshr_b32 s45, s42, 16
; GFX9-NEXT:    s_lshr_b32 s46, s41, 16
; GFX9-NEXT:    s_lshr_b32 s47, s40, 16
; GFX9-NEXT:    s_lshr_b32 s56, s15, 16
; GFX9-NEXT:    s_lshr_b32 s57, s14, 16
; GFX9-NEXT:    s_lshr_b32 s58, s13, 16
; GFX9-NEXT:    s_lshr_b32 s59, s12, 16
; GFX9-NEXT:    s_lshr_b32 s60, s11, 16
; GFX9-NEXT:    s_lshr_b32 s61, s10, 16
; GFX9-NEXT:    s_lshr_b32 s62, s9, 16
; GFX9-NEXT:    s_lshr_b32 s63, s8, 16
; GFX9-NEXT:    s_lshr_b32 s72, s7, 16
; GFX9-NEXT:    s_lshr_b32 s73, s6, 16
; GFX9-NEXT:    s_lshr_b32 s74, s29, 16
; GFX9-NEXT:    s_lshr_b32 s75, s28, 16
; GFX9-NEXT:    s_lshr_b32 s76, s27, 16
; GFX9-NEXT:    s_lshr_b32 s77, s26, 16
; GFX9-NEXT:    s_lshr_b32 s78, s25, 16
; GFX9-NEXT:    s_lshr_b32 s79, s24, 16
; GFX9-NEXT:    s_lshr_b32 s88, s23, 16
; GFX9-NEXT:    s_lshr_b32 s89, s22, 16
; GFX9-NEXT:    s_lshr_b32 s90, s21, 16
; GFX9-NEXT:    s_lshr_b32 s91, s20, 16
; GFX9-NEXT:    s_lshr_b32 s92, s19, 16
; GFX9-NEXT:    s_lshr_b32 s93, s18, 16
; GFX9-NEXT:    s_lshr_b32 s94, s17, 16
; GFX9-NEXT:    s_lshr_b32 s95, s16, 16
; GFX9-NEXT:  .LBB17_3: ; %end
; GFX9-NEXT:    s_pack_ll_b32_b16 s4, s16, s95
; GFX9-NEXT:    s_pack_ll_b32_b16 s5, s17, s94
; GFX9-NEXT:    s_pack_ll_b32_b16 s16, s18, s93
; GFX9-NEXT:    s_pack_ll_b32_b16 s17, s19, s92
; GFX9-NEXT:    s_pack_ll_b32_b16 s18, s20, s91
; GFX9-NEXT:    s_pack_ll_b32_b16 s19, s21, s90
; GFX9-NEXT:    s_pack_ll_b32_b16 s20, s22, s89
; GFX9-NEXT:    s_pack_ll_b32_b16 s21, s23, s88
; GFX9-NEXT:    s_pack_ll_b32_b16 s22, s24, s79
; GFX9-NEXT:    s_pack_ll_b32_b16 s23, s25, s78
; GFX9-NEXT:    s_pack_ll_b32_b16 s24, s26, s77
; GFX9-NEXT:    s_pack_ll_b32_b16 s25, s27, s76
; GFX9-NEXT:    s_pack_ll_b32_b16 s26, s28, s75
; GFX9-NEXT:    s_pack_ll_b32_b16 s27, s29, s74
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s6, s73
; GFX9-NEXT:    s_pack_ll_b32_b16 s7, s7, s72
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s8, s63
; GFX9-NEXT:    s_pack_ll_b32_b16 s9, s9, s62
; GFX9-NEXT:    s_pack_ll_b32_b16 s10, s10, s61
; GFX9-NEXT:    s_pack_ll_b32_b16 s11, s11, s60
; GFX9-NEXT:    s_pack_ll_b32_b16 s12, s12, s59
; GFX9-NEXT:    s_pack_ll_b32_b16 s13, s13, s58
; GFX9-NEXT:    s_pack_ll_b32_b16 s14, s14, s57
; GFX9-NEXT:    s_pack_ll_b32_b16 s15, s15, s56
; GFX9-NEXT:    s_pack_ll_b32_b16 s28, s40, s47
; GFX9-NEXT:    s_pack_ll_b32_b16 s29, s41, s46
; GFX9-NEXT:    s_pack_ll_b32_b16 s40, s42, s45
; GFX9-NEXT:    s_pack_ll_b32_b16 s41, s43, s44
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s16
; GFX9-NEXT:    v_mov_b32_e32 v3, s17
; GFX9-NEXT:    v_mov_b32_e32 v4, s18
; GFX9-NEXT:    v_mov_b32_e32 v5, s19
; GFX9-NEXT:    v_mov_b32_e32 v6, s20
; GFX9-NEXT:    v_mov_b32_e32 v7, s21
; GFX9-NEXT:    v_mov_b32_e32 v8, s22
; GFX9-NEXT:    v_mov_b32_e32 v9, s23
; GFX9-NEXT:    v_mov_b32_e32 v10, s24
; GFX9-NEXT:    v_mov_b32_e32 v11, s25
; GFX9-NEXT:    v_mov_b32_e32 v12, s26
; GFX9-NEXT:    v_mov_b32_e32 v13, s27
; GFX9-NEXT:    v_mov_b32_e32 v14, s6
; GFX9-NEXT:    v_mov_b32_e32 v15, s7
; GFX9-NEXT:    v_mov_b32_e32 v16, s8
; GFX9-NEXT:    v_mov_b32_e32 v17, s9
; GFX9-NEXT:    v_mov_b32_e32 v18, s10
; GFX9-NEXT:    v_mov_b32_e32 v19, s11
; GFX9-NEXT:    v_mov_b32_e32 v20, s12
; GFX9-NEXT:    v_mov_b32_e32 v21, s13
; GFX9-NEXT:    v_mov_b32_e32 v22, s14
; GFX9-NEXT:    v_mov_b32_e32 v23, s15
; GFX9-NEXT:    v_mov_b32_e32 v24, s28
; GFX9-NEXT:    v_mov_b32_e32 v25, s29
; GFX9-NEXT:    v_mov_b32_e32 v26, s40
; GFX9-NEXT:    v_mov_b32_e32 v27, s41
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB17_4:
; GFX9-NEXT:    ; implicit-def: $sgpr95
; GFX9-NEXT:    ; implicit-def: $sgpr94
; GFX9-NEXT:    ; implicit-def: $sgpr93
; GFX9-NEXT:    ; implicit-def: $sgpr92
; GFX9-NEXT:    ; implicit-def: $sgpr91
; GFX9-NEXT:    ; implicit-def: $sgpr90
; GFX9-NEXT:    ; implicit-def: $sgpr89
; GFX9-NEXT:    ; implicit-def: $sgpr88
; GFX9-NEXT:    ; implicit-def: $sgpr79
; GFX9-NEXT:    ; implicit-def: $sgpr78
; GFX9-NEXT:    ; implicit-def: $sgpr77
; GFX9-NEXT:    ; implicit-def: $sgpr76
; GFX9-NEXT:    ; implicit-def: $sgpr75
; GFX9-NEXT:    ; implicit-def: $sgpr74
; GFX9-NEXT:    ; implicit-def: $sgpr73
; GFX9-NEXT:    ; implicit-def: $sgpr72
; GFX9-NEXT:    ; implicit-def: $sgpr63
; GFX9-NEXT:    ; implicit-def: $sgpr62
; GFX9-NEXT:    ; implicit-def: $sgpr61
; GFX9-NEXT:    ; implicit-def: $sgpr60
; GFX9-NEXT:    ; implicit-def: $sgpr59
; GFX9-NEXT:    ; implicit-def: $sgpr58
; GFX9-NEXT:    ; implicit-def: $sgpr57
; GFX9-NEXT:    ; implicit-def: $sgpr56
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr46
; GFX9-NEXT:    ; implicit-def: $sgpr45
; GFX9-NEXT:    ; implicit-def: $sgpr44
; GFX9-NEXT:    s_branch .LBB17_2
;
; GFX11-LABEL: bitcast_v28i32_to_v56f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v10
; GFX11-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_readfirstlane_b32 s6, v2
; GFX11-NEXT:    v_readfirstlane_b32 s7, v3
; GFX11-NEXT:    v_readfirstlane_b32 s8, v4
; GFX11-NEXT:    v_readfirstlane_b32 s9, v5
; GFX11-NEXT:    v_readfirstlane_b32 s10, v6
; GFX11-NEXT:    v_readfirstlane_b32 s11, v7
; GFX11-NEXT:    v_readfirstlane_b32 s13, v8
; GFX11-NEXT:    v_readfirstlane_b32 s12, v9
; GFX11-NEXT:    s_mov_b32 s90, 0
; GFX11-NEXT:    s_and_b32 s14, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB17_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s14, s12, 16
; GFX11-NEXT:    s_lshr_b32 s15, s13, 16
; GFX11-NEXT:    s_lshr_b32 s40, s11, 16
; GFX11-NEXT:    s_lshr_b32 s41, s10, 16
; GFX11-NEXT:    s_lshr_b32 s42, s9, 16
; GFX11-NEXT:    s_lshr_b32 s43, s8, 16
; GFX11-NEXT:    s_lshr_b32 s44, s7, 16
; GFX11-NEXT:    s_lshr_b32 s45, s6, 16
; GFX11-NEXT:    s_lshr_b32 s46, s5, 16
; GFX11-NEXT:    s_lshr_b32 s47, s4, 16
; GFX11-NEXT:    s_lshr_b32 s56, s29, 16
; GFX11-NEXT:    s_lshr_b32 s57, s28, 16
; GFX11-NEXT:    s_lshr_b32 s58, s27, 16
; GFX11-NEXT:    s_lshr_b32 s59, s26, 16
; GFX11-NEXT:    s_lshr_b32 s60, s25, 16
; GFX11-NEXT:    s_lshr_b32 s61, s24, 16
; GFX11-NEXT:    s_lshr_b32 s62, s23, 16
; GFX11-NEXT:    s_lshr_b32 s63, s22, 16
; GFX11-NEXT:    s_lshr_b32 s72, s21, 16
; GFX11-NEXT:    s_lshr_b32 s73, s20, 16
; GFX11-NEXT:    s_lshr_b32 s74, s19, 16
; GFX11-NEXT:    s_lshr_b32 s75, s18, 16
; GFX11-NEXT:    s_lshr_b32 s76, s17, 16
; GFX11-NEXT:    s_lshr_b32 s77, s16, 16
; GFX11-NEXT:    s_lshr_b32 s78, s3, 16
; GFX11-NEXT:    s_lshr_b32 s79, s2, 16
; GFX11-NEXT:    s_lshr_b32 s88, s1, 16
; GFX11-NEXT:    s_lshr_b32 s89, s0, 16
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s90
; GFX11-NEXT:    s_cbranch_vccnz .LBB17_3
; GFX11-NEXT:  .LBB17_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s12, s12, 3
; GFX11-NEXT:    s_add_i32 s13, s13, 3
; GFX11-NEXT:    s_add_i32 s11, s11, 3
; GFX11-NEXT:    s_add_i32 s10, s10, 3
; GFX11-NEXT:    s_add_i32 s9, s9, 3
; GFX11-NEXT:    s_add_i32 s8, s8, 3
; GFX11-NEXT:    s_add_i32 s7, s7, 3
; GFX11-NEXT:    s_add_i32 s6, s6, 3
; GFX11-NEXT:    s_add_i32 s5, s5, 3
; GFX11-NEXT:    s_add_i32 s4, s4, 3
; GFX11-NEXT:    s_add_i32 s29, s29, 3
; GFX11-NEXT:    s_add_i32 s28, s28, 3
; GFX11-NEXT:    s_add_i32 s27, s27, 3
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    s_add_i32 s25, s25, 3
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    s_add_i32 s23, s23, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_add_i32 s21, s21, 3
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_lshr_b32 s14, s12, 16
; GFX11-NEXT:    s_lshr_b32 s15, s13, 16
; GFX11-NEXT:    s_lshr_b32 s40, s11, 16
; GFX11-NEXT:    s_lshr_b32 s41, s10, 16
; GFX11-NEXT:    s_lshr_b32 s42, s9, 16
; GFX11-NEXT:    s_lshr_b32 s43, s8, 16
; GFX11-NEXT:    s_lshr_b32 s44, s7, 16
; GFX11-NEXT:    s_lshr_b32 s45, s6, 16
; GFX11-NEXT:    s_lshr_b32 s46, s5, 16
; GFX11-NEXT:    s_lshr_b32 s47, s4, 16
; GFX11-NEXT:    s_lshr_b32 s56, s29, 16
; GFX11-NEXT:    s_lshr_b32 s57, s28, 16
; GFX11-NEXT:    s_lshr_b32 s58, s27, 16
; GFX11-NEXT:    s_lshr_b32 s59, s26, 16
; GFX11-NEXT:    s_lshr_b32 s60, s25, 16
; GFX11-NEXT:    s_lshr_b32 s61, s24, 16
; GFX11-NEXT:    s_lshr_b32 s62, s23, 16
; GFX11-NEXT:    s_lshr_b32 s63, s22, 16
; GFX11-NEXT:    s_lshr_b32 s72, s21, 16
; GFX11-NEXT:    s_lshr_b32 s73, s20, 16
; GFX11-NEXT:    s_lshr_b32 s74, s19, 16
; GFX11-NEXT:    s_lshr_b32 s75, s18, 16
; GFX11-NEXT:    s_lshr_b32 s76, s17, 16
; GFX11-NEXT:    s_lshr_b32 s77, s16, 16
; GFX11-NEXT:    s_lshr_b32 s78, s3, 16
; GFX11-NEXT:    s_lshr_b32 s79, s2, 16
; GFX11-NEXT:    s_lshr_b32 s88, s1, 16
; GFX11-NEXT:    s_lshr_b32 s89, s0, 16
; GFX11-NEXT:  .LBB17_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_pack_ll_b32_b16 s0, s0, s89
; GFX11-NEXT:    s_pack_ll_b32_b16 s1, s1, s88
; GFX11-NEXT:    s_pack_ll_b32_b16 s2, s2, s79
; GFX11-NEXT:    s_pack_ll_b32_b16 s3, s3, s78
; GFX11-NEXT:    s_pack_ll_b32_b16 s16, s16, s77
; GFX11-NEXT:    s_pack_ll_b32_b16 s17, s17, s76
; GFX11-NEXT:    s_pack_ll_b32_b16 s18, s18, s75
; GFX11-NEXT:    s_pack_ll_b32_b16 s19, s19, s74
; GFX11-NEXT:    s_pack_ll_b32_b16 s20, s20, s73
; GFX11-NEXT:    s_pack_ll_b32_b16 s21, s21, s72
; GFX11-NEXT:    s_pack_ll_b32_b16 s22, s22, s63
; GFX11-NEXT:    s_pack_ll_b32_b16 s23, s23, s62
; GFX11-NEXT:    s_pack_ll_b32_b16 s24, s24, s61
; GFX11-NEXT:    s_pack_ll_b32_b16 s25, s25, s60
; GFX11-NEXT:    s_pack_ll_b32_b16 s26, s26, s59
; GFX11-NEXT:    s_pack_ll_b32_b16 s27, s27, s58
; GFX11-NEXT:    s_pack_ll_b32_b16 s28, s28, s57
; GFX11-NEXT:    s_pack_ll_b32_b16 s29, s29, s56
; GFX11-NEXT:    s_pack_ll_b32_b16 s4, s4, s47
; GFX11-NEXT:    s_pack_ll_b32_b16 s5, s5, s46
; GFX11-NEXT:    s_pack_ll_b32_b16 s6, s6, s45
; GFX11-NEXT:    s_pack_ll_b32_b16 s7, s7, s44
; GFX11-NEXT:    s_pack_ll_b32_b16 s8, s8, s43
; GFX11-NEXT:    s_pack_ll_b32_b16 s9, s9, s42
; GFX11-NEXT:    s_pack_ll_b32_b16 s10, s10, s41
; GFX11-NEXT:    s_pack_ll_b32_b16 s11, s11, s40
; GFX11-NEXT:    s_pack_ll_b32_b16 s13, s13, s15
; GFX11-NEXT:    s_pack_ll_b32_b16 s12, s12, s14
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v16, s28 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_dual_mov_b32 v18, s4 :: v_dual_mov_b32 v19, s5
; GFX11-NEXT:    v_dual_mov_b32 v20, s6 :: v_dual_mov_b32 v21, s7
; GFX11-NEXT:    v_dual_mov_b32 v22, s8 :: v_dual_mov_b32 v23, s9
; GFX11-NEXT:    v_dual_mov_b32 v24, s10 :: v_dual_mov_b32 v25, s11
; GFX11-NEXT:    v_dual_mov_b32 v26, s13 :: v_dual_mov_b32 v27, s12
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB17_4:
; GFX11-NEXT:    ; implicit-def: $sgpr89
; GFX11-NEXT:    ; implicit-def: $sgpr88
; GFX11-NEXT:    ; implicit-def: $sgpr79
; GFX11-NEXT:    ; implicit-def: $sgpr78
; GFX11-NEXT:    ; implicit-def: $sgpr77
; GFX11-NEXT:    ; implicit-def: $sgpr76
; GFX11-NEXT:    ; implicit-def: $sgpr75
; GFX11-NEXT:    ; implicit-def: $sgpr74
; GFX11-NEXT:    ; implicit-def: $sgpr73
; GFX11-NEXT:    ; implicit-def: $sgpr72
; GFX11-NEXT:    ; implicit-def: $sgpr63
; GFX11-NEXT:    ; implicit-def: $sgpr62
; GFX11-NEXT:    ; implicit-def: $sgpr61
; GFX11-NEXT:    ; implicit-def: $sgpr60
; GFX11-NEXT:    ; implicit-def: $sgpr59
; GFX11-NEXT:    ; implicit-def: $sgpr58
; GFX11-NEXT:    ; implicit-def: $sgpr57
; GFX11-NEXT:    ; implicit-def: $sgpr56
; GFX11-NEXT:    ; implicit-def: $sgpr47
; GFX11-NEXT:    ; implicit-def: $sgpr46
; GFX11-NEXT:    ; implicit-def: $sgpr45
; GFX11-NEXT:    ; implicit-def: $sgpr44
; GFX11-NEXT:    ; implicit-def: $sgpr43
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr41
; GFX11-NEXT:    ; implicit-def: $sgpr40
; GFX11-NEXT:    ; implicit-def: $sgpr15
; GFX11-NEXT:    ; implicit-def: $sgpr14
; GFX11-NEXT:    s_branch .LBB17_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <28 x i32> %a, splat (i32 3)
  %a2 = bitcast <28 x i32> %a1 to <56 x half>
  br label %end

cmp.false:
  %a3 = bitcast <28 x i32> %a to <56 x half>
  br label %end

end:
  %phi = phi <56 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <56 x half> %phi
}

define <28 x i32> @bitcast_v56f16_to_v28i32(<56 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v56f16_to_v28i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    v_cvt_f16_f32_e32 v46, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v6
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:8
; SI-NEXT:    s_waitcnt expcnt(5)
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:24
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:20
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:28
; SI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:40
; SI-NEXT:    buffer_load_dword v34, off, s[0:3], s32 offset:36
; SI-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:48
; SI-NEXT:    buffer_load_dword v36, off, s[0:3], s32 offset:44
; SI-NEXT:    buffer_load_dword v37, off, s[0:3], s32 offset:56
; SI-NEXT:    buffer_load_dword v38, off, s[0:3], s32 offset:52
; SI-NEXT:    buffer_load_dword v39, off, s[0:3], s32 offset:64
; SI-NEXT:    buffer_load_dword v48, off, s[0:3], s32 offset:60
; SI-NEXT:    buffer_load_dword v49, off, s[0:3], s32 offset:72
; SI-NEXT:    buffer_load_dword v50, off, s[0:3], s32 offset:68
; SI-NEXT:    buffer_load_dword v51, off, s[0:3], s32 offset:80
; SI-NEXT:    buffer_load_dword v52, off, s[0:3], s32 offset:76
; SI-NEXT:    buffer_load_dword v53, off, s[0:3], s32 offset:88
; SI-NEXT:    buffer_load_dword v54, off, s[0:3], s32 offset:84
; SI-NEXT:    buffer_load_dword v55, off, s[0:3], s32 offset:96
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:92
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:100
; SI-NEXT:    v_cvt_f16_f32_e32 v47, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v45, v3
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v44, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v43, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v42, v4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v41, v7
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v11
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v10
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v13
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v12
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v15
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v14
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v17
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v16
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v19
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_cvt_f16_f32_e32 v56, v56
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v18
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v21
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v48, v48
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v23
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v22
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v25
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v24
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v27
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v26
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v29
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v28
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v30
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v57
; SI-NEXT:    v_cvt_f16_f32_e32 v57, v39
; SI-NEXT:    v_cvt_f16_f32_e32 v39, v49
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v58
; SI-NEXT:    v_cvt_f16_f32_e32 v58, v38
; SI-NEXT:    v_cvt_f16_f32_e32 v38, v50
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v59
; SI-NEXT:    v_cvt_f16_f32_e32 v59, v37
; SI-NEXT:    v_cvt_f16_f32_e32 v37, v51
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v60
; SI-NEXT:    v_cvt_f16_f32_e32 v60, v36
; SI-NEXT:    v_cvt_f16_f32_e32 v36, v52
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v61
; SI-NEXT:    v_cvt_f16_f32_e32 v61, v35
; SI-NEXT:    v_cvt_f16_f32_e32 v35, v53
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v62
; SI-NEXT:    v_cvt_f16_f32_e32 v62, v34
; SI-NEXT:    v_cvt_f16_f32_e32 v34, v54
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v63
; SI-NEXT:    v_cvt_f16_f32_e32 v63, v33
; SI-NEXT:    v_cvt_f16_f32_e32 v33, v55
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v32
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v40
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB18_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:292 ; 4-byte Folded Reload
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v41
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v47
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v45
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v43
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v61
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v59
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v57
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v39
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v37
; SI-NEXT:    v_lshlrev_b32_e32 v26, 16, v35
; SI-NEXT:    v_lshlrev_b32_e32 v27, 16, v33
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    v_or_b32_e32 v0, v46, v0
; SI-NEXT:    v_or_b32_e32 v1, v44, v1
; SI-NEXT:    v_or_b32_e32 v2, v42, v2
; SI-NEXT:    v_or_b32_e32 v21, v60, v21
; SI-NEXT:    v_or_b32_e32 v22, v58, v22
; SI-NEXT:    v_or_b32_e32 v23, v48, v23
; SI-NEXT:    v_or_b32_e32 v24, v38, v24
; SI-NEXT:    v_or_b32_e32 v25, v36, v25
; SI-NEXT:    v_or_b32_e32 v26, v34, v26
; SI-NEXT:    v_or_b32_e32 v27, v32, v27
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr61
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:284 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:276 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:268 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:288 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:280 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:272 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:264 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_or_b32_e32 v9, v10, v9
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, v11, v10
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_or_b32_e32 v12, v13, v12
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_or_b32_e32 v13, v14, v13
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v56
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; SI-NEXT:    v_or_b32_e32 v16, v17, v16
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    v_or_b32_e32 v17, v18, v17
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; SI-NEXT:    v_or_b32_e32 v18, v19, v18
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; SI-NEXT:    v_or_b32_e32 v19, v20, v19
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v63
; SI-NEXT:    v_or_b32_e32 v20, v62, v20
; SI-NEXT:    ; implicit-def: $vgpr63
; SI-NEXT:    ; implicit-def: $vgpr62
; SI-NEXT:  .LBB18_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB18_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:292 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v47
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v45
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v46
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v44
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v43
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v42
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v56
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v61
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v41
; SI-NEXT:    v_add_f32_e32 v22, 0x38000000, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v60
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v58
; SI-NEXT:    v_add_f32_e32 v23, 0x38000000, v23
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v23
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_add_f32_e32 v24, 0x38000000, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v39
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v38
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v33
; SI-NEXT:    v_add_f32_e32 v25, 0x38000000, v25
; SI-NEXT:    v_cvt_f16_f32_e32 v25, v25
; SI-NEXT:    v_add_f32_e32 v26, 0x38000000, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v26
; SI-NEXT:    v_add_f32_e32 v27, 0x38000000, v27
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v27
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v32
; SI-NEXT:    v_add_f32_e32 v28, 0x38000000, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v28
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:284 ; 4-byte Folded Reload
; SI-NEXT:    v_add_f32_e32 v29, 0x38000000, v29
; SI-NEXT:    v_cvt_f16_f32_e32 v29, v29
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:276 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:268 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:288 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    s_waitcnt vmcnt(13)
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    s_waitcnt vmcnt(12)
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    s_waitcnt vmcnt(11)
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    s_waitcnt vmcnt(9)
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    s_waitcnt vmcnt(8)
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v19
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_add_f32_e32 v19, 0x38000000, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:280 ; 4-byte Folded Reload
; SI-NEXT:    v_add_f32_e32 v21, 0x38000000, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v21
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:272 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:264 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_or_b32_e32 v9, v10, v9
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, v11, v10
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_or_b32_e32 v12, v13, v12
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_or_b32_e32 v13, v14, v13
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v16
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; SI-NEXT:    v_or_b32_e32 v15, v17, v15
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v18
; SI-NEXT:    v_add_f32_e32 v18, 0x38000000, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; SI-NEXT:    v_or_b32_e32 v16, v18, v16
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v18
; SI-NEXT:    v_add_f32_e32 v18, 0x38000000, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    v_or_b32_e32 v17, v18, v17
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v19
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v20
; SI-NEXT:    v_add_f32_e32 v20, 0x38000000, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v20
; SI-NEXT:    v_or_b32_e32 v18, v20, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v63
; SI-NEXT:    v_add_f32_e32 v20, 0x38000000, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v20
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v19
; SI-NEXT:    v_add_f32_e32 v19, 0x38000000, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; SI-NEXT:    v_or_b32_e32 v19, v21, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v62
; SI-NEXT:    v_add_f32_e32 v21, 0x38000000, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v21
; SI-NEXT:    v_or_b32_e32 v20, v21, v20
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v59
; SI-NEXT:    v_or_b32_e32 v21, v23, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v57
; SI-NEXT:    v_add_f32_e32 v22, 0x38000000, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v22
; SI-NEXT:    v_add_f32_e32 v23, 0x38000000, v23
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v23
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; SI-NEXT:    v_or_b32_e32 v22, v24, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v48
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; SI-NEXT:    v_add_f32_e32 v24, 0x38000000, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v24
; SI-NEXT:    v_or_b32_e32 v23, v24, v23
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v37
; SI-NEXT:    v_or_b32_e32 v24, v26, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v35
; SI-NEXT:    v_add_f32_e32 v25, 0x38000000, v25
; SI-NEXT:    v_cvt_f16_f32_e32 v25, v25
; SI-NEXT:    v_add_f32_e32 v26, 0x38000000, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v26
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; SI-NEXT:    v_or_b32_e32 v25, v27, v25
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v34
; SI-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; SI-NEXT:    v_add_f32_e32 v27, 0x38000000, v27
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v27
; SI-NEXT:    v_or_b32_e32 v26, v27, v26
; SI-NEXT:    v_lshlrev_b32_e32 v27, 16, v28
; SI-NEXT:    v_or_b32_e32 v27, v29, v27
; SI-NEXT:  .LBB18_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v56f16_to_v28i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    v_mov_b32_e32 v32, v27
; VI-NEXT:    v_mov_b32_e32 v33, v26
; VI-NEXT:    v_mov_b32_e32 v34, v25
; VI-NEXT:    v_mov_b32_e32 v35, v24
; VI-NEXT:    v_mov_b32_e32 v36, v23
; VI-NEXT:    v_mov_b32_e32 v37, v22
; VI-NEXT:    v_mov_b32_e32 v38, v21
; VI-NEXT:    v_mov_b32_e32 v39, v20
; VI-NEXT:    v_mov_b32_e32 v48, v19
; VI-NEXT:    v_mov_b32_e32 v49, v18
; VI-NEXT:    v_mov_b32_e32 v50, v17
; VI-NEXT:    v_mov_b32_e32 v51, v16
; VI-NEXT:    v_mov_b32_e32 v52, v15
; VI-NEXT:    v_mov_b32_e32 v53, v14
; VI-NEXT:    v_mov_b32_e32 v54, v13
; VI-NEXT:    v_mov_b32_e32 v55, v12
; VI-NEXT:    v_mov_b32_e32 v40, v11
; VI-NEXT:    v_mov_b32_e32 v41, v10
; VI-NEXT:    v_mov_b32_e32 v42, v9
; VI-NEXT:    v_mov_b32_e32 v43, v8
; VI-NEXT:    v_mov_b32_e32 v44, v7
; VI-NEXT:    v_mov_b32_e32 v45, v6
; VI-NEXT:    v_mov_b32_e32 v46, v5
; VI-NEXT:    v_mov_b32_e32 v47, v4
; VI-NEXT:    v_mov_b32_e32 v56, v3
; VI-NEXT:    v_mov_b32_e32 v57, v2
; VI-NEXT:    v_mov_b32_e32 v58, v1
; VI-NEXT:    v_mov_b32_e32 v59, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB18_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_mov_b32_e32 v27, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v27, v59 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v27, v58 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v27, v57 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v3, v27, v56 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v4, v27, v47 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v5, v27, v46 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v6, v27, v45 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v7, v27, v44 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v8, v27, v43 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v9, v27, v42 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v10, v27, v41 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v11, v27, v40 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v12, v27, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v13, v27, v54 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v14, v27, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v15, v27, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v16, v27, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v17, v27, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v18, v27, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v19, v27, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v20, v27, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v21, v27, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v22, v27, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v23, v27, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v24, v27, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v25, v27, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v26, v27, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v27, v27, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v59, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v58, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v57, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v56, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v47, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v46, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v45, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v44, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v43, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v42, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v41, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v40, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v55, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v54, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v53, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v52, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v51, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v50, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v49, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v48, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v20, v39, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v21, v38, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v22, v37, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v23, v36, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v24, v35, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v25, v34, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v26, v33, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v27, v32, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr59
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    ; implicit-def: $vgpr57
; VI-NEXT:    ; implicit-def: $vgpr56
; VI-NEXT:    ; implicit-def: $vgpr47
; VI-NEXT:    ; implicit-def: $vgpr46
; VI-NEXT:    ; implicit-def: $vgpr45
; VI-NEXT:    ; implicit-def: $vgpr44
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:  .LBB18_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB18_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v27, 0x200
; VI-NEXT:    v_add_f16_sdwa v0, v59, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v59
; VI-NEXT:    v_add_f16_sdwa v2, v58, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v58
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    v_or_b32_e32 v1, v3, v2
; VI-NEXT:    v_add_f16_sdwa v2, v57, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v57
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_add_f16_sdwa v3, v56, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v56
; VI-NEXT:    v_or_b32_e32 v3, v4, v3
; VI-NEXT:    v_add_f16_sdwa v4, v47, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v47
; VI-NEXT:    v_or_b32_e32 v4, v5, v4
; VI-NEXT:    v_add_f16_sdwa v5, v46, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, 0x200, v46
; VI-NEXT:    v_or_b32_e32 v5, v6, v5
; VI-NEXT:    v_add_f16_sdwa v6, v45, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v7, 0x200, v45
; VI-NEXT:    v_or_b32_e32 v6, v7, v6
; VI-NEXT:    v_add_f16_sdwa v7, v44, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, 0x200, v44
; VI-NEXT:    v_or_b32_e32 v7, v8, v7
; VI-NEXT:    v_add_f16_sdwa v8, v43, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v9, 0x200, v43
; VI-NEXT:    v_or_b32_e32 v8, v9, v8
; VI-NEXT:    v_add_f16_sdwa v9, v42, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v10, 0x200, v42
; VI-NEXT:    v_or_b32_e32 v9, v10, v9
; VI-NEXT:    v_add_f16_sdwa v10, v41, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v11, 0x200, v41
; VI-NEXT:    v_or_b32_e32 v10, v11, v10
; VI-NEXT:    v_add_f16_sdwa v11, v40, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v12, 0x200, v40
; VI-NEXT:    v_or_b32_e32 v11, v12, v11
; VI-NEXT:    v_add_f16_sdwa v12, v55, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v13, 0x200, v55
; VI-NEXT:    v_or_b32_e32 v12, v13, v12
; VI-NEXT:    v_add_f16_sdwa v13, v54, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v14, 0x200, v54
; VI-NEXT:    v_or_b32_e32 v13, v14, v13
; VI-NEXT:    v_add_f16_sdwa v14, v53, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v15, 0x200, v53
; VI-NEXT:    v_or_b32_e32 v14, v15, v14
; VI-NEXT:    v_add_f16_sdwa v15, v52, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v16, 0x200, v52
; VI-NEXT:    v_or_b32_e32 v15, v16, v15
; VI-NEXT:    v_add_f16_sdwa v16, v51, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v17, 0x200, v51
; VI-NEXT:    v_or_b32_e32 v16, v17, v16
; VI-NEXT:    v_add_f16_sdwa v17, v50, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v18, 0x200, v50
; VI-NEXT:    v_or_b32_e32 v17, v18, v17
; VI-NEXT:    v_add_f16_sdwa v18, v49, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v19, 0x200, v49
; VI-NEXT:    v_or_b32_e32 v18, v19, v18
; VI-NEXT:    v_add_f16_sdwa v19, v48, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v20, 0x200, v48
; VI-NEXT:    v_or_b32_e32 v19, v20, v19
; VI-NEXT:    v_add_f16_sdwa v20, v39, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v21, 0x200, v39
; VI-NEXT:    v_or_b32_e32 v20, v21, v20
; VI-NEXT:    v_add_f16_sdwa v21, v38, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v22, 0x200, v38
; VI-NEXT:    v_or_b32_e32 v21, v22, v21
; VI-NEXT:    v_add_f16_sdwa v22, v37, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v23, 0x200, v37
; VI-NEXT:    v_or_b32_e32 v22, v23, v22
; VI-NEXT:    v_add_f16_sdwa v23, v36, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v24, 0x200, v36
; VI-NEXT:    v_or_b32_e32 v23, v24, v23
; VI-NEXT:    v_add_f16_sdwa v24, v35, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v25, 0x200, v35
; VI-NEXT:    v_or_b32_e32 v24, v25, v24
; VI-NEXT:    v_add_f16_sdwa v25, v34, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v26, 0x200, v34
; VI-NEXT:    v_or_b32_e32 v25, v26, v25
; VI-NEXT:    v_add_f16_sdwa v26, v33, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v28, 0x200, v33
; VI-NEXT:    v_or_b32_e32 v26, v28, v26
; VI-NEXT:    v_add_f16_sdwa v27, v32, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v28, 0x200, v32
; VI-NEXT:    v_or_b32_e32 v27, v28, v27
; VI-NEXT:  .LBB18_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v56f16_to_v28i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    v_mov_b32_e32 v59, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v27
; GFX9-NEXT:    buffer_store_dword v27, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v26
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v25, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v25
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v24
; GFX9-NEXT:    v_mov_b32_e32 v37, v22
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v23, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v23
; GFX9-NEXT:    v_mov_b32_e32 v38, v21
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v37
; GFX9-NEXT:    v_mov_b32_e32 v39, v20
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v38
; GFX9-NEXT:    v_mov_b32_e32 v48, v19
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v39
; GFX9-NEXT:    v_mov_b32_e32 v49, v18
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v48
; GFX9-NEXT:    v_mov_b32_e32 v50, v17
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v49
; GFX9-NEXT:    v_mov_b32_e32 v51, v16
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v50
; GFX9-NEXT:    v_mov_b32_e32 v52, v15
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v51
; GFX9-NEXT:    v_mov_b32_e32 v53, v14
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v52
; GFX9-NEXT:    v_mov_b32_e32 v54, v13
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v53
; GFX9-NEXT:    v_mov_b32_e32 v55, v12
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v54
; GFX9-NEXT:    v_mov_b32_e32 v40, v11
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v55
; GFX9-NEXT:    v_mov_b32_e32 v41, v10
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v40
; GFX9-NEXT:    v_mov_b32_e32 v42, v9
; GFX9-NEXT:    v_mov_b32_e32 v43, v8
; GFX9-NEXT:    v_mov_b32_e32 v44, v7
; GFX9-NEXT:    v_mov_b32_e32 v45, v6
; GFX9-NEXT:    v_mov_b32_e32 v46, v5
; GFX9-NEXT:    v_mov_b32_e32 v47, v4
; GFX9-NEXT:    v_mov_b32_e32 v56, v3
; GFX9-NEXT:    v_mov_b32_e32 v57, v2
; GFX9-NEXT:    v_mov_b32_e32 v58, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v41
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v42
; GFX9-NEXT:    v_lshrrev_b32_e32 v63, 16, v43
; GFX9-NEXT:    v_lshrrev_b32_e32 v60, 16, v44
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v45
; GFX9-NEXT:    v_lshrrev_b32_e32 v61, 16, v46
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v47
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v56
; GFX9-NEXT:    v_lshrrev_b32_e32 v62, 16, v57
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v58
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v59
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB18_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 16, v42
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v41
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 16, v40
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 16, v55
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 16, v54
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v53
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 16, v52
; GFX9-NEXT:    v_lshrrev_b32_e32 v16, 16, v51
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 16, v50
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v49
; GFX9-NEXT:    v_lshrrev_b32_e32 v19, 16, v48
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v39
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v38
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v37
; GFX9-NEXT:    v_perm_b32 v0, v36, v59, s6
; GFX9-NEXT:    v_perm_b32 v1, v35, v58, s6
; GFX9-NEXT:    v_perm_b32 v2, v62, v57, s6
; GFX9-NEXT:    v_perm_b32 v3, v34, v56, s6
; GFX9-NEXT:    v_perm_b32 v4, v33, v47, s6
; GFX9-NEXT:    v_perm_b32 v5, v61, v46, s6
; GFX9-NEXT:    v_perm_b32 v6, v32, v45, s6
; GFX9-NEXT:    v_perm_b32 v7, v60, v44, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v43, s6
; GFX9-NEXT:    v_perm_b32 v9, v9, v42, s6
; GFX9-NEXT:    v_perm_b32 v10, v10, v41, s6
; GFX9-NEXT:    v_perm_b32 v11, v11, v40, s6
; GFX9-NEXT:    v_perm_b32 v12, v12, v55, s6
; GFX9-NEXT:    v_perm_b32 v13, v13, v54, s6
; GFX9-NEXT:    v_perm_b32 v14, v14, v53, s6
; GFX9-NEXT:    v_perm_b32 v15, v15, v52, s6
; GFX9-NEXT:    v_perm_b32 v16, v16, v51, s6
; GFX9-NEXT:    v_perm_b32 v17, v17, v50, s6
; GFX9-NEXT:    v_perm_b32 v18, v18, v49, s6
; GFX9-NEXT:    v_perm_b32 v19, v19, v48, s6
; GFX9-NEXT:    v_perm_b32 v20, v20, v39, s6
; GFX9-NEXT:    v_perm_b32 v21, v21, v38, s6
; GFX9-NEXT:    v_perm_b32 v22, v22, v37, s6
; GFX9-NEXT:    ; implicit-def: $vgpr59
; GFX9-NEXT:    ; implicit-def: $vgpr58
; GFX9-NEXT:    ; implicit-def: $vgpr57
; GFX9-NEXT:    ; implicit-def: $vgpr56
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr60
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr61
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr62
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v23, v24, v23, s6
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v24, v25, v24, s6
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v25, v26, v25, s6
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v26, v27, v26, s6
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v27, v28, v27, s6
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:  .LBB18_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB18_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v36, v59, s6
; GFX9-NEXT:    s_movk_i32 s7, 0x200
; GFX9-NEXT:    v_perm_b32 v1, v35, v58, s6
; GFX9-NEXT:    v_perm_b32 v2, v62, v57, s6
; GFX9-NEXT:    v_perm_b32 v3, v34, v56, s6
; GFX9-NEXT:    v_perm_b32 v4, v33, v47, s6
; GFX9-NEXT:    v_perm_b32 v5, v61, v46, s6
; GFX9-NEXT:    v_perm_b32 v6, v32, v45, s6
; GFX9-NEXT:    v_perm_b32 v7, v60, v44, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v43, s6
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, v6, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v7, v7, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v8, v8, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(15)
; GFX9-NEXT:    v_perm_b32 v9, v9, v42, s6
; GFX9-NEXT:    s_waitcnt vmcnt(14)
; GFX9-NEXT:    v_perm_b32 v10, v10, v41, s6
; GFX9-NEXT:    s_waitcnt vmcnt(13)
; GFX9-NEXT:    v_perm_b32 v11, v11, v40, s6
; GFX9-NEXT:    s_waitcnt vmcnt(12)
; GFX9-NEXT:    v_perm_b32 v12, v12, v55, s6
; GFX9-NEXT:    s_waitcnt vmcnt(11)
; GFX9-NEXT:    v_perm_b32 v13, v13, v54, s6
; GFX9-NEXT:    s_waitcnt vmcnt(10)
; GFX9-NEXT:    v_perm_b32 v14, v14, v53, s6
; GFX9-NEXT:    s_waitcnt vmcnt(9)
; GFX9-NEXT:    v_perm_b32 v15, v15, v52, s6
; GFX9-NEXT:    s_waitcnt vmcnt(8)
; GFX9-NEXT:    v_perm_b32 v16, v16, v51, s6
; GFX9-NEXT:    s_waitcnt vmcnt(7)
; GFX9-NEXT:    v_perm_b32 v17, v17, v50, s6
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_perm_b32 v18, v18, v49, s6
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_perm_b32 v19, v19, v48, s6
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_perm_b32 v20, v20, v39, s6
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_perm_b32 v21, v21, v38, s6
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_perm_b32 v22, v22, v37, s6
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v23, v24, v23, s6
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GFX9-NEXT:    v_pk_add_f16 v9, v9, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v10, v10, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v11, v11, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v12, v12, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v13, v13, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v14, v14, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v15, v15, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v16, v16, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v17, v17, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v18, v18, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v19, v19, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v20, v20, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v21, v21, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v22, v22, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v23, v23, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v24, v25, v24, s6
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-NEXT:    v_pk_add_f16 v24, v24, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v25, v26, v25, s6
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-NEXT:    v_pk_add_f16 v25, v25, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v26, v27, v26, s6
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-NEXT:    v_pk_add_f16 v26, v26, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v27, v28, v27, s6
; GFX9-NEXT:    v_pk_add_f16 v27, v27, s7 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB18_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v56f16_to_v28i32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB18_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v6, 0x200, v6 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v7, 0x200, v7 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v8, 0x200, v8 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v9, 0x200, v9 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v10, 0x200, v10 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v11, 0x200, v11 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v12, 0x200, v12 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v13, 0x200, v13 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v14, 0x200, v14 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v15, 0x200, v15 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v16, 0x200, v16 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v17, 0x200, v17 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v18, 0x200, v18 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v19, 0x200, v19 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v20, 0x200, v20 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v21, 0x200, v21 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v22, 0x200, v22 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v23, 0x200, v23 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v24, 0x200, v24 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v25, 0x200, v25 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v26, 0x200, v26 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v27, 0x200, v27 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:  .LBB18_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v56f16_to_v28i32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v50, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v53, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v54, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v65, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v66, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 16, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v80, 16, v3
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v28
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v69, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v70, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v71, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v80, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v68, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v67, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v66, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v65, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v64, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v55, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v54, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v53, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v52, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v51, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v50, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v49, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v48, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v39, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v38, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v37, v19, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v20, v36, v20, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v21, v35, v21, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v22, v34, v22, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v23, v33, v23, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v24, v32, v24, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v25, v31, v25, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v26, v30, v26, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v27, v29, v27, 0x5040100
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB18_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v6, 0x200, v6 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v7, 0x200, v7 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v8, 0x200, v8 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v9, 0x200, v9 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v10, 0x200, v10 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v11, 0x200, v11 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v12, 0x200, v12 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v13, 0x200, v13 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v14, 0x200, v14 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v15, 0x200, v15 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v16, 0x200, v16 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v17, 0x200, v17 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v18, 0x200, v18 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v19, 0x200, v19 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v20, 0x200, v20 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v21, 0x200, v21 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v22, 0x200, v22 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v23, 0x200, v23 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v24, 0x200, v24 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v25, 0x200, v25 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v26, 0x200, v26 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v27, 0x200, v27 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:  .LBB18_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <56 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <56 x half> %a1 to <28 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <56 x half> %a to <28 x i32>
  br label %end

end:
  %phi = phi <28 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x i32> %phi
}

define inreg <28 x i32> @bitcast_v56f16_to_v28i32_scalar(<56 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v56f16_to_v28i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; SI-NEXT:    buffer_load_dword v50, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v51, off, s[0:3], s32 offset:4
; SI-NEXT:    buffer_load_dword v52, off, s[0:3], s32 offset:16
; SI-NEXT:    buffer_load_dword v53, off, s[0:3], s32 offset:12
; SI-NEXT:    buffer_load_dword v54, off, s[0:3], s32 offset:24
; SI-NEXT:    buffer_load_dword v55, off, s[0:3], s32 offset:20
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:28
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:40
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:36
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:44
; SI-NEXT:    v_cvt_f16_f32_e32 v47, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v23
; SI-NEXT:    v_cvt_f16_f32_e32 v44, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v46, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v58, v2
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v60, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v59, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v62, v7
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v25
; SI-NEXT:    v_cvt_f16_f32_e32 v56, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v57, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v45, v8
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v63, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v38, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v27
; SI-NEXT:    v_cvt_f16_f32_e32 v36, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v34, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v35, v14
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v19
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v37, v20
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v30
; SI-NEXT:    v_cvt_f16_f32_e32 v29, v29
; SI-NEXT:    v_cvt_f16_f32_e32 v2, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v11, s20
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; SI-NEXT:    v_cvt_f16_f32_e32 v3, s23
; SI-NEXT:    v_cvt_f16_f32_e32 v10, s22
; SI-NEXT:    v_cvt_f16_f32_e32 v4, s25
; SI-NEXT:    v_cvt_f16_f32_e32 v9, s24
; SI-NEXT:    v_cvt_f16_f32_e32 v5, s27
; SI-NEXT:    v_cvt_f16_f32_e32 v8, s26
; SI-NEXT:    v_cvt_f16_f32_e32 v6, s29
; SI-NEXT:    v_cvt_f16_f32_e32 v7, s28
; SI-NEXT:    s_waitcnt vmcnt(14) expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v31
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v50
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v51
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v61
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v52
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v53
; SI-NEXT:    v_cvt_f16_f32_e32 v53, s18
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v54
; SI-NEXT:    v_cvt_f16_f32_e32 v54, s19
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v55
; SI-NEXT:    v_cvt_f16_f32_e32 v55, s16
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v40
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v41
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v42
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v43
; SI-NEXT:    v_cvt_f16_f32_e32 v43, s17
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; SI-NEXT:    s_cbranch_scc0 .LBB19_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; SI-NEXT:    v_or_b32_e32 v16, v18, v16
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v49, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_mov_b32_e32 v48, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_mov_b32_e32 v61, v44
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v43
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v54
; SI-NEXT:    v_mov_b32_e32 v39, v11
; SI-NEXT:    v_or_b32_e32 v2, v11, v2
; SI-NEXT:    v_mov_b32_e32 v33, v10
; SI-NEXT:    v_or_b32_e32 v3, v10, v3
; SI-NEXT:    v_or_b32_e32 v4, v9, v4
; SI-NEXT:    v_or_b32_e32 v5, v8, v5
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v61
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v46
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v60
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v62
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v57
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v63
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v34
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    v_or_b32_e32 v0, v55, v0
; SI-NEXT:    v_or_b32_e32 v1, v53, v1
; SI-NEXT:    v_or_b32_e32 v7, v47, v7
; SI-NEXT:    v_mov_b32_e32 v42, v58
; SI-NEXT:    v_or_b32_e32 v8, v58, v8
; SI-NEXT:    v_mov_b32_e32 v41, v60
; SI-NEXT:    v_or_b32_e32 v9, v59, v9
; SI-NEXT:    v_mov_b32_e32 v40, v56
; SI-NEXT:    v_or_b32_e32 v10, v56, v10
; SI-NEXT:    v_or_b32_e32 v11, v45, v11
; SI-NEXT:    v_or_b32_e32 v12, v38, v12
; SI-NEXT:    v_or_b32_e32 v13, v36, v13
; SI-NEXT:    v_or_b32_e32 v14, v35, v14
; SI-NEXT:    v_or_b32_e32 v15, v32, v15
; SI-NEXT:    v_or_b32_e32 v17, v37, v17
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v50, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; SI-NEXT:    s_waitcnt vmcnt(9)
; SI-NEXT:    v_or_b32_e32 v18, v19, v18
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; SI-NEXT:    v_or_b32_e32 v19, v20, v19
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; SI-NEXT:    v_or_b32_e32 v20, v21, v20
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v29
; SI-NEXT:    v_or_b32_e32 v21, v22, v21
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; SI-NEXT:    v_or_b32_e32 v22, v23, v22
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; SI-NEXT:    v_or_b32_e32 v23, v24, v23
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; SI-NEXT:    v_or_b32_e32 v24, v25, v24
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; SI-NEXT:    v_or_b32_e32 v25, v26, v25
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; SI-NEXT:    v_or_b32_e32 v26, v27, v26
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; SI-NEXT:    v_or_b32_e32 v27, v50, v27
; SI-NEXT:    s_cbranch_execnz .LBB19_3
; SI-NEXT:  .LBB19_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v43
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v54
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v55
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v53
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v49
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v39
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v33
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v47
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v48
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v42
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v40
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v45
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v38
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v35
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v32
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v29
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    v_add_f32_e32 v22, 0x38000000, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v22
; SI-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v19
; SI-NEXT:    s_waitcnt vmcnt(12)
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v28
; SI-NEXT:    s_waitcnt vmcnt(11)
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    s_waitcnt vmcnt(9)
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    s_waitcnt vmcnt(8)
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v19, 0x38000000, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v25
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v29
; SI-NEXT:    v_add_f32_e32 v28, 0x38000000, v28
; SI-NEXT:    v_add_f32_e32 v21, 0x38000000, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v21
; SI-NEXT:    v_add_f32_e32 v25, 0x38000000, v25
; SI-NEXT:    v_cvt_f16_f32_e32 v25, v25
; SI-NEXT:    v_add_f32_e32 v29, 0x38000000, v29
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v29, v29
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v61
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v46
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v41
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_or_b32_e32 v9, v10, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v62
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, v11, v10
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v63
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_or_b32_e32 v12, v13, v12
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_or_b32_e32 v13, v14, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v34
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v16
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; SI-NEXT:    v_or_b32_e32 v15, v17, v15
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v18
; SI-NEXT:    v_add_f32_e32 v18, 0x38000000, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; SI-NEXT:    v_or_b32_e32 v16, v18, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v37
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    v_add_f32_e32 v18, 0x38000000, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    v_or_b32_e32 v17, v18, v17
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v19
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v20
; SI-NEXT:    v_add_f32_e32 v20, 0x38000000, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v20
; SI-NEXT:    v_or_b32_e32 v18, v20, v18
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v19
; SI-NEXT:    v_add_f32_e32 v19, 0x38000000, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; SI-NEXT:    v_or_b32_e32 v19, v21, v19
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v20
; SI-NEXT:    v_add_f32_e32 v20, 0x38000000, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v20
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_add_f32_e32 v21, 0x38000000, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v21
; SI-NEXT:    v_or_b32_e32 v20, v21, v20
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v22
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v23
; SI-NEXT:    v_add_f32_e32 v23, 0x38000000, v23
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v23
; SI-NEXT:    v_or_b32_e32 v21, v23, v21
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v24
; SI-NEXT:    v_add_f32_e32 v24, 0x38000000, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v24
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v22
; SI-NEXT:    v_add_f32_e32 v22, 0x38000000, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v22
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; SI-NEXT:    v_or_b32_e32 v22, v24, v22
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v23
; SI-NEXT:    v_add_f32_e32 v23, 0x38000000, v23
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v23
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v24
; SI-NEXT:    v_add_f32_e32 v24, 0x38000000, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v24
; SI-NEXT:    v_or_b32_e32 v23, v24, v23
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v26
; SI-NEXT:    v_add_f32_e32 v26, 0x38000000, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v26
; SI-NEXT:    v_or_b32_e32 v24, v26, v24
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v27
; SI-NEXT:    v_add_f32_e32 v27, 0x38000000, v27
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v27
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v25
; SI-NEXT:    v_add_f32_e32 v25, 0x38000000, v25
; SI-NEXT:    v_cvt_f16_f32_e32 v25, v25
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; SI-NEXT:    v_or_b32_e32 v25, v27, v25
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v26
; SI-NEXT:    v_add_f32_e32 v26, 0x38000000, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v26
; SI-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v27
; SI-NEXT:    v_add_f32_e32 v27, 0x38000000, v27
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v27
; SI-NEXT:    v_or_b32_e32 v26, v27, v26
; SI-NEXT:    v_lshlrev_b32_e32 v27, 16, v28
; SI-NEXT:    v_or_b32_e32 v27, v29, v27
; SI-NEXT:  .LBB19_3: ; %end
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB19_4:
; SI-NEXT:    v_mov_b32_e32 v39, v11
; SI-NEXT:    v_mov_b32_e32 v33, v10
; SI-NEXT:    v_mov_b32_e32 v49, v2
; SI-NEXT:    v_mov_b32_e32 v48, v3
; SI-NEXT:    v_mov_b32_e32 v52, v37
; SI-NEXT:    v_mov_b32_e32 v37, v29
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    v_mov_b32_e32 v42, v58
; SI-NEXT:    v_mov_b32_e32 v41, v60
; SI-NEXT:    v_mov_b32_e32 v40, v56
; SI-NEXT:    v_mov_b32_e32 v29, v37
; SI-NEXT:    v_mov_b32_e32 v37, v52
; SI-NEXT:    v_mov_b32_e32 v61, v44
; SI-NEXT:    s_branch .LBB19_2
;
; VI-LABEL: bitcast_v56f16_to_v28i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s6, s29, 16
; VI-NEXT:    s_lshr_b32 s7, s28, 16
; VI-NEXT:    s_lshr_b32 s8, s27, 16
; VI-NEXT:    s_lshr_b32 s9, s26, 16
; VI-NEXT:    s_lshr_b32 s10, s25, 16
; VI-NEXT:    s_lshr_b32 s11, s24, 16
; VI-NEXT:    s_lshr_b32 s12, s23, 16
; VI-NEXT:    s_lshr_b32 s13, s22, 16
; VI-NEXT:    s_lshr_b32 s14, s21, 16
; VI-NEXT:    s_lshr_b32 s15, s20, 16
; VI-NEXT:    s_lshr_b32 s40, s19, 16
; VI-NEXT:    s_lshr_b32 s41, s18, 16
; VI-NEXT:    s_lshr_b32 s42, s17, 16
; VI-NEXT:    s_lshr_b32 s43, s16, 16
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v32, v13
; VI-NEXT:    v_mov_b32_e32 v33, v12
; VI-NEXT:    v_mov_b32_e32 v34, v11
; VI-NEXT:    v_mov_b32_e32 v35, v10
; VI-NEXT:    v_mov_b32_e32 v36, v9
; VI-NEXT:    v_mov_b32_e32 v37, v8
; VI-NEXT:    v_mov_b32_e32 v38, v7
; VI-NEXT:    v_mov_b32_e32 v39, v6
; VI-NEXT:    v_mov_b32_e32 v48, v5
; VI-NEXT:    v_mov_b32_e32 v49, v4
; VI-NEXT:    v_mov_b32_e32 v50, v3
; VI-NEXT:    v_mov_b32_e32 v51, v2
; VI-NEXT:    v_mov_b32_e32 v52, v1
; VI-NEXT:    v_mov_b32_e32 v53, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    s_cbranch_scc0 .LBB19_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, 0xffff, s16
; VI-NEXT:    s_lshl_b32 s5, s43, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, 0xffff, s17
; VI-NEXT:    s_lshl_b32 s44, s42, 16
; VI-NEXT:    v_mov_b32_e32 v0, 16
; VI-NEXT:    s_or_b32 s5, s5, s44
; VI-NEXT:    s_and_b32 s44, 0xffff, s18
; VI-NEXT:    s_lshl_b32 s45, s41, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s44, s44, s45
; VI-NEXT:    s_and_b32 s45, 0xffff, s19
; VI-NEXT:    s_lshl_b32 s46, s40, 16
; VI-NEXT:    v_or_b32_sdwa v14, v53, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s45, s45, s46
; VI-NEXT:    s_and_b32 s46, 0xffff, s20
; VI-NEXT:    s_lshl_b32 s47, s15, 16
; VI-NEXT:    v_or_b32_sdwa v16, v51, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s46, s46, s47
; VI-NEXT:    s_and_b32 s47, 0xffff, s21
; VI-NEXT:    s_lshl_b32 s56, s14, 16
; VI-NEXT:    v_or_b32_sdwa v17, v50, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s47, s47, s56
; VI-NEXT:    s_and_b32 s56, 0xffff, s22
; VI-NEXT:    s_lshl_b32 s57, s13, 16
; VI-NEXT:    v_or_b32_sdwa v18, v49, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s56, s56, s57
; VI-NEXT:    s_and_b32 s57, 0xffff, s23
; VI-NEXT:    s_lshl_b32 s58, s12, 16
; VI-NEXT:    v_or_b32_sdwa v19, v48, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s57, s57, s58
; VI-NEXT:    s_and_b32 s58, 0xffff, s24
; VI-NEXT:    s_lshl_b32 s59, s11, 16
; VI-NEXT:    v_or_b32_sdwa v20, v39, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s58, s58, s59
; VI-NEXT:    s_and_b32 s59, 0xffff, s25
; VI-NEXT:    s_lshl_b32 s60, s10, 16
; VI-NEXT:    v_or_b32_sdwa v21, v38, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s59, s59, s60
; VI-NEXT:    s_and_b32 s60, 0xffff, s26
; VI-NEXT:    s_lshl_b32 s61, s9, 16
; VI-NEXT:    v_or_b32_sdwa v22, v37, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s60, s60, s61
; VI-NEXT:    s_and_b32 s61, 0xffff, s27
; VI-NEXT:    s_lshl_b32 s62, s8, 16
; VI-NEXT:    v_or_b32_sdwa v23, v36, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s61, s61, s62
; VI-NEXT:    s_and_b32 s62, 0xffff, s28
; VI-NEXT:    s_lshl_b32 s63, s7, 16
; VI-NEXT:    v_or_b32_sdwa v24, v35, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s62, s62, s63
; VI-NEXT:    s_and_b32 s63, 0xffff, s29
; VI-NEXT:    s_lshl_b32 s72, s6, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v0, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v25, v34, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v0, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s63, s63, s72
; VI-NEXT:    v_or_b32_sdwa v15, v52, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v26, v33, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v27, v32, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s44
; VI-NEXT:    v_mov_b32_e32 v3, s45
; VI-NEXT:    v_mov_b32_e32 v4, s46
; VI-NEXT:    v_mov_b32_e32 v5, s47
; VI-NEXT:    v_mov_b32_e32 v6, s56
; VI-NEXT:    v_mov_b32_e32 v7, s57
; VI-NEXT:    v_mov_b32_e32 v8, s58
; VI-NEXT:    v_mov_b32_e32 v9, s59
; VI-NEXT:    v_mov_b32_e32 v10, s60
; VI-NEXT:    v_mov_b32_e32 v11, s61
; VI-NEXT:    v_mov_b32_e32 v12, s62
; VI-NEXT:    v_mov_b32_e32 v13, s63
; VI-NEXT:    s_cbranch_execnz .LBB19_3
; VI-NEXT:  .LBB19_2: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v13, 0x200
; VI-NEXT:    v_mov_b32_e32 v0, s43
; VI-NEXT:    v_mov_b32_e32 v2, s42
; VI-NEXT:    v_add_f16_sdwa v0, v0, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, s16, v13
; VI-NEXT:    v_add_f16_sdwa v2, v2, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, s17, v13
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    v_or_b32_e32 v1, v3, v2
; VI-NEXT:    v_mov_b32_e32 v2, s41
; VI-NEXT:    v_add_f16_sdwa v2, v2, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, s18, v13
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_mov_b32_e32 v3, s40
; VI-NEXT:    v_add_f16_sdwa v3, v3, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, s19, v13
; VI-NEXT:    v_or_b32_e32 v3, v4, v3
; VI-NEXT:    v_mov_b32_e32 v4, s15
; VI-NEXT:    v_add_f16_sdwa v4, v4, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, s20, v13
; VI-NEXT:    v_or_b32_e32 v4, v5, v4
; VI-NEXT:    v_mov_b32_e32 v5, s14
; VI-NEXT:    v_add_f16_sdwa v5, v5, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, s21, v13
; VI-NEXT:    v_or_b32_e32 v5, v6, v5
; VI-NEXT:    v_mov_b32_e32 v6, s13
; VI-NEXT:    v_add_f16_sdwa v6, v6, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v7, s22, v13
; VI-NEXT:    v_or_b32_e32 v6, v7, v6
; VI-NEXT:    v_mov_b32_e32 v7, s12
; VI-NEXT:    v_add_f16_sdwa v7, v7, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, s23, v13
; VI-NEXT:    v_or_b32_e32 v7, v8, v7
; VI-NEXT:    v_mov_b32_e32 v8, s11
; VI-NEXT:    v_add_f16_sdwa v8, v8, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v9, s24, v13
; VI-NEXT:    v_or_b32_e32 v8, v9, v8
; VI-NEXT:    v_mov_b32_e32 v9, s10
; VI-NEXT:    v_add_f16_sdwa v9, v9, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v10, s25, v13
; VI-NEXT:    v_or_b32_e32 v9, v10, v9
; VI-NEXT:    v_mov_b32_e32 v10, s9
; VI-NEXT:    v_add_f16_sdwa v10, v10, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v11, s26, v13
; VI-NEXT:    v_or_b32_e32 v10, v11, v10
; VI-NEXT:    v_mov_b32_e32 v11, s8
; VI-NEXT:    v_add_f16_sdwa v11, v11, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v12, s27, v13
; VI-NEXT:    v_or_b32_e32 v11, v12, v11
; VI-NEXT:    v_mov_b32_e32 v12, s7
; VI-NEXT:    v_add_f16_sdwa v12, v12, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v14, s28, v13
; VI-NEXT:    v_or_b32_e32 v12, v14, v12
; VI-NEXT:    v_mov_b32_e32 v14, s6
; VI-NEXT:    v_add_f16_sdwa v14, v14, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v13, s29, v13
; VI-NEXT:    v_mov_b32_e32 v27, 0x200
; VI-NEXT:    v_or_b32_e32 v13, v13, v14
; VI-NEXT:    v_add_f16_sdwa v14, v53, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v15, 0x200, v53
; VI-NEXT:    v_or_b32_e32 v14, v15, v14
; VI-NEXT:    v_add_f16_sdwa v15, v52, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v16, 0x200, v52
; VI-NEXT:    v_or_b32_e32 v15, v16, v15
; VI-NEXT:    v_add_f16_sdwa v16, v51, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v17, 0x200, v51
; VI-NEXT:    v_or_b32_e32 v16, v17, v16
; VI-NEXT:    v_add_f16_sdwa v17, v50, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v18, 0x200, v50
; VI-NEXT:    v_or_b32_e32 v17, v18, v17
; VI-NEXT:    v_add_f16_sdwa v18, v49, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v19, 0x200, v49
; VI-NEXT:    v_or_b32_e32 v18, v19, v18
; VI-NEXT:    v_add_f16_sdwa v19, v48, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v20, 0x200, v48
; VI-NEXT:    v_or_b32_e32 v19, v20, v19
; VI-NEXT:    v_add_f16_sdwa v20, v39, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v21, 0x200, v39
; VI-NEXT:    v_or_b32_e32 v20, v21, v20
; VI-NEXT:    v_add_f16_sdwa v21, v38, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v22, 0x200, v38
; VI-NEXT:    v_or_b32_e32 v21, v22, v21
; VI-NEXT:    v_add_f16_sdwa v22, v37, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v23, 0x200, v37
; VI-NEXT:    v_or_b32_e32 v22, v23, v22
; VI-NEXT:    v_add_f16_sdwa v23, v36, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v24, 0x200, v36
; VI-NEXT:    v_or_b32_e32 v23, v24, v23
; VI-NEXT:    v_add_f16_sdwa v24, v35, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v25, 0x200, v35
; VI-NEXT:    v_or_b32_e32 v24, v25, v24
; VI-NEXT:    v_add_f16_sdwa v25, v34, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v26, 0x200, v34
; VI-NEXT:    v_or_b32_e32 v25, v26, v25
; VI-NEXT:    v_add_f16_sdwa v26, v33, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v28, 0x200, v33
; VI-NEXT:    v_or_b32_e32 v26, v28, v26
; VI-NEXT:    v_add_f16_sdwa v27, v32, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v28, 0x200, v32
; VI-NEXT:    v_or_b32_e32 v27, v28, v27
; VI-NEXT:  .LBB19_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB19_4:
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_branch .LBB19_2
;
; GFX9-LABEL: bitcast_v56f16_to_v28i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v13
; GFX9-NEXT:    v_mov_b32_e32 v33, v12
; GFX9-NEXT:    v_mov_b32_e32 v34, v11
; GFX9-NEXT:    v_mov_b32_e32 v35, v10
; GFX9-NEXT:    v_mov_b32_e32 v36, v9
; GFX9-NEXT:    v_mov_b32_e32 v37, v8
; GFX9-NEXT:    v_mov_b32_e32 v38, v7
; GFX9-NEXT:    v_mov_b32_e32 v39, v6
; GFX9-NEXT:    v_mov_b32_e32 v48, v5
; GFX9-NEXT:    v_mov_b32_e32 v49, v4
; GFX9-NEXT:    v_mov_b32_e32 v50, v3
; GFX9-NEXT:    v_mov_b32_e32 v51, v2
; GFX9-NEXT:    v_mov_b32_e32 v52, v1
; GFX9-NEXT:    v_mov_b32_e32 v53, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    s_lshr_b32 s40, s29, 16
; GFX9-NEXT:    s_lshr_b32 s41, s28, 16
; GFX9-NEXT:    s_lshr_b32 s42, s27, 16
; GFX9-NEXT:    s_lshr_b32 s43, s26, 16
; GFX9-NEXT:    s_lshr_b32 s15, s25, 16
; GFX9-NEXT:    s_lshr_b32 s14, s24, 16
; GFX9-NEXT:    s_lshr_b32 s13, s23, 16
; GFX9-NEXT:    s_lshr_b32 s12, s22, 16
; GFX9-NEXT:    s_lshr_b32 s11, s21, 16
; GFX9-NEXT:    s_lshr_b32 s10, s20, 16
; GFX9-NEXT:    s_lshr_b32 s9, s19, 16
; GFX9-NEXT:    s_lshr_b32 s8, s18, 16
; GFX9-NEXT:    s_lshr_b32 s7, s17, 16
; GFX9-NEXT:    s_lshr_b32 s6, s16, 16
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v36
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v37
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s16, s6
; GFX9-NEXT:    s_pack_ll_b32_b16 s7, s17, s7
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s18, s8
; GFX9-NEXT:    s_pack_ll_b32_b16 s9, s19, s9
; GFX9-NEXT:    s_pack_ll_b32_b16 s10, s20, s10
; GFX9-NEXT:    s_pack_ll_b32_b16 s11, s21, s11
; GFX9-NEXT:    s_pack_ll_b32_b16 s12, s22, s12
; GFX9-NEXT:    s_pack_ll_b32_b16 s13, s23, s13
; GFX9-NEXT:    s_pack_ll_b32_b16 s14, s24, s14
; GFX9-NEXT:    s_pack_ll_b32_b16 s15, s25, s15
; GFX9-NEXT:    s_pack_ll_b32_b16 s16, s26, s43
; GFX9-NEXT:    s_pack_ll_b32_b16 s17, s27, s42
; GFX9-NEXT:    s_pack_ll_b32_b16 s18, s28, s41
; GFX9-NEXT:    s_pack_ll_b32_b16 s19, s29, s40
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v38
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v39
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v48
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v49
; GFX9-NEXT:    v_lshrrev_b32_e32 v56, 16, v50
; GFX9-NEXT:    v_lshrrev_b32_e32 v57, 16, v51
; GFX9-NEXT:    v_lshrrev_b32_e32 v58, 16, v52
; GFX9-NEXT:    v_lshrrev_b32_e32 v59, 16, v53
; GFX9-NEXT:    s_cbranch_scc0 .LBB19_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v53
; GFX9-NEXT:    v_lshl_or_b32 v14, v59, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v52
; GFX9-NEXT:    v_lshl_or_b32 v15, v58, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v51
; GFX9-NEXT:    v_lshl_or_b32 v16, v57, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v50
; GFX9-NEXT:    v_lshl_or_b32 v17, v56, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v49
; GFX9-NEXT:    v_lshl_or_b32 v18, v47, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v48
; GFX9-NEXT:    v_lshl_or_b32 v19, v46, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v39
; GFX9-NEXT:    v_lshl_or_b32 v20, v45, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v38
; GFX9-NEXT:    v_lshl_or_b32 v21, v44, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v37
; GFX9-NEXT:    v_lshl_or_b32 v22, v43, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v36
; GFX9-NEXT:    v_lshl_or_b32 v23, v42, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v35
; GFX9-NEXT:    v_lshl_or_b32 v24, v41, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v34
; GFX9-NEXT:    v_lshl_or_b32 v25, v40, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v33
; GFX9-NEXT:    v_lshl_or_b32 v26, v55, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v32
; GFX9-NEXT:    v_lshl_or_b32 v27, v54, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:    v_mov_b32_e32 v6, s12
; GFX9-NEXT:    v_mov_b32_e32 v7, s13
; GFX9-NEXT:    v_mov_b32_e32 v8, s14
; GFX9-NEXT:    v_mov_b32_e32 v9, s15
; GFX9-NEXT:    v_mov_b32_e32 v10, s16
; GFX9-NEXT:    v_mov_b32_e32 v11, s17
; GFX9-NEXT:    v_mov_b32_e32 v12, s18
; GFX9-NEXT:    v_mov_b32_e32 v13, s19
; GFX9-NEXT:    s_cbranch_execnz .LBB19_3
; GFX9-NEXT:  .LBB19_2: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v14, 0xffff, v53
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v52
; GFX9-NEXT:    v_and_b32_e32 v16, 0xffff, v51
; GFX9-NEXT:    v_and_b32_e32 v17, 0xffff, v50
; GFX9-NEXT:    v_and_b32_e32 v18, 0xffff, v49
; GFX9-NEXT:    v_and_b32_e32 v19, 0xffff, v48
; GFX9-NEXT:    v_and_b32_e32 v20, 0xffff, v39
; GFX9-NEXT:    v_and_b32_e32 v21, 0xffff, v38
; GFX9-NEXT:    v_and_b32_e32 v22, 0xffff, v37
; GFX9-NEXT:    v_and_b32_e32 v23, 0xffff, v36
; GFX9-NEXT:    v_and_b32_e32 v24, 0xffff, v35
; GFX9-NEXT:    v_and_b32_e32 v25, 0xffff, v34
; GFX9-NEXT:    v_and_b32_e32 v26, 0xffff, v33
; GFX9-NEXT:    v_and_b32_e32 v27, 0xffff, v32
; GFX9-NEXT:    v_mov_b32_e32 v13, 0x200
; GFX9-NEXT:    s_movk_i32 s4, 0x200
; GFX9-NEXT:    v_lshl_or_b32 v14, v59, 16, v14
; GFX9-NEXT:    v_lshl_or_b32 v15, v58, 16, v15
; GFX9-NEXT:    v_lshl_or_b32 v16, v57, 16, v16
; GFX9-NEXT:    v_lshl_or_b32 v17, v56, 16, v17
; GFX9-NEXT:    v_lshl_or_b32 v18, v47, 16, v18
; GFX9-NEXT:    v_lshl_or_b32 v19, v46, 16, v19
; GFX9-NEXT:    v_lshl_or_b32 v20, v45, 16, v20
; GFX9-NEXT:    v_lshl_or_b32 v21, v44, 16, v21
; GFX9-NEXT:    v_lshl_or_b32 v22, v43, 16, v22
; GFX9-NEXT:    v_lshl_or_b32 v23, v42, 16, v23
; GFX9-NEXT:    v_lshl_or_b32 v24, v41, 16, v24
; GFX9-NEXT:    v_lshl_or_b32 v25, v40, 16, v25
; GFX9-NEXT:    v_lshl_or_b32 v26, v55, 16, v26
; GFX9-NEXT:    v_lshl_or_b32 v27, v54, 16, v27
; GFX9-NEXT:    v_pk_add_f16 v0, s6, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s7, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, s8, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, s9, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, s10, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, s11, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, s12, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v7, s13, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v8, s14, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v9, s15, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v10, s16, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v11, s17, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v12, s18, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v13, s19, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v14, v14, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v15, v15, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v16, v16, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v17, v17, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v18, v18, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v19, v19, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v20, v20, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v21, v21, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v22, v22, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v23, v23, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v24, v24, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v25, v25, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v26, v26, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v27, v27, s4 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB19_3: ; %end
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB19_4:
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_branch .LBB19_2
;
; GFX11-TRUE16-LABEL: bitcast_v56f16_to_v28i32_scalar:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.h, 0
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v10
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.l, v9.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.l, v8.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v34.l, v7.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v34.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v35.l, v6.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v35.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v36.l, v5.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v36.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v37.l, v4.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v37.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v38.l, v3.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v38.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v39.l, v2.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v39.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v48.l, v1.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v48.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v49.l, v0.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v49.h, v32.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v67, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v66, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v65, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v64, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v55, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v54, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v53, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v52, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v51, 0xffff, v8
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v50, 0xffff, v9
; GFX11-TRUE16-NEXT:    s_lshr_b32 s40, s29, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s41, s28, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s42, s27, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s14, s26, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s13, s25, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s12, s24, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s11, s23, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s10, s22, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s9, s21, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s8, s20, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s7, s19, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s6, s18, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s5, s17, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s4, s16, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s43, s3, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s44, s2, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s45, s1, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s46, s0, 16
; GFX11-TRUE16-NEXT:    s_mov_b32 s15, 0
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s0, s0, s46
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s1, s1, s45
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s2, s2, s44
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s43
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s4, s16, s4
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s5, s17, s5
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s6, s18, s6
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s7, s19, s7
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s8, s20, s8
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s9, s21, s9
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s10, s22, s10
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s11, s23, s11
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s12, s24, s12
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s13, s25, s13
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s14, s26, s14
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s16, s27, s42
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s17, s28, s41
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s18, s29, s40
; GFX11-TRUE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-TRUE16-NEXT:    s_cbranch_scc0 .LBB19_4
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v49, 16, v67
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v48, 16, v66
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v20, v39, 16, v65
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v21, v38, 16, v64
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v22, v37, 16, v55
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v23, v36, 16, v54
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v24, v35, 16, v53
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v25, v34, 16, v52
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v26, v33, 16, v51
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v27, v32, 16, v50
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v8, s8 :: v_dual_mov_b32 v9, s9
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v10, s10 :: v_dual_mov_b32 v11, s11
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v12, s12 :: v_dual_mov_b32 v13, s13
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v14, s14 :: v_dual_mov_b32 v15, s16
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v16, s17 :: v_dual_mov_b32 v17, s18
; GFX11-TRUE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s15
; GFX11-TRUE16-NEXT:    s_cbranch_vccnz .LBB19_3
; GFX11-TRUE16-NEXT:  .LBB19_2: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v49, 16, v67
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v48, 16, v66
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v20, v39, 16, v65
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v21, v38, 16, v64
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v22, v37, 16, v55
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v23, v36, 16, v54
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v24, v35, 16, v53
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v25, v34, 16, v52
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v26, v33, 16, v51
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v27, v32, 16, v50
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v4, 0x200, s4 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v5, 0x200, s5 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v6, 0x200, s6 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v7, 0x200, s7 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v8, 0x200, s8 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v9, 0x200, s9 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v10, 0x200, s10 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v11, 0x200, s11 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v12, 0x200, s12 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v13, 0x200, s13 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v14, 0x200, s14 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v15, 0x200, s16 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v16, 0x200, s17 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v17, 0x200, s18 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v18, 0x200, v18 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v19, 0x200, v19 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v20, 0x200, v20 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v21, 0x200, v21 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v22, 0x200, v22 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v23, 0x200, v23 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v24, 0x200, v24 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v25, 0x200, v25 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v26, 0x200, v26 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v27, 0x200, v27 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:  .LBB19_3: ; %end
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB19_4:
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-TRUE16-NEXT:    s_branch .LBB19_2
;
; GFX11-FAKE16-LABEL: bitcast_v56f16_to_v28i32_scalar:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v67, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v66, 0xffff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v65, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v64, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v55, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v54, 0xffff, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v53, 0xffff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v52, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v51, 0xffff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v50, 0xffff, v9
; GFX11-FAKE16-NEXT:    s_lshr_b32 s40, s29, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s41, s28, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s42, s27, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s14, s26, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s13, s25, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s12, s24, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s11, s23, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s10, s22, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s9, s21, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s8, s20, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s7, s19, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s6, s18, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s5, s17, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s4, s16, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s43, s3, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s44, s2, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s45, s1, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s46, s0, 16
; GFX11-FAKE16-NEXT:    s_mov_b32 s15, 0
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s0, s0, s46
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s1, s1, s45
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s2, s2, s44
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s43
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s4, s16, s4
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s5, s17, s5
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s6, s18, s6
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s7, s19, s7
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s8, s20, s8
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s9, s21, s9
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s10, s22, s10
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s11, s23, s11
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s12, s24, s12
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s13, s25, s13
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s14, s26, s14
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s16, s27, s42
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s17, s28, s41
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s18, s29, s40
; GFX11-FAKE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-FAKE16-NEXT:    s_cbranch_scc0 .LBB19_4
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v49, 16, v67
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v48, 16, v66
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v20, v39, 16, v65
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v21, v38, 16, v64
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v22, v37, 16, v55
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v23, v36, 16, v54
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v24, v35, 16, v53
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v25, v34, 16, v52
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v26, v33, 16, v51
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v27, v32, 16, v50
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v8, s8 :: v_dual_mov_b32 v9, s9
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v10, s10 :: v_dual_mov_b32 v11, s11
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v12, s12 :: v_dual_mov_b32 v13, s13
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v14, s14 :: v_dual_mov_b32 v15, s16
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v16, s17 :: v_dual_mov_b32 v17, s18
; GFX11-FAKE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s15
; GFX11-FAKE16-NEXT:    s_cbranch_vccnz .LBB19_3
; GFX11-FAKE16-NEXT:  .LBB19_2: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v49, 16, v67
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v48, 16, v66
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v20, v39, 16, v65
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v21, v38, 16, v64
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v22, v37, 16, v55
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v23, v36, 16, v54
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v24, v35, 16, v53
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v25, v34, 16, v52
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v26, v33, 16, v51
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v27, v32, 16, v50
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v4, 0x200, s4 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v5, 0x200, s5 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v6, 0x200, s6 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v7, 0x200, s7 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v8, 0x200, s8 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v9, 0x200, s9 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v10, 0x200, s10 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v11, 0x200, s11 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v12, 0x200, s12 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v13, 0x200, s13 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v14, 0x200, s14 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v15, 0x200, s16 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v16, 0x200, s17 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v17, 0x200, s18 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v18, 0x200, v18 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v19, 0x200, v19 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v20, 0x200, v20 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v21, 0x200, v21 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v22, 0x200, v22 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v23, 0x200, v23 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v24, 0x200, v24 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v25, 0x200, v25 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v26, 0x200, v26 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v27, 0x200, v27 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:  .LBB19_3: ; %end
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB19_4:
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-FAKE16-NEXT:    s_branch .LBB19_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <56 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <56 x half> %a1 to <28 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <56 x half> %a to <28 x i32>
  br label %end

end:
  %phi = phi <28 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x i32> %phi
}

define <14 x i64> @bitcast_v28f32_to_v14i64(<28 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v28f32_to_v14i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB20_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; SI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; SI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; SI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; SI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB20_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v28f32_to_v14i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB20_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; VI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; VI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; VI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; VI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; VI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; VI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; VI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB20_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v28f32_to_v14i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB20_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v27, 1.0, v27
; GFX9-NEXT:    v_add_f32_e32 v26, 1.0, v26
; GFX9-NEXT:    v_add_f32_e32 v25, 1.0, v25
; GFX9-NEXT:    v_add_f32_e32 v24, 1.0, v24
; GFX9-NEXT:    v_add_f32_e32 v23, 1.0, v23
; GFX9-NEXT:    v_add_f32_e32 v22, 1.0, v22
; GFX9-NEXT:    v_add_f32_e32 v21, 1.0, v21
; GFX9-NEXT:    v_add_f32_e32 v20, 1.0, v20
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB20_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v28f32_to_v14i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB20_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-NEXT:    v_dual_add_f32 v25, 1.0, v25 :: v_dual_add_f32 v24, 1.0, v24
; GFX11-NEXT:    v_dual_add_f32 v23, 1.0, v23 :: v_dual_add_f32 v22, 1.0, v22
; GFX11-NEXT:    v_dual_add_f32 v21, 1.0, v21 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  .LBB20_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <28 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <28 x float> %a1 to <14 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <28 x float> %a to <14 x i64>
  br label %end

end:
  %phi = phi <14 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <14 x i64> %phi
}

define inreg <14 x i64> @bitcast_v28f32_to_v14i64_scalar(<28 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v28f32_to_v14i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v28, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB21_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB21_3
; SI-NEXT:  .LBB21_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; SI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; SI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; SI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; SI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB21_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v14, v28
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB21_4:
; SI-NEXT:    s_branch .LBB21_2
;
; VI-LABEL: bitcast_v28f32_to_v14i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v28, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB21_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB21_3
; VI-NEXT:  .LBB21_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; VI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; VI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; VI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; VI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; VI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; VI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; VI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB21_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v14, v28
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB21_4:
; VI-NEXT:    s_branch .LBB21_2
;
; GFX9-LABEL: bitcast_v28f32_to_v14i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v28, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB21_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB21_3
; GFX9-NEXT:  .LBB21_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v27, 1.0, v27
; GFX9-NEXT:    v_add_f32_e32 v26, 1.0, v26
; GFX9-NEXT:    v_add_f32_e32 v25, 1.0, v25
; GFX9-NEXT:    v_add_f32_e32 v24, 1.0, v24
; GFX9-NEXT:    v_add_f32_e32 v23, 1.0, v23
; GFX9-NEXT:    v_add_f32_e32 v22, 1.0, v22
; GFX9-NEXT:    v_add_f32_e32 v21, 1.0, v21
; GFX9-NEXT:    v_add_f32_e32 v20, 1.0, v20
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v28, 1.0, v28
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB21_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v14, v28
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB21_4:
; GFX9-NEXT:    s_branch .LBB21_2
;
; GFX11-LABEL: bitcast_v28f32_to_v14i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB21_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB21_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB21_3:
; GFX11-NEXT:  .LBB21_4: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-NEXT:    v_dual_add_f32 v25, 1.0, v25 :: v_dual_add_f32 v24, 1.0, v24
; GFX11-NEXT:    v_dual_add_f32 v23, 1.0, v23 :: v_dual_add_f32 v22, 1.0, v22
; GFX11-NEXT:    v_dual_add_f32 v21, 1.0, v21 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <28 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <28 x float> %a1 to <14 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <28 x float> %a to <14 x i64>
  br label %end

end:
  %phi = phi <14 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <14 x i64> %phi
}

define <28 x float> @bitcast_v14i64_to_v28f32(<14 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v14i64_to_v28f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB22_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_addc_u32_e32 v27, vcc, 0, v27, vcc
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_addc_u32_e32 v25, vcc, 0, v25, vcc
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_addc_u32_e32 v23, vcc, 0, v23, vcc
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v21, vcc
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  .LBB22_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v14i64_to_v28f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB22_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_addc_u32_e32 v27, vcc, 0, v27, vcc
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_addc_u32_e32 v25, vcc, 0, v25, vcc
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_addc_u32_e32 v23, vcc, 0, v23, vcc
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v21, vcc
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  .LBB22_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v14i64_to_v28f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB22_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v26, vcc, 3, v26
; GFX9-NEXT:    v_addc_co_u32_e32 v27, vcc, 0, v27, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v24, vcc, 3, v24
; GFX9-NEXT:    v_addc_co_u32_e32 v25, vcc, 0, v25, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v22, vcc, 3, v22
; GFX9-NEXT:    v_addc_co_u32_e32 v23, vcc, 0, v23, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v20, vcc, 3, v20
; GFX9-NEXT:    v_addc_co_u32_e32 v21, vcc, 0, v21, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, 3, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, 3, v16
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  .LBB22_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v14i64_to_v28f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB22_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v26, vcc_lo, v26, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v27, null, 0, v27, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v24, vcc_lo, v24, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v25, null, 0, v25, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v22, vcc_lo, v22, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v23, null, 0, v23, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v20, vcc_lo, v20, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v21, null, 0, v21, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  .LBB22_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <14 x i64> %a, splat (i64 3)
  %a2 = bitcast <14 x i64> %a1 to <28 x float>
  br label %end

cmp.false:
  %a3 = bitcast <14 x i64> %a to <28 x float>
  br label %end

end:
  %phi = phi <28 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x float> %phi
}

define inreg <28 x float> @bitcast_v14i64_to_v28f32_scalar(<14 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v14i64_to_v28f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v28, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB23_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB23_3
; SI-NEXT:  .LBB23_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    v_addc_u32_e32 v27, vcc, 0, v27, vcc
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_addc_u32_e32 v25, vcc, 0, v25, vcc
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_addc_u32_e32 v23, vcc, 0, v23, vcc
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v21, vcc
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  .LBB23_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v14, v28
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB23_4:
; SI-NEXT:    s_branch .LBB23_2
;
; VI-LABEL: bitcast_v14i64_to_v28f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v28, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB23_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB23_3
; VI-NEXT:  .LBB23_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v26, vcc, 3, v26
; VI-NEXT:    v_addc_u32_e32 v27, vcc, 0, v27, vcc
; VI-NEXT:    v_add_u32_e32 v24, vcc, 3, v24
; VI-NEXT:    v_addc_u32_e32 v25, vcc, 0, v25, vcc
; VI-NEXT:    v_add_u32_e32 v22, vcc, 3, v22
; VI-NEXT:    v_addc_u32_e32 v23, vcc, 0, v23, vcc
; VI-NEXT:    v_add_u32_e32 v20, vcc, 3, v20
; VI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v21, vcc
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; VI-NEXT:    v_add_u32_e32 v28, vcc, 3, v28
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  .LBB23_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v14, v28
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB23_4:
; VI-NEXT:    s_branch .LBB23_2
;
; GFX9-LABEL: bitcast_v14i64_to_v28f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v28, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB23_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB23_3
; GFX9-NEXT:  .LBB23_2: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v26, vcc, 3, v26
; GFX9-NEXT:    v_addc_co_u32_e32 v27, vcc, 0, v27, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v24, vcc, 3, v24
; GFX9-NEXT:    v_addc_co_u32_e32 v25, vcc, 0, v25, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v22, vcc, 3, v22
; GFX9-NEXT:    v_addc_co_u32_e32 v23, vcc, 0, v23, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v20, vcc, 3, v20
; GFX9-NEXT:    v_addc_co_u32_e32 v21, vcc, 0, v21, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, 3, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, 3, v16
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v28, vcc, 3, v28
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  .LBB23_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v14, v28
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB23_4:
; GFX9-NEXT:    s_branch .LBB23_2
;
; GFX11-LABEL: bitcast_v14i64_to_v28f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB23_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB23_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB23_3:
; GFX11-NEXT:  .LBB23_4: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v26, vcc_lo, v26, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v27, null, 0, v27, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v24, vcc_lo, v24, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v25, null, 0, v25, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v22, vcc_lo, v22, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v23, null, 0, v23, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v20, vcc_lo, v20, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v21, null, 0, v21, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <14 x i64> %a, splat (i64 3)
  %a2 = bitcast <14 x i64> %a1 to <28 x float>
  br label %end

cmp.false:
  %a3 = bitcast <14 x i64> %a to <28 x float>
  br label %end

end:
  %phi = phi <28 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x float> %phi
}

define <14 x double> @bitcast_v28f32_to_v14f64(<28 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v28f32_to_v14f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB24_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; SI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; SI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; SI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; SI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB24_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v28f32_to_v14f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB24_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; VI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; VI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; VI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; VI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; VI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; VI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; VI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB24_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v28f32_to_v14f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB24_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v27, 1.0, v27
; GFX9-NEXT:    v_add_f32_e32 v26, 1.0, v26
; GFX9-NEXT:    v_add_f32_e32 v25, 1.0, v25
; GFX9-NEXT:    v_add_f32_e32 v24, 1.0, v24
; GFX9-NEXT:    v_add_f32_e32 v23, 1.0, v23
; GFX9-NEXT:    v_add_f32_e32 v22, 1.0, v22
; GFX9-NEXT:    v_add_f32_e32 v21, 1.0, v21
; GFX9-NEXT:    v_add_f32_e32 v20, 1.0, v20
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB24_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v28f32_to_v14f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB24_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-NEXT:    v_dual_add_f32 v25, 1.0, v25 :: v_dual_add_f32 v24, 1.0, v24
; GFX11-NEXT:    v_dual_add_f32 v23, 1.0, v23 :: v_dual_add_f32 v22, 1.0, v22
; GFX11-NEXT:    v_dual_add_f32 v21, 1.0, v21 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  .LBB24_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <28 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <28 x float> %a1 to <14 x double>
  br label %end

cmp.false:
  %a3 = bitcast <28 x float> %a to <14 x double>
  br label %end

end:
  %phi = phi <14 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <14 x double> %phi
}

define inreg <14 x double> @bitcast_v28f32_to_v14f64_scalar(<28 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v28f32_to_v14f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v28, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB25_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB25_3
; SI-NEXT:  .LBB25_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; SI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; SI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; SI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; SI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB25_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v14, v28
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB25_4:
; SI-NEXT:    s_branch .LBB25_2
;
; VI-LABEL: bitcast_v28f32_to_v14f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v28, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB25_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB25_3
; VI-NEXT:  .LBB25_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; VI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; VI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; VI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; VI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; VI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; VI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; VI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB25_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v14, v28
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB25_4:
; VI-NEXT:    s_branch .LBB25_2
;
; GFX9-LABEL: bitcast_v28f32_to_v14f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v28, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB25_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB25_3
; GFX9-NEXT:  .LBB25_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v27, 1.0, v27
; GFX9-NEXT:    v_add_f32_e32 v26, 1.0, v26
; GFX9-NEXT:    v_add_f32_e32 v25, 1.0, v25
; GFX9-NEXT:    v_add_f32_e32 v24, 1.0, v24
; GFX9-NEXT:    v_add_f32_e32 v23, 1.0, v23
; GFX9-NEXT:    v_add_f32_e32 v22, 1.0, v22
; GFX9-NEXT:    v_add_f32_e32 v21, 1.0, v21
; GFX9-NEXT:    v_add_f32_e32 v20, 1.0, v20
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v28, 1.0, v28
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB25_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v14, v28
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB25_4:
; GFX9-NEXT:    s_branch .LBB25_2
;
; GFX11-LABEL: bitcast_v28f32_to_v14f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB25_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB25_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB25_3:
; GFX11-NEXT:  .LBB25_4: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-NEXT:    v_dual_add_f32 v25, 1.0, v25 :: v_dual_add_f32 v24, 1.0, v24
; GFX11-NEXT:    v_dual_add_f32 v23, 1.0, v23 :: v_dual_add_f32 v22, 1.0, v22
; GFX11-NEXT:    v_dual_add_f32 v21, 1.0, v21 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <28 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <28 x float> %a1 to <14 x double>
  br label %end

cmp.false:
  %a3 = bitcast <28 x float> %a to <14 x double>
  br label %end

end:
  %phi = phi <14 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <14 x double> %phi
}

define <28 x float> @bitcast_v14f64_to_v28f32(<14 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v14f64_to_v28f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB26_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; SI-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; SI-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; SI-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; SI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; SI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  .LBB26_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v14f64_to_v28f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB26_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; VI-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; VI-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; VI-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; VI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; VI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; VI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB26_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v14f64_to_v28f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB26_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; GFX9-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; GFX9-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; GFX9-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX9-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB26_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v14f64_to_v28f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB26_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; GFX11-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; GFX11-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; GFX11-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; GFX11-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX11-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX11-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB26_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <14 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <14 x double> %a1 to <28 x float>
  br label %end

cmp.false:
  %a3 = bitcast <14 x double> %a to <28 x float>
  br label %end

end:
  %phi = phi <28 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x float> %phi
}

define inreg <28 x float> @bitcast_v14f64_to_v28f32_scalar(<14 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v14f64_to_v28f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; SI-NEXT:    v_mov_b32_e32 v27, v13
; SI-NEXT:    v_mov_b32_e32 v26, v12
; SI-NEXT:    v_mov_b32_e32 v25, v11
; SI-NEXT:    v_mov_b32_e32 v24, v10
; SI-NEXT:    v_mov_b32_e32 v23, v9
; SI-NEXT:    v_mov_b32_e32 v22, v8
; SI-NEXT:    v_mov_b32_e32 v21, v7
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v29, v1
; SI-NEXT:    v_mov_b32_e32 v28, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB27_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB27_3
; SI-NEXT:  .LBB27_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; SI-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; SI-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; SI-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; SI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; SI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; SI-NEXT:    v_add_f64 v[28:29], v[28:29], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  .LBB27_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v14, v28
; SI-NEXT:    v_mov_b32_e32 v15, v29
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB27_4:
; SI-NEXT:    s_branch .LBB27_2
;
; VI-LABEL: bitcast_v14f64_to_v28f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v27, v13
; VI-NEXT:    v_mov_b32_e32 v26, v12
; VI-NEXT:    v_mov_b32_e32 v25, v11
; VI-NEXT:    v_mov_b32_e32 v24, v10
; VI-NEXT:    v_mov_b32_e32 v23, v9
; VI-NEXT:    v_mov_b32_e32 v22, v8
; VI-NEXT:    v_mov_b32_e32 v21, v7
; VI-NEXT:    v_mov_b32_e32 v20, v6
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v29, v1
; VI-NEXT:    v_mov_b32_e32 v28, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB27_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB27_3
; VI-NEXT:  .LBB27_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; VI-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; VI-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; VI-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; VI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; VI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; VI-NEXT:    v_add_f64 v[28:29], v[28:29], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB27_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v14, v28
; VI-NEXT:    v_mov_b32_e32 v15, v29
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB27_4:
; VI-NEXT:    s_branch .LBB27_2
;
; GFX9-LABEL: bitcast_v14f64_to_v28f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    v_mov_b32_e32 v27, v13
; GFX9-NEXT:    v_mov_b32_e32 v26, v12
; GFX9-NEXT:    v_mov_b32_e32 v25, v11
; GFX9-NEXT:    v_mov_b32_e32 v24, v10
; GFX9-NEXT:    v_mov_b32_e32 v23, v9
; GFX9-NEXT:    v_mov_b32_e32 v22, v8
; GFX9-NEXT:    v_mov_b32_e32 v21, v7
; GFX9-NEXT:    v_mov_b32_e32 v20, v6
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v29, v1
; GFX9-NEXT:    v_mov_b32_e32 v28, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB27_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB27_3
; GFX9-NEXT:  .LBB27_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; GFX9-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; GFX9-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; GFX9-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX9-NEXT:    v_add_f64 v[28:29], v[28:29], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB27_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v14, v28
; GFX9-NEXT:    v_mov_b32_e32 v15, v29
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB27_4:
; GFX9-NEXT:    s_branch .LBB27_2
;
; GFX11-LABEL: bitcast_v14f64_to_v28f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v10 :: v_dual_mov_b32 v27, v9
; GFX11-NEXT:    v_dual_mov_b32 v26, v8 :: v_dual_mov_b32 v25, v7
; GFX11-NEXT:    v_dual_mov_b32 v24, v6 :: v_dual_mov_b32 v23, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v22, v4 :: v_dual_mov_b32 v21, v3
; GFX11-NEXT:    v_dual_mov_b32 v20, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB27_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB27_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB27_3:
; GFX11-NEXT:  .LBB27_4: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[26:27], v[26:27], 1.0
; GFX11-NEXT:    v_add_f64 v[24:25], v[24:25], 1.0
; GFX11-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; GFX11-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; GFX11-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX11-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX11-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <14 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <14 x double> %a1 to <28 x float>
  br label %end

cmp.false:
  %a3 = bitcast <14 x double> %a to <28 x float>
  br label %end

end:
  %phi = phi <28 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x float> %phi
}

define <56 x i16> @bitcast_v28f32_to_v56i16(<28 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v28f32_to_v56i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v29
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB28_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v29, v28, v27, 16
; SI-NEXT:    v_alignbit_b32 v30, v26, v25, 16
; SI-NEXT:    v_alignbit_b32 v31, v24, v23, 16
; SI-NEXT:    v_alignbit_b32 v32, v22, v21, 16
; SI-NEXT:    v_alignbit_b32 v33, v20, v19, 16
; SI-NEXT:    v_alignbit_b32 v34, v18, v17, 16
; SI-NEXT:    v_alignbit_b32 v37, v16, v15, 16
; SI-NEXT:    v_alignbit_b32 v39, v14, v13, 16
; SI-NEXT:    v_alignbit_b32 v49, v12, v11, 16
; SI-NEXT:    v_alignbit_b32 v51, v10, v9, 16
; SI-NEXT:    v_alignbit_b32 v54, v8, v7, 16
; SI-NEXT:    v_alignbit_b32 v40, v6, v5, 16
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_alignbit_b32 v42, v4, v3, 16
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_alignbit_b32 v44, v2, v1, 16
; SI-NEXT:    v_lshrrev_b32_e32 v35, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v50, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v52, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v55, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v41, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v43, 16, v10
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_lshrrev_b32_e32 v45, 16, v8
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_lshrrev_b32_e32 v46, 16, v6
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_lshrrev_b32_e32 v47, 16, v4
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v56, 16, v2
; SI-NEXT:  .LBB28_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB28_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; SI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; SI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; SI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; SI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; SI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; SI-NEXT:    v_alignbit_b32 v29, v28, v27, 16
; SI-NEXT:    v_alignbit_b32 v30, v26, v25, 16
; SI-NEXT:    v_alignbit_b32 v31, v24, v23, 16
; SI-NEXT:    v_alignbit_b32 v32, v22, v21, 16
; SI-NEXT:    v_alignbit_b32 v33, v20, v19, 16
; SI-NEXT:    v_alignbit_b32 v34, v18, v17, 16
; SI-NEXT:    v_alignbit_b32 v37, v16, v15, 16
; SI-NEXT:    v_alignbit_b32 v39, v14, v13, 16
; SI-NEXT:    v_alignbit_b32 v49, v12, v11, 16
; SI-NEXT:    v_alignbit_b32 v51, v10, v9, 16
; SI-NEXT:    v_alignbit_b32 v54, v8, v7, 16
; SI-NEXT:    v_alignbit_b32 v40, v6, v5, 16
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_alignbit_b32 v42, v4, v3, 16
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_alignbit_b32 v44, v2, v1, 16
; SI-NEXT:    v_lshrrev_b32_e32 v35, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v50, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v52, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v55, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v41, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v43, 16, v10
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_lshrrev_b32_e32 v45, 16, v8
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_lshrrev_b32_e32 v46, 16, v6
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_lshrrev_b32_e32 v47, 16, v4
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v56, 16, v2
; SI-NEXT:  .LBB28_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v44, 16, v44
; SI-NEXT:    v_or_b32_e32 v1, v1, v44
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v56
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 4, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v42
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 8, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v47
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 12, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v40
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 16, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v46
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 20, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v7
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v54
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 24, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v8
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v45
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 28, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v9
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v51
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 32, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v10
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v43
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 36, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v11
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v49
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 40, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v12
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v41
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v13
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v39
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v14
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v55
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 52, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v15
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v37
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 56, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v16
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v53
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 60, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v17
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v34
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 64, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v18
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v52
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v19
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v33
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v20
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v50
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x4c, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v21
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v32
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x50, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v22
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v48
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x54, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v23
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v31
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x58, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v24
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v38
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x5c, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v25
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v30
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x60, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v26
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v36
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x64, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v27
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v29
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x68, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v28
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v35
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x6c, v0
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v28f32_to_v56i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr47
; VI-NEXT:    ; implicit-def: $vgpr46
; VI-NEXT:    ; implicit-def: $vgpr45
; VI-NEXT:    ; implicit-def: $vgpr44
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB28_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; VI-NEXT:  .LBB28_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB28_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; VI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; VI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; VI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; VI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; VI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; VI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; VI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; VI-NEXT:  .LBB28_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_lshlrev_b32_e32 v47, 16, v47
; VI-NEXT:    v_lshlrev_b32_e32 v46, 16, v46
; VI-NEXT:    v_lshlrev_b32_e32 v45, 16, v45
; VI-NEXT:    v_lshlrev_b32_e32 v44, 16, v44
; VI-NEXT:    v_lshlrev_b32_e32 v43, 16, v43
; VI-NEXT:    v_lshlrev_b32_e32 v42, 16, v42
; VI-NEXT:    v_lshlrev_b32_e32 v41, 16, v41
; VI-NEXT:    v_lshlrev_b32_e32 v40, 16, v40
; VI-NEXT:    v_or_b32_sdwa v0, v0, v47 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v46 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v45 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v44 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v43 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v42 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v41 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v40 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; VI-NEXT:    v_lshlrev_b32_e32 v55, 16, v55
; VI-NEXT:    v_lshlrev_b32_e32 v54, 16, v54
; VI-NEXT:    v_lshlrev_b32_e32 v53, 16, v53
; VI-NEXT:    v_lshlrev_b32_e32 v52, 16, v52
; VI-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; VI-NEXT:    v_lshlrev_b32_e32 v50, 16, v50
; VI-NEXT:    v_lshlrev_b32_e32 v49, 16, v49
; VI-NEXT:    v_lshlrev_b32_e32 v48, 16, v48
; VI-NEXT:    v_lshlrev_b32_e32 v39, 16, v39
; VI-NEXT:    v_lshlrev_b32_e32 v38, 16, v38
; VI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; VI-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; VI-NEXT:    v_lshlrev_b32_e32 v35, 16, v35
; VI-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; VI-NEXT:    v_lshlrev_b32_e32 v33, 16, v33
; VI-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; VI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; VI-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; VI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; VI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; VI-NEXT:    v_or_b32_sdwa v8, v8, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v9, v54 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v10, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v11, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v12, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v13, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v14, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v15, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v16, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v17, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v18, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v19, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v20, v20, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v21, v21, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v22, v22, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v23, v23, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v24, v24, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v25, v25, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v26, v26, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v27, v27, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v28f32_to_v56i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB28_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; GFX9-NEXT:  .LBB28_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB28_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v27, 1.0, v27
; GFX9-NEXT:    v_add_f32_e32 v26, 1.0, v26
; GFX9-NEXT:    v_add_f32_e32 v25, 1.0, v25
; GFX9-NEXT:    v_add_f32_e32 v24, 1.0, v24
; GFX9-NEXT:    v_add_f32_e32 v23, 1.0, v23
; GFX9-NEXT:    v_add_f32_e32 v22, 1.0, v22
; GFX9-NEXT:    v_add_f32_e32 v21, 1.0, v21
; GFX9-NEXT:    v_add_f32_e32 v20, 1.0, v20
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; GFX9-NEXT:  .LBB28_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v47, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v46, v1, s4
; GFX9-NEXT:    v_perm_b32 v2, v45, v2, s4
; GFX9-NEXT:    v_perm_b32 v3, v44, v3, s4
; GFX9-NEXT:    v_perm_b32 v4, v43, v4, s4
; GFX9-NEXT:    v_perm_b32 v5, v42, v5, s4
; GFX9-NEXT:    v_perm_b32 v6, v41, v6, s4
; GFX9-NEXT:    v_perm_b32 v7, v40, v7, s4
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    v_perm_b32 v8, v55, v8, s4
; GFX9-NEXT:    v_perm_b32 v9, v54, v9, s4
; GFX9-NEXT:    v_perm_b32 v10, v53, v10, s4
; GFX9-NEXT:    v_perm_b32 v11, v52, v11, s4
; GFX9-NEXT:    v_perm_b32 v12, v51, v12, s4
; GFX9-NEXT:    v_perm_b32 v13, v50, v13, s4
; GFX9-NEXT:    v_perm_b32 v14, v49, v14, s4
; GFX9-NEXT:    v_perm_b32 v15, v48, v15, s4
; GFX9-NEXT:    v_perm_b32 v16, v39, v16, s4
; GFX9-NEXT:    v_perm_b32 v17, v38, v17, s4
; GFX9-NEXT:    v_perm_b32 v18, v37, v18, s4
; GFX9-NEXT:    v_perm_b32 v19, v36, v19, s4
; GFX9-NEXT:    v_perm_b32 v20, v35, v20, s4
; GFX9-NEXT:    v_perm_b32 v21, v34, v21, s4
; GFX9-NEXT:    v_perm_b32 v22, v33, v22, s4
; GFX9-NEXT:    v_perm_b32 v23, v32, v23, s4
; GFX9-NEXT:    v_perm_b32 v24, v31, v24, s4
; GFX9-NEXT:    v_perm_b32 v25, v30, v25, s4
; GFX9-NEXT:    v_perm_b32 v26, v29, v26, s4
; GFX9-NEXT:    v_perm_b32 v27, v28, v27, s4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v28f32_to_v56i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB28_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v25, 1.0, v25 :: v_dual_add_f32 v24, 1.0, v24
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v23, 1.0, v23 :: v_dual_add_f32 v22, 1.0, v22
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v21, 1.0, v21 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-TRUE16-NEXT:  .LBB28_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v28f32_to_v56i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr71
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr70
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr69
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr68
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr67
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr66
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr65
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr64
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr55
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr54
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr53
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr52
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr51
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr50
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr49
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr48
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB28_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v65, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v66, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v0
; GFX11-FAKE16-NEXT:  .LBB28_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB28_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v25, 1.0, v25 :: v_dual_add_f32 v24, 1.0, v24
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v23, 1.0, v23 :: v_dual_add_f32 v22, 1.0, v22
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v21, 1.0, v21 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v65, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v66, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v0
; GFX11-FAKE16-NEXT:  .LBB28_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v71, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v70, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v69, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v68, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v67, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v66, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v65, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v64, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v55, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v54, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v53, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v52, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v51, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v50, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v49, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v48, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v39, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v38, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v37, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v36, v19, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v20, v35, v20, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v21, v34, v21, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v22, v33, v22, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v23, v32, v23, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v24, v31, v24, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v25, v30, v25, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v26, v29, v26, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v27, v28, v27, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <28 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <28 x float> %a1 to <56 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <28 x float> %a to <56 x i16>
  br label %end

end:
  %phi = phi <56 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <56 x i16> %phi
}

define inreg <56 x i16> @bitcast_v28f32_to_v56i16_scalar(<28 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v28f32_to_v56i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v15
; SI-NEXT:    v_mov_b32_e32 v30, s16
; SI-NEXT:    v_mov_b32_e32 v29, s17
; SI-NEXT:    v_mov_b32_e32 v25, s18
; SI-NEXT:    v_mov_b32_e32 v23, s19
; SI-NEXT:    v_mov_b32_e32 v28, s20
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v26, s21
; SI-NEXT:    v_mov_b32_e32 v24, s22
; SI-NEXT:    v_mov_b32_e32 v22, s23
; SI-NEXT:    v_mov_b32_e32 v20, s24
; SI-NEXT:    v_mov_b32_e32 v19, s25
; SI-NEXT:    v_mov_b32_e32 v18, s26
; SI-NEXT:    v_mov_b32_e32 v17, s27
; SI-NEXT:    v_mov_b32_e32 v16, s28
; SI-NEXT:    v_mov_b32_e32 v15, s29
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_cbranch_scc0 .LBB29_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v21, v14, v13, 16
; SI-NEXT:    v_alignbit_b32 v27, v12, v11, 16
; SI-NEXT:    v_alignbit_b32 v31, v10, v9, 16
; SI-NEXT:    v_alignbit_b32 v32, v8, v7, 16
; SI-NEXT:    v_alignbit_b32 v33, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v34, v4, v3, 16
; SI-NEXT:    v_alignbit_b32 v37, v2, v1, 16
; SI-NEXT:    v_alignbit_b32 v39, v15, v16, 16
; SI-NEXT:    v_alignbit_b32 v49, v17, v18, 16
; SI-NEXT:    v_alignbit_b32 v51, v19, v20, 16
; SI-NEXT:    v_alignbit_b32 v54, v22, v24, 16
; SI-NEXT:    v_alignbit_b32 v40, v26, v28, 16
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_alignbit_b32 v42, v23, v25, 16
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_alignbit_b32 v44, v29, v30, 16
; SI-NEXT:    v_lshrrev_b32_e32 v35, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v50, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v52, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v55, 16, v15
; SI-NEXT:    v_lshrrev_b32_e32 v41, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v43, 16, v19
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_lshrrev_b32_e32 v45, 16, v22
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_lshrrev_b32_e32 v46, 16, v26
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_lshrrev_b32_e32 v47, 16, v23
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v56, 16, v29
; SI-NEXT:    s_cbranch_execnz .LBB29_3
; SI-NEXT:  .LBB29_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v29, 1.0, v29
; SI-NEXT:    v_add_f32_e32 v30, 1.0, v30
; SI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; SI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; SI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; SI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; SI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_alignbit_b32 v21, v14, v13, 16
; SI-NEXT:    v_alignbit_b32 v27, v12, v11, 16
; SI-NEXT:    v_alignbit_b32 v31, v10, v9, 16
; SI-NEXT:    v_alignbit_b32 v32, v8, v7, 16
; SI-NEXT:    v_alignbit_b32 v33, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v34, v4, v3, 16
; SI-NEXT:    v_alignbit_b32 v37, v2, v1, 16
; SI-NEXT:    v_alignbit_b32 v39, v15, v16, 16
; SI-NEXT:    v_alignbit_b32 v49, v17, v18, 16
; SI-NEXT:    v_alignbit_b32 v51, v19, v20, 16
; SI-NEXT:    v_alignbit_b32 v54, v22, v24, 16
; SI-NEXT:    v_alignbit_b32 v40, v26, v28, 16
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_alignbit_b32 v42, v23, v25, 16
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_alignbit_b32 v44, v29, v30, 16
; SI-NEXT:    v_lshrrev_b32_e32 v35, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v50, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v52, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v55, 16, v15
; SI-NEXT:    v_lshrrev_b32_e32 v41, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v43, 16, v19
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_lshrrev_b32_e32 v45, 16, v22
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_lshrrev_b32_e32 v46, 16, v26
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_lshrrev_b32_e32 v47, 16, v23
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v56, 16, v29
; SI-NEXT:  .LBB29_3: ; %end
; SI-NEXT:    v_and_b32_e32 v30, 0xffff, v30
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v44, 16, v44
; SI-NEXT:    v_or_b32_e32 v30, v30, v44
; SI-NEXT:    buffer_store_dword v30, v0, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v29, 0xffff, v29
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v30, 16, v56
; SI-NEXT:    v_or_b32_e32 v29, v29, v30
; SI-NEXT:    v_add_i32_e32 v30, vcc, 4, v0
; SI-NEXT:    buffer_store_dword v29, v30, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v25, 0xffff, v25
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v29, 16, v42
; SI-NEXT:    v_or_b32_e32 v25, v25, v29
; SI-NEXT:    v_add_i32_e32 v29, vcc, 8, v0
; SI-NEXT:    buffer_store_dword v25, v29, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v23, 0xffff, v23
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v47
; SI-NEXT:    v_or_b32_e32 v23, v23, v25
; SI-NEXT:    v_add_i32_e32 v25, vcc, 12, v0
; SI-NEXT:    buffer_store_dword v23, v25, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v23, 0xffff, v28
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v40
; SI-NEXT:    v_or_b32_e32 v23, v23, v25
; SI-NEXT:    v_add_i32_e32 v25, vcc, 16, v0
; SI-NEXT:    buffer_store_dword v23, v25, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v23, 0xffff, v26
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v46
; SI-NEXT:    v_or_b32_e32 v23, v23, v25
; SI-NEXT:    v_add_i32_e32 v25, vcc, 20, v0
; SI-NEXT:    buffer_store_dword v23, v25, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v23, 0xffff, v24
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v54
; SI-NEXT:    v_or_b32_e32 v23, v23, v24
; SI-NEXT:    v_add_i32_e32 v24, vcc, 24, v0
; SI-NEXT:    buffer_store_dword v23, v24, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v45
; SI-NEXT:    v_or_b32_e32 v22, v22, v23
; SI-NEXT:    v_add_i32_e32 v23, vcc, 28, v0
; SI-NEXT:    buffer_store_dword v22, v23, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v51
; SI-NEXT:    v_or_b32_e32 v20, v20, v22
; SI-NEXT:    v_add_i32_e32 v22, vcc, 32, v0
; SI-NEXT:    buffer_store_dword v20, v22, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v43
; SI-NEXT:    v_or_b32_e32 v19, v19, v20
; SI-NEXT:    v_add_i32_e32 v20, vcc, 36, v0
; SI-NEXT:    buffer_store_dword v19, v20, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v49
; SI-NEXT:    v_or_b32_e32 v18, v18, v19
; SI-NEXT:    v_add_i32_e32 v19, vcc, 40, v0
; SI-NEXT:    buffer_store_dword v18, v19, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v41
; SI-NEXT:    v_or_b32_e32 v17, v17, v18
; SI-NEXT:    v_add_i32_e32 v18, vcc, 44, v0
; SI-NEXT:    buffer_store_dword v17, v18, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v39
; SI-NEXT:    v_or_b32_e32 v16, v16, v17
; SI-NEXT:    v_add_i32_e32 v17, vcc, 48, v0
; SI-NEXT:    buffer_store_dword v16, v17, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v55
; SI-NEXT:    v_or_b32_e32 v15, v15, v16
; SI-NEXT:    v_add_i32_e32 v16, vcc, 52, v0
; SI-NEXT:    buffer_store_dword v15, v16, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v37
; SI-NEXT:    v_or_b32_e32 v1, v1, v15
; SI-NEXT:    v_add_i32_e32 v15, vcc, 56, v0
; SI-NEXT:    buffer_store_dword v1, v15, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v53
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 60, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v34
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 64, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v52
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v33
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v50
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x4c, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v7
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v32
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x50, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v8
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v48
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x54, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v9
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v31
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x58, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v10
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v38
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x5c, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v11
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v27
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x60, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v12
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v36
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x64, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v13
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v21
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x68, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v14
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v35
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x6c, v0
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB29_4:
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    s_branch .LBB29_2
;
; VI-LABEL: bitcast_v28f32_to_v56i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v20, s16
; VI-NEXT:    v_mov_b32_e32 v18, s17
; VI-NEXT:    v_mov_b32_e32 v17, s18
; VI-NEXT:    v_mov_b32_e32 v16, s19
; VI-NEXT:    v_mov_b32_e32 v15, s20
; VI-NEXT:    v_mov_b32_e32 v26, s21
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v27, s22
; VI-NEXT:    v_mov_b32_e32 v25, s23
; VI-NEXT:    v_mov_b32_e32 v24, s24
; VI-NEXT:    v_mov_b32_e32 v23, s25
; VI-NEXT:    v_mov_b32_e32 v22, s26
; VI-NEXT:    v_mov_b32_e32 v21, s27
; VI-NEXT:    v_mov_b32_e32 v19, s28
; VI-NEXT:    v_mov_b32_e32 v14, s29
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    s_cbranch_scc0 .LBB29_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v48, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v21
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v22
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v23
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v24
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v25
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v27
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v26
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v20
; VI-NEXT:    s_cbranch_execnz .LBB29_3
; VI-NEXT:  .LBB29_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; VI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; VI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; VI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; VI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; VI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; VI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; VI-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v48, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v21
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v22
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v23
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v24
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v25
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v27
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v26
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v20
; VI-NEXT:  .LBB29_3: ; %end
; VI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; VI-NEXT:    v_or_b32_sdwa v28, v20, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v20, 16, v29
; VI-NEXT:    v_or_b32_sdwa v29, v18, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v18, 16, v30
; VI-NEXT:    v_or_b32_sdwa v30, v17, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v17, 16, v31
; VI-NEXT:    v_or_b32_sdwa v31, v16, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v32
; VI-NEXT:    v_or_b32_sdwa v32, v15, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v33
; VI-NEXT:    v_or_b32_sdwa v33, v26, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v34
; VI-NEXT:    v_or_b32_sdwa v34, v27, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v35
; VI-NEXT:    v_or_b32_sdwa v35, v25, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v36
; VI-NEXT:    v_or_b32_sdwa v36, v24, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v37
; VI-NEXT:    v_or_b32_sdwa v37, v23, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v38
; VI-NEXT:    v_or_b32_sdwa v38, v22, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v39
; VI-NEXT:    v_or_b32_sdwa v39, v21, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v48
; VI-NEXT:    v_or_b32_sdwa v48, v19, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v49
; VI-NEXT:    v_or_b32_sdwa v49, v14, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v47
; VI-NEXT:    v_or_b32_sdwa v14, v0, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v46
; VI-NEXT:    v_or_b32_sdwa v15, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v45
; VI-NEXT:    v_or_b32_sdwa v16, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v44
; VI-NEXT:    v_or_b32_sdwa v17, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v43
; VI-NEXT:    v_or_b32_sdwa v18, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v42
; VI-NEXT:    v_or_b32_sdwa v19, v5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v41
; VI-NEXT:    v_or_b32_sdwa v20, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v40
; VI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; VI-NEXT:    v_or_b32_sdwa v21, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v55
; VI-NEXT:    v_or_b32_sdwa v22, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v54
; VI-NEXT:    v_or_b32_sdwa v23, v9, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v53
; VI-NEXT:    v_or_b32_sdwa v24, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v52
; VI-NEXT:    v_or_b32_sdwa v25, v11, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v51
; VI-NEXT:    v_or_b32_sdwa v26, v12, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v50
; VI-NEXT:    v_or_b32_sdwa v27, v13, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, v28
; VI-NEXT:    v_mov_b32_e32 v1, v29
; VI-NEXT:    v_mov_b32_e32 v2, v30
; VI-NEXT:    v_mov_b32_e32 v3, v31
; VI-NEXT:    v_mov_b32_e32 v4, v32
; VI-NEXT:    v_mov_b32_e32 v5, v33
; VI-NEXT:    v_mov_b32_e32 v6, v34
; VI-NEXT:    v_mov_b32_e32 v7, v35
; VI-NEXT:    v_mov_b32_e32 v8, v36
; VI-NEXT:    v_mov_b32_e32 v9, v37
; VI-NEXT:    v_mov_b32_e32 v10, v38
; VI-NEXT:    v_mov_b32_e32 v11, v39
; VI-NEXT:    v_mov_b32_e32 v12, v48
; VI-NEXT:    v_mov_b32_e32 v13, v49
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB29_4:
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr47
; VI-NEXT:    ; implicit-def: $vgpr46
; VI-NEXT:    ; implicit-def: $vgpr45
; VI-NEXT:    ; implicit-def: $vgpr44
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    s_branch .LBB29_2
;
; GFX9-LABEL: bitcast_v28f32_to_v56i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    v_mov_b32_e32 v20, s16
; GFX9-NEXT:    v_mov_b32_e32 v18, s17
; GFX9-NEXT:    v_mov_b32_e32 v17, s18
; GFX9-NEXT:    v_mov_b32_e32 v16, s19
; GFX9-NEXT:    v_mov_b32_e32 v15, s20
; GFX9-NEXT:    v_mov_b32_e32 v26, s21
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v27, s22
; GFX9-NEXT:    v_mov_b32_e32 v25, s23
; GFX9-NEXT:    v_mov_b32_e32 v24, s24
; GFX9-NEXT:    v_mov_b32_e32 v23, s25
; GFX9-NEXT:    v_mov_b32_e32 v22, s26
; GFX9-NEXT:    v_mov_b32_e32 v21, s27
; GFX9-NEXT:    v_mov_b32_e32 v19, s28
; GFX9-NEXT:    v_mov_b32_e32 v14, s29
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    s_cbranch_scc0 .LBB29_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v21
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v22
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v23
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v24
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v27
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v26
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v20
; GFX9-NEXT:    s_cbranch_execnz .LBB29_3
; GFX9-NEXT:  .LBB29_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v21, 1.0, v21
; GFX9-NEXT:    v_add_f32_e32 v22, 1.0, v22
; GFX9-NEXT:    v_add_f32_e32 v23, 1.0, v23
; GFX9-NEXT:    v_add_f32_e32 v24, 1.0, v24
; GFX9-NEXT:    v_add_f32_e32 v25, 1.0, v25
; GFX9-NEXT:    v_add_f32_e32 v27, 1.0, v27
; GFX9-NEXT:    v_add_f32_e32 v26, 1.0, v26
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v20, 1.0, v20
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v21
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v22
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v23
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v24
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v27
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v26
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v20
; GFX9-NEXT:  .LBB29_3: ; %end
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX9-NEXT:    v_lshl_or_b32 v32, v32, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v26
; GFX9-NEXT:    v_lshl_or_b32 v33, v33, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v27
; GFX9-NEXT:    v_lshl_or_b32 v34, v34, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v25
; GFX9-NEXT:    v_lshl_or_b32 v35, v35, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v24
; GFX9-NEXT:    v_lshl_or_b32 v36, v36, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v23
; GFX9-NEXT:    v_lshl_or_b32 v37, v37, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v22
; GFX9-NEXT:    v_lshl_or_b32 v38, v38, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v21
; GFX9-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX9-NEXT:    v_lshl_or_b32 v39, v39, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v19
; GFX9-NEXT:    v_lshl_or_b32 v49, v49, 16, v14
; GFX9-NEXT:    v_lshl_or_b32 v14, v47, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v1
; GFX9-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; GFX9-NEXT:    v_lshl_or_b32 v48, v48, 16, v15
; GFX9-NEXT:    v_lshl_or_b32 v15, v46, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v2
; GFX9-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX9-NEXT:    v_lshl_or_b32 v31, v31, 16, v16
; GFX9-NEXT:    v_lshl_or_b32 v16, v45, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v3
; GFX9-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; GFX9-NEXT:    v_lshl_or_b32 v30, v30, 16, v17
; GFX9-NEXT:    v_lshl_or_b32 v17, v44, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v4
; GFX9-NEXT:    v_lshl_or_b32 v29, v29, 16, v18
; GFX9-NEXT:    v_lshl_or_b32 v18, v43, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v5
; GFX9-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; GFX9-NEXT:    v_lshl_or_b32 v19, v42, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v6
; GFX9-NEXT:    v_lshl_or_b32 v28, v28, 16, v20
; GFX9-NEXT:    v_lshl_or_b32 v20, v41, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v7
; GFX9-NEXT:    v_lshl_or_b32 v21, v40, 16, v0
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v8
; GFX9-NEXT:    v_lshl_or_b32 v22, v55, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v9
; GFX9-NEXT:    v_lshl_or_b32 v23, v54, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v10
; GFX9-NEXT:    v_lshl_or_b32 v24, v53, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v11
; GFX9-NEXT:    v_lshl_or_b32 v25, v52, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v12
; GFX9-NEXT:    v_lshl_or_b32 v26, v51, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v13
; GFX9-NEXT:    v_lshl_or_b32 v27, v50, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v28
; GFX9-NEXT:    v_mov_b32_e32 v1, v29
; GFX9-NEXT:    v_mov_b32_e32 v2, v30
; GFX9-NEXT:    v_mov_b32_e32 v3, v31
; GFX9-NEXT:    v_mov_b32_e32 v4, v32
; GFX9-NEXT:    v_mov_b32_e32 v5, v33
; GFX9-NEXT:    v_mov_b32_e32 v6, v34
; GFX9-NEXT:    v_mov_b32_e32 v7, v35
; GFX9-NEXT:    v_mov_b32_e32 v8, v36
; GFX9-NEXT:    v_mov_b32_e32 v9, v37
; GFX9-NEXT:    v_mov_b32_e32 v10, v38
; GFX9-NEXT:    v_mov_b32_e32 v11, v39
; GFX9-NEXT:    v_mov_b32_e32 v12, v48
; GFX9-NEXT:    v_mov_b32_e32 v13, v49
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB29_4:
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    s_branch .LBB29_2
;
; GFX11-LABEL: bitcast_v28f32_to_v56i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v10
; GFX11-NEXT:    v_dual_mov_b32 v28, s0 :: v_dual_mov_b32 v27, s1
; GFX11-NEXT:    v_dual_mov_b32 v26, s2 :: v_dual_mov_b32 v25, s3
; GFX11-NEXT:    v_dual_mov_b32 v24, s16 :: v_dual_mov_b32 v23, s17
; GFX11-NEXT:    v_dual_mov_b32 v22, s18 :: v_dual_mov_b32 v21, s19
; GFX11-NEXT:    v_dual_mov_b32 v20, s20 :: v_dual_mov_b32 v19, s21
; GFX11-NEXT:    v_dual_mov_b32 v18, s22 :: v_dual_mov_b32 v11, s24
; GFX11-NEXT:    v_dual_mov_b32 v12, s23 :: v_dual_mov_b32 v15, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v13, s27
; GFX11-NEXT:    v_dual_mov_b32 v17, s28 :: v_dual_mov_b32 v16, s29
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB29_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    v_lshrrev_b32_e32 v38, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v39, 16, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v48, 16, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v49, 16, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v50, 16, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v51, 16, v4
; GFX11-NEXT:    v_lshrrev_b32_e32 v52, 16, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v53, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v54, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v55, 16, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v64, 16, v16
; GFX11-NEXT:    v_lshrrev_b32_e32 v65, 16, v17
; GFX11-NEXT:    v_lshrrev_b32_e32 v66, 16, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v67, 16, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v68, 16, v15
; GFX11-NEXT:    v_lshrrev_b32_e32 v69, 16, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v70, 16, v12
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v18
; GFX11-NEXT:    v_lshrrev_b32_e32 v29, 16, v19
; GFX11-NEXT:    v_lshrrev_b32_e32 v71, 16, v20
; GFX11-NEXT:    v_lshrrev_b32_e32 v37, 16, v21
; GFX11-NEXT:    v_lshrrev_b32_e32 v36, 16, v22
; GFX11-NEXT:    v_lshrrev_b32_e32 v35, 16, v23
; GFX11-NEXT:    v_lshrrev_b32_e32 v34, 16, v24
; GFX11-NEXT:    v_lshrrev_b32_e32 v33, 16, v25
; GFX11-NEXT:    v_lshrrev_b32_e32 v32, 16, v26
; GFX11-NEXT:    v_lshrrev_b32_e32 v31, 16, v27
; GFX11-NEXT:    v_lshrrev_b32_e32 v30, 16, v28
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB29_3
; GFX11-NEXT:  .LBB29_2: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:    v_dual_add_f32 v16, 1.0, v16 :: v_dual_add_f32 v17, 1.0, v17
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-NEXT:    v_dual_add_f32 v21, 1.0, v21 :: v_dual_add_f32 v22, 1.0, v22
; GFX11-NEXT:    v_dual_add_f32 v23, 1.0, v23 :: v_dual_add_f32 v24, 1.0, v24
; GFX11-NEXT:    v_dual_add_f32 v25, 1.0, v25 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v28, 1.0, v28
; GFX11-NEXT:    v_lshrrev_b32_e32 v38, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v39, 16, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v48, 16, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v49, 16, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v50, 16, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v51, 16, v4
; GFX11-NEXT:    v_lshrrev_b32_e32 v52, 16, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v53, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v54, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v55, 16, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v64, 16, v16
; GFX11-NEXT:    v_lshrrev_b32_e32 v65, 16, v17
; GFX11-NEXT:    v_lshrrev_b32_e32 v66, 16, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v67, 16, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v68, 16, v15
; GFX11-NEXT:    v_lshrrev_b32_e32 v69, 16, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v70, 16, v12
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v18
; GFX11-NEXT:    v_lshrrev_b32_e32 v29, 16, v19
; GFX11-NEXT:    v_lshrrev_b32_e32 v71, 16, v20
; GFX11-NEXT:    v_lshrrev_b32_e32 v37, 16, v21
; GFX11-NEXT:    v_lshrrev_b32_e32 v36, 16, v22
; GFX11-NEXT:    v_lshrrev_b32_e32 v35, 16, v23
; GFX11-NEXT:    v_lshrrev_b32_e32 v34, 16, v24
; GFX11-NEXT:    v_lshrrev_b32_e32 v33, 16, v25
; GFX11-NEXT:    v_lshrrev_b32_e32 v32, 16, v26
; GFX11-NEXT:    v_lshrrev_b32_e32 v31, 16, v27
; GFX11-NEXT:    v_lshrrev_b32_e32 v30, 16, v28
; GFX11-NEXT:  .LBB29_3: ; %end
; GFX11-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; GFX11-NEXT:    v_and_b32_e32 v27, 0xffff, v27
; GFX11-NEXT:    v_and_b32_e32 v25, 0xffff, v25
; GFX11-NEXT:    v_and_b32_e32 v23, 0xffff, v23
; GFX11-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; GFX11-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; GFX11-NEXT:    v_lshl_or_b32 v29, v29, 16, v19
; GFX11-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX11-NEXT:    v_and_b32_e32 v19, 0xffff, v16
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_lshl_or_b32 v31, v31, 16, v27
; GFX11-NEXT:    v_and_b32_e32 v28, 0xffff, v28
; GFX11-NEXT:    v_lshl_or_b32 v33, v33, 16, v25
; GFX11-NEXT:    v_and_b32_e32 v26, 0xffff, v26
; GFX11-NEXT:    v_lshl_or_b32 v35, v35, 16, v23
; GFX11-NEXT:    v_and_b32_e32 v24, 0xffff, v24
; GFX11-NEXT:    v_lshl_or_b32 v37, v37, 16, v21
; GFX11-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; GFX11-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; GFX11-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX11-NEXT:    v_and_b32_e32 v21, 0xffff, v11
; GFX11-NEXT:    v_lshl_or_b32 v10, v10, 16, v18
; GFX11-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-NEXT:    v_and_b32_e32 v18, 0xffff, v13
; GFX11-NEXT:    v_lshl_or_b32 v16, v65, 16, v17
; GFX11-NEXT:    v_lshl_or_b32 v17, v64, 16, v19
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-NEXT:    v_lshl_or_b32 v19, v54, 16, v1
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v6
; GFX11-NEXT:    v_lshl_or_b32 v32, v32, 16, v26
; GFX11-NEXT:    v_lshl_or_b32 v11, v70, 16, v12
; GFX11-NEXT:    v_lshl_or_b32 v12, v69, 16, v21
; GFX11-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX11-NEXT:    v_lshl_or_b32 v13, v68, 16, v15
; GFX11-NEXT:    v_lshl_or_b32 v15, v66, 16, v18
; GFX11-NEXT:    v_lshl_or_b32 v18, v55, 16, v0
; GFX11-NEXT:    v_lshl_or_b32 v21, v52, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v5
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v8
; GFX11-NEXT:    v_mov_b32_e32 v5, v35
; GFX11-NEXT:    v_lshl_or_b32 v34, v34, 16, v24
; GFX11-NEXT:    v_lshl_or_b32 v24, v49, 16, v1
; GFX11-NEXT:    v_mov_b32_e32 v1, v31
; GFX11-NEXT:    v_lshl_or_b32 v30, v30, 16, v28
; GFX11-NEXT:    v_lshl_or_b32 v28, v71, 16, v20
; GFX11-NEXT:    v_lshl_or_b32 v20, v53, 16, v2
; GFX11-NEXT:    v_dual_mov_b32 v7, v37 :: v_dual_and_b32 v2, 0xffff, v7
; GFX11-NEXT:    v_lshl_or_b32 v36, v36, 16, v22
; GFX11-NEXT:    v_lshl_or_b32 v22, v51, 16, v4
; GFX11-NEXT:    v_and_b32_e32 v4, 0xffff, v9
; GFX11-NEXT:    v_lshl_or_b32 v14, v67, 16, v14
; GFX11-NEXT:    v_lshl_or_b32 v23, v50, 16, v0
; GFX11-NEXT:    v_lshl_or_b32 v25, v48, 16, v2
; GFX11-NEXT:    v_lshl_or_b32 v26, v39, 16, v3
; GFX11-NEXT:    v_lshl_or_b32 v27, v38, 16, v4
; GFX11-NEXT:    v_mov_b32_e32 v0, v30
; GFX11-NEXT:    v_dual_mov_b32 v2, v32 :: v_dual_mov_b32 v3, v33
; GFX11-NEXT:    v_mov_b32_e32 v4, v34
; GFX11-NEXT:    v_mov_b32_e32 v6, v36
; GFX11-NEXT:    v_dual_mov_b32 v8, v28 :: v_dual_mov_b32 v9, v29
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB29_4:
; GFX11-NEXT:    ; implicit-def: $vgpr30
; GFX11-NEXT:    ; implicit-def: $vgpr31
; GFX11-NEXT:    ; implicit-def: $vgpr32
; GFX11-NEXT:    ; implicit-def: $vgpr33
; GFX11-NEXT:    ; implicit-def: $vgpr34
; GFX11-NEXT:    ; implicit-def: $vgpr35
; GFX11-NEXT:    ; implicit-def: $vgpr36
; GFX11-NEXT:    ; implicit-def: $vgpr37
; GFX11-NEXT:    ; implicit-def: $vgpr71
; GFX11-NEXT:    ; implicit-def: $vgpr29
; GFX11-NEXT:    ; implicit-def: $vgpr10
; GFX11-NEXT:    ; implicit-def: $vgpr70
; GFX11-NEXT:    ; implicit-def: $vgpr69
; GFX11-NEXT:    ; implicit-def: $vgpr68
; GFX11-NEXT:    ; implicit-def: $vgpr67
; GFX11-NEXT:    ; implicit-def: $vgpr66
; GFX11-NEXT:    ; implicit-def: $vgpr65
; GFX11-NEXT:    ; implicit-def: $vgpr64
; GFX11-NEXT:    ; implicit-def: $vgpr55
; GFX11-NEXT:    ; implicit-def: $vgpr54
; GFX11-NEXT:    ; implicit-def: $vgpr53
; GFX11-NEXT:    ; implicit-def: $vgpr52
; GFX11-NEXT:    ; implicit-def: $vgpr51
; GFX11-NEXT:    ; implicit-def: $vgpr50
; GFX11-NEXT:    ; implicit-def: $vgpr49
; GFX11-NEXT:    ; implicit-def: $vgpr48
; GFX11-NEXT:    ; implicit-def: $vgpr39
; GFX11-NEXT:    ; implicit-def: $vgpr38
; GFX11-NEXT:    s_branch .LBB29_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <28 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <28 x float> %a1 to <56 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <28 x float> %a to <56 x i16>
  br label %end

end:
  %phi = phi <56 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <56 x i16> %phi
}

define <28 x float> @bitcast_v56i16_to_v28f32(<56 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v56i16_to_v28f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v54, v2
; SI-NEXT:    v_mov_b32_e32 v55, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:96
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:92
; SI-NEXT:    v_mov_b32_e32 v53, v4
; SI-NEXT:    v_lshlrev_b32_e32 v58, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v52, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v57, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v51, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v56, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v50, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v46, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v45, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v39, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v37, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v36, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v34, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v43, 16, v25
; SI-NEXT:    v_lshlrev_b32_e32 v42, 16, v27
; SI-NEXT:    v_lshlrev_b32_e32 v40, 16, v29
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v60, 16, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:88
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:84
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v61, 16, v2
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:80
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:76
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v62, 16, v4
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:72
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:68
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v63, 16, v6
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:100
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:24
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:16
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:64
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:60
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_lshlrev_b32_e32 v47, 16, v8
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v10
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_lshlrev_b32_e32 v44, 16, v12
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v38, 16, v14
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_lshlrev_b32_e32 v48, 16, v16
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v49, 16, v18
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v41, 16, v20
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:56
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:40
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:48
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:52
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_lshlrev_b32_e32 v32, 16, v22
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v35, 16, v24
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v33, 16, v26
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:44
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:36
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:28
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:20
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:12
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB30_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v55
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v54
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v53
; SI-NEXT:    v_and_b32_e32 v16, 0xffff, v59
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    v_or_b32_e32 v0, v0, v58
; SI-NEXT:    v_or_b32_e32 v1, v1, v52
; SI-NEXT:    v_or_b32_e32 v2, v2, v57
; SI-NEXT:    v_or_b32_e32 v16, v16, v49
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; kill: killed $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; SI-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; SI-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    s_waitcnt vmcnt(13)
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    s_waitcnt vmcnt(12)
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; SI-NEXT:    s_waitcnt vmcnt(11)
; SI-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; SI-NEXT:    s_waitcnt vmcnt(9)
; SI-NEXT:    v_and_b32_e32 v23, 0xffff, v23
; SI-NEXT:    s_waitcnt vmcnt(8)
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_and_b32_e32 v24, 0xffff, v24
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_and_b32_e32 v25, 0xffff, v25
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v26, 0xffff, v26
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v27, 0xffff, v27
; SI-NEXT:    v_or_b32_e32 v3, v3, v51
; SI-NEXT:    v_or_b32_e32 v4, v4, v56
; SI-NEXT:    v_or_b32_e32 v5, v5, v50
; SI-NEXT:    v_or_b32_e32 v6, v6, v46
; SI-NEXT:    v_or_b32_e32 v7, v7, v45
; SI-NEXT:    v_or_b32_e32 v8, v8, v39
; SI-NEXT:    v_or_b32_e32 v9, v9, v37
; SI-NEXT:    v_or_b32_e32 v10, v10, v36
; SI-NEXT:    v_or_b32_e32 v11, v11, v34
; SI-NEXT:    v_or_b32_e32 v12, v12, v43
; SI-NEXT:    v_or_b32_e32 v13, v13, v42
; SI-NEXT:    v_or_b32_e32 v14, v14, v40
; SI-NEXT:    v_or_b32_e32 v15, v15, v47
; SI-NEXT:    v_or_b32_e32 v17, v17, v48
; SI-NEXT:    v_or_b32_e32 v18, v18, v38
; SI-NEXT:    v_or_b32_e32 v19, v19, v44
; SI-NEXT:    v_or_b32_e32 v20, v20, v35
; SI-NEXT:    v_or_b32_e32 v21, v21, v33
; SI-NEXT:    v_or_b32_e32 v22, v22, v32
; SI-NEXT:    v_or_b32_e32 v23, v23, v41
; SI-NEXT:    v_or_b32_e32 v24, v24, v63
; SI-NEXT:    v_or_b32_e32 v25, v25, v62
; SI-NEXT:    v_or_b32_e32 v26, v26, v61
; SI-NEXT:    v_or_b32_e32 v27, v27, v60
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr63
; SI-NEXT:    ; implicit-def: $vgpr62
; SI-NEXT:    ; implicit-def: $vgpr61
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:  .LBB30_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB30_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v55
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v54
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v53
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v59
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; SI-NEXT:    v_or_b32_e32 v0, v58, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v52, v1
; SI-NEXT:    v_or_b32_e32 v2, v57, v2
; SI-NEXT:    v_or_b32_e32 v16, v49, v16
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v16, vcc, s6, v16
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    s_waitcnt vmcnt(13)
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    s_waitcnt vmcnt(8)
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v21, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v22, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v23, vcc, 3, v23
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_add_i32_e32 v25, vcc, 3, v25
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_add_i32_e32 v26, vcc, 3, v26
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v27, vcc, 3, v27
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; SI-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; SI-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; SI-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; SI-NEXT:    v_and_b32_e32 v23, 0xffff, v23
; SI-NEXT:    v_and_b32_e32 v24, 0xffff, v24
; SI-NEXT:    v_and_b32_e32 v25, 0xffff, v25
; SI-NEXT:    v_and_b32_e32 v26, 0xffff, v26
; SI-NEXT:    v_and_b32_e32 v27, 0xffff, v27
; SI-NEXT:    v_or_b32_e32 v3, v51, v3
; SI-NEXT:    v_or_b32_e32 v4, v56, v4
; SI-NEXT:    v_or_b32_e32 v5, v50, v5
; SI-NEXT:    v_or_b32_e32 v6, v46, v6
; SI-NEXT:    v_or_b32_e32 v7, v45, v7
; SI-NEXT:    v_or_b32_e32 v8, v39, v8
; SI-NEXT:    v_or_b32_e32 v9, v37, v9
; SI-NEXT:    v_or_b32_e32 v10, v36, v10
; SI-NEXT:    v_or_b32_e32 v11, v34, v11
; SI-NEXT:    v_or_b32_e32 v12, v43, v12
; SI-NEXT:    v_or_b32_e32 v13, v42, v13
; SI-NEXT:    v_or_b32_e32 v14, v40, v14
; SI-NEXT:    v_or_b32_e32 v15, v47, v15
; SI-NEXT:    v_or_b32_e32 v17, v48, v17
; SI-NEXT:    v_or_b32_e32 v18, v38, v18
; SI-NEXT:    v_or_b32_e32 v19, v44, v19
; SI-NEXT:    v_or_b32_e32 v20, v35, v20
; SI-NEXT:    v_or_b32_e32 v21, v33, v21
; SI-NEXT:    v_or_b32_e32 v22, v32, v22
; SI-NEXT:    v_or_b32_e32 v23, v41, v23
; SI-NEXT:    v_or_b32_e32 v24, v63, v24
; SI-NEXT:    v_or_b32_e32 v25, v62, v25
; SI-NEXT:    v_or_b32_e32 v26, v61, v26
; SI-NEXT:    v_or_b32_e32 v27, v60, v27
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, s6, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, s6, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, s6, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, s6, v8
; SI-NEXT:    v_add_i32_e32 v9, vcc, s6, v9
; SI-NEXT:    v_add_i32_e32 v10, vcc, s6, v10
; SI-NEXT:    v_add_i32_e32 v11, vcc, s6, v11
; SI-NEXT:    v_add_i32_e32 v12, vcc, s6, v12
; SI-NEXT:    v_add_i32_e32 v13, vcc, s6, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, s6, v14
; SI-NEXT:    v_add_i32_e32 v15, vcc, s6, v15
; SI-NEXT:    v_add_i32_e32 v17, vcc, s6, v17
; SI-NEXT:    v_add_i32_e32 v18, vcc, s6, v18
; SI-NEXT:    v_add_i32_e32 v19, vcc, s6, v19
; SI-NEXT:    v_add_i32_e32 v20, vcc, s6, v20
; SI-NEXT:    v_add_i32_e32 v21, vcc, s6, v21
; SI-NEXT:    v_add_i32_e32 v22, vcc, s6, v22
; SI-NEXT:    v_add_i32_e32 v23, vcc, s6, v23
; SI-NEXT:    v_add_i32_e32 v24, vcc, s6, v24
; SI-NEXT:    v_add_i32_e32 v25, vcc, s6, v25
; SI-NEXT:    v_add_i32_e32 v26, vcc, s6, v26
; SI-NEXT:    v_add_i32_e32 v27, vcc, 0x30000, v27
; SI-NEXT:  .LBB30_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v56i16_to_v28f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    v_mov_b32_e32 v32, v27
; VI-NEXT:    v_mov_b32_e32 v33, v26
; VI-NEXT:    v_mov_b32_e32 v34, v25
; VI-NEXT:    v_mov_b32_e32 v35, v24
; VI-NEXT:    v_mov_b32_e32 v36, v23
; VI-NEXT:    v_mov_b32_e32 v37, v22
; VI-NEXT:    v_mov_b32_e32 v38, v21
; VI-NEXT:    v_mov_b32_e32 v39, v20
; VI-NEXT:    v_mov_b32_e32 v48, v19
; VI-NEXT:    v_mov_b32_e32 v49, v18
; VI-NEXT:    v_mov_b32_e32 v50, v17
; VI-NEXT:    v_mov_b32_e32 v51, v16
; VI-NEXT:    v_mov_b32_e32 v52, v15
; VI-NEXT:    v_mov_b32_e32 v53, v14
; VI-NEXT:    v_mov_b32_e32 v54, v13
; VI-NEXT:    v_mov_b32_e32 v55, v12
; VI-NEXT:    v_mov_b32_e32 v40, v11
; VI-NEXT:    v_mov_b32_e32 v41, v10
; VI-NEXT:    v_mov_b32_e32 v42, v9
; VI-NEXT:    v_mov_b32_e32 v43, v8
; VI-NEXT:    v_mov_b32_e32 v44, v7
; VI-NEXT:    v_mov_b32_e32 v45, v6
; VI-NEXT:    v_mov_b32_e32 v46, v5
; VI-NEXT:    v_mov_b32_e32 v47, v4
; VI-NEXT:    v_mov_b32_e32 v56, v3
; VI-NEXT:    v_mov_b32_e32 v57, v2
; VI-NEXT:    v_mov_b32_e32 v58, v1
; VI-NEXT:    v_mov_b32_e32 v59, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB30_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_mov_b32_e32 v27, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v27, v59 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v27, v58 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v27, v57 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v3, v27, v56 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v4, v27, v47 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v5, v27, v46 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v6, v27, v45 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v7, v27, v44 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v8, v27, v43 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v9, v27, v42 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v10, v27, v41 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v11, v27, v40 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v12, v27, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v13, v27, v54 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v14, v27, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v15, v27, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v16, v27, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v17, v27, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v18, v27, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v19, v27, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v20, v27, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v21, v27, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v22, v27, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v23, v27, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v24, v27, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v25, v27, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v26, v27, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v27, v27, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v59, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v58, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v57, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v56, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v47, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v46, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v45, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v44, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v43, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v42, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v41, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v40, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v55, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v54, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v53, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v52, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v51, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v50, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v49, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v48, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v20, v39, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v21, v38, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v22, v37, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v23, v36, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v24, v35, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v25, v34, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v26, v33, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v27, v32, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr59
; VI-NEXT:    ; implicit-def: $vgpr58
; VI-NEXT:    ; implicit-def: $vgpr57
; VI-NEXT:    ; implicit-def: $vgpr56
; VI-NEXT:    ; implicit-def: $vgpr47
; VI-NEXT:    ; implicit-def: $vgpr46
; VI-NEXT:    ; implicit-def: $vgpr45
; VI-NEXT:    ; implicit-def: $vgpr44
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:  .LBB30_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB30_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v27, 3
; VI-NEXT:    v_add_u16_e32 v0, 3, v59
; VI-NEXT:    v_add_u16_sdwa v1, v59, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v2, 3, v58
; VI-NEXT:    v_add_u16_sdwa v3, v58, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_or_b32_e32 v1, v2, v3
; VI-NEXT:    v_add_u16_e32 v2, 3, v57
; VI-NEXT:    v_add_u16_sdwa v3, v57, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    v_add_u16_e32 v3, 3, v56
; VI-NEXT:    v_add_u16_sdwa v4, v56, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v47
; VI-NEXT:    v_add_u16_sdwa v5, v47, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v4, v5
; VI-NEXT:    v_add_u16_e32 v5, 3, v46
; VI-NEXT:    v_add_u16_sdwa v6, v46, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v5, v6
; VI-NEXT:    v_add_u16_e32 v6, 3, v45
; VI-NEXT:    v_add_u16_sdwa v7, v45, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v6, v6, v7
; VI-NEXT:    v_add_u16_e32 v7, 3, v44
; VI-NEXT:    v_add_u16_sdwa v8, v44, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v7, v7, v8
; VI-NEXT:    v_add_u16_e32 v8, 3, v43
; VI-NEXT:    v_add_u16_sdwa v9, v43, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v8, v8, v9
; VI-NEXT:    v_add_u16_e32 v9, 3, v42
; VI-NEXT:    v_add_u16_sdwa v10, v42, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v9, v9, v10
; VI-NEXT:    v_add_u16_e32 v10, 3, v41
; VI-NEXT:    v_add_u16_sdwa v11, v41, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v10, v10, v11
; VI-NEXT:    v_add_u16_e32 v11, 3, v40
; VI-NEXT:    v_add_u16_sdwa v12, v40, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v11, v11, v12
; VI-NEXT:    v_add_u16_e32 v12, 3, v55
; VI-NEXT:    v_add_u16_sdwa v13, v55, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v12, v12, v13
; VI-NEXT:    v_add_u16_e32 v13, 3, v54
; VI-NEXT:    v_add_u16_sdwa v14, v54, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v13, v13, v14
; VI-NEXT:    v_add_u16_e32 v14, 3, v53
; VI-NEXT:    v_add_u16_sdwa v15, v53, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v14, v14, v15
; VI-NEXT:    v_add_u16_e32 v15, 3, v52
; VI-NEXT:    v_add_u16_sdwa v16, v52, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v15, v15, v16
; VI-NEXT:    v_add_u16_e32 v16, 3, v51
; VI-NEXT:    v_add_u16_sdwa v17, v51, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v16, v16, v17
; VI-NEXT:    v_add_u16_e32 v17, 3, v50
; VI-NEXT:    v_add_u16_sdwa v18, v50, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v17, v17, v18
; VI-NEXT:    v_add_u16_e32 v18, 3, v49
; VI-NEXT:    v_add_u16_sdwa v19, v49, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v18, v18, v19
; VI-NEXT:    v_add_u16_e32 v19, 3, v48
; VI-NEXT:    v_add_u16_sdwa v20, v48, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v19, v19, v20
; VI-NEXT:    v_add_u16_e32 v20, 3, v39
; VI-NEXT:    v_add_u16_sdwa v21, v39, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v20, v20, v21
; VI-NEXT:    v_add_u16_e32 v21, 3, v38
; VI-NEXT:    v_add_u16_sdwa v22, v38, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v21, v21, v22
; VI-NEXT:    v_add_u16_e32 v22, 3, v37
; VI-NEXT:    v_add_u16_sdwa v23, v37, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v22, v22, v23
; VI-NEXT:    v_add_u16_e32 v23, 3, v36
; VI-NEXT:    v_add_u16_sdwa v24, v36, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v23, v23, v24
; VI-NEXT:    v_add_u16_e32 v24, 3, v35
; VI-NEXT:    v_add_u16_sdwa v25, v35, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v24, v24, v25
; VI-NEXT:    v_add_u16_e32 v25, 3, v34
; VI-NEXT:    v_add_u16_sdwa v26, v34, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v25, v25, v26
; VI-NEXT:    v_add_u16_e32 v26, 3, v33
; VI-NEXT:    v_add_u16_sdwa v28, v33, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v26, v26, v28
; VI-NEXT:    v_add_u16_e32 v28, 3, v32
; VI-NEXT:    v_add_u16_sdwa v27, v32, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v27, v28, v27
; VI-NEXT:  .LBB30_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v56i16_to_v28f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    v_mov_b32_e32 v59, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v27
; GFX9-NEXT:    buffer_store_dword v27, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v26
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v25, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v25
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v24
; GFX9-NEXT:    v_mov_b32_e32 v37, v22
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v23, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v23
; GFX9-NEXT:    v_mov_b32_e32 v38, v21
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v37
; GFX9-NEXT:    v_mov_b32_e32 v39, v20
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v38
; GFX9-NEXT:    v_mov_b32_e32 v48, v19
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v39
; GFX9-NEXT:    v_mov_b32_e32 v49, v18
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v48
; GFX9-NEXT:    v_mov_b32_e32 v50, v17
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v49
; GFX9-NEXT:    v_mov_b32_e32 v51, v16
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v50
; GFX9-NEXT:    v_mov_b32_e32 v52, v15
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v51
; GFX9-NEXT:    v_mov_b32_e32 v53, v14
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v52
; GFX9-NEXT:    v_mov_b32_e32 v54, v13
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v53
; GFX9-NEXT:    v_mov_b32_e32 v55, v12
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v54
; GFX9-NEXT:    v_mov_b32_e32 v40, v11
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v55
; GFX9-NEXT:    v_mov_b32_e32 v41, v10
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v40
; GFX9-NEXT:    v_mov_b32_e32 v42, v9
; GFX9-NEXT:    v_mov_b32_e32 v43, v8
; GFX9-NEXT:    v_mov_b32_e32 v44, v7
; GFX9-NEXT:    v_mov_b32_e32 v45, v6
; GFX9-NEXT:    v_mov_b32_e32 v46, v5
; GFX9-NEXT:    v_mov_b32_e32 v47, v4
; GFX9-NEXT:    v_mov_b32_e32 v56, v3
; GFX9-NEXT:    v_mov_b32_e32 v57, v2
; GFX9-NEXT:    v_mov_b32_e32 v58, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v41
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v42
; GFX9-NEXT:    v_lshrrev_b32_e32 v63, 16, v43
; GFX9-NEXT:    v_lshrrev_b32_e32 v60, 16, v44
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v45
; GFX9-NEXT:    v_lshrrev_b32_e32 v61, 16, v46
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v47
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v56
; GFX9-NEXT:    v_lshrrev_b32_e32 v62, 16, v57
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v58
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v59
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB30_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 16, v42
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v41
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 16, v40
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 16, v55
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 16, v54
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v53
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 16, v52
; GFX9-NEXT:    v_lshrrev_b32_e32 v16, 16, v51
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 16, v50
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v49
; GFX9-NEXT:    v_lshrrev_b32_e32 v19, 16, v48
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v39
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v38
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v37
; GFX9-NEXT:    v_perm_b32 v0, v36, v59, s6
; GFX9-NEXT:    v_perm_b32 v1, v35, v58, s6
; GFX9-NEXT:    v_perm_b32 v2, v62, v57, s6
; GFX9-NEXT:    v_perm_b32 v3, v34, v56, s6
; GFX9-NEXT:    v_perm_b32 v4, v33, v47, s6
; GFX9-NEXT:    v_perm_b32 v5, v61, v46, s6
; GFX9-NEXT:    v_perm_b32 v6, v32, v45, s6
; GFX9-NEXT:    v_perm_b32 v7, v60, v44, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v43, s6
; GFX9-NEXT:    v_perm_b32 v9, v9, v42, s6
; GFX9-NEXT:    v_perm_b32 v10, v10, v41, s6
; GFX9-NEXT:    v_perm_b32 v11, v11, v40, s6
; GFX9-NEXT:    v_perm_b32 v12, v12, v55, s6
; GFX9-NEXT:    v_perm_b32 v13, v13, v54, s6
; GFX9-NEXT:    v_perm_b32 v14, v14, v53, s6
; GFX9-NEXT:    v_perm_b32 v15, v15, v52, s6
; GFX9-NEXT:    v_perm_b32 v16, v16, v51, s6
; GFX9-NEXT:    v_perm_b32 v17, v17, v50, s6
; GFX9-NEXT:    v_perm_b32 v18, v18, v49, s6
; GFX9-NEXT:    v_perm_b32 v19, v19, v48, s6
; GFX9-NEXT:    v_perm_b32 v20, v20, v39, s6
; GFX9-NEXT:    v_perm_b32 v21, v21, v38, s6
; GFX9-NEXT:    v_perm_b32 v22, v22, v37, s6
; GFX9-NEXT:    ; implicit-def: $vgpr59
; GFX9-NEXT:    ; implicit-def: $vgpr58
; GFX9-NEXT:    ; implicit-def: $vgpr57
; GFX9-NEXT:    ; implicit-def: $vgpr56
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr60
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr61
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr62
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v23, v24, v23, s6
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v24, v25, v24, s6
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v25, v26, v25, s6
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v26, v27, v26, s6
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v27, v28, v27, s6
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; kill: killed $vgpr28
; GFX9-NEXT:  .LBB30_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB30_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v36, v59, s6
; GFX9-NEXT:    v_perm_b32 v1, v35, v58, s6
; GFX9-NEXT:    v_perm_b32 v2, v62, v57, s6
; GFX9-NEXT:    v_perm_b32 v3, v34, v56, s6
; GFX9-NEXT:    v_perm_b32 v4, v33, v47, s6
; GFX9-NEXT:    v_perm_b32 v5, v61, v46, s6
; GFX9-NEXT:    v_perm_b32 v6, v32, v45, s6
; GFX9-NEXT:    v_perm_b32 v7, v60, v44, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v43, s6
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(15)
; GFX9-NEXT:    v_perm_b32 v9, v9, v42, s6
; GFX9-NEXT:    s_waitcnt vmcnt(14)
; GFX9-NEXT:    v_perm_b32 v10, v10, v41, s6
; GFX9-NEXT:    s_waitcnt vmcnt(13)
; GFX9-NEXT:    v_perm_b32 v11, v11, v40, s6
; GFX9-NEXT:    s_waitcnt vmcnt(12)
; GFX9-NEXT:    v_perm_b32 v12, v12, v55, s6
; GFX9-NEXT:    s_waitcnt vmcnt(11)
; GFX9-NEXT:    v_perm_b32 v13, v13, v54, s6
; GFX9-NEXT:    s_waitcnt vmcnt(10)
; GFX9-NEXT:    v_perm_b32 v14, v14, v53, s6
; GFX9-NEXT:    s_waitcnt vmcnt(9)
; GFX9-NEXT:    v_perm_b32 v15, v15, v52, s6
; GFX9-NEXT:    s_waitcnt vmcnt(8)
; GFX9-NEXT:    v_perm_b32 v16, v16, v51, s6
; GFX9-NEXT:    s_waitcnt vmcnt(7)
; GFX9-NEXT:    v_perm_b32 v17, v17, v50, s6
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_perm_b32 v18, v18, v49, s6
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_perm_b32 v19, v19, v48, s6
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_perm_b32 v20, v20, v39, s6
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_perm_b32 v21, v21, v38, s6
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_perm_b32 v22, v22, v37, s6
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v23, v24, v23, s6
; GFX9-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GFX9-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v20, v20, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v21, v21, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v22, v22, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v23, v23, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v24, v25, v24, s6
; GFX9-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-NEXT:    v_pk_add_u16 v24, v24, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v25, v26, v25, s6
; GFX9-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-NEXT:    v_pk_add_u16 v25, v25, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v26, v27, v26, s6
; GFX9-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-NEXT:    v_pk_add_u16 v26, v26, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v27, v28, v27, s6
; GFX9-NEXT:    v_pk_add_u16 v27, v27, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB30_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v56i16_to_v28f32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB30_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v20, v20, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v21, v21, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v22, v22, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v23, v23, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v24, v24, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v25, v25, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v26, v26, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v27, v27, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:  .LBB30_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v56i16_to_v28f32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v50, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v53, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v54, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v65, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v66, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 16, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v80, 16, v3
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v28
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v69, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v70, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v71, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v80, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v68, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v67, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v66, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v65, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v64, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v55, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v54, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v53, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v52, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v51, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v50, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v49, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v48, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v39, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v38, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v37, v19, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v20, v36, v20, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v21, v35, v21, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v22, v34, v22, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v23, v33, v23, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v24, v32, v24, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v25, v31, v25, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v26, v30, v26, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v27, v29, v27, 0x5040100
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB30_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v20, v20, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v21, v21, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v22, v22, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v23, v23, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v24, v24, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v25, v25, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v26, v26, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v27, v27, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:  .LBB30_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <56 x i16> %a, splat (i16 3)
  %a2 = bitcast <56 x i16> %a1 to <28 x float>
  br label %end

cmp.false:
  %a3 = bitcast <56 x i16> %a to <28 x float>
  br label %end

end:
  %phi = phi <28 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x float> %phi
}

define inreg <28 x float> @bitcast_v56i16_to_v28f32_scalar(<56 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v56i16_to_v28f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v49, v12
; SI-NEXT:    v_mov_b32_e32 v50, v10
; SI-NEXT:    v_mov_b32_e32 v51, v8
; SI-NEXT:    v_mov_b32_e32 v52, v6
; SI-NEXT:    v_mov_b32_e32 v53, v4
; SI-NEXT:    v_mov_b32_e32 v54, v2
; SI-NEXT:    v_mov_b32_e32 v55, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:44
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:4
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:16
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:12
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:24
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:20
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v48, off, s[0:3], s32 offset:28
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:40
; SI-NEXT:    buffer_load_dword v39, off, s[0:3], s32 offset:36
; SI-NEXT:    v_mov_b32_e32 v32, v26
; SI-NEXT:    v_mov_b32_e32 v33, v24
; SI-NEXT:    v_mov_b32_e32 v34, v22
; SI-NEXT:    v_mov_b32_e32 v35, v20
; SI-NEXT:    v_mov_b32_e32 v36, v18
; SI-NEXT:    v_mov_b32_e32 v37, v16
; SI-NEXT:    v_mov_b32_e32 v38, v14
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v11
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v62, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v44, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v43, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v60, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v59, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v58, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v57, 16, v25
; SI-NEXT:    v_lshlrev_b32_e32 v56, 16, v27
; SI-NEXT:    v_lshlrev_b32_e32 v47, 16, v29
; SI-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v46, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v45, 16, v4
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    s_waitcnt vmcnt(13)
; SI-NEXT:    v_lshlrev_b32_e32 v31, 16, v6
; SI-NEXT:    s_waitcnt vmcnt(11)
; SI-NEXT:    v_lshlrev_b32_e32 v61, 16, v8
; SI-NEXT:    s_waitcnt vmcnt(9)
; SI-NEXT:    v_lshlrev_b32_e32 v29, 16, v10
; SI-NEXT:    s_waitcnt vmcnt(7) expcnt(6)
; SI-NEXT:    v_lshlrev_b32_e32 v63, 16, v12
; SI-NEXT:    s_cbranch_scc0 .LBB31_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v55
; SI-NEXT:    v_or_b32_e32 v7, v0, v20
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v53
; SI-NEXT:    v_or_b32_e32 v9, v0, v16
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v52
; SI-NEXT:    v_or_b32_e32 v10, v0, v14
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v51
; SI-NEXT:    v_or_b32_e32 v11, v0, v5
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v50
; SI-NEXT:    v_or_b32_e32 v12, v0, v3
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v49
; SI-NEXT:    v_or_b32_e32 v13, v0, v62
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v38
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_or_b32_e32 v14, v0, v44
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v37
; SI-NEXT:    v_or_b32_e32 v15, v0, v43
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v36
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_or_b32_e32 v16, v0, v60
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v35
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v54
; SI-NEXT:    v_or_b32_e32 v17, v0, v59
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v34
; SI-NEXT:    v_or_b32_e32 v8, v1, v18
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_or_b32_e32 v18, v0, v58
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v33
; SI-NEXT:    v_or_b32_e32 v19, v0, v57
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v32
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_or_b32_e32 v20, v0, v56
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v28
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    v_or_b32_e32 v21, v0, v47
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v30
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    v_or_b32_e32 v22, v0, v46
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v42
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    v_or_b32_e32 v23, v0, v45
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v41
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    v_or_b32_e32 v24, v0, v31
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v40
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    v_or_b32_e32 v25, v0, v61
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v48
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_or_b32_e32 v26, v0, v29
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v39
; SI-NEXT:    s_or_b32 s10, s10, s11
; SI-NEXT:    v_or_b32_e32 v27, v0, v63
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    s_cbranch_execnz .LBB31_3
; SI-NEXT:  .LBB31_2: ; %cmp.true
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v55
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    s_or_b32 s10, s11, s10
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:    s_add_i32 s10, s10, 0x30000
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v54
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v8, vcc, 0x30000, v1
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v53
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v9, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v52
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v10, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v51
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v11, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v50
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v12, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v49
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v62, v0
; SI-NEXT:    v_add_i32_e32 v13, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v38
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v44, v0
; SI-NEXT:    v_add_i32_e32 v14, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v37
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v43, v0
; SI-NEXT:    v_add_i32_e32 v15, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v36
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v60, v0
; SI-NEXT:    v_add_i32_e32 v16, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v35
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v59, v0
; SI-NEXT:    v_add_i32_e32 v17, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v34
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v58, v0
; SI-NEXT:    v_add_i32_e32 v18, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v33
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v57, v0
; SI-NEXT:    v_add_i32_e32 v19, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v32
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v56, v0
; SI-NEXT:    v_add_i32_e32 v20, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v28
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v47, v0
; SI-NEXT:    v_add_i32_e32 v21, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v30
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v46, v0
; SI-NEXT:    v_add_i32_e32 v22, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v42
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v45, v0
; SI-NEXT:    v_add_i32_e32 v23, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v41
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v31, v0
; SI-NEXT:    v_add_i32_e32 v24, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v40
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v61, v0
; SI-NEXT:    v_add_i32_e32 v25, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v48
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v29, v0
; SI-NEXT:    v_add_i32_e32 v26, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v39
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v63, v0
; SI-NEXT:    v_add_i32_e32 v27, vcc, 0x30000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:  .LBB31_3: ; %end
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB31_4:
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v59, v56
; SI-NEXT:    v_mov_b32_e32 v56, v45
; SI-NEXT:    v_mov_b32_e32 v45, v29
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v44, v41
; SI-NEXT:    s_waitcnt vmcnt(8)
; SI-NEXT:    v_mov_b32_e32 v41, v39
; SI-NEXT:    v_mov_b32_e32 v39, v36
; SI-NEXT:    v_mov_b32_e32 v36, v33
; SI-NEXT:    v_mov_b32_e32 v33, v30
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v43, v55
; SI-NEXT:    v_mov_b32_e32 v55, v54
; SI-NEXT:    v_mov_b32_e32 v54, v53
; SI-NEXT:    v_mov_b32_e32 v53, v52
; SI-NEXT:    v_mov_b32_e32 v52, v51
; SI-NEXT:    v_mov_b32_e32 v51, v50
; SI-NEXT:    v_mov_b32_e32 v50, v49
; SI-NEXT:    v_mov_b32_e32 v49, v42
; SI-NEXT:    v_mov_b32_e32 v42, v48
; SI-NEXT:    v_mov_b32_e32 v48, v37
; SI-NEXT:    v_mov_b32_e32 v37, v34
; SI-NEXT:    v_mov_b32_e32 v34, v28
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v62, v60
; SI-NEXT:    v_mov_b32_e32 v60, v57
; SI-NEXT:    v_mov_b32_e32 v57, v46
; SI-NEXT:    v_mov_b32_e32 v46, v61
; SI-NEXT:    v_mov_b32_e32 v61, v58
; SI-NEXT:    v_mov_b32_e32 v58, v47
; SI-NEXT:    v_mov_b32_e32 v47, v31
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    v_mov_b32_e32 v31, v47
; SI-NEXT:    v_mov_b32_e32 v47, v58
; SI-NEXT:    v_mov_b32_e32 v58, v61
; SI-NEXT:    v_mov_b32_e32 v61, v46
; SI-NEXT:    v_mov_b32_e32 v46, v57
; SI-NEXT:    v_mov_b32_e32 v57, v60
; SI-NEXT:    v_mov_b32_e32 v60, v62
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v28, v34
; SI-NEXT:    v_mov_b32_e32 v34, v37
; SI-NEXT:    v_mov_b32_e32 v37, v48
; SI-NEXT:    v_mov_b32_e32 v48, v42
; SI-NEXT:    v_mov_b32_e32 v42, v49
; SI-NEXT:    v_mov_b32_e32 v49, v50
; SI-NEXT:    v_mov_b32_e32 v50, v51
; SI-NEXT:    v_mov_b32_e32 v51, v52
; SI-NEXT:    v_mov_b32_e32 v52, v53
; SI-NEXT:    v_mov_b32_e32 v53, v54
; SI-NEXT:    v_mov_b32_e32 v54, v55
; SI-NEXT:    v_mov_b32_e32 v55, v43
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v30, v33
; SI-NEXT:    v_mov_b32_e32 v33, v36
; SI-NEXT:    v_mov_b32_e32 v36, v39
; SI-NEXT:    v_mov_b32_e32 v39, v41
; SI-NEXT:    v_mov_b32_e32 v41, v44
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v29, v45
; SI-NEXT:    v_mov_b32_e32 v45, v56
; SI-NEXT:    v_mov_b32_e32 v56, v59
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    s_branch .LBB31_2
;
; VI-LABEL: bitcast_v56i16_to_v28f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s6, s29, 16
; VI-NEXT:    s_lshr_b32 s7, s28, 16
; VI-NEXT:    s_lshr_b32 s8, s27, 16
; VI-NEXT:    s_lshr_b32 s9, s26, 16
; VI-NEXT:    s_lshr_b32 s10, s25, 16
; VI-NEXT:    s_lshr_b32 s11, s24, 16
; VI-NEXT:    s_lshr_b32 s12, s23, 16
; VI-NEXT:    s_lshr_b32 s13, s22, 16
; VI-NEXT:    s_lshr_b32 s14, s21, 16
; VI-NEXT:    s_lshr_b32 s15, s20, 16
; VI-NEXT:    s_lshr_b32 s40, s19, 16
; VI-NEXT:    s_lshr_b32 s41, s18, 16
; VI-NEXT:    s_lshr_b32 s42, s17, 16
; VI-NEXT:    s_lshr_b32 s43, s16, 16
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v32, v13
; VI-NEXT:    v_mov_b32_e32 v33, v12
; VI-NEXT:    v_mov_b32_e32 v34, v11
; VI-NEXT:    v_mov_b32_e32 v35, v10
; VI-NEXT:    v_mov_b32_e32 v36, v9
; VI-NEXT:    v_mov_b32_e32 v37, v8
; VI-NEXT:    v_mov_b32_e32 v38, v7
; VI-NEXT:    v_mov_b32_e32 v39, v6
; VI-NEXT:    v_mov_b32_e32 v48, v5
; VI-NEXT:    v_mov_b32_e32 v49, v4
; VI-NEXT:    v_mov_b32_e32 v50, v3
; VI-NEXT:    v_mov_b32_e32 v51, v2
; VI-NEXT:    v_mov_b32_e32 v52, v1
; VI-NEXT:    v_mov_b32_e32 v53, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    s_cbranch_scc0 .LBB31_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, 0xffff, s16
; VI-NEXT:    s_lshl_b32 s5, s43, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, 0xffff, s17
; VI-NEXT:    s_lshl_b32 s44, s42, 16
; VI-NEXT:    v_mov_b32_e32 v0, 16
; VI-NEXT:    s_or_b32 s5, s5, s44
; VI-NEXT:    s_and_b32 s44, 0xffff, s18
; VI-NEXT:    s_lshl_b32 s45, s41, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s44, s44, s45
; VI-NEXT:    s_and_b32 s45, 0xffff, s19
; VI-NEXT:    s_lshl_b32 s46, s40, 16
; VI-NEXT:    v_or_b32_sdwa v14, v53, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s45, s45, s46
; VI-NEXT:    s_and_b32 s46, 0xffff, s20
; VI-NEXT:    s_lshl_b32 s47, s15, 16
; VI-NEXT:    v_or_b32_sdwa v16, v51, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s46, s46, s47
; VI-NEXT:    s_and_b32 s47, 0xffff, s21
; VI-NEXT:    s_lshl_b32 s56, s14, 16
; VI-NEXT:    v_or_b32_sdwa v17, v50, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s47, s47, s56
; VI-NEXT:    s_and_b32 s56, 0xffff, s22
; VI-NEXT:    s_lshl_b32 s57, s13, 16
; VI-NEXT:    v_or_b32_sdwa v18, v49, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s56, s56, s57
; VI-NEXT:    s_and_b32 s57, 0xffff, s23
; VI-NEXT:    s_lshl_b32 s58, s12, 16
; VI-NEXT:    v_or_b32_sdwa v19, v48, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s57, s57, s58
; VI-NEXT:    s_and_b32 s58, 0xffff, s24
; VI-NEXT:    s_lshl_b32 s59, s11, 16
; VI-NEXT:    v_or_b32_sdwa v20, v39, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s58, s58, s59
; VI-NEXT:    s_and_b32 s59, 0xffff, s25
; VI-NEXT:    s_lshl_b32 s60, s10, 16
; VI-NEXT:    v_or_b32_sdwa v21, v38, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s59, s59, s60
; VI-NEXT:    s_and_b32 s60, 0xffff, s26
; VI-NEXT:    s_lshl_b32 s61, s9, 16
; VI-NEXT:    v_or_b32_sdwa v22, v37, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s60, s60, s61
; VI-NEXT:    s_and_b32 s61, 0xffff, s27
; VI-NEXT:    s_lshl_b32 s62, s8, 16
; VI-NEXT:    v_or_b32_sdwa v23, v36, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s61, s61, s62
; VI-NEXT:    s_and_b32 s62, 0xffff, s28
; VI-NEXT:    s_lshl_b32 s63, s7, 16
; VI-NEXT:    v_or_b32_sdwa v24, v35, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s62, s62, s63
; VI-NEXT:    s_and_b32 s63, 0xffff, s29
; VI-NEXT:    s_lshl_b32 s72, s6, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v0, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v25, v34, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v0, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s63, s63, s72
; VI-NEXT:    v_or_b32_sdwa v15, v52, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v26, v33, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v27, v32, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s44
; VI-NEXT:    v_mov_b32_e32 v3, s45
; VI-NEXT:    v_mov_b32_e32 v4, s46
; VI-NEXT:    v_mov_b32_e32 v5, s47
; VI-NEXT:    v_mov_b32_e32 v6, s56
; VI-NEXT:    v_mov_b32_e32 v7, s57
; VI-NEXT:    v_mov_b32_e32 v8, s58
; VI-NEXT:    v_mov_b32_e32 v9, s59
; VI-NEXT:    v_mov_b32_e32 v10, s60
; VI-NEXT:    v_mov_b32_e32 v11, s61
; VI-NEXT:    v_mov_b32_e32 v12, s62
; VI-NEXT:    v_mov_b32_e32 v13, s63
; VI-NEXT:    s_cbranch_execnz .LBB31_3
; VI-NEXT:  .LBB31_2: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v1, 16
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v53
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v52
; VI-NEXT:    v_lshlrev_b32_sdwa v3, v1, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v14, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v15, vcc, 0x30000, v2
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v51
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v16, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v50
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v17, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v49
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v18, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v48
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_and_b32 s4, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s43, 16
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    v_add_u32_e32 v19, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v39
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s17, 0xffff
; VI-NEXT:    s_lshl_b32 s16, s42, 16
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s5, s16, s5
; VI-NEXT:    s_and_b32 s16, s18, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s41, 16
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    v_add_u32_e32 v20, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v38
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s16, s17, s16
; VI-NEXT:    s_and_b32 s17, s19, 0xffff
; VI-NEXT:    s_lshl_b32 s18, s40, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s17, s18, s17
; VI-NEXT:    s_and_b32 s18, s20, 0xffff
; VI-NEXT:    s_lshl_b32 s15, s15, 16
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    v_add_u32_e32 v21, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v37
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s15, s15, s18
; VI-NEXT:    s_and_b32 s18, s21, 0xffff
; VI-NEXT:    s_lshl_b32 s14, s14, 16
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s14, s14, s18
; VI-NEXT:    s_and_b32 s18, s22, 0xffff
; VI-NEXT:    s_lshl_b32 s13, s13, 16
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    v_add_u32_e32 v22, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v36
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s13, s13, s18
; VI-NEXT:    s_and_b32 s18, s23, 0xffff
; VI-NEXT:    s_lshl_b32 s12, s12, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s12, s12, s18
; VI-NEXT:    s_and_b32 s18, s24, 0xffff
; VI-NEXT:    s_lshl_b32 s11, s11, 16
; VI-NEXT:    s_add_i32 s25, s25, 3
; VI-NEXT:    v_add_u32_e32 v23, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v35
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s11, s11, s18
; VI-NEXT:    s_and_b32 s18, s25, 0xffff
; VI-NEXT:    s_lshl_b32 s10, s10, 16
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s10, s10, s18
; VI-NEXT:    s_and_b32 s18, s26, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    s_add_i32 s27, s27, 3
; VI-NEXT:    v_add_u32_e32 v24, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v34
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s9, s9, s18
; VI-NEXT:    s_and_b32 s18, s27, 0xffff
; VI-NEXT:    s_lshl_b32 s8, s8, 16
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s8, s8, s18
; VI-NEXT:    s_and_b32 s18, s28, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_add_i32 s29, s29, 3
; VI-NEXT:    v_add_u32_e32 v25, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v33
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s7, s7, s18
; VI-NEXT:    s_and_b32 s18, s29, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s6, s6, s18
; VI-NEXT:    v_add_u32_e32 v26, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v32
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v1, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_add_i32 s4, s4, 0x30000
; VI-NEXT:    s_add_i32 s5, s5, 0x30000
; VI-NEXT:    s_add_i32 s16, s16, 0x30000
; VI-NEXT:    s_add_i32 s17, s17, 0x30000
; VI-NEXT:    s_add_i32 s15, s15, 0x30000
; VI-NEXT:    s_add_i32 s14, s14, 0x30000
; VI-NEXT:    s_add_i32 s13, s13, 0x30000
; VI-NEXT:    s_add_i32 s12, s12, 0x30000
; VI-NEXT:    s_add_i32 s11, s11, 0x30000
; VI-NEXT:    s_add_i32 s10, s10, 0x30000
; VI-NEXT:    s_add_i32 s9, s9, 0x30000
; VI-NEXT:    s_add_i32 s8, s8, 0x30000
; VI-NEXT:    s_add_i32 s7, s7, 0x30000
; VI-NEXT:    s_add_i32 s6, s6, 0x30000
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v27, vcc, 0x30000, v0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    v_mov_b32_e32 v3, s17
; VI-NEXT:    v_mov_b32_e32 v4, s15
; VI-NEXT:    v_mov_b32_e32 v5, s14
; VI-NEXT:    v_mov_b32_e32 v6, s13
; VI-NEXT:    v_mov_b32_e32 v7, s12
; VI-NEXT:    v_mov_b32_e32 v8, s11
; VI-NEXT:    v_mov_b32_e32 v9, s10
; VI-NEXT:    v_mov_b32_e32 v10, s9
; VI-NEXT:    v_mov_b32_e32 v11, s8
; VI-NEXT:    v_mov_b32_e32 v12, s7
; VI-NEXT:    v_mov_b32_e32 v13, s6
; VI-NEXT:  .LBB31_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB31_4:
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_branch .LBB31_2
;
; GFX9-LABEL: bitcast_v56i16_to_v28f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v13
; GFX9-NEXT:    v_mov_b32_e32 v33, v12
; GFX9-NEXT:    v_mov_b32_e32 v34, v11
; GFX9-NEXT:    v_mov_b32_e32 v35, v10
; GFX9-NEXT:    v_mov_b32_e32 v36, v9
; GFX9-NEXT:    v_mov_b32_e32 v37, v8
; GFX9-NEXT:    v_mov_b32_e32 v38, v7
; GFX9-NEXT:    v_mov_b32_e32 v39, v6
; GFX9-NEXT:    v_mov_b32_e32 v48, v5
; GFX9-NEXT:    v_mov_b32_e32 v49, v4
; GFX9-NEXT:    v_mov_b32_e32 v50, v3
; GFX9-NEXT:    v_mov_b32_e32 v51, v2
; GFX9-NEXT:    v_mov_b32_e32 v52, v1
; GFX9-NEXT:    v_mov_b32_e32 v53, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    s_lshr_b32 s40, s29, 16
; GFX9-NEXT:    s_lshr_b32 s41, s28, 16
; GFX9-NEXT:    s_lshr_b32 s42, s27, 16
; GFX9-NEXT:    s_lshr_b32 s43, s26, 16
; GFX9-NEXT:    s_lshr_b32 s15, s25, 16
; GFX9-NEXT:    s_lshr_b32 s14, s24, 16
; GFX9-NEXT:    s_lshr_b32 s13, s23, 16
; GFX9-NEXT:    s_lshr_b32 s12, s22, 16
; GFX9-NEXT:    s_lshr_b32 s11, s21, 16
; GFX9-NEXT:    s_lshr_b32 s10, s20, 16
; GFX9-NEXT:    s_lshr_b32 s9, s19, 16
; GFX9-NEXT:    s_lshr_b32 s8, s18, 16
; GFX9-NEXT:    s_lshr_b32 s7, s17, 16
; GFX9-NEXT:    s_lshr_b32 s6, s16, 16
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v36
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v37
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s16, s6
; GFX9-NEXT:    s_pack_ll_b32_b16 s7, s17, s7
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s18, s8
; GFX9-NEXT:    s_pack_ll_b32_b16 s9, s19, s9
; GFX9-NEXT:    s_pack_ll_b32_b16 s10, s20, s10
; GFX9-NEXT:    s_pack_ll_b32_b16 s11, s21, s11
; GFX9-NEXT:    s_pack_ll_b32_b16 s12, s22, s12
; GFX9-NEXT:    s_pack_ll_b32_b16 s13, s23, s13
; GFX9-NEXT:    s_pack_ll_b32_b16 s14, s24, s14
; GFX9-NEXT:    s_pack_ll_b32_b16 s15, s25, s15
; GFX9-NEXT:    s_pack_ll_b32_b16 s16, s26, s43
; GFX9-NEXT:    s_pack_ll_b32_b16 s17, s27, s42
; GFX9-NEXT:    s_pack_ll_b32_b16 s18, s28, s41
; GFX9-NEXT:    s_pack_ll_b32_b16 s19, s29, s40
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v38
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v39
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v48
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v49
; GFX9-NEXT:    v_lshrrev_b32_e32 v56, 16, v50
; GFX9-NEXT:    v_lshrrev_b32_e32 v57, 16, v51
; GFX9-NEXT:    v_lshrrev_b32_e32 v58, 16, v52
; GFX9-NEXT:    v_lshrrev_b32_e32 v59, 16, v53
; GFX9-NEXT:    s_cbranch_scc0 .LBB31_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v53
; GFX9-NEXT:    v_lshl_or_b32 v14, v59, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v52
; GFX9-NEXT:    v_lshl_or_b32 v15, v58, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v51
; GFX9-NEXT:    v_lshl_or_b32 v16, v57, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v50
; GFX9-NEXT:    v_lshl_or_b32 v17, v56, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v49
; GFX9-NEXT:    v_lshl_or_b32 v18, v47, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v48
; GFX9-NEXT:    v_lshl_or_b32 v19, v46, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v39
; GFX9-NEXT:    v_lshl_or_b32 v20, v45, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v38
; GFX9-NEXT:    v_lshl_or_b32 v21, v44, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v37
; GFX9-NEXT:    v_lshl_or_b32 v22, v43, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v36
; GFX9-NEXT:    v_lshl_or_b32 v23, v42, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v35
; GFX9-NEXT:    v_lshl_or_b32 v24, v41, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v34
; GFX9-NEXT:    v_lshl_or_b32 v25, v40, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v33
; GFX9-NEXT:    v_lshl_or_b32 v26, v55, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v32
; GFX9-NEXT:    v_lshl_or_b32 v27, v54, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:    v_mov_b32_e32 v6, s12
; GFX9-NEXT:    v_mov_b32_e32 v7, s13
; GFX9-NEXT:    v_mov_b32_e32 v8, s14
; GFX9-NEXT:    v_mov_b32_e32 v9, s15
; GFX9-NEXT:    v_mov_b32_e32 v10, s16
; GFX9-NEXT:    v_mov_b32_e32 v11, s17
; GFX9-NEXT:    v_mov_b32_e32 v12, s18
; GFX9-NEXT:    v_mov_b32_e32 v13, s19
; GFX9-NEXT:    s_cbranch_execnz .LBB31_3
; GFX9-NEXT:  .LBB31_2: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v14, 0xffff, v53
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v52
; GFX9-NEXT:    v_and_b32_e32 v16, 0xffff, v51
; GFX9-NEXT:    v_and_b32_e32 v17, 0xffff, v50
; GFX9-NEXT:    v_and_b32_e32 v18, 0xffff, v49
; GFX9-NEXT:    v_and_b32_e32 v19, 0xffff, v48
; GFX9-NEXT:    v_and_b32_e32 v20, 0xffff, v39
; GFX9-NEXT:    v_and_b32_e32 v21, 0xffff, v38
; GFX9-NEXT:    v_and_b32_e32 v22, 0xffff, v37
; GFX9-NEXT:    v_and_b32_e32 v23, 0xffff, v36
; GFX9-NEXT:    v_and_b32_e32 v24, 0xffff, v35
; GFX9-NEXT:    v_and_b32_e32 v25, 0xffff, v34
; GFX9-NEXT:    v_and_b32_e32 v26, 0xffff, v33
; GFX9-NEXT:    v_and_b32_e32 v27, 0xffff, v32
; GFX9-NEXT:    v_lshl_or_b32 v14, v59, 16, v14
; GFX9-NEXT:    v_lshl_or_b32 v15, v58, 16, v15
; GFX9-NEXT:    v_lshl_or_b32 v16, v57, 16, v16
; GFX9-NEXT:    v_lshl_or_b32 v17, v56, 16, v17
; GFX9-NEXT:    v_lshl_or_b32 v18, v47, 16, v18
; GFX9-NEXT:    v_lshl_or_b32 v19, v46, 16, v19
; GFX9-NEXT:    v_lshl_or_b32 v20, v45, 16, v20
; GFX9-NEXT:    v_lshl_or_b32 v21, v44, 16, v21
; GFX9-NEXT:    v_lshl_or_b32 v22, v43, 16, v22
; GFX9-NEXT:    v_lshl_or_b32 v23, v42, 16, v23
; GFX9-NEXT:    v_lshl_or_b32 v24, v41, 16, v24
; GFX9-NEXT:    v_lshl_or_b32 v25, v40, 16, v25
; GFX9-NEXT:    v_lshl_or_b32 v26, v55, 16, v26
; GFX9-NEXT:    v_lshl_or_b32 v27, v54, 16, v27
; GFX9-NEXT:    v_pk_add_u16 v0, s6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, s8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, s9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, s10, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, s11, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, s12, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v7, s13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, s14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v9, s15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v10, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v11, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v12, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, s19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v20, v20, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v21, v21, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v22, v22, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v23, v23, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v24, v24, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v25, v25, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v26, v26, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v27, v27, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB31_3: ; %end
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB31_4:
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_branch .LBB31_2
;
; GFX11-TRUE16-LABEL: bitcast_v56i16_to_v28f32_scalar:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.h, 0
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v10
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.l, v9.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.l, v8.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v34.l, v7.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v34.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v35.l, v6.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v35.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v36.l, v5.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v36.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v37.l, v4.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v37.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v38.l, v3.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v38.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v39.l, v2.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v39.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v48.l, v1.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v48.h, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v49.l, v0.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v49.h, v32.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v67, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v66, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v65, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v64, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v55, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v54, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v53, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v52, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v51, 0xffff, v8
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v50, 0xffff, v9
; GFX11-TRUE16-NEXT:    s_lshr_b32 s40, s29, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s41, s28, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s42, s27, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s14, s26, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s13, s25, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s12, s24, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s11, s23, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s10, s22, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s9, s21, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s8, s20, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s7, s19, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s6, s18, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s5, s17, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s4, s16, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s43, s3, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s44, s2, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s45, s1, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s46, s0, 16
; GFX11-TRUE16-NEXT:    s_mov_b32 s15, 0
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s0, s0, s46
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s1, s1, s45
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s2, s2, s44
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s43
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s4, s16, s4
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s5, s17, s5
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s6, s18, s6
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s7, s19, s7
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s8, s20, s8
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s9, s21, s9
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s10, s22, s10
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s11, s23, s11
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s12, s24, s12
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s13, s25, s13
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s14, s26, s14
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s16, s27, s42
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s17, s28, s41
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s18, s29, s40
; GFX11-TRUE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-TRUE16-NEXT:    s_cbranch_scc0 .LBB31_4
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v49, 16, v67
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v48, 16, v66
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v20, v39, 16, v65
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v21, v38, 16, v64
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v22, v37, 16, v55
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v23, v36, 16, v54
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v24, v35, 16, v53
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v25, v34, 16, v52
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v26, v33, 16, v51
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v27, v32, 16, v50
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v8, s8 :: v_dual_mov_b32 v9, s9
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v10, s10 :: v_dual_mov_b32 v11, s11
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v12, s12 :: v_dual_mov_b32 v13, s13
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v14, s14 :: v_dual_mov_b32 v15, s16
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v16, s17 :: v_dual_mov_b32 v17, s18
; GFX11-TRUE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s15
; GFX11-TRUE16-NEXT:    s_cbranch_vccnz .LBB31_3
; GFX11-TRUE16-NEXT:  .LBB31_2: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v49, 16, v67
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v48, 16, v66
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v20, v39, 16, v65
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v21, v38, 16, v64
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v22, v37, 16, v55
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v23, v36, 16, v54
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v24, v35, 16, v53
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v25, v34, 16, v52
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v26, v33, 16, v51
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v27, v32, 16, v50
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v4, s4, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v5, s5, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v6, s6, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v7, s7, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v8, s8, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v9, s9, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v10, s10, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v11, s11, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v12, s12, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v13, s13, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v14, s14, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v15, s16, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v16, s17, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v17, s18, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v20, v20, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v21, v21, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v22, v22, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v23, v23, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v24, v24, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v25, v25, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v26, v26, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v27, v27, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:  .LBB31_3: ; %end
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB31_4:
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-TRUE16-NEXT:    s_branch .LBB31_2
;
; GFX11-FAKE16-LABEL: bitcast_v56i16_to_v28f32_scalar:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v67, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v66, 0xffff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v65, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v64, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v55, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v54, 0xffff, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v53, 0xffff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v52, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v51, 0xffff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v50, 0xffff, v9
; GFX11-FAKE16-NEXT:    s_lshr_b32 s40, s29, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s41, s28, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s42, s27, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s14, s26, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s13, s25, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s12, s24, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s11, s23, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s10, s22, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s9, s21, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s8, s20, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s7, s19, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s6, s18, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s5, s17, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s4, s16, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s43, s3, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s44, s2, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s45, s1, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s46, s0, 16
; GFX11-FAKE16-NEXT:    s_mov_b32 s15, 0
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s0, s0, s46
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s1, s1, s45
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s2, s2, s44
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s43
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s4, s16, s4
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s5, s17, s5
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s6, s18, s6
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s7, s19, s7
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s8, s20, s8
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s9, s21, s9
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s10, s22, s10
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s11, s23, s11
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s12, s24, s12
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s13, s25, s13
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s14, s26, s14
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s16, s27, s42
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s17, s28, s41
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s18, s29, s40
; GFX11-FAKE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-FAKE16-NEXT:    s_cbranch_scc0 .LBB31_4
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v49, 16, v67
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v48, 16, v66
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v20, v39, 16, v65
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v21, v38, 16, v64
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v22, v37, 16, v55
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v23, v36, 16, v54
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v24, v35, 16, v53
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v25, v34, 16, v52
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v26, v33, 16, v51
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v27, v32, 16, v50
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v8, s8 :: v_dual_mov_b32 v9, s9
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v10, s10 :: v_dual_mov_b32 v11, s11
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v12, s12 :: v_dual_mov_b32 v13, s13
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v14, s14 :: v_dual_mov_b32 v15, s16
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v16, s17 :: v_dual_mov_b32 v17, s18
; GFX11-FAKE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s15
; GFX11-FAKE16-NEXT:    s_cbranch_vccnz .LBB31_3
; GFX11-FAKE16-NEXT:  .LBB31_2: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v49, 16, v67
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v48, 16, v66
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v20, v39, 16, v65
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v21, v38, 16, v64
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v22, v37, 16, v55
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v23, v36, 16, v54
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v24, v35, 16, v53
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v25, v34, 16, v52
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v26, v33, 16, v51
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v27, v32, 16, v50
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v4, s4, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v5, s5, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v6, s6, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v7, s7, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v8, s8, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v9, s9, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v10, s10, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v11, s11, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v12, s12, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v13, s13, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v14, s14, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v15, s16, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v16, s17, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v17, s18, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v20, v20, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v21, v21, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v22, v22, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v23, v23, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v24, v24, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v25, v25, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v26, v26, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v27, v27, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:  .LBB31_3: ; %end
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB31_4:
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-FAKE16-NEXT:    s_branch .LBB31_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <56 x i16> %a, splat (i16 3)
  %a2 = bitcast <56 x i16> %a1 to <28 x float>
  br label %end

cmp.false:
  %a3 = bitcast <56 x i16> %a to <28 x float>
  br label %end

end:
  %phi = phi <28 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <28 x float> %phi
}

define <56 x half> @bitcast_v28f32_to_v56f16(<28 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v28f32_to_v56f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr63
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr61
; SI-NEXT:    ; kill: killed $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr62
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB32_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v35, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v27
; SI-NEXT:    v_cvt_f32_f16_e32 v33, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v25
; SI-NEXT:    v_cvt_f32_f16_e32 v43, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v24
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v62, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v61, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v59, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v22
; SI-NEXT:    buffer_store_dword v29, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v45, v27
; SI-NEXT:    buffer_store_dword v29, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v47, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v57, v25
; SI-NEXT:    buffer_store_dword v29, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v18
; SI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v23, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v29, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v42, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v44, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v46, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v56, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v58, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v60, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v63, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v32, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v34, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v36, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v38, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v48, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v51, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v53, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v55, v29
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v41, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v28
; SI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v21, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v19, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    v_cvt_f32_f16_e32 v37, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v39, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v49, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v50, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v52, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v54, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v40, v1
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:  .LBB32_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB32_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_lshrrev_b32_e32 v57, 16, v21
; SI-NEXT:    v_lshrrev_b32_e32 v55, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v54, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v57
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_lshrrev_b32_e32 v47, 16, v20
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v47
; SI-NEXT:    v_lshrrev_b32_e32 v45, 16, v19
; SI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v45
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v25
; SI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; SI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; SI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; SI-NEXT:    v_lshrrev_b32_e32 v41, 16, v1
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v51, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v32, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v63, 16, v11
; SI-NEXT:    v_lshrrev_b32_e32 v60, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v58, 16, v13
; SI-NEXT:    v_lshrrev_b32_e32 v56, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v46, 16, v15
; SI-NEXT:    v_lshrrev_b32_e32 v44, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v42, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v43, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v59, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v61, 16, v23
; SI-NEXT:    v_lshrrev_b32_e32 v62, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v33, 16, v27
; SI-NEXT:    v_lshrrev_b32_e32 v35, 16, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v27
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v25
; SI-NEXT:    v_cvt_f32_f16_e32 v40, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v37, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v39, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v49, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v50, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v52, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v35, v35
; SI-NEXT:    v_cvt_f32_f16_e32 v33, v33
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v31
; SI-NEXT:    v_cvt_f32_f16_e32 v62, v62
; SI-NEXT:    v_cvt_f32_f16_e32 v61, v61
; SI-NEXT:    v_cvt_f32_f16_e32 v59, v59
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v43
; SI-NEXT:    v_cvt_f32_f16_e32 v42, v42
; SI-NEXT:    v_cvt_f32_f16_e32 v44, v44
; SI-NEXT:    v_cvt_f32_f16_e32 v46, v46
; SI-NEXT:    v_cvt_f32_f16_e32 v56, v56
; SI-NEXT:    v_cvt_f32_f16_e32 v58, v58
; SI-NEXT:    v_cvt_f32_f16_e32 v60, v60
; SI-NEXT:    v_cvt_f32_f16_e32 v63, v63
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v30
; SI-NEXT:    v_cvt_f32_f16_e32 v32, v32
; SI-NEXT:    v_cvt_f32_f16_e32 v34, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v36, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v38, v38
; SI-NEXT:    v_cvt_f32_f16_e32 v48, v48
; SI-NEXT:    v_cvt_f32_f16_e32 v51, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v53, v53
; SI-NEXT:    v_cvt_f32_f16_e32 v55, v55
; SI-NEXT:    v_cvt_f32_f16_e32 v41, v41
; SI-NEXT:    v_mov_b32_e32 v29, v28
; SI-NEXT:    v_mov_b32_e32 v57, v25
; SI-NEXT:    v_mov_b32_e32 v47, v26
; SI-NEXT:    v_mov_b32_e32 v45, v27
; SI-NEXT:    v_mov_b32_e32 v43, v1
; SI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v23, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v21, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v20, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v19, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:  .LBB32_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v41
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v40
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v55
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v54
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v2, v4, v2
; SI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v53
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v52
; SI-NEXT:    v_add_i32_e32 v3, vcc, 8, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v51
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v50
; SI-NEXT:    v_add_i32_e32 v3, vcc, 12, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v48
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v49
; SI-NEXT:    v_add_i32_e32 v3, vcc, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v38
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v39
; SI-NEXT:    v_add_i32_e32 v3, vcc, 20, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v36
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v37
; SI-NEXT:    v_add_i32_e32 v3, vcc, 24, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v34
; SI-NEXT:    v_add_i32_e32 v3, vcc, 28, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v32
; SI-NEXT:    v_add_i32_e32 v3, vcc, 32, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v30
; SI-NEXT:    v_add_i32_e32 v3, vcc, 36, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v63
; SI-NEXT:    v_add_i32_e32 v3, vcc, 40, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v60
; SI-NEXT:    v_add_i32_e32 v3, vcc, 44, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v58
; SI-NEXT:    v_add_i32_e32 v3, vcc, 48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v56
; SI-NEXT:    v_add_i32_e32 v3, vcc, 52, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v46
; SI-NEXT:    v_add_i32_e32 v3, vcc, 56, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v44
; SI-NEXT:    v_add_i32_e32 v3, vcc, 60, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v42
; SI-NEXT:    v_add_i32_e32 v3, vcc, 64, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x44, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x48, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x4c, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x50, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v59
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x54, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v61
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x58, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v62
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x5c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v43
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v57
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x60, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v31
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v47
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x64, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v33
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v45
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x68, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v35
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v29
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x6c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v28f32_to_v56f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    ; implicit-def: $vgpr47
; VI-NEXT:    ; implicit-def: $vgpr46
; VI-NEXT:    ; implicit-def: $vgpr45
; VI-NEXT:    ; implicit-def: $vgpr44
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB32_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; VI-NEXT:  .LBB32_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB32_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; VI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; VI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; VI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; VI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; VI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; VI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; VI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; VI-NEXT:  .LBB32_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_lshlrev_b32_e32 v47, 16, v47
; VI-NEXT:    v_lshlrev_b32_e32 v46, 16, v46
; VI-NEXT:    v_lshlrev_b32_e32 v45, 16, v45
; VI-NEXT:    v_lshlrev_b32_e32 v44, 16, v44
; VI-NEXT:    v_lshlrev_b32_e32 v43, 16, v43
; VI-NEXT:    v_lshlrev_b32_e32 v42, 16, v42
; VI-NEXT:    v_lshlrev_b32_e32 v41, 16, v41
; VI-NEXT:    v_lshlrev_b32_e32 v40, 16, v40
; VI-NEXT:    v_or_b32_sdwa v0, v0, v47 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v46 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v45 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v44 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v43 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v42 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v41 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v40 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; VI-NEXT:    v_lshlrev_b32_e32 v55, 16, v55
; VI-NEXT:    v_lshlrev_b32_e32 v54, 16, v54
; VI-NEXT:    v_lshlrev_b32_e32 v53, 16, v53
; VI-NEXT:    v_lshlrev_b32_e32 v52, 16, v52
; VI-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; VI-NEXT:    v_lshlrev_b32_e32 v50, 16, v50
; VI-NEXT:    v_lshlrev_b32_e32 v49, 16, v49
; VI-NEXT:    v_lshlrev_b32_e32 v48, 16, v48
; VI-NEXT:    v_lshlrev_b32_e32 v39, 16, v39
; VI-NEXT:    v_lshlrev_b32_e32 v38, 16, v38
; VI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; VI-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; VI-NEXT:    v_lshlrev_b32_e32 v35, 16, v35
; VI-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; VI-NEXT:    v_lshlrev_b32_e32 v33, 16, v33
; VI-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; VI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; VI-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; VI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; VI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; VI-NEXT:    v_or_b32_sdwa v8, v8, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v9, v54 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v10, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v11, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v12, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v13, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v14, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v15, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v16, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v17, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v18, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v19, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v20, v20, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v21, v21, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v22, v22, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v23, v23, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v24, v24, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v25, v25, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v26, v26, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v27, v27, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v28f32_to_v56f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v28
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB32_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; GFX9-NEXT:  .LBB32_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB32_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v27, 1.0, v27
; GFX9-NEXT:    v_add_f32_e32 v26, 1.0, v26
; GFX9-NEXT:    v_add_f32_e32 v25, 1.0, v25
; GFX9-NEXT:    v_add_f32_e32 v24, 1.0, v24
; GFX9-NEXT:    v_add_f32_e32 v23, 1.0, v23
; GFX9-NEXT:    v_add_f32_e32 v22, 1.0, v22
; GFX9-NEXT:    v_add_f32_e32 v21, 1.0, v21
; GFX9-NEXT:    v_add_f32_e32 v20, 1.0, v20
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; GFX9-NEXT:  .LBB32_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v47, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v46, v1, s4
; GFX9-NEXT:    v_perm_b32 v2, v45, v2, s4
; GFX9-NEXT:    v_perm_b32 v3, v44, v3, s4
; GFX9-NEXT:    v_perm_b32 v4, v43, v4, s4
; GFX9-NEXT:    v_perm_b32 v5, v42, v5, s4
; GFX9-NEXT:    v_perm_b32 v6, v41, v6, s4
; GFX9-NEXT:    v_perm_b32 v7, v40, v7, s4
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    v_perm_b32 v8, v55, v8, s4
; GFX9-NEXT:    v_perm_b32 v9, v54, v9, s4
; GFX9-NEXT:    v_perm_b32 v10, v53, v10, s4
; GFX9-NEXT:    v_perm_b32 v11, v52, v11, s4
; GFX9-NEXT:    v_perm_b32 v12, v51, v12, s4
; GFX9-NEXT:    v_perm_b32 v13, v50, v13, s4
; GFX9-NEXT:    v_perm_b32 v14, v49, v14, s4
; GFX9-NEXT:    v_perm_b32 v15, v48, v15, s4
; GFX9-NEXT:    v_perm_b32 v16, v39, v16, s4
; GFX9-NEXT:    v_perm_b32 v17, v38, v17, s4
; GFX9-NEXT:    v_perm_b32 v18, v37, v18, s4
; GFX9-NEXT:    v_perm_b32 v19, v36, v19, s4
; GFX9-NEXT:    v_perm_b32 v20, v35, v20, s4
; GFX9-NEXT:    v_perm_b32 v21, v34, v21, s4
; GFX9-NEXT:    v_perm_b32 v22, v33, v22, s4
; GFX9-NEXT:    v_perm_b32 v23, v32, v23, s4
; GFX9-NEXT:    v_perm_b32 v24, v31, v24, s4
; GFX9-NEXT:    v_perm_b32 v25, v30, v25, s4
; GFX9-NEXT:    v_perm_b32 v26, v29, v26, s4
; GFX9-NEXT:    v_perm_b32 v27, v28, v27, s4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v28f32_to_v56f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v28
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB32_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v25, 1.0, v25 :: v_dual_add_f32 v24, 1.0, v24
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v23, 1.0, v23 :: v_dual_add_f32 v22, 1.0, v22
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v21, 1.0, v21 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-TRUE16-NEXT:  .LBB32_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v28f32_to_v56f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr71
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr70
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr69
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr68
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr67
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr66
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr65
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr64
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr55
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr54
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr53
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr52
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr51
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr50
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr49
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr48
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB32_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v65, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v66, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v0
; GFX11-FAKE16-NEXT:  .LBB32_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB32_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v25, 1.0, v25 :: v_dual_add_f32 v24, 1.0, v24
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v23, 1.0, v23 :: v_dual_add_f32 v22, 1.0, v22
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v21, 1.0, v21 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v23
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v21
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v65, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v66, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v69, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v70, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v0
; GFX11-FAKE16-NEXT:  .LBB32_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v71, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v70, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v69, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v68, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v67, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v66, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v65, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v64, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v55, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v54, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v53, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v52, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v51, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v50, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v49, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v48, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v39, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v38, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v37, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v36, v19, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v20, v35, v20, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v21, v34, v21, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v22, v33, v22, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v23, v32, v23, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v24, v31, v24, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v25, v30, v25, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v26, v29, v26, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v27, v28, v27, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <28 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <28 x float> %a1 to <56 x half>
  br label %end

cmp.false:
  %a3 = bitcast <28 x float> %a to <56 x half>
  br label %end

end:
  %phi = phi <56 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <56 x half> %phi
}

define inreg <56 x half> @bitcast_v28f32_to_v56f16_scalar(<28 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v28f32_to_v56f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v15
; SI-NEXT:    v_readfirstlane_b32 s43, v1
; SI-NEXT:    v_readfirstlane_b32 s42, v2
; SI-NEXT:    v_readfirstlane_b32 s41, v3
; SI-NEXT:    v_readfirstlane_b32 s40, v4
; SI-NEXT:    v_readfirstlane_b32 s15, v5
; SI-NEXT:    v_readfirstlane_b32 s14, v6
; SI-NEXT:    v_readfirstlane_b32 s13, v7
; SI-NEXT:    v_readfirstlane_b32 s12, v8
; SI-NEXT:    v_readfirstlane_b32 s11, v9
; SI-NEXT:    v_readfirstlane_b32 s10, v10
; SI-NEXT:    v_readfirstlane_b32 s8, v11
; SI-NEXT:    v_readfirstlane_b32 s7, v12
; SI-NEXT:    v_readfirstlane_b32 s6, v13
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_readfirstlane_b32 s9, v14
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_cbranch_scc0 .LBB33_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s9, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v40, s4
; SI-NEXT:    s_lshr_b32 s4, s6, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v41, s4
; SI-NEXT:    s_lshr_b32 s4, s7, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v43, s4
; SI-NEXT:    s_lshr_b32 s4, s8, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v45, s4
; SI-NEXT:    s_lshr_b32 s4, s10, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v47, s4
; SI-NEXT:    s_lshr_b32 s4, s11, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v54, s4
; SI-NEXT:    s_lshr_b32 s4, s12, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v50, s4
; SI-NEXT:    s_lshr_b32 s4, s13, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s4
; SI-NEXT:    s_lshr_b32 s4, s14, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s4
; SI-NEXT:    s_lshr_b32 s4, s15, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v18, s4
; SI-NEXT:    s_lshr_b32 s4, s40, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v20, s4
; SI-NEXT:    s_lshr_b32 s4, s41, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v22, s4
; SI-NEXT:    s_lshr_b32 s4, s42, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v24, s4
; SI-NEXT:    s_lshr_b32 s4, s43, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v26, s4
; SI-NEXT:    s_lshr_b32 s4, s29, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v28, s4
; SI-NEXT:    s_lshr_b32 s4, s28, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v30, s4
; SI-NEXT:    s_lshr_b32 s4, s27, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v32, s4
; SI-NEXT:    s_lshr_b32 s4, s26, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v35, s4
; SI-NEXT:    s_lshr_b32 s4, s25, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v37, s4
; SI-NEXT:    s_lshr_b32 s4, s24, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v39, s4
; SI-NEXT:    s_lshr_b32 s4, s23, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v49, s4
; SI-NEXT:    s_lshr_b32 s4, s22, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v51, s4
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v53, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v55, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v42, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v44, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v46, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v56, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v38, s9
; SI-NEXT:    v_cvt_f32_f16_e32 v52, s6
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_cvt_f32_f16_e32 v57, s7
; SI-NEXT:    s_waitcnt expcnt(5)
; SI-NEXT:    v_cvt_f32_f16_e32 v58, s8
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_cvt_f32_f16_e32 v59, s10
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    v_cvt_f32_f16_e32 v60, s11
; SI-NEXT:    v_cvt_f32_f16_e32 v16, s12
; SI-NEXT:    v_cvt_f32_f16_e32 v17, s13
; SI-NEXT:    v_cvt_f32_f16_e32 v19, s14
; SI-NEXT:    v_cvt_f32_f16_e32 v21, s15
; SI-NEXT:    v_cvt_f32_f16_e32 v23, s40
; SI-NEXT:    v_cvt_f32_f16_e32 v25, s41
; SI-NEXT:    v_cvt_f32_f16_e32 v27, s42
; SI-NEXT:    v_cvt_f32_f16_e32 v29, s43
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s29
; SI-NEXT:    v_cvt_f32_f16_e32 v33, s28
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s27
; SI-NEXT:    v_cvt_f32_f16_e32 v36, s26
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s25
; SI-NEXT:    v_cvt_f32_f16_e32 v48, s24
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s16
; SI-NEXT:    s_cbranch_execnz .LBB33_3
; SI-NEXT:  .LBB33_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v1, s16, 1.0
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_add_f32_e64 v14, s11, 1.0
; SI-NEXT:    v_add_f32_e64 v36, s6, 1.0
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v54, 16, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v41, v54
; SI-NEXT:    v_cvt_f32_f16_e32 v54, v6
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    v_add_f32_e64 v10, s8, 1.0
; SI-NEXT:    v_add_f32_e64 v26, s29, 1.0
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v26
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_cvt_f32_f16_e32 v58, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v31
; SI-NEXT:    v_add_f32_e64 v12, s10, 1.0
; SI-NEXT:    v_add_f32_e64 v33, s7, 1.0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_f32_e64 v2, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v3, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v5, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v7, s20, 1.0
; SI-NEXT:    v_add_f32_e64 v9, s21, 1.0
; SI-NEXT:    v_add_f32_e64 v11, s22, 1.0
; SI-NEXT:    v_add_f32_e64 v13, s23, 1.0
; SI-NEXT:    v_add_f32_e64 v15, s24, 1.0
; SI-NEXT:    v_add_f32_e64 v18, s25, 1.0
; SI-NEXT:    v_add_f32_e64 v20, s26, 1.0
; SI-NEXT:    v_add_f32_e64 v22, s27, 1.0
; SI-NEXT:    v_add_f32_e64 v24, s28, 1.0
; SI-NEXT:    v_add_f32_e64 v29, s43, 1.0
; SI-NEXT:    v_add_f32_e64 v27, s42, 1.0
; SI-NEXT:    v_add_f32_e64 v25, s41, 1.0
; SI-NEXT:    v_add_f32_e64 v23, s40, 1.0
; SI-NEXT:    v_add_f32_e64 v21, s15, 1.0
; SI-NEXT:    v_add_f32_e64 v19, s14, 1.0
; SI-NEXT:    v_add_f32_e64 v17, s13, 1.0
; SI-NEXT:    v_add_f32_e64 v16, s12, 1.0
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v33
; SI-NEXT:    v_add_f32_e64 v48, s9, 1.0
; SI-NEXT:    v_lshrrev_b32_e32 v56, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v46, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v44, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v42, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v55, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v11
; SI-NEXT:    v_lshrrev_b32_e32 v51, 16, v13
; SI-NEXT:    v_lshrrev_b32_e32 v49, 16, v15
; SI-NEXT:    v_lshrrev_b32_e32 v39, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v37, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v35, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v32, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v43, 16, v29
; SI-NEXT:    v_lshrrev_b32_e32 v45, 16, v27
; SI-NEXT:    v_lshrrev_b32_e32 v28, 16, v25
; SI-NEXT:    v_lshrrev_b32_e32 v47, 16, v23
; SI-NEXT:    v_lshrrev_b32_e32 v61, 16, v21
; SI-NEXT:    v_lshrrev_b32_e32 v62, 16, v19
; SI-NEXT:    v_lshrrev_b32_e32 v63, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v50, 16, v48
; SI-NEXT:    v_cvt_f32_f16_e32 v34, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v38, v48
; SI-NEXT:    v_cvt_f32_f16_e32 v52, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v57, v33
; SI-NEXT:    v_cvt_f32_f16_e32 v59, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v60, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v25
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v27
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v33, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v36, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v48, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v40, v50
; SI-NEXT:    v_cvt_f32_f16_e32 v50, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v63
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v62
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v61
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v47
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v45
; SI-NEXT:    v_mov_b32_e32 v45, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v43
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v30
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v32
; SI-NEXT:    v_cvt_f32_f16_e32 v32, v35
; SI-NEXT:    v_cvt_f32_f16_e32 v35, v37
; SI-NEXT:    v_cvt_f32_f16_e32 v37, v39
; SI-NEXT:    v_cvt_f32_f16_e32 v39, v49
; SI-NEXT:    v_cvt_f32_f16_e32 v49, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v51, v53
; SI-NEXT:    v_cvt_f32_f16_e32 v53, v55
; SI-NEXT:    v_cvt_f32_f16_e32 v55, v42
; SI-NEXT:    v_cvt_f32_f16_e32 v42, v44
; SI-NEXT:    v_cvt_f32_f16_e32 v44, v46
; SI-NEXT:    v_cvt_f32_f16_e32 v46, v56
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v56, v6
; SI-NEXT:    v_mov_b32_e32 v47, v8
; SI-NEXT:    v_mov_b32_e32 v43, v34
; SI-NEXT:  .LBB33_3: ; %end
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v56
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v31, v46
; SI-NEXT:    v_cvt_f16_f32_e32 v34, v2
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v31
; SI-NEXT:    buffer_store_dword v6, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v6, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v8, v34, v8
; SI-NEXT:    buffer_store_dword v8, v6, s[0:3], 0 offen
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v44
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v3
; SI-NEXT:    v_add_i32_e32 v31, vcc, 8, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v31, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v42
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v5
; SI-NEXT:    v_add_i32_e32 v31, vcc, 12, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v31, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v55
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v7
; SI-NEXT:    v_add_i32_e32 v31, vcc, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v31, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v53
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v9
; SI-NEXT:    v_add_i32_e32 v31, vcc, 20, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v31, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v51
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v11
; SI-NEXT:    v_add_i32_e32 v31, vcc, 24, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v31, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v49
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v13
; SI-NEXT:    v_add_i32_e32 v13, vcc, 28, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v13, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v39
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v48
; SI-NEXT:    v_add_i32_e32 v13, vcc, 32, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v13, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v37
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 36, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v13, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v35
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v36
; SI-NEXT:    v_add_i32_e32 v13, vcc, 40, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v13, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v32
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v12
; SI-NEXT:    v_add_i32_e32 v12, vcc, 44, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v12, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v30
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v33
; SI-NEXT:    v_add_i32_e32 v12, vcc, 48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v12, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v10
; SI-NEXT:    v_add_i32_e32 v10, vcc, 52, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v10, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v29
; SI-NEXT:    v_add_i32_e32 v10, vcc, 56, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v10, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v27
; SI-NEXT:    v_add_i32_e32 v10, vcc, 60, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v10, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v25
; SI-NEXT:    v_add_i32_e32 v10, vcc, 64, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v10, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v23
; SI-NEXT:    v_add_i32_e32 v10, vcc, 0x44, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v10, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v21
; SI-NEXT:    v_add_i32_e32 v10, vcc, 0x48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    buffer_store_dword v6, v10, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v19
; SI-NEXT:    v_add_i32_e32 v10, vcc, 0x4c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    buffer_store_dword v6, v10, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v17
; SI-NEXT:    v_add_i32_e32 v8, vcc, 0x50, v0
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    buffer_store_dword v4, v8, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v50
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v16
; SI-NEXT:    v_add_i32_e32 v8, vcc, 0x54, v0
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    buffer_store_dword v4, v8, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v54
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v60
; SI-NEXT:    v_add_i32_e32 v8, vcc, 0x58, v0
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    buffer_store_dword v4, v8, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v47
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v59
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x5c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    buffer_store_dword v4, v7, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v45
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v58
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x60, v0
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v43
; SI-NEXT:    buffer_store_dword v4, v6, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v57
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x64, v0
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v41
; SI-NEXT:    buffer_store_dword v3, v5, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v52
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x68, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v40
; SI-NEXT:    buffer_store_dword v2, v4, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v38
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x6c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB33_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    s_branch .LBB33_2
;
; VI-LABEL: bitcast_v28f32_to_v56f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; VI-NEXT:    v_mov_b32_e32 v20, s16
; VI-NEXT:    v_mov_b32_e32 v18, s17
; VI-NEXT:    v_mov_b32_e32 v17, s18
; VI-NEXT:    v_mov_b32_e32 v16, s19
; VI-NEXT:    v_mov_b32_e32 v15, s20
; VI-NEXT:    v_mov_b32_e32 v26, s21
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v27, s22
; VI-NEXT:    v_mov_b32_e32 v25, s23
; VI-NEXT:    v_mov_b32_e32 v24, s24
; VI-NEXT:    v_mov_b32_e32 v23, s25
; VI-NEXT:    v_mov_b32_e32 v22, s26
; VI-NEXT:    v_mov_b32_e32 v21, s27
; VI-NEXT:    v_mov_b32_e32 v19, s28
; VI-NEXT:    v_mov_b32_e32 v14, s29
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    s_cbranch_scc0 .LBB33_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v48, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v21
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v22
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v23
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v24
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v25
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v27
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v26
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v20
; VI-NEXT:    s_cbranch_execnz .LBB33_3
; VI-NEXT:  .LBB33_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; VI-NEXT:    v_add_f32_e32 v22, 1.0, v22
; VI-NEXT:    v_add_f32_e32 v23, 1.0, v23
; VI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; VI-NEXT:    v_add_f32_e32 v25, 1.0, v25
; VI-NEXT:    v_add_f32_e32 v27, 1.0, v27
; VI-NEXT:    v_add_f32_e32 v26, 1.0, v26
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; VI-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v48, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v21
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v22
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v23
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v24
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v25
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v27
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v26
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v20
; VI-NEXT:  .LBB33_3: ; %end
; VI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; VI-NEXT:    v_or_b32_sdwa v28, v20, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v20, 16, v29
; VI-NEXT:    v_or_b32_sdwa v29, v18, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v18, 16, v30
; VI-NEXT:    v_or_b32_sdwa v30, v17, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v17, 16, v31
; VI-NEXT:    v_or_b32_sdwa v31, v16, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v32
; VI-NEXT:    v_or_b32_sdwa v32, v15, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v33
; VI-NEXT:    v_or_b32_sdwa v33, v26, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v34
; VI-NEXT:    v_or_b32_sdwa v34, v27, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v35
; VI-NEXT:    v_or_b32_sdwa v35, v25, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v36
; VI-NEXT:    v_or_b32_sdwa v36, v24, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v37
; VI-NEXT:    v_or_b32_sdwa v37, v23, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v38
; VI-NEXT:    v_or_b32_sdwa v38, v22, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v39
; VI-NEXT:    v_or_b32_sdwa v39, v21, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v48
; VI-NEXT:    v_or_b32_sdwa v48, v19, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v15, 16, v49
; VI-NEXT:    v_or_b32_sdwa v49, v14, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v47
; VI-NEXT:    v_or_b32_sdwa v14, v0, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v46
; VI-NEXT:    v_or_b32_sdwa v15, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v45
; VI-NEXT:    v_or_b32_sdwa v16, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v44
; VI-NEXT:    v_or_b32_sdwa v17, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v43
; VI-NEXT:    v_or_b32_sdwa v18, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v42
; VI-NEXT:    v_or_b32_sdwa v19, v5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v41
; VI-NEXT:    v_or_b32_sdwa v20, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v40
; VI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; VI-NEXT:    v_or_b32_sdwa v21, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v55
; VI-NEXT:    v_or_b32_sdwa v22, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v54
; VI-NEXT:    v_or_b32_sdwa v23, v9, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v53
; VI-NEXT:    v_or_b32_sdwa v24, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v52
; VI-NEXT:    v_or_b32_sdwa v25, v11, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v51
; VI-NEXT:    v_or_b32_sdwa v26, v12, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v50
; VI-NEXT:    v_or_b32_sdwa v27, v13, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, v28
; VI-NEXT:    v_mov_b32_e32 v1, v29
; VI-NEXT:    v_mov_b32_e32 v2, v30
; VI-NEXT:    v_mov_b32_e32 v3, v31
; VI-NEXT:    v_mov_b32_e32 v4, v32
; VI-NEXT:    v_mov_b32_e32 v5, v33
; VI-NEXT:    v_mov_b32_e32 v6, v34
; VI-NEXT:    v_mov_b32_e32 v7, v35
; VI-NEXT:    v_mov_b32_e32 v8, v36
; VI-NEXT:    v_mov_b32_e32 v9, v37
; VI-NEXT:    v_mov_b32_e32 v10, v38
; VI-NEXT:    v_mov_b32_e32 v11, v39
; VI-NEXT:    v_mov_b32_e32 v12, v48
; VI-NEXT:    v_mov_b32_e32 v13, v49
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB33_4:
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr47
; VI-NEXT:    ; implicit-def: $vgpr46
; VI-NEXT:    ; implicit-def: $vgpr45
; VI-NEXT:    ; implicit-def: $vgpr44
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    s_branch .LBB33_2
;
; GFX9-LABEL: bitcast_v28f32_to_v56f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GFX9-NEXT:    v_mov_b32_e32 v20, s16
; GFX9-NEXT:    v_mov_b32_e32 v18, s17
; GFX9-NEXT:    v_mov_b32_e32 v17, s18
; GFX9-NEXT:    v_mov_b32_e32 v16, s19
; GFX9-NEXT:    v_mov_b32_e32 v15, s20
; GFX9-NEXT:    v_mov_b32_e32 v26, s21
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v27, s22
; GFX9-NEXT:    v_mov_b32_e32 v25, s23
; GFX9-NEXT:    v_mov_b32_e32 v24, s24
; GFX9-NEXT:    v_mov_b32_e32 v23, s25
; GFX9-NEXT:    v_mov_b32_e32 v22, s26
; GFX9-NEXT:    v_mov_b32_e32 v21, s27
; GFX9-NEXT:    v_mov_b32_e32 v19, s28
; GFX9-NEXT:    v_mov_b32_e32 v14, s29
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    s_cbranch_scc0 .LBB33_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v21
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v22
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v23
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v24
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v27
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v26
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v20
; GFX9-NEXT:    s_cbranch_execnz .LBB33_3
; GFX9-NEXT:  .LBB33_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v21, 1.0, v21
; GFX9-NEXT:    v_add_f32_e32 v22, 1.0, v22
; GFX9-NEXT:    v_add_f32_e32 v23, 1.0, v23
; GFX9-NEXT:    v_add_f32_e32 v24, 1.0, v24
; GFX9-NEXT:    v_add_f32_e32 v25, 1.0, v25
; GFX9-NEXT:    v_add_f32_e32 v27, 1.0, v27
; GFX9-NEXT:    v_add_f32_e32 v26, 1.0, v26
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v20, 1.0, v20
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v52, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v54, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v55, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v42, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v43, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v21
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v22
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v23
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v24
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v27
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v26
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v20
; GFX9-NEXT:  .LBB33_3: ; %end
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX9-NEXT:    v_lshl_or_b32 v32, v32, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v26
; GFX9-NEXT:    v_lshl_or_b32 v33, v33, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v27
; GFX9-NEXT:    v_lshl_or_b32 v34, v34, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v25
; GFX9-NEXT:    v_lshl_or_b32 v35, v35, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v24
; GFX9-NEXT:    v_lshl_or_b32 v36, v36, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v23
; GFX9-NEXT:    v_lshl_or_b32 v37, v37, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v22
; GFX9-NEXT:    v_lshl_or_b32 v38, v38, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v21
; GFX9-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX9-NEXT:    v_lshl_or_b32 v39, v39, 16, v15
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v19
; GFX9-NEXT:    v_lshl_or_b32 v49, v49, 16, v14
; GFX9-NEXT:    v_lshl_or_b32 v14, v47, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v1
; GFX9-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; GFX9-NEXT:    v_lshl_or_b32 v48, v48, 16, v15
; GFX9-NEXT:    v_lshl_or_b32 v15, v46, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v2
; GFX9-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX9-NEXT:    v_lshl_or_b32 v31, v31, 16, v16
; GFX9-NEXT:    v_lshl_or_b32 v16, v45, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v3
; GFX9-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; GFX9-NEXT:    v_lshl_or_b32 v30, v30, 16, v17
; GFX9-NEXT:    v_lshl_or_b32 v17, v44, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v4
; GFX9-NEXT:    v_lshl_or_b32 v29, v29, 16, v18
; GFX9-NEXT:    v_lshl_or_b32 v18, v43, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v5
; GFX9-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; GFX9-NEXT:    v_lshl_or_b32 v19, v42, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v6
; GFX9-NEXT:    v_lshl_or_b32 v28, v28, 16, v20
; GFX9-NEXT:    v_lshl_or_b32 v20, v41, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v7
; GFX9-NEXT:    v_lshl_or_b32 v21, v40, 16, v0
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v8
; GFX9-NEXT:    v_lshl_or_b32 v22, v55, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v9
; GFX9-NEXT:    v_lshl_or_b32 v23, v54, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v10
; GFX9-NEXT:    v_lshl_or_b32 v24, v53, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v11
; GFX9-NEXT:    v_lshl_or_b32 v25, v52, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v12
; GFX9-NEXT:    v_lshl_or_b32 v26, v51, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v13
; GFX9-NEXT:    v_lshl_or_b32 v27, v50, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v28
; GFX9-NEXT:    v_mov_b32_e32 v1, v29
; GFX9-NEXT:    v_mov_b32_e32 v2, v30
; GFX9-NEXT:    v_mov_b32_e32 v3, v31
; GFX9-NEXT:    v_mov_b32_e32 v4, v32
; GFX9-NEXT:    v_mov_b32_e32 v5, v33
; GFX9-NEXT:    v_mov_b32_e32 v6, v34
; GFX9-NEXT:    v_mov_b32_e32 v7, v35
; GFX9-NEXT:    v_mov_b32_e32 v8, v36
; GFX9-NEXT:    v_mov_b32_e32 v9, v37
; GFX9-NEXT:    v_mov_b32_e32 v10, v38
; GFX9-NEXT:    v_mov_b32_e32 v11, v39
; GFX9-NEXT:    v_mov_b32_e32 v12, v48
; GFX9-NEXT:    v_mov_b32_e32 v13, v49
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB33_4:
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    s_branch .LBB33_2
;
; GFX11-LABEL: bitcast_v28f32_to_v56f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v10
; GFX11-NEXT:    v_dual_mov_b32 v28, s0 :: v_dual_mov_b32 v27, s1
; GFX11-NEXT:    v_dual_mov_b32 v26, s2 :: v_dual_mov_b32 v25, s3
; GFX11-NEXT:    v_dual_mov_b32 v24, s16 :: v_dual_mov_b32 v23, s17
; GFX11-NEXT:    v_dual_mov_b32 v22, s18 :: v_dual_mov_b32 v21, s19
; GFX11-NEXT:    v_dual_mov_b32 v20, s20 :: v_dual_mov_b32 v19, s21
; GFX11-NEXT:    v_dual_mov_b32 v18, s22 :: v_dual_mov_b32 v11, s24
; GFX11-NEXT:    v_dual_mov_b32 v12, s23 :: v_dual_mov_b32 v15, s25
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v13, s27
; GFX11-NEXT:    v_dual_mov_b32 v17, s28 :: v_dual_mov_b32 v16, s29
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB33_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    v_lshrrev_b32_e32 v38, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v39, 16, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v48, 16, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v49, 16, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v50, 16, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v51, 16, v4
; GFX11-NEXT:    v_lshrrev_b32_e32 v52, 16, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v53, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v54, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v55, 16, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v64, 16, v16
; GFX11-NEXT:    v_lshrrev_b32_e32 v65, 16, v17
; GFX11-NEXT:    v_lshrrev_b32_e32 v66, 16, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v67, 16, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v68, 16, v15
; GFX11-NEXT:    v_lshrrev_b32_e32 v69, 16, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v70, 16, v12
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v18
; GFX11-NEXT:    v_lshrrev_b32_e32 v29, 16, v19
; GFX11-NEXT:    v_lshrrev_b32_e32 v71, 16, v20
; GFX11-NEXT:    v_lshrrev_b32_e32 v37, 16, v21
; GFX11-NEXT:    v_lshrrev_b32_e32 v36, 16, v22
; GFX11-NEXT:    v_lshrrev_b32_e32 v35, 16, v23
; GFX11-NEXT:    v_lshrrev_b32_e32 v34, 16, v24
; GFX11-NEXT:    v_lshrrev_b32_e32 v33, 16, v25
; GFX11-NEXT:    v_lshrrev_b32_e32 v32, 16, v26
; GFX11-NEXT:    v_lshrrev_b32_e32 v31, 16, v27
; GFX11-NEXT:    v_lshrrev_b32_e32 v30, 16, v28
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB33_3
; GFX11-NEXT:  .LBB33_2: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:    v_dual_add_f32 v16, 1.0, v16 :: v_dual_add_f32 v17, 1.0, v17
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-NEXT:    v_dual_add_f32 v21, 1.0, v21 :: v_dual_add_f32 v22, 1.0, v22
; GFX11-NEXT:    v_dual_add_f32 v23, 1.0, v23 :: v_dual_add_f32 v24, 1.0, v24
; GFX11-NEXT:    v_dual_add_f32 v25, 1.0, v25 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v28, 1.0, v28
; GFX11-NEXT:    v_lshrrev_b32_e32 v38, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v39, 16, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v48, 16, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v49, 16, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v50, 16, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v51, 16, v4
; GFX11-NEXT:    v_lshrrev_b32_e32 v52, 16, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v53, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v54, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v55, 16, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v64, 16, v16
; GFX11-NEXT:    v_lshrrev_b32_e32 v65, 16, v17
; GFX11-NEXT:    v_lshrrev_b32_e32 v66, 16, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v67, 16, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v68, 16, v15
; GFX11-NEXT:    v_lshrrev_b32_e32 v69, 16, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v70, 16, v12
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v18
; GFX11-NEXT:    v_lshrrev_b32_e32 v29, 16, v19
; GFX11-NEXT:    v_lshrrev_b32_e32 v71, 16, v20
; GFX11-NEXT:    v_lshrrev_b32_e32 v37, 16, v21
; GFX11-NEXT:    v_lshrrev_b32_e32 v36, 16, v22
; GFX11-NEXT:    v_lshrrev_b32_e32 v35, 16, v23
; GFX11-NEXT:    v_lshrrev_b32_e32 v34, 16, v24
; GFX11-NEXT:    v_lshrrev_b32_e32 v33, 16, v25
; GFX11-NEXT:    v_lshrrev_b32_e32 v32, 16, v26
; GFX11-NEXT:    v_lshrrev_b32_e32 v31, 16, v27
; GFX11-NEXT:    v_lshrrev_b32_e32 v30, 16, v28
; GFX11-NEXT:  .LBB33_3: ; %end
; GFX11-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; GFX11-NEXT:    v_and_b32_e32 v27, 0xffff, v27
; GFX11-NEXT:    v_and_b32_e32 v25, 0xffff, v25
; GFX11-NEXT:    v_and_b32_e32 v23, 0xffff, v23
; GFX11-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; GFX11-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; GFX11-NEXT:    v_lshl_or_b32 v29, v29, 16, v19
; GFX11-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX11-NEXT:    v_and_b32_e32 v19, 0xffff, v16
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_lshl_or_b32 v31, v31, 16, v27
; GFX11-NEXT:    v_and_b32_e32 v28, 0xffff, v28
; GFX11-NEXT:    v_lshl_or_b32 v33, v33, 16, v25
; GFX11-NEXT:    v_and_b32_e32 v26, 0xffff, v26
; GFX11-NEXT:    v_lshl_or_b32 v35, v35, 16, v23
; GFX11-NEXT:    v_and_b32_e32 v24, 0xffff, v24
; GFX11-NEXT:    v_lshl_or_b32 v37, v37, 16, v21
; GFX11-NEXT:    v_and_b32_e32 v22, 0xffff, v22
; GFX11-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; GFX11-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX11-NEXT:    v_and_b32_e32 v21, 0xffff, v11
; GFX11-NEXT:    v_lshl_or_b32 v10, v10, 16, v18
; GFX11-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-NEXT:    v_and_b32_e32 v18, 0xffff, v13
; GFX11-NEXT:    v_lshl_or_b32 v16, v65, 16, v17
; GFX11-NEXT:    v_lshl_or_b32 v17, v64, 16, v19
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-NEXT:    v_lshl_or_b32 v19, v54, 16, v1
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v6
; GFX11-NEXT:    v_lshl_or_b32 v32, v32, 16, v26
; GFX11-NEXT:    v_lshl_or_b32 v11, v70, 16, v12
; GFX11-NEXT:    v_lshl_or_b32 v12, v69, 16, v21
; GFX11-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX11-NEXT:    v_lshl_or_b32 v13, v68, 16, v15
; GFX11-NEXT:    v_lshl_or_b32 v15, v66, 16, v18
; GFX11-NEXT:    v_lshl_or_b32 v18, v55, 16, v0
; GFX11-NEXT:    v_lshl_or_b32 v21, v52, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v5
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v8
; GFX11-NEXT:    v_mov_b32_e32 v5, v35
; GFX11-NEXT:    v_lshl_or_b32 v34, v34, 16, v24
; GFX11-NEXT:    v_lshl_or_b32 v24, v49, 16, v1
; GFX11-NEXT:    v_mov_b32_e32 v1, v31
; GFX11-NEXT:    v_lshl_or_b32 v30, v30, 16, v28
; GFX11-NEXT:    v_lshl_or_b32 v28, v71, 16, v20
; GFX11-NEXT:    v_lshl_or_b32 v20, v53, 16, v2
; GFX11-NEXT:    v_dual_mov_b32 v7, v37 :: v_dual_and_b32 v2, 0xffff, v7
; GFX11-NEXT:    v_lshl_or_b32 v36, v36, 16, v22
; GFX11-NEXT:    v_lshl_or_b32 v22, v51, 16, v4
; GFX11-NEXT:    v_and_b32_e32 v4, 0xffff, v9
; GFX11-NEXT:    v_lshl_or_b32 v14, v67, 16, v14
; GFX11-NEXT:    v_lshl_or_b32 v23, v50, 16, v0
; GFX11-NEXT:    v_lshl_or_b32 v25, v48, 16, v2
; GFX11-NEXT:    v_lshl_or_b32 v26, v39, 16, v3
; GFX11-NEXT:    v_lshl_or_b32 v27, v38, 16, v4
; GFX11-NEXT:    v_mov_b32_e32 v0, v30
; GFX11-NEXT:    v_dual_mov_b32 v2, v32 :: v_dual_mov_b32 v3, v33
; GFX11-NEXT:    v_mov_b32_e32 v4, v34
; GFX11-NEXT:    v_mov_b32_e32 v6, v36
; GFX11-NEXT:    v_dual_mov_b32 v8, v28 :: v_dual_mov_b32 v9, v29
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB33_4:
; GFX11-NEXT:    ; implicit-def: $vgpr30
; GFX11-NEXT:    ; implicit-def: $vgpr31
; GFX11-NEXT:    ; implicit-def: $vgpr32
; GFX11-NEXT:    ; implicit-def: $vgpr33
; GFX11-NEXT:    ; implicit-def: $vgpr34
; GFX11-NEXT:    ; implicit-def: $vgpr35
; GFX11-NEXT:    ; implicit-def: $vgpr36
; GFX11-NEXT:    ; implicit-def: $vgpr37
; GFX11-NEXT:    ; implicit-def: $vgpr71
; GFX11-NEXT:    ; implicit-def: $vgpr29
; GFX11-NEXT:    ; implicit-def: $vgpr10
; GFX11-NEXT:    ; implicit-def: $vgpr70
; GFX11-NEXT:    ; implicit-def: $vgpr69
; GFX11-NEXT:    ; implicit-def: $vgpr68
; GFX11-NEXT:    ; implicit-def: $vgpr67
; GFX11-NEXT:    ; implicit-def: $vgpr66
; GFX11-NEXT:    ; implicit-def: $vgpr65
; GFX11-NEXT:    ; implicit-def: $vgpr64
; GFX11-NEXT:    ; implicit-def: $vgpr55
; GFX11-NEXT:    ; implicit-def: $vgpr54
; GFX11-NEXT:    ; implicit-def: $vgpr53
; GFX11-NEXT:    ; implicit-def: $vgpr52
; GFX11-NEXT:    ; implicit-def: $vgpr51
; GFX11-NEXT:    ; implicit-def: $vgpr50
; GFX11-NEXT:    ; implicit-def: $vgpr49
; GFX11-NEXT:    ; implicit-def: $vgpr48
; GFX11-NEXT:    ; implicit-def: $vgpr39
; GFX11-NEXT:    ; implicit-def: $vgpr38
; GFX11-NEXT:    s_branch .LBB33_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <28 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <28 x float> %a1 to <56 x half>
  br label %end

cmp.false:
  %a3 = bitcast <28 x float> %a to <56 x half>
  br label %end

end:
  %phi = phi <56 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <56 x half> %phi
}

define <28 x float> @bitcast_v56f16_to_v28f32(<56 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v56f16_to_v28f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    v_cvt_f16_f32_e32 v46, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v6
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:8
; SI-NEXT:    s_waitcnt expcnt(5)
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16
; SI-NEXT:    s_waitcnt expcnt(3)
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:24
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:20
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:28
; SI-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:40
; SI-NEXT:    buffer_load_dword v34, off, s[0:3], s32 offset:36
; SI-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:48
; SI-NEXT:    buffer_load_dword v36, off, s[0:3], s32 offset:44
; SI-NEXT:    buffer_load_dword v37, off, s[0:3], s32 offset:56
; SI-NEXT:    buffer_load_dword v38, off, s[0:3], s32 offset:52
; SI-NEXT:    buffer_load_dword v39, off, s[0:3], s32 offset:64
; SI-NEXT:    buffer_load_dword v48, off, s[0:3], s32 offset:60
; SI-NEXT:    buffer_load_dword v49, off, s[0:3], s32 offset:72
; SI-NEXT:    buffer_load_dword v50, off, s[0:3], s32 offset:68
; SI-NEXT:    buffer_load_dword v51, off, s[0:3], s32 offset:80
; SI-NEXT:    buffer_load_dword v52, off, s[0:3], s32 offset:76
; SI-NEXT:    buffer_load_dword v53, off, s[0:3], s32 offset:88
; SI-NEXT:    buffer_load_dword v54, off, s[0:3], s32 offset:84
; SI-NEXT:    buffer_load_dword v55, off, s[0:3], s32 offset:96
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:92
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:100
; SI-NEXT:    v_cvt_f16_f32_e32 v47, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v45, v3
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v44, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v43, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v42, v4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v41, v7
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v11
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v10
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v13
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v12
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v15
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v14
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v17
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v16
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v19
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_cvt_f16_f32_e32 v56, v56
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v18
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v21
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v48, v48
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v23
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v22
; SI-NEXT:    s_waitcnt vmcnt(14)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v31
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v25
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v24
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v27
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v26
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v29
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v28
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v30
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v57
; SI-NEXT:    v_cvt_f16_f32_e32 v57, v39
; SI-NEXT:    v_cvt_f16_f32_e32 v39, v49
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v58
; SI-NEXT:    v_cvt_f16_f32_e32 v58, v38
; SI-NEXT:    v_cvt_f16_f32_e32 v38, v50
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v59
; SI-NEXT:    v_cvt_f16_f32_e32 v59, v37
; SI-NEXT:    v_cvt_f16_f32_e32 v37, v51
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v60
; SI-NEXT:    v_cvt_f16_f32_e32 v60, v36
; SI-NEXT:    v_cvt_f16_f32_e32 v36, v52
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v61
; SI-NEXT:    v_cvt_f16_f32_e32 v61, v35
; SI-NEXT:    v_cvt_f16_f32_e32 v35, v53
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v62
; SI-NEXT:    v_cvt_f16_f32_e32 v62, v34
; SI-NEXT:    v_cvt_f16_f32_e32 v34, v54
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v63
; SI-NEXT:    v_cvt_f16_f32_e32 v63, v33
; SI-NEXT:    v_cvt_f16_f32_e32 v33, v55
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e