# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-x280 -iterations=1 < %s | FileCheck %s

# The legal (SEW, LMUL) pairs on sifive-x280 are:
# (e8, mf8) (e8, mf4) (e8, mf2) (e8, m1) (e8, m2) (e8, m4) (e8, m8)
# (e16, mf4) (e16, mf2) (e16, m1) (e16, m2) (e16, m4) (e16, m8)
# (e32, mf2) (e32, m1) (e32, m2) (e32, m4) (e32, m8)
# (e64, m1) (e64, m2) (e64, m4) (e64, m8)
# Widening instructions do not have e64
# Narrowing instructions do not have e8

# Vector Single-Width Integer Add and Subtract
vsetvli zero, zero, e8, mf8, tu, mu
vadd.vv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vadd.vx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vadd.vi v4, v8, 0
vsetvli zero, zero, e8, m1, tu, mu
vsub.vv v4, v8, v12
vsetvli zero, zero, e8, m2, tu, mu
vsub.vx v4, v8, x10
vsetvli zero, zero, e8, m4, tu, mu
vrsub.vx v4, v8, x10
vsetvli zero, zero, e8, m8, tu, mu
vrsub.vi v4, v8, 0
vsetvli zero, zero, e16, mf4, tu, mu
vadd.vv v4, v8, v12
vsetvli zero, zero, e16, mf2, tu, mu
vadd.vx v4, v8, x10
vsetvli zero, zero, e16, m1, tu, mu
vadd.vi v4, v8, 0
vsetvli zero, zero, e16, m2, tu, mu
vsub.vv v4, v8, v12
vsetvli zero, zero, e16, m4, tu, mu
vsub.vx v4, v8, x10
vsetvli zero, zero, e16, m8, tu, mu
vrsub.vx v4, v8, x10
vsetvli zero, zero, e32, mf2, tu, mu
vrsub.vi v4, v8, 0
vsetvli zero, zero, e32, m1, tu, mu
vadd.vv v4, v8, v12
vsetvli zero, zero, e32, m2, tu, mu
vadd.vx v4, v8, x10
vsetvli zero, zero, e32, m4, tu, mu
vadd.vi v4, v8, 0
vsetvli zero, zero, e32, m8, tu, mu
vsub.vv v4, v8, v12
vsetvli zero, zero, e64, m1, tu, mu
vsub.vx v4, v8, x10
vsetvli zero, zero, e64, m2, tu, mu
vrsub.vx v4, v8, x10
vsetvli zero, zero, e64, m4, tu, mu
vrsub.vi v4, v8, 0
vsetvli zero, zero, e64, m8, tu, mu
vadd.vv v4, v8, v12

# Vector Widening Integer Add/Subtract
# no e64
vsetvli zero, zero, e8, mf8, tu, mu
vwaddu.vv  v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vwaddu.vx  v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vwsubu.vv  v4, v8, v12
vsetvli zero, zero, e8, m1, tu, mu
vwsubu.vx  v4, v8, x10
vsetvli zero, zero, e8, m2, tu, mu
vwadd.vv  v4, v8, v12
vsetvli zero, zero, e8, m4, tu, mu
vwadd.vx  v4, v8, x10
vsetvli zero, zero, e8, m8, tu, mu
vwsub.vv  v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vwsub.vx  v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vwaddu.wv  v4, v8, v12
vsetvli zero, zero, e16, m1, tu, mu
vwaddu.wx  v4, v8, x10
vsetvli zero, zero, e16, m2, tu, mu
vwsubu.wv  v4, v8, v12
vsetvli zero, zero, e16, m4, tu, mu
vwsubu.wx  v4, v8, x10
vsetvli zero, zero, e16, m8, tu, mu
vwadd.wv  v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vwadd.wx  v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vwsub.wv  v4, v8, v12
vsetvli zero, zero, e32, m2, tu, mu
vwsub.wx  v4, v8, x10
vsetvli zero, zero, e32, m4, tu, mu
vwaddu.vv  v4, v8, v12
vsetvli zero, zero, e32, m8, tu, mu
vwaddu.vx  v4, v8, x10

# Vector Integer Extension
# no e8
vsetvli zero, zero, e16, mf4, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vsetvli zero, zero, e16, mf2, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vsetvli zero, zero, e16, m1, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vsetvli zero, zero, e16, m2, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vsetvli zero, zero, e16, m4, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vsetvli zero, zero, e16, m8, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vsetvli zero, zero, e32, mf2, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vsetvli zero, zero, e32, m1, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vsetvli zero, zero, e32, m2, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vsetvli zero, zero, e32, m4, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vsetvli zero, zero, e32, m8, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vsetvli zero, zero, e64, m1, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vzext.vf8 v4, v8
vsext.vf8 v4, v8
vsetvli zero, zero, e64, m2, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vzext.vf8 v4, v8
vsext.vf8 v4, v8
vsetvli zero, zero, e64, m4, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vzext.vf8 v4, v8
vsext.vf8 v4, v8
vsetvli zero, zero, e64, m8, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vzext.vf8 v4, v8
vsext.vf8 v4, v8

# Vector Integer Add-with-Carry / Subtract-with-Borrow Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vadc.vvm   v4, v8, v12, v0
vsetvli zero, zero, e8, mf4, tu, mu
vadc.vxm   v4, v8, x10, v0
vsetvli zero, zero, e8, mf2, tu, mu
vadc.vim   v4, v8, 0, v0
vsetvli zero, zero, e8, m1, tu, mu
vmadc.vvm   v4, v8, v12, v0
vsetvli zero, zero, e8, m2, tu, mu
vmadc.vxm   v4, v8, x10, v0
vsetvli zero, zero, e8, m4, tu, mu
vmadc.vim   v4, v8, 0, v0
vsetvli zero, zero, e8, m8, tu, mu
vmadc.vv    v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vmadc.vx    v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vmadc.vi    v4, v8, 0
vsetvli zero, zero, e16, m1, tu, mu
vsbc.vvm   v4, v8, v12, v0
vsetvli zero, zero, e16, m2, tu, mu
vsbc.vxm   v4, v8, x10, v0
vsetvli zero, zero, e16, m4, tu, mu
vmsbc.vvm   v4, v8, v12, v0
vsetvli zero, zero, e16, m8, tu, mu
vmsbc.vxm   v4, v8, x10, v0
vsetvli zero, zero, e32, mf2, tu, mu
vmsbc.vv    v4, v8, v12
vsetvli zero, zero, e32, m1, tu, mu
vmsbc.vx    v4, v8, x10
vsetvli zero, zero, e32, m2, tu, mu
vadc.vvm   v4, v8, v12, v0
vsetvli zero, zero, e32, m4, tu, mu
vadc.vxm   v4, v8, x10, v0
vsetvli zero, zero, e32, m8, tu, mu
vadc.vim   v4, v8, 0, v0
vsetvli zero, zero, e64, m1, tu, mu
vmadc.vvm   v4, v8, v12, v0
vsetvli zero, zero, e64, m2, tu, mu
vmadc.vxm   v4, v8, x10, v0
vsetvli zero, zero, e64, m4, tu, mu
vmadc.vim   v4, v8, 0, v0
vsetvli zero, zero, e64, m8, tu, mu
vmadc.vv    v4, v8, v12

# Vector Bitwise Logical Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vand.vv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vand.vx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vand.vi v4, v8, 0
vsetvli zero, zero, e8, m1, tu, mu
vor.vv v4, v8, v12
vsetvli zero, zero, e8, m2, tu, mu
vor.vx v4, v8, x10
vsetvli zero, zero, e8, m4, tu, mu
vor.vi v4, v8, 0
vsetvli zero, zero, e8, m8, tu, mu
vxor.vv v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vxor.vx v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vxor.vi v4, v8, 0
vsetvli zero, zero, e16, m1, tu, mu
vand.vv v4, v8, v12
vsetvli zero, zero, e16, m2, tu, mu
vand.vx v4, v8, x10
vsetvli zero, zero, e16, m4, tu, mu
vand.vi v4, v8, 0
vsetvli zero, zero, e16, m8, tu, mu
vor.vv v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vor.vx v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vor.vi v4, v8, 0
vsetvli zero, zero, e32, m2, tu, mu
vxor.vv v4, v8, v12
vsetvli zero, zero, e32, m4, tu, mu
vxor.vx v4, v8, x10
vsetvli zero, zero, e32, m8, tu, mu
vxor.vi v4, v8, 0
vsetvli zero, zero, e64, m1, tu, mu
vand.vv v4, v8, v12
vsetvli zero, zero, e64, m2, tu, mu
vand.vx v4, v8, x10
vsetvli zero, zero, e64, m4, tu, mu
vand.vi v4, v8, 0
vsetvli zero, zero, e64, m8, tu, mu
vor.vv v4, v8, v12

# Vector Single-Width Shift Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vsll.vv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vsll.vx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vsll.vi v4, v8, 0
vsetvli zero, zero, e8, m1, tu, mu
vsrl.vv v4, v8, v12
vsetvli zero, zero, e8, m2, tu, mu
vsrl.vx v4, v8, x10
vsetvli zero, zero, e8, m4, tu, mu
vsrl.vi v4, v8, 0
vsetvli zero, zero, e8, m8, tu, mu
vsra.vv v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vsra.vx v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vsra.vi v4, v8, 0
vsetvli zero, zero, e16, m1, tu, mu
vsll.vv v4, v8, v12
vsetvli zero, zero, e16, m2, tu, mu
vsll.vx v4, v8, x10
vsetvli zero, zero, e16, m4, tu, mu
vsll.vi v4, v8, 0
vsetvli zero, zero, e16, m8, tu, mu
vsrl.vv v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vsrl.vx v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vsrl.vi v4, v8, 0
vsetvli zero, zero, e32, m2, tu, mu
vsra.vv v4, v8, v12
vsetvli zero, zero, e32, m4, tu, mu
vsra.vx v4, v8, x10
vsetvli zero, zero, e32, m8, tu, mu
vsra.vi v4, v8, 0
vsetvli zero, zero, e64, m1, tu, mu
vsll.vv v4, v8, v12
vsetvli zero, zero, e64, m2, tu, mu
vsll.vx v4, v8, x10
vsetvli zero, zero, e64, m4, tu, mu
vsll.vi v4, v8, 0
vsetvli zero, zero, e64, m8, tu, mu
vsrl.vv v4, v8, v12

# Vector Narrowing Integer Right Shift Instructions
# no e8
vsetvli zero, zero, e8, mf8, tu, mu
vnsrl.wv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vnsrl.wx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vnsrl.wi v4, v8, 0
vsetvli zero, zero, e8, m1, tu, mu
vnsra.wv v4, v8, v12
vsetvli zero, zero, e8, m2, tu, mu
vnsra.wx v4, v8, x10
vsetvli zero, zero, e8, m4, tu, mu
vnsra.wi v4, v8, 0
vsetvli zero, zero, e8, m8, tu, mu
vnsrl.wv v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vnsrl.wx v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vnsrl.wi v4, v8, 0
vsetvli zero, zero, e16, m1, tu, mu
vnsra.wv v4, v8, v12
vsetvli zero, zero, e16, m2, tu, mu
vnsra.wx v4, v8, x10
vsetvli zero, zero, e16, m4, tu, mu
vnsra.wi v4, v8, 0
vsetvli zero, zero, e16, m8, tu, mu
vnsrl.wv v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vnsrl.wx v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vnsrl.wi v4, v8, 0
vsetvli zero, zero, e32, m2, tu, mu
vnsra.wv v4, v8, v12
vsetvli zero, zero, e32, m4, tu, mu
vnsra.wx v4, v8, x10
vsetvli zero, zero, e32, m8, tu, mu
vnsra.wi v4, v8, 0
vsetvli zero, zero, e64, m1, tu, mu
vnsrl.wv v4, v8, v12
vsetvli zero, zero, e64, m2, tu, mu
vnsrl.wx v4, v8, x10
vsetvli zero, zero, e64, m4, tu, mu
vnsrl.wi v4, v8, 0
vsetvli zero, zero, e64, m8, tu, mu
vnsra.wv v4, v8, v12

# Vector Integer Compare Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vmseq.vv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vmseq.vx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vmseq.vi v4, v8, 0
vsetvli zero, zero, e8, m1, tu, mu
vmsne.vv v4, v8, v12
vsetvli zero, zero, e8, m2, tu, mu
vmsne.vx v4, v8, x10
vsetvli zero, zero, e8, m4, tu, mu
vmsne.vi v4, v8, 0
vsetvli zero, zero, e8, m8, tu, mu
vmsltu.vv v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vmsltu.vx v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vmslt.vv v4, v8, v12
vsetvli zero, zero, e16, m1, tu, mu
vmslt.vx v4, v8, x10
vsetvli zero, zero, e16, m2, tu, mu
vmsleu.vv v4, v8, v12
vsetvli zero, zero, e16, m4, tu, mu
vmsleu.vx v4, v8, x10
vsetvli zero, zero, e16, m8, tu, mu
vmsleu.vi v4, v8, 0
vsetvli zero, zero, e32, mf2, tu, mu
vmsle.vv v4, v8, v12
vsetvli zero, zero, e32, m1, tu, mu
vmsle.vx v4, v8, x10
vsetvli zero, zero, e32, m2, tu, mu
vmsle.vi v4, v8, 0
vsetvli zero, zero, e32, m4, tu, mu
vmsgtu.vx v4, v8, x10
vsetvli zero, zero, e32, m8, tu, mu
vmsgtu.vi v4, v8, 0
vsetvli zero, zero, e64, m1, tu, mu
vmsgt.vx v4, v8, x10
vsetvli zero, zero, e64, m2, tu, mu
vmsgt.vi v4, v8, 0
vsetvli zero, zero, e64, m4, tu, mu
vmseq.vv v4, v8, v12
vsetvli zero, zero, e64, m8, tu, mu
vmseq.vx v4, v8, x10

# Pseudo instructions
vsetvli zero, zero, e8, mf8, tu, mu
vmslt.vi v4, v8, 1
vsetvli zero, zero, e8, mf4, tu, mu
vmsltu.vi v4, v8, 1
vsetvli zero, zero, e8, mf2, tu, mu
vmsltu.vi v4, v8, 0
vsetvli zero, zero, e8, m1, tu, mu
vmsgeu.vi v4, v8, 1
vsetvli zero, zero, e8, m2, tu, mu
vmsge.vi v4, v8, 1
vsetvli zero, zero, e8, m4, tu, mu
vmsgeu.vi v4, v8, 0
vsetvli zero, zero, e16, mf4, tu, mu
vmsge.vi v4, v8, 0
vsetvli zero, zero, e16, mf2, tu, mu
vmsge.vx v4, v8, x10
vsetvli zero, zero, e16, m1, tu, mu
vmsgeu.vx v4, v8, x11

# Vector Integer Min/Max Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vminu.vv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vminu.vx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vmin.vv v4, v8, v12
vsetvli zero, zero, e8, m1, tu, mu
vmin.vx v4, v8, x10
vsetvli zero, zero, e8, m2, tu, mu
vmaxu.vv v4, v8, v12
vsetvli zero, zero, e8, m4, tu, mu
vmaxu.vx v4, v8, x10
vsetvli zero, zero, e8, m8, tu, mu
vmax.vv v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vmax.vx v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vminu.vv v4, v8, v12
vsetvli zero, zero, e16, m1, tu, mu
vminu.vx v4, v8, x10
vsetvli zero, zero, e16, m2, tu, mu
vmin.vv v4, v8, v12
vsetvli zero, zero, e16, m4, tu, mu
vmin.vx v4, v8, x10
vsetvli zero, zero, e16, m8, tu, mu
vmaxu.vv v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vmaxu.vx v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vmax.vv v4, v8, v12
vsetvli zero, zero, e32, m2, tu, mu
vmax.vx v4, v8, x10
vsetvli zero, zero, e32, m4, tu, mu
vminu.vv v4, v8, v12
vsetvli zero, zero, e32, m8, tu, mu
vminu.vx v4, v8, x10
vsetvli zero, zero, e64, m1, tu, mu
vmin.vv v4, v8, v12
vsetvli zero, zero, e64, m2, tu, mu
vmin.vx v4, v8, x10
vsetvli zero, zero, e64, m4, tu, mu
vmaxu.vv v4, v8, v12
vsetvli zero, zero, e64, m8, tu, mu
vmaxu.vx v4, v8, x10

# Vector Single-Width Integer Multiply Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vmul.vv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vmul.vx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vmulh.vv v4, v8, v12
vsetvli zero, zero, e8, m1, tu, mu
vmulh.vx v4, v8, x10
vsetvli zero, zero, e8, m2, tu, mu
vmulhu.vv v4, v8, v12
vsetvli zero, zero, e8, m4, tu, mu
vmulhu.vx v4, v8, x10
vsetvli zero, zero, e8, m8, tu, mu
vmulhsu.vv v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vmulhsu.vx v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vmul.vv v4, v8, v12
vsetvli zero, zero, e16, m1, tu, mu
vmul.vx v4, v8, x10
vsetvli zero, zero, e16, m2, tu, mu
vmulh.vv v4, v8, v12
vsetvli zero, zero, e16, m4, tu, mu
vmulh.vx v4, v8, x10
vsetvli zero, zero, e16, m8, tu, mu
vmulhu.vv v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vmulhu.vx v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vmulhsu.vv v4, v8, v12
vsetvli zero, zero, e32, m2, tu, mu
vmulhsu.vx v4, v8, x10
vsetvli zero, zero, e32, m4, tu, mu
vmul.vv v4, v8, v12
vsetvli zero, zero, e32, m8, tu, mu
vmul.vx v4, v8, x10
vsetvli zero, zero, e64, m1, tu, mu
vmulh.vv v4, v8, v12
vsetvli zero, zero, e64, m2, tu, mu
vmulh.vx v4, v8, x10
vsetvli zero, zero, e64, m4, tu, mu
vmulhu.vv v4, v8, v12
vsetvli zero, zero, e64, m8, tu, mu
vmulhu.vx v4, v8, x10

# Vector Integer Divide Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vdivu.vv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vdivu.vx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vdiv.vv v4, v8, v12
vsetvli zero, zero, e8, m1, tu, mu
vdiv.vx v4, v8, x10
vsetvli zero, zero, e8, m2, tu, mu
vremu.vv v4, v8, v12
vsetvli zero, zero, e8, m4, tu, mu
vremu.vx v4, v8, x10
vsetvli zero, zero, e8, m8, tu, mu
vrem.vv v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vrem.vx v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vdivu.vv v4, v8, v12
vsetvli zero, zero, e16, m1, tu, mu
vdivu.vx v4, v8, x10
vsetvli zero, zero, e16, m2, tu, mu
vdiv.vv v4, v8, v12
vsetvli zero, zero, e16, m4, tu, mu
vdiv.vx v4, v8, x10
vsetvli zero, zero, e16, m8, tu, mu
vremu.vv v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vremu.vx v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vrem.vv v4, v8, v12
vsetvli zero, zero, e32, m2, tu, mu
vrem.vx v4, v8, x10
vsetvli zero, zero, e32, m4, tu, mu
vdivu.vv v4, v8, v12
vsetvli zero, zero, e32, m8, tu, mu
vdivu.vx v4, v8, x10
vsetvli zero, zero, e64, m1, tu, mu
vdiv.vv v4, v8, v12
vsetvli zero, zero, e64, m2, tu, mu
vdiv.vx v4, v8, x10
vsetvli zero, zero, e64, m4, tu, mu
vremu.vv v4, v8, v12
vsetvli zero, zero, e64, m8, tu, mu
vremu.vx v4, v8, x10

# Vector Widening Integer Multiply Instructions
# no e64
vsetvli zero, zero, e8, mf8, tu, mu
vwmul.vv  v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vwmul.vx  v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vwmulu.vv v4, v8, v12
vsetvli zero, zero, e8, m1, tu, mu
vwmulu.vx v4, v8, x10
vsetvli zero, zero, e8, m2, tu, mu
vwmulsu.vv v4, v8, v12
vsetvli zero, zero, e8, m4, tu, mu
vwmulsu.vx v4, v8, x10
vsetvli zero, zero, e8, m8, tu, mu
vwmul.vv  v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vwmul.vx  v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vwmulu.vv v4, v8, v12
vsetvli zero, zero, e16, m1, tu, mu
vwmulu.vx v4, v8, x10
vsetvli zero, zero, e16, m2, tu, mu
vwmulsu.vv v4, v8, v12
vsetvli zero, zero, e16, m4, tu, mu
vwmulsu.vx v4, v8, x10
vsetvli zero, zero, e16, m8, tu, mu
vwmul.vv  v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vwmul.vx  v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vwmulu.vv v4, v8, v12
vsetvli zero, zero, e32, m2, tu, mu
vwmulu.vx v4, v8, x10
vsetvli zero, zero, e32, m4, tu, mu
vwmulsu.vv v4, v8, v12
vsetvli zero, zero, e32, m8, tu, mu
vwmulsu.vx v4, v8, x10

# Vector Single-Width Integer Multiply-Add Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vmacc.vv v4, v12, v8
vsetvli zero, zero, e8, mf4, tu, mu
vmacc.vx v4, x10, v8
vsetvli zero, zero, e8, mf2, tu, mu
vnmsac.vv v4, v12, v8
vsetvli zero, zero, e8, m1, tu, mu
vnmsac.vx v4, x10, v8
vsetvli zero, zero, e8, m2, tu, mu
vmadd.vv v4, v12, v8
vsetvli zero, zero, e8, m4, tu, mu
vmadd.vx v4, x10, v8
vsetvli zero, zero, e8, m8, tu, mu
vnmsub.vv v4, v12, v8
vsetvli zero, zero, e16, mf4, tu, mu
vnmsub.vx v4, x10, v8
vsetvli zero, zero, e16, mf2, tu, mu
vmacc.vv v4, v12, v8
vsetvli zero, zero, e16, m1, tu, mu
vmacc.vx v4, x10, v8
vsetvli zero, zero, e16, m2, tu, mu
vnmsac.vv v4, v12, v8
vsetvli zero, zero, e16, m4, tu, mu
vnmsac.vx v4, x10, v8
vsetvli zero, zero, e16, m8, tu, mu
vmadd.vv v4, v12, v8
vsetvli zero, zero, e32, mf2, tu, mu
vmadd.vx v4, x10, v8
vsetvli zero, zero, e32, m1, tu, mu
vnmsub.vv v4, v12, v8
vsetvli zero, zero, e32, m2, tu, mu
vnmsub.vx v4, x10, v8
vsetvli zero, zero, e32, m4, tu, mu
vmacc.vv v4, v12, v8
vsetvli zero, zero, e32, m8, tu, mu
vmacc.vx v4, x10, v8
vsetvli zero, zero, e64, m1, tu, mu
vnmsac.vv v4, v12, v8
vsetvli zero, zero, e64, m2, tu, mu
vnmsac.vx v4, x10, v8
vsetvli zero, zero, e64, m4, tu, mu
vmadd.vv v4, v12, v8
vsetvli zero, zero, e64, m8, tu, mu
vmadd.vx v4, x10, v8

# Vector Widening Integer Multiply-Add Instructions
# no e64
vsetvli zero, zero, e8, mf8, tu, mu
vwmaccu.vv v4, v12, v8
vsetvli zero, zero, e8, mf4, tu, mu
vwmaccu.vx v4, x10, v8
vsetvli zero, zero, e8, mf2, tu, mu
vwmacc.vv v4, v12, v8
vsetvli zero, zero, e8, m1, tu, mu
vwmacc.vx v4, x10, v8
vsetvli zero, zero, e8, m2, tu, mu
vwmaccsu.vv v4, v12, v8
vsetvli zero, zero, e8, m4, tu, mu
vwmaccsu.vx v4, x10, v8
vsetvli zero, zero, e8, m8, tu, mu
vwmaccus.vx v4, x10, v8
vsetvli zero, zero, e16, mf4, tu, mu
vwmaccu.vv v4, v12, v8
vsetvli zero, zero, e16, mf2, tu, mu
vwmaccu.vx v4, x10, v8
vsetvli zero, zero, e16, m1, tu, mu
vwmacc.vv v4, v12, v8
vsetvli zero, zero, e16, m2, tu, mu
vwmacc.vx v4, x10, v8
vsetvli zero, zero, e16, m4, tu, mu
vwmaccsu.vv v4, v12, v8
vsetvli zero, zero, e16, m8, tu, mu
vwmaccsu.vx v4, x10, v8
vsetvli zero, zero, e32, mf2, tu, mu
vwmaccus.vx v4, x10, v8
vsetvli zero, zero, e32, m1, tu, mu
vwmaccu.vv v4, v12, v8
vsetvli zero, zero, e32, m2, tu, mu
vwmaccu.vx v4, x10, v8
vsetvli zero, zero, e32, m4, tu, mu
vwmacc.vv v4, v12, v8
vsetvli zero, zero, e32, m8, tu, mu
vwmacc.vx v4, x10, v8

# Vector Integer Merge Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vmerge.vvm v4, v8, v12, v0
vsetvli zero, zero, e8, mf4, tu, mu
vmerge.vxm v4, v8, x10, v0
vsetvli zero, zero, e8, mf2, tu, mu
vmerge.vim v4, v8, 0, v0
vsetvli zero, zero, e8, m1, tu, mu
vmerge.vvm v4, v8, v12, v0
vsetvli zero, zero, e8, m2, tu, mu
vmerge.vxm v4, v8, x10, v0
vsetvli zero, zero, e8, m4, tu, mu
vmerge.vim v4, v8, 0, v0
vsetvli zero, zero, e8, m8, tu, mu
vmerge.vvm v4, v8, v12, v0
vsetvli zero, zero, e16, mf4, tu, mu
vmerge.vxm v4, v8, x10, v0
vsetvli zero, zero, e16, mf2, tu, mu
vmerge.vim v4, v8, 0, v0
vsetvli zero, zero, e16, m1, tu, mu
vmerge.vvm v4, v8, v12, v0
vsetvli zero, zero, e16, m2, tu, mu
vmerge.vxm v4, v8, x10, v0
vsetvli zero, zero, e16, m4, tu, mu
vmerge.vim v4, v8, 0, v0
vsetvli zero, zero, e16, m8, tu, mu
vmerge.vvm v4, v8, v12, v0
vsetvli zero, zero, e32, mf2, tu, mu
vmerge.vxm v4, v8, x10, v0
vsetvli zero, zero, e32, m1, tu, mu
vmerge.vim v4, v8, 0, v0
vsetvli zero, zero, e32, m2, tu, mu
vmerge.vvm v4, v8, v12, v0
vsetvli zero, zero, e32, m4, tu, mu
vmerge.vxm v4, v8, x10, v0
vsetvli zero, zero, e32, m8, tu, mu
vmerge.vim v4, v8, 0, v0
vsetvli zero, zero, e64, m1, tu, mu
vmerge.vvm v4, v8, v12, v0
vsetvli zero, zero, e64, m2, tu, mu
vmerge.vxm v4, v8, x10, v0
vsetvli zero, zero, e64, m4, tu, mu
vmerge.vim v4, v8, 0, v0
vsetvli zero, zero, e64, m8, tu, mu
vmerge.vvm v4, v8, v12, v0

# Vector Integer Move Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vmv.v.v v4, v12
vsetvli zero, zero, e8, mf4, tu, mu
vmv.v.x v4, x10
vsetvli zero, zero, e8, mf2, tu, mu
vmv.v.i v4, 0
vsetvli zero, zero, e8, m1, tu, mu
vmv.v.v v4, v12
vsetvli zero, zero, e8, m2, tu, mu
vmv.v.x v4, x10
vsetvli zero, zero, e8, m4, tu, mu
vmv.v.i v4, 0
vsetvli zero, zero, e8, m8, tu, mu
vmv.v.v v4, v12
vsetvli zero, zero, e16, mf4, tu, mu
vmv.v.x v4, x10
vsetvli zero, zero, e16, mf2, tu, mu
vmv.v.i v4, 0
vsetvli zero, zero, e16, m1, tu, mu
vmv.v.v v4, v12
vsetvli zero, zero, e16, m2, tu, mu
vmv.v.x v4, x10
vsetvli zero, zero, e16, m4, tu, mu
vmv.v.i v4, 0
vsetvli zero, zero, e16, m8, tu, mu
vmv.v.v v4, v12
vsetvli zero, zero, e32, mf2, tu, mu
vmv.v.x v4, x10
vsetvli zero, zero, e32, m1, tu, mu
vmv.v.i v4, 0
vsetvli zero, zero, e32, m2, tu, mu
vmv.v.v v4, v12
vsetvli zero, zero, e32, m4, tu, mu
vmv.v.x v4, x10
vsetvli zero, zero, e32, m8, tu, mu
vmv.v.i v4, 0
vsetvli zero, zero, e64, m1, tu, mu
vmv.v.v v4, v12
vsetvli zero, zero, e64, m2, tu, mu
vmv.v.x v4, x10
vsetvli zero, zero, e64, m4, tu, mu
vmv.v.i v4, 0
vsetvli zero, zero, e64, m8, tu, mu
vmv.v.v v4, v12

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      727
# CHECK-NEXT: Total Cycles:      12174
# CHECK-NEXT: Total uOps:        727

# CHECK:      Dispatch Width:    2
# CHECK-NEXT: uOps Per Cycle:    0.06
# CHECK-NEXT: IPC:               0.06
# CHECK-NEXT: Block RThroughput: 11583.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                        vadd.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vadd.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vadd.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vsub.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vsub.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vrsub.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vrsub.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vadd.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vadd.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vadd.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vsub.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vsub.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vrsub.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vrsub.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vadd.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vadd.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vadd.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vsub.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vsub.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vrsub.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vrsub.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vadd.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwaddu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwaddu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwsubu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vwsubu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vwadd.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwadd.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwsub.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwsub.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwaddu.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vwaddu.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vwsubu.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwsubu.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwadd.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwadd.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vwsub.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vwsub.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwaddu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwaddu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     1.00                        vsext.vf2	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     1.00                        vsext.vf2	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     2.00                        vsext.vf2	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     4.00                        vsext.vf2	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     8.00                        vsext.vf2	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     16.00                       vsext.vf2	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     1.00                        vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     1.00                        vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     1.00                        vsext.vf4	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     2.00                        vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     2.00                        vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     2.00                        vsext.vf4	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     4.00                        vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     4.00                        vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     4.00                        vsext.vf4	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     8.00                        vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     8.00                        vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     8.00                        vsext.vf4	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     16.00                       vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     16.00                       vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     16.00                       vsext.vf4	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     2.00                        vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     2.00                        vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     2.00                        vsext.vf4	v4, v8
# CHECK-NEXT:  1      4     2.00                        vzext.vf8	v4, v8
# CHECK-NEXT:  1      4     2.00                        vsext.vf8	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     4.00                        vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     4.00                        vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     4.00                        vsext.vf4	v4, v8
# CHECK-NEXT:  1      4     4.00                        vzext.vf8	v4, v8
# CHECK-NEXT:  1      4     4.00                        vsext.vf8	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     8.00                        vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     8.00                        vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     8.00                        vsext.vf4	v4, v8
# CHECK-NEXT:  1      4     8.00                        vzext.vf8	v4, v8
# CHECK-NEXT:  1      4     8.00                        vsext.vf8	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     16.00                       vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     16.00                       vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     16.00                       vsext.vf4	v4, v8
# CHECK-NEXT:  1      4     16.00                       vzext.vf8	v4, v8
# CHECK-NEXT:  1      4     16.00                       vsext.vf8	v4, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                        vadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vmadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vmadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vmadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vmadc.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmadc.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmadc.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vsbc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vsbc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vmsbc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vmsbc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmsbc.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vmsbc.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vmadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vmadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vmadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vmadc.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                        vand.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vand.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vand.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vor.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vor.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vor.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vxor.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vxor.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vxor.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vand.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vand.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vand.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vor.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vor.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vor.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vxor.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vxor.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vxor.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vand.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vand.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vand.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vor.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      8     1.00                        vsll.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                        vsll.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vsll.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vsrl.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vsrl.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vsrl.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vsra.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                        vsra.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vsra.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vsll.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vsll.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vsll.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vsrl.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vsrl.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vsrl.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vsra.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vsra.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vsra.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vsll.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vsll.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vsll.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vsrl.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      8     1.00                        vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                        vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      8     2.00                        vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      8     4.00                        vnsra.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      8     8.00                        vnsra.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      8     16.00                       vnsra.wi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                        vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     2.00                        vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     4.00                        vnsra.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     8.00                        vnsra.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     16.00                       vnsra.wi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     2.00                        vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     4.00                        vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     8.00                        vnsra.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     16.00                       vnsra.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vnsra.wi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      8     4.00                        vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      8     8.00                        vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      8     16.00                       vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vnsra.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmseq.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmseq.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmseq.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      5     2.00                        vmsne.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      7     4.00                        vmsne.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      11    8.00                        vmsne.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      19    16.00                       vmsltu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmsltu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmslt.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      5     2.00                        vmslt.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      7     4.00                        vmsleu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      11    8.00                        vmsleu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      19    16.00                       vmsleu.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmsle.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      5     2.00                        vmsle.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      7     4.00                        vmsle.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      11    8.00                        vmsgtu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      19    16.00                       vmsgtu.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      5     2.00                        vmsgt.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      7     4.00                        vmsgt.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      11    8.00                        vmseq.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      19    16.00                       vmseq.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmsle.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmsleu.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmsne.vv	v4, v8, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      5     2.00                        vmsgtu.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      7     4.00                        vmsgt.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      11    8.00                        vmseq.vv	v4, v8, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmsgt.vi	v4, v8, -1
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmslt.vx	v4, v8, a0
# CHECK-NEXT:  1      4     1.00                        vmnot.m	v4, v4
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      5     2.00                        vmsltu.vx	v4, v8, a1
# CHECK-NEXT:  1      4     1.00                        vmnot.m	v4, v4
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                        vminu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vminu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmin.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vmin.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vmaxu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vmaxu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vmax.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmax.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vminu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vminu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vmin.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vmin.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vmaxu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmaxu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vmax.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vmax.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vminu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vminu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vmin.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vmin.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vmaxu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vmaxu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      8     1.00                        vmul.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                        vmul.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vmulh.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vmulh.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vmulhu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vmulhu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vmulhsu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                        vmulhsu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vmul.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vmul.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vmulh.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vmulh.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vmulhu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vmulhu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vmulhsu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vmulhsu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vmul.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vmul.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vmulh.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vmulh.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vmulhu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vmulhu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      30    30.00                       vdivu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      60    60.00                       vdivu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      120   120.00                      vdiv.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      240   240.00                      vdiv.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      480   480.00                      vremu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      960   960.00                      vremu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      1920  1920.00                     vrem.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      30    30.00                       vrem.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      60    60.00                       vdivu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      120   120.00                      vdivu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      240   240.00                      vdiv.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      480   480.00                      vdiv.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      960   960.00                      vremu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      56    56.00                       vremu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      112   112.00                      vrem.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      224   224.00                      vrem.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      448   448.00                      vdivu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      896   896.00                      vdivu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      114   114.00                      vdiv.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      228   228.00                      vdiv.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      456   456.00                      vremu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      912   912.00                      vremu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwmul.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwmul.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwmulu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vwmulu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vwmulsu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwmulsu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwmul.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwmul.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwmulu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vwmulu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vwmulsu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwmulsu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwmul.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwmul.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vwmulu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vwmulu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwmulsu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwmulsu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      8     1.00                        vmacc.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                        vmacc.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vnmsac.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vnmsac.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vmadd.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vmadd.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vnmsub.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                        vnmsub.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vmacc.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vmacc.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vnmsac.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vnmsac.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vmadd.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vmadd.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vnmsub.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vnmsub.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vmacc.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vmacc.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vnmsac.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vnmsac.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vmadd.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      8     16.00                       vmadd.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwmaccu.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwmaccu.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwmacc.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vwmacc.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vwmaccsu.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwmaccsu.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwmaccus.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwmaccu.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwmaccu.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vwmacc.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vwmacc.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwmaccsu.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwmaccsu.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                        vwmaccus.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                        vwmaccu.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                        vwmaccu.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwmacc.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                        vwmacc.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmv.v.v	v4, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmv.v.x	v4, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmv.v.i	v4, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vmv.v.v	v4, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vmv.v.x	v4, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vmv.v.i	v4, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vmv.v.v	v4, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmv.v.x	v4, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmv.v.i	v4, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vmv.v.v	v4, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vmv.v.x	v4, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vmv.v.i	v4, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vmv.v.v	v4, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                        vmv.v.x	v4, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vmv.v.i	v4, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vmv.v.v	v4, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vmv.v.x	v4, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vmv.v.i	v4, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                        vmv.v.v	v4, v12
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                        vmv.v.x	v4, a0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                        vmv.v.i	v4, 0
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                       vmv.v.v	v4, v12

# CHECK:      Resources:
# CHECK-NEXT: [0]   - VLEN512SiFive7FDiv
# CHECK-NEXT: [1]   - VLEN512SiFive7IDiv
# CHECK-NEXT: [2]   - VLEN512SiFive7PipeA
# CHECK-NEXT: [3]   - VLEN512SiFive7PipeB
# CHECK-NEXT: [4]   - VLEN512SiFive7VA
# CHECK-NEXT: [5]   - VLEN512SiFive7VCQ
# CHECK-NEXT: [6]   - VLEN512SiFive7VL
# CHECK-NEXT: [7]   - VLEN512SiFive7VS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# CHECK-NEXT:  -      -     342.00  -     11583.00 385.00  -    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    Instructions:
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vadd.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vadd.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vadd.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vsub.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vsub.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vrsub.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vrsub.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vadd.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vadd.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vadd.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vsub.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vsub.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vrsub.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vrsub.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vadd.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vadd.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vadd.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vsub.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vsub.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vrsub.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vrsub.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vadd.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwaddu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwaddu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwsubu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vwsubu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vwadd.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwadd.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwsub.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwsub.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwaddu.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vwaddu.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vwsubu.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwsubu.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwadd.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwadd.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vwsub.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vwsub.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwaddu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwaddu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vzext.vf8	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vsext.vf8	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vzext.vf8	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vsext.vf8	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vzext.vf8	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vsext.vf8	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vzext.vf8	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vsext.vf8	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmadc.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmadc.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmadc.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vsbc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vsbc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmsbc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmsbc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmsbc.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmsbc.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmadc.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vand.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vand.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vand.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vor.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vor.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vor.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vxor.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vxor.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vxor.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vand.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vand.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vand.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vor.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vor.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vor.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vxor.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vxor.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vxor.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vand.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vand.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vand.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vor.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vsll.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vsll.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vsll.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vsrl.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vsrl.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vsrl.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vsra.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vsra.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vsra.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vsll.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vsll.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vsll.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vsrl.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vsrl.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vsrl.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vsra.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vsra.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vsra.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vsll.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vsll.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vsll.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vsrl.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vnsra.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vnsra.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vnsra.wi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vnsra.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vnsra.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vnsra.wi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vnsra.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vnsra.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vnsra.wi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vnsra.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmseq.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmseq.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmseq.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmsne.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmsne.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmsne.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmsltu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmsltu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmslt.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmslt.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmsleu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmsleu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmsleu.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmsle.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmsle.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmsle.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmsgtu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmsgtu.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmsgt.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmsgt.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmseq.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmseq.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmsle.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmsleu.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmsne.vv	v4, v8, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmsgtu.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmsgt.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmseq.vv	v4, v8, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmsgt.vi	v4, v8, -1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmslt.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmnot.m	v4, v4
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmsltu.vx	v4, v8, a1
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmnot.m	v4, v4
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vminu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vminu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmin.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmin.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmaxu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmaxu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmax.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmax.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vminu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vminu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmin.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmin.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmaxu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmaxu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmax.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmax.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vminu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vminu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmin.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmin.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmaxu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmaxu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmul.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmul.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmulh.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmulh.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmulhu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmulhu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmulhsu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmulhsu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmul.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmul.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmulh.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmulh.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmulhu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmulhu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmulhsu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmulhsu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmul.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmul.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmulh.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmulh.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmulhu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmulhu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     31.00  1.00    -      -     vdivu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     61.00  1.00    -      -     vdivu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     121.00 1.00    -      -     vdiv.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     241.00 1.00    -      -     vdiv.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     481.00 1.00    -      -     vremu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     961.00 1.00    -      -     vremu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     1921.00 1.00   -      -     vrem.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     31.00  1.00    -      -     vrem.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     61.00  1.00    -      -     vdivu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     121.00 1.00    -      -     vdivu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     241.00 1.00    -      -     vdiv.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     481.00 1.00    -      -     vdiv.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     961.00 1.00    -      -     vremu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     57.00  1.00    -      -     vremu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     113.00 1.00    -      -     vrem.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     225.00 1.00    -      -     vrem.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     449.00 1.00    -      -     vdivu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     897.00 1.00    -      -     vdivu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     115.00 1.00    -      -     vdiv.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     229.00 1.00    -      -     vdiv.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     457.00 1.00    -      -     vremu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     913.00 1.00    -      -     vremu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwmul.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwmul.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwmulu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vwmulu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vwmulsu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwmulsu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwmul.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwmul.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwmulu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vwmulu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vwmulsu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwmulsu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwmul.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwmul.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vwmulu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vwmulu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwmulsu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwmulsu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmacc.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmacc.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vnmsac.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vnmsac.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmadd.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmadd.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vnmsub.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vnmsub.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmacc.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmacc.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vnmsac.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vnmsac.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmadd.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmadd.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vnmsub.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vnmsub.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmacc.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmacc.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vnmsac.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vnmsac.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmadd.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmadd.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwmaccu.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwmaccu.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwmacc.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vwmacc.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vwmaccsu.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwmaccsu.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwmaccus.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwmaccu.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwmaccu.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vwmacc.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vwmacc.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwmaccsu.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwmaccsu.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vwmaccus.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vwmaccu.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vwmaccu.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwmacc.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vwmacc.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmv.v.v	v4, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmv.v.x	v4, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmv.v.i	v4, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmv.v.v	v4, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmv.v.x	v4, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmv.v.i	v4, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmv.v.v	v4, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmv.v.x	v4, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmv.v.i	v4, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmv.v.v	v4, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmv.v.x	v4, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmv.v.i	v4, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmv.v.v	v4, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00   1.00    -      -     vmv.v.x	v4, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmv.v.i	v4, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmv.v.v	v4, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmv.v.x	v4, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmv.v.i	v4, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00   1.00    -      -     vmv.v.v	v4, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00   1.00    -      -     vmv.v.x	v4, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00   1.00    -      -     vmv.v.i	v4, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00  1.00    -      -     vmv.v.v	v4, v12
