// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemakeredgemanager

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opGetDeployments = "GetDeployments"

// GetDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the GetDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeployments for more information on using the GetDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDeploymentsRequest method.
//	req, resp := client.GetDeploymentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-edge-2020-09-23/GetDeployments
func (c *SagemakerEdgeManager) GetDeploymentsRequest(input *GetDeploymentsInput) (req *request.Request, output *GetDeploymentsOutput) {
	op := &request.Operation{
		Name:       opGetDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/GetDeployments",
	}

	if input == nil {
		input = &GetDeploymentsInput{}
	}

	output = &GetDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeployments API operation for Amazon Sagemaker Edge Manager.
//
// Use to get the active deployments from a device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Sagemaker Edge Manager's
// API operation GetDeployments for usage and error information.
//
// Returned Error Types:
//   - InternalServiceException
//     An internal failure occurred. Try your request again. If the problem persists,
//     contact Amazon Web Services customer support.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-edge-2020-09-23/GetDeployments
func (c *SagemakerEdgeManager) GetDeployments(input *GetDeploymentsInput) (*GetDeploymentsOutput, error) {
	req, out := c.GetDeploymentsRequest(input)
	return out, req.Send()
}

// GetDeploymentsWithContext is the same as GetDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SagemakerEdgeManager) GetDeploymentsWithContext(ctx aws.Context, input *GetDeploymentsInput, opts ...request.Option) (*GetDeploymentsOutput, error) {
	req, out := c.GetDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeviceRegistration = "GetDeviceRegistration"

// GetDeviceRegistrationRequest generates a "aws/request.Request" representing the
// client's request for the GetDeviceRegistration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeviceRegistration for more information on using the GetDeviceRegistration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDeviceRegistrationRequest method.
//	req, resp := client.GetDeviceRegistrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-edge-2020-09-23/GetDeviceRegistration
func (c *SagemakerEdgeManager) GetDeviceRegistrationRequest(input *GetDeviceRegistrationInput) (req *request.Request, output *GetDeviceRegistrationOutput) {
	op := &request.Operation{
		Name:       opGetDeviceRegistration,
		HTTPMethod: "POST",
		HTTPPath:   "/GetDeviceRegistration",
	}

	if input == nil {
		input = &GetDeviceRegistrationInput{}
	}

	output = &GetDeviceRegistrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeviceRegistration API operation for Amazon Sagemaker Edge Manager.
//
// Use to check if a device is registered with SageMaker Edge Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Sagemaker Edge Manager's
// API operation GetDeviceRegistration for usage and error information.
//
// Returned Error Types:
//   - InternalServiceException
//     An internal failure occurred. Try your request again. If the problem persists,
//     contact Amazon Web Services customer support.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-edge-2020-09-23/GetDeviceRegistration
func (c *SagemakerEdgeManager) GetDeviceRegistration(input *GetDeviceRegistrationInput) (*GetDeviceRegistrationOutput, error) {
	req, out := c.GetDeviceRegistrationRequest(input)
	return out, req.Send()
}

// GetDeviceRegistrationWithContext is the same as GetDeviceRegistration with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeviceRegistration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SagemakerEdgeManager) GetDeviceRegistrationWithContext(ctx aws.Context, input *GetDeviceRegistrationInput, opts ...request.Option) (*GetDeviceRegistrationOutput, error) {
	req, out := c.GetDeviceRegistrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendHeartbeat = "SendHeartbeat"

// SendHeartbeatRequest generates a "aws/request.Request" representing the
// client's request for the SendHeartbeat operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendHeartbeat for more information on using the SendHeartbeat
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendHeartbeatRequest method.
//	req, resp := client.SendHeartbeatRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-edge-2020-09-23/SendHeartbeat
func (c *SagemakerEdgeManager) SendHeartbeatRequest(input *SendHeartbeatInput) (req *request.Request, output *SendHeartbeatOutput) {
	op := &request.Operation{
		Name:       opSendHeartbeat,
		HTTPMethod: "POST",
		HTTPPath:   "/SendHeartbeat",
	}

	if input == nil {
		input = &SendHeartbeatInput{}
	}

	output = &SendHeartbeatOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendHeartbeat API operation for Amazon Sagemaker Edge Manager.
//
// Use to get the current status of devices registered on SageMaker Edge Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Sagemaker Edge Manager's
// API operation SendHeartbeat for usage and error information.
//
// Returned Error Types:
//   - InternalServiceException
//     An internal failure occurred. Try your request again. If the problem persists,
//     contact Amazon Web Services customer support.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-edge-2020-09-23/SendHeartbeat
func (c *SagemakerEdgeManager) SendHeartbeat(input *SendHeartbeatInput) (*SendHeartbeatOutput, error) {
	req, out := c.SendHeartbeatRequest(input)
	return out, req.Send()
}

// SendHeartbeatWithContext is the same as SendHeartbeat with the addition of
// the ability to pass a context and additional request options.
//
// See SendHeartbeat for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SagemakerEdgeManager) SendHeartbeatWithContext(ctx aws.Context, input *SendHeartbeatInput, opts ...request.Option) (*SendHeartbeatOutput, error) {
	req, out := c.SendHeartbeatRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Information about the checksum of a model deployed on a device.
type Checksum struct {
	_ struct{} `type:"structure"`

	// The checksum of the model.
	Sum *string `min:"1" type:"string"`

	// The type of the checksum.
	Type *string `type:"string" enum:"ChecksumType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Checksum) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Checksum) GoString() string {
	return s.String()
}

// SetSum sets the Sum field's value.
func (s *Checksum) SetSum(v string) *Checksum {
	s.Sum = &v
	return s
}

// SetType sets the Type field's value.
func (s *Checksum) SetType(v string) *Checksum {
	s.Type = &v
	return s
}

type Definition struct {
	_ struct{} `type:"structure"`

	// The checksum information of the model.
	Checksum *Checksum `type:"structure"`

	// The unique model handle.
	ModelHandle *string `min:"1" type:"string"`

	// The absolute S3 location of the model.
	S3Url *string `type:"string"`

	// The desired state of the model.
	State *string `type:"string" enum:"ModelState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Definition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Definition) GoString() string {
	return s.String()
}

// SetChecksum sets the Checksum field's value.
func (s *Definition) SetChecksum(v *Checksum) *Definition {
	s.Checksum = v
	return s
}

// SetModelHandle sets the ModelHandle field's value.
func (s *Definition) SetModelHandle(v string) *Definition {
	s.ModelHandle = &v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *Definition) SetS3Url(v string) *Definition {
	s.S3Url = &v
	return s
}

// SetState sets the State field's value.
func (s *Definition) SetState(v string) *Definition {
	s.State = &v
	return s
}

type DeploymentModel struct {
	_ struct{} `type:"structure"`

	// The desired state of the model.
	DesiredState *string `type:"string" enum:"ModelState"`

	// The unique handle of the model.
	ModelHandle *string `min:"1" type:"string"`

	// The name of the model.
	ModelName *string `min:"4" type:"string"`

	// The version of the model.
	ModelVersion *string `min:"1" type:"string"`

	// Returns the error message if there is a rollback.
	RollbackFailureReason *string `type:"string"`

	// Returns the current state of the model.
	State *string `type:"string" enum:"ModelState"`

	// Returns the deployment status of the model.
	Status *string `type:"string" enum:"DeploymentStatus"`

	// Returns the error message for the deployment status result.
	StatusReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentModel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentModel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeploymentModel"}
	if s.ModelHandle != nil && len(*s.ModelHandle) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelHandle", 1))
	}
	if s.ModelName != nil && len(*s.ModelName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 4))
	}
	if s.ModelVersion != nil && len(*s.ModelVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredState sets the DesiredState field's value.
func (s *DeploymentModel) SetDesiredState(v string) *DeploymentModel {
	s.DesiredState = &v
	return s
}

// SetModelHandle sets the ModelHandle field's value.
func (s *DeploymentModel) SetModelHandle(v string) *DeploymentModel {
	s.ModelHandle = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *DeploymentModel) SetModelName(v string) *DeploymentModel {
	s.ModelName = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *DeploymentModel) SetModelVersion(v string) *DeploymentModel {
	s.ModelVersion = &v
	return s
}

// SetRollbackFailureReason sets the RollbackFailureReason field's value.
func (s *DeploymentModel) SetRollbackFailureReason(v string) *DeploymentModel {
	s.RollbackFailureReason = &v
	return s
}

// SetState sets the State field's value.
func (s *DeploymentModel) SetState(v string) *DeploymentModel {
	s.State = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeploymentModel) SetStatus(v string) *DeploymentModel {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DeploymentModel) SetStatusReason(v string) *DeploymentModel {
	s.StatusReason = &v
	return s
}

// Information about the result of a deployment on an edge device that is registered
// with SageMaker Edge Manager.
type DeploymentResult struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the deployment was ended, and the agent got the deployment
	// results.
	DeploymentEndTime *time.Time `type:"timestamp"`

	// Returns a list of models deployed on the agent.
	DeploymentModels []*DeploymentModel `type:"list"`

	// The name and unique ID of the deployment.
	DeploymentName *string `min:"1" type:"string"`

	// The timestamp of when the deployment was started on the agent.
	DeploymentStartTime *time.Time `type:"timestamp"`

	// Returns the bucket error code.
	DeploymentStatus *string `min:"1" type:"string"`

	// Returns the detailed error message.
	DeploymentStatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentResult) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentResult) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeploymentResult"}
	if s.DeploymentName != nil && len(*s.DeploymentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentName", 1))
	}
	if s.DeploymentStatus != nil && len(*s.DeploymentStatus) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentStatus", 1))
	}
	if s.DeploymentModels != nil {
		for i, v := range s.DeploymentModels {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DeploymentModels", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentEndTime sets the DeploymentEndTime field's value.
func (s *DeploymentResult) SetDeploymentEndTime(v time.Time) *DeploymentResult {
	s.DeploymentEndTime = &v
	return s
}

// SetDeploymentModels sets the DeploymentModels field's value.
func (s *DeploymentResult) SetDeploymentModels(v []*DeploymentModel) *DeploymentResult {
	s.DeploymentModels = v
	return s
}

// SetDeploymentName sets the DeploymentName field's value.
func (s *DeploymentResult) SetDeploymentName(v string) *DeploymentResult {
	s.DeploymentName = &v
	return s
}

// SetDeploymentStartTime sets the DeploymentStartTime field's value.
func (s *DeploymentResult) SetDeploymentStartTime(v time.Time) *DeploymentResult {
	s.DeploymentStartTime = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *DeploymentResult) SetDeploymentStatus(v string) *DeploymentResult {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentStatusMessage sets the DeploymentStatusMessage field's value.
func (s *DeploymentResult) SetDeploymentStatusMessage(v string) *DeploymentResult {
	s.DeploymentStatusMessage = &v
	return s
}

// Information about a deployment on an edge device that is registered with
// SageMaker Edge Manager.
type EdgeDeployment struct {
	_ struct{} `type:"structure"`

	// Returns a list of Definition objects.
	Definitions []*Definition `type:"list"`

	// The name and unique ID of the deployment.
	DeploymentName *string `min:"1" type:"string"`

	// Determines whether to rollback to previous configuration if deployment fails.
	FailureHandlingPolicy *string `type:"string" enum:"FailureHandlingPolicy"`

	// The type of the deployment.
	Type *string `type:"string" enum:"DeploymentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EdgeDeployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EdgeDeployment) GoString() string {
	return s.String()
}

// SetDefinitions sets the Definitions field's value.
func (s *EdgeDeployment) SetDefinitions(v []*Definition) *EdgeDeployment {
	s.Definitions = v
	return s
}

// SetDeploymentName sets the DeploymentName field's value.
func (s *EdgeDeployment) SetDeploymentName(v string) *EdgeDeployment {
	s.DeploymentName = &v
	return s
}

// SetFailureHandlingPolicy sets the FailureHandlingPolicy field's value.
func (s *EdgeDeployment) SetFailureHandlingPolicy(v string) *EdgeDeployment {
	s.FailureHandlingPolicy = &v
	return s
}

// SetType sets the Type field's value.
func (s *EdgeDeployment) SetType(v string) *EdgeDeployment {
	s.Type = &v
	return s
}

// Information required for edge device metrics.
type EdgeMetric struct {
	_ struct{} `type:"structure"`

	// The dimension of metrics published.
	Dimension *string `min:"1" type:"string"`

	// Returns the name of the metric.
	MetricName *string `min:"4" type:"string"`

	// Timestamp of when the metric was requested.
	Timestamp *time.Time `type:"timestamp"`

	// Returns the value of the metric.
	Value *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EdgeMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EdgeMetric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EdgeMetric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EdgeMetric"}
	if s.Dimension != nil && len(*s.Dimension) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Dimension", 1))
	}
	if s.MetricName != nil && len(*s.MetricName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimension sets the Dimension field's value.
func (s *EdgeMetric) SetDimension(v string) *EdgeMetric {
	s.Dimension = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *EdgeMetric) SetMetricName(v string) *EdgeMetric {
	s.MetricName = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *EdgeMetric) SetTimestamp(v time.Time) *EdgeMetric {
	s.Timestamp = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EdgeMetric) SetValue(v float64) *EdgeMetric {
	s.Value = &v
	return s
}

type GetDeploymentsInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet that the device belongs to.
	//
	// DeviceFleetName is a required field
	DeviceFleetName *string `min:"1" type:"string" required:"true"`

	// The unique name of the device you want to get the configuration of active
	// deployments from.
	//
	// DeviceName is a required field
	DeviceName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentsInput"}
	if s.DeviceFleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceFleetName"))
	}
	if s.DeviceFleetName != nil && len(*s.DeviceFleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceFleetName", 1))
	}
	if s.DeviceName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceName"))
	}
	if s.DeviceName != nil && len(*s.DeviceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceFleetName sets the DeviceFleetName field's value.
func (s *GetDeploymentsInput) SetDeviceFleetName(v string) *GetDeploymentsInput {
	s.DeviceFleetName = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *GetDeploymentsInput) SetDeviceName(v string) *GetDeploymentsInput {
	s.DeviceName = &v
	return s
}

type GetDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of the configurations of the active deployments on the device.
	Deployments []*EdgeDeployment `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentsOutput) GoString() string {
	return s.String()
}

// SetDeployments sets the Deployments field's value.
func (s *GetDeploymentsOutput) SetDeployments(v []*EdgeDeployment) *GetDeploymentsOutput {
	s.Deployments = v
	return s
}

type GetDeviceRegistrationInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet that the device belongs to.
	//
	// DeviceFleetName is a required field
	DeviceFleetName *string `min:"1" type:"string" required:"true"`

	// The unique name of the device you want to get the registration status from.
	//
	// DeviceName is a required field
	DeviceName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceRegistrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceRegistrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceRegistrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceRegistrationInput"}
	if s.DeviceFleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceFleetName"))
	}
	if s.DeviceFleetName != nil && len(*s.DeviceFleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceFleetName", 1))
	}
	if s.DeviceName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceName"))
	}
	if s.DeviceName != nil && len(*s.DeviceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceFleetName sets the DeviceFleetName field's value.
func (s *GetDeviceRegistrationInput) SetDeviceFleetName(v string) *GetDeviceRegistrationInput {
	s.DeviceFleetName = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *GetDeviceRegistrationInput) SetDeviceName(v string) *GetDeviceRegistrationInput {
	s.DeviceName = &v
	return s
}

type GetDeviceRegistrationOutput struct {
	_ struct{} `type:"structure"`

	// The amount of time, in seconds, that the registration status is stored on
	// the device’s cache before it is refreshed.
	CacheTTL *string `min:"1" type:"string"`

	// Describes if the device is currently registered with SageMaker Edge Manager.
	DeviceRegistration *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceRegistrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceRegistrationOutput) GoString() string {
	return s.String()
}

// SetCacheTTL sets the CacheTTL field's value.
func (s *GetDeviceRegistrationOutput) SetCacheTTL(v string) *GetDeviceRegistrationOutput {
	s.CacheTTL = &v
	return s
}

// SetDeviceRegistration sets the DeviceRegistration field's value.
func (s *GetDeviceRegistrationOutput) SetDeviceRegistration(v string) *GetDeviceRegistrationOutput {
	s.DeviceRegistration = &v
	return s
}

// An internal failure occurred. Try your request again. If the problem persists,
// contact Amazon Web Services customer support.
type InternalServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceException) GoString() string {
	return s.String()
}

func newErrorInternalServiceException(v protocol.ResponseMetadata) error {
	return &InternalServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceException) Code() string {
	return "InternalServiceException"
}

// Message returns the exception's message.
func (s *InternalServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceException) OrigErr() error {
	return nil
}

func (s *InternalServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a model deployed on an edge device that is registered with
// SageMaker Edge Manager.
type Model struct {
	_ struct{} `type:"structure"`

	// The timestamp of the last inference that was made.
	LatestInference *time.Time `type:"timestamp"`

	// The timestamp of the last data sample taken.
	LatestSampleTime *time.Time `type:"timestamp"`

	// Information required for model metrics.
	ModelMetrics []*EdgeMetric `type:"list"`

	// The name of the model.
	ModelName *string `min:"4" type:"string"`

	// The version of the model.
	ModelVersion *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Model) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Model) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Model) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Model"}
	if s.ModelName != nil && len(*s.ModelName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 4))
	}
	if s.ModelVersion != nil && len(*s.ModelVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersion", 1))
	}
	if s.ModelMetrics != nil {
		for i, v := range s.ModelMetrics {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ModelMetrics", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLatestInference sets the LatestInference field's value.
func (s *Model) SetLatestInference(v time.Time) *Model {
	s.LatestInference = &v
	return s
}

// SetLatestSampleTime sets the LatestSampleTime field's value.
func (s *Model) SetLatestSampleTime(v time.Time) *Model {
	s.LatestSampleTime = &v
	return s
}

// SetModelMetrics sets the ModelMetrics field's value.
func (s *Model) SetModelMetrics(v []*EdgeMetric) *Model {
	s.ModelMetrics = v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *Model) SetModelName(v string) *Model {
	s.ModelName = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *Model) SetModelVersion(v string) *Model {
	s.ModelVersion = &v
	return s
}

type SendHeartbeatInput struct {
	_ struct{} `type:"structure"`

	// For internal use. Returns a list of SageMaker Edge Manager agent operating
	// metrics.
	AgentMetrics []*EdgeMetric `type:"list"`

	// Returns the version of the agent.
	//
	// AgentVersion is a required field
	AgentVersion *string `min:"1" type:"string" required:"true"`

	// Returns the result of a deployment on the device.
	DeploymentResult *DeploymentResult `type:"structure"`

	// The name of the fleet that the device belongs to.
	//
	// DeviceFleetName is a required field
	DeviceFleetName *string `min:"1" type:"string" required:"true"`

	// The unique name of the device.
	//
	// DeviceName is a required field
	DeviceName *string `min:"1" type:"string" required:"true"`

	// Returns a list of models deployed on the the device.
	Models []*Model `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendHeartbeatInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendHeartbeatInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendHeartbeatInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendHeartbeatInput"}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}
	if s.DeviceFleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceFleetName"))
	}
	if s.DeviceFleetName != nil && len(*s.DeviceFleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceFleetName", 1))
	}
	if s.DeviceName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceName"))
	}
	if s.DeviceName != nil && len(*s.DeviceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceName", 1))
	}
	if s.AgentMetrics != nil {
		for i, v := range s.AgentMetrics {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AgentMetrics", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DeploymentResult != nil {
		if err := s.DeploymentResult.Validate(); err != nil {
			invalidParams.AddNested("DeploymentResult", err.(request.ErrInvalidParams))
		}
	}
	if s.Models != nil {
		for i, v := range s.Models {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Models", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentMetrics sets the AgentMetrics field's value.
func (s *SendHeartbeatInput) SetAgentMetrics(v []*EdgeMetric) *SendHeartbeatInput {
	s.AgentMetrics = v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *SendHeartbeatInput) SetAgentVersion(v string) *SendHeartbeatInput {
	s.AgentVersion = &v
	return s
}

// SetDeploymentResult sets the DeploymentResult field's value.
func (s *SendHeartbeatInput) SetDeploymentResult(v *DeploymentResult) *SendHeartbeatInput {
	s.DeploymentResult = v
	return s
}

// SetDeviceFleetName sets the DeviceFleetName field's value.
func (s *SendHeartbeatInput) SetDeviceFleetName(v string) *SendHeartbeatInput {
	s.DeviceFleetName = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *SendHeartbeatInput) SetDeviceName(v string) *SendHeartbeatInput {
	s.DeviceName = &v
	return s
}

// SetModels sets the Models field's value.
func (s *SendHeartbeatInput) SetModels(v []*Model) *SendHeartbeatInput {
	s.Models = v
	return s
}

type SendHeartbeatOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendHeartbeatOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendHeartbeatOutput) GoString() string {
	return s.String()
}

const (
	// ChecksumTypeSha1 is a ChecksumType enum value
	ChecksumTypeSha1 = "SHA1"
)

// ChecksumType_Values returns all elements of the ChecksumType enum
func ChecksumType_Values() []string {
	return []string{
		ChecksumTypeSha1,
	}
}

const (
	// DeploymentStatusSuccess is a DeploymentStatus enum value
	DeploymentStatusSuccess = "SUCCESS"

	// DeploymentStatusFail is a DeploymentStatus enum value
	DeploymentStatusFail = "FAIL"
)

// DeploymentStatus_Values returns all elements of the DeploymentStatus enum
func DeploymentStatus_Values() []string {
	return []string{
		DeploymentStatusSuccess,
		DeploymentStatusFail,
	}
}

const (
	// DeploymentTypeModel is a DeploymentType enum value
	DeploymentTypeModel = "Model"
)

// DeploymentType_Values returns all elements of the DeploymentType enum
func DeploymentType_Values() []string {
	return []string{
		DeploymentTypeModel,
	}
}

const (
	// FailureHandlingPolicyRollbackOnFailure is a FailureHandlingPolicy enum value
	FailureHandlingPolicyRollbackOnFailure = "ROLLBACK_ON_FAILURE"

	// FailureHandlingPolicyDoNothing is a FailureHandlingPolicy enum value
	FailureHandlingPolicyDoNothing = "DO_NOTHING"
)

// FailureHandlingPolicy_Values returns all elements of the FailureHandlingPolicy enum
func FailureHandlingPolicy_Values() []string {
	return []string{
		FailureHandlingPolicyRollbackOnFailure,
		FailureHandlingPolicyDoNothing,
	}
}

const (
	// ModelStateDeploy is a ModelState enum value
	ModelStateDeploy = "DEPLOY"

	// ModelStateUndeploy is a ModelState enum value
	ModelStateUndeploy = "UNDEPLOY"
)

// ModelState_Values returns all elements of the ModelState enum
func ModelState_Values() []string {
	return []string{
		ModelStateDeploy,
		ModelStateUndeploy,
	}
}
