/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.diff.util;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffLineMarkerRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.jupyter.diff.util.JupyterDiffDrawUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/diff/util/JupyterDiffLineMarkerRenderer;", "Lcom/intellij/diff/util/DiffLineMarkerRenderer;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "diffType", "Lcom/intellij/diff/util/TextDiffType;", "editorMode", "Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;", "gutterMode", "hideWithoutLineNumbers", "", "isEmptyRange", "isFirstLine", "isLastLine", "alignedSides", "<init>", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/intellij/diff/util/TextDiffType;Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;ZZZZZ)V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "range", "Ljava/awt/Rectangle;", "intellij.jupyter.diff"})
public final class JupyterDiffLineMarkerRenderer
extends DiffLineMarkerRenderer {
    public JupyterDiffLineMarkerRenderer(@NotNull RangeHighlighter highlighter, @NotNull TextDiffType diffType, @NotNull DiffDrawUtil.PaintMode editorMode, @NotNull DiffDrawUtil.PaintMode gutterMode, boolean hideWithoutLineNumbers, boolean isEmptyRange, boolean isFirstLine, boolean isLastLine, boolean alignedSides) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)diffType, (String)"diffType");
        Intrinsics.checkNotNullParameter((Object)editorMode, (String)"editorMode");
        Intrinsics.checkNotNullParameter((Object)gutterMode, (String)"gutterMode");
        super(highlighter, diffType, editorMode, gutterMode, hideWithoutLineNumbers, isEmptyRange, isFirstLine, isLastLine, alignedSides, false);
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle range) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        EditorEx cfr_ignored_0 = (EditorEx)editor;
        Graphics2D cfr_ignored_1 = (Graphics2D)g;
        EditorGutterComponentEx editorGutterComponentEx = ((EditorEx)editor).getGutterComponentEx();
        Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
        EditorGutterComponentEx gutter = editorGutterComponentEx;
        int x1 = 0;
        int x2 = gutter.getWidth();
        int startLine = 0;
        int endLine = 0;
        if (this.isEmptyRange()) {
            startLine = this.isLastLine() ? DiffUtil.getLineCount((Document)((Document)((EditorEx)editor).getDocument())) : ((EditorEx)editor).getDocument().getLineNumber(this.getHighlighter().getStartOffset());
            endLine = startLine;
        } else {
            startLine = ((EditorEx)editor).getDocument().getLineNumber(this.getHighlighter().getStartOffset());
            endLine = ((EditorEx)editor).getDocument().getLineNumber(this.getHighlighter().getEndOffset()) + 1;
        }
        DiffDrawUtil.MarkerRange markerRange = JupyterDiffDrawUtil.INSTANCE.getGutterMarkerPaintRange(editor, startLine, endLine);
        int y1 = markerRange.component1();
        int y2 = markerRange.component2();
        if (this.getHideWithoutLineNumbers() && !editor.getSettings().isLineNumbersShown()) {
            x1 = gutter.getWhitespaceSeparatorOffset();
        } else {
            int annotationsOffset = gutter.getAnnotationsAreaOffset();
            int annotationsWidth = gutter.getAnnotationsAreaWidth();
            if (annotationsWidth != 0) {
                DiffLineMarkerRenderer.drawMarker$default((DiffLineMarkerRenderer)this, (Editor)editor, (Graphics2D)((Graphics2D)g), (int)x1, (int)annotationsOffset, (int)y1, (int)y2, (boolean)this.getAlignedSides(), (DiffDrawUtil.PaintMode)this.getGutterMode(), null, (int)256, null);
                x1 = annotationsOffset + annotationsWidth;
            }
        }
        if (Intrinsics.areEqual((Object)this.getEditorMode(), (Object)this.getGutterMode())) {
            DiffLineMarkerRenderer.drawMarker$default((DiffLineMarkerRenderer)this, (Editor)editor, (Graphics2D)((Graphics2D)g), (int)x1, (int)x2, (int)y1, (int)y2, (boolean)this.getAlignedSides(), (DiffDrawUtil.PaintMode)this.getGutterMode(), null, (int)256, null);
        } else {
            int xOutline = gutter.getWhitespaceSeparatorOffset();
            DiffLineMarkerRenderer.drawMarker$default((DiffLineMarkerRenderer)this, (Editor)editor, (Graphics2D)((Graphics2D)g), (int)xOutline, (int)x2, (int)y1, (int)y2, (boolean)this.getAlignedSides(), (DiffDrawUtil.PaintMode)this.getEditorMode(), null, (int)256, null);
            DiffLineMarkerRenderer.drawMarker$default((DiffLineMarkerRenderer)this, (Editor)editor, (Graphics2D)((Graphics2D)g), (int)x1, (int)xOutline, (int)y1, (int)y2, (boolean)this.getAlignedSides(), (DiffDrawUtil.PaintMode)this.getGutterMode(), null, (int)256, null);
        }
    }
}

