/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.RowPattern;
import com.intellij.sql.formatter.model.SingletonPattern;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlExistsClauseBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedSubqueryBlock;
import com.intellij.sql.formatter.model.StartStopPattern;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokenType;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/formatter/model/SqlExistsClauseBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "<init>", "()V", "whetherToFlatten", "", "node", "Lcom/intellij/lang/ASTNode;", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "configureFormattingAttributes", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "Companion", "ExistsClauseParenthesizedSubqueryBlock", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlParenthesizedBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlParenthesizedBlock.kt\ncom/intellij/sql/formatter/model/SqlExistsClauseBlock\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlock\n*L\n1#1,203:1\n112#2,4:204\n*S KotlinDebug\n*F\n+ 1 SqlParenthesizedBlock.kt\ncom/intellij/sql/formatter/model/SqlExistsClauseBlock\n*L\n172#1:204,4\n*E\n"})
public final class SqlExistsClauseBlock
extends SqlNodeBlock {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<IElementType> flattenBlockTypes;
    @NotNull
    private static final List<FlowPattern> patterns;

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return flattenBlockTypes.contains(node.getElementType());
    }

    @Override
    @NotNull
    protected List<FlowPattern> flowPatterns() {
        return patterns;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureFormattingAttributes() {
        block1: {
            int subqueryOpening = this.getContext().getSql().SUBQUERY_OPENING;
            if (subqueryOpening <= 0) break block1;
            Wrap w = SqlFlowBlock.makeWrap$default(this, subqueryOpening <= 1 ? WrapType.NONE : WrapType.ALWAYS, false, 2, null);
            Indent i2 = subqueryOpening == 3 ? SqlFormattingFunKt.getNONE_INDENT() : SqlFormattingFunKt.getNORMAL_INDENT();
            SqlBlock sqlBlock = SqlFormattingModelFun.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.BODY);
            if (sqlBlock != null) {
                void indent$iv;
                void wrap$iv;
                void this_$iv;
                SqlBlock sqlBlock2 = sqlBlock;
                Wrap wrap = w;
                Indent indent = i2;
                Alignment align$iv = null;
                boolean $i$f$setAttributes = false;
                this_$iv.setMyWrap((Wrap)wrap$iv);
                this_$iv.setMyIndent((Indent)indent$iv);
                this_$iv.setMyAlign(align$iv);
            }
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        BlockRole r1 = block1.getRole();
        BlockRole r2 = block2.getRole();
        if (r1 == BlockRole.PREFIX || r2 == BlockRole.BODY) {
            int sp = this.getContext().getSql().SUBQUERY_PAR_SPACE_BEFORE;
            boolean wrapping = this.getContext().getSql().SUBQUERY_OPENING > 1;
            switch (sp) {
                case 1: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, wrapping, 1, null);
                    break;
                }
                case 2: {
                    spacing = this.getContext().makeNoSpace(wrapping);
                    break;
                }
                default: {
                    spacing = null;
                    break;
                }
            }
        } else {
            spacing = super.decideSpacing(block1, block2);
        }
        return spacing;
    }

    static {
        Object[] objectArray = new IElementType[]{SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE, SqlCompositeElementTypes.SQL_ARGUMENT_LIST, SqlCompositeElementTypes.SQL_IDENTIFIER, SqlCompositeElementTypes.SQL_UNARY_EXPRESSION, SqlCompositeElementTypes.SQL_FUNCTION_CALL};
        flattenBlockTypes = SetsKt.setOf((Object[])objectArray);
        objectArray = new FlowPattern[3];
        objectArray[0] = new SingletonPattern((byte)0, (byte)1, NodeMatcherKt.matchSingleText$default("exists", false, 2, null), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
        Byte by = 0;
        Byte by2 = 1;
        Object[] objectArray2 = new NodeMatcher[2];
        SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_NOT;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTokenType), (String)"SQL_NOT");
        objectArray2[0] = NodeMatcherKt.matchType((IElementType)sqlTokenType);
        objectArray2[1] = NodeMatcherKt.matchSingleText$default("exists", false, 2, null);
        objectArray[1] = new RowPattern(by, by2, CollectionsKt.listOf((Object[])objectArray2), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
        Byte by3 = 1;
        Byte by4 = 2;
        SqlTokenType sqlTokenType2 = SqlCommonTokens.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTokenType2), (String)"SQL_LEFT_PAREN");
        NodeMatcher nodeMatcher = NodeMatcherKt.matchType((IElementType)sqlTokenType2);
        SqlTokenType sqlTokenType3 = SqlCommonTokens.SQL_RIGHT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTokenType3), (String)"SQL_RIGHT_PAREN");
        objectArray[2] = new StartStopPattern(by3, by4, nodeMatcher, NodeMatcherKt.matchType((IElementType)sqlTokenType3), BlockRole.BODY, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
        patterns = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/formatter/model/SqlExistsClauseBlock$Companion;", "", "<init>", "()V", "flattenBlockTypes", "", "Lcom/intellij/psi/tree/IElementType;", "getFlattenBlockTypes", "()Ljava/util/Set;", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<IElementType> getFlattenBlockTypes() {
            return flattenBlockTypes;
        }

        @NotNull
        public final List<FlowPattern> getPatterns() {
            return patterns;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/formatter/model/SqlExistsClauseBlock$ExistsClauseParenthesizedSubqueryBlock;", "Lcom/intellij/sql/formatter/model/SqlParenthesizedSubqueryBlock;", "<init>", "()V", "adjustNestedNodes", "", "intellij.database.sql.core.impl"})
    public static final class ExistsClauseParenthesizedSubqueryBlock
    extends SqlParenthesizedSubqueryBlock {
        @Override
        protected void adjustNestedNodes() {
            this.flattenNestedNodes((Function1<? super ASTNode, Boolean>)((Function1)ExistsClauseParenthesizedSubqueryBlock::adjustNestedNodes$lambda$0));
        }

        private static final boolean adjustNestedNodes$lambda$0(ASTNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.getFlattenBlockTypes().contains(it.getElementType());
        }
    }
}

