/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ToDatabaseScriptTranslationAction;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.actions.SubmitMutations;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.EditorTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToDatabaseScriptTranslationPreviewAction
extends ToDatabaseScriptTranslationAction {
    @Nullable
    private static JdbcConsoleProvider.Info getInfo(@NotNull PsiFile psiFile, @NotNull Editor editor2) {
        Project project;
        Document document;
        if (psiFile == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(1);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = psiFile.getProject())).getDocument(psiFile)) == null) {
            return null;
        }
        ScriptModel model = SqlPsiFacade.getInstance((Project)project).createScriptModel(psiFile);
        return new JdbcConsoleProvider.Info(psiFile, psiFile, (EditorEx)editor2, model, DatabaseSettings.getDefaultExecOption(), null);
    }

    @NotNull
    private static EditorTextField createArea(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Language language, @NotNull String text) {
        JdbcConsole console;
        if (e == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(3);
        }
        if (language == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(4);
        }
        if (text == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(5);
        }
        SearchPath searchPath = (console = JdbcConsole.findConsole(e)) == null ? null : console.getSearchPath();
        DbDataSource dataSource = console == null ? null : DbPsiFacade.getInstance((Project)project).findDataSource(console.getDataSource().getUniqueId());
        EditorTextField editorTextField2 = DatabaseDialogsHelper.createLanguageEditorArea(project, language, dataSource, searchPath, text, false);
        if (editorTextField2 == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(6);
        }
        return editorTextField2;
    }

    @Override
    void handleTranslatedQueryText(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Language language, @NotNull String text) {
        if (e == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(8);
        }
        if (language == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(9);
        }
        if (text == null) {
            ToDatabaseScriptTranslationPreviewAction.$$$reportNull$$$0(10);
        }
        EditorTextField area = ToDatabaseScriptTranslationPreviewAction.createArea(e, project, language, text);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)area, "Center");
        DialogBuilder builder = new DialogBuilder();
        builder.setCenterPanel((JComponent)panel2);
        builder.addOkAction().setText(DatabaseBundle.message((String)"database.cli.integration.run.action", (Object[])new Object[0]));
        builder.setOkOperation(() -> {
            JdbcConsole console = JdbcConsole.findConsole(e);
            if (console == null) {
                return;
            }
            Editor editor2 = area.getEditor();
            if (editor2 == null) {
                return;
            }
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor2, (Project)project);
            if (psiFile == null) {
                return;
            }
            JdbcConsoleProvider.Info info2 = ToDatabaseScriptTranslationPreviewAction.getInfo(psiFile, editor2);
            if (info2 == null) {
                return;
            }
            JdbcConsoleProvider.doRunQueryInConsole(console, info2);
            builder.getDialogWrapper().close(0);
        });
        builder.setOkActionEnabled(true);
        builder.addCancelAction();
        builder.setTitle(DatabaseBundle.message((String)"dialog.title.js.script.preview", (Object[])new Object[0]));
        if (builder.showAndGet()) {
            SubmitMutations.submitChangesIfExists(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ToDatabaseScriptTranslationPreviewAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ToDatabaseScriptTranslationPreviewAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createArea";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleTranslatedQueryText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

