/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CouchbaseDialect
extends AbstractDatabaseDialect {
    public static final String SYSTEM_SCHEMA = "system";
    public static final String DEFAULT_SCHEMA = "default";

    public CouchbaseDialect() {
        super(new TypeHelper(){

            public String getTypeName(int code, int length, int precision, int scale) {
                return null;
            }
        });
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.COUCHBASE_QUERY;
        if (dbms == null) {
            CouchbaseDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        return "Couchbase Query";
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    public boolean supportsInsertInto() {
        return false;
    }

    public boolean supportsSchemaChanging() {
        return false;
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        String schemaName;
        if (builder == null) {
            CouchbaseDialect.$$$reportNull$$$0(1);
        }
        if (identifier == null) {
            CouchbaseDialect.$$$reportNull$$$0(2);
        }
        if (qualifier == null) {
            CouchbaseDialect.$$$reportNull$$$0(3);
        }
        if (SYSTEM_SCHEMA.equalsIgnoreCase(schemaName = DasUtil.getName((DasObject)DasUtil.getSchemaObject((DasObject)qualifier)))) {
            builder.plain(schemaName).symbol(":");
        }
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, null, null, null, null, null, null);
        if (ddlBuilder == null) {
            CouchbaseDialect.$$$reportNull$$$0(4);
        }
        return ddlBuilder;
    }

    public String catToScript(@NotNull String identifier, @Nullable ObjectKind kind, boolean forceQuoting, boolean suppress, @NotNull Casing casing) {
        if (identifier == null) {
            CouchbaseDialect.$$$reportNull$$$0(5);
        }
        if (casing == null) {
            CouchbaseDialect.$$$reportNull$$$0(6);
        }
        if (!forceQuoting && identifier.contains(".")) {
            return identifier;
        }
        return super.catToScript(identifier, kind, forceQuoting, suppress, casing);
    }

    public SearchPath tryToLoadSearchPath(@NotNull DatabaseConnectionCore connection2) {
        if (connection2 == null) {
            CouchbaseDialect.$$$reportNull$$$0(7);
        }
        return SearchPath.of((ObjectPath)ObjectPath.create((String)DEFAULT_SCHEMA, (ObjectKind)ObjectKind.SCHEMA));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/couchbase/CouchbaseDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/couchbase/CouchbaseDialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "catToScript";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

