/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbStructureEditor;
import com.intellij.database.schemaEditor.ui.DbStructureEditorActions;
import com.intellij.database.schemaEditor.ui.DbStructureNodeEditor;
import com.intellij.database.schemaEditor.ui.DbStructureNodeTreeModel;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbStructureEditorDnD {

    public static class DbIdTransferable
    implements Transferable {
        private final DbEditorController myController;
        private final ElementIdentity<?> myIdentity;

        public DbIdTransferable(@NotNull DbEditorController controller, @NotNull ElementIdentity<?> identity) {
            if (controller == null) {
                DbIdTransferable.$$$reportNull$$$0(0);
            }
            if (identity == null) {
                DbIdTransferable.$$$reportNull$$$0(1);
            }
            this.myController = controller;
            this.myIdentity = identity;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.stringFlavor, DnDEventImpl.ourDataFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return true;
        }

        @Override
        @NotNull
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return this.getCommaSeparatedText();
            }
            if (DnDEventImpl.ourDataFlavor.equals(flavor)) {
                ElementIdentity<?> elementIdentity = this.myIdentity;
                if (elementIdentity == null) {
                    DbIdTransferable.$$$reportNull$$$0(2);
                }
                return elementIdentity;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @NotNull
        private String getCommaSeparatedText() {
            String string = StringUtil.join((Iterable)MultiElementIdentity.expand(this.myIdentity).filterMap(this::getName), (String)", ");
            if (string == null) {
                DbIdTransferable.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        private String getName(@NotNull ElementIdentity<?> id) {
            DbStructureObjectModelState<?> s;
            if (id == null) {
                DbIdTransferable.$$$reportNull$$$0(4);
            }
            return (s = DbStructureObjectModelState.resolve(this.myController.getModelController(), id)) == null ? null : s.getObjectRef().getState().getProperties().getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identity";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditorDnD$DbIdTransferable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditorDnD$DbIdTransferable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTransferData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommaSeparatedText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class TreeDnDTarget
    implements DnDTarget {
        private final DbStructureEditor<?> myEditor;

        public TreeDnDTarget(@NotNull DbStructureEditor<?> editor2) {
            if (editor2 == null) {
                TreeDnDTarget.$$$reportNull$$$0(0);
            }
            this.myEditor = editor2;
        }

        public void drop(DnDEvent event) {
            ElementIdentity<?> id = TreeDnDTarget.getIdentity(event);
            if (id == null) {
                return;
            }
            TreePath path = this.getPathAboveTheClosestGap(event.getPointOn((Component)this.myEditor.getTree()));
            DbStructureNodeEditor<?, ?> node = DbStructureNodeTreeModel.getEditor(path);
            if (node == null || !this.canDrop(id, node)) {
                return;
            }
            this.moveTo(id, node);
        }

        private void moveTo(@NotNull ElementIdentity<?> id, @NotNull DbStructureNodeEditor<?, ?> ptrNode) {
            DbStructureNodeEditor<Object, Object> tgt;
            if (id == null) {
                TreeDnDTarget.$$$reportNull$$$0(1);
            }
            if (ptrNode == null) {
                TreeDnDTarget.$$$reportNull$$$0(2);
            }
            DbStructureNodeTreeModel structure = this.myEditor.getStructure();
            boolean isFamily = ptrNode.getState() instanceof DbStructureFamilyModelState;
            DbStructureNodeEditor<Object, Object> dbStructureNodeEditor = tgt = isFamily ? ptrNode : structure.getParent(ptrNode);
            if (tgt == null) {
                return;
            }
            ArrayList children2 = new ArrayList(tgt.getChildren());
            Set toRemove = MultiElementIdentity.expand(id).toSet();
            ArrayList<DbStructureNodeEditor> toInsert = new ArrayList<DbStructureNodeEditor>(toRemove.size());
            DbStructureNodeEditor<Object, Object> lastNode = null;
            Iterator it = children2.iterator();
            while (it.hasNext()) {
                DbStructureNodeEditor<Object, Object> c2 = (DbStructureNodeEditor<Object, Object>)it.next();
                if (toRemove.contains(c2.getIdentity())) {
                    toInsert.add(c2);
                    it.remove();
                    if (c2 != ptrNode) continue;
                    ptrNode = lastNode;
                    continue;
                }
                lastNode = c2;
            }
            int idx = isFamily ? 0 : children2.indexOf(ptrNode) + 1;
            children2.addAll(idx, toInsert);
            tgt.setChildren(children2);
            this.myEditor.getTree().setSelectionPaths((TreePath[])JBIterable.from(toInsert).filterMap(structure::pathOf).toArray((Object[])new TreePath[0]));
        }

        public boolean update(DnDEvent event) {
            Rectangle bounds;
            ElementIdentity<?> id = TreeDnDTarget.getIdentity(event);
            if (id == null) {
                return true;
            }
            JTree tree = this.myEditor.getTree();
            TreePath path = this.getPathAboveTheClosestGap(event.getPointOn((Component)tree));
            DbStructureNodeEditor<?, ?> node = DbStructureNodeTreeModel.getEditor(path);
            if (node == null) {
                return true;
            }
            boolean canDrop = this.canDrop(id, node);
            event.setDropPossible(canDrop);
            if (canDrop && (bounds = tree.getPathBounds(path)) != null) {
                event.setHighlighting(new RelativeRectangle((Component)tree, bounds), 64);
            }
            return false;
        }

        private boolean canDrop(@NotNull ElementIdentity<?> id, @NotNull DbStructureNodeEditor<?, ?> node) {
            BasicMetaObject meta;
            DbEditorModelController controller;
            if (id == null) {
                TreeDnDTarget.$$$reportNull$$$0(3);
            }
            if (node == null) {
                TreeDnDTarget.$$$reportNull$$$0(4);
            }
            if (!DbStructureEditorActions.isMoveSupported(controller = this.myEditor.getController().getModelController(), id, 0, node.getIdentity())) {
                return false;
            }
            ElementIdentity pathId = node.getIdentity();
            ElementMatcher matcher = controller.getMatcher();
            ElementIdentity parentId = matcher.getParent(id);
            Object s = node.getState();
            if (s instanceof DbStructureFamilyModelState) {
                DbStructureFamilyModelState fState = (DbStructureFamilyModelState)s;
                meta = fState.getMetaObject();
                return meta == id.getMetaObject() && pathId == parentId;
            }
            meta = pathId.getMetaObject();
            ElementIdentity dropParentId = matcher.getParent(pathId);
            return meta == id.getMetaObject() && dropParentId == parentId;
        }

        @Nullable
        private TreePath getPathAboveTheClosestGap(Point pt) {
            TreePath path2;
            int row;
            Rectangle pathBounds;
            JTree tree = this.myEditor.getTree();
            TreePath path = tree.getPathForLocation(pt.x, pt.y);
            Rectangle rectangle = pathBounds = path == null ? null : tree.getPathBounds(path);
            if (pathBounds != null && pathBounds.getMaxY() - (double)pt.y > (double)pt.y - pathBounds.getMinY() && (row = tree.getRowForPath(path)) - 1 >= 0 && (path2 = tree.getPathForRow(row - 1)) != null) {
                path = path2;
            }
            return path;
        }

        @Nullable
        private static ElementIdentity<?> getIdentity(DnDEvent event) {
            try {
                return (ElementIdentity)ObjectUtils.tryCast((Object)event.getTransferData(DnDEventImpl.ourDataFlavor), ElementIdentity.class);
            }
            catch (Throwable e) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ptrNode";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditorDnD$TreeDnDTarget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveTo";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDrop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

