/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.lexer;

import com.intellij.lang.puppet.PuppetLanguage;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.lexer.PuppetLexerKeywords;
import com.intellij.lang.puppet.settings.PuppetProjectConfiguration;
import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Stack;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class PuppetLexerBase
implements FlexLexer,
PuppetTokenTypes {
    public static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-z][\\-a-zA-Z0-9_]*");
    private final NotNullLazyValue<PuppetLanguage.Version> myPuppetVersion;
    private static final TokenSet PRE_FQN_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CLASS, DEFINE, FUNCTION});
    private final Project myProject;
    protected final Stack<Integer> stack = new Stack();
    protected final Deque<HeredocInfo> myHeredocQueue = new ArrayDeque<HeredocInfo>(1);
    private boolean myIsLookLikeIncompleteHeredocOpenerLine = false;
    private final Map<String, IElementType> myKeywordsMap;

    public PuppetLexerBase() {
        this(null);
    }

    public PuppetLexerBase(Project project) {
        this.myProject = project;
        this.myKeywordsMap = PuppetLexerKeywords.getKeywordsMap(project);
        this.myPuppetVersion = NotNullLazyValue.atomicLazy(() -> {
            if (this.myProject == null) {
                return PuppetLanguage.Version.PUPPET_4;
            }
            return PuppetProjectConfiguration.getInstance(this.myProject).getLanguageVersion();
        });
    }

    protected void pushStateAndBegin(int state) {
        this.pushState();
        this.myYyBegin(state);
    }

    protected void pushState() {
        this.stack.push((Object)this.yystate());
    }

    protected void popState() {
        if (!this.stack.empty()) {
            this.myYyBegin((Integer)this.stack.pop());
        } else {
            this.myYyBegin(0);
        }
    }

    protected void myYyBegin(int state) {
        if (state == 0 && !this.isSafeToInit()) {
            this.yybegin(8);
        } else if (state == 8 && this.isSafeToInit()) {
            this.yybegin(0);
        } else {
            this.yybegin(state);
        }
    }

    private void refreshState() {
        this.myYyBegin(this.yystate());
    }

    protected void setLookLikeIncompleteHeredocOpenerLine(boolean newValue) {
        this.myIsLookLikeIncompleteHeredocOpenerLine = newValue;
        this.refreshState();
    }

    private boolean isSafeToInit() {
        return this.stack.empty() && this.myHeredocQueue.isEmpty() && !this.myIsLookLikeIncompleteHeredocOpenerLine;
    }

    public void clearOnReset() {
        this.stack.clear();
        this.myHeredocQueue.clear();
        this.myIsLookLikeIncompleteHeredocOpenerLine = false;
    }

    protected PuppetLanguage.Version getLanguageVersion() {
        return (PuppetLanguage.Version)((Object)this.myPuppetVersion.getValue());
    }

    protected boolean isPuppet3() {
        return this.getLanguageVersion() == PuppetLanguage.Version.PUPPET_3;
    }

    protected IElementType proxyLiteralToken(IElementType tokenType) {
        this.myYyBegin(4);
        return tokenType;
    }

    protected IElementType getNameOrKeywordToken() {
        IElementType elementType = this.myKeywordsMap.get(this.yytext().toString());
        if (elementType == null) {
            return this.proxyLiteralToken(NAME);
        }
        if (PRE_FQN_TOKENS.contains(elementType)) {
            this.myYyBegin(14);
        } else {
            this.myYyBegin(16);
        }
        return elementType;
    }

    protected IElementType lexLBrack() {
        if (this.isPuppet3()) {
            return LBRACK;
        }
        return this.getTokenStart() == 0 || Character.isWhitespace(this.yycharat(-1)) ? LISTSTART : LBRACK;
    }

    protected boolean isCurrentHeredocCloser() {
        return this.yytext().toString().trim().endsWith(this.myHeredocQueue.peekFirst().myEndTag);
    }

    protected void pushback() {
        this.yypushback(this.yylength());
    }

    public abstract int yylength();

    public abstract void yypushback(int var1);

    public abstract CharSequence yytext();

    public abstract int getTokenStart();

    public abstract char yycharat(int var1);

    public abstract void setTokenEnd(int var1);

    protected static class HeredocInfo {
        final String myEndTag;
        final boolean myInterpolationAllowed;

        public HeredocInfo(String endTag, boolean isInterpolationAllowed) {
            this.myEndTag = endTag;
            this.myInterpolationAllowed = isInterpolationAllowed;
        }
    }
}

