/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.figures;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.python.scientific.figures.DisplayMessage;
import com.intellij.python.scientific.figures.MatplotlibDisplayObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"parse", "Lcom/intellij/python/scientific/figures/DisplayMessage;", "reader", "Lcom/google/gson/stream/JsonReader;", "getDisplayObjectFromMap", "Lcom/intellij/python/scientific/figures/MatplotlibDisplayObject;", "jsonObject", "Lcom/google/gson/JsonObject;", "intellij.python.scientific"})
public final class DisplayMessageKt {
    @NotNull
    public static final DisplayMessage parse(@NotNull JsonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        JsonObject jsonObject = new JsonParser().parse(reader).getAsJsonObject();
        String string = jsonObject.getAsJsonPrimitive("type").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
        JsonObject jsonObject2 = jsonObject.get("body").getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
        return new DisplayMessage(string, jsonObject2);
    }

    @NotNull
    public static final MatplotlibDisplayObject getDisplayObjectFromMap(@NotNull JsonObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        int n = jsonObject.get("plot_index").getAsInt();
        String string = jsonObject.get("image_base64").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
        String string2 = jsonObject.get("html_string").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAsString(...)");
        return new MatplotlibDisplayObject(n, string, string2);
    }
}

