/*
 * Decompiled with CFR 0.152.
 */
package externalApp;

import externalApp.ExternalAppEntry;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalAppUtil {
    private ExternalAppUtil() {
    }

    @NotNull
    public static Result sendIdeRequest(@NotNull String entryPoint, int idePort, @NotNull String handlerId, @Nullable String bodyContent) {
        Result result;
        int statusCode;
        HttpResponse<String> response;
        block12: {
            block11: {
                if (entryPoint == null) {
                    ExternalAppUtil.$$$reportNull$$$0(0);
                }
                if (handlerId == null) {
                    ExternalAppUtil.$$$reportNull$$$0(1);
                }
                TrustManager[] tm = new TrustManager[]{new AllowingTrustManager()};
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, tm, null);
                HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).sslContext(sslContext).connectTimeout(Duration.ofSeconds(5L)).build();
                HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(String.format("https://127.0.0.1:%s/api/%s?%s=%s", idePort, entryPoint, "handlerId", handlerId)));
                if (bodyContent != null) {
                    requestBuilder.POST(HttpRequest.BodyPublishers.ofString(bodyContent));
                } else {
                    requestBuilder.POST(HttpRequest.BodyPublishers.noBody());
                }
                response = client.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
                statusCode = response.statusCode();
                if (statusCode != 200) break block11;
                Result result2 = Result.success(statusCode, response.body());
                if (result2 == null) {
                    ExternalAppUtil.$$$reportNull$$$0(2);
                }
                return result2;
            }
            if (statusCode != 204) break block12;
            Result result3 = Result.success(statusCode, null);
            if (result3 == null) {
                ExternalAppUtil.$$$reportNull$$$0(3);
            }
            return result3;
        }
        try {
            result = Result.error(statusCode, response.body());
        }
        catch (IOException | InterruptedException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        if (result == null) {
            ExternalAppUtil.$$$reportNull$$$0(4);
        }
        return result;
    }

    @Deprecated(since="2025.2", forRemoval=true)
    @NotNull
    public static String getEnv(@NotNull String env) {
        String value;
        if (env == null) {
            ExternalAppUtil.$$$reportNull$$$0(5);
        }
        if ((value = System.getenv(env)) == null) {
            throw new IllegalStateException(env + " environment variable is not defined!");
        }
        String string = value;
        if (string == null) {
            ExternalAppUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getEnv(@NotNull String env, @NotNull Map<String, String> environment) {
        String value;
        if (env == null) {
            ExternalAppUtil.$$$reportNull$$$0(7);
        }
        if (environment == null) {
            ExternalAppUtil.$$$reportNull$$$0(8);
        }
        if ((value = environment.get(env)) == null) {
            throw new IllegalStateException(env + " environment variable is not defined!");
        }
        String string = value;
        if (string == null) {
            ExternalAppUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Deprecated(since="2025.2", forRemoval=true)
    public static int getEnvInt(@NotNull String env) {
        if (env == null) {
            ExternalAppUtil.$$$reportNull$$$0(10);
        }
        return Integer.parseInt(ExternalAppUtil.getEnv(env));
    }

    public static int getEnvInt(@NotNull String env, @NotNull Map<String, String> environment) {
        if (env == null) {
            ExternalAppUtil.$$$reportNull$$$0(11);
        }
        if (environment == null) {
            ExternalAppUtil.$$$reportNull$$$0(12);
        }
        return Integer.parseInt(ExternalAppUtil.getEnv(env, environment));
    }

    @Deprecated(since="2025.2", forRemoval=true)
    public static void handleAskPassInvocation(@NotNull String handlerIdEnvName, @NotNull String idePortEnvName, @NotNull String entryPoint, String[] args) {
        if (handlerIdEnvName == null) {
            ExternalAppUtil.$$$reportNull$$$0(13);
        }
        if (idePortEnvName == null) {
            ExternalAppUtil.$$$reportNull$$$0(14);
        }
        if (entryPoint == null) {
            ExternalAppUtil.$$$reportNull$$$0(15);
        }
        int exitCode = ExternalAppUtil.handleAskPassInvocation(handlerIdEnvName, idePortEnvName, entryPoint, ExternalAppEntry.fromMain(args));
        System.exit(exitCode);
    }

    public static int handleAskPassInvocation(@NotNull String handlerIdEnvName, @NotNull String idePortEnvName, @NotNull String entryPoint, ExternalAppEntry entry) {
        if (handlerIdEnvName == null) {
            ExternalAppUtil.$$$reportNull$$$0(16);
        }
        if (idePortEnvName == null) {
            ExternalAppUtil.$$$reportNull$$$0(17);
        }
        if (entryPoint == null) {
            ExternalAppUtil.$$$reportNull$$$0(18);
        }
        try {
            String[] args = entry.getArgs();
            String handlerId = ExternalAppUtil.getEnv(handlerIdEnvName);
            int idePort = ExternalAppUtil.getEnvInt(idePortEnvName);
            String description = args.length > 0 ? args[0] : null;
            Result result = ExternalAppUtil.sendIdeRequest(entryPoint, idePort, handlerId, description);
            if (result.isError) {
                entry.getStderr().println(result.getPresentableError());
                return 1;
            }
            String passphrase = result.response;
            if (passphrase == null) {
                entry.getStderr().println("Authentication request was cancelled");
                return 1;
            }
            entry.getStdout().println(passphrase);
            return 0;
        }
        catch (Throwable t) {
            entry.getStderr().println(t.getMessage());
            t.printStackTrace(entry.getStderr());
            return 1;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryPoint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerId";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalApp/ExternalAppUtil";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerIdEnvName";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idePortEnvName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "externalApp/ExternalAppUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sendIdeRequest";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sendIdeRequest";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEnv";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEnvInt";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleAskPassInvocation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 9 -> new IllegalStateException(string);
        };
    }

    private static class AllowingTrustManager
    extends X509ExtendedTrustManager {
        private AllowingTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }

    public static class Result {
        public final boolean isError;
        public final int statusCode;
        public final String response;
        public final String error;

        private Result(int statusCode, String response, String error, boolean isError) {
            this.statusCode = statusCode;
            this.response = response;
            this.error = error;
            this.isError = isError;
        }

        public static Result success(int statusCode, @Nullable String response) {
            return new Result(statusCode, response, null, false);
        }

        public static Result error(int statusCode, @Nullable String error) {
            return new Result(statusCode, null, error, true);
        }

        @NotNull
        public String getPresentableError() {
            String msg = "Could not communicate with IDE: " + this.statusCode;
            if (this.error != null && !this.error.isEmpty()) {
                msg = msg + " - " + this.error;
            }
            String string = msg;
            if (string == null) {
                Result.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "externalApp/ExternalAppUtil$Result", "getPresentableError"));
        }
    }
}

