/******************************************************************************
 * The MIT License (MIT)
 *
 * Copyright (c) 2019-2024 Baldur Karlsson
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

/******************************************************************************
 * Generated from Khronos SPIR-V machine-readable JSON grammar.
 *
 * Copyright (c) 2014-2024 The Khronos Group Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and/or associated documentation files (the "Materials"),
 * to deal in the Materials without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Materials, and to permit persons to whom the
 * Materials are furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Materials.
 *
 * MODIFICATIONS TO THIS FILE MAY MEAN IT NO LONGER ACCURATELY REFLECTS KHRONOS
 * STANDARDS. THE UNMODIFIED, NORMATIVE VERSIONS OF KHRONOS SPECIFICATIONS AND
 * HEADER INFORMATION ARE LOCATED AT https://www.khronos.org/registry/
 *
 * THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM,OUT OF OR IN CONNECTION WITH THE MATERIALS OR THE USE OR OTHER DEALINGS
 * IN THE MATERIALS.
 ******************************************************************************/

#pragma once

// This file is autogenerated with gen_spirv_code.py - any changes will be overwritten next time
// that script is run.
// $ ./gen_spirv_code.py

// We need to disable clang-format since this file is programmatically generated
// clang-format off

#include <stdint.h>
#include "api/replay/apidefs.h"
#include "api/replay/stringise.h"

#undef None
#undef CopyMemory
#undef MemoryBarrier

namespace rdcspv
{
static const uint32_t MagicNumber = 0x07230203;
static const uint32_t VersionMajor = 1;
static const uint32_t VersionMinor = 6;
static const uint32_t VersionRevision = 1;
static const uint32_t VersionPacked = (1 << 16) | (6 << 8);
static const uint32_t OpCodeMask = 0xffff;
static const uint32_t WordCountShift = 16;
static const uint32_t FirstRealWord = 5;

struct Id
{
  constexpr inline Id() : id(0) {}
  // only allow explicit functions to cast to/from uint32_t
  constexpr static inline Id fromWord(uint32_t i) { return Id(i); }
  inline uint32_t value() const { return id; }
  constexpr inline explicit operator bool() const { return id != 0; }
  constexpr inline bool operator==(const Id o) const { return id == o.id; }
  constexpr inline bool operator!=(const Id o) const { return id != o.id; }
  constexpr inline bool operator<(const Id o) const { return id < o.id; }
  constexpr inline bool operator==(const uint32_t o) const { return id == o; }
  constexpr inline bool operator!=(const uint32_t o) const { return id != o; }
  constexpr inline bool operator<(const uint32_t o) const { return id < o; }
private:
  constexpr inline Id(uint32_t i) : id(i) {}
  uint32_t id;
};

enum class Generator : uint32_t
{
  LLVMSPIRVTranslator = 6,
  SPIRVToolsAssembler = 7,
  GlslangReferenceFrontEnd = 8,
  ShadercoverGlslang = 13,
  spiregg = 14,
  rspirv = 15,
  MesaIRSPIRVTranslator = 16,
  SPIRVToolsLinker = 17,
  VKD3DShaderCompiler = 18,
  ClayShaderCompiler = 19,
  WHLSLShaderTranslator = 20,
  Clspv = 21,
  MLIRSPIRVSerializer = 22,
  TintCompiler = 23,
  ANGLEShaderCompiler = 24,
  MessiahShaderCompiler = 25,
  XeniaEmulatorMicrocodeTranslator = 26,
  RustGPUCompilerBackend = 27,
  Naga = 28,
  MSPShaderCompiler = 29,
  SpvGenTwoSPIRVIRTools = 30,
  SkiaSkSL = 31,
  BeehiveSPIRVToolkit = 32,
  ShaderWriter = 33,
  SPIRVSmith = 34,
  Shady = 35,
  Taichi = 36,
  HeroCCompiler = 37,
  SparkSL = 38,
  NazaraShaderLangCompiler = 39,
  SlangCompiler = 40,
  ZigCompiler = 41,
  spq = 42,
  LLVMSPIRVBackend = 43,
};

enum class ImageOperands : uint32_t
{
  None = 0x0000,
  Bias = 0x0001,
  Lod = 0x0002,
  Grad = 0x0004,
  ConstOffset = 0x0008,
  Offset = 0x0010,
  ConstOffsets = 0x0020,
  Sample = 0x0040,
  MinLod = 0x0080,
  MakeTexelAvailable = 0x0100,
  MakeTexelAvailableKHR = 0x0100,
  MakeTexelVisible = 0x0200,
  MakeTexelVisibleKHR = 0x0200,
  NonPrivateTexel = 0x0400,
  NonPrivateTexelKHR = 0x0400,
  VolatileTexel = 0x0800,
  VolatileTexelKHR = 0x0800,
  SignExtend = 0x1000,
  ZeroExtend = 0x2000,
  Nontemporal = 0x4000,
  Offsets = 0x10000,
  Max,
  Invalid = ~0U,
};

BITMASK_OPERATORS(ImageOperands);

enum class FPFastMathMode : uint32_t
{
  None = 0x0000,
  NotNaN = 0x0001,
  NotInf = 0x0002,
  NSZ = 0x0004,
  AllowRecip = 0x0008,
  Fast = 0x0010,
  AllowContract = 0x10000,
  AllowContractFastINTEL = 0x10000,
  AllowReassoc = 0x20000,
  AllowReassocINTEL = 0x20000,
  AllowTransform = 0x40000,
  Max,
  Invalid = ~0U,
};

BITMASK_OPERATORS(FPFastMathMode);

enum class SelectionControl : uint32_t
{
  None = 0x0000,
  Flatten = 0x0001,
  DontFlatten = 0x0002,
  Max,
  Invalid = ~0U,
};

BITMASK_OPERATORS(SelectionControl);

enum class LoopControl : uint32_t
{
  None = 0x0000,
  Unroll = 0x0001,
  DontUnroll = 0x0002,
  DependencyInfinite = 0x0004,
  DependencyLength = 0x0008,
  MinIterations = 0x0010,
  MaxIterations = 0x0020,
  IterationMultiple = 0x0040,
  PeelCount = 0x0080,
  PartialCount = 0x0100,
  InitiationIntervalINTEL = 0x10000,
  MaxConcurrencyINTEL = 0x20000,
  DependencyArrayINTEL = 0x40000,
  PipelineEnableINTEL = 0x80000,
  LoopCoalesceINTEL = 0x100000,
  MaxInterleavingINTEL = 0x200000,
  SpeculatedIterationsINTEL = 0x400000,
  NoFusionINTEL = 0x800000,
  LoopCountINTEL = 0x1000000,
  MaxReinvocationDelayINTEL = 0x2000000,
  Max,
  Invalid = ~0U,
};

BITMASK_OPERATORS(LoopControl);

enum class FunctionControl : uint32_t
{
  None = 0x0000,
  Inline = 0x0001,
  DontInline = 0x0002,
  Pure = 0x0004,
  Const = 0x0008,
  OptNoneINTEL = 0x10000,
  Max,
  Invalid = ~0U,
};

BITMASK_OPERATORS(FunctionControl);

enum class MemorySemantics : uint32_t
{
  Relaxed = 0x0000,
  None = 0x0000,
  Acquire = 0x0002,
  Release = 0x0004,
  AcquireRelease = 0x0008,
  SequentiallyConsistent = 0x0010,
  UniformMemory = 0x0040,
  SubgroupMemory = 0x0080,
  WorkgroupMemory = 0x0100,
  CrossWorkgroupMemory = 0x0200,
  AtomicCounterMemory = 0x0400,
  ImageMemory = 0x0800,
  OutputMemory = 0x1000,
  OutputMemoryKHR = 0x1000,
  MakeAvailable = 0x2000,
  MakeAvailableKHR = 0x2000,
  MakeVisible = 0x4000,
  MakeVisibleKHR = 0x4000,
  Volatile = 0x8000,
  Max,
  Invalid = ~0U,
};

BITMASK_OPERATORS(MemorySemantics);

enum class MemoryAccess : uint32_t
{
  None = 0x0000,
  Volatile = 0x0001,
  Aligned = 0x0002,
  Nontemporal = 0x0004,
  MakePointerAvailable = 0x0008,
  MakePointerAvailableKHR = 0x0008,
  MakePointerVisible = 0x0010,
  MakePointerVisibleKHR = 0x0010,
  NonPrivatePointer = 0x0020,
  NonPrivatePointerKHR = 0x0020,
  AliasScopeINTELMask = 0x10000,
  NoAliasINTELMask = 0x20000,
  Max,
  Invalid = ~0U,
};

BITMASK_OPERATORS(MemoryAccess);

enum class KernelProfilingInfo : uint32_t
{
  None = 0x0000,
  CmdExecTime = 0x0001,
  Max,
  Invalid = ~0U,
};

BITMASK_OPERATORS(KernelProfilingInfo);

enum class RayFlags : uint32_t
{
  NoneKHR = 0x0000,
  OpaqueKHR = 0x0001,
  NoOpaqueKHR = 0x0002,
  TerminateOnFirstHitKHR = 0x0004,
  SkipClosestHitShaderKHR = 0x0008,
  CullBackFacingTrianglesKHR = 0x0010,
  CullFrontFacingTrianglesKHR = 0x0020,
  CullOpaqueKHR = 0x0040,
  CullNoOpaqueKHR = 0x0080,
  SkipTrianglesKHR = 0x0100,
  SkipAABBsKHR = 0x0200,
  ForceOpacityMicromap2StateEXT = 0x0400,
  Max,
  Invalid = ~0U,
};

BITMASK_OPERATORS(RayFlags);

enum class FragmentShadingRate : uint32_t
{
  Vertical2Pixels = 0x0001,
  Vertical4Pixels = 0x0002,
  Horizontal2Pixels = 0x0004,
  Horizontal4Pixels = 0x0008,
  Max,
  Invalid = ~0U,
};

BITMASK_OPERATORS(FragmentShadingRate);

enum class RawAccessChainOperands : uint32_t
{
  None = 0x0000,
  RobustnessPerComponentNV = 0x0001,
  RobustnessPerElementNV = 0x0002,
  Max,
  Invalid = ~0U,
};

BITMASK_OPERATORS(RawAccessChainOperands);

enum class SourceLanguage : uint32_t
{
  Unknown = 0,
  ESSL = 1,
  GLSL = 2,
  OpenCL_C = 3,
  OpenCL_CPP = 4,
  HLSL = 5,
  CPP_for_OpenCL = 6,
  SYCL = 7,
  HERO_C = 8,
  NZSL = 9,
  WGSL = 10,
  Slang = 11,
  Zig = 12,
  Max,
  Invalid = ~0U,
};

enum class ExecutionModel : uint32_t
{
  Vertex = 0,
  TessellationControl = 1,
  TessellationEvaluation = 2,
  Geometry = 3,
  Fragment = 4,
  GLCompute = 5,
  Kernel = 6,
  TaskNV = 5267,
  MeshNV = 5268,
  RayGenerationKHR = 5313,
  RayGenerationNV = 5313,
  IntersectionKHR = 5314,
  IntersectionNV = 5314,
  AnyHitKHR = 5315,
  AnyHitNV = 5315,
  ClosestHitKHR = 5316,
  ClosestHitNV = 5316,
  MissKHR = 5317,
  MissNV = 5317,
  CallableKHR = 5318,
  CallableNV = 5318,
  TaskEXT = 5364,
  MeshEXT = 5365,
  Max,
  Invalid = ~0U,
};

enum class AddressingModel : uint32_t
{
  Logical = 0,
  Physical32 = 1,
  Physical64 = 2,
  PhysicalStorageBuffer64 = 5348,
  PhysicalStorageBuffer64EXT = 5348,
  Max,
  Invalid = ~0U,
};

enum class MemoryModel : uint32_t
{
  Simple = 0,
  GLSL450 = 1,
  OpenCL = 2,
  Vulkan = 3,
  VulkanKHR = 3,
  Max,
  Invalid = ~0U,
};

enum class ExecutionMode : uint32_t
{
  Invocations = 0,
  SpacingEqual = 1,
  SpacingFractionalEven = 2,
  SpacingFractionalOdd = 3,
  VertexOrderCw = 4,
  VertexOrderCcw = 5,
  PixelCenterInteger = 6,
  OriginUpperLeft = 7,
  OriginLowerLeft = 8,
  EarlyFragmentTests = 9,
  PointMode = 10,
  Xfb = 11,
  DepthReplacing = 12,
  DepthGreater = 14,
  DepthLess = 15,
  DepthUnchanged = 16,
  LocalSize = 17,
  LocalSizeHint = 18,
  InputPoints = 19,
  InputLines = 20,
  InputLinesAdjacency = 21,
  Triangles = 22,
  InputTrianglesAdjacency = 23,
  Quads = 24,
  Isolines = 25,
  OutputVertices = 26,
  OutputPoints = 27,
  OutputLineStrip = 28,
  OutputTriangleStrip = 29,
  VecTypeHint = 30,
  ContractionOff = 31,
  Initializer = 33,
  Finalizer = 34,
  SubgroupSize = 35,
  SubgroupsPerWorkgroup = 36,
  SubgroupsPerWorkgroupId = 37,
  LocalSizeId = 38,
  LocalSizeHintId = 39,
  NonCoherentColorAttachmentReadEXT = 4169,
  NonCoherentDepthAttachmentReadEXT = 4170,
  NonCoherentStencilAttachmentReadEXT = 4171,
  SubgroupUniformControlFlowKHR = 4421,
  PostDepthCoverage = 4446,
  DenormPreserve = 4459,
  DenormFlushToZero = 4460,
  SignedZeroInfNanPreserve = 4461,
  RoundingModeRTE = 4462,
  RoundingModeRTZ = 4463,
  EarlyAndLateFragmentTestsAMD = 5017,
  StencilRefReplacingEXT = 5027,
  CoalescingAMDX = 5069,
  MaxNodeRecursionAMDX = 5071,
  StaticNumWorkgroupsAMDX = 5072,
  ShaderIndexAMDX = 5073,
  MaxNumWorkgroupsAMDX = 5077,
  StencilRefUnchangedFrontAMD = 5079,
  StencilRefGreaterFrontAMD = 5080,
  StencilRefLessFrontAMD = 5081,
  StencilRefUnchangedBackAMD = 5082,
  StencilRefGreaterBackAMD = 5083,
  StencilRefLessBackAMD = 5084,
  QuadDerivativesKHR = 5088,
  RequireFullQuadsKHR = 5089,
  OutputLinesEXT = 5269,
  OutputLinesNV = 5269,
  OutputPrimitivesEXT = 5270,
  OutputPrimitivesNV = 5270,
  DerivativeGroupQuadsNV = 5289,
  DerivativeGroupLinearNV = 5290,
  OutputTrianglesEXT = 5298,
  OutputTrianglesNV = 5298,
  PixelInterlockOrderedEXT = 5366,
  PixelInterlockUnorderedEXT = 5367,
  SampleInterlockOrderedEXT = 5368,
  SampleInterlockUnorderedEXT = 5369,
  ShadingRateInterlockOrderedEXT = 5370,
  ShadingRateInterlockUnorderedEXT = 5371,
  SharedLocalMemorySizeINTEL = 5618,
  RoundingModeRTPINTEL = 5620,
  RoundingModeRTNINTEL = 5621,
  FloatingPointModeALTINTEL = 5622,
  FloatingPointModeIEEEINTEL = 5623,
  MaxWorkgroupSizeINTEL = 5893,
  MaxWorkDimINTEL = 5894,
  NoGlobalOffsetINTEL = 5895,
  NumSIMDWorkitemsINTEL = 5896,
  SchedulerTargetFmaxMhzINTEL = 5903,
  MaximallyReconvergesKHR = 6023,
  FPFastMathDefault = 6028,
  StreamingInterfaceINTEL = 6154,
  RegisterMapInterfaceINTEL = 6160,
  NamedBarrierCountINTEL = 6417,
  MaximumRegistersINTEL = 6461,
  MaximumRegistersIdINTEL = 6462,
  NamedMaximumRegistersINTEL = 6463,
  Max,
  Invalid = ~0U,
};

enum class StorageClass : uint32_t
{
  UniformConstant = 0,
  Input = 1,
  Uniform = 2,
  Output = 3,
  Workgroup = 4,
  CrossWorkgroup = 5,
  Private = 6,
  Function = 7,
  Generic = 8,
  PushConstant = 9,
  AtomicCounter = 10,
  Image = 11,
  StorageBuffer = 12,
  TileImageEXT = 4172,
  NodePayloadAMDX = 5068,
  NodeOutputPayloadAMDX = 5076,
  CallableDataKHR = 5328,
  CallableDataNV = 5328,
  IncomingCallableDataKHR = 5329,
  IncomingCallableDataNV = 5329,
  RayPayloadKHR = 5338,
  RayPayloadNV = 5338,
  HitAttributeKHR = 5339,
  HitAttributeNV = 5339,
  IncomingRayPayloadKHR = 5342,
  IncomingRayPayloadNV = 5342,
  ShaderRecordBufferKHR = 5343,
  ShaderRecordBufferNV = 5343,
  PhysicalStorageBuffer = 5349,
  PhysicalStorageBufferEXT = 5349,
  HitObjectAttributeNV = 5385,
  TaskPayloadWorkgroupEXT = 5402,
  CodeSectionINTEL = 5605,
  DeviceOnlyINTEL = 5936,
  HostOnlyINTEL = 5937,
  Max,
  Invalid = ~0U,
};

enum class Dim : uint32_t
{
  _1D = 0,
  _2D = 1,
  _3D = 2,
  Cube = 3,
  Rect = 4,
  Buffer = 5,
  SubpassData = 6,
  TileImageDataEXT = 4173,
  Max,
  Invalid = ~0U,
};

enum class SamplerAddressingMode : uint32_t
{
  None = 0,
  ClampToEdge = 1,
  Clamp = 2,
  Repeat = 3,
  RepeatMirrored = 4,
  Max,
  Invalid = ~0U,
};

enum class SamplerFilterMode : uint32_t
{
  Nearest = 0,
  Linear = 1,
  Max,
  Invalid = ~0U,
};

enum class ImageFormat : uint32_t
{
  Unknown = 0,
  Rgba32f = 1,
  Rgba16f = 2,
  R32f = 3,
  Rgba8 = 4,
  Rgba8Snorm = 5,
  Rg32f = 6,
  Rg16f = 7,
  R11fG11fB10f = 8,
  R16f = 9,
  Rgba16 = 10,
  Rgb10A2 = 11,
  Rg16 = 12,
  Rg8 = 13,
  R16 = 14,
  R8 = 15,
  Rgba16Snorm = 16,
  Rg16Snorm = 17,
  Rg8Snorm = 18,
  R16Snorm = 19,
  R8Snorm = 20,
  Rgba32i = 21,
  Rgba16i = 22,
  Rgba8i = 23,
  R32i = 24,
  Rg32i = 25,
  Rg16i = 26,
  Rg8i = 27,
  R16i = 28,
  R8i = 29,
  Rgba32ui = 30,
  Rgba16ui = 31,
  Rgba8ui = 32,
  R32ui = 33,
  Rgb10a2ui = 34,
  Rg32ui = 35,
  Rg16ui = 36,
  Rg8ui = 37,
  R16ui = 38,
  R8ui = 39,
  R64ui = 40,
  R64i = 41,
  Max,
  Invalid = ~0U,
};

enum class ImageChannelOrder : uint32_t
{
  R = 0,
  A = 1,
  RG = 2,
  RA = 3,
  RGB = 4,
  RGBA = 5,
  BGRA = 6,
  ARGB = 7,
  Intensity = 8,
  Luminance = 9,
  Rx = 10,
  RGx = 11,
  RGBx = 12,
  Depth = 13,
  DepthStencil = 14,
  sRGB = 15,
  sRGBx = 16,
  sRGBA = 17,
  sBGRA = 18,
  ABGR = 19,
  Max,
  Invalid = ~0U,
};

enum class ImageChannelDataType : uint32_t
{
  SnormInt8 = 0,
  SnormInt16 = 1,
  UnormInt8 = 2,
  UnormInt16 = 3,
  UnormShort565 = 4,
  UnormShort555 = 5,
  UnormInt101010 = 6,
  SignedInt8 = 7,
  SignedInt16 = 8,
  SignedInt32 = 9,
  UnsignedInt8 = 10,
  UnsignedInt16 = 11,
  UnsignedInt32 = 12,
  HalfFloat = 13,
  Float = 14,
  UnormInt24 = 15,
  UnormInt101010_2 = 16,
  UnsignedIntRaw10EXT = 19,
  UnsignedIntRaw12EXT = 20,
  Max,
  Invalid = ~0U,
};

enum class FPRoundingMode : uint32_t
{
  RTE = 0,
  RTZ = 1,
  RTP = 2,
  RTN = 3,
  Max,
  Invalid = ~0U,
};

enum class FPDenormMode : uint32_t
{
  Preserve = 0,
  FlushToZero = 1,
  Max,
  Invalid = ~0U,
};

enum class QuantizationModes : uint32_t
{
  TRN = 0,
  TRN_ZERO = 1,
  RND = 2,
  RND_ZERO = 3,
  RND_INF = 4,
  RND_MIN_INF = 5,
  RND_CONV = 6,
  RND_CONV_ODD = 7,
  Max,
  Invalid = ~0U,
};

enum class FPOperationMode : uint32_t
{
  IEEE = 0,
  ALT = 1,
  Max,
  Invalid = ~0U,
};

enum class OverflowModes : uint32_t
{
  WRAP = 0,
  SAT = 1,
  SAT_ZERO = 2,
  SAT_SYM = 3,
  Max,
  Invalid = ~0U,
};

enum class LinkageType : uint32_t
{
  Export = 0,
  Import = 1,
  LinkOnceODR = 2,
  Max,
  Invalid = ~0U,
};

enum class AccessQualifier : uint32_t
{
  ReadOnly = 0,
  WriteOnly = 1,
  ReadWrite = 2,
  Max,
  Invalid = ~0U,
};

enum class HostAccessQualifier : uint32_t
{
  NoneINTEL = 0,
  ReadINTEL = 1,
  WriteINTEL = 2,
  ReadWriteINTEL = 3,
  Max,
  Invalid = ~0U,
};

enum class FunctionParameterAttribute : uint32_t
{
  Zext = 0,
  Sext = 1,
  ByVal = 2,
  Sret = 3,
  NoAlias = 4,
  NoCapture = 5,
  NoWrite = 6,
  NoReadWrite = 7,
  RuntimeAlignedINTEL = 5940,
  Max,
  Invalid = ~0U,
};

enum class Decoration : uint32_t
{
  RelaxedPrecision = 0,
  SpecId = 1,
  Block = 2,
  BufferBlock = 3,
  RowMajor = 4,
  ColMajor = 5,
  ArrayStride = 6,
  MatrixStride = 7,
  GLSLShared = 8,
  GLSLPacked = 9,
  CPacked = 10,
  BuiltIn = 11,
  NoPerspective = 13,
  Flat = 14,
  Patch = 15,
  Centroid = 16,
  Sample = 17,
  Invariant = 18,
  Restrict = 19,
  Aliased = 20,
  Volatile = 21,
  Constant = 22,
  Coherent = 23,
  NonWritable = 24,
  NonReadable = 25,
  Uniform = 26,
  UniformId = 27,
  SaturatedConversion = 28,
  Stream = 29,
  Location = 30,
  Component = 31,
  Index = 32,
  Binding = 33,
  DescriptorSet = 34,
  Offset = 35,
  XfbBuffer = 36,
  XfbStride = 37,
  FuncParamAttr = 38,
  FPRoundingMode = 39,
  FPFastMathMode = 40,
  LinkageAttributes = 41,
  NoContraction = 42,
  InputAttachmentIndex = 43,
  Alignment = 44,
  MaxByteOffset = 45,
  AlignmentId = 46,
  MaxByteOffsetId = 47,
  NoSignedWrap = 4469,
  NoUnsignedWrap = 4470,
  WeightTextureQCOM = 4487,
  BlockMatchTextureQCOM = 4488,
  BlockMatchSamplerQCOM = 4499,
  ExplicitInterpAMD = 4999,
  NodeSharesPayloadLimitsWithAMDX = 5019,
  NodeMaxPayloadsAMDX = 5020,
  TrackFinishWritingAMDX = 5078,
  PayloadNodeNameAMDX = 5091,
  OverrideCoverageNV = 5248,
  PassthroughNV = 5250,
  ViewportRelativeNV = 5252,
  SecondaryViewportRelativeNV = 5256,
  PerPrimitiveEXT = 5271,
  PerPrimitiveNV = 5271,
  PerViewNV = 5272,
  PerTaskNV = 5273,
  PerVertexKHR = 5285,
  PerVertexNV = 5285,
  NonUniform = 5300,
  NonUniformEXT = 5300,
  RestrictPointer = 5355,
  RestrictPointerEXT = 5355,
  AliasedPointer = 5356,
  AliasedPointerEXT = 5356,
  HitObjectShaderRecordBufferNV = 5386,
  BindlessSamplerNV = 5398,
  BindlessImageNV = 5399,
  BoundSamplerNV = 5400,
  BoundImageNV = 5401,
  SIMTCallINTEL = 5599,
  ReferencedIndirectlyINTEL = 5602,
  ClobberINTEL = 5607,
  SideEffectsINTEL = 5608,
  VectorComputeVariableINTEL = 5624,
  FuncParamIOKindINTEL = 5625,
  VectorComputeFunctionINTEL = 5626,
  StackCallINTEL = 5627,
  GlobalVariableOffsetINTEL = 5628,
  CounterBuffer = 5634,
  HlslCounterBufferGOOGLE = 5634,
  UserSemantic = 5635,
  HlslSemanticGOOGLE = 5635,
  UserTypeGOOGLE = 5636,
  FunctionRoundingModeINTEL = 5822,
  FunctionDenormModeINTEL = 5823,
  RegisterINTEL = 5825,
  MemoryINTEL = 5826,
  NumbanksINTEL = 5827,
  BankwidthINTEL = 5828,
  MaxPrivateCopiesINTEL = 5829,
  SinglepumpINTEL = 5830,
  DoublepumpINTEL = 5831,
  MaxReplicatesINTEL = 5832,
  SimpleDualPortINTEL = 5833,
  MergeINTEL = 5834,
  BankBitsINTEL = 5835,
  ForcePow2DepthINTEL = 5836,
  StridesizeINTEL = 5883,
  WordsizeINTEL = 5884,
  TrueDualPortINTEL = 5885,
  BurstCoalesceINTEL = 5899,
  CacheSizeINTEL = 5900,
  DontStaticallyCoalesceINTEL = 5901,
  PrefetchINTEL = 5902,
  StallEnableINTEL = 5905,
  FuseLoopsInFunctionINTEL = 5907,
  MathOpDSPModeINTEL = 5909,
  AliasScopeINTEL = 5914,
  NoAliasINTEL = 5915,
  InitiationIntervalINTEL = 5917,
  MaxConcurrencyINTEL = 5918,
  PipelineEnableINTEL = 5919,
  BufferLocationINTEL = 5921,
  IOPipeStorageINTEL = 5944,
  FunctionFloatingPointModeINTEL = 6080,
  SingleElementVectorINTEL = 6085,
  VectorComputeCallableFunctionINTEL = 6087,
  MediaBlockIOINTEL = 6140,
  StallFreeINTEL = 6151,
  FPMaxErrorDecorationINTEL = 6170,
  LatencyControlLabelINTEL = 6172,
  LatencyControlConstraintINTEL = 6173,
  ConduitKernelArgumentINTEL = 6175,
  RegisterMapKernelArgumentINTEL = 6176,
  MMHostInterfaceAddressWidthINTEL = 6177,
  MMHostInterfaceDataWidthINTEL = 6178,
  MMHostInterfaceLatencyINTEL = 6179,
  MMHostInterfaceReadWriteModeINTEL = 6180,
  MMHostInterfaceMaxBurstINTEL = 6181,
  MMHostInterfaceWaitRequestINTEL = 6182,
  StableKernelArgumentINTEL = 6183,
  HostAccessINTEL = 6188,
  InitModeINTEL = 6190,
  ImplementInRegisterMapINTEL = 6191,
  CacheControlLoadINTEL = 6442,
  CacheControlStoreINTEL = 6443,
  Max,
  Invalid = ~0U,
};

enum class BuiltIn : uint32_t
{
  Position = 0,
  PointSize = 1,
  ClipDistance = 3,
  CullDistance = 4,
  VertexId = 5,
  InstanceId = 6,
  PrimitiveId = 7,
  InvocationId = 8,
  Layer = 9,
  ViewportIndex = 10,
  TessLevelOuter = 11,
  TessLevelInner = 12,
  TessCoord = 13,
  PatchVertices = 14,
  FragCoord = 15,
  PointCoord = 16,
  FrontFacing = 17,
  SampleId = 18,
  SamplePosition = 19,
  SampleMask = 20,
  FragDepth = 22,
  HelperInvocation = 23,
  NumWorkgroups = 24,
  WorkgroupSize = 25,
  WorkgroupId = 26,
  LocalInvocationId = 27,
  GlobalInvocationId = 28,
  LocalInvocationIndex = 29,
  WorkDim = 30,
  GlobalSize = 31,
  EnqueuedWorkgroupSize = 32,
  GlobalOffset = 33,
  GlobalLinearId = 34,
  SubgroupSize = 36,
  SubgroupMaxSize = 37,
  NumSubgroups = 38,
  NumEnqueuedSubgroups = 39,
  SubgroupId = 40,
  SubgroupLocalInvocationId = 41,
  VertexIndex = 42,
  InstanceIndex = 43,
  CoreIDARM = 4160,
  CoreCountARM = 4161,
  CoreMaxIDARM = 4162,
  WarpIDARM = 4163,
  WarpMaxIDARM = 4164,
  SubgroupEqMask = 4416,
  SubgroupEqMaskKHR = 4416,
  SubgroupGeMask = 4417,
  SubgroupGeMaskKHR = 4417,
  SubgroupGtMask = 4418,
  SubgroupGtMaskKHR = 4418,
  SubgroupLeMask = 4419,
  SubgroupLeMaskKHR = 4419,
  SubgroupLtMask = 4420,
  SubgroupLtMaskKHR = 4420,
  BaseVertex = 4424,
  BaseInstance = 4425,
  DrawIndex = 4426,
  PrimitiveShadingRateKHR = 4432,
  DeviceIndex = 4438,
  ViewIndex = 4440,
  ShadingRateKHR = 4444,
  BaryCoordNoPerspAMD = 4992,
  BaryCoordNoPerspCentroidAMD = 4993,
  BaryCoordNoPerspSampleAMD = 4994,
  BaryCoordSmoothAMD = 4995,
  BaryCoordSmoothCentroidAMD = 4996,
  BaryCoordSmoothSampleAMD = 4997,
  BaryCoordPullModelAMD = 4998,
  FragStencilRefEXT = 5014,
  CoalescedInputCountAMDX = 5021,
  ShaderIndexAMDX = 5073,
  ViewportMaskNV = 5253,
  SecondaryPositionNV = 5257,
  SecondaryViewportMaskNV = 5258,
  PositionPerViewNV = 5261,
  ViewportMaskPerViewNV = 5262,
  FullyCoveredEXT = 5264,
  TaskCountNV = 5274,
  PrimitiveCountNV = 5275,
  PrimitiveIndicesNV = 5276,
  ClipDistancePerViewNV = 5277,
  CullDistancePerViewNV = 5278,
  LayerPerViewNV = 5279,
  MeshViewCountNV = 5280,
  MeshViewIndicesNV = 5281,
  BaryCoordKHR = 5286,
  BaryCoordNV = 5286,
  BaryCoordNoPerspKHR = 5287,
  BaryCoordNoPerspNV = 5287,
  FragSizeEXT = 5292,
  FragmentSizeNV = 5292,
  FragInvocationCountEXT = 5293,
  InvocationsPerPixelNV = 5293,
  PrimitivePointIndicesEXT = 5294,
  PrimitiveLineIndicesEXT = 5295,
  PrimitiveTriangleIndicesEXT = 5296,
  CullPrimitiveEXT = 5299,
  LaunchIdKHR = 5319,
  LaunchIdNV = 5319,
  LaunchSizeKHR = 5320,
  LaunchSizeNV = 5320,
  WorldRayOriginKHR = 5321,
  WorldRayOriginNV = 5321,
  WorldRayDirectionKHR = 5322,
  WorldRayDirectionNV = 5322,
  ObjectRayOriginKHR = 5323,
  ObjectRayOriginNV = 5323,
  ObjectRayDirectionKHR = 5324,
  ObjectRayDirectionNV = 5324,
  RayTminKHR = 5325,
  RayTminNV = 5325,
  RayTmaxKHR = 5326,
  RayTmaxNV = 5326,
  InstanceCustomIndexKHR = 5327,
  InstanceCustomIndexNV = 5327,
  ObjectToWorldKHR = 5330,
  ObjectToWorldNV = 5330,
  WorldToObjectKHR = 5331,
  WorldToObjectNV = 5331,
  HitTNV = 5332,
  HitKindKHR = 5333,
  HitKindNV = 5333,
  CurrentRayTimeNV = 5334,
  HitTriangleVertexPositionsKHR = 5335,
  HitMicroTriangleVertexPositionsNV = 5337,
  HitMicroTriangleVertexBarycentricsNV = 5344,
  IncomingRayFlagsKHR = 5351,
  IncomingRayFlagsNV = 5351,
  RayGeometryIndexKHR = 5352,
  WarpsPerSMNV = 5374,
  SMCountNV = 5375,
  WarpIDNV = 5376,
  SMIDNV = 5377,
  HitKindFrontFacingMicroTriangleNV = 5405,
  HitKindBackFacingMicroTriangleNV = 5406,
  CullMaskKHR = 6021,
  Max,
  Invalid = ~0U,
};

enum class Scope : uint32_t
{
  CrossDevice = 0,
  Device = 1,
  Workgroup = 2,
  Subgroup = 3,
  Invocation = 4,
  QueueFamily = 5,
  QueueFamilyKHR = 5,
  ShaderCallKHR = 6,
  Max,
  Invalid = ~0U,
};

enum class GroupOperation : uint32_t
{
  Reduce = 0,
  InclusiveScan = 1,
  ExclusiveScan = 2,
  ClusteredReduce = 3,
  PartitionedReduceNV = 6,
  PartitionedInclusiveScanNV = 7,
  PartitionedExclusiveScanNV = 8,
  Max,
  Invalid = ~0U,
};

enum class KernelEnqueueFlags : uint32_t
{
  NoWait = 0,
  WaitKernel = 1,
  WaitWorkGroup = 2,
  Max,
  Invalid = ~0U,
};

enum class Capability : uint32_t
{
  Matrix = 0,
  Shader = 1,
  Geometry = 2,
  Tessellation = 3,
  Addresses = 4,
  Linkage = 5,
  Kernel = 6,
  Vector16 = 7,
  Float16Buffer = 8,
  Float16 = 9,
  Float64 = 10,
  Int64 = 11,
  Int64Atomics = 12,
  ImageBasic = 13,
  ImageReadWrite = 14,
  ImageMipmap = 15,
  Pipes = 17,
  Groups = 18,
  DeviceEnqueue = 19,
  LiteralSampler = 20,
  AtomicStorage = 21,
  Int16 = 22,
  TessellationPointSize = 23,
  GeometryPointSize = 24,
  ImageGatherExtended = 25,
  StorageImageMultisample = 27,
  UniformBufferArrayDynamicIndexing = 28,
  SampledImageArrayDynamicIndexing = 29,
  StorageBufferArrayDynamicIndexing = 30,
  StorageImageArrayDynamicIndexing = 31,
  ClipDistance = 32,
  CullDistance = 33,
  ImageCubeArray = 34,
  SampleRateShading = 35,
  ImageRect = 36,
  SampledRect = 37,
  GenericPointer = 38,
  Int8 = 39,
  InputAttachment = 40,
  SparseResidency = 41,
  MinLod = 42,
  Sampled1D = 43,
  Image1D = 44,
  SampledCubeArray = 45,
  SampledBuffer = 46,
  ImageBuffer = 47,
  ImageMSArray = 48,
  StorageImageExtendedFormats = 49,
  ImageQuery = 50,
  DerivativeControl = 51,
  InterpolationFunction = 52,
  TransformFeedback = 53,
  GeometryStreams = 54,
  StorageImageReadWithoutFormat = 55,
  StorageImageWriteWithoutFormat = 56,
  MultiViewport = 57,
  SubgroupDispatch = 58,
  NamedBarrier = 59,
  PipeStorage = 60,
  GroupNonUniform = 61,
  GroupNonUniformVote = 62,
  GroupNonUniformArithmetic = 63,
  GroupNonUniformBallot = 64,
  GroupNonUniformShuffle = 65,
  GroupNonUniformShuffleRelative = 66,
  GroupNonUniformClustered = 67,
  GroupNonUniformQuad = 68,
  ShaderLayer = 69,
  ShaderViewportIndex = 70,
  UniformDecoration = 71,
  CoreBuiltinsARM = 4165,
  TileImageColorReadAccessEXT = 4166,
  TileImageDepthReadAccessEXT = 4167,
  TileImageStencilReadAccessEXT = 4168,
  CooperativeMatrixLayoutsARM = 4201,
  FragmentShadingRateKHR = 4422,
  SubgroupBallotKHR = 4423,
  DrawParameters = 4427,
  WorkgroupMemoryExplicitLayoutKHR = 4428,
  WorkgroupMemoryExplicitLayout8BitAccessKHR = 4429,
  WorkgroupMemoryExplicitLayout16BitAccessKHR = 4430,
  SubgroupVoteKHR = 4431,
  StorageBuffer16BitAccess = 4433,
  StorageUniformBufferBlock16 = 4433,
  UniformAndStorageBuffer16BitAccess = 4434,
  StorageUniform16 = 4434,
  StoragePushConstant16 = 4435,
  StorageInputOutput16 = 4436,
  DeviceGroup = 4437,
  MultiView = 4439,
  VariablePointersStorageBuffer = 4441,
  VariablePointers = 4442,
  AtomicStorageOps = 4445,
  SampleMaskPostDepthCoverage = 4447,
  StorageBuffer8BitAccess = 4448,
  UniformAndStorageBuffer8BitAccess = 4449,
  StoragePushConstant8 = 4450,
  DenormPreserve = 4464,
  DenormFlushToZero = 4465,
  SignedZeroInfNanPreserve = 4466,
  RoundingModeRTE = 4467,
  RoundingModeRTZ = 4468,
  RayQueryProvisionalKHR = 4471,
  RayQueryKHR = 4472,
  RayTraversalPrimitiveCullingKHR = 4478,
  RayTracingKHR = 4479,
  TextureSampleWeightedQCOM = 4484,
  TextureBoxFilterQCOM = 4485,
  TextureBlockMatchQCOM = 4486,
  TextureBlockMatch2QCOM = 4498,
  Float16ImageAMD = 5008,
  ImageGatherBiasLodAMD = 5009,
  FragmentMaskAMD = 5010,
  StencilExportEXT = 5013,
  ImageReadWriteLodAMD = 5015,
  Int64ImageEXT = 5016,
  ShaderClockKHR = 5055,
  ShaderEnqueueAMDX = 5067,
  QuadControlKHR = 5087,
  SampleMaskOverrideCoverageNV = 5249,
  GeometryShaderPassthroughNV = 5251,
  ShaderViewportIndexLayerEXT = 5254,
  ShaderViewportIndexLayerNV = 5254,
  ShaderViewportMaskNV = 5255,
  ShaderStereoViewNV = 5259,
  PerViewAttributesNV = 5260,
  FragmentFullyCoveredEXT = 5265,
  MeshShadingNV = 5266,
  ImageFootprintNV = 5282,
  MeshShadingEXT = 5283,
  FragmentBarycentricKHR = 5284,
  FragmentBarycentricNV = 5284,
  ComputeDerivativeGroupQuadsNV = 5288,
  FragmentDensityEXT = 5291,
  ShadingRateNV = 5291,
  GroupNonUniformPartitionedNV = 5297,
  ShaderNonUniform = 5301,
  ShaderNonUniformEXT = 5301,
  RuntimeDescriptorArray = 5302,
  RuntimeDescriptorArrayEXT = 5302,
  InputAttachmentArrayDynamicIndexing = 5303,
  InputAttachmentArrayDynamicIndexingEXT = 5303,
  UniformTexelBufferArrayDynamicIndexing = 5304,
  UniformTexelBufferArrayDynamicIndexingEXT = 5304,
  StorageTexelBufferArrayDynamicIndexing = 5305,
  StorageTexelBufferArrayDynamicIndexingEXT = 5305,
  UniformBufferArrayNonUniformIndexing = 5306,
  UniformBufferArrayNonUniformIndexingEXT = 5306,
  SampledImageArrayNonUniformIndexing = 5307,
  SampledImageArrayNonUniformIndexingEXT = 5307,
  StorageBufferArrayNonUniformIndexing = 5308,
  StorageBufferArrayNonUniformIndexingEXT = 5308,
  StorageImageArrayNonUniformIndexing = 5309,
  StorageImageArrayNonUniformIndexingEXT = 5309,
  InputAttachmentArrayNonUniformIndexing = 5310,
  InputAttachmentArrayNonUniformIndexingEXT = 5310,
  UniformTexelBufferArrayNonUniformIndexing = 5311,
  UniformTexelBufferArrayNonUniformIndexingEXT = 5311,
  StorageTexelBufferArrayNonUniformIndexing = 5312,
  StorageTexelBufferArrayNonUniformIndexingEXT = 5312,
  RayTracingPositionFetchKHR = 5336,
  RayTracingNV = 5340,
  RayTracingMotionBlurNV = 5341,
  VulkanMemoryModel = 5345,
  VulkanMemoryModelKHR = 5345,
  VulkanMemoryModelDeviceScope = 5346,
  VulkanMemoryModelDeviceScopeKHR = 5346,
  PhysicalStorageBufferAddresses = 5347,
  PhysicalStorageBufferAddressesEXT = 5347,
  ComputeDerivativeGroupLinearNV = 5350,
  RayTracingProvisionalKHR = 5353,
  CooperativeMatrixNV = 5357,
  FragmentShaderSampleInterlockEXT = 5363,
  FragmentShaderShadingRateInterlockEXT = 5372,
  ShaderSMBuiltinsNV = 5373,
  FragmentShaderPixelInterlockEXT = 5378,
  DemoteToHelperInvocation = 5379,
  DemoteToHelperInvocationEXT = 5379,
  DisplacementMicromapNV = 5380,
  RayTracingOpacityMicromapEXT = 5381,
  ShaderInvocationReorderNV = 5383,
  BindlessTextureNV = 5390,
  RayQueryPositionFetchKHR = 5391,
  AtomicFloat16VectorNV = 5404,
  RayTracingDisplacementMicromapNV = 5409,
  RawAccessChainsNV = 5414,
  SubgroupShuffleINTEL = 5568,
  SubgroupBufferBlockIOINTEL = 5569,
  SubgroupImageBlockIOINTEL = 5570,
  SubgroupImageMediaBlockIOINTEL = 5579,
  RoundToInfinityINTEL = 5582,
  FloatingPointModeINTEL = 5583,
  IntegerFunctions2INTEL = 5584,
  FunctionPointersINTEL = 5603,
  IndirectReferencesINTEL = 5604,
  AsmINTEL = 5606,
  AtomicFloat32MinMaxEXT = 5612,
  AtomicFloat64MinMaxEXT = 5613,
  AtomicFloat16MinMaxEXT = 5616,
  VectorComputeINTEL = 5617,
  VectorAnyINTEL = 5619,
  ExpectAssumeKHR = 5629,
  SubgroupAvcMotionEstimationINTEL = 5696,
  SubgroupAvcMotionEstimationIntraINTEL = 5697,
  SubgroupAvcMotionEstimationChromaINTEL = 5698,
  VariableLengthArrayINTEL = 5817,
  FunctionFloatControlINTEL = 5821,
  FPGAMemoryAttributesINTEL = 5824,
  FPFastMathModeINTEL = 5837,
  ArbitraryPrecisionIntegersINTEL = 5844,
  ArbitraryPrecisionFloatingPointINTEL = 5845,
  UnstructuredLoopControlsINTEL = 5886,
  FPGALoopControlsINTEL = 5888,
  KernelAttributesINTEL = 5892,
  FPGAKernelAttributesINTEL = 5897,
  FPGAMemoryAccessesINTEL = 5898,
  FPGAClusterAttributesINTEL = 5904,
  LoopFuseINTEL = 5906,
  FPGADSPControlINTEL = 5908,
  MemoryAccessAliasingINTEL = 5910,
  FPGAInvocationPipeliningAttributesINTEL = 5916,
  FPGABufferLocationINTEL = 5920,
  ArbitraryPrecisionFixedPointINTEL = 5922,
  USMStorageClassesINTEL = 5935,
  RuntimeAlignedAttributeINTEL = 5939,
  IOPipesINTEL = 5943,
  BlockingPipesINTEL = 5945,
  FPGARegINTEL = 5948,
  DotProductInputAll = 6016,
  DotProductInputAllKHR = 6016,
  DotProductInput4x8Bit = 6017,
  DotProductInput4x8BitKHR = 6017,
  DotProductInput4x8BitPacked = 6018,
  DotProductInput4x8BitPackedKHR = 6018,
  DotProduct = 6019,
  DotProductKHR = 6019,
  RayCullMaskKHR = 6020,
  CooperativeMatrixKHR = 6022,
  ReplicatedCompositesEXT = 6024,
  BitInstructions = 6025,
  GroupNonUniformRotateKHR = 6026,
  FloatControls2 = 6029,
  AtomicFloat32AddEXT = 6033,
  AtomicFloat64AddEXT = 6034,
  LongCompositesINTEL = 6089,
  OptNoneINTEL = 6094,
  AtomicFloat16AddEXT = 6095,
  DebugInfoModuleINTEL = 6114,
  BFloat16ConversionINTEL = 6115,
  SplitBarrierINTEL = 6141,
  FPGAClusterAttributesV2INTEL = 6150,
  FPGAKernelAttributesv2INTEL = 6161,
  FPMaxErrorINTEL = 6169,
  FPGALatencyControlINTEL = 6171,
  FPGAArgumentInterfacesINTEL = 6174,
  GlobalVariableHostAccessINTEL = 6187,
  GlobalVariableFPGADecorationsINTEL = 6189,
  GroupUniformArithmeticKHR = 6400,
  MaskedGatherScatterINTEL = 6427,
  CacheControlsINTEL = 6441,
  RegisterLimitsINTEL = 6460,
  Max,
  Invalid = ~0U,
};

enum class RayQueryIntersection : uint32_t
{
  RayQueryCandidateIntersectionKHR = 0,
  RayQueryCommittedIntersectionKHR = 1,
  Max,
  Invalid = ~0U,
};

enum class RayQueryCommittedIntersectionType : uint32_t
{
  RayQueryCommittedIntersectionNoneKHR = 0,
  RayQueryCommittedIntersectionTriangleKHR = 1,
  RayQueryCommittedIntersectionGeneratedKHR = 2,
  Max,
  Invalid = ~0U,
};

enum class RayQueryCandidateIntersectionType : uint32_t
{
  RayQueryCandidateIntersectionTriangleKHR = 0,
  RayQueryCandidateIntersectionAABBKHR = 1,
  Max,
  Invalid = ~0U,
};

enum class PackedVectorFormat : uint32_t
{
  PackedVectorFormat4x8Bit = 0,
  PackedVectorFormat4x8BitKHR = 0,
  Max,
  Invalid = ~0U,
};

enum class CooperativeMatrixOperands : uint32_t
{
  NoneKHR = 0x0000,
  MatrixASignedComponentsKHR = 0x0001,
  MatrixBSignedComponentsKHR = 0x0002,
  MatrixCSignedComponentsKHR = 0x0004,
  MatrixResultSignedComponentsKHR = 0x0008,
  SaturatingAccumulationKHR = 0x0010,
  Max,
  Invalid = ~0U,
};

BITMASK_OPERATORS(CooperativeMatrixOperands);

enum class CooperativeMatrixLayout : uint32_t
{
  RowMajorKHR = 0,
  ColumnMajorKHR = 1,
  RowBlockedInterleavedARM = 4202,
  ColumnBlockedInterleavedARM = 4203,
  Max,
  Invalid = ~0U,
};

enum class CooperativeMatrixUse : uint32_t
{
  MatrixAKHR = 0,
  MatrixBKHR = 1,
  MatrixAccumulatorKHR = 2,
  Max,
  Invalid = ~0U,
};

enum class InitializationModeQualifier : uint32_t
{
  InitOnDeviceReprogramINTEL = 0,
  InitOnDeviceResetINTEL = 1,
  Max,
  Invalid = ~0U,
};

enum class LoadCacheControl : uint32_t
{
  UncachedINTEL = 0,
  CachedINTEL = 1,
  StreamingINTEL = 2,
  InvalidateAfterReadINTEL = 3,
  ConstCachedINTEL = 4,
  Max,
  Invalid = ~0U,
};

enum class StoreCacheControl : uint32_t
{
  UncachedINTEL = 0,
  WriteThroughINTEL = 1,
  WriteBackINTEL = 2,
  StreamingINTEL = 3,
  Max,
  Invalid = ~0U,
};

enum class NamedMaximumNumberOfRegisters : uint32_t
{
  AutoINTEL = 0,
  Max,
  Invalid = ~0U,
};

using IdResultType = Id;

using IdResult = Id;

using IdMemorySemantics = Id;

using IdScope = Id;

struct GradParams
{
  Id first;
  Id second;
};

struct ImageOperandsAndParamDatas
{
  ImageOperandsAndParamDatas(ImageOperands f = ImageOperands::None) : flags(f) {}
  ImageOperands flags;
  Id bias;
  Id lod;
  GradParams grad;
  Id constOffset;
  Id offset;
  Id constOffsets;
  Id sample;
  Id minLod;
  IdScope makeTexelAvailable;
  IdScope makeTexelAvailableKHR;
  IdScope makeTexelVisible;
  IdScope makeTexelVisibleKHR;
  Id offsets;
  
  operator ImageOperands() const { return flags; }
  bool operator &(const ImageOperands v) const { return bool(flags & v); }
  void setNone() { flags |= ImageOperands::None; }
  void unsetNone() { flags &= ~ImageOperands::None; }
  void setBias(Id biasParam) { flags |= ImageOperands::Bias; bias = biasParam; }
  void unsetBias() { flags &= ~ImageOperands::Bias; }
  void setLod(Id lodParam) { flags |= ImageOperands::Lod; lod = lodParam; }
  void unsetLod() { flags &= ~ImageOperands::Lod; }
  void setGrad(Id first, Id second) { flags |= ImageOperands::Grad; grad.first = first; grad.second = second; }
  void unsetGrad() { flags &= ~ImageOperands::Grad; }
  void setConstOffset(Id constOffsetParam) { flags |= ImageOperands::ConstOffset; constOffset = constOffsetParam; }
  void unsetConstOffset() { flags &= ~ImageOperands::ConstOffset; }
  void setOffset(Id offsetParam) { flags |= ImageOperands::Offset; offset = offsetParam; }
  void unsetOffset() { flags &= ~ImageOperands::Offset; }
  void setConstOffsets(Id constOffsetsParam) { flags |= ImageOperands::ConstOffsets; constOffsets = constOffsetsParam; }
  void unsetConstOffsets() { flags &= ~ImageOperands::ConstOffsets; }
  void setSample(Id sampleParam) { flags |= ImageOperands::Sample; sample = sampleParam; }
  void unsetSample() { flags &= ~ImageOperands::Sample; }
  void setMinLod(Id minLodParam) { flags |= ImageOperands::MinLod; minLod = minLodParam; }
  void unsetMinLod() { flags &= ~ImageOperands::MinLod; }
  void setMakeTexelAvailable(IdScope makeTexelAvailableParam) { flags |= ImageOperands::MakeTexelAvailable; makeTexelAvailable = makeTexelAvailableParam; }
  void unsetMakeTexelAvailable() { flags &= ~ImageOperands::MakeTexelAvailable; }
  void setMakeTexelAvailableKHR(IdScope makeTexelAvailableKHRParam) { flags |= ImageOperands::MakeTexelAvailableKHR; makeTexelAvailableKHR = makeTexelAvailableKHRParam; }
  void unsetMakeTexelAvailableKHR() { flags &= ~ImageOperands::MakeTexelAvailableKHR; }
  void setMakeTexelVisible(IdScope makeTexelVisibleParam) { flags |= ImageOperands::MakeTexelVisible; makeTexelVisible = makeTexelVisibleParam; }
  void unsetMakeTexelVisible() { flags &= ~ImageOperands::MakeTexelVisible; }
  void setMakeTexelVisibleKHR(IdScope makeTexelVisibleKHRParam) { flags |= ImageOperands::MakeTexelVisibleKHR; makeTexelVisibleKHR = makeTexelVisibleKHRParam; }
  void unsetMakeTexelVisibleKHR() { flags &= ~ImageOperands::MakeTexelVisibleKHR; }
  void setNonPrivateTexel() { flags |= ImageOperands::NonPrivateTexel; }
  void unsetNonPrivateTexel() { flags &= ~ImageOperands::NonPrivateTexel; }
  void setNonPrivateTexelKHR() { flags |= ImageOperands::NonPrivateTexelKHR; }
  void unsetNonPrivateTexelKHR() { flags &= ~ImageOperands::NonPrivateTexelKHR; }
  void setVolatileTexel() { flags |= ImageOperands::VolatileTexel; }
  void unsetVolatileTexel() { flags &= ~ImageOperands::VolatileTexel; }
  void setVolatileTexelKHR() { flags |= ImageOperands::VolatileTexelKHR; }
  void unsetVolatileTexelKHR() { flags &= ~ImageOperands::VolatileTexelKHR; }
  void setSignExtend() { flags |= ImageOperands::SignExtend; }
  void unsetSignExtend() { flags &= ~ImageOperands::SignExtend; }
  void setZeroExtend() { flags |= ImageOperands::ZeroExtend; }
  void unsetZeroExtend() { flags &= ~ImageOperands::ZeroExtend; }
  void setNontemporal() { flags |= ImageOperands::Nontemporal; }
  void unsetNontemporal() { flags &= ~ImageOperands::Nontemporal; }
  void setOffsets(Id offsetsParam) { flags |= ImageOperands::Offsets; offsets = offsetsParam; }
  void unsetOffsets() { flags &= ~ImageOperands::Offsets; }
};

struct LoopControlAndParamDatas
{
  LoopControlAndParamDatas(LoopControl f = LoopControl::None) : flags(f) {}
  LoopControl flags;
  uint32_t dependencyLength;
  uint32_t minIterations;
  uint32_t maxIterations;
  uint32_t iterationMultiple;
  uint32_t peelCount;
  uint32_t partialCount;
  uint32_t initiationIntervalINTEL;
  uint32_t maxConcurrencyINTEL;
  uint32_t dependencyArrayINTEL;
  uint32_t pipelineEnableINTEL;
  uint32_t loopCoalesceINTEL;
  uint32_t maxInterleavingINTEL;
  uint32_t speculatedIterationsINTEL;
  uint32_t loopCountINTEL;
  uint32_t maxReinvocationDelayINTEL;
  
  operator LoopControl() const { return flags; }
  bool operator &(const LoopControl v) const { return bool(flags & v); }
  void setNone() { flags |= LoopControl::None; }
  void unsetNone() { flags &= ~LoopControl::None; }
  void setUnroll() { flags |= LoopControl::Unroll; }
  void unsetUnroll() { flags &= ~LoopControl::Unroll; }
  void setDontUnroll() { flags |= LoopControl::DontUnroll; }
  void unsetDontUnroll() { flags &= ~LoopControl::DontUnroll; }
  void setDependencyInfinite() { flags |= LoopControl::DependencyInfinite; }
  void unsetDependencyInfinite() { flags &= ~LoopControl::DependencyInfinite; }
  void setDependencyLength(uint32_t dependencyLengthParam) { flags |= LoopControl::DependencyLength; dependencyLength = dependencyLengthParam; }
  void unsetDependencyLength() { flags &= ~LoopControl::DependencyLength; }
  void setMinIterations(uint32_t minIterationsParam) { flags |= LoopControl::MinIterations; minIterations = minIterationsParam; }
  void unsetMinIterations() { flags &= ~LoopControl::MinIterations; }
  void setMaxIterations(uint32_t maxIterationsParam) { flags |= LoopControl::MaxIterations; maxIterations = maxIterationsParam; }
  void unsetMaxIterations() { flags &= ~LoopControl::MaxIterations; }
  void setIterationMultiple(uint32_t iterationMultipleParam) { flags |= LoopControl::IterationMultiple; iterationMultiple = iterationMultipleParam; }
  void unsetIterationMultiple() { flags &= ~LoopControl::IterationMultiple; }
  void setPeelCount(uint32_t peelCountParam) { flags |= LoopControl::PeelCount; peelCount = peelCountParam; }
  void unsetPeelCount() { flags &= ~LoopControl::PeelCount; }
  void setPartialCount(uint32_t partialCountParam) { flags |= LoopControl::PartialCount; partialCount = partialCountParam; }
  void unsetPartialCount() { flags &= ~LoopControl::PartialCount; }
  void setInitiationIntervalINTEL(uint32_t initiationIntervalINTELParam) { flags |= LoopControl::InitiationIntervalINTEL; initiationIntervalINTEL = initiationIntervalINTELParam; }
  void unsetInitiationIntervalINTEL() { flags &= ~LoopControl::InitiationIntervalINTEL; }
  void setMaxConcurrencyINTEL(uint32_t maxConcurrencyINTELParam) { flags |= LoopControl::MaxConcurrencyINTEL; maxConcurrencyINTEL = maxConcurrencyINTELParam; }
  void unsetMaxConcurrencyINTEL() { flags &= ~LoopControl::MaxConcurrencyINTEL; }
  void setDependencyArrayINTEL(uint32_t dependencyArrayINTELParam) { flags |= LoopControl::DependencyArrayINTEL; dependencyArrayINTEL = dependencyArrayINTELParam; }
  void unsetDependencyArrayINTEL() { flags &= ~LoopControl::DependencyArrayINTEL; }
  void setPipelineEnableINTEL(uint32_t pipelineEnableINTELParam) { flags |= LoopControl::PipelineEnableINTEL; pipelineEnableINTEL = pipelineEnableINTELParam; }
  void unsetPipelineEnableINTEL() { flags &= ~LoopControl::PipelineEnableINTEL; }
  void setLoopCoalesceINTEL(uint32_t loopCoalesceINTELParam) { flags |= LoopControl::LoopCoalesceINTEL; loopCoalesceINTEL = loopCoalesceINTELParam; }
  void unsetLoopCoalesceINTEL() { flags &= ~LoopControl::LoopCoalesceINTEL; }
  void setMaxInterleavingINTEL(uint32_t maxInterleavingINTELParam) { flags |= LoopControl::MaxInterleavingINTEL; maxInterleavingINTEL = maxInterleavingINTELParam; }
  void unsetMaxInterleavingINTEL() { flags &= ~LoopControl::MaxInterleavingINTEL; }
  void setSpeculatedIterationsINTEL(uint32_t speculatedIterationsINTELParam) { flags |= LoopControl::SpeculatedIterationsINTEL; speculatedIterationsINTEL = speculatedIterationsINTELParam; }
  void unsetSpeculatedIterationsINTEL() { flags &= ~LoopControl::SpeculatedIterationsINTEL; }
  void setNoFusionINTEL() { flags |= LoopControl::NoFusionINTEL; }
  void unsetNoFusionINTEL() { flags &= ~LoopControl::NoFusionINTEL; }
  void setLoopCountINTEL(uint32_t loopCountINTELParam) { flags |= LoopControl::LoopCountINTEL; loopCountINTEL = loopCountINTELParam; }
  void unsetLoopCountINTEL() { flags &= ~LoopControl::LoopCountINTEL; }
  void setMaxReinvocationDelayINTEL(uint32_t maxReinvocationDelayINTELParam) { flags |= LoopControl::MaxReinvocationDelayINTEL; maxReinvocationDelayINTEL = maxReinvocationDelayINTELParam; }
  void unsetMaxReinvocationDelayINTEL() { flags &= ~LoopControl::MaxReinvocationDelayINTEL; }
};

struct MemoryAccessAndParamDatas
{
  MemoryAccessAndParamDatas(MemoryAccess f = MemoryAccess::None) : flags(f) {}
  MemoryAccess flags;
  uint32_t aligned;
  IdScope makePointerAvailable;
  IdScope makePointerAvailableKHR;
  IdScope makePointerVisible;
  IdScope makePointerVisibleKHR;
  Id aliasScopeINTELMask;
  Id noAliasINTELMask;
  
  operator MemoryAccess() const { return flags; }
  bool operator &(const MemoryAccess v) const { return bool(flags & v); }
  void setNone() { flags |= MemoryAccess::None; }
  void unsetNone() { flags &= ~MemoryAccess::None; }
  void setVolatile() { flags |= MemoryAccess::Volatile; }
  void unsetVolatile() { flags &= ~MemoryAccess::Volatile; }
  void setAligned(uint32_t alignedParam) { flags |= MemoryAccess::Aligned; aligned = alignedParam; }
  void unsetAligned() { flags &= ~MemoryAccess::Aligned; }
  void setNontemporal() { flags |= MemoryAccess::Nontemporal; }
  void unsetNontemporal() { flags &= ~MemoryAccess::Nontemporal; }
  void setMakePointerAvailable(IdScope makePointerAvailableParam) { flags |= MemoryAccess::MakePointerAvailable; makePointerAvailable = makePointerAvailableParam; }
  void unsetMakePointerAvailable() { flags &= ~MemoryAccess::MakePointerAvailable; }
  void setMakePointerAvailableKHR(IdScope makePointerAvailableKHRParam) { flags |= MemoryAccess::MakePointerAvailableKHR; makePointerAvailableKHR = makePointerAvailableKHRParam; }
  void unsetMakePointerAvailableKHR() { flags &= ~MemoryAccess::MakePointerAvailableKHR; }
  void setMakePointerVisible(IdScope makePointerVisibleParam) { flags |= MemoryAccess::MakePointerVisible; makePointerVisible = makePointerVisibleParam; }
  void unsetMakePointerVisible() { flags &= ~MemoryAccess::MakePointerVisible; }
  void setMakePointerVisibleKHR(IdScope makePointerVisibleKHRParam) { flags |= MemoryAccess::MakePointerVisibleKHR; makePointerVisibleKHR = makePointerVisibleKHRParam; }
  void unsetMakePointerVisibleKHR() { flags &= ~MemoryAccess::MakePointerVisibleKHR; }
  void setNonPrivatePointer() { flags |= MemoryAccess::NonPrivatePointer; }
  void unsetNonPrivatePointer() { flags &= ~MemoryAccess::NonPrivatePointer; }
  void setNonPrivatePointerKHR() { flags |= MemoryAccess::NonPrivatePointerKHR; }
  void unsetNonPrivatePointerKHR() { flags &= ~MemoryAccess::NonPrivatePointerKHR; }
  void setAliasScopeINTELMask(Id aliasScopeINTELMaskParam) { flags |= MemoryAccess::AliasScopeINTELMask; aliasScopeINTELMask = aliasScopeINTELMaskParam; }
  void unsetAliasScopeINTELMask() { flags &= ~MemoryAccess::AliasScopeINTELMask; }
  void setNoAliasINTELMask(Id noAliasINTELMaskParam) { flags |= MemoryAccess::NoAliasINTELMask; noAliasINTELMask = noAliasINTELMaskParam; }
  void unsetNoAliasINTELMask() { flags &= ~MemoryAccess::NoAliasINTELMask; }
};

struct LocalSizeParams
{
  uint32_t xsize;
  uint32_t ysize;
  uint32_t zsize;
};

struct LocalSizeHintParams
{
  uint32_t xsize;
  uint32_t ysize;
  uint32_t zsize;
};

struct LocalSizeIdParams
{
  Id xsize;
  Id ysize;
  Id zsize;
};

struct LocalSizeHintIdParams
{
  Id xsizehint;
  Id ysizehint;
  Id zsizehint;
};

struct StaticNumWorkgroupsAMDXParams
{
  Id xsize;
  Id ysize;
  Id zsize;
};

struct MaxNumWorkgroupsAMDXParams
{
  Id xsize;
  Id ysize;
  Id zsize;
};

struct MaxWorkgroupSizeINTELParams
{
  uint32_t max_x_size;
  uint32_t max_y_size;
  uint32_t max_z_size;
};

struct FPFastMathDefaultParams
{
  Id targetType;
  Id fastMathMode;
};

struct ExecutionModeAndParamData
{
  ExecutionModeAndParamData(ExecutionMode v = ExecutionMode::Invalid) : value(v) {}
  ExecutionMode value;
  union
  {
    uint32_t invocations;
    LocalSizeParams localSize;
    LocalSizeHintParams localSizeHint;
    uint32_t outputVertices;
    uint32_t vecTypeHint;
    uint32_t subgroupSize;
    uint32_t subgroupsPerWorkgroup;
    Id subgroupsPerWorkgroupId;
    LocalSizeIdParams localSizeId;
    LocalSizeHintIdParams localSizeHintId;
    uint32_t denormPreserve;
    uint32_t denormFlushToZero;
    uint32_t signedZeroInfNanPreserve;
    uint32_t roundingModeRTE;
    uint32_t roundingModeRTZ;
    Id maxNodeRecursionAMDX;
    StaticNumWorkgroupsAMDXParams staticNumWorkgroupsAMDX;
    Id shaderIndexAMDX;
    MaxNumWorkgroupsAMDXParams maxNumWorkgroupsAMDX;
    uint32_t outputPrimitivesEXT;
    uint32_t outputPrimitivesNV;
    uint32_t sharedLocalMemorySizeINTEL;
    uint32_t roundingModeRTPINTEL;
    uint32_t roundingModeRTNINTEL;
    uint32_t floatingPointModeALTINTEL;
    uint32_t floatingPointModeIEEEINTEL;
    MaxWorkgroupSizeINTELParams maxWorkgroupSizeINTEL;
    uint32_t maxWorkDimINTEL;
    uint32_t numSIMDWorkitemsINTEL;
    uint32_t schedulerTargetFmaxMhzINTEL;
    FPFastMathDefaultParams fPFastMathDefault;
    uint32_t streamingInterfaceINTEL;
    uint32_t registerMapInterfaceINTEL;
    uint32_t namedBarrierCountINTEL;
    uint32_t maximumRegistersINTEL;
    Id maximumRegistersIdINTEL;
    NamedMaximumNumberOfRegisters namedMaximumRegistersINTEL;
  };
  
  operator ExecutionMode() const { return value; }
  bool operator ==(const ExecutionMode v) const { return value == v; }
};

struct FunctionRoundingModeINTELParams
{
  uint32_t targetWidth;
  FPRoundingMode fPRoundingMode;
};

struct FunctionDenormModeINTELParams
{
  uint32_t targetWidth;
  FPDenormMode fPDenormMode;
};

struct MathOpDSPModeINTELParams
{
  uint32_t mode;
  uint32_t propagate;
};

struct FunctionFloatingPointModeINTELParams
{
  uint32_t targetWidth;
  FPOperationMode fPOperationMode;
};

struct LatencyControlConstraintINTELParams
{
  uint32_t relativeTo;
  uint32_t controlType;
  uint32_t relativeCycle;
};

struct CacheControlLoadINTELParams
{
  uint32_t cacheLevel;
  LoadCacheControl cacheControl;
};

struct CacheControlStoreINTELParams
{
  uint32_t cacheLevel;
  StoreCacheControl cacheControl;
};

struct DecorationAndParamData
{
  DecorationAndParamData(Decoration v = Decoration::Invalid) : value(v) {}
  Decoration value;
  union
  {
    uint32_t specId;
    uint32_t arrayStride;
    uint32_t matrixStride;
    BuiltIn builtIn;
    IdScope uniformId;
    uint32_t stream;
    uint32_t location;
    uint32_t component;
    uint32_t index;
    uint32_t binding;
    uint32_t descriptorSet;
    uint32_t offset;
    uint32_t xfbBuffer;
    uint32_t xfbStride;
    FunctionParameterAttribute funcParamAttr;
    FPRoundingMode fPRoundingMode;
    FPFastMathMode fPFastMathMode;
    uint32_t inputAttachmentIndex;
    uint32_t alignment;
    uint32_t maxByteOffset;
    Id alignmentId;
    Id maxByteOffsetId;
    Id nodeSharesPayloadLimitsWithAMDX;
    Id nodeMaxPayloadsAMDX;
    uint32_t secondaryViewportRelativeNV;
    uint32_t sIMTCallINTEL;
    uint32_t funcParamIOKindINTEL;
    uint32_t globalVariableOffsetINTEL;
    Id counterBuffer;
    Id hlslCounterBufferGOOGLE;
    FunctionRoundingModeINTELParams functionRoundingModeINTEL;
    FunctionDenormModeINTELParams functionDenormModeINTEL;
    uint32_t numbanksINTEL;
    uint32_t bankwidthINTEL;
    uint32_t maxPrivateCopiesINTEL;
    uint32_t maxReplicatesINTEL;
    uint32_t bankBitsINTEL;
    uint32_t forcePow2DepthINTEL;
    uint32_t stridesizeINTEL;
    uint32_t wordsizeINTEL;
    uint32_t cacheSizeINTEL;
    uint32_t prefetchINTEL;
    MathOpDSPModeINTELParams mathOpDSPModeINTEL;
    Id aliasScopeINTEL;
    Id noAliasINTEL;
    uint32_t initiationIntervalINTEL;
    uint32_t maxConcurrencyINTEL;
    uint32_t pipelineEnableINTEL;
    uint32_t bufferLocationINTEL;
    uint32_t iOPipeStorageINTEL;
    FunctionFloatingPointModeINTELParams functionFloatingPointModeINTEL;
    float fPMaxErrorDecorationINTEL;
    uint32_t latencyControlLabelINTEL;
    LatencyControlConstraintINTELParams latencyControlConstraintINTEL;
    uint32_t mMHostInterfaceAddressWidthINTEL;
    uint32_t mMHostInterfaceDataWidthINTEL;
    uint32_t mMHostInterfaceLatencyINTEL;
    AccessQualifier mMHostInterfaceReadWriteModeINTEL;
    uint32_t mMHostInterfaceMaxBurstINTEL;
    uint32_t mMHostInterfaceWaitRequestINTEL;
    InitializationModeQualifier initModeINTEL;
    uint32_t implementInRegisterMapINTEL;
    CacheControlLoadINTELParams cacheControlLoadINTEL;
    CacheControlStoreINTELParams cacheControlStoreINTEL;
  };
  
  operator Decoration() const { return value; }
  bool operator ==(const Decoration v) const { return value == v; }
};

enum class Op : uint16_t
{
  Nop = 0,
  Undef = 1,
  SourceContinued = 2,
  Source = 3,
  SourceExtension = 4,
  Name = 5,
  MemberName = 6,
  String = 7,
  Line = 8,
  Extension = 10,
  ExtInstImport = 11,
  ExtInst = 12,
  MemoryModel = 14,
  EntryPoint = 15,
  ExecutionMode = 16,
  Capability = 17,
  TypeVoid = 19,
  TypeBool = 20,
  TypeInt = 21,
  TypeFloat = 22,
  TypeVector = 23,
  TypeMatrix = 24,
  TypeImage = 25,
  TypeSampler = 26,
  TypeSampledImage = 27,
  TypeArray = 28,
  TypeRuntimeArray = 29,
  TypeStruct = 30,
  TypeOpaque = 31,
  TypePointer = 32,
  TypeFunction = 33,
  TypeEvent = 34,
  TypeDeviceEvent = 35,
  TypeReserveId = 36,
  TypeQueue = 37,
  TypePipe = 38,
  TypeForwardPointer = 39,
  ConstantTrue = 41,
  ConstantFalse = 42,
  Constant = 43,
  ConstantComposite = 44,
  ConstantSampler = 45,
  ConstantNull = 46,
  SpecConstantTrue = 48,
  SpecConstantFalse = 49,
  SpecConstant = 50,
  SpecConstantComposite = 51,
  SpecConstantOp = 52,
  Function = 54,
  FunctionParameter = 55,
  FunctionEnd = 56,
  FunctionCall = 57,
  Variable = 59,
  ImageTexelPointer = 60,
  Load = 61,
  Store = 62,
  CopyMemory = 63,
  CopyMemorySized = 64,
  AccessChain = 65,
  InBoundsAccessChain = 66,
  PtrAccessChain = 67,
  ArrayLength = 68,
  GenericPtrMemSemantics = 69,
  InBoundsPtrAccessChain = 70,
  Decorate = 71,
  MemberDecorate = 72,
  DecorationGroup = 73,
  GroupDecorate = 74,
  GroupMemberDecorate = 75,
  VectorExtractDynamic = 77,
  VectorInsertDynamic = 78,
  VectorShuffle = 79,
  CompositeConstruct = 80,
  CompositeExtract = 81,
  CompositeInsert = 82,
  CopyObject = 83,
  Transpose = 84,
  SampledImage = 86,
  ImageSampleImplicitLod = 87,
  ImageSampleExplicitLod = 88,
  ImageSampleDrefImplicitLod = 89,
  ImageSampleDrefExplicitLod = 90,
  ImageSampleProjImplicitLod = 91,
  ImageSampleProjExplicitLod = 92,
  ImageSampleProjDrefImplicitLod = 93,
  ImageSampleProjDrefExplicitLod = 94,
  ImageFetch = 95,
  ImageGather = 96,
  ImageDrefGather = 97,
  ImageRead = 98,
  ImageWrite = 99,
  Image = 100,
  ImageQueryFormat = 101,
  ImageQueryOrder = 102,
  ImageQuerySizeLod = 103,
  ImageQuerySize = 104,
  ImageQueryLod = 105,
  ImageQueryLevels = 106,
  ImageQuerySamples = 107,
  ConvertFToU = 109,
  ConvertFToS = 110,
  ConvertSToF = 111,
  ConvertUToF = 112,
  UConvert = 113,
  SConvert = 114,
  FConvert = 115,
  QuantizeToF16 = 116,
  ConvertPtrToU = 117,
  SatConvertSToU = 118,
  SatConvertUToS = 119,
  ConvertUToPtr = 120,
  PtrCastToGeneric = 121,
  GenericCastToPtr = 122,
  GenericCastToPtrExplicit = 123,
  Bitcast = 124,
  SNegate = 126,
  FNegate = 127,
  IAdd = 128,
  FAdd = 129,
  ISub = 130,
  FSub = 131,
  IMul = 132,
  FMul = 133,
  UDiv = 134,
  SDiv = 135,
  FDiv = 136,
  UMod = 137,
  SRem = 138,
  SMod = 139,
  FRem = 140,
  FMod = 141,
  VectorTimesScalar = 142,
  MatrixTimesScalar = 143,
  VectorTimesMatrix = 144,
  MatrixTimesVector = 145,
  MatrixTimesMatrix = 146,
  OuterProduct = 147,
  Dot = 148,
  IAddCarry = 149,
  ISubBorrow = 150,
  UMulExtended = 151,
  SMulExtended = 152,
  Any = 154,
  All = 155,
  IsNan = 156,
  IsInf = 157,
  IsFinite = 158,
  IsNormal = 159,
  SignBitSet = 160,
  LessOrGreater = 161,
  Ordered = 162,
  Unordered = 163,
  LogicalEqual = 164,
  LogicalNotEqual = 165,
  LogicalOr = 166,
  LogicalAnd = 167,
  LogicalNot = 168,
  Select = 169,
  IEqual = 170,
  INotEqual = 171,
  UGreaterThan = 172,
  SGreaterThan = 173,
  UGreaterThanEqual = 174,
  SGreaterThanEqual = 175,
  ULessThan = 176,
  SLessThan = 177,
  ULessThanEqual = 178,
  SLessThanEqual = 179,
  FOrdEqual = 180,
  FUnordEqual = 181,
  FOrdNotEqual = 182,
  FUnordNotEqual = 183,
  FOrdLessThan = 184,
  FUnordLessThan = 185,
  FOrdGreaterThan = 186,
  FUnordGreaterThan = 187,
  FOrdLessThanEqual = 188,
  FUnordLessThanEqual = 189,
  FOrdGreaterThanEqual = 190,
  FUnordGreaterThanEqual = 191,
  ShiftRightLogical = 194,
  ShiftRightArithmetic = 195,
  ShiftLeftLogical = 196,
  BitwiseOr = 197,
  BitwiseXor = 198,
  BitwiseAnd = 199,
  Not = 200,
  BitFieldInsert = 201,
  BitFieldSExtract = 202,
  BitFieldUExtract = 203,
  BitReverse = 204,
  BitCount = 205,
  DPdx = 207,
  DPdy = 208,
  Fwidth = 209,
  DPdxFine = 210,
  DPdyFine = 211,
  FwidthFine = 212,
  DPdxCoarse = 213,
  DPdyCoarse = 214,
  FwidthCoarse = 215,
  EmitVertex = 218,
  EndPrimitive = 219,
  EmitStreamVertex = 220,
  EndStreamPrimitive = 221,
  ControlBarrier = 224,
  MemoryBarrier = 225,
  AtomicLoad = 227,
  AtomicStore = 228,
  AtomicExchange = 229,
  AtomicCompareExchange = 230,
  AtomicCompareExchangeWeak = 231,
  AtomicIIncrement = 232,
  AtomicIDecrement = 233,
  AtomicIAdd = 234,
  AtomicISub = 235,
  AtomicSMin = 236,
  AtomicUMin = 237,
  AtomicSMax = 238,
  AtomicUMax = 239,
  AtomicAnd = 240,
  AtomicOr = 241,
  AtomicXor = 242,
  Phi = 245,
  LoopMerge = 246,
  SelectionMerge = 247,
  Label = 248,
  Branch = 249,
  BranchConditional = 250,
  Switch = 251,
  Kill = 252,
  Return = 253,
  ReturnValue = 254,
  Unreachable = 255,
  LifetimeStart = 256,
  LifetimeStop = 257,
  GroupAsyncCopy = 259,
  GroupWaitEvents = 260,
  GroupAll = 261,
  GroupAny = 262,
  GroupBroadcast = 263,
  GroupIAdd = 264,
  GroupFAdd = 265,
  GroupFMin = 266,
  GroupUMin = 267,
  GroupSMin = 268,
  GroupFMax = 269,
  GroupUMax = 270,
  GroupSMax = 271,
  ReadPipe = 274,
  WritePipe = 275,
  ReservedReadPipe = 276,
  ReservedWritePipe = 277,
  ReserveReadPipePackets = 278,
  ReserveWritePipePackets = 279,
  CommitReadPipe = 280,
  CommitWritePipe = 281,
  IsValidReserveId = 282,
  GetNumPipePackets = 283,
  GetMaxPipePackets = 284,
  GroupReserveReadPipePackets = 285,
  GroupReserveWritePipePackets = 286,
  GroupCommitReadPipe = 287,
  GroupCommitWritePipe = 288,
  EnqueueMarker = 291,
  EnqueueKernel = 292,
  GetKernelNDrangeSubGroupCount = 293,
  GetKernelNDrangeMaxSubGroupSize = 294,
  GetKernelWorkGroupSize = 295,
  GetKernelPreferredWorkGroupSizeMultiple = 296,
  RetainEvent = 297,
  ReleaseEvent = 298,
  CreateUserEvent = 299,
  IsValidEvent = 300,
  SetUserEventStatus = 301,
  CaptureEventProfilingInfo = 302,
  GetDefaultQueue = 303,
  BuildNDRange = 304,
  ImageSparseSampleImplicitLod = 305,
  ImageSparseSampleExplicitLod = 306,
  ImageSparseSampleDrefImplicitLod = 307,
  ImageSparseSampleDrefExplicitLod = 308,
  ImageSparseSampleProjImplicitLod = 309,
  ImageSparseSampleProjExplicitLod = 310,
  ImageSparseSampleProjDrefImplicitLod = 311,
  ImageSparseSampleProjDrefExplicitLod = 312,
  ImageSparseFetch = 313,
  ImageSparseGather = 314,
  ImageSparseDrefGather = 315,
  ImageSparseTexelsResident = 316,
  NoLine = 317,
  AtomicFlagTestAndSet = 318,
  AtomicFlagClear = 319,
  ImageSparseRead = 320,
  SizeOf = 321,
  TypePipeStorage = 322,
  ConstantPipeStorage = 323,
  CreatePipeFromPipeStorage = 324,
  GetKernelLocalSizeForSubgroupCount = 325,
  GetKernelMaxNumSubgroups = 326,
  TypeNamedBarrier = 327,
  NamedBarrierInitialize = 328,
  MemoryNamedBarrier = 329,
  ModuleProcessed = 330,
  ExecutionModeId = 331,
  DecorateId = 332,
  GroupNonUniformElect = 333,
  GroupNonUniformAll = 334,
  GroupNonUniformAny = 335,
  GroupNonUniformAllEqual = 336,
  GroupNonUniformBroadcast = 337,
  GroupNonUniformBroadcastFirst = 338,
  GroupNonUniformBallot = 339,
  GroupNonUniformInverseBallot = 340,
  GroupNonUniformBallotBitExtract = 341,
  GroupNonUniformBallotBitCount = 342,
  GroupNonUniformBallotFindLSB = 343,
  GroupNonUniformBallotFindMSB = 344,
  GroupNonUniformShuffle = 345,
  GroupNonUniformShuffleXor = 346,
  GroupNonUniformShuffleUp = 347,
  GroupNonUniformShuffleDown = 348,
  GroupNonUniformIAdd = 349,
  GroupNonUniformFAdd = 350,
  GroupNonUniformIMul = 351,
  GroupNonUniformFMul = 352,
  GroupNonUniformSMin = 353,
  GroupNonUniformUMin = 354,
  GroupNonUniformFMin = 355,
  GroupNonUniformSMax = 356,
  GroupNonUniformUMax = 357,
  GroupNonUniformFMax = 358,
  GroupNonUniformBitwiseAnd = 359,
  GroupNonUniformBitwiseOr = 360,
  GroupNonUniformBitwiseXor = 361,
  GroupNonUniformLogicalAnd = 362,
  GroupNonUniformLogicalOr = 363,
  GroupNonUniformLogicalXor = 364,
  GroupNonUniformQuadBroadcast = 365,
  GroupNonUniformQuadSwap = 366,
  CopyLogical = 400,
  PtrEqual = 401,
  PtrNotEqual = 402,
  PtrDiff = 403,
  ColorAttachmentReadEXT = 4160,
  DepthAttachmentReadEXT = 4161,
  StencilAttachmentReadEXT = 4162,
  TerminateInvocation = 4416,
  SubgroupBallotKHR = 4421,
  SubgroupFirstInvocationKHR = 4422,
  SubgroupAllKHR = 4428,
  SubgroupAnyKHR = 4429,
  SubgroupAllEqualKHR = 4430,
  GroupNonUniformRotateKHR = 4431,
  SubgroupReadInvocationKHR = 4432,
  ExtInstWithForwardRefsKHR = 4433,
  TraceRayKHR = 4445,
  ExecuteCallableKHR = 4446,
  ConvertUToAccelerationStructureKHR = 4447,
  IgnoreIntersectionKHR = 4448,
  TerminateRayKHR = 4449,
  SDot = 4450,
  SDotKHR = 4450,
  UDot = 4451,
  UDotKHR = 4451,
  SUDot = 4452,
  SUDotKHR = 4452,
  SDotAccSat = 4453,
  SDotAccSatKHR = 4453,
  UDotAccSat = 4454,
  UDotAccSatKHR = 4454,
  SUDotAccSat = 4455,
  SUDotAccSatKHR = 4455,
  TypeCooperativeMatrixKHR = 4456,
  CooperativeMatrixLoadKHR = 4457,
  CooperativeMatrixStoreKHR = 4458,
  CooperativeMatrixMulAddKHR = 4459,
  CooperativeMatrixLengthKHR = 4460,
  ConstantCompositeReplicateEXT = 4461,
  SpecConstantCompositeReplicateEXT = 4462,
  CompositeConstructReplicateEXT = 4463,
  TypeRayQueryKHR = 4472,
  RayQueryInitializeKHR = 4473,
  RayQueryTerminateKHR = 4474,
  RayQueryGenerateIntersectionKHR = 4475,
  RayQueryConfirmIntersectionKHR = 4476,
  RayQueryProceedKHR = 4477,
  RayQueryGetIntersectionTypeKHR = 4479,
  ImageSampleWeightedQCOM = 4480,
  ImageBoxFilterQCOM = 4481,
  ImageBlockMatchSSDQCOM = 4482,
  ImageBlockMatchSADQCOM = 4483,
  ImageBlockMatchWindowSSDQCOM = 4500,
  ImageBlockMatchWindowSADQCOM = 4501,
  ImageBlockMatchGatherSSDQCOM = 4502,
  ImageBlockMatchGatherSADQCOM = 4503,
  GroupIAddNonUniformAMD = 5000,
  GroupFAddNonUniformAMD = 5001,
  GroupFMinNonUniformAMD = 5002,
  GroupUMinNonUniformAMD = 5003,
  GroupSMinNonUniformAMD = 5004,
  GroupFMaxNonUniformAMD = 5005,
  GroupUMaxNonUniformAMD = 5006,
  GroupSMaxNonUniformAMD = 5007,
  FragmentMaskFetchAMD = 5011,
  FragmentFetchAMD = 5012,
  ReadClockKHR = 5056,
  FinalizeNodePayloadsAMDX = 5075,
  FinishWritingNodePayloadAMDX = 5078,
  InitializeNodePayloadsAMDX = 5090,
  GroupNonUniformQuadAllKHR = 5110,
  GroupNonUniformQuadAnyKHR = 5111,
  HitObjectRecordHitMotionNV = 5249,
  HitObjectRecordHitWithIndexMotionNV = 5250,
  HitObjectRecordMissMotionNV = 5251,
  HitObjectGetWorldToObjectNV = 5252,
  HitObjectGetObjectToWorldNV = 5253,
  HitObjectGetObjectRayDirectionNV = 5254,
  HitObjectGetObjectRayOriginNV = 5255,
  HitObjectTraceRayMotionNV = 5256,
  HitObjectGetShaderRecordBufferHandleNV = 5257,
  HitObjectGetShaderBindingTableRecordIndexNV = 5258,
  HitObjectRecordEmptyNV = 5259,
  HitObjectTraceRayNV = 5260,
  HitObjectRecordHitNV = 5261,
  HitObjectRecordHitWithIndexNV = 5262,
  HitObjectRecordMissNV = 5263,
  HitObjectExecuteShaderNV = 5264,
  HitObjectGetCurrentTimeNV = 5265,
  HitObjectGetAttributesNV = 5266,
  HitObjectGetHitKindNV = 5267,
  HitObjectGetPrimitiveIndexNV = 5268,
  HitObjectGetGeometryIndexNV = 5269,
  HitObjectGetInstanceIdNV = 5270,
  HitObjectGetInstanceCustomIndexNV = 5271,
  HitObjectGetWorldRayDirectionNV = 5272,
  HitObjectGetWorldRayOriginNV = 5273,
  HitObjectGetRayTMaxNV = 5274,
  HitObjectGetRayTMinNV = 5275,
  HitObjectIsEmptyNV = 5276,
  HitObjectIsHitNV = 5277,
  HitObjectIsMissNV = 5278,
  ReorderThreadWithHitObjectNV = 5279,
  ReorderThreadWithHintNV = 5280,
  TypeHitObjectNV = 5281,
  ImageSampleFootprintNV = 5283,
  EmitMeshTasksEXT = 5294,
  SetMeshOutputsEXT = 5295,
  GroupNonUniformPartitionNV = 5296,
  WritePackedPrimitiveIndices4x8NV = 5299,
  FetchMicroTriangleVertexPositionNV = 5300,
  FetchMicroTriangleVertexBarycentricNV = 5301,
  ReportIntersectionKHR = 5334,
  IgnoreIntersectionNV = 5335,
  TerminateRayNV = 5336,
  TraceNV = 5337,
  TraceMotionNV = 5338,
  TraceRayMotionNV = 5339,
  RayQueryGetIntersectionTriangleVertexPositionsKHR = 5340,
  TypeAccelerationStructureKHR = 5341,
  ExecuteCallableNV = 5344,
  TypeCooperativeMatrixNV = 5358,
  CooperativeMatrixLoadNV = 5359,
  CooperativeMatrixStoreNV = 5360,
  CooperativeMatrixMulAddNV = 5361,
  CooperativeMatrixLengthNV = 5362,
  BeginInvocationInterlockEXT = 5364,
  EndInvocationInterlockEXT = 5365,
  DemoteToHelperInvocation = 5380,
  DemoteToHelperInvocationEXT = 5380,
  IsHelperInvocationEXT = 5381,
  ConvertUToImageNV = 5391,
  ConvertUToSamplerNV = 5392,
  ConvertImageToUNV = 5393,
  ConvertSamplerToUNV = 5394,
  ConvertUToSampledImageNV = 5395,
  ConvertSampledImageToUNV = 5396,
  SamplerImageAddressingModeNV = 5397,
  RawAccessChainNV = 5398,
  SubgroupShuffleINTEL = 5571,
  SubgroupShuffleDownINTEL = 5572,
  SubgroupShuffleUpINTEL = 5573,
  SubgroupShuffleXorINTEL = 5574,
  SubgroupBlockReadINTEL = 5575,
  SubgroupBlockWriteINTEL = 5576,
  SubgroupImageBlockReadINTEL = 5577,
  SubgroupImageBlockWriteINTEL = 5578,
  SubgroupImageMediaBlockReadINTEL = 5580,
  SubgroupImageMediaBlockWriteINTEL = 5581,
  UCountLeadingZerosINTEL = 5585,
  UCountTrailingZerosINTEL = 5586,
  AbsISubINTEL = 5587,
  AbsUSubINTEL = 5588,
  IAddSatINTEL = 5589,
  UAddSatINTEL = 5590,
  IAverageINTEL = 5591,
  UAverageINTEL = 5592,
  IAverageRoundedINTEL = 5593,
  UAverageRoundedINTEL = 5594,
  ISubSatINTEL = 5595,
  USubSatINTEL = 5596,
  IMul32x16INTEL = 5597,
  UMul32x16INTEL = 5598,
  AtomicFMinEXT = 5614,
  AtomicFMaxEXT = 5615,
  AssumeTrueKHR = 5630,
  ExpectKHR = 5631,
  DecorateString = 5632,
  DecorateStringGOOGLE = 5632,
  MemberDecorateString = 5633,
  MemberDecorateStringGOOGLE = 5633,
  LoopControlINTEL = 5887,
  ReadPipeBlockingINTEL = 5946,
  WritePipeBlockingINTEL = 5947,
  FPGARegINTEL = 5949,
  RayQueryGetRayTMinKHR = 6016,
  RayQueryGetRayFlagsKHR = 6017,
  RayQueryGetIntersectionTKHR = 6018,
  RayQueryGetIntersectionInstanceCustomIndexKHR = 6019,
  RayQueryGetIntersectionInstanceIdKHR = 6020,
  RayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR = 6021,
  RayQueryGetIntersectionGeometryIndexKHR = 6022,
  RayQueryGetIntersectionPrimitiveIndexKHR = 6023,
  RayQueryGetIntersectionBarycentricsKHR = 6024,
  RayQueryGetIntersectionFrontFaceKHR = 6025,
  RayQueryGetIntersectionCandidateAABBOpaqueKHR = 6026,
  RayQueryGetIntersectionObjectRayDirectionKHR = 6027,
  RayQueryGetIntersectionObjectRayOriginKHR = 6028,
  RayQueryGetWorldRayDirectionKHR = 6029,
  RayQueryGetWorldRayOriginKHR = 6030,
  RayQueryGetIntersectionObjectToWorldKHR = 6031,
  RayQueryGetIntersectionWorldToObjectKHR = 6032,
  AtomicFAddEXT = 6035,
  TypeBufferSurfaceINTEL = 6086,
  TypeStructContinuedINTEL = 6090,
  ConstantCompositeContinuedINTEL = 6091,
  SpecConstantCompositeContinuedINTEL = 6092,
  CompositeConstructContinuedINTEL = 6096,
  ConvertFToBF16INTEL = 6116,
  ConvertBF16ToFINTEL = 6117,
  ControlBarrierArriveINTEL = 6142,
  ControlBarrierWaitINTEL = 6143,
  GroupIMulKHR = 6401,
  GroupFMulKHR = 6402,
  GroupBitwiseAndKHR = 6403,
  GroupBitwiseOrKHR = 6404,
  GroupBitwiseXorKHR = 6405,
  GroupLogicalAndKHR = 6406,
  GroupLogicalOrKHR = 6407,
  GroupLogicalXorKHR = 6408,
  MaskedGatherINTEL = 6428,
  MaskedScatterINTEL = 6429,

  Max,
};

enum class GLSLstd450 : uint32_t
{
  Round = 1,
  RoundEven = 2,
  Trunc = 3,
  FAbs = 4,
  SAbs = 5,
  FSign = 6,
  SSign = 7,
  Floor = 8,
  Ceil = 9,
  Fract = 10,
  Radians = 11,
  Degrees = 12,
  Sin = 13,
  Cos = 14,
  Tan = 15,
  Asin = 16,
  Acos = 17,
  Atan = 18,
  Sinh = 19,
  Cosh = 20,
  Tanh = 21,
  Asinh = 22,
  Acosh = 23,
  Atanh = 24,
  Atan2 = 25,
  Pow = 26,
  Exp = 27,
  Log = 28,
  Exp2 = 29,
  Log2 = 30,
  Sqrt = 31,
  InverseSqrt = 32,
  Determinant = 33,
  MatrixInverse = 34,
  Modf = 35,
  ModfStruct = 36,
  FMin = 37,
  UMin = 38,
  SMin = 39,
  FMax = 40,
  UMax = 41,
  SMax = 42,
  FClamp = 43,
  UClamp = 44,
  SClamp = 45,
  FMix = 46,
  IMix = 47,
  Step = 48,
  SmoothStep = 49,
  Fma = 50,
  Frexp = 51,
  FrexpStruct = 52,
  Ldexp = 53,
  PackSnorm4x8 = 54,
  PackUnorm4x8 = 55,
  PackSnorm2x16 = 56,
  PackUnorm2x16 = 57,
  PackHalf2x16 = 58,
  PackDouble2x32 = 59,
  UnpackSnorm2x16 = 60,
  UnpackUnorm2x16 = 61,
  UnpackHalf2x16 = 62,
  UnpackSnorm4x8 = 63,
  UnpackUnorm4x8 = 64,
  UnpackDouble2x32 = 65,
  Length = 66,
  Distance = 67,
  Cross = 68,
  Normalize = 69,
  FaceForward = 70,
  Reflect = 71,
  Refract = 72,
  FindILsb = 73,
  FindSMsb = 74,
  FindUMsb = 75,
  InterpolateAtCentroid = 76,
  InterpolateAtSample = 77,
  InterpolateAtOffset = 78,
  NMin = 79,
  NMax = 80,
  NClamp = 81,

  Max,
  Invalid = ~0U,
};

enum class ShaderDbg : uint32_t
{
  InfoNone = 0,
  CompilationUnit = 1,
  TypeBasic = 2,
  TypePointer = 3,
  TypeQualifier = 4,
  TypeArray = 5,
  TypeVector = 6,
  Typedef = 7,
  TypeFunction = 8,
  TypeEnum = 9,
  TypeComposite = 10,
  TypeMember = 11,
  TypeInheritance = 12,
  TypePtrToMember = 13,
  TypeTemplate = 14,
  TypeTemplateParameter = 15,
  TypeTemplateTemplateParameter = 16,
  TypeTemplateParameterPack = 17,
  GlobalVariable = 18,
  FunctionDeclaration = 19,
  Function = 20,
  LexicalBlock = 21,
  LexicalBlockDiscriminator = 22,
  Scope = 23,
  NoScope = 24,
  InlinedAt = 25,
  LocalVariable = 26,
  InlinedVariable = 27,
  Declare = 28,
  Value = 29,
  Operation = 30,
  Expression = 31,
  MacroDef = 32,
  MacroUndef = 33,
  ImportedEntity = 34,
  Source = 35,
  FunctionDefinition = 101,
  SourceContinued = 102,
  Line = 103,
  NoLine = 104,
  BuildIdentifier = 105,
  StoragePath = 106,
  EntryPoint = 107,
  TypeMatrix = 108,

  Max,
  Invalid = ~0U,
};


}; // namespace rdcspv

DECLARE_STRINGISE_TYPE(rdcspv::GLSLstd450);
DECLARE_STRINGISE_TYPE(rdcspv::Generator);

DECLARE_STRINGISE_TYPE(rdcspv::ImageOperands);
DECLARE_STRINGISE_TYPE(rdcspv::FPFastMathMode);
DECLARE_STRINGISE_TYPE(rdcspv::SelectionControl);
DECLARE_STRINGISE_TYPE(rdcspv::LoopControl);
DECLARE_STRINGISE_TYPE(rdcspv::FunctionControl);
DECLARE_STRINGISE_TYPE(rdcspv::MemorySemantics);
DECLARE_STRINGISE_TYPE(rdcspv::MemoryAccess);
DECLARE_STRINGISE_TYPE(rdcspv::KernelProfilingInfo);
DECLARE_STRINGISE_TYPE(rdcspv::RayFlags);
DECLARE_STRINGISE_TYPE(rdcspv::FragmentShadingRate);
DECLARE_STRINGISE_TYPE(rdcspv::RawAccessChainOperands);
DECLARE_STRINGISE_TYPE(rdcspv::SourceLanguage);
DECLARE_STRINGISE_TYPE(rdcspv::ExecutionModel);
DECLARE_STRINGISE_TYPE(rdcspv::AddressingModel);
DECLARE_STRINGISE_TYPE(rdcspv::MemoryModel);
DECLARE_STRINGISE_TYPE(rdcspv::ExecutionMode);
DECLARE_STRINGISE_TYPE(rdcspv::StorageClass);
DECLARE_STRINGISE_TYPE(rdcspv::Dim);
DECLARE_STRINGISE_TYPE(rdcspv::SamplerAddressingMode);
DECLARE_STRINGISE_TYPE(rdcspv::SamplerFilterMode);
DECLARE_STRINGISE_TYPE(rdcspv::ImageFormat);
DECLARE_STRINGISE_TYPE(rdcspv::ImageChannelOrder);
DECLARE_STRINGISE_TYPE(rdcspv::ImageChannelDataType);
DECLARE_STRINGISE_TYPE(rdcspv::FPRoundingMode);
DECLARE_STRINGISE_TYPE(rdcspv::FPDenormMode);
DECLARE_STRINGISE_TYPE(rdcspv::QuantizationModes);
DECLARE_STRINGISE_TYPE(rdcspv::FPOperationMode);
DECLARE_STRINGISE_TYPE(rdcspv::OverflowModes);
DECLARE_STRINGISE_TYPE(rdcspv::LinkageType);
DECLARE_STRINGISE_TYPE(rdcspv::AccessQualifier);
DECLARE_STRINGISE_TYPE(rdcspv::HostAccessQualifier);
DECLARE_STRINGISE_TYPE(rdcspv::FunctionParameterAttribute);
DECLARE_STRINGISE_TYPE(rdcspv::Decoration);
DECLARE_STRINGISE_TYPE(rdcspv::BuiltIn);
DECLARE_STRINGISE_TYPE(rdcspv::Scope);
DECLARE_STRINGISE_TYPE(rdcspv::GroupOperation);
DECLARE_STRINGISE_TYPE(rdcspv::KernelEnqueueFlags);
DECLARE_STRINGISE_TYPE(rdcspv::Capability);
DECLARE_STRINGISE_TYPE(rdcspv::RayQueryIntersection);
DECLARE_STRINGISE_TYPE(rdcspv::RayQueryCommittedIntersectionType);
DECLARE_STRINGISE_TYPE(rdcspv::RayQueryCandidateIntersectionType);
DECLARE_STRINGISE_TYPE(rdcspv::PackedVectorFormat);
DECLARE_STRINGISE_TYPE(rdcspv::CooperativeMatrixOperands);
DECLARE_STRINGISE_TYPE(rdcspv::CooperativeMatrixLayout);
DECLARE_STRINGISE_TYPE(rdcspv::CooperativeMatrixUse);
DECLARE_STRINGISE_TYPE(rdcspv::InitializationModeQualifier);
DECLARE_STRINGISE_TYPE(rdcspv::LoadCacheControl);
DECLARE_STRINGISE_TYPE(rdcspv::StoreCacheControl);
DECLARE_STRINGISE_TYPE(rdcspv::NamedMaximumNumberOfRegisters);
