#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[inline]
pub unsafe fn AmsiCloseSession<P0, P1>(amsicontext: P0, amsisession: P1)
where
    P0: ::windows::core::IntoParam<HAMSICONTEXT>,
    P1: ::windows::core::IntoParam<HAMSISESSION>,
{
    ::windows_targets::link ! ( "amsi.dll""system" fn AmsiCloseSession ( amsicontext : HAMSICONTEXT , amsisession : HAMSISESSION ) -> ( ) );
    AmsiCloseSession(amsicontext.into_param().abi(), amsisession.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[inline]
pub unsafe fn AmsiInitialize<P0>(appname: P0) -> ::windows::core::Result<HAMSICONTEXT>
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows_targets::link ! ( "amsi.dll""system" fn AmsiInitialize ( appname : ::windows::core::PCWSTR , amsicontext : *mut HAMSICONTEXT ) -> ::windows::core::HRESULT );
    let mut result__ = ::windows::core::zeroed::<HAMSICONTEXT>();
    AmsiInitialize(appname.into_param().abi(), &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[inline]
pub unsafe fn AmsiNotifyOperation<P0, P1>(amsicontext: P0, buffer: *const ::core::ffi::c_void, length: u32, contentname: P1) -> ::windows::core::Result<AMSI_RESULT>
where
    P0: ::windows::core::IntoParam<HAMSICONTEXT>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows_targets::link ! ( "amsi.dll""system" fn AmsiNotifyOperation ( amsicontext : HAMSICONTEXT , buffer : *const ::core::ffi::c_void , length : u32 , contentname : ::windows::core::PCWSTR , result : *mut AMSI_RESULT ) -> ::windows::core::HRESULT );
    let mut result__ = ::windows::core::zeroed::<AMSI_RESULT>();
    AmsiNotifyOperation(amsicontext.into_param().abi(), buffer, length, contentname.into_param().abi(), &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[inline]
pub unsafe fn AmsiOpenSession<P0>(amsicontext: P0) -> ::windows::core::Result<HAMSISESSION>
where
    P0: ::windows::core::IntoParam<HAMSICONTEXT>,
{
    ::windows_targets::link ! ( "amsi.dll""system" fn AmsiOpenSession ( amsicontext : HAMSICONTEXT , amsisession : *mut HAMSISESSION ) -> ::windows::core::HRESULT );
    let mut result__ = ::windows::core::zeroed::<HAMSISESSION>();
    AmsiOpenSession(amsicontext.into_param().abi(), &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[inline]
pub unsafe fn AmsiScanBuffer<P0, P1, P2>(amsicontext: P0, buffer: *const ::core::ffi::c_void, length: u32, contentname: P1, amsisession: P2) -> ::windows::core::Result<AMSI_RESULT>
where
    P0: ::windows::core::IntoParam<HAMSICONTEXT>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<HAMSISESSION>,
{
    ::windows_targets::link ! ( "amsi.dll""system" fn AmsiScanBuffer ( amsicontext : HAMSICONTEXT , buffer : *const ::core::ffi::c_void , length : u32 , contentname : ::windows::core::PCWSTR , amsisession : HAMSISESSION , result : *mut AMSI_RESULT ) -> ::windows::core::HRESULT );
    let mut result__ = ::windows::core::zeroed::<AMSI_RESULT>();
    AmsiScanBuffer(amsicontext.into_param().abi(), buffer, length, contentname.into_param().abi(), amsisession.into_param().abi(), &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[inline]
pub unsafe fn AmsiScanString<P0, P1, P2, P3>(amsicontext: P0, string: P1, contentname: P2, amsisession: P3) -> ::windows::core::Result<AMSI_RESULT>
where
    P0: ::windows::core::IntoParam<HAMSICONTEXT>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P3: ::windows::core::IntoParam<HAMSISESSION>,
{
    ::windows_targets::link ! ( "amsi.dll""system" fn AmsiScanString ( amsicontext : HAMSICONTEXT , string : ::windows::core::PCWSTR , contentname : ::windows::core::PCWSTR , amsisession : HAMSISESSION , result : *mut AMSI_RESULT ) -> ::windows::core::HRESULT );
    let mut result__ = ::windows::core::zeroed::<AMSI_RESULT>();
    AmsiScanString(amsicontext.into_param().abi(), string.into_param().abi(), contentname.into_param().abi(), amsisession.into_param().abi(), &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[inline]
pub unsafe fn AmsiUninitialize<P0>(amsicontext: P0)
where
    P0: ::windows::core::IntoParam<HAMSICONTEXT>,
{
    ::windows_targets::link ! ( "amsi.dll""system" fn AmsiUninitialize ( amsicontext : HAMSICONTEXT ) -> ( ) );
    AmsiUninitialize(amsicontext.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn InstallELAMCertificateInfo<P0>(elamfile: P0) -> super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::Foundation::HANDLE>,
{
    ::windows_targets::link ! ( "kernel32.dll""system" fn InstallELAMCertificateInfo ( elamfile : super::super::Foundation:: HANDLE ) -> super::super::Foundation:: BOOL );
    InstallELAMCertificateInfo(elamfile.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[repr(transparent)]
pub struct IAmsiStream(::windows::core::IUnknown);
impl IAmsiStream {
    pub unsafe fn GetAttribute(&self, attribute: AMSI_ATTRIBUTE, data: &mut [u8], retdata: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetAttribute)(::windows::core::Interface::as_raw(self), attribute, data.len() as _, ::core::mem::transmute(data.as_ptr()), retdata).ok()
    }
    pub unsafe fn Read(&self, position: u64, buffer: &mut [u8], readsize: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Read)(::windows::core::Interface::as_raw(self), position, buffer.len() as _, ::core::mem::transmute(buffer.as_ptr()), readsize).ok()
    }
}
::windows::imp::interface_hierarchy!(IAmsiStream, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IAmsiStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAmsiStream {}
impl ::core::fmt::Debug for IAmsiStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAmsiStream").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAmsiStream {
    type Vtable = IAmsiStream_Vtbl;
}
impl ::core::clone::Clone for IAmsiStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IAmsiStream {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3e47f2e5_81d4_4d3b_897f_545096770373);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAmsiStream_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetAttribute: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, attribute: AMSI_ATTRIBUTE, datasize: u32, data: *mut u8, retdata: *mut u32) -> ::windows::core::HRESULT,
    pub Read: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, position: u64, size: u32, buffer: *mut u8, readsize: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[repr(transparent)]
pub struct IAntimalware(::windows::core::IUnknown);
impl IAntimalware {
    pub unsafe fn Scan<P0>(&self, stream: P0, result: *mut AMSI_RESULT, provider: *mut ::core::option::Option<IAntimalwareProvider>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IAmsiStream>,
    {
        (::windows::core::Interface::vtable(self).Scan)(::windows::core::Interface::as_raw(self), stream.into_param().abi(), result, ::core::mem::transmute(provider)).ok()
    }
    pub unsafe fn CloseSession(&self, session: u64) {
        (::windows::core::Interface::vtable(self).CloseSession)(::windows::core::Interface::as_raw(self), session)
    }
}
::windows::imp::interface_hierarchy!(IAntimalware, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IAntimalware {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAntimalware {}
impl ::core::fmt::Debug for IAntimalware {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAntimalware").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAntimalware {
    type Vtable = IAntimalware_Vtbl;
}
impl ::core::clone::Clone for IAntimalware {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IAntimalware {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x82d29c2e_f062_44e6_b5c9_3d9a2f24a2df);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalware_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Scan: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, stream: *mut ::core::ffi::c_void, result: *mut AMSI_RESULT, provider: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CloseSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, session: u64),
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[repr(transparent)]
pub struct IAntimalware2(::windows::core::IUnknown);
impl IAntimalware2 {
    pub unsafe fn Scan<P0>(&self, stream: P0, result: *mut AMSI_RESULT, provider: *mut ::core::option::Option<IAntimalwareProvider>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IAmsiStream>,
    {
        (::windows::core::Interface::vtable(self).base__.Scan)(::windows::core::Interface::as_raw(self), stream.into_param().abi(), result, ::core::mem::transmute(provider)).ok()
    }
    pub unsafe fn CloseSession(&self, session: u64) {
        (::windows::core::Interface::vtable(self).base__.CloseSession)(::windows::core::Interface::as_raw(self), session)
    }
    pub unsafe fn Notify<P0, P1>(&self, buffer: *const ::core::ffi::c_void, length: u32, contentname: P0, appname: P1) -> ::windows::core::Result<AMSI_RESULT>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<AMSI_RESULT>();
        (::windows::core::Interface::vtable(self).Notify)(::windows::core::Interface::as_raw(self), buffer, length, contentname.into_param().abi(), appname.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IAntimalware2, ::windows::core::IUnknown, IAntimalware);
impl ::core::cmp::PartialEq for IAntimalware2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAntimalware2 {}
impl ::core::fmt::Debug for IAntimalware2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAntimalware2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAntimalware2 {
    type Vtable = IAntimalware2_Vtbl;
}
impl ::core::clone::Clone for IAntimalware2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IAntimalware2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x301035b5_2d42_4f56_8c65_2dcaa7fb3cdc);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalware2_Vtbl {
    pub base__: IAntimalware_Vtbl,
    pub Notify: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: *const ::core::ffi::c_void, length: u32, contentname: ::windows::core::PCWSTR, appname: ::windows::core::PCWSTR, presult: *mut AMSI_RESULT) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[repr(transparent)]
pub struct IAntimalwareProvider(::windows::core::IUnknown);
impl IAntimalwareProvider {
    pub unsafe fn Scan<P0>(&self, stream: P0) -> ::windows::core::Result<AMSI_RESULT>
    where
        P0: ::windows::core::IntoParam<IAmsiStream>,
    {
        let mut result__ = ::windows::core::zeroed::<AMSI_RESULT>();
        (::windows::core::Interface::vtable(self).Scan)(::windows::core::Interface::as_raw(self), stream.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn CloseSession(&self, session: u64) {
        (::windows::core::Interface::vtable(self).CloseSession)(::windows::core::Interface::as_raw(self), session)
    }
    pub unsafe fn DisplayName(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).DisplayName)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IAntimalwareProvider, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IAntimalwareProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAntimalwareProvider {}
impl ::core::fmt::Debug for IAntimalwareProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAntimalwareProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAntimalwareProvider {
    type Vtable = IAntimalwareProvider_Vtbl;
}
impl ::core::clone::Clone for IAntimalwareProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IAntimalwareProvider {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb2cabfe3_fe04_42b1_a5df_08d483d4d125);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalwareProvider_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Scan: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, stream: *mut ::core::ffi::c_void, result: *mut AMSI_RESULT) -> ::windows::core::HRESULT,
    pub CloseSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, session: u64),
    pub DisplayName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, displayname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[repr(transparent)]
pub struct IAntimalwareProvider2(::windows::core::IUnknown);
impl IAntimalwareProvider2 {
    pub unsafe fn Scan<P0>(&self, stream: P0) -> ::windows::core::Result<AMSI_RESULT>
    where
        P0: ::windows::core::IntoParam<IAmsiStream>,
    {
        let mut result__ = ::windows::core::zeroed::<AMSI_RESULT>();
        (::windows::core::Interface::vtable(self).base__.Scan)(::windows::core::Interface::as_raw(self), stream.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn CloseSession(&self, session: u64) {
        (::windows::core::Interface::vtable(self).base__.CloseSession)(::windows::core::Interface::as_raw(self), session)
    }
    pub unsafe fn DisplayName(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).base__.DisplayName)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Notify<P0, P1>(&self, buffer: *const ::core::ffi::c_void, length: u32, contentname: P0, appname: P1) -> ::windows::core::Result<AMSI_RESULT>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<AMSI_RESULT>();
        (::windows::core::Interface::vtable(self).Notify)(::windows::core::Interface::as_raw(self), buffer, length, contentname.into_param().abi(), appname.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IAntimalwareProvider2, ::windows::core::IUnknown, IAntimalwareProvider);
impl ::core::cmp::PartialEq for IAntimalwareProvider2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAntimalwareProvider2 {}
impl ::core::fmt::Debug for IAntimalwareProvider2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAntimalwareProvider2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAntimalwareProvider2 {
    type Vtable = IAntimalwareProvider2_Vtbl;
}
impl ::core::clone::Clone for IAntimalwareProvider2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IAntimalwareProvider2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7c1e6570_3f73_4e0f_8ad4_98b94cd3290f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalwareProvider2_Vtbl {
    pub base__: IAntimalwareProvider_Vtbl,
    pub Notify: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: *const ::core::ffi::c_void, length: u32, contentname: ::windows::core::PCWSTR, appname: ::windows::core::PCWSTR, presult: *mut AMSI_RESULT) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[repr(transparent)]
pub struct IAntimalwareUacProvider(::windows::core::IUnknown);
impl IAntimalwareUacProvider {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UacScan(&self, context: *const AMSI_UAC_REQUEST_CONTEXT) -> ::windows::core::Result<AMSI_RESULT> {
        let mut result__ = ::windows::core::zeroed::<AMSI_RESULT>();
        (::windows::core::Interface::vtable(self).UacScan)(::windows::core::Interface::as_raw(self), context, &mut result__).from_abi(result__)
    }
    pub unsafe fn DisplayName(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::PWSTR>();
        (::windows::core::Interface::vtable(self).DisplayName)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IAntimalwareUacProvider, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IAntimalwareUacProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAntimalwareUacProvider {}
impl ::core::fmt::Debug for IAntimalwareUacProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAntimalwareUacProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAntimalwareUacProvider {
    type Vtable = IAntimalwareUacProvider_Vtbl;
}
impl ::core::clone::Clone for IAntimalwareUacProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IAntimalwareUacProvider {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb2cabfe4_fe04_42b1_a5df_08d483d4d125);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAntimalwareUacProvider_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub UacScan: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *const AMSI_UAC_REQUEST_CONTEXT, result: *mut AMSI_RESULT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    UacScan: usize,
    pub DisplayName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, displayname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const CAntimalware: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfdb00e52_a214_4aa1_8fba_4357bb0072ec);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct AMSI_ATTRIBUTE(pub i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_ATTRIBUTE_APP_NAME: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(0i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_ATTRIBUTE_CONTENT_NAME: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(1i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_ATTRIBUTE_CONTENT_SIZE: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(2i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_ATTRIBUTE_CONTENT_ADDRESS: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(3i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_ATTRIBUTE_SESSION: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(4i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_ATTRIBUTE_REDIRECT_CHAIN_SIZE: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(5i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_ATTRIBUTE_REDIRECT_CHAIN_ADDRESS: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(6i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_ATTRIBUTE_ALL_SIZE: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(7i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_ATTRIBUTE_ALL_ADDRESS: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(8i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_ATTRIBUTE_QUIET: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(9i32);
impl ::core::marker::Copy for AMSI_ATTRIBUTE {}
impl ::core::clone::Clone for AMSI_ATTRIBUTE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AMSI_ATTRIBUTE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for AMSI_ATTRIBUTE {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for AMSI_ATTRIBUTE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AMSI_ATTRIBUTE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct AMSI_RESULT(pub i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_RESULT_CLEAN: AMSI_RESULT = AMSI_RESULT(0i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_RESULT_NOT_DETECTED: AMSI_RESULT = AMSI_RESULT(1i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_RESULT_BLOCKED_BY_ADMIN_START: AMSI_RESULT = AMSI_RESULT(16384i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_RESULT_BLOCKED_BY_ADMIN_END: AMSI_RESULT = AMSI_RESULT(20479i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_RESULT_DETECTED: AMSI_RESULT = AMSI_RESULT(32768i32);
impl ::core::marker::Copy for AMSI_RESULT {}
impl ::core::clone::Clone for AMSI_RESULT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AMSI_RESULT {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for AMSI_RESULT {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for AMSI_RESULT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AMSI_RESULT").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct AMSI_UAC_MSI_ACTION(pub i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_MSI_ACTION_INSTALL: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(0i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_MSI_ACTION_UNINSTALL: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(1i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_MSI_ACTION_UPDATE: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(2i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_MSI_ACTION_MAINTENANCE: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(3i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_MSI_ACTION_MAX: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(4i32);
impl ::core::marker::Copy for AMSI_UAC_MSI_ACTION {}
impl ::core::clone::Clone for AMSI_UAC_MSI_ACTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AMSI_UAC_MSI_ACTION {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for AMSI_UAC_MSI_ACTION {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for AMSI_UAC_MSI_ACTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AMSI_UAC_MSI_ACTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct AMSI_UAC_REQUEST_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_REQUEST_TYPE_EXE: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(0i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_REQUEST_TYPE_COM: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(1i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_REQUEST_TYPE_MSI: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(2i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_REQUEST_TYPE_AX: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(3i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_REQUEST_TYPE_PACKAGED_APP: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(4i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_REQUEST_TYPE_MAX: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(5i32);
impl ::core::marker::Copy for AMSI_UAC_REQUEST_TYPE {}
impl ::core::clone::Clone for AMSI_UAC_REQUEST_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AMSI_UAC_REQUEST_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for AMSI_UAC_REQUEST_TYPE {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AMSI_UAC_REQUEST_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct AMSI_UAC_TRUST_STATE(pub i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_TRUST_STATE_TRUSTED: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(0i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_TRUST_STATE_UNTRUSTED: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(1i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_TRUST_STATE_BLOCKED: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(2i32);
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub const AMSI_UAC_TRUST_STATE_MAX: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(3i32);
impl ::core::marker::Copy for AMSI_UAC_TRUST_STATE {}
impl ::core::clone::Clone for AMSI_UAC_TRUST_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AMSI_UAC_TRUST_STATE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows::core::TypeKind for AMSI_UAC_TRUST_STATE {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::fmt::Debug for AMSI_UAC_TRUST_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AMSI_UAC_TRUST_STATE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub struct AMSI_UAC_REQUEST_AX_INFO {
    pub ulLength: u32,
    pub lpwszLocalInstallPath: ::windows::core::PWSTR,
    pub lpwszSourceURL: ::windows::core::PWSTR,
}
impl ::core::marker::Copy for AMSI_UAC_REQUEST_AX_INFO {}
impl ::core::clone::Clone for AMSI_UAC_REQUEST_AX_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_AX_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMSI_UAC_REQUEST_AX_INFO").field("ulLength", &self.ulLength).field("lpwszLocalInstallPath", &self.lpwszLocalInstallPath).field("lpwszSourceURL", &self.lpwszSourceURL).finish()
    }
}
impl ::windows::core::TypeKind for AMSI_UAC_REQUEST_AX_INFO {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_AX_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength && self.lpwszLocalInstallPath == other.lpwszLocalInstallPath && self.lpwszSourceURL == other.lpwszSourceURL
    }
}
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_AX_INFO {}
impl ::core::default::Default for AMSI_UAC_REQUEST_AX_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub struct AMSI_UAC_REQUEST_COM_INFO {
    pub ulLength: u32,
    pub lpwszServerBinary: ::windows::core::PWSTR,
    pub lpwszRequestor: ::windows::core::PWSTR,
    pub Clsid: ::windows::core::GUID,
}
impl ::core::marker::Copy for AMSI_UAC_REQUEST_COM_INFO {}
impl ::core::clone::Clone for AMSI_UAC_REQUEST_COM_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_COM_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMSI_UAC_REQUEST_COM_INFO").field("ulLength", &self.ulLength).field("lpwszServerBinary", &self.lpwszServerBinary).field("lpwszRequestor", &self.lpwszRequestor).field("Clsid", &self.Clsid).finish()
    }
}
impl ::windows::core::TypeKind for AMSI_UAC_REQUEST_COM_INFO {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_COM_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength && self.lpwszServerBinary == other.lpwszServerBinary && self.lpwszRequestor == other.lpwszRequestor && self.Clsid == other.Clsid
    }
}
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_COM_INFO {}
impl ::core::default::Default for AMSI_UAC_REQUEST_COM_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Antimalware\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_CONTEXT {
    pub ulLength: u32,
    pub ulRequestorProcessId: u32,
    pub UACTrustState: AMSI_UAC_TRUST_STATE,
    pub Type: AMSI_UAC_REQUEST_TYPE,
    pub RequestType: AMSI_UAC_REQUEST_CONTEXT_0,
    pub bAutoElevateRequest: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_CONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::windows::core::TypeKind for AMSI_UAC_REQUEST_CONTEXT {
    type TypeKind = ::windows::core::CopyType;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_CONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Antimalware\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub union AMSI_UAC_REQUEST_CONTEXT_0 {
    pub ExeInfo: AMSI_UAC_REQUEST_EXE_INFO,
    pub ComInfo: AMSI_UAC_REQUEST_COM_INFO,
    pub MsiInfo: AMSI_UAC_REQUEST_MSI_INFO,
    pub ActiveXInfo: AMSI_UAC_REQUEST_AX_INFO,
    pub PackagedAppInfo: AMSI_UAC_REQUEST_PACKAGED_APP_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_CONTEXT_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_CONTEXT_0 {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::windows::core::TypeKind for AMSI_UAC_REQUEST_CONTEXT_0 {
    type TypeKind = ::windows::core::CopyType;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AMSI_UAC_REQUEST_CONTEXT_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub struct AMSI_UAC_REQUEST_EXE_INFO {
    pub ulLength: u32,
    pub lpwszApplicationName: ::windows::core::PWSTR,
    pub lpwszCommandLine: ::windows::core::PWSTR,
    pub lpwszDLLParameter: ::windows::core::PWSTR,
}
impl ::core::marker::Copy for AMSI_UAC_REQUEST_EXE_INFO {}
impl ::core::clone::Clone for AMSI_UAC_REQUEST_EXE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_EXE_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMSI_UAC_REQUEST_EXE_INFO").field("ulLength", &self.ulLength).field("lpwszApplicationName", &self.lpwszApplicationName).field("lpwszCommandLine", &self.lpwszCommandLine).field("lpwszDLLParameter", &self.lpwszDLLParameter).finish()
    }
}
impl ::windows::core::TypeKind for AMSI_UAC_REQUEST_EXE_INFO {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_EXE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength && self.lpwszApplicationName == other.lpwszApplicationName && self.lpwszCommandLine == other.lpwszCommandLine && self.lpwszDLLParameter == other.lpwszDLLParameter
    }
}
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_EXE_INFO {}
impl ::core::default::Default for AMSI_UAC_REQUEST_EXE_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub struct AMSI_UAC_REQUEST_MSI_INFO {
    pub ulLength: u32,
    pub MsiAction: AMSI_UAC_MSI_ACTION,
    pub lpwszProductName: ::windows::core::PWSTR,
    pub lpwszVersion: ::windows::core::PWSTR,
    pub lpwszLanguage: ::windows::core::PWSTR,
    pub lpwszManufacturer: ::windows::core::PWSTR,
    pub lpwszPackagePath: ::windows::core::PWSTR,
    pub lpwszPackageSource: ::windows::core::PWSTR,
    pub ulUpdates: u32,
    pub ppwszUpdates: *mut ::windows::core::PWSTR,
    pub ppwszUpdateSources: *mut ::windows::core::PWSTR,
}
impl ::core::marker::Copy for AMSI_UAC_REQUEST_MSI_INFO {}
impl ::core::clone::Clone for AMSI_UAC_REQUEST_MSI_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_MSI_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMSI_UAC_REQUEST_MSI_INFO")
            .field("ulLength", &self.ulLength)
            .field("MsiAction", &self.MsiAction)
            .field("lpwszProductName", &self.lpwszProductName)
            .field("lpwszVersion", &self.lpwszVersion)
            .field("lpwszLanguage", &self.lpwszLanguage)
            .field("lpwszManufacturer", &self.lpwszManufacturer)
            .field("lpwszPackagePath", &self.lpwszPackagePath)
            .field("lpwszPackageSource", &self.lpwszPackageSource)
            .field("ulUpdates", &self.ulUpdates)
            .field("ppwszUpdates", &self.ppwszUpdates)
            .field("ppwszUpdateSources", &self.ppwszUpdateSources)
            .finish()
    }
}
impl ::windows::core::TypeKind for AMSI_UAC_REQUEST_MSI_INFO {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_MSI_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength && self.MsiAction == other.MsiAction && self.lpwszProductName == other.lpwszProductName && self.lpwszVersion == other.lpwszVersion && self.lpwszLanguage == other.lpwszLanguage && self.lpwszManufacturer == other.lpwszManufacturer && self.lpwszPackagePath == other.lpwszPackagePath && self.lpwszPackageSource == other.lpwszPackageSource && self.ulUpdates == other.ulUpdates && self.ppwszUpdates == other.ppwszUpdates && self.ppwszUpdateSources == other.ppwszUpdateSources
    }
}
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_MSI_INFO {}
impl ::core::default::Default for AMSI_UAC_REQUEST_MSI_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_System_Antimalware\"`*"]
pub struct AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    pub ulLength: u32,
    pub lpwszApplicationName: ::windows::core::PWSTR,
    pub lpwszCommandLine: ::windows::core::PWSTR,
    pub lpPackageFamilyName: ::windows::core::PWSTR,
    pub lpApplicationId: ::windows::core::PWSTR,
}
impl ::core::marker::Copy for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {}
impl ::core::clone::Clone for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMSI_UAC_REQUEST_PACKAGED_APP_INFO").field("ulLength", &self.ulLength).field("lpwszApplicationName", &self.lpwszApplicationName).field("lpwszCommandLine", &self.lpwszCommandLine).field("lpPackageFamilyName", &self.lpPackageFamilyName).field("lpApplicationId", &self.lpApplicationId).finish()
    }
}
impl ::windows::core::TypeKind for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    type TypeKind = ::windows::core::CopyType;
}
impl ::core::cmp::PartialEq for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ulLength == other.ulLength && self.lpwszApplicationName == other.lpwszApplicationName && self.lpwszCommandLine == other.lpwszCommandLine && self.lpPackageFamilyName == other.lpPackageFamilyName && self.lpApplicationId == other.lpApplicationId
    }
}
impl ::core::cmp::Eq for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {}
impl ::core::default::Default for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HAMSICONTEXT(pub isize);
impl HAMSICONTEXT {
    pub fn is_invalid(&self) -> bool {
        self.0 == -1 || self.0 == 0
    }
}
impl ::core::default::Default for HAMSICONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::clone::Clone for HAMSICONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::marker::Copy for HAMSICONTEXT {}
impl ::core::fmt::Debug for HAMSICONTEXT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HAMSICONTEXT").field(&self.0).finish()
    }
}
impl ::windows::core::TypeKind for HAMSICONTEXT {
    type TypeKind = ::windows::core::CopyType;
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HAMSISESSION(pub isize);
impl HAMSISESSION {
    pub fn is_invalid(&self) -> bool {
        self.0 == -1 || self.0 == 0
    }
}
impl ::core::default::Default for HAMSISESSION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::clone::Clone for HAMSISESSION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::marker::Copy for HAMSISESSION {}
impl ::core::fmt::Debug for HAMSISESSION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HAMSISESSION").field(&self.0).finish()
    }
}
impl ::windows::core::TypeKind for HAMSISESSION {
    type TypeKind = ::windows::core::CopyType;
}
#[cfg(feature = "implement")]
::core::include!("impl.rs");
