--TEST--
bcdiv() function with numbers pow 10
--EXTENSIONS--
bcmath
--INI--
bcmath.scale=0
--FILE--
<?php
$dividend_cases = ['0.012345', '0.12345', '1.2345', '12.345', '123.45', '-0.012345', '-0.12345', '-1.2345', '-12.345', '-123.45'];
$divisor_cases = ['0.01', '0.1', '1', '10', '100', '-0.01', '-0.1', '-1', '-10', '-100'];
$scale_cases = [0, 3, 5];

foreach ($scale_cases as $scale) {
    echo "scale: {$scale}\n";
    foreach ($divisor_cases as $divisor) {
        foreach ($dividend_cases as $dividend) {
            $dividend_label = str_pad($dividend, 9, ' ', STR_PAD_LEFT);
            $divisor_label = str_pad($divisor, 5, ' ', STR_PAD_LEFT);
            $quot = bcdiv($dividend, $divisor, $scale);
            $quot_label = str_pad($quot, $scale + 7 + ($scale ? 1 : 0), ' ', STR_PAD_LEFT);
            echo $dividend_label, ' / ', $divisor_label, ' = ', $quot_label, "\n";
        }
    }
    echo "\n";
}
?>
--EXPECT--
scale: 0
 0.012345 /  0.01 =       1
  0.12345 /  0.01 =      12
   1.2345 /  0.01 =     123
   12.345 /  0.01 =    1234
   123.45 /  0.01 =   12345
-0.012345 /  0.01 =      -1
 -0.12345 /  0.01 =     -12
  -1.2345 /  0.01 =    -123
  -12.345 /  0.01 =   -1234
  -123.45 /  0.01 =  -12345
 0.012345 /   0.1 =       0
  0.12345 /   0.1 =       1
   1.2345 /   0.1 =      12
   12.345 /   0.1 =     123
   123.45 /   0.1 =    1234
-0.012345 /   0.1 =       0
 -0.12345 /   0.1 =      -1
  -1.2345 /   0.1 =     -12
  -12.345 /   0.1 =    -123
  -123.45 /   0.1 =   -1234
 0.012345 /     1 =       0
  0.12345 /     1 =       0
   1.2345 /     1 =       1
   12.345 /     1 =      12
   123.45 /     1 =     123
-0.012345 /     1 =       0
 -0.12345 /     1 =       0
  -1.2345 /     1 =      -1
  -12.345 /     1 =     -12
  -123.45 /     1 =    -123
 0.012345 /    10 =       0
  0.12345 /    10 =       0
   1.2345 /    10 =       0
   12.345 /    10 =       1
   123.45 /    10 =      12
-0.012345 /    10 =       0
 -0.12345 /    10 =       0
  -1.2345 /    10 =       0
  -12.345 /    10 =      -1
  -123.45 /    10 =     -12
 0.012345 /   100 =       0
  0.12345 /   100 =       0
   1.2345 /   100 =       0
   12.345 /   100 =       0
   123.45 /   100 =       1
-0.012345 /   100 =       0
 -0.12345 /   100 =       0
  -1.2345 /   100 =       0
  -12.345 /   100 =       0
  -123.45 /   100 =      -1
 0.012345 / -0.01 =      -1
  0.12345 / -0.01 =     -12
   1.2345 / -0.01 =    -123
   12.345 / -0.01 =   -1234
   123.45 / -0.01 =  -12345
-0.012345 / -0.01 =       1
 -0.12345 / -0.01 =      12
  -1.2345 / -0.01 =     123
  -12.345 / -0.01 =    1234
  -123.45 / -0.01 =   12345
 0.012345 /  -0.1 =       0
  0.12345 /  -0.1 =      -1
   1.2345 /  -0.1 =     -12
   12.345 /  -0.1 =    -123
   123.45 /  -0.1 =   -1234
-0.012345 /  -0.1 =       0
 -0.12345 /  -0.1 =       1
  -1.2345 /  -0.1 =      12
  -12.345 /  -0.1 =     123
  -123.45 /  -0.1 =    1234
 0.012345 /    -1 =       0
  0.12345 /    -1 =       0
   1.2345 /    -1 =      -1
   12.345 /    -1 =     -12
   123.45 /    -1 =    -123
-0.012345 /    -1 =       0
 -0.12345 /    -1 =       0
  -1.2345 /    -1 =       1
  -12.345 /    -1 =      12
  -123.45 /    -1 =     123
 0.012345 /   -10 =       0
  0.12345 /   -10 =       0
   1.2345 /   -10 =       0
   12.345 /   -10 =      -1
   123.45 /   -10 =     -12
-0.012345 /   -10 =       0
 -0.12345 /   -10 =       0
  -1.2345 /   -10 =       0
  -12.345 /   -10 =       1
  -123.45 /   -10 =      12
 0.012345 /  -100 =       0
  0.12345 /  -100 =       0
   1.2345 /  -100 =       0
   12.345 /  -100 =       0
   123.45 /  -100 =      -1
-0.012345 /  -100 =       0
 -0.12345 /  -100 =       0
  -1.2345 /  -100 =       0
  -12.345 /  -100 =       0
  -123.45 /  -100 =       1

scale: 3
 0.012345 /  0.01 =       1.234
  0.12345 /  0.01 =      12.345
   1.2345 /  0.01 =     123.450
   12.345 /  0.01 =    1234.500
   123.45 /  0.01 =   12345.000
-0.012345 /  0.01 =      -1.234
 -0.12345 /  0.01 =     -12.345
  -1.2345 /  0.01 =    -123.450
  -12.345 /  0.01 =   -1234.500
  -123.45 /  0.01 =  -12345.000
 0.012345 /   0.1 =       0.123
  0.12345 /   0.1 =       1.234
   1.2345 /   0.1 =      12.345
   12.345 /   0.1 =     123.450
   123.45 /   0.1 =    1234.500
-0.012345 /   0.1 =      -0.123
 -0.12345 /   0.1 =      -1.234
  -1.2345 /   0.1 =     -12.345
  -12.345 /   0.1 =    -123.450
  -123.45 /   0.1 =   -1234.500
 0.012345 /     1 =       0.012
  0.12345 /     1 =       0.123
   1.2345 /     1 =       1.234
   12.345 /     1 =      12.345
   123.45 /     1 =     123.450
-0.012345 /     1 =      -0.012
 -0.12345 /     1 =      -0.123
  -1.2345 /     1 =      -1.234
  -12.345 /     1 =     -12.345
  -123.45 /     1 =    -123.450
 0.012345 /    10 =       0.001
  0.12345 /    10 =       0.012
   1.2345 /    10 =       0.123
   12.345 /    10 =       1.234
   123.45 /    10 =      12.345
-0.012345 /    10 =      -0.001
 -0.12345 /    10 =      -0.012
  -1.2345 /    10 =      -0.123
  -12.345 /    10 =      -1.234
  -123.45 /    10 =     -12.345
 0.012345 /   100 =       0.000
  0.12345 /   100 =       0.001
   1.2345 /   100 =       0.012
   12.345 /   100 =       0.123
   123.45 /   100 =       1.234
-0.012345 /   100 =       0.000
 -0.12345 /   100 =      -0.001
  -1.2345 /   100 =      -0.012
  -12.345 /   100 =      -0.123
  -123.45 /   100 =      -1.234
 0.012345 / -0.01 =      -1.234
  0.12345 / -0.01 =     -12.345
   1.2345 / -0.01 =    -123.450
   12.345 / -0.01 =   -1234.500
   123.45 / -0.01 =  -12345.000
-0.012345 / -0.01 =       1.234
 -0.12345 / -0.01 =      12.345
  -1.2345 / -0.01 =     123.450
  -12.345 / -0.01 =    1234.500
  -123.45 / -0.01 =   12345.000
 0.012345 /  -0.1 =      -0.123
  0.12345 /  -0.1 =      -1.234
   1.2345 /  -0.1 =     -12.345
   12.345 /  -0.1 =    -123.450
   123.45 /  -0.1 =   -1234.500
-0.012345 /  -0.1 =       0.123
 -0.12345 /  -0.1 =       1.234
  -1.2345 /  -0.1 =      12.345
  -12.345 /  -0.1 =     123.450
  -123.45 /  -0.1 =    1234.500
 0.012345 /    -1 =      -0.012
  0.12345 /    -1 =      -0.123
   1.2345 /    -1 =      -1.234
   12.345 /    -1 =     -12.345
   123.45 /    -1 =    -123.450
-0.012345 /    -1 =       0.012
 -0.12345 /    -1 =       0.123
  -1.2345 /    -1 =       1.234
  -12.345 /    -1 =      12.345
  -123.45 /    -1 =     123.450
 0.012345 /   -10 =      -0.001
  0.12345 /   -10 =      -0.012
   1.2345 /   -10 =      -0.123
   12.345 /   -10 =      -1.234
   123.45 /   -10 =     -12.345
-0.012345 /   -10 =       0.001
 -0.12345 /   -10 =       0.012
  -1.2345 /   -10 =       0.123
  -12.345 /   -10 =       1.234
  -123.45 /   -10 =      12.345
 0.012345 /  -100 =       0.000
  0.12345 /  -100 =      -0.001
   1.2345 /  -100 =      -0.012
   12.345 /  -100 =      -0.123
   123.45 /  -100 =      -1.234
-0.012345 /  -100 =       0.000
 -0.12345 /  -100 =       0.001
  -1.2345 /  -100 =       0.012
  -12.345 /  -100 =       0.123
  -123.45 /  -100 =       1.234

scale: 5
 0.012345 /  0.01 =       1.23450
  0.12345 /  0.01 =      12.34500
   1.2345 /  0.01 =     123.45000
   12.345 /  0.01 =    1234.50000
   123.45 /  0.01 =   12345.00000
-0.012345 /  0.01 =      -1.23450
 -0.12345 /  0.01 =     -12.34500
  -1.2345 /  0.01 =    -123.45000
  -12.345 /  0.01 =   -1234.50000
  -123.45 /  0.01 =  -12345.00000
 0.012345 /   0.1 =       0.12345
  0.12345 /   0.1 =       1.23450
   1.2345 /   0.1 =      12.34500
   12.345 /   0.1 =     123.45000
   123.45 /   0.1 =    1234.50000
-0.012345 /   0.1 =      -0.12345
 -0.12345 /   0.1 =      -1.23450
  -1.2345 /   0.1 =     -12.34500
  -12.345 /   0.1 =    -123.45000
  -123.45 /   0.1 =   -1234.50000
 0.012345 /     1 =       0.01234
  0.12345 /     1 =       0.12345
   1.2345 /     1 =       1.23450
   12.345 /     1 =      12.34500
   123.45 /     1 =     123.45000
-0.012345 /     1 =      -0.01234
 -0.12345 /     1 =      -0.12345
  -1.2345 /     1 =      -1.23450
  -12.345 /     1 =     -12.34500
  -123.45 /     1 =    -123.45000
 0.012345 /    10 =       0.00123
  0.12345 /    10 =       0.01234
   1.2345 /    10 =       0.12345
   12.345 /    10 =       1.23450
   123.45 /    10 =      12.34500
-0.012345 /    10 =      -0.00123
 -0.12345 /    10 =      -0.01234
  -1.2345 /    10 =      -0.12345
  -12.345 /    10 =      -1.23450
  -123.45 /    10 =     -12.34500
 0.012345 /   100 =       0.00012
  0.12345 /   100 =       0.00123
   1.2345 /   100 =       0.01234
   12.345 /   100 =       0.12345
   123.45 /   100 =       1.23450
-0.012345 /   100 =      -0.00012
 -0.12345 /   100 =      -0.00123
  -1.2345 /   100 =      -0.01234
  -12.345 /   100 =      -0.12345
  -123.45 /   100 =      -1.23450
 0.012345 / -0.01 =      -1.23450
  0.12345 / -0.01 =     -12.34500
   1.2345 / -0.01 =    -123.45000
   12.345 / -0.01 =   -1234.50000
   123.45 / -0.01 =  -12345.00000
-0.012345 / -0.01 =       1.23450
 -0.12345 / -0.01 =      12.34500
  -1.2345 / -0.01 =     123.45000
  -12.345 / -0.01 =    1234.50000
  -123.45 / -0.01 =   12345.00000
 0.012345 /  -0.1 =      -0.12345
  0.12345 /  -0.1 =      -1.23450
   1.2345 /  -0.1 =     -12.34500
   12.345 /  -0.1 =    -123.45000
   123.45 /  -0.1 =   -1234.50000
-0.012345 /  -0.1 =       0.12345
 -0.12345 /  -0.1 =       1.23450
  -1.2345 /  -0.1 =      12.34500
  -12.345 /  -0.1 =     123.45000
  -123.45 /  -0.1 =    1234.50000
 0.012345 /    -1 =      -0.01234
  0.12345 /    -1 =      -0.12345
   1.2345 /    -1 =      -1.23450
   12.345 /    -1 =     -12.34500
   123.45 /    -1 =    -123.45000
-0.012345 /    -1 =       0.01234
 -0.12345 /    -1 =       0.12345
  -1.2345 /    -1 =       1.23450
  -12.345 /    -1 =      12.34500
  -123.45 /    -1 =     123.45000
 0.012345 /   -10 =      -0.00123
  0.12345 /   -10 =      -0.01234
   1.2345 /   -10 =      -0.12345
   12.345 /   -10 =      -1.23450
   123.45 /   -10 =     -12.34500
-0.012345 /   -10 =       0.00123
 -0.12345 /   -10 =       0.01234
  -1.2345 /   -10 =       0.12345
  -12.345 /   -10 =       1.23450
  -123.45 /   -10 =      12.34500
 0.012345 /  -100 =      -0.00012
  0.12345 /  -100 =      -0.00123
   1.2345 /  -100 =      -0.01234
   12.345 /  -100 =      -0.12345
   123.45 /  -100 =      -1.23450
-0.012345 /  -100 =       0.00012
 -0.12345 /  -100 =       0.00123
  -1.2345 /  -100 =       0.01234
  -12.345 /  -100 =       0.12345
  -123.45 /  -100 =       1.23450
