/* Generated by re2c 4.3 */
/*
  +----------------------------------------------------------------------+
  | phar php single-file executable PHP extension                        |
  +----------------------------------------------------------------------+
  | Copyright (c) The PHP Group                                          |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | https://www.php.net/license/3_01.txt                                 |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors: Marcus Boerger <helly@php.net>                              |
  +----------------------------------------------------------------------+
*/

#include "phar_internal.h"

phar_path_check_result phar_path_check(char **s, size_t *len, const char **error)
{
	const unsigned char *p = (const unsigned char*)*s;
	const unsigned char *m;

	if (*len == 1 && *p == '.') {
		*error = "current directory reference";
		return pcr_err_curr_dir;
	} else if (*len == 2 && p[0] == '.' && p[1] == '.') {
		*error = "upper directory reference";
		return pcr_err_up_dir;
	}

#define YYCTYPE         unsigned char
#define YYCURSOR        p
#define YYLIMIT         p+*len
#define YYMARKER        m
#define YYFILL(n)       do {} while (0)

loop:

{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	if (yych <= '[') {
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych >= 0x01) goto yy1;
			} else {
				if (yych <= '\r') goto yy3;
				if (yych <= 0x19) goto yy1;
				goto yy4;
			}
		} else {
			if (yych <= '/') {
				if (yych <= '*') goto yy6;
				if (yych <= '.') goto yy4;
				goto yy7;
			} else {
				if (yych == '?') goto yy8;
				goto yy4;
			}
		}
	} else {
		if (yych <= 0xEC) {
			if (yych <= 0xC1) {
				if (yych <= '\\') goto yy9;
				if (yych <= 0x7F) goto yy4;
				goto yy1;
			} else {
				if (yych <= 0xDF) goto yy10;
				if (yych <= 0xE0) goto yy11;
				goto yy12;
			}
		} else {
			if (yych <= 0xF0) {
				if (yych <= 0xED) goto yy13;
				if (yych <= 0xEF) goto yy12;
				goto yy14;
			} else {
				if (yych <= 0xF3) goto yy15;
				if (yych <= 0xF4) goto yy16;
				goto yy1;
			}
		}
	}
	++YYCURSOR;
	{
			if (**s == '/') {
				(*s)++;
				(*len)--;
			}
			if ((p - (const unsigned char*)*s) - 1 != *len)
			{
				*error ="illegal character";
				return pcr_err_illegal_char;
			}
			*error = NULL;
			return pcr_is_ok;
		}
yy1:
	++YYCURSOR;
yy2:
	{
			*error ="illegal character";
			return pcr_err_illegal_char;
		}
yy3:
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy1;
	goto yy2;
yy4:
	++YYCURSOR;
yy5:
	{
			goto loop;
		}
yy6:
	++YYCURSOR;
	{
			*error = "star";
			return pcr_err_star;
		}
yy7:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') goto yy5;
	if (yych <= '.') goto yy17;
	if (yych <= '/') goto yy19;
	goto yy5;
yy8:
	++YYCURSOR;
	{
			if (**s == '/') {
				(*s)++;
			}
			*len = (p - (const unsigned char*)*s) -1;
			*error = NULL;
			return pcr_use_query;
		}
yy9:
	++YYCURSOR;
	{
			*error = "back-slash";
			return pcr_err_back_slash;
		}
yy10:
	yych = *++YYCURSOR;
	if (yych <= 0x7F) goto yy2;
	if (yych <= 0xBF) goto yy4;
	goto yy2;
yy11:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x9F) goto yy2;
	if (yych <= 0xBF) goto yy20;
	goto yy2;
yy12:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x7F) goto yy2;
	if (yych <= 0xBF) goto yy20;
	goto yy2;
yy13:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x7F) goto yy2;
	if (yych <= 0x9F) goto yy20;
	goto yy2;
yy14:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x8F) goto yy2;
	if (yych <= 0xBF) goto yy21;
	goto yy2;
yy15:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x7F) goto yy2;
	if (yych <= 0xBF) goto yy21;
	goto yy2;
yy16:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x7F) goto yy2;
	if (yych <= 0x8F) goto yy21;
	goto yy2;
yy17:
	yych = *++YYCURSOR;
	if (yych <= 0x00) goto yy22;
	if (yych <= '-') goto yy18;
	if (yych <= '.') goto yy23;
	if (yych <= '/') goto yy22;
yy18:
	YYCURSOR = YYMARKER;
	if (yyaccept == 0) goto yy5;
	else goto yy2;
yy19:
	++YYCURSOR;
	{
			*error = "double slash";
			return pcr_err_double_slash;
		}
yy20:
	yych = *++YYCURSOR;
	if (yych <= 0x7F) goto yy18;
	if (yych <= 0xBF) goto yy4;
	goto yy18;
yy21:
	yych = *++YYCURSOR;
	if (yych <= 0x7F) goto yy18;
	if (yych <= 0xBF) goto yy20;
	goto yy18;
yy22:
	++YYCURSOR;
	{
			*error = "current directory reference";
			return pcr_err_curr_dir;
		}
yy23:
	yych = *++YYCURSOR;
	if (yych <= 0x00) goto yy24;
	if (yych != '/') goto yy18;
yy24:
	++YYCURSOR;
	{
			*error = "upper directory reference";
			return pcr_err_up_dir;
		}
}

}
