from io import BytesIO

from translate.storage import ini

from . import test_monolingual


class TestINIUnit(test_monolingual.TestMonolingualUnit):
    UnitClass = ini.iniunit


class TestINIStore(test_monolingual.TestMonolingualStore):
    StoreClass = ini.inifile

    def test_serialize(self) -> None:
        content = b"[default]\nkey=None"
        store = self.StoreClass()
        store.parse(content)
        out = BytesIO()
        store.serialize(out)

        assert out.getvalue() == content

    def test_rem(self) -> None:
        content = b"[default]\nremaining=None"
        store = self.StoreClass()
        store.parse(content)
        assert len(store.units) == 1
        out = BytesIO()
        store.serialize(out)

        assert out.getvalue() == content
