/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sr_Latn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ccp = "čakma";
        final String metaValue_chr = "čeroki";
        final String metaValue_nqo = "nko";
        final String metaValue_vai = "vai";
        final Object[][] data = new Object[][] {
            { "001", "svet" },
            { "002", "Afrika" },
            { "003", "Severnoamerički kontinent" },
            { "005", "Južna Amerika" },
            { "009", "Okeanija" },
            { "011", "Zapadna Afrika" },
            { "013", "Centralna Amerika" },
            { "014", "Istočna Afrika" },
            { "015", "Severna Afrika" },
            { "017", "Centralna Afrika" },
            { "018", "Južna Afrika" },
            { "019", "Severna i Južna Amerika" },
            { "021", "Severna Amerika" },
            { "029", "Karibi" },
            { "030", "Istočna Azija" },
            { "034", "Južna Azija" },
            { "035", "Jugoistočna Azija" },
            { "039", "Južna Evropa" },
            { "053", "Australija i Novi Zeland" },
            { "054", "Melanezija" },
            { "057", "Mikronezijski region" },
            { "061", "Polinezija" },
            { "142", "Azija" },
            { "143", "Centralna Azija" },
            { "145", "Zapadna Azija" },
            { "150", "Evropa" },
            { "151", "Istočna Evropa" },
            { "154", "Severna Evropa" },
            { "155", "Zapadna Evropa" },
            { "202", "Podsaharska Afrika" },
            { "419", "Latinska Amerika" },
            { "AC", "Ostrvo Asension" },
            { "AD", "Andora" },
            { "AE", "Ujedinjeni Arapski Emirati" },
            { "AF", "Avganistan" },
            { "AG", "Antigva i Barbuda" },
            { "AI", "Angvila" },
            { "AL", "Albanija" },
            { "AM", "Jermenija" },
            { "AO", "Angola" },
            { "AQ", "Antarktik" },
            { "AR", "Argentina" },
            { "AS", "Američka Samoa" },
            { "AT", "Austrija" },
            { "AU", "Australija" },
            { "AW", "Aruba" },
            { "AX", "Olandska Ostrva" },
            { "AZ", "Azerbejdžan" },
            { "BA", "Bosna i Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladeš" },
            { "BE", "Belgija" },
            { "BF", "Burkina Faso" },
            { "BG", "Bugarska" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sveti Bartolomej" },
            { "BM", "Bermudi" },
            { "BN", "Brunej" },
            { "BO", "Bolivija" },
            { "BQ", "Karipska Holandija" },
            { "BR", "Brazil" },
            { "BS", "Bahami" },
            { "BT", "Butan" },
            { "BV", "Ostrvo Buve" },
            { "BW", "Bocvana" },
            { "BY", "Belorusija" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosova (Kilingova) Ostrva" },
            { "CD", "Kongo - Kinšasa" },
            { "CF", "Centralnoafrička Republika" },
            { "CG", "Kongo - Brazavil" },
            { "CH", "Švajcarska" },
            { "CI", "Obala Slonovače (Kot d’Ivoar)" },
            { "CK", "Kukova Ostrva" },
            { "CL", "Čile" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Kolumbija" },
            { "CP", "Ostrvo Kliperton" },
            { "CQ", "Sark" },
            { "CR", "Kostarika" },
            { "CU", "Kuba" },
            { "CV", "Zelenortska Ostrva" },
            { "CW", "Kurasao" },
            { "CX", "Božićno Ostrvo" },
            { "CY", "Kipar" },
            { "CZ", "Češka" },
            { "DE", "Nemačka" },
            { "DG", "Dijego Garsija" },
            { "DJ", "Džibuti" },
            { "DK", "Danska" },
            { "DM", "Dominika" },
            { "DO", "Dominikanska Republika" },
            { "DZ", "Alžir" },
            { "EA", "Seuta i Melilja" },
            { "EC", "Ekvador" },
            { "EE", "Estonija" },
            { "EG", "Egipat" },
            { "EH", "Zapadna Sahara" },
            { "ER", "Eritreja" },
            { "ES", "Španija" },
            { "ET", "Etiopija" },
            { "EU", "Evropska unija" },
            { "EZ", "Evrozona" },
            { "FI", "Finska" },
            { "FJ", "Fidži" },
            { "FK", "Foklandska Ostrva" },
            { "FM", "Mikronezija" },
            { "FO", "Farska Ostrva" },
            { "FR", "Francuska" },
            { "GA", "Gabon" },
            { "GB", "Ujedinjeno Kraljevstvo" },
            { "GD", "Grenada" },
            { "GE", "Gruzija" },
            { "GF", "Francuska Gvajana" },
            { "GG", "Gernzi" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Grenland" },
            { "GM", "Gambija" },
            { "GN", "Gvineja" },
            { "GP", "Gvadelup" },
            { "GQ", "Ekvatorijalna Gvineja" },
            { "GR", "Grčka" },
            { "GS", "Južna Džordžija i Južna Sendvička Ostrva" },
            { "GT", "Gvatemala" },
            { "GU", "Guam" },
            { "GW", "Gvineja-Bisao" },
            { "GY", "Gvajana" },
            { "HK", "SAR Hongkong (Kina)" },
            { "HM", "Ostrvo Herd i Mekdonaldova ostrva" },
            { "HN", "Honduras" },
            { "HR", "Hrvatska" },
            { "HT", "Haiti" },
            { "HU", "Mađarska" },
            { "IC", "Kanarska Ostrva" },
            { "ID", "Indonezija" },
            { "IE", "Irska" },
            { "IL", "Izrael" },
            { "IM", "Ostrvo Man" },
            { "IN", "Indija" },
            { "IO", "Britanska teritorija Indijskog okeana" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italija" },
            { "JE", "Džerzi" },
            { "JM", "Jamajka" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "KE", "Kenija" },
            { "KG", "Kirgistan" },
            { "KH", "Kambodža" },
            { "KI", "Kiribati" },
            { "KM", "Komorska Ostrva" },
            { "KN", "Sent Kits i Nevis" },
            { "KP", "Severna Koreja" },
            { "KR", "Južna Koreja" },
            { "KW", "Kuvajt" },
            { "KY", "Kajmanska Ostrva" },
            { "KZ", "Kazahstan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Sveta Lucija" },
            { "LI", "Lihtenštajn" },
            { "LK", "Šri Lanka" },
            { "LR", "Liberija" },
            { "LS", "Lesoto" },
            { "LT", "Litvanija" },
            { "LU", "Luksemburg" },
            { "LV", "Letonija" },
            { "LY", "Libija" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavija" },
            { "ME", "Crna Gora" },
            { "MF", "Sveti Martin (Francuska)" },
            { "MG", "Madagaskar" },
            { "MH", "Maršalska Ostrva" },
            { "MK", "Severna Makedonija" },
            { "ML", "Mali" },
            { "MM", "Mijanmar (Burma)" },
            { "MN", "Mongolija" },
            { "MO", "SAR Makao (Kina)" },
            { "MP", "Severna Marijanska Ostrva" },
            { "MQ", "Martinik" },
            { "MR", "Mauritanija" },
            { "MS", "Monserat" },
            { "MT", "Malta" },
            { "MU", "Mauricijus" },
            { "MV", "Maldivi" },
            { "MW", "Malavi" },
            { "MX", "Meksiko" },
            { "MY", "Malezija" },
            { "MZ", "Mozambik" },
            { "NA", "Namibija" },
            { "NC", "Nova Kaledonija" },
            { "NE", "Niger" },
            { "NF", "Ostrvo Norfok" },
            { "NG", "Nigerija" },
            { "NI", "Nikaragva" },
            { "NL", "Holandija" },
            { "NO", "Norveška" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Novi Zeland" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Francuska Polinezija" },
            { "PG", "Papua Nova Gvineja" },
            { "PH", "Filipini" },
            { "PK", "Pakistan" },
            { "PL", "Poljska" },
            { "PM", "Sen Pjer i Mikelon" },
            { "PN", "Pitkern" },
            { "PR", "Portoriko" },
            { "PS", "Palestinske teritorije" },
            { "PT", "Portugalija" },
            { "PW", "Palau" },
            { "PY", "Paragvaj" },
            { "QA", "Katar" },
            { "QO", "udaljena ostrva Okeanije" },
            { "RE", "Reinion" },
            { "RO", "Rumunija" },
            { "RS", "Srbija" },
            { "RU", "Rusija" },
            { "RW", "Ruanda" },
            { "SA", "Saudijska Arabija" },
            { "SB", "Solomonska Ostrva" },
            { "SC", "Sejšeli" },
            { "SD", "Sudan" },
            { "SE", "Švedska" },
            { "SG", "Singapur" },
            { "SH", "Sveta Jelena" },
            { "SI", "Slovenija" },
            { "SJ", "Svalbard i Jan Majen" },
            { "SK", "Slovačka" },
            { "SL", "Sijera Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalija" },
            { "SR", "Surinam" },
            { "SS", "Južni Sudan" },
            { "ST", "Sao Tome i Principe" },
            { "SV", "Salvador" },
            { "SX", "Sveti Martin (Holandija)" },
            { "SY", "Sirija" },
            { "SZ", "Svazilend" },
            { "TA", "Tristan da Kunja" },
            { "TC", "Ostrva Turks i Kaikos" },
            { "TD", "Čad" },
            { "TF", "Francuske Južne Teritorije" },
            { "TG", "Togo" },
            { "TH", "Tajland" },
            { "TJ", "Tadžikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste (Istočni Timor)" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunis" },
            { "TO", "Tonga" },
            { "TR", "Turska" },
            { "TT", "Trinidad i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajvan" },
            { "TZ", "Tanzanija" },
            { "UA", "Ukrajina" },
            { "UG", "Uganda" },
            { "UM", "Udaljena ostrva SAD" },
            { "UN", "Ujedinjene nacije" },
            { "US", "Sjedinjene Države" },
            { "UY", "Urugvaj" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikan" },
            { "VC", "Sent Vinsent i Grenadini" },
            { "VE", "Venecuela" },
            { "VG", "Britanska Devičanska Ostrva" },
            { "VI", "Američka Devičanska Ostrva" },
            { "VN", "Vijetnam" },
            { "VU", "Vanuatu" },
            { "WF", "Valis i Futuna" },
            { "WS", "Samoa" },
            { "XA", "simulirane dijakritike" },
            { "XB", "Pseudobidi" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Majot" },
            { "ZA", "Južnoafrička Republika" },
            { "ZM", "Zambija" },
            { "ZW", "Zimbabve" },
            { "ZZ", "nepoznat region" },
            { "aa", "afarski" },
            { "ab", "abhaski" },
            { "ae", "avestanski" },
            { "af", "afrikans" },
            { "ak", "akanski" },
            { "am", "amharski" },
            { "an", "aragonski" },
            { "ar", "arapski" },
            { "as", "asamski" },
            { "av", "avarski" },
            { "ay", "ajmara" },
            { "az", "azerbejdžanski" },
            { "ba", "baškirski" },
            { "be", "beloruski" },
            { "bg", "bugarski" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengalski" },
            { "bo", "tibetanski" },
            { "br", "bretonski" },
            { "bs", "bosanski" },
            { "ca", "katalonski" },
            { "ce", "čečenski" },
            { "ch", "čamoro" },
            { "co", "korzikanski" },
            { "cr", "kri" },
            { "cs", "češki" },
            { "cu", "crkvenoslovenski" },
            { "cv", "čuvaški" },
            { "cy", "velški" },
            { "da", "danski" },
            { "de", "nemački" },
            { "dv", "maldivski" },
            { "dz", "džonga" },
            { "ee", "eve" },
            { "el", "grčki" },
            { "en", "engleski" },
            { "eo", "esperanto" },
            { "es", "španski" },
            { "et", "estonski" },
            { "eu", "baskijski" },
            { "fa", "persijski" },
            { "ff", "fula" },
            { "fi", "finski" },
            { "fj", "fidžijski" },
            { "fo", "farski" },
            { "fr", "francuski" },
            { "fy", "zapadni frizijski" },
            { "ga", "irski" },
            { "gd", "škotski gelski" },
            { "gl", "galicijski" },
            { "gn", "gvarani" },
            { "gu", "gudžarati" },
            { "gv", "manks" },
            { "ha", "hausa" },
            { "he", "hebrejski" },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "hrvatski" },
            { "ht", "haićanski" },
            { "hu", "mađarski" },
            { "hy", "jermenski" },
            { "hz", "herero" },
            { "ia", "interlingva" },
            { "id", "indonežanski" },
            { "ie", "interlingve" },
            { "ig", "igbo" },
            { "ii", "sečuanski ji" },
            { "ik", "inupik" },
            { "io", "ido" },
            { "is", "islandski" },
            { "it", "italijanski" },
            { "iu", "inuktitutski" },
            { "ja", "japanski" },
            { "jv", "javanski" },
            { "ka", "gruzijski" },
            { "kg", "kongo" },
            { "ki", "kikuju" },
            { "kj", "kvanjama" },
            { "kk", "kazaški" },
            { "kl", "grenlandski" },
            { "km", "kmerski" },
            { "kn", "kanada" },
            { "ko", "korejski" },
            { "kr", "kanuri" },
            { "ks", "kašmirski" },
            { "ku", "kurmandži" },
            { "kv", "komi" },
            { "kw", "kornvolski" },
            { "ky", "kirgiski" },
            { "la", "latinski" },
            { "lb", "luksemburški" },
            { "lg", "ganda" },
            { "li", "limburški" },
            { "ln", "lingala" },
            { "lo", "laoski" },
            { "lt", "litvanski" },
            { "lu", "luba-katanga" },
            { "lv", "letonski" },
            { "mg", "malgaški" },
            { "mh", "maršalski" },
            { "mi", "maorski" },
            { "mk", "makedonski" },
            { "ml", "malajalam" },
            { "mn", "mongolski" },
            { "mr", "marati" },
            { "ms", "malajski" },
            { "mt", "malteški" },
            { "my", "burmanski" },
            { "na", "nauruski" },
            { "nb", "norveški bukmol" },
            { "nd", "severni ndebele" },
            { "ne", "nepalski" },
            { "ng", "ndonga" },
            { "nl", "holandski" },
            { "nn", "norveški ninorsk" },
            { "no", "norveški" },
            { "nr", "južni ndebele" },
            { "nv", "navaho" },
            { "ny", "njandža" },
            { "oc", "oksitanski" },
            { "oj", "odžibve" },
            { "om", "oromo" },
            { "or", "odija" },
            { "os", "osetinski" },
            { "pa", "pendžapski" },
            { "pi", "pali" },
            { "pl", "poljski" },
            { "ps", "paštunski" },
            { "pt", "portugalski" },
            { "qu", "kečua" },
            { "rm", "romanš" },
            { "rn", "kirundi" },
            { "ro", "rumunski" },
            { "ru", "ruski" },
            { "rw", "kinjaruanda" },
            { "sa", "sanskrit" },
            { "sc", "sardinski" },
            { "sd", "sindi" },
            { "se", "severni sami" },
            { "sg", "sango" },
            { "sh", "srpskohrvatski" },
            { "si", "sinhaleški" },
            { "sk", "slovački" },
            { "sl", "slovenački" },
            { "sm", "samoanski" },
            { "sn", "šona" },
            { "so", "somalski" },
            { "sq", "albanski" },
            { "sr", "srpski" },
            { "ss", "svazi" },
            { "st", "sesoto" },
            { "su", "sundski" },
            { "sv", "švedski" },
            { "sw", "svahili" },
            { "ta", "tamilski" },
            { "te", "telugu" },
            { "tg", "tadžički" },
            { "th", "tajski" },
            { "ti", "tigrinja" },
            { "tk", "turkmenski" },
            { "tl", "tagalog" },
            { "tn", "cvana" },
            { "to", "tonganski" },
            { "tr", "turski" },
            { "ts", "conga" },
            { "tt", "tatarski" },
            { "tw", "tvi" },
            { "ty", "tahićanski" },
            { "ug", "ujgurski" },
            { "uk", "ukrajinski" },
            { "ur", "urdu" },
            { "uz", "uzbečki" },
            { "ve", "venda" },
            { "vi", "vijetnamski" },
            { "vo", "volapik" },
            { "wa", "valonski" },
            { "wo", "volof" },
            { "xh", "kosa" },
            { "yi", "jidiš" },
            { "yo", "joruba" },
            { "za", "džuanški" },
            { "zh", "kineski" },
            { "zu", "zulu" },
            { "ace", "aceški" },
            { "ach", "akoli" },
            { "ada", "adangme" },
            { "ady", "adigejski" },
            { "afh", "afrihili" },
            { "agq", "agem" },
            { "ain", "ainu" },
            { "akk", "akadijski" },
            { "ale", "aleutski" },
            { "alt", "južnoaltajski" },
            { "ang", "staroengleski" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramejski" },
            { "arn", "mapuče" },
            { "arp", "arapaho" },
            { "ars", "najdiarapski" },
            { "arw", "aravački" },
            { "asa", "asu" },
            { "ast", "asturijski" },
            { "atj", "atikameku" },
            { "awa", "avadi" },
            { "bal", "belučki" },
            { "ban", "balijski" },
            { "bas", "basa" },
            { "bej", "bedža" },
            { "bem", "bemba" },
            { "bew", "betavi" },
            { "bez", "bena" },
            { "bgc", "harijanski" },
            { "bgn", "zapadni belučki" },
            { "bho", "bodžpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bla", "sisika" },
            { "blo", "anii" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bss", "akose" },
            { "bua", "burjatski" },
            { "bug", "bugijski" },
            { "byn", "blinski" },
            { "cad", "kado" },
            { "car", "karipski" },
            { "cay", "kajuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "sebuanski" },
            { "cgg", "čiga" },
            { "chb", "čipča" },
            { "chg", "čagataj" },
            { "chk", "čučki" },
            { "chm", "mari" },
            { "chn", "činučki" },
            { "cho", "čoktavski" },
            { "chp", "čipevjanski" },
            { "chr", metaValue_chr },
            { "chy", "čejenski" },
            { "cic", "čikaso" },
            { "ckb", "centralni kurdski" },
            { "clc", "čilkotin" },
            { "cop", "koptski" },
            { "crg", "mičif" },
            { "crh", "krimskotatarski" },
            { "crj", "jugoistočni kri" },
            { "crk", "plainskri" },
            { "crl", "severoistočni kri" },
            { "crm", "muzkri" },
            { "crr", "karolinški algonkvijan" },
            { "crs", "sejšelski kreolski francuski" },
            { "csb", "kašupski" },
            { "csw", "močvarni kri" },
            { "dak", "dakota" },
            { "dar", "darginski" },
            { "dav", "taita" },
            { "del", "delaverski" },
            { "den", "slejvi" },
            { "dgr", "dogripski" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "donjolužičkosrpski" },
            { "dua", "duala" },
            { "dum", "srednjeholandski" },
            { "dyo", "džola fonji" },
            { "dyu", "đula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efički" },
            { "egy", "staroegipatski" },
            { "eka", "ekadžuk" },
            { "elx", "elamitski" },
            { "enm", "srednjeengleski" },
            { "ewo", "evondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipinski" },
            { "fon", "fon" },
            { "frc", "kajunski francuski" },
            { "frm", "srednjefrancuski" },
            { "fro", "starofrancuski" },
            { "frr", "severnofrizijski" },
            { "frs", "istočnofrizijski" },
            { "fur", "friulski" },
            { "gaa", "ga" },
            { "gag", "gagauz" },
            { "gay", "gajo" },
            { "gba", "gbaja" },
            { "gez", "geez" },
            { "gil", "gilbertski" },
            { "gmh", "srednji visokonemački" },
            { "goh", "staronemački" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "gotski" },
            { "grb", "grebo" },
            { "grc", "starogrčki" },
            { "gsw", "nemački (Švajcarska)" },
            { "guz", "gusi" },
            { "gwi", "gvičinski" },
            { "hai", "haida" },
            { "haw", "havajski" },
            { "hax", "južni haida" },
            { "hil", "hiligajnonski" },
            { "hit", "hetitski" },
            { "hmn", "hmonški" },
            { "hnj", "hmong ndžua" },
            { "hsb", "gornjolužičkosrpski" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "ibanski" },
            { "ibb", "ibibio" },
            { "ikt", "zapadnokanadski inuktitut" },
            { "ilo", "iloko" },
            { "inh", "inguški" },
            { "jbo", "ložban" },
            { "jgo", "ngomba" },
            { "jmc", "mačame" },
            { "jpr", "judeo-persijski" },
            { "jrb", "judeo-arapski" },
            { "kaa", "kara-kalpaški" },
            { "kab", "kabile" },
            { "kac", "kačinski" },
            { "kaj", "džu" },
            { "kam", "kamba" },
            { "kaw", "kavi" },
            { "kbd", "kabardijski" },
            { "kcg", "tjap" },
            { "kde", "makonde" },
            { "kea", "zelenortski" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "kasi" },
            { "kho", "kotaneški" },
            { "khq", "kojra čiini" },
            { "kkj", "kako" },
            { "kln", "kalendžinski" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permski" },
            { "kok", "konkani" },
            { "kos", "kosrenski" },
            { "kpe", "kpele" },
            { "krc", "karačajsko-balkarski" },
            { "kri", "krio" },
            { "krl", "karelski" },
            { "kru", "kuruk" },
            { "ksb", "šambala" },
            { "ksf", "bafija" },
            { "ksh", "kelnski" },
            { "kum", "kumički" },
            { "kut", "kutenaj" },
            { "kwk", "kvakvala" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "landa" },
            { "lam", "lamba" },
            { "lez", "lezginski" },
            { "lij", "ligurski" },
            { "lil", "lilut" },
            { "lkt", "lakota" },
            { "lmo", "lombard" },
            { "lol", "mongo" },
            { "lou", "luizijanski kreolski" },
            { "loz", "lozi" },
            { "lrc", "severni luri" },
            { "lsm", "samia" },
            { "lua", "luba-lulua" },
            { "lui", "luisenjo" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "mizo" },
            { "luy", "lujia" },
            { "mad", "madurski" },
            { "mag", "magahi" },
            { "mai", "maitili" },
            { "mak", "makasarski" },
            { "man", "mandingo" },
            { "mas", "masajski" },
            { "mdf", "mokša" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "morisjen" },
            { "mga", "srednjeirski" },
            { "mgh", "makuva-mito" },
            { "mgo", "meta" },
            { "mic", "mikmak" },
            { "min", "minangkabau" },
            { "mnc", "mandžurski" },
            { "mni", "manipurski" },
            { "moe", "inuajmun" },
            { "moh", "mohočki" },
            { "mos", "mosi" },
            { "mua", "mundang" },
            { "mul", "Više jezika" },
            { "mus", "kriški" },
            { "mwl", "mirandski" },
            { "mwr", "marvari" },
            { "myv", "erzja" },
            { "mzn", "mazanderanski" },
            { "nap", "napuljski" },
            { "naq", "nama" },
            { "nds", "niskonemački" },
            { "new", "nevari" },
            { "nia", "nias" },
            { "niu", "niuejski" },
            { "nmg", "kvasio" },
            { "nnh", "ngiembun" },
            { "nog", "nogajski" },
            { "non", "staronordijski" },
            { "nqo", metaValue_nqo },
            { "nso", "severni soto" },
            { "nus", "nuer" },
            { "nwc", "klasični nevarski" },
            { "nym", "njamvezi" },
            { "nyn", "njankole" },
            { "nyo", "njoro" },
            { "nzi", "nzima" },
            { "ojb", "severozapadni odžibva" },
            { "ojc", "centralni odžibva" },
            { "ojs", "odžikri" },
            { "ojw", "zapadni odžibva" },
            { "oka", "okangan" },
            { "osa", "osage" },
            { "ota", "osmanski turski" },
            { "pag", "pangasinanski" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papijamento" },
            { "pau", "palauski" },
            { "pcm", "nigerijski pidžin" },
            { "peo", "staropersijski" },
            { "phn", "feničanski" },
            { "pis", "pidžin" },
            { "pon", "ponpejski" },
            { "pqm", "malisepasamakvodi" },
            { "prg", "pruski" },
            { "pro", "starooksitanski" },
            { "quc", "kiče" },
            { "raj", "radžastanski" },
            { "rap", "rapanui" },
            { "rar", "rarotonganski" },
            { "rhg", "rohingja" },
            { "rof", "rombo" },
            { "rom", "romski" },
            { "rup", "cincarski" },
            { "rwk", "rua" },
            { "sad", "sandave" },
            { "sah", "saha" },
            { "sam", "samarijanski aramejski" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "sba", "ngambaj" },
            { "sbp", "sangu" },
            { "scn", "sicilijanski" },
            { "sco", "škotski" },
            { "sdh", "južnokurdski" },
            { "seh", "sena" },
            { "sel", "selkupski" },
            { "ses", "kojraboro seni" },
            { "sga", "staroirski" },
            { "shi", "tašelhit" },
            { "shn", "šanski" },
            { "sid", "sidamo" },
            { "slh", "južni lašutsid" },
            { "sma", "južni sami" },
            { "smj", "lule sami" },
            { "smn", "inari sami" },
            { "sms", "skolt sami" },
            { "snk", "soninke" },
            { "sog", "sogdijski" },
            { "srn", "sranan tongo" },
            { "srr", "sererski" },
            { "ssy", "saho" },
            { "str", "streicsališ" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumerski" },
            { "swb", "komorski" },
            { "syc", "sirijački" },
            { "syr", "sirijski" },
            { "szl", "siležanski" },
            { "tce", "južni tačon" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "tagiš" },
            { "tht", "tahltan" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tlh", "klingonski" },
            { "tli", "tlingit" },
            { "tmh", "tamašek" },
            { "tog", "njasa tonga" },
            { "tok", "tokipona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tsi", "cimšian" },
            { "ttm", "severni tučon" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasavak" },
            { "tyv", "tuvinski" },
            { "tzm", "centralnoatlaski tamašek" },
            { "udm", "udmurtski" },
            { "uga", "ugaritski" },
            { "umb", "umbundu" },
            { "und", "nepoznat jezik" },
            { "vai", metaValue_vai },
            { "vec", "venecijanski" },
            { "vmw", "makuva" },
            { "vot", "vodski" },
            { "vun", "vundžo" },
            { "wae", "valserski" },
            { "wal", "volajta" },
            { "war", "varajski" },
            { "was", "vašo" },
            { "wbp", "varlpiri" },
            { "wuu", "vu kineski" },
            { "xal", "kalmički" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yao", "jao" },
            { "yap", "japski" },
            { "yav", "jangben" },
            { "ybb", "jemba" },
            { "yrl", "ningatu" },
            { "yue", "kantonski" },
            { "zap", "zapotečki" },
            { "zbl", "blisimboli" },
            { "zen", "zenaga" },
            { "zgh", "standardni marokanski tamazigt" },
            { "zun", "zuni" },
            { "zxx", "bez lingvističkog sadržaja" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Arab", "arapsko pismo" },
            { "Aran", "nastalik" },
            { "Armi", "imperijsko aramejsko pismo" },
            { "Armn", "jermensko pismo" },
            { "Avst", "avestansko pismo" },
            { "Bali", "balijsko pismo" },
            { "Batk", "batak pismo" },
            { "Beng", "bengalsko pismo" },
            { "Blis", "blisimbolično pismo" },
            { "Bopo", "bopomofo pismo" },
            { "Brah", "bramansko pismo" },
            { "Brai", "brajevo pismo" },
            { "Bugi", "buginsko pismo" },
            { "Buhd", "buhidsko pismo" },
            { "Cakm", metaValue_ccp },
            { "Cans", "ujedinjeni kanadski aboridžinski silabici" },
            { "Cari", "karijsko pismo" },
            { "Cham", "čamsko pismo" },
            { "Cher", metaValue_chr },
            { "Cirt", "cirt pismo" },
            { "Copt", "koptičko pismo" },
            { "Cprt", "kiparsko pismo" },
            { "Cyrl", "ćirilica" },
            { "Cyrs", "Staroslovenska crkvena ćirilica" },
            { "Deva", "devanagari" },
            { "Dsrt", "Dezeret" },
            { "Egyd", "egipatsko narodno pismo" },
            { "Egyh", "egipatsko hijeratsko pismo" },
            { "Egyp", "egipatski hijeroglifi" },
            { "Ethi", "etiopsko pismo" },
            { "Geok", "gruzijsko khutsuri pismo" },
            { "Geor", "gruzijsko pismo" },
            { "Glag", "glagoljica" },
            { "Goth", "Gotika" },
            { "Grek", "grčko pismo" },
            { "Gujr", "gudžaratsko pismo" },
            { "Guru", "gurmuki pismo" },
            { "Hanb", "hanb" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanuno" },
            { "Hans", "pojednostavljeno kinesko pismo" },
            { "Hant", "tradicionalno kinesko pismo" },
            { "Hebr", "hebrejsko pismo" },
            { "Hira", "hiragana" },
            { "Hmng", "pahav hmong pismo" },
            { "Hrkt", "japanska slogovna pisma" },
            { "Hung", "staromađarsko pismo" },
            { "Inds", "induško pismo" },
            { "Ital", "stari italik" },
            { "Jamo", "džamo" },
            { "Java", "javansko pismo" },
            { "Jpan", "japansko pismo" },
            { "Kali", "kajah-li pismo" },
            { "Kana", "katakana" },
            { "Khar", "karošti pismo" },
            { "Khmr", "kmersko pismo" },
            { "Knda", "kanada pismo" },
            { "Kore", "korejsko pismo" },
            { "Kthi", "kaiti" },
            { "Lana", "lanna pismo" },
            { "Laoo", "laoško pismo" },
            { "Latf", "latinica (fraktur varijanta)" },
            { "Latg", "galska latinica" },
            { "Latn", "latinica" },
            { "Lepc", "lepča pismo" },
            { "Limb", "limbu pismo" },
            { "Lina", "linearno A pismo" },
            { "Linb", "linearno B pismo" },
            { "Lyci", "lisijsko pismo" },
            { "Lydi", "lidijsko pismo" },
            { "Mand", "mandeansko pismo" },
            { "Mani", "manihejsko pismo" },
            { "Maya", "majanski hijeroglifi" },
            { "Mero", "meroitik pismo" },
            { "Mlym", "malajalamsko pismo" },
            { "Mong", "mongolsko pismo" },
            { "Moon", "mesečevo pismo" },
            { "Mtei", "meitei majek" },
            { "Mymr", "mijanmarsko pismo" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ogamsko pismo" },
            { "Olck", "ol čiki" },
            { "Orkh", "orkonsko pismo" },
            { "Orya", "orijansko pismo" },
            { "Osma", "osmanjansko pismo" },
            { "Perm", "staro permiksko pismo" },
            { "Phag", "pags-pa pismo" },
            { "Phli", "pisani pahlavi" },
            { "Phlp", "psalter pahlavi" },
            { "Phlv", "pahlavi pismo" },
            { "Phnx", "Feničansko pismo" },
            { "Plrd", "porald fonetsko pismo" },
            { "Prti", "pisani partian" },
            { "Rjng", "rejang pismo" },
            { "Rohg", "hanifi" },
            { "Roro", "rongorongo pismo" },
            { "Runr", "runsko pismo" },
            { "Samr", "samaritansko pismo" },
            { "Sara", "sarati pismo" },
            { "Saur", "sauraštra pismo" },
            { "Sgnw", "znakovno pismo" },
            { "Shaw", "šavijansko pismo" },
            { "Sinh", "sinhalsko pismo" },
            { "Sund", "sundansko pismo" },
            { "Sylo", "siloti nagri pismo" },
            { "Syrc", "sirijsko pismo" },
            { "Syre", "sirijsko estrangelo pismo" },
            { "Syrj", "zapadnosirijsko pismo" },
            { "Syrn", "pismo istočne Sirije" },
            { "Tagb", "tagbanva pismo" },
            { "Tale", "tai le pismo" },
            { "Talu", "novi tai lue" },
            { "Taml", "tamilsko pismo" },
            { "Tavt", "tai viet pismo" },
            { "Telu", "telugu pismo" },
            { "Teng", "tengvar pismo" },
            { "Tfng", "tifinag" },
            { "Tglg", "Tagalog" },
            { "Thaa", "tana pismo" },
            { "Thai", "tajlandsko pismo" },
            { "Tibt", "tibetansko pismo" },
            { "Ugar", "ugaritsko pismo" },
            { "Vaii", metaValue_vai },
            { "Visp", "vidljivi govor" },
            { "Xpeo", "staropersijsko pismo" },
            { "Xsux", "sumersko-akadsko kuneiform pismo" },
            { "Yiii", "ji" },
            { "Zinh", "nasledno pismo" },
            { "Zmth", "matematička notacija" },
            { "Zsye", "emodži" },
            { "Zsym", "simboli" },
            { "Zxxx", "nepisani jezik" },
            { "Zyyy", "zajedničko pismo" },
            { "Zzzz", "nepoznato pismo" },
            { "de_AT", "austrijski nemački" },
            { "de_CH", "švajcarski visoki nemački" },
            { "en_GB", "engleski (Velika Britanija)" },
            { "en_US", "engleski (Sjedinjene Američke Države)" },
            { "es_ES", "evropski španski" },
            { "es_MX", "meksički španski" },
            { "fa_AF", "dari" },
            { "fr_CA", "kanadski francuski" },
            { "fr_CH", "švajcarski francuski" },
            { "nl_BE", "flamanski" },
            { "pt_BR", "brazilski portugalski" },
            { "pt_PT", "evropski portugalski" },
            { "ro_MD", "moldavski" },
            { "sw_CD", "kisvahili" },
            { "%%1901", "Tradicionalna nemačka ortografija" },
            { "%%1994", "Standardnizovana resijanska ortografija" },
            { "%%1996", "Nemačka ortografija iz 1996" },
            { "ar_001", "savremeni standardni arapski" },
            { "es_419", "latinoamerički španski" },
            { "key.ca", "kalendar" },
            { "key.cf", "format valute" },
            { "key.co", "redosled sortiranja" },
            { "key.cu", "valuta" },
            { "key.em", "prezentacija emodžija" },
            { "key.hc", "prikazivanje vremena (12- ili 24-časovno)" },
            { "key.lb", "stil preloma reda" },
            { "key.lw", "prelomi redova unutar reči" },
            { "key.ms", "sistem mernih jedinica" },
            { "key.nu", "brojevi" },
            { "key.ss", "Prelom rečenice posle skraćenice" },
            { "key.tz", "Vremenska zona" },
            { "key.va", "Varijanta lokaliteta" },
            { "nds_NL", "niskosaksonski" },
            { "%%BISKE", "San Đorđio/Bila dijalekt" },
            { "%%BOONT", "Buntling" },
            { "%%LIPAW", "Lipovički dijalekt resijanski" },
            { "%%NEDIS", "Natisone dijalekt" },
            { "%%NJIVA", "Gnjiva/Njiva dijalkekt" },
            { "%%OSOJS", "Oseako/Osojane dijalekt" },
            { "%%POSIX", "Kompjuter" },
            { "%%ROZAJ", "Resijan" },
            { "%%SAAHO", "Saho" },
            { "%%SOLBA", "Stolvica/Solbica dijalekt" },
            { "zh_Hans", "pojednostavljeni kineski" },
            { "zh_Hant", "tradicionalni kineski" },
            { "%%FONIPA", "IPA fonetika" },
            { "%%FONUPA", "UPA fonetika" },
            { "%%SCOUSE", "Skauz" },
            { "%%TARASK", "Taraskijevička ortografija" },
            { "%%AREVELA", "Istočni armenijski" },
            { "%%AREVMDA", "Zapadno jermenska" },
            { "%%MONOTON", "Monotonik" },
            { "%%POLYTON", "Politonik" },
            { "%%REVISED", "Revidirana ortografija" },
            { "%%1606NICT", "Francuski iz kasnog srednjeg veka do 1606." },
            { "%%1694ACAD", "Rani moderni francuski" },
            { "%%BAKU1926", "Ujedinjen turski latinični alfabet" },
            { "%%SCOTLAND", "Škotski standardni Engleski" },
            { "%%VALENCIA", "Valencijska" },
            { "type.ca.roc", "kalendar Republike Kine" },
            { "type.co.eor", "evropska pravila redosleda" },
            { "type.hc.h11", "12-časovni sistem (0-11)" },
            { "type.hc.h12", "12-časovni sistem (1-12)" },
            { "type.hc.h23", "24-časovni sistem (0-23)" },
            { "type.hc.h24", "24-časovni sistem (1-24)" },
            { "type.m0.bgn", "BGN (BGN)" },
            { "type.nu.arab", "arapsko-indijske cifre" },
            { "type.nu.armn", "jermenski brojevi" },
            { "type.nu.beng", "bengalske cifre" },
            { "type.nu.cakm", "čakma cifre" },
            { "type.nu.deva", "devangari cifre" },
            { "type.nu.ethi", "etiopski brojevi" },
            { "type.nu.geor", "gruzijski brojevi" },
            { "type.nu.grek", "grčki brojevi" },
            { "type.nu.gujr", "gudžaratske cifre" },
            { "type.nu.guru", "gurmuki cifre" },
            { "type.nu.hans", "pojednostavljeni kineski brojevi" },
            { "type.nu.hant", "tradicionalni kineski brojevi" },
            { "type.nu.hebr", "hebrejski brojevi" },
            { "type.nu.java", "javanske cifre" },
            { "type.nu.jpan", "japanski brojevi" },
            { "type.nu.khmr", "kmerske cifre" },
            { "type.nu.knda", "kanada cifre" },
            { "type.nu.laoo", "laoške cifre" },
            { "type.nu.latn", "zapadne cifre" },
            { "type.nu.mlym", "malajalam cifre" },
            { "type.nu.mong", "mongolske cifre" },
            { "type.nu.mtei", "mitei majek cifre" },
            { "type.nu.mymr", "mijanmarske cifre" },
            { "type.nu.olck", "ol čiki cifre" },
            { "type.nu.orya", "orija cifre" },
            { "type.nu.taml", "tamilski brojevi" },
            { "type.nu.telu", "telugu cifre" },
            { "type.nu.thai", "tajske cifre" },
            { "type.nu.tibt", "tibetanske cifre" },
            { "type.nu.vaii", "vai cifre" },
            { "type.ca.dangi", "dangi kalendar" },
            { "type.co.ducet", "podrazumevani Unicode redosled sortiranja" },
            { "type.lb.loose", "razmaknuti stil preloma reda" },
            { "type.nu.roman", "rimski brojevi" },
            { "type.ca.coptic", "koptski kalendar" },
            { "type.ca.hebrew", "hebrejski kalendar" },
            { "type.ca.indian", "Indijski nacionalni kalendar" },
            { "type.co.compat", "prethodni redosled sortiranja, zbog kompatibilnosti" },
            { "type.co.pinyin", "pinjin sortiranje" },
            { "type.co.search", "pretraga opšte namene" },
            { "type.co.stroke", "sortiranje po broju poteza" },
            { "type.co.unihan", "redosled sortiranja radikalnih poteza" },
            { "type.co.zhuyin", "žujin" },
            { "type.d0.fwidth", "puna širina" },
            { "type.d0.hwidth", "pola širine" },
            { "type.lb.normal", "normalni stil preloma reda" },
            { "type.lb.strict", "strogi stil preloma reda" },
            { "type.m0.ungegn", "UNGEGN (BGN)" },
            { "type.ms.metric", "metrički sistem" },
            { "type.nu.native", "lokalne cifre" },
            { "type.ca.chinese", "kineski kalendar" },
            { "type.ca.islamic", "islamski kalendar" },
            { "type.ca.iso8601", "ISO-8601 kalendar" },
            { "type.ca.persian", "persijski kalendar" },
            { "type.cf.account", "računovodstveni format valute" },
            { "type.d0.npinyin", "Numerička" },
            { "type.nu.arabext", "produžene arapsko-indijske cifre" },
            { "type.nu.armnlow", "mali jermenski brojevi" },
            { "type.nu.finance", "Finansijski brojevi" },
            { "type.nu.greklow", "mali grčki brojevi" },
            { "type.nu.hanidec", "kineski decimalni brojevi" },
            { "type.nu.hansfin", "pojednostavljeni kineski finansijski brojevi" },
            { "type.nu.hantfin", "tradicionalni kineski finansijski brojevi" },
            { "type.nu.jpanfin", "japanski finansijski brojevi" },
            { "type.nu.tamldec", "tamilske cifre" },
            { "type.ca.buddhist", "budistički kalendar" },
            { "type.ca.ethiopic", "etiopski kalendar" },
            { "type.ca.japanese", "japanski kalendar" },
            { "type.cf.standard", "standardni format valute" },
            { "type.co.phonetic", "fonetski redosled sortiranja" },
            { "type.co.searchjl", "Pretraga prema hangul početnom suglasniku" },
            { "type.co.standard", "standardni redosled sortiranja" },
            { "type.ms.uksystem", "imperijalni" },
            { "type.ms.ussystem", "američki sistem" },
            { "type.nu.fullwide", "cifre pune širine" },
            { "type.nu.romanlow", "mali rimski brojevi" },
            { "type.ca.gregorian", "gregorijanski kalendar" },
            { "type.co.phonebook", "sortiranje kao telefonski imenik" },
            { "type.co.dictionary", "redosled sortiranja u rečniku" },
            { "type.co.traditional", "tradicionalno sortiranje" },
            { "type.nu.traditional", "Tradicionalni brojevi" },
            { "type.ca.islamic-tbla", "islamski astronomski kalendar" },
            { "type.ca.islamic-civil", "islamski civilni kalendar" },
            { "type.ca.islamic-umalqura", "islamski kalendar (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "etiopski amet alem kalendar" },
        };
        return data;
    }
}
