/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_lo extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ເວ​ລາກຣີນ​ວິ​ຊ",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "ເວລາມາດຕະຖານຂອງອາເກຣ",
               "",
               "ເວລາລະດູຮ້ອນຂອງອາເກຣ",
               "",
               "ເວລາຂອງອາເກຣ",
               "",
            };
        final String[] Apia = new String[] {
               "ເວລາມາດຕະຖານເອເພຍ",
               "",
               "ເວລາກາງເວັນອາເພຍ",
               "",
               "ເວລາເອເພຍ",
               "",
            };
        final String[] Cook = new String[] {
               "ເວລາມາດຕະຖານຫມູ່ເກາະຄຸກ",
               "",
               "ເວ​ລາ​ເຄິ່ງ​ລະ​ດູ​ຮ້ອນ​ໝູ່​ເກາະ​ຄຸກ",
               "",
               "ເວລາຫມູ່ເກາະຄຸກ",
               "",
            };
        final String[] Cuba = new String[] {
               "ເວລາມາດຕະຖານຂອງຄິວບາ",
               "CST",
               "ເວລາກາງເວັນຄິວບາ",
               "CDT",
               "ເວລາຄິວບາ",
               "CT",
            };
        final String[] Fiji = new String[] {
               "ເວລາມາດຕະຖານຟິຈິ",
               "",
               "ເວລາລະດູຮ້ອນຟິຈິ",
               "",
               "ເວລາຟິຈິ",
               "",
            };
        final String[] Gulf = new String[] {
               "ເວ​ລາ​ກູ​ລ​໌ຟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "​ເວ​ລາ​ມາດ​ຕະ​ຖານ​ຮອບ​ດ໌",
               "",
               "​ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ຮອບ​ດ໌",
               "",
               "ເວ​ລາ​ຮອບ​ດ໌",
               "",
            };
        final String[] Iran = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານອີ​ຣານ",
               "",
               "ເວ​ລາ​ຕອນ​ທ່ຽງ​ອີ​ຣາ​ນ",
               "",
               "ເວ​ລາ​ອີ​ຣານ",
               "",
            };
        final String[] Niue = new String[] {
               "ເວລານິອູເອ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານອອມ​ສ​ຄ໌",
               "",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນອອມ​ສ​ຄ໌",
               "",
               "​ເວ​ລາອອມ​ສ​ຄ໌",
               "",
            };
        final String[] Peru = new String[] {
               "ເວ​ລາ​​ມາ​ດ​ຕະ​ຖານເປ​ຣູ",
               "",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ເປ​ຣູ",
               "",
               "ເວ​ລາ​ເປ​ຣູ",
               "",
            };
        final String[] Truk = new String[] {
               "ເວລາຊຸກ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ເວລາເກາະເວກ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານຊິ​ລີ",
               "",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນຊິ​ລີ",
               "",
               "ເວ​ລາ​ຊິ​ລີ",
               "",
            };
        final String[] China = new String[] {
               "ເວລາມາດຕະຖານຈີນ",
               "CST",
               "​ເວ​ລາ​ຕອນ​ທ່ຽງ​ຈີນ",
               "CDT",
               "ເວ​ລາ​ຈີນ",
               "CT",
            };
        final String[] Cocos = new String[] {
               "ເວລາຫມູ່ເກາະໂກໂກສ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ເວລາເດວິດ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ເວລາ ອິນເດຍ",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານ​ຍີ່​ປຸ່ນ",
               "JST",
               "ເວ​ລາ​ຕອນ​ທ່ຽງ​ຍີ່​ປຸ່ນ",
               "JDT",
               "ເວ​ລາ​ຍີ່​ປຸ່ນ",
               "JT",
            };
        final String[] Korea = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານ​ເກົາ​ຫລີ",
               "KST",
               "ເວ​ລາ​ຕອນ​ທ່ຽງ​ເກົາ​ຫລີ",
               "KST",
               "ເວລາເກົາຫຼີ",
               "KST",
            };
        final String[] Nauru = new String[] {
               "ເວ​ລາ​ນາ​ອູ​ຣຸ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "​ເວ​ລາ​ເນ​ປານ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "ເວລາປາເລົາ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "ເວລາມາດຕະຖານຊາມົວ",
               "SST",
               "ເວລາລະດູຮ້ອນຊາມົວ",
               "SST",
               "ເວລາຊາມົວ",
               "SST",
            };
        final String[] Syowa = new String[] {
               "ເວລາ ໂຊວາ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ເວລາມາດຕະຖານຕອງກາ",
               "",
               "ເວລາລະດູຮ້ອນຕອງກາ",
               "",
               "ເວລາຕອງກາ",
               "",
            };
        final String[] Yukon = new String[] {
               "ເວລາຢູຄອນ",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "ເວລາມາດຕະຖານອະລັສກາ",
               "AKST",
               "ເວລາກາງເວັນອະລັສກາ",
               "AKDT",
               "ເວລາອະລັສກາ",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານອາ​ເມ​ຊອນ",
               "",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນອາ​ເມ​ຊອນ",
               "",
               "ເວລາຕາມເຂດອາເມຊອນ",
               "",
            };
        final String[] Azores = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານອາ​ໂຊ​ເຣ​ສ",
               "",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນອາ​ໂຊ​ເຣ​ສ",
               "",
               "ເວ​ລາ​ອາ​ໂຊ​ເຣ​ສ",
               "",
            };
        final String[] Bhutan = new String[] {
               "ເວ​ລາ​ພູ​ຖານ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "​ເວ​ລາບຣູ​ໄນດາ​ຣຸສ​ຊາ​ລາມ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານເກາະ​ອີ​ສ​ເຕີ",
               "",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນເກາະ​ອີ​ສ​ເຕີ",
               "",
               "ເວ​ລາ​ເກາະ​ອີ​ສ​ເຕີ",
               "",
            };
        final String[] Guyana = new String[] {
               "ເວລາກາຍອານາ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "ເວລາມາດຕະຖານຮາວາຍ-ເອລູທຽນ",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານອິ​ສ​ຣາ​ເອວ",
               "IST",
               "ເວລາກາງເວັນອິສຣາເອວ",
               "IDT",
               "ເວ​ລາ​ອິ​ສ​ຣາ​ເອວ",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "ເວລາຄອສແຣ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "ເວລາມໍສັນ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານມອ​ສ​ໂຄ",
               "MSK",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນມອ​ສ​ໂຄ",
               "MSK",
               "ເວ​ລາ​ມອ​ສ​ໂຄ",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "ເວລາໂປເນບ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "ເວລາທາຮິຕິ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານ​ໄທ​ເປ",
               "CST",
               "ເວ​ລາ​ຕອນ​ທ່​ຽງ​ໄທ​ເປ",
               "CDT",
               "ເວ​ລາ​ໄທ​ເປ",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "ເວລາຕູວາລູ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ເວລາ ວອສໂຕກ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "ເວລາວາລລິສ ແລະ ຟູຕູນາ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານອາ​ຣາ​ບຽນ",
               "",
               "ເວລາກາງເວັນອາຣາບຽນ",
               "",
               "ເວ​ລາ​ອາ​ຣາ​ບຽນ",
               "",
            };
        final String[] Armenia = new String[] {
               "ເວລາມາດຕະຖານອາເມເນຍ",
               "",
               "ເວລາລະດູຮ້ອນອາເມເນຍ",
               "",
               "ເວລາອາເມເນຍ",
               "",
            };
        final String[] Bolivia = new String[] {
               "ເວ​ລາ​ໂບ​ລິ​ເວຍ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານ​ຊາ​ທາມ",
               "",
               "ເວ​ລາ​ຕອນ​ທ່ຽງ​ຊາ​ທາມ",
               "",
               "ເວ​ລາ​ຊາ​ທາມ",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "ເວລາສາກົນເຊີງພິກັດ",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ເວ​ລາ​ເອ​ກົວ​ດໍ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "ເວລາແກມເບຍ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "ເວລາມາດຕະຖານຈໍເຈຍ",
               "",
               "ເວລາລະດູຮ້ອນຈໍເຈຍ",
               "",
               "ເວລາຈໍເຈຍ",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ເວ​ລາມາດ​ຕະ​ຖານອີ​ຄຸດ​ສ​ຄ໌",
               "",
               "ເວ​ລາລະ​ດູ​ຮ້ອນອີ​ຄຸດ​ສ​ຄ໌",
               "",
               "ເວ​ລ​າອີ​ຄຸດ​ສ​ຄ໌",
               "",
            };
        final String[] Magadan = new String[] {
               "ເວລາມາດຕະຖານເມັກກາເດນ",
               "",
               "ເວລາລະດູຮ້ອນເມັກກາເດນ",
               "",
               "ເວລາເມັກກາເດນ",
               "",
            };
        final String[] Myanmar = new String[] {
               "ເວລາມຽນມາ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານເກາະ​ນໍ​ຟອ​ລ໌ກ",
               "",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນເກາະ​ນໍ​ຟອ​ລ໌ກ",
               "",
               "ເວ​ລາ​ເກາະ​ນໍ​ຟອ​ລ໌ກ",
               "",
            };
        final String[] Noronha = new String[] {
               "ເວລາມາດຕະຖານເຟນັນໂດເດໂນຮອນຮາ",
               "",
               "ເວລາລະດູຮ້ອນເຟນັນໂດເດໂນຮອນຮາ",
               "",
               "ເວລາເຟນັນໂດເດໂນຮອນຮາ",
               "",
            };
        final String[] Reunion = new String[] {
               "ເວ​ລາ​ເຣ​ອູ​ນິ​ຢົງ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "ເວລາ ໂຣທີຕາ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "ເວລາຫມູ່ເກາະໂຊໂລມອນ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "ເວລາໂຕເກເລົາ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານ​ອູ​ຣູ​ກວຍ",
               "",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ອູ​ຣູ​ກວຍ",
               "",
               "​ເວ​ລາ​ອູ​ຣູ​ກວຍ",
               "",
            };
        final String[] Vanuatu = new String[] {
               "ເວລາມາດຕະຖານວານູອາຕູ",
               "",
               "ເວລາລະດູຮ້ອນວານູອາຕູ",
               "",
               "ເວລາວານູອາຕູ",
               "",
            };
        final String[] Yakutsk = new String[] {
               "ເວລາມາດຕະຖານຢາກູດສ",
               "",
               "ເວລາລະດູຮ້ອນຢາກູດສ",
               "",
               "ເວລາຢາກູດສ",
               "",
            };
        final String[] Atlantic = new String[] {
               "ເວລາມາດຕະຖານຂອງອາແລນຕິກ",
               "AST",
               "ເວລາກາງເວັນຂອງອາແລນຕິກ",
               "AST",
               "ເວລາຂອງອາແລນຕິກ",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ເວລາມາດຕາຖານເບຣຊີເລຍ",
               "",
               "ເວລາຕາມເຂດລະດູຮ້ອນຕາມເຂດບຣາຊີເລຍ",
               "",
               "ເວລາຕາມເຂດບຣາຊິເລຍ",
               "",
            };
        final String[] Chamorro = new String[] {
               "ເວ​ລາ​ຈາ​ໂມ​ໂຣ",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "ເວລາມາດຕະຖານໂຄລຳເບຍ",
               "",
               "ເວລາລະດູຮ້ອນໂຄລໍາເບຍ",
               "",
               "ເວລາໂຄລໍາເບຍ",
               "",
            };
        final String[] Falkland = new String[] {
               "​ເວ​ລາ​ມາດ​ຕະ​ຖານໝູ່​ເກາະ​ຟອ​ລ໌ກ​ແລນ",
               "",
               "​ເວ​ລາ​ລະ​ດູ​ຮ້ອນໝູ່​ເກາະ​ຟອ​ລ໌ກ​ແລນ",
               "",
               "​ເວ​ລາ​ໝູ່​ເກາະ​ຟອ​ລ໌ກ​ແລນ",
               "",
            };
        final String[] Malaysia = new String[] {
               "ເວ​ລາ​ມາ​ເລ​ເຊຍ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "ເວລາມັລດີຟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ເວລາມາດຕະຖານ ອູລານບາເຕີ",
               "",
               "ເວລາລະດູຮ້ອນອູລານບາເຕີ",
               "",
               "ເວລາ ອູລານບາເຕີ",
               "",
            };
        final String[] Pakistan = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານ​ປາ​ກີສຖານ",
               "PKT",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ປາ​ກີ​ສ​ຖານ",
               "PKST",
               "ເວ​ລາ​ປາ​ກີສຖານ",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານ​ປາ​ຣາ​ກວຍ",
               "",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ປາ​ຣາ​ກວຍ",
               "",
               "ເວ​ລາ​ປາ​ຣາ​ກວຍ",
               "",
            };
        final String[] Pitcairn = new String[] {
               "ເວລາພິດແຄຣ໌ນ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "ເວ​ລາ​ຊຸ​ຣິ​ນາມ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "​ເວ​ລາ​ມາດ​ຕະ​ຖານອາ​ເຈນ​ທິ​ນາ",
               "",
               "​ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ອາ​ເຈນ​ທິ​ນາ",
               "",
               "ເວ​ລາ​ອາ​ເຈ​ທິ​ນາ",
               "",
            };
        final String[] Christmas = new String[] {
               "ເວ​ລາ​ເກາະ​ຄ​ຣິສ​ມາສ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "ເວ​ລາ​ກາ​ລາ​ປາ​ກອ​ສ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານ​ຮອງ​ກົງ",
               "HKT",
               "​ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ຮອງ​ກົງ",
               "HKST",
               "ເວ​ລາ​ຮອງ​ກົງ",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ເວລາອິນດູຈີນ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "ເວລາເຄຍກິສຖານ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານ​ລອດ​ເຮົາ",
               "",
               "​ເວ​ລ​ສາ​ຕອນ​​ທ່ຽງ​ລອດ​ເຮົາ​",
               "",
               "ເວ​ລາ​ລອດ​ເຮົາ",
               "",
            };
        final String[] Marquesas = new String[] {
               "ເວລາມາເຄີຊັສ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານມົວ​ຣິ​ຊຽ​ສ",
               "",
               "​ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ເມົາ​ຣິ​ທຽ​ສ",
               "",
               "ເວ​ລາ​ມົວຣິ​ຊຽ​ສ",
               "",
            };
        final String[] Singapore = new String[] {
               "ເວ​ລາ​ສິງ​ກະ​ໂປ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "ເວ​ລາ​ເວ​ເນ​ຊູ​ເອ​ລາ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "ເວລາມາດຕະຖານອັສເຊີໄບຈັນ",
               "",
               "ເວລາລະດູຮ້ອນອັສເຊີໄບຈັນ",
               "",
               "ເວລາອັສເຊີໄບຈັນ",
               "",
            };
        final String[] Bangladesh = new String[] {
               "ເວລາມາດຕະຖານ ບັງກະລາເທດ",
               "",
               "ເວລາ ລະດູຮ້ອນ ບັງກະລາເທດ",
               "",
               "ເວລາ ບັງກະລາເທດ",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "​ເວ​ລາ​ມາດ​ຕະ​ຖານ​ເຄບ​ເວີດ",
               "",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ເຄບ​ເວີດ",
               "",
               "ເວ​ລາ​ເຄບ​ເວີດ",
               "",
            };
        final String[] East_Timor = new String[] {
               "ເວລາຕີມໍຕາເວັນອອກ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "ເວລາຄາຊັກສຖານ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "ເວ​ລາ​ເຊ​ເຊ​ລ​ສ໌",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "ເວລາທາຈິກິສຖານ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ເວລາມາດຕະຖານອຸສເບກິດສະຖານ",
               "",
               "ເວລາລະດູຮ້ອນອຸສເບກິດສະຖານ",
               "",
               "ເວລາອຸສເບກິດສະຖານ",
               "",
            };
        final String[] Afghanistan = new String[] {
               "ເວລາ ອັຟການິສຖານ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານຄຣັສ​ໂນ​ຢາ​ສ​ຄ໌",
               "",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນຄຣັສ​ໂນ​ຢາ​ສ​ຄ໌",
               "",
               "ເວ​ລາ​ຄຣັສ​ໂນ​ຢາ​ສ​ຄ໌",
               "",
            };
        final String[] New_Zealand = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານນິວ​ຊີ​ແລນ",
               "NZST",
               "ເວ​ລາ​ຕອນ​ທ່ຽງ​ນິວ​ຊີ​ແລນ",
               "NZDT",
               "ເວ​ລາ​ນິວ​ຊີ​ແລນ",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານ​ຟິ​ລິບ​ປິນ",
               "PST",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ຟິ​ລິບ​ປິນ",
               "PDT",
               "​ເວ​ລາ​ຟິ​ລິບ​ປິນ",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ເວລາມາດຕະຖານລາດີໂວສຕົກ",
               "",
               "ເວລາລະດູຮ້ອນລາດີໂວສຕົກ",
               "",
               "ເວລາລາດີໂວສຕົກ",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "ເວລາມະຫາສະຫມຸດອິນເດຍ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "ເວ​ລາ​ໝູ່​ເກາະ​ລາຍ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານ​ນິວ​ຟາວ​ແລນ",
               "NST",
               "ເວລາກາງເວັນນິວຟາວແລນ",
               "NDT",
               "ເວ​ລາ​ນິວ​ຟາວ​ແລນ",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "ເວລາມາດຕະຖານຕວກເມນິສຖານ",
               "",
               "ເວລາລະດູຮ້ອນຕວກເມນິສຖານ",
               "",
               "ເວລາຕວກເມນິສຖານ",
               "",
            };
        final String[] French_Guiana = new String[] {
               "ເວ​ລາ​ເຟ​ຣນ​ຊ໌​ເກຍ​ນາ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "ເວລາມາດຕະຖານນິວແຄລິໂດເນຍ",
               "",
               "ເວລາລະດູຮ້ອນນິວແຄລິໂດເນຍ",
               "",
               "ເວລານິວແຄລິໂດເນຍ",
               "",
            };
        final String[] South_Georgia = new String[] {
               "ເວລາຈໍເຈຍໃຕ້",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "ເວລາມາດຕະຖານເຢກາເຕລິນເບີກ",
               "",
               "ເວລາລະດູຮ້ອນເຢກາເຕລິນເບີກ",
               "",
               "ເວລາເຢກາເຕລິນເບີກ",
               "",
            };
        final String[] Africa_Central = new String[] {
               "ເວ​ລາ​ອາ​ຟຣິ​ກາ​ກາງ",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "ເວ​ລາ​ອາ​ຟຣິ​ກາ​ຕາ​ເວັນ​ອອກ",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "ເວ​ລາ​ອາ​ຟຣິ​ກາ​ຕາ​ເວັນ​ຕົກ",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ເວລາດູມອງດູວິລ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານ​ຢູ​ໂຣບກາງ",
               "CET",
               "​ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ຢູ​ໂຣບ​ກາງ",
               "CEST",
               "ເວ​ລາ​ຢູ​ໂຣບ​ກາງ",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "ເວ​ລາ​ມາ​ດ​ຕະ​ຖານ​ຢູ​ໂຣບ​ຕາ​ເວັນ​ອອກ",
               "EET",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນຢູ​ໂຣບ​ຕາ​ເວັນ​ອອກ",
               "EEST",
               "ເວ​ລາ​ຢູ​ໂຣບ​ຕາ​ເວັນ​ອອກ",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານຢູ​ໂຣບ​ຕາ​ເວັນ​ຕົກ",
               "WET",
               "ເວ​ລາ​ລະ​ດູ​ຮ້ອນຢູ​ໂຣບ​ຕາ​ເວັນ​ຕົກ",
               "WEST",
               "ເວ​ລາ​ຢູ​ໂຣບ​ຕາ​ເວັນ​ຕົກ",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "ເວລາມາດຕະຖານແປຊິຟິກເມັກຊິກັນ",
               "MST",
               "ເວລາກາງເວັນແປຊິຟິກເມັກຊິກັນ",
               "MDT",
               "ເວລາແປຊິຟິກເມັກຊິກັນ",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "ເວ​ລາ​ອາ​ຟຣິ​ກາ​ໃຕ້",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "ເວລາມາດຕະຖານກາງ",
               "CST",
               "ເວລາກາງເວັນກາງ",
               "CDT",
               "ເວລາກາງ",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "ເວລາມາດຕະຖານຕາເວັນອອກ",
               "EST",
               "ເວລາກາງເວັນຕາເວັນອອກ",
               "EST",
               "ເວລາຕາເວັນອອກ",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "ເວລາມາດຕະຖານແປຊິຟິກ",
               "PST",
               "ເວລາກາງເວັນແປຊິຟິກ",
               "PDT",
               "ເວລາແປຊິຟິກ",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "ເວລາຝຣັ່ງຕອນໃຕ້ ແລະ ແອນຕາກຕິກ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "ເວລາຫມູ່ເກາະກິລເບີດ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "ເວລາມາດຕະຖານຮາວາຍ-ເອລູທຽນ",
               "HST",
               "ເວລາຕອນທ່ຽງຮາວາຍ-ເອລູທຽນ",
               "HDT",
               "ເວລາຮາວາຍ-ເອລູທຽນ",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "ເວລາຫມູ່ເກາະຟີນິກ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "​ເວ​ລາມາດ​ຕະ​ຖານເຊນ​ປີ​ແອ ແລະ​ມິ​ກົວ​ລອນ",
               "",
               "​ເວ​ລາຕອນ​ທ່ຽງເຊນ​ປີ​ແອ ແລະ​ມິ​ກົວ​ລອນ",
               "",
               "​ເວ​ລາເຊນ​ປີ​ແອ ແລະ​ມິ​ກົວ​ລອນ",
               "",
            };
        final String[] America_Mountain = new String[] {
               "ເວລາມາດຕະຖານແຖບພູເຂົາ",
               "MST",
               "ເວລາກາງເວັນແຖບພູເຂົາ",
               "MST",
               "ເວລາແຖບພູເຂົາ",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "ເວ​ລາ​ໝູ່​ເກາະ​ມາ​ແຊວ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "ເວລາປາປົວກິນີ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ເວ​ລາມາດ​ຕະ​ຖານອອ​ສ​ເຕຣ​ເລຍ​ກ​າງ",
               "ACST",
               "ເວ​ລາ​ຕອນ​ທ່ຽງ​ອອສ​ເຕຣ​ເລຍ​ກາງ",
               "ACDT",
               "ເວ​ລາອອ​ສ​ເຕຣ​ເລຍ​ກາງ",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "ເວ​ລາ​ມາດຕະຖານ​​​ອອສ​ເຕຣ​ລຽນ​ຕາ​ເວັນ​ອອກ",
               "AEST",
               "ເວ​ລາ​ຕອນ​ທ່ຽງ​ອອສ​ເຕຣ​ລຽນ​ຕາ​ເວັນ​ອອກ",
               "AEDT",
               "ເວ​ລາອອສ​ເຕຣ​ລຽນ​ຕາ​ເວັນ​ອອກ",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "ເວ​ລາ​ມາ​ດ​ຕະ​ຖານອອສ​ເຕຣ​ລຽນ​ຕາ​ເວັນ​ຕົກ",
               "AWST",
               "ເວ​ລາ​ຕອນ​ທ່ຽງ​ອອສ​ເຕຣ​ລຽນ​ຕາ​ເວັນ​ຕົກ",
               "AWDT",
               "ເວ​ລາ​ອອສ​ເຕຣ​ເລຍ​ຕາ​ເວັນ​ຕົກ",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "ເວ​ລາ​ອິນ​ໂດ​ເນ​ເຊຍ​ກາງ",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "ເວ​ລາ​ອິນ​ໂດ​ເນ​ເຊຍ​ຕາ​ເວັນ​ອອກ",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "ເວ​ລາ​ອິນ​ໂດ​ເນ​ເຊຍ​ຕາ​ເວັນ​ຕົກ",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "ເວ​ລາ​ມາດ​ຕະ​ຖານອອສ​ເຕຣ​ລຽນ​ກາງ​ຕາ​ເວັນ​ຕົກ",
               "",
               "ເວ​ລາ​ຕອນ​ທ່ຽງ​ອອສ​ເຕຣ​ລຽນ​ກາງ​ຕາ​ເວັນ​ຕົກ",
               "",
               "ເວ​ລາອອສ​ເຕຣ​ລຽນ​ກາງ​ຕາ​ເວັນ​ຕົກ",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "ເວ​ລາກຣີນ​ວິ​ຊ",
                    "GMT",
                    "ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ອັງ​ກິດ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "ເວລາສາກົນເຊີງພິກັດ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "ເວ​ລາກຣີນ​ວິ​ຊ",
                    "GMT",
                    "ເວ​ລາ​ມາດ​ຕະ​ຖານ​ໄອ​ຣິ​ຊ",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "ເວລາສາກົນເຊີງພິກັດ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "ເວລາສາກົນເຊີງພິກັດ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "ເວ​ລາກຣີນ​ວິ​ຊ",
                    "GMT",
                    "ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ອັງ​ກິດ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "ເວລາສາກົນເຊີງພິກັດ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "ເວລາສາກົນເຊີງພິກັດ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "ເວລາສາກົນເຊີງພິກັດ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "ເວ​ລາກຣີນ​ວິ​ຊ",
                    "GMT",
                    "ເວ​ລາ​ມາດ​ຕະ​ຖານ​ໄອ​ຣິ​ຊ",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "ເວ​ລາກຣີນ​ວິ​ຊ",
                    "GMT",
                    "ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ອັງ​ກິດ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "ເວ​ລາກຣີນ​ວິ​ຊ",
                    "GMT",
                    "ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ອັງ​ກິດ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "ເວ​ລາກຣີນ​ວິ​ຊ",
                    "GMT",
                    "ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ອັງ​ກິດ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "ເວ​ລາກຣີນ​ວິ​ຊ",
                    "GMT",
                    "ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ອັງ​ກິດ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "ເວ​ລາກຣີນ​ວິ​ຊ",
                    "GMT",
                    "ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ອັງ​ກິດ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "ເອເດັນ" },
            { "timezone.excity.Asia/Baku", "ບາກູ" },
            { "timezone.excity.Asia/Dili", "ດີລີ" },
            { "timezone.excity.Asia/Gaza", "ກາຊາ" },
            { "timezone.excity.Asia/Hovd", "ຮອບ" },
            { "timezone.excity.Asia/Omsk", "ອອມສຄ໌" },
            { "timezone.excity.Asia/Oral", "ອໍຣໍ" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "ອຳມານ" },
            { "timezone.excity.Asia/Aqtau", "ອັດຕາອູ" },
            { "timezone.excity.Asia/Chita", "ຊີຕ່າ" },
            { "timezone.excity.Asia/Dhaka", "ດາຫ໌ກາ" },
            { "timezone.excity.Asia/Dubai", "ດູໄບ" },
            { "timezone.excity.Asia/Kabul", "ຄາບູ" },
            { "timezone.excity.Asia/Macau", "ມາເກົາ" },
            { "timezone.excity.Asia/Qatar", "ກາຕາຣ໌" },
            { "timezone.excity.Asia/Seoul", "ໂຊລ໌" },
            { "timezone.excity.Asia/Tokyo", "ໂຕກຽວ" },
            { "timezone.excity.Asia/Tomsk", "ທອມສກ໌" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "ຈູບາ" },
            { "timezone.excity.Africa/Lome", "ໂລເມ" },
            { "timezone.excity.Asia/Almaty", "ອໍມາຕີ" },
            { "timezone.excity.Asia/Anadyr", "ອານາດີ" },
            { "timezone.excity.Asia/Aqtobe", "ອັດໂທບີ" },
            { "timezone.excity.Asia/Atyrau", "ອັດທີເຣົາ" },
            { "timezone.excity.Asia/Beirut", "ເບຣຸດ" },
            { "timezone.excity.Asia/Brunei", "ບຣູໄນ" },
            { "timezone.excity.Asia/Hebron", "ເຮບຣອນ" },
            { "timezone.excity.Asia/Kuwait", "ຄູເວດ" },
            { "timezone.excity.Asia/Manila", "ມານີລາ" },
            { "timezone.excity.Asia/Muscat", "ມາສຄັດ" },
            { "timezone.excity.Asia/Riyadh", "ຣີຢາດ" },
            { "timezone.excity.Asia/Saigon", "ໂຮຈິມິນ" },
            { "timezone.excity.Asia/Taipei", "ໄທເປ" },
            { "timezone.excity.Asia/Tehran", "ເຕຣານ" },
            { "timezone.excity.Asia/Urumqi", "ອູຣຸມຊີ" },
            { "timezone.excity.Etc/Unknown", "ບໍ່ຮູ້ຊື່ເມືອງ" },
            { "timezone.excity.Europe/Kiev", "ຂຽບ" },
            { "timezone.excity.Europe/Oslo", "ອອສໂລ" },
            { "timezone.excity.Europe/Riga", "ຣິກາ" },
            { "timezone.excity.Europe/Rome", "ໂຣມ" },
            { "timezone.excity.Indian/Mahe", "ມາເຮ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "ອັກຄຣາ" },
            { "timezone.excity.Africa/Cairo", "ໄຄໂຣ" },
            { "timezone.excity.Africa/Ceuta", "ຊີວຕາ" },
            { "timezone.excity.Africa/Dakar", "ດາກາ" },
            { "timezone.excity.Africa/Lagos", "ລາໂກສ" },
            { "timezone.excity.Africa/Tunis", "ຕູນິສ" },
            { "timezone.excity.America/Adak", "ອາແດກ" },
            { "timezone.excity.America/Lima", "ລີມາ" },
            { "timezone.excity.America/Nome", "ນອມ" },
            { "timezone.excity.Asia/Baghdad", "ແບກແດດ" },
            { "timezone.excity.Asia/Bahrain", "ບາເຣນ" },
            { "timezone.excity.Asia/Bangkok", "ບາງກອກ" },
            { "timezone.excity.Asia/Barnaul", "ບານົວ" },
            { "timezone.excity.Asia/Bishkek", "ບິດຊ໌ເຄກ" },
            { "timezone.excity.Asia/Colombo", "ໂຄລຳໂບ" },
            { "timezone.excity.Asia/Irkutsk", "ອີຄຸສຄ໌" },
            { "timezone.excity.Asia/Jakarta", "ຈາກາຕາ" },
            { "timezone.excity.Asia/Karachi", "ກາຣາຈີ" },
            { "timezone.excity.Asia/Kuching", "ກູຊີງ" },
            { "timezone.excity.Asia/Magadan", "ມາກາແດນ" },
            { "timezone.excity.Asia/Nicosia", "ນິໂຄເຊຍ" },
            { "timezone.excity.Asia/Rangoon", "ຢາງກອນ" },
            { "timezone.excity.Asia/Tbilisi", "ທິບີລີຊີ" },
            { "timezone.excity.Asia/Thimphu", "ທິມພູ" },
            { "timezone.excity.Asia/Yakutsk", "ຢາຄຸທຊ໌" },
            { "timezone.excity.Asia/Yerevan", "ເຍເຣວານ" },
            { "timezone.excity.Europe/Kirov", "ກິໂຣບ" },
            { "timezone.excity.Europe/Malta", "ມອລຕາ" },
            { "timezone.excity.Europe/Minsk", "ມິນສກ໌" },
            { "timezone.excity.Europe/Paris", "ປາຣີສ" },
            { "timezone.excity.Europe/Sofia", "ໂຊເຟຍ" },
            { "timezone.excity.Europe/Vaduz", "ວາດາຊ" },
            { "timezone.excity.Indian/Cocos", "ໂຄໂຄສ" },
            { "timezone.excity.Pacific/Apia", "ເອປີອາ" },
            { "timezone.excity.Pacific/Fiji", "ຟູຈິ" },
            { "timezone.excity.Pacific/Guam", "ກວມ" },
            { "timezone.excity.Pacific/Niue", "ນີອູເອ" },
            { "timezone.excity.Pacific/Truk", "ຈັກ" },
            { "timezone.excity.Pacific/Wake", "ເວກ" },
            { "timezone.excity.Africa/Asmera", "ອັສມາຣາ" },
            { "timezone.excity.Africa/Bamako", "ບາມາໂກ" },
            { "timezone.excity.Africa/Bangui", "ບັງກຸຍ" },
            { "timezone.excity.Africa/Banjul", "ບານຈູ" },
            { "timezone.excity.Africa/Bissau", "ບິສເຊົາ" },
            { "timezone.excity.Africa/Douala", "ດູອາລາ" },
            { "timezone.excity.Africa/Harare", "ຮາຣາເຣ" },
            { "timezone.excity.Africa/Kigali", "ຄີກາລີ" },
            { "timezone.excity.Africa/Luanda", "ລວນດາ" },
            { "timezone.excity.Africa/Lusaka", "ລູຊາກາ" },
            { "timezone.excity.Africa/Malabo", "ມາລາໂບ" },
            { "timezone.excity.Africa/Maputo", "ມາປູໂຕ" },
            { "timezone.excity.Africa/Maseru", "ມາເຊຣູ" },
            { "timezone.excity.Africa/Niamey", "ນີອາເມ" },
            { "timezone.excity.America/Aruba", "ອາຣູບາ" },
            { "timezone.excity.America/Bahia", "ບາເຢຍ" },
            { "timezone.excity.America/Belem", "ບີເລມ" },
            { "timezone.excity.America/Boise", "ບອຍຊ໌" },
            { "timezone.excity.America/Jujuy", "ຈູຈຸຍ" },
            { "timezone.excity.America/Sitka", "ຊິດກາ" },
            { "timezone.excity.America/Thule", "ທູເລ" },
            { "timezone.excity.Asia/Ashgabat", "ອາດຊ໌ກາບັດ" },
            { "timezone.excity.Asia/Calcutta", "ໂກລກາຕາ" },
            { "timezone.excity.Asia/Damascus", "ດາມາສຄັສ" },
            { "timezone.excity.Asia/Dushanbe", "ດູຊານເບ" },
            { "timezone.excity.Asia/Jayapura", "ຈາຢາປູຣະ" },
            { "timezone.excity.Asia/Katmandu", "ຄັດມັນດູ" },
            { "timezone.excity.Asia/Khandyga", "ແຄນດີກາ" },
            { "timezone.excity.Asia/Makassar", "ມາກາສຊາ" },
            { "timezone.excity.Asia/Qostanay", "ຄອສຕາເນ" },
            { "timezone.excity.Asia/Sakhalin", "ຊາຄາລິນ" },
            { "timezone.excity.Asia/Shanghai", "ຊ່ຽງໄຮ້" },
            { "timezone.excity.Asia/Tashkent", "ທາດສ໌ເຄນ" },
            { "timezone.excity.Asia/Ust-Nera", "ອຸສ ເນຣາ" },
            { "timezone.excity.Europe/Athens", "ເອເທນສ໌" },
            { "timezone.excity.Europe/Berlin", "ເບີລິນ" },
            { "timezone.excity.Europe/Dublin", "ດັບບລິນ" },
            { "timezone.excity.Europe/Jersey", "ເຈີຊີ" },
            { "timezone.excity.Europe/Lisbon", "ລິສບອນ" },
            { "timezone.excity.Europe/London", "ລອນດອນ" },
            { "timezone.excity.Europe/Madrid", "ມາດຣິດ" },
            { "timezone.excity.Europe/Monaco", "ໂມນາໂຄ" },
            { "timezone.excity.Europe/Moscow", "ມອສໂຄ" },
            { "timezone.excity.Europe/Prague", "ປຣາກ" },
            { "timezone.excity.Europe/Samara", "ຊາມາຣາ" },
            { "timezone.excity.Europe/Skopje", "ສະໂກເປຍ" },
            { "timezone.excity.Europe/Tirane", "ທິຣານ" },
            { "timezone.excity.Europe/Vienna", "ວຽນນາ" },
            { "timezone.excity.Europe/Warsaw", "ວໍຊໍ" },
            { "timezone.excity.Europe/Zagreb", "ຊາເກຣບ" },
            { "timezone.excity.Europe/Zurich", "ຊູຣິກ" },
            { "timezone.excity.Indian/Chagos", "ຊາໂກສ" },
            { "timezone.excity.Indian/Comoro", "ໂຄໂມໂຣ" },
            { "timezone.excity.Pacific/Efate", "ເອຟາເຕ" },
            { "timezone.excity.Pacific/Nauru", "ນາອູຣູ" },
            { "timezone.excity.Pacific/Palau", "ປາເລົາ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "ອາບິດແຈນ" },
            { "timezone.excity.Africa/Algiers", "ແອວເຈຍ" },
            { "timezone.excity.Africa/Conakry", "ໂຄນາຄຣີ" },
            { "timezone.excity.Africa/Kampala", "ຄຳປາລາ" },
            { "timezone.excity.Africa/Mbabane", "ອຳບາບາເນ" },
            { "timezone.excity.Africa/Nairobi", "ໄນໂຣບີ" },
            { "timezone.excity.Africa/Tripoli", "ທຣິໂພລິ" },
            { "timezone.excity.America/Belize", "ເບລີຊ" },
            { "timezone.excity.America/Bogota", "ໂບໂກຕາ" },
            { "timezone.excity.America/Cancun", "ແຄນກຸນ" },
            { "timezone.excity.America/Cayman", "ເຄແມນ" },
            { "timezone.excity.America/Cuiaba", "ກຸຢາບາ" },
            { "timezone.excity.America/Dawson", "ດໍສັນ" },
            { "timezone.excity.America/Denver", "ເດັນເວີ" },
            { "timezone.excity.America/Guyana", "ກູຢານາ" },
            { "timezone.excity.America/Havana", "ຮາວານາ" },
            { "timezone.excity.America/Inuvik", "ອີນູວິກ" },
            { "timezone.excity.America/Juneau", "ຈູໂນ" },
            { "timezone.excity.America/La_Paz", "ລາປາສ" },
            { "timezone.excity.America/Maceio", "ມາເຊໂອ" },
            { "timezone.excity.America/Manaus", "ມາເນົາສ໌" },
            { "timezone.excity.America/Merida", "ເມີຣິດາ" },
            { "timezone.excity.America/Nassau", "ແນສຊໍ" },
            { "timezone.excity.America/Panama", "ພານາມາ" },
            { "timezone.excity.America/Recife", "ເຣຊິເຟ" },
            { "timezone.excity.America/Regina", "ເຣຈິນາ" },
            { "timezone.excity.Asia/Famagusta", "ຟາມາກັສທາ" },
            { "timezone.excity.Asia/Hong_Kong", "ຮ່ອງກົງ" },
            { "timezone.excity.Asia/Jerusalem", "ເຢຣູຊາເລມ" },
            { "timezone.excity.Asia/Kamchatka", "ຄາມຊາດກາ" },
            { "timezone.excity.Asia/Pontianak", "ພອນເທຍນັກ" },
            { "timezone.excity.Asia/Pyongyang", "ປຽງຢາງ" },
            { "timezone.excity.Asia/Qyzylorda", "ໄຄຊີລໍດາ" },
            { "timezone.excity.Asia/Samarkand", "ຊາມາແຄນ" },
            { "timezone.excity.Asia/Singapore", "ສິງກະໂປ" },
            { "timezone.excity.Asia/Vientiane", "ວຽງຈັນ" },
            { "timezone.excity.Europe/Andorra", "ອິນດໍຣາ" },
            { "timezone.excity.Europe/Saratov", "ຊາຣາທອບ" },
            { "timezone.excity.Europe/Tallinn", "ທາລລິນນ໌" },
            { "timezone.excity.Europe/Vatican", "ວາຕິກັນ" },
            { "timezone.excity.Europe/Vilnius", "ວິລນິອຸສ" },
            { "timezone.excity.Indian/Mayotte", "ມາຢັອດເຕ" },
            { "timezone.excity.Indian/Reunion", "ເຣອູນິຢົງ" },
            { "timezone.excity.Pacific/Easter", "ເອສເຕີ" },
            { "timezone.excity.Pacific/Kosrae", "ຄໍສແຣ" },
            { "timezone.excity.Pacific/Majuro", "ມາຈູໂຣ" },
            { "timezone.excity.Pacific/Midway", "ມິດເວ" },
            { "timezone.excity.Pacific/Noumea", "ນູເມອາ" },
            { "timezone.excity.Pacific/Ponape", "ປົນເປີຍ" },
            { "timezone.excity.Pacific/Saipan", "ໄຊປານ" },
            { "timezone.excity.Pacific/Tahiti", "ທາຮີຕິ" },
            { "timezone.excity.Pacific/Tarawa", "ຕາຣາວາ" },
            { "timezone.excity.Pacific/Wallis", "ວາລິດ" },
            { "timezone.excity.Africa/Blantyre", "ແບລນໄທຣ໌" },
            { "timezone.excity.Africa/Djibouti", "ຈີບູຕິ" },
            { "timezone.excity.Africa/El_Aaiun", "ເອວ ອາຢູນ" },
            { "timezone.excity.Africa/Freetown", "ຟຣີທາວ" },
            { "timezone.excity.Africa/Gaborone", "ກາບໍໂຣນ" },
            { "timezone.excity.Africa/Khartoum", "ຄາທູມ" },
            { "timezone.excity.Africa/Kinshasa", "ກິນຊາຊາ" },
            { "timezone.excity.Africa/Monrovia", "ມອນໂຣເວຍ" },
            { "timezone.excity.Africa/Ndjamena", "ເອນຈາເມນ່າ" },
            { "timezone.excity.Africa/Sao_Tome", "ຊາວໂຕເມ" },
            { "timezone.excity.Africa/Windhoek", "ວີນຮູດ" },
            { "timezone.excity.America/Antigua", "ແອນທິກົວ" },
            { "timezone.excity.America/Caracas", "ຄາຣາກັສ" },
            { "timezone.excity.America/Cayenne", "ຄາເຢນ" },
            { "timezone.excity.America/Chicago", "ຊິຄາໂກ" },
            { "timezone.excity.America/Cordoba", "ຄໍໂດບາ" },
            { "timezone.excity.America/Creston", "ເຄຣສຕັນ" },
            { "timezone.excity.America/Curacao", "ກືຣາເຊົາ" },
            { "timezone.excity.America/Detroit", "ດີທຣອຍ" },
            { "timezone.excity.America/Godthab", "ນູກ" },
            { "timezone.excity.America/Grenada", "ເກຣນາດາ" },
            { "timezone.excity.America/Halifax", "ຮາລິແຟັກ" },
            { "timezone.excity.America/Iqaluit", "ອີກົວລິດ" },
            { "timezone.excity.America/Jamaica", "ຈາໄມກາ" },
            { "timezone.excity.America/Managua", "ມານາກົວ" },
            { "timezone.excity.America/Marigot", "ມາຣີໂກດ" },
            { "timezone.excity.America/Mendoza", "ເມັນໂດຊ່າ" },
            { "timezone.excity.America/Moncton", "ມອນຕັນ" },
            { "timezone.excity.America/Noronha", "ນໍຣອນຮາ" },
            { "timezone.excity.America/Ojinaga", "ໂອຈິນາກາ" },
            { "timezone.excity.America/Phoenix", "ຟິນິກ" },
            { "timezone.excity.America/Tijuana", "ທີຈົວນາ" },
            { "timezone.excity.America/Toronto", "ໂທຣອນໂຕ" },
            { "timezone.excity.America/Tortola", "ທໍໂຕລາ" },
            { "timezone.excity.America/Yakutat", "ຢາຄູຕັດ" },
            { "timezone.excity.Asia/Phnom_Penh", "ພະນົມເປັນ" },
            { "timezone.excity.Atlantic/Azores", "ອາ​ໂຊ​ເຣ​ສ" },
            { "timezone.excity.Atlantic/Canary", "ຄານາຣີ" },
            { "timezone.excity.Atlantic/Faeroe", "ແຟໂຣ" },
            { "timezone.excity.Australia/Eucla", "ຢູຄລາ" },
            { "timezone.excity.Australia/Perth", "ເພີດ" },
            { "timezone.excity.Europe/Belgrade", "ເບວເກຣດ" },
            { "timezone.excity.Europe/Brussels", "ບຣັສເຊວ" },
            { "timezone.excity.Europe/Budapest", "ບູດາເປສຕ໌" },
            { "timezone.excity.Europe/Busingen", "ບັດຊິນເກນ" },
            { "timezone.excity.Europe/Chisinau", "ຄີຊີເນົາ" },
            { "timezone.excity.Europe/Guernsey", "ເກີນຊີ" },
            { "timezone.excity.Europe/Helsinki", "ເຮວຊິນກິ" },
            { "timezone.excity.Europe/Istanbul", "ອິສຕັນບູລ໌" },
            { "timezone.excity.Europe/Sarajevo", "ຊາຣາເຢໂວ" },
            { "timezone.excity.Indian/Maldives", "ມັລດີຟ" },
            { "timezone.excity.Pacific/Chatham", "ແຊແທມ" },
            { "timezone.excity.Pacific/Fakaofo", "ຟາກາວໂຟ" },
            { "timezone.excity.Pacific/Gambier", "ແກມເບຍ" },
            { "timezone.excity.Pacific/Norfolk", "ນໍຟອລ໌ກ" },
            { "timezone.excity.Africa/Bujumbura", "ບູຈູມບູຣາ" },
            { "timezone.excity.Africa/Mogadishu", "ໂມກາດີຊູ" },
            { "timezone.excity.America/Anguilla", "ແອນກິນລາ" },
            { "timezone.excity.America/Asuncion", "ອະຊຸນຊິອອງ" },
            { "timezone.excity.America/Barbados", "ບາເບດອສ" },
            { "timezone.excity.America/Dominica", "ໂດມິນິກາ" },
            { "timezone.excity.America/Edmonton", "ເອດມອນຕອນ" },
            { "timezone.excity.America/Eirunepe", "ເອຣຸເນປີ" },
            { "timezone.excity.America/Mazatlan", "ມາຊາດລານ" },
            { "timezone.excity.America/Miquelon", "ມິກົວລອນ" },
            { "timezone.excity.America/New_York", "ນິວຢອກ" },
            { "timezone.excity.America/Resolute", "ເຣໂຊລຸດ" },
            { "timezone.excity.America/Santarem", "ຊັນຕາເຣມ" },
            { "timezone.excity.America/Santiago", "ຊັນຕີອາໂກ" },
            { "timezone.excity.America/St_Johns", "ເຊນ ຈອນ" },
            { "timezone.excity.America/St_Kitts", "ເຊນ ຄິດສ໌" },
            { "timezone.excity.America/St_Lucia", "ເຊນ ລູເຊຍ" },
            { "timezone.excity.America/Winnipeg", "ວິນນີເພກ" },
            { "timezone.excity.Antarctica/Casey", "ເຄຊີ" },
            { "timezone.excity.Antarctica/Davis", "ດາວີສ" },
            { "timezone.excity.Antarctica/Syowa", "ເຊຍວາ" },
            { "timezone.excity.Antarctica/Troll", "ໂທຣລ໌" },
            { "timezone.excity.Asia/Krasnoyarsk", "ຄຣັສໂນຢາສຄ໌" },
            { "timezone.excity.Asia/Novosibirsk", "ໂນໂວຊີບີສຄ໌" },
            { "timezone.excity.Asia/Ulaanbaatar", "ອູລານບາຕາຣ໌" },
            { "timezone.excity.Asia/Vladivostok", "ວີລາດິໂວສຕອກ" },
            { "timezone.excity.Atlantic/Bermuda", "ເບີມິວດາ" },
            { "timezone.excity.Atlantic/Madeira", "ມາເດຣາ" },
            { "timezone.excity.Atlantic/Stanley", "ສະແຕນເລ" },
            { "timezone.excity.Australia/Darwin", "ດາວິນ" },
            { "timezone.excity.Australia/Hobart", "ໂຮບາດ" },
            { "timezone.excity.Australia/Sydney", "ຊິດນີ" },
            { "timezone.excity.Europe/Amsterdam", "ອາມສເຕີດຳ" },
            { "timezone.excity.Europe/Astrakhan", "ອາສຕຣາຄານ" },
            { "timezone.excity.Europe/Bucharest", "ບູຄາເຣສຕ໌" },
            { "timezone.excity.Europe/Gibraltar", "ກິບຣອລທາ" },
            { "timezone.excity.Europe/Ljubljana", "ລູບລີຍານາ" },
            { "timezone.excity.Europe/Mariehamn", "ມາຣີແຮມນ໌" },
            { "timezone.excity.Europe/Podgorica", "ພອດກໍຣີກາ" },
            { "timezone.excity.Europe/Stockholm", "ສະຕອກໂຮມ" },
            { "timezone.excity.Europe/Ulyanovsk", "ອູລີອານອບສຄ໌" },
            { "timezone.excity.Europe/Volgograd", "ວອລໂກກຣາດ" },
            { "timezone.excity.Indian/Christmas", "ຄຣິດສະມາດ" },
            { "timezone.excity.Indian/Kerguelen", "ແກເກີເລນ" },
            { "timezone.excity.Indian/Mauritius", "ເມົາຣິທຽສ" },
            { "timezone.excity.Pacific/Auckland", "ອັກແລນ" },
            { "timezone.excity.Pacific/Funafuti", "ຟູນະຟູຕິ" },
            { "timezone.excity.Pacific/Honolulu", "ໂຮໂນລູລູ" },
            { "timezone.excity.Pacific/Pitcairn", "ພິດແຄນ" },
            { "timezone.excity.Africa/Casablanca", "ຄາຊາບລັງກາ" },
            { "timezone.excity.Africa/Libreville", "ລິເບຼີວິວ" },
            { "timezone.excity.Africa/Lubumbashi", "ລູບຳບາຊິ" },
            { "timezone.excity.Africa/Nouakchott", "ນູແອກຊອດ" },
            { "timezone.excity.Africa/Porto-Novo", "ປໍໂຕ-ໂນໂວ" },
            { "timezone.excity.America/Anchorage", "ແອນເຄີເຣກ" },
            { "timezone.excity.America/Araguaina", "ອາຣາກົວນາ" },
            { "timezone.excity.America/Boa_Vista", "ບົວ ວິສຕາ" },
            { "timezone.excity.America/Catamarca", "ຄາຕາມາກາ" },
            { "timezone.excity.America/Chihuahua", "ຊິວາວາ" },
            { "timezone.excity.America/Fortaleza", "ຟໍຕາເລຊາ" },
            { "timezone.excity.America/Glace_Bay", "ເກລດເບ" },
            { "timezone.excity.America/Goose_Bay", "ກູສເບ" },
            { "timezone.excity.America/Guatemala", "ກົວເຕມາລາ" },
            { "timezone.excity.America/Guayaquil", "ກົວຢາກິລ" },
            { "timezone.excity.America/Matamoros", "ມາຕາໂມຣອສ" },
            { "timezone.excity.America/Menominee", "ເມໂນມິນີ" },
            { "timezone.excity.America/Monterrey", "ມອນເຕີເຣຍ" },
            { "timezone.excity.America/Sao_Paulo", "ເຊົາ ເປົາໂລ" },
            { "timezone.excity.America/St_Thomas", "ເຊນ ໂທມັສ" },
            { "timezone.excity.America/Vancouver", "ແວນຄູເວີ" },
            { "timezone.excity.Antarctica/Mawson", "ເມົາຊັນ" },
            { "timezone.excity.Antarctica/Palmer", "ພາມເມີ" },
            { "timezone.excity.Antarctica/Vostok", "ວໍສະຕອກ" },
            { "timezone.excity.Asia/Kuala_Lumpur", "ກົວລາລຳເປີ" },
            { "timezone.excity.Asia/Novokuznetsk", "ໂນໂວຄຸສເນັດ" },
            { "timezone.excity.Europe/Bratislava", "ບຣາທິສລາວາ" },
            { "timezone.excity.Europe/Copenhagen", "ໂຄເປນເຮເກນ" },
            { "timezone.excity.Europe/Luxembourg", "ລັກເຊັມເບີກ" },
            { "timezone.excity.Europe/San_Marino", "ຊານມາຣີໂນ" },
            { "timezone.excity.Europe/Simferopol", "ຊີມເຟໂລໂປ" },
            { "timezone.excity.Pacific/Enderbury", "ແຄນຕອນ" },
            { "timezone.excity.Pacific/Galapagos", "ກາລາປາກອສ" },
            { "timezone.excity.Pacific/Kwajalein", "ຄວາຈາເລນ" },
            { "timezone.excity.Pacific/Marquesas", "ມາຄິວຊາສ" },
            { "timezone.excity.Pacific/Pago_Pago", "ປາໂກປາໂກ" },
            { "timezone.excity.Pacific/Rarotonga", "ຣາໂຣຕອງກາ" },
            { "timezone.excity.Pacific/Tongatapu", "ຕອງກາຕາປູ" },
            { "timezone.excity.Africa/Addis_Ababa", "ແອດດິສ ອະບາບາ" },
            { "timezone.excity.Africa/Brazzaville", "ບຣາຊາວິວ" },
            { "timezone.excity.Africa/Ouagadougou", "ອູກາດູກູ" },
            { "timezone.excity.America/Costa_Rica", "ຄອສຕາຣິກາ" },
            { "timezone.excity.America/Grand_Turk", "ແກຣນ ເທີກ" },
            { "timezone.excity.America/Guadeloupe", "ກາວເດລູບ" },
            { "timezone.excity.America/Hermosillo", "ເອໂມຊິໂຢ" },
            { "timezone.excity.America/Kralendijk", "ຄຣາເລນດິກ" },
            { "timezone.excity.America/Louisville", "ຫລຸຍວິວ" },
            { "timezone.excity.America/Martinique", "ມາທີນິກ" },
            { "timezone.excity.America/Metlakatla", "ເມັດລາກັດລາ" },
            { "timezone.excity.America/Montevideo", "ມອນເຕວິເດໂອ" },
            { "timezone.excity.America/Montserrat", "ມອນເຊີຣັດ" },
            { "timezone.excity.America/Paramaribo", "ພາຣາມາຣິໂບ" },
            { "timezone.excity.America/Rio_Branco", "ຣິໂອ ບຣັນໂກ" },
            { "timezone.excity.America/St_Vincent", "ເຊນ ວິນເຊນ" },
            { "timezone.excity.America/Whitehorse", "ໄວທ໌ຮອສ" },
            { "timezone.excity.Antarctica/McMurdo", "ແມັກມົວໂດ" },
            { "timezone.excity.Antarctica/Rothera", "ໂຣເທຣາ" },
            { "timezone.excity.Asia/Srednekolymsk", "ສຣິລເນັກໂກລີດ" },
            { "timezone.excity.Asia/Yekaterinburg", "ເຢຄາເຕີຣິນເບີກ" },
            { "timezone.excity.Atlantic/Reykjavik", "ເຣກຢາວິກ" },
            { "timezone.excity.Atlantic/St_Helena", "ເຊນ ເຮເລນາ" },
            { "timezone.excity.Australia/Adelaide", "ເອດີແລດ" },
            { "timezone.excity.Australia/Brisbane", "ບຣິສເບນ" },
            { "timezone.excity.Australia/Lindeman", "ລິນດີແມນ" },
            { "timezone.excity.Europe/Isle_of_Man", "ເກາະແມນ" },
            { "timezone.excity.Europe/Kaliningrad", "ຄາລິນິນກຣາດ" },
            { "timezone.excity.Pacific/Kiritimati", "ຄີຣິທີມາຕີ" },
            { "timezone.excity.Africa/Johannesburg", "ໂຈຮັນເນດສເບີກ" },
            { "timezone.excity.America/El_Salvador", "ເອວ ຊາວາດໍ" },
            { "timezone.excity.America/Fort_Nelson", "ຟອດ ເນວສັນ" },
            { "timezone.excity.America/Los_Angeles", "ລອສແອນເຈລີສ" },
            { "timezone.excity.America/Mexico_City", "ເມັກຊິໂກ ຊິຕີ" },
            { "timezone.excity.America/Porto_Velho", "ປໍຕູ ເວວຢູ" },
            { "timezone.excity.America/Puerto_Rico", "ເປີໂທຣິໂກ" },
            { "timezone.excity.America/Tegucigalpa", "ເຕກູຊີການປາ" },
            { "timezone.excity.Arctic/Longyearbyen", "ລອງເຢຍບຽນ" },
            { "timezone.excity.Atlantic/Cape_Verde", "ເຄບເວີດ" },
            { "timezone.excity.Australia/Lord_Howe", "ໂລດໂຮວີ" },
            { "timezone.excity.Australia/Melbourne", "ເມວເບິນ" },
            { "timezone.excity.Indian/Antananarivo", "ອັນຕານານາຣິໂວ" },
            { "timezone.excity.Pacific/Guadalcanal", "ກົວດັລຄະແນລ" },
            { "timezone.excity.Africa/Dar_es_Salaam", "ດາເອສສະລາມ" },
            { "timezone.excity.America/Blanc-Sablon", "ບລານ-ຊາບລອນ" },
            { "timezone.excity.America/Buenos_Aires", "ບົວໂນສ ໄອເຣສ" },
            { "timezone.excity.America/Campo_Grande", "ກັງປູຣັງຈີ" },
            { "timezone.excity.America/Danmarkshavn", "ເດນມາກແຊນ" },
            { "timezone.excity.America/Dawson_Creek", "ດໍສັນ ຄຣີກ" },
            { "timezone.excity.America/Indiana/Knox", "ນ໋ອກ, ອິນເດຍນາ" },
            { "timezone.excity.America/Indianapolis", "ອິນດີເອນາໂພລິສ" },
            { "timezone.excity.America/Punta_Arenas", "ພຸນທາ ອະຣີນາສ໌" },
            { "timezone.excity.America/Rankin_Inlet", "ແຣນກິນ ອິນເລັດ" },
            { "timezone.excity.America/Scoresbysund", "ອິໂຕຄໍທົວມິດ" },
            { "timezone.excity.Antarctica/Macquarie", "ແມັກຄົວຣີ" },
            { "timezone.excity.Pacific/Bougainville", "ເວລາຕາມເຂດບູນກຽນວິວ" },
            { "timezone.excity.Pacific/Port_Moresby", "ພອດ ມໍເຣສບີ" },
            { "timezone.excity.America/Cambridge_Bay", "ແຄມບຣິດ ເບ" },
            { "timezone.excity.America/Ciudad_Juarez", "ຊີອູດັດ ຄົວເຣຊ" },
            { "timezone.excity.America/Coral_Harbour", "ອາທິໂຄຄານ" },
            { "timezone.excity.America/Indiana/Vevay", "ວີເວ, ອິນເດຍນາ" },
            { "timezone.excity.America/Lower_Princes", "ໂລເວີ ພຣິນຊ໌ ຄວດເຕີ" },
            { "timezone.excity.America/Port_of_Spain", "ພອດອອບສະເປນ" },
            { "timezone.excity.America/Santo_Domingo", "ຊານໂຕໂດມິນໂກ" },
            { "timezone.excity.America/St_Barthelemy", "ເຊນບາເທເລມີ" },
            { "timezone.excity.America/Swift_Current", "ສະວິຟ ເຄີເຣນ" },
            { "timezone.excity.Australia/Broken_Hill", "ໂບຣກເຄນ ຮິວ" },
            { "timezone.excity.America/Bahia_Banderas", "ບາເຮຍ ແບນເດີຣາສ" },
            { "timezone.excity.America/Port-au-Prince", "ປໍໂຕແປຣງ" },
            { "timezone.excity.Atlantic/South_Georgia", "ເຊົາຈໍເຈຍ" },
            { "timezone.excity.America/Argentina/Salta", "ຊານຕາ" },
            { "timezone.excity.America/Indiana/Marengo", "ມາເຣນໂກ, ອິນເດຍນາ" },
            { "timezone.excity.America/Indiana/Winamac", "ວິນາແມັກ, ອິນເດຍນາ" },
            { "timezone.excity.America/Argentina/Tucuman", "ຕູຄູແມນ" },
            { "timezone.excity.America/Argentina/Ushuaia", "ອູຊູເອຍ" },
            { "timezone.excity.America/Indiana/Tell_City", "ເທວ ຊິຕີ, ອິນເດຍນາ" },
            { "timezone.excity.America/Indiana/Vincennes", "ວິນເຊນເນສ, ອິນເດຍນາ" },
            { "timezone.excity.Antarctica/DumontDUrville", "ດູມອນດີຍູວີວສ໌" },
            { "timezone.excity.America/Argentina/La_Rioja", "ລາ ຣິໂອຈາ" },
            { "timezone.excity.America/Argentina/San_Juan", "ແຊນຮວນ" },
            { "timezone.excity.America/Argentina/San_Luis", "ແຊນລຸຍສ໌" },
            { "timezone.excity.America/Indiana/Petersburg", "ປີເຕີສເປີກ, ອິນເດຍນາ" },
            { "timezone.excity.America/Kentucky/Monticello", "ມອນຕີເຊວໂລ, ເຄນທັກກີ" },
            { "timezone.excity.America/North_Dakota/Beulah", "ເບີລາ, ນອດ ດາໂກຕາ" },
            { "timezone.excity.America/North_Dakota/Center", "ເຊັນເຈີ, ນອດ ດາໂກຕາ" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ຣິໂກ ແກວເລກອສ" },
            { "timezone.excity.America/North_Dakota/New_Salem", "ນິວ ຊາເລມ, ນອດ ດາໂກຕາ" },
        };
        return data;
    }
}
