/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class Parsed
implements TemporalAccessor {
    final Map<TemporalField, Long> fieldValues = new HashMap<TemporalField, Long>();
    ZoneId zone;
    Chronology chrono;
    boolean leapSecond;
    private ResolverStyle resolverStyle;
    private ChronoLocalDate date;
    private LocalTime time;
    Period excessDays = Period.ZERO;

    Parsed() {
    }

    Parsed copy() {
        Parsed parsed = new Parsed();
        parsed.fieldValues.putAll(this.fieldValues);
        parsed.zone = this.zone;
        parsed.chrono = this.chrono;
        parsed.leapSecond = this.leapSecond;
        return parsed;
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        if (this.fieldValues.containsKey(temporalField) || this.date != null && this.date.isSupported(temporalField) || this.time != null && this.time.isSupported(temporalField)) {
            return true;
        }
        return temporalField != null && !(temporalField instanceof ChronoField) && temporalField.isSupportedBy(this);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        Objects.requireNonNull(temporalField, "field");
        Long l = this.fieldValues.get(temporalField);
        if (l != null) {
            return l;
        }
        if (this.date != null && this.date.isSupported(temporalField)) {
            return this.date.getLong(temporalField);
        }
        if (this.time != null && this.time.isSupported(temporalField)) {
            return this.time.getLong(temporalField);
        }
        if (temporalField instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.getFrom(this);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.zoneId()) {
            return (R)this.zone;
        }
        if (temporalQuery == TemporalQueries.chronology()) {
            return (R)this.chrono;
        }
        if (temporalQuery == TemporalQueries.localDate()) {
            return (R)(this.date != null ? LocalDate.from(this.date) : null);
        }
        if (temporalQuery == TemporalQueries.localTime()) {
            return (R)this.time;
        }
        if (temporalQuery == TemporalQueries.zone() || temporalQuery == TemporalQueries.offset()) {
            return temporalQuery.queryFrom(this);
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return null;
        }
        return temporalQuery.queryFrom(this);
    }

    TemporalAccessor resolve(ResolverStyle resolverStyle, Set<TemporalField> set) {
        if (set != null) {
            this.fieldValues.keySet().retainAll(set);
        }
        this.resolverStyle = resolverStyle;
        this.resolveFields();
        this.resolveTimeLenient();
        this.crossCheck();
        this.resolvePeriod();
        this.resolveFractional();
        this.resolveInstant();
        return this;
    }

    private void resolveFields() {
        this.resolveInstantFields();
        this.resolveDateFields();
        this.resolveTimeFields();
        if (this.fieldValues.size() > 0) {
            int n = 0;
            block0: while (n < 50) {
                for (Map.Entry<TemporalField, Long> entry : this.fieldValues.entrySet()) {
                    TemporalField temporalField = entry.getKey();
                    ChronoLocalDateTime chronoLocalDateTime = temporalField.resolve(this.fieldValues, this, this.resolverStyle);
                    if (chronoLocalDateTime != null) {
                        Comparable<ChronoZonedDateTime<?>> comparable;
                        if (chronoLocalDateTime instanceof ChronoZonedDateTime) {
                            comparable = (ChronoZonedDateTime)((Object)chronoLocalDateTime);
                            if (this.zone == null) {
                                this.zone = comparable.getZone();
                            } else if (!this.zone.equals(comparable.getZone())) {
                                throw new DateTimeException("ChronoZonedDateTime must use the effective parsed zone: " + this.zone);
                            }
                            chronoLocalDateTime = comparable.toLocalDateTime();
                        }
                        if (chronoLocalDateTime instanceof ChronoLocalDateTime) {
                            comparable = chronoLocalDateTime;
                            this.updateCheckConflict(comparable.toLocalTime(), Period.ZERO);
                            this.updateCheckConflict((ChronoLocalDate)comparable.toLocalDate());
                            ++n;
                            continue block0;
                        }
                        if (chronoLocalDateTime instanceof ChronoLocalDate) {
                            this.updateCheckConflict((ChronoLocalDate)((Object)chronoLocalDateTime));
                            ++n;
                            continue block0;
                        }
                        if (chronoLocalDateTime instanceof LocalTime) {
                            this.updateCheckConflict((LocalTime)((Object)chronoLocalDateTime), Period.ZERO);
                            ++n;
                            continue block0;
                        }
                        throw new DateTimeException("Method resolve() can only return ChronoZonedDateTime, ChronoLocalDateTime, ChronoLocalDate or LocalTime");
                    }
                    if (this.fieldValues.containsKey(temporalField)) continue;
                    ++n;
                    continue block0;
                }
            }
            if (n == 50) {
                throw new DateTimeException("One of the parsed fields has an incorrectly implemented resolve method");
            }
            if (n > 0) {
                this.resolveInstantFields();
                this.resolveDateFields();
                this.resolveTimeFields();
            }
        }
    }

    private void updateCheckConflict(TemporalField temporalField, TemporalField temporalField2, Long l) {
        Long l2 = this.fieldValues.put(temporalField2, l);
        if (l2 != null && l2.longValue() != l.longValue()) {
            throw new DateTimeException("Conflict found: " + temporalField2 + " " + l2 + " differs from " + temporalField2 + " " + l + " while resolving  " + temporalField);
        }
    }

    private void resolveInstantFields() {
        if (this.fieldValues.containsKey(ChronoField.INSTANT_SECONDS)) {
            if (this.zone != null) {
                this.resolveInstantFields0(this.zone);
            } else {
                Long l = this.fieldValues.get(ChronoField.OFFSET_SECONDS);
                if (l != null) {
                    ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(l.intValue());
                    this.resolveInstantFields0(zoneOffset);
                }
            }
        }
    }

    private void resolveInstantFields0(ZoneId zoneId) {
        Instant instant = Instant.ofEpochSecond(this.fieldValues.remove(ChronoField.INSTANT_SECONDS));
        ChronoZonedDateTime<? extends ChronoLocalDate> chronoZonedDateTime = this.chrono.zonedDateTime(instant, zoneId);
        this.updateCheckConflict(chronoZonedDateTime.toLocalDate());
        this.updateCheckConflict(ChronoField.INSTANT_SECONDS, ChronoField.SECOND_OF_DAY, Long.valueOf(chronoZonedDateTime.toLocalTime().toSecondOfDay()));
    }

    private void resolveDateFields() {
        this.updateCheckConflict(this.chrono.resolveDate(this.fieldValues, this.resolverStyle));
    }

    private void updateCheckConflict(ChronoLocalDate chronoLocalDate) {
        if (this.date != null) {
            if (chronoLocalDate != null && !this.date.equals(chronoLocalDate)) {
                throw new DateTimeException("Conflict found: Fields resolved to two different dates: " + this.date + " " + chronoLocalDate);
            }
        } else if (chronoLocalDate != null) {
            if (!this.chrono.equals(chronoLocalDate.getChronology())) {
                throw new DateTimeException("ChronoLocalDate must use the effective parsed chronology: " + this.chrono);
            }
            this.date = chronoLocalDate;
        }
    }

    private void resolveTimeFields() {
        long l;
        long l2;
        if (this.fieldValues.containsKey(ChronoField.CLOCK_HOUR_OF_DAY)) {
            l2 = this.fieldValues.remove(ChronoField.CLOCK_HOUR_OF_DAY);
            if (this.resolverStyle == ResolverStyle.STRICT || this.resolverStyle == ResolverStyle.SMART && l2 != 0L) {
                ChronoField.CLOCK_HOUR_OF_DAY.checkValidValue(l2);
            }
            this.updateCheckConflict(ChronoField.CLOCK_HOUR_OF_DAY, ChronoField.HOUR_OF_DAY, l2 == 24L ? 0L : l2);
        }
        if (this.fieldValues.containsKey(ChronoField.CLOCK_HOUR_OF_AMPM)) {
            l2 = this.fieldValues.remove(ChronoField.CLOCK_HOUR_OF_AMPM);
            if (this.resolverStyle == ResolverStyle.STRICT || this.resolverStyle == ResolverStyle.SMART && l2 != 0L) {
                ChronoField.CLOCK_HOUR_OF_AMPM.checkValidValue(l2);
            }
            this.updateCheckConflict(ChronoField.CLOCK_HOUR_OF_AMPM, ChronoField.HOUR_OF_AMPM, l2 == 12L ? 0L : l2);
        }
        if (this.fieldValues.containsKey(ChronoField.AMPM_OF_DAY) && this.fieldValues.containsKey(ChronoField.HOUR_OF_AMPM)) {
            l2 = this.fieldValues.remove(ChronoField.AMPM_OF_DAY);
            l = this.fieldValues.remove(ChronoField.HOUR_OF_AMPM);
            if (this.resolverStyle == ResolverStyle.LENIENT) {
                this.updateCheckConflict(ChronoField.AMPM_OF_DAY, ChronoField.HOUR_OF_DAY, Math.addExact(Math.multiplyExact(l2, 12L), l));
            } else {
                ChronoField.AMPM_OF_DAY.checkValidValue(l2);
                ChronoField.HOUR_OF_AMPM.checkValidValue(l2);
                this.updateCheckConflict(ChronoField.AMPM_OF_DAY, ChronoField.HOUR_OF_DAY, l2 * 12L + l);
            }
        }
        if (this.fieldValues.containsKey(ChronoField.NANO_OF_DAY)) {
            l2 = this.fieldValues.remove(ChronoField.NANO_OF_DAY);
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.NANO_OF_DAY.checkValidValue(l2);
            }
            this.updateCheckConflict(ChronoField.NANO_OF_DAY, ChronoField.HOUR_OF_DAY, l2 / 3600000000000L);
            this.updateCheckConflict(ChronoField.NANO_OF_DAY, ChronoField.MINUTE_OF_HOUR, l2 / 60000000000L % 60L);
            this.updateCheckConflict(ChronoField.NANO_OF_DAY, ChronoField.SECOND_OF_MINUTE, l2 / 1000000000L % 60L);
            this.updateCheckConflict(ChronoField.NANO_OF_DAY, ChronoField.NANO_OF_SECOND, l2 % 1000000000L);
        }
        if (this.fieldValues.containsKey(ChronoField.MICRO_OF_DAY)) {
            l2 = this.fieldValues.remove(ChronoField.MICRO_OF_DAY);
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.MICRO_OF_DAY.checkValidValue(l2);
            }
            this.updateCheckConflict(ChronoField.MICRO_OF_DAY, ChronoField.SECOND_OF_DAY, l2 / 1000000L);
            this.updateCheckConflict(ChronoField.MICRO_OF_DAY, ChronoField.MICRO_OF_SECOND, l2 % 1000000L);
        }
        if (this.fieldValues.containsKey(ChronoField.MILLI_OF_DAY)) {
            l2 = this.fieldValues.remove(ChronoField.MILLI_OF_DAY);
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.MILLI_OF_DAY.checkValidValue(l2);
            }
            this.updateCheckConflict(ChronoField.MILLI_OF_DAY, ChronoField.SECOND_OF_DAY, l2 / 1000L);
            this.updateCheckConflict(ChronoField.MILLI_OF_DAY, ChronoField.MILLI_OF_SECOND, l2 % 1000L);
        }
        if (this.fieldValues.containsKey(ChronoField.SECOND_OF_DAY)) {
            l2 = this.fieldValues.remove(ChronoField.SECOND_OF_DAY);
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.SECOND_OF_DAY.checkValidValue(l2);
            }
            this.updateCheckConflict(ChronoField.SECOND_OF_DAY, ChronoField.HOUR_OF_DAY, l2 / 3600L);
            this.updateCheckConflict(ChronoField.SECOND_OF_DAY, ChronoField.MINUTE_OF_HOUR, l2 / 60L % 60L);
            this.updateCheckConflict(ChronoField.SECOND_OF_DAY, ChronoField.SECOND_OF_MINUTE, l2 % 60L);
        }
        if (this.fieldValues.containsKey(ChronoField.MINUTE_OF_DAY)) {
            l2 = this.fieldValues.remove(ChronoField.MINUTE_OF_DAY);
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.MINUTE_OF_DAY.checkValidValue(l2);
            }
            this.updateCheckConflict(ChronoField.MINUTE_OF_DAY, ChronoField.HOUR_OF_DAY, l2 / 60L);
            this.updateCheckConflict(ChronoField.MINUTE_OF_DAY, ChronoField.MINUTE_OF_HOUR, l2 % 60L);
        }
        if (this.fieldValues.containsKey(ChronoField.NANO_OF_SECOND)) {
            l2 = this.fieldValues.get(ChronoField.NANO_OF_SECOND);
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.NANO_OF_SECOND.checkValidValue(l2);
            }
            if (this.fieldValues.containsKey(ChronoField.MICRO_OF_SECOND)) {
                l = this.fieldValues.remove(ChronoField.MICRO_OF_SECOND);
                if (this.resolverStyle != ResolverStyle.LENIENT) {
                    ChronoField.MICRO_OF_SECOND.checkValidValue(l);
                }
                l2 = l * 1000L + l2 % 1000L;
                this.updateCheckConflict(ChronoField.MICRO_OF_SECOND, ChronoField.NANO_OF_SECOND, l2);
            }
            if (this.fieldValues.containsKey(ChronoField.MILLI_OF_SECOND)) {
                l = this.fieldValues.remove(ChronoField.MILLI_OF_SECOND);
                if (this.resolverStyle != ResolverStyle.LENIENT) {
                    ChronoField.MILLI_OF_SECOND.checkValidValue(l);
                }
                this.updateCheckConflict(ChronoField.MILLI_OF_SECOND, ChronoField.NANO_OF_SECOND, l * 1000000L + l2 % 1000000L);
            }
        }
        if (this.fieldValues.containsKey(ChronoField.HOUR_OF_DAY) && this.fieldValues.containsKey(ChronoField.MINUTE_OF_HOUR) && this.fieldValues.containsKey(ChronoField.SECOND_OF_MINUTE) && this.fieldValues.containsKey(ChronoField.NANO_OF_SECOND)) {
            l2 = this.fieldValues.remove(ChronoField.HOUR_OF_DAY);
            l = this.fieldValues.remove(ChronoField.MINUTE_OF_HOUR);
            long l3 = this.fieldValues.remove(ChronoField.SECOND_OF_MINUTE);
            long l4 = this.fieldValues.remove(ChronoField.NANO_OF_SECOND);
            this.resolveTime(l2, l, l3, l4);
        }
    }

    private void resolveTimeLenient() {
        if (this.time == null) {
            long l;
            if (this.fieldValues.containsKey(ChronoField.MILLI_OF_SECOND)) {
                l = this.fieldValues.remove(ChronoField.MILLI_OF_SECOND);
                if (this.fieldValues.containsKey(ChronoField.MICRO_OF_SECOND)) {
                    long l2 = l * 1000L + this.fieldValues.get(ChronoField.MICRO_OF_SECOND) % 1000L;
                    this.updateCheckConflict(ChronoField.MILLI_OF_SECOND, ChronoField.MICRO_OF_SECOND, l2);
                    this.fieldValues.remove(ChronoField.MICRO_OF_SECOND);
                    this.fieldValues.put(ChronoField.NANO_OF_SECOND, l2 * 1000L);
                } else {
                    this.fieldValues.put(ChronoField.NANO_OF_SECOND, l * 1000000L);
                }
            } else if (this.fieldValues.containsKey(ChronoField.MICRO_OF_SECOND)) {
                l = this.fieldValues.remove(ChronoField.MICRO_OF_SECOND);
                this.fieldValues.put(ChronoField.NANO_OF_SECOND, l * 1000L);
            }
            Long l3 = this.fieldValues.get(ChronoField.HOUR_OF_DAY);
            if (l3 != null) {
                Long object = this.fieldValues.get(ChronoField.MINUTE_OF_HOUR);
                Long l4 = this.fieldValues.get(ChronoField.SECOND_OF_MINUTE);
                Long l2 = this.fieldValues.get(ChronoField.NANO_OF_SECOND);
                if (object == null && (l4 != null || l2 != null) || object != null && l4 == null && l2 != null) {
                    return;
                }
                long l5 = object != null ? object : 0L;
                long l6 = l4 != null ? l4 : 0L;
                long l7 = l2 != null ? l2 : 0L;
                this.resolveTime(l3, l5, l6, l7);
                this.fieldValues.remove(ChronoField.HOUR_OF_DAY);
                this.fieldValues.remove(ChronoField.MINUTE_OF_HOUR);
                this.fieldValues.remove(ChronoField.SECOND_OF_MINUTE);
                this.fieldValues.remove(ChronoField.NANO_OF_SECOND);
            }
        }
        if (this.resolverStyle != ResolverStyle.LENIENT && this.fieldValues.size() > 0) {
            for (Map.Entry entry : this.fieldValues.entrySet()) {
                TemporalField temporalField = (TemporalField)entry.getKey();
                if (!(temporalField instanceof ChronoField) || !temporalField.isTimeBased()) continue;
                ((ChronoField)temporalField).checkValidValue((Long)entry.getValue());
            }
        }
    }

    private void resolveTime(long l, long l2, long l3, long l4) {
        if (this.resolverStyle == ResolverStyle.LENIENT) {
            long l5 = Math.multiplyExact(l, 3600000000000L);
            l5 = Math.addExact(l5, Math.multiplyExact(l2, 60000000000L));
            l5 = Math.addExact(l5, Math.multiplyExact(l3, 1000000000L));
            l5 = Math.addExact(l5, l4);
            int n = (int)Math.floorDiv(l5, 86400000000000L);
            long l6 = Math.floorMod(l5, 86400000000000L);
            this.updateCheckConflict(LocalTime.ofNanoOfDay(l6), Period.ofDays(n));
        } else {
            int n = ChronoField.MINUTE_OF_HOUR.checkValidIntValue(l2);
            int n2 = ChronoField.NANO_OF_SECOND.checkValidIntValue(l4);
            if (this.resolverStyle == ResolverStyle.SMART && l == 24L && n == 0 && l3 == 0L && n2 == 0) {
                this.updateCheckConflict(LocalTime.MIDNIGHT, Period.ofDays(1));
            } else {
                int n3 = ChronoField.HOUR_OF_DAY.checkValidIntValue(l);
                int n4 = ChronoField.SECOND_OF_MINUTE.checkValidIntValue(l3);
                this.updateCheckConflict(LocalTime.of(n3, n, n4, n2), Period.ZERO);
            }
        }
    }

    private void resolvePeriod() {
        if (this.date != null && this.time != null && !this.excessDays.isZero()) {
            this.date = this.date.plus(this.excessDays);
            this.excessDays = Period.ZERO;
        }
    }

    private void resolveFractional() {
        if (this.time == null && (this.fieldValues.containsKey(ChronoField.INSTANT_SECONDS) || this.fieldValues.containsKey(ChronoField.SECOND_OF_DAY) || this.fieldValues.containsKey(ChronoField.SECOND_OF_MINUTE))) {
            if (this.fieldValues.containsKey(ChronoField.NANO_OF_SECOND)) {
                long l = this.fieldValues.get(ChronoField.NANO_OF_SECOND);
                this.fieldValues.put(ChronoField.MICRO_OF_SECOND, l / 1000L);
                this.fieldValues.put(ChronoField.MILLI_OF_SECOND, l / 1000000L);
            } else {
                this.fieldValues.put(ChronoField.NANO_OF_SECOND, 0L);
                this.fieldValues.put(ChronoField.MICRO_OF_SECOND, 0L);
                this.fieldValues.put(ChronoField.MILLI_OF_SECOND, 0L);
            }
        }
    }

    private void resolveInstant() {
        if (this.date != null && this.time != null) {
            if (this.zone != null) {
                long l = this.date.atTime(this.time).atZone(this.zone).getLong(ChronoField.INSTANT_SECONDS);
                this.fieldValues.put(ChronoField.INSTANT_SECONDS, l);
            } else {
                Long l = this.fieldValues.get(ChronoField.OFFSET_SECONDS);
                if (l != null) {
                    ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(l.intValue());
                    long l2 = this.date.atTime(this.time).atZone(zoneOffset).getLong(ChronoField.INSTANT_SECONDS);
                    this.fieldValues.put(ChronoField.INSTANT_SECONDS, l2);
                }
            }
        }
    }

    private void updateCheckConflict(LocalTime localTime, Period period) {
        if (this.time != null) {
            if (!this.time.equals(localTime)) {
                throw new DateTimeException("Conflict found: Fields resolved to different times: " + this.time + " " + localTime);
            }
            if (!(this.excessDays.isZero() || period.isZero() || this.excessDays.equals(period))) {
                throw new DateTimeException("Conflict found: Fields resolved to different excess periods: " + this.excessDays + " " + period);
            }
            this.excessDays = period;
        } else {
            this.time = localTime;
            this.excessDays = period;
        }
    }

    private void crossCheck() {
        if (this.date != null) {
            this.crossCheck(this.date);
        }
        if (this.time != null) {
            this.crossCheck(this.time);
            if (this.date != null && this.fieldValues.size() > 0) {
                this.crossCheck(this.date.atTime(this.time));
            }
        }
    }

    private void crossCheck(TemporalAccessor temporalAccessor) {
        Iterator<Map.Entry<TemporalField, Long>> iterator = this.fieldValues.entrySet().iterator();
        while (iterator.hasNext()) {
            long l;
            Map.Entry<TemporalField, Long> entry = iterator.next();
            TemporalField temporalField = entry.getKey();
            if (!temporalAccessor.isSupported(temporalField)) continue;
            try {
                l = temporalAccessor.getLong(temporalField);
            }
            catch (RuntimeException runtimeException) {
                continue;
            }
            long l2 = entry.getValue();
            if (l != l2) {
                throw new DateTimeException("Conflict found: Field " + temporalField + " " + l + " differs from " + temporalField + " " + l2 + " derived from " + temporalAccessor);
            }
            iterator.remove();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.fieldValues).append(',').append(this.chrono);
        if (this.zone != null) {
            stringBuilder.append(',').append(this.zone);
        }
        if (this.date != null || this.time != null) {
            stringBuilder.append(" resolved to ");
            if (this.date != null) {
                stringBuilder.append(this.date);
                if (this.time != null) {
                    stringBuilder.append('T').append(this.time);
                }
            } else {
                stringBuilder.append(this.time);
            }
        }
        return stringBuilder.toString();
    }
}

