/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.tomcat.util.net.openssl;

import java.io.Serial;
import java.io.Serializable;

public class OpenSSLConfCmd implements Serializable {

    // Tomcat / Tomcat Native custom commands. Used internally by Tomcat. Not intended for direct use by users.
    public static final String NO_OCSP_CHECK = "NO_OCSP_CHECK";
    public static final String OCSP_SOFT_FAIL = "OCSP_SOFT_FAIL";
    public static final String OCSP_TIMEOUT = "OCSP_TIMEOUT";
    public static final String OCSP_VERIFY_FLAGS = "OCSP_VERIFY_FLAGS";

    @Serial
    private static final long serialVersionUID = 1L;

    private String name = null;
    private String value = null;

    public OpenSSLConfCmd() {
    }

    public OpenSSLConfCmd(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
