/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider.file;

import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.internal.provider.file.TemplateFileProvider;
import org.openhab.core.automation.internal.provider.file.WatchServiceUtil;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.parser.ValidationException;
import org.openhab.core.automation.template.RuleTemplate;
import org.openhab.core.automation.template.RuleTemplateProvider;
import org.openhab.core.service.WatchService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component(immediate=true, service={RuleTemplateProvider.class})
public class TemplateFileProviderWatcher
extends TemplateFileProvider {
    private final WatchService watchService;

    @Activate
    public TemplateFileProviderWatcher(@Reference(target="(watchservice.name=configWatcher)") WatchService watchService) {
        this.watchService = watchService;
    }

    @Override
    protected void initializeWatchService(String watchingDir) {
        WatchServiceUtil.initializeWatchService(watchingDir, this, this.watchService);
    }

    @Override
    protected void deactivateWatchService(String watchingDir) {
        WatchServiceUtil.deactivateWatchService(watchingDir, this);
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, target="(parser.type=parser.template)")
    public void addParser(Parser<RuleTemplate> parser, Map<String, String> properties) {
        super.addParser(parser, properties);
    }

    @Override
    public void removeParser(Parser<RuleTemplate> parser, Map<String, String> properties) {
        super.removeParser(parser, properties);
    }

    @Override
    protected void validateObject(RuleTemplate template) throws ValidationException {
        String s = template.getUID();
        if (s == null || s.isBlank()) {
            throw new ValidationException(ValidationException.ObjectType.TEMPLATE, null, "UID cannot be blank");
        }
        s = template.getLabel();
        if (s == null || s.isBlank()) {
            throw new ValidationException(ValidationException.ObjectType.TEMPLATE, template.getUID(), "Label cannot be blank");
        }
        if (template.getModules(Module.class).isEmpty()) {
            throw new ValidationException(ValidationException.ObjectType.TEMPLATE, template.getUID(), "There must be at least one module");
        }
    }
}

