# Changelog

## v1.3.0 - 2024-07-09

## v1.3.0-rc3 - 2024-07-08

- Fixed a bug where not all pure function calls in constant definitions would be
  annotated as `@__PURE__` when compiling to JavaScript.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

## v1.3.0-rc2 - 2024-07-06

### Formatter

- Fixed a bug when multiple subjects in a case would be split even if not
  necessary.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

## v1.3.0-rc1 - 2024-06-30

### Build tool

- `gleam remove` will now present an error if a package being removed does not
  exist as a dependency in the project.
  ([Changfeng Lou](https://github.com/hnlcf))

- `gleam add` now takes an optional package version specifier,
  separated by a `@`, that resolves as follows:

  ```sh
  gleam add lustre@1.2.3 # "1.2.3"
  gleam add lustre@1.2   # ">= 1.2.0 and < 2.0.0"
  gleam add lustre@1     # ">= 1.0.0 and < 2.0.0"
  ```

  ([Rahul D. Ghosal](https://github.com/rdghosal))

### Compiler

- Added more an informative error message for when attempting to use the `..`
  syntax to append to a list rather than prepend.

  ```
  error: Syntax error
    ┌─ /src/parse/error.gleam:4:14
    │
  4 │         [..rest, last] -> 1
    │          ^^^^^^ I wasn't expecting elements after this

  Lists are immutable and singly-linked, so to match on the end
  of a list would require the whole list to be traversed. This
  would be slow, so there is no built-in syntax for it. Pattern
  match on the start of the list instead.
  ```

  ([Antonio Iaccarino](https://github.com/eingin))

- The compiler now emits a warning for redundant function captures in a
  pipeline:

  ```
  warning: Redundant function capture
    ┌─ /src/warning/wrn.gleam:5:17
    │
  5 │     1 |> wibble(_, 2) |> wibble(2)
    │                 ^ You can safely remove this

  This function capture is redundant since the value is already piped as the
  first argument of this call.

  See: https://tour.gleam.run/functions/pipelines/
  ```

  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- The syntax `[a..b]` is now deprecated in favour of the `[a, ..b]` syntax.
  This was to avoid it being mistaken for a range syntax, which Gleam does
  not have.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- Functions etc named `maybe` are now escaped in generated Erlang as it is now a
  reserved word in Erlang/OTP 27.
  ([Jake Barszcz](https://github.com/barszcz))

- Functions, types and constructors named `maybe` and `else` are now
  escaped in generated Erlang to avoid clashing with Erlang's keywords.
  ([Jake Barszcz](https://github.com/barszcz)) and
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- Non byte aligned arrays that use literals for size are now marked as an
  Unsupported feature for Javascript since they would already cause
  a runtime error on Javascript.

  This means if you compile specifically for Javascript you will now receive
  this error:

  ```
  error: Unsupported feature for compilation target
    ┌─ /src/test/gleam_test.gleam:6:5
    │
  6 │   <<1:size(5)>>
    │     ^^^^^^^^^

  Non byte aligned array is not supported for JavaScript compilation.
  ```

  Else any functions which rely on this will not be compiled into Javascript.
  ([Pi-Cla](https://github.com/Pi-Cla))

- Compilation fault tolerance is now at a statement level instead of a function
  level. This means that the compiler will attempt to infer the rest of the
  statements in a function when there is an error in a previous one.
  ([Ameen Radwan](https://github.com/Acepie))

- The JavaScript prelude is no-longer rewritten each time a project is compiled
  to JavaScript.
  ([Ofek Doitch](https://github.com/ofekd))

- Compiler now supports arithmetic operations in guards.
  ([Danielle Maywood](https://github.com/DanielleMaywood))

- Import cycles now show the location where the import occur.
  ([Ameen Radwan](https://github.com/Acepie))

- Error messages resulting from unexpected tokens now include information on
  the found token's type. This updated message explains how the lexer handled
  the token, so as to guide the user towards providing correct syntax.

  Following is an example, where the error message indicates that the name of
  the provided field conflicts with a keyword:

  ```
  3 │     A(type: String)
    │       ^^^^ I was not expecting this

  Found the keyword `type`, expected one of:
  - `)`
  - a constructor argument name
  ```

  ([Rahul D. Ghosal](https://github.com/rdghosal))

- When compiling to JavaScript constants will now be annotated as `@__PURE__`.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

### Formatter

### Language Server

- The language server will now suggest the "Remove redundant tuple" action even
  if the case expression contains some catch all patterns:

  ```
  case #(a, b) {
    #(1, 2) -> todo
    _ -> todo
  }
  ```

  Becomes:

  ```
  case a, b {
    1, 2 -> todo
    _, _ -> todo
  }
  ```

  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- LSP can now suggest completions for values and types from importable modules
  and adds the import to the top of the file.
  ([Ameen Radwan](https://github.com/Acepie))

- Diagnostics with extra labels now show the diagnostic in all locations
  including across multiple files.
  ([Ameen Radwan](https://github.com/Acepie))

- LSP completions now use the "text_edit" language server API resulting in
  better/more accurate insertions.
  ([Ameen Radwan](https://github.com/Acepie))

- Completions are no longer provided inside comments.
  ([Nicky Lim](https://github.com/nicklimmm))

- The language server will now show all the ignored fields when hovering over
  `..` in a record pattern.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

### Bug Fixes

- Fixed a bug where the compiler would output a confusing error message when
  trying to use the spread syntax to append to a list.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- Fixed a bug where the formatter would strip empty lines out of the body of an
  anonymous function passed as an argument.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- Fixed a bug where the compiler would crash when a type was defined with
  the same name as an imported type.
  ([Gears](https://github.com/gearsdatapacks))

- Fixed a bug where a horizontal scrollbar would appear on code blocks in built
  documentation when they contained lines 79 or 80 characters long.
  ([Richard Viney](https://github.com/richard-viney))

- Fixed a bug where importing a record constructor in an unqualified fashion and
  aliasing it and then using it in a constant expression would generate invalid
  JavaScript.
  ([Louis Pilfold](https://github.com/lpil))

- Fixed a bug where the compiler would crash because types weren't registered if
  they referenced a non-existent type.
  ([Gears](https://github.com/gearsdatapacks))

- Fixed a bug where the compiler would generate invalid Erlang when pattern
  matching on strings with an `as` pattern.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- Fixed a bug where the compiler would warn that a module alias was unused when
  it was only used in case patterns.
  ([Michael Jones](https://github.com/michaeljones))

## v1.2.1 - 2024-05-30

### Bug Fixes

- Fixed a bug where the compiler could fail to detect modules that would clash
  with Erlang modules.
  ([Louis Pilfold](https://github.com/lpil))

- Fixed a bug where dependency version resolution could crash for certain
  release candidate versions.
  ([Marshall Bowers](https://github.com/maxdeviant))

- Fixed a bug where trailing comments would be moved out of a bit array.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))
