/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.stacktrace;

import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.Messages;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;

public class StacktraceFormatToolkit {
    public static String formatFrame(IMCFrame frame, FrameSeparator frameSeparator) {
        return StacktraceFormatToolkit.formatFrame(frame, frameSeparator, true, true, true, true, true, true);
    }

    public static String formatFrame(IMCFrame frame, FrameSeparator frameSeparator, boolean showReturnValue, boolean showReturnValuePackage, boolean showClassName, boolean showClassPackageName, boolean showArguments, boolean showArgumentsPackage) {
        String formatted;
        if (frame == StacktraceModel.UNKNOWN_FRAME) {
            return Messages.getString("STACKTRACE_UNCLASSIFIABLE_FRAME");
        }
        String detailsText = "";
        switch (frameSeparator.getCategorization()) {
            case PACKAGE: {
                formatted = FormatToolkit.getPackage(frame.getMethod().getType().getPackage());
                break;
            }
            case CLASS: {
                formatted = FormatToolkit.getType(frame.getMethod().getType(), showClassPackageName);
                break;
            }
            case BCI: {
                detailsText = " [BCI: " + StacktraceFormatToolkit.asString(frame.getBCI()) + "]";
            }
            case LINE: {
                detailsText = ":" + StacktraceFormatToolkit.asString(frame.getFrameLineNumber()) + detailsText;
            }
            default: {
                formatted = FormatToolkit.getHumanReadable(frame.getMethod(), showReturnValue, showReturnValuePackage, showClassName, showClassPackageName, showArguments, showArgumentsPackage) + detailsText;
            }
        }
        if (frameSeparator.isDistinguishFramesByOptimization()) {
            formatted = formatted + " (" + frame.getType().getName() + ")";
        }
        return formatted;
    }

    private static String asString(Object element) {
        return element == null ? "?" : element.toString();
    }
}

