/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.changeSignature.CallReferenceUsageInfo;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProvider;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoConverters;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.changeSignature.PsiCallReference;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTagValueToken;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrMethodCallUsageInfo;

public final class GrChangeSignatureUsageProvider
implements ChangeSignatureUsageProvider {
    private static final Logger LOG = Logger.getInstance(GrChangeSignatureUsageProvider.class);

    @Nullable
    public UsageInfo createOverrideUsageInfo(@NotNull ChangeInfo changeInfo, @NotNull PsiElement overrider, @NotNull PsiElement method, boolean isOriginalOverrider, boolean modifyArgs, boolean modifyExceptions, List<? super UsageInfo> result2) {
        if (changeInfo == null) {
            GrChangeSignatureUsageProvider.$$$reportNull$$$0(0);
        }
        if (overrider == null) {
            GrChangeSignatureUsageProvider.$$$reportNull$$$0(1);
        }
        if (method == null) {
            GrChangeSignatureUsageProvider.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(overrider instanceof PsiMethod);
        JavaChangeInfo javaChangeInfo = JavaChangeInfoConverters.getJavaChangeInfo((ChangeInfo)changeInfo, (UsageInfo)new UsageInfo(overrider));
        if (javaChangeInfo == null) {
            return null;
        }
        return new OverriderUsageInfo((PsiMethod)overrider, javaChangeInfo.getMethod(), isOriginalOverrider, modifyArgs, modifyExceptions);
    }

    @Nullable
    public UsageInfo createUsageInfo(@NotNull ChangeInfo changeInfo, @NotNull PsiReference reference, @NotNull PsiElement m, boolean isToModifyArgs, boolean isToThrowExceptions) {
        boolean isToCatchExceptions;
        JavaChangeInfo javaChangeInfo;
        if (changeInfo == null) {
            GrChangeSignatureUsageProvider.$$$reportNull$$$0(3);
        }
        if (reference == null) {
            GrChangeSignatureUsageProvider.$$$reportNull$$$0(4);
        }
        if (m == null) {
            GrChangeSignatureUsageProvider.$$$reportNull$$$0(5);
        }
        if ((javaChangeInfo = JavaChangeInfoConverters.getJavaChangeInfo((ChangeInfo)changeInfo, (UsageInfo)new UsageInfo(reference))) == null) {
            return null;
        }
        PsiMethod method = javaChangeInfo.getMethod();
        if (m instanceof PsiMethod) {
            method = (PsiMethod)m;
        }
        PsiElement element = reference.getElement();
        boolean bl = isToCatchExceptions = isToThrowExceptions && GrChangeSignatureUsageProvider.needToCatchExceptions(RefactoringUtil.getEnclosingMethod((PsiElement)element), javaChangeInfo);
        if (PsiUtil.isMethodUsage(element)) {
            return new GrMethodCallUsageInfo(element, isToModifyArgs, isToCatchExceptions, method);
        }
        if (element instanceof GrDocTagValueToken) {
            return new UsageInfo(reference.getElement());
        }
        if (element instanceof GrMethod && ((GrMethod)element).isConstructor()) {
            return new DefaultConstructorImplicitUsageInfo((PsiMethod)((GrMethod)element), ((GrMethod)element).getContainingClass(), method);
        }
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            LOG.assertTrue(method.isConstructor());
            if (psiClass instanceof GrAnonymousClassDefinition) {
                return new GrMethodCallUsageInfo(element, isToModifyArgs, isToCatchExceptions, method);
            }
            return new NoConstructorClassUsageInfo(psiClass);
        }
        if (reference instanceof PsiCallReference) {
            return new CallReferenceUsageInfo((PsiCallReference)reference);
        }
        return new MoveRenameUsageInfo(element, reference, (PsiElement)method);
    }

    private static boolean needToCatchExceptions(PsiMethod caller, JavaChangeInfo info) {
        return info.isExceptionSetOrOrderChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overrider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrChangeSignatureUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createOverrideUsageInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createUsageInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

