/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml;

import com.intellij.platform.ml.Tier;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002BO\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00070\u0006\u0012\u0016\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00070\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0005\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/ml/MLTask;", "P", "", "name", "", "levels", "", "", "Lcom/intellij/platform/ml/Tier;", "callParameters", "predictionClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/Class;)V", "getName", "()Ljava/lang/String;", "getLevels", "()Ljava/util/List;", "getCallParameters", "getPredictionClass", "()Ljava/lang/Class;", "intellij.platform.ml"})
@ApiStatus.Internal
public abstract class MLTask<P> {
    @NotNull
    private final String name;
    @NotNull
    private final List<Set<Tier<?>>> levels;
    @NotNull
    private final List<Set<Tier<?>>> callParameters;
    @NotNull
    private final Class<P> predictionClass;

    protected MLTask(@NotNull String name, @NotNull List<? extends Set<? extends Tier<?>>> levels, @NotNull List<? extends Set<? extends Tier<?>>> callParameters, @NotNull Class<P> predictionClass) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(levels, (String)"levels");
        Intrinsics.checkNotNullParameter(callParameters, (String)"callParameters");
        Intrinsics.checkNotNullParameter(predictionClass, (String)"predictionClass");
        this.name = name;
        this.levels = levels;
        this.callParameters = callParameters;
        this.predictionClass = predictionClass;
        if (!(!((Collection)this.levels).isEmpty())) {
            boolean $i$a$-require-MLTask$32 = false;
            String $i$a$-require-MLTask$32 = StringsKt.trimIndent((String)("\n        Task " + this + " should contain at least one level\n      "));
            throw new IllegalArgumentException($i$a$-require-MLTask$32.toString());
        }
        if (!(this.callParameters.size() == this.levels.size())) {
            boolean bl = false;
            String string = StringsKt.trimIndent((String)("\n        Task " + this + " has " + this.levels.size() + " levels, but in call parameters there are " + this.callParameters.size() + " levels.\n        Each level must have its own set of call parameters.\n      "));
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<Set<Tier<?>>> getLevels() {
        return this.levels;
    }

    @NotNull
    public final List<Set<Tier<?>>> getCallParameters() {
        return this.callParameters;
    }

    @NotNull
    public final Class<P> getPredictionClass() {
        return this.predictionClass;
    }
}

