/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.CodeInsightFrontbackUtil;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.jsp.IJspClassLevelDeclarationStatement;
import com.intellij.psi.jsp.IJspTemplateStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

final class JavaStatementMover
extends LineMover {
    private static final Logger LOG = Logger.getInstance(JavaStatementMover.class);
    private static final Key<PsiElement> STATEMENT_TO_SURROUND_WITH_CODE_BLOCK_KEY = Key.create((String)"STATEMENT_TO_SURROUND_WITH_CODE_BLOCK_KEY");

    JavaStatementMover() {
    }

    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            JavaStatementMover.$$$reportNull$$$0(0);
        }
        if (info == null) {
            JavaStatementMover.$$$reportNull$$$0(1);
        }
        super.beforeMove(editor, info, down);
        PsiElement statement = (PsiElement)STATEMENT_TO_SURROUND_WITH_CODE_BLOCK_KEY.get((UserDataHolder)info);
        if (statement != null) {
            JavaStatementMover.surroundWithCodeBlock(info, down, statement);
        }
    }

    private static void surroundWithCodeBlock(StatementUpDownMover.MoveInfo info, boolean down, PsiElement statement) {
        try {
            Document document = PsiDocumentManager.getInstance((Project)statement.getProject()).getDocument(statement.getContainingFile());
            assert (document != null) : statement.getContainingFile();
            int startOffset = document.getLineStartOffset(info.toMove.startLine);
            int endOffset = JavaStatementMover.getLineStartSafeOffset((Document)document, (int)info.toMove.endLine);
            if (document.getText().charAt(endOffset - 1) == '\n') {
                --endOffset;
            }
            RangeMarker lineRangeMarker = document.createRangeMarker(startOffset, endOffset);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(statement.getProject());
            PsiCodeBlock codeBlock = factory.createCodeBlock();
            codeBlock.add(statement);
            PsiBlockStatement blockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", statement);
            blockStatement.getCodeBlock().replace(codeBlock);
            PsiBlockStatement newStatement = (PsiBlockStatement)statement.replace((PsiElement)blockStatement);
            newStatement = (PsiBlockStatement)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)newStatement);
            info.toMove = new LineRange(document.getLineNumber(lineRangeMarker.getStartOffset()), document.getLineNumber(lineRangeMarker.getEndOffset()) + 1);
            PsiCodeBlock newCodeBlock = newStatement.getCodeBlock();
            if (down) {
                PsiElement blockChild = JavaStatementMover.firstNonWhiteElement((PsiElement)newCodeBlock.getFirstBodyElement(), (boolean)true);
                if (blockChild == null) {
                    blockChild = newCodeBlock.getRBrace();
                }
                assert (blockChild != null) : newCodeBlock;
                info.toMove2 = new LineRange(info.toMove2.startLine, document.getLineNumber(blockChild.getTextRange().getStartOffset()));
            } else {
                int end;
                PsiJavaToken brace = newCodeBlock.getRBrace();
                assert (brace != null) : newCodeBlock;
                int start = document.getLineNumber(brace.getTextRange().getStartOffset());
                if (start > (end = info.toMove.startLine)) {
                    end = start;
                }
                info.toMove2 = new LineRange(start, end);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        int endOffset;
        boolean available;
        if (editor == null) {
            JavaStatementMover.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JavaStatementMover.$$$reportNull$$$0(3);
        }
        if (info == null) {
            JavaStatementMover.$$$reportNull$$$0(4);
        }
        if (!(available = super.checkAvailable(editor, file, info, down))) {
            return false;
        }
        LineRange range = JavaStatementMover.expandLineRangeToCoverPsiElements(info.toMove, editor, file);
        if (range == null) {
            return false;
        }
        info.toMove = range;
        int startOffset = editor.logicalPositionToOffset(new LogicalPosition(range.startLine, 0));
        PsiElement[] statements = CodeInsightFrontbackUtil.findStatementsInRange(file, startOffset, endOffset = editor.logicalPositionToOffset(new LogicalPosition(range.endLine, 0)));
        if (statements.length == 0) {
            return false;
        }
        range.firstElement = statements[0];
        range.lastElement = statements[statements.length - 1];
        if (!JavaStatementMover.checkMovingInsideOutside(file, editor, info, down)) {
            return info.prohibitMove();
        }
        return true;
    }

    private static int getDestLineForAnonymous(Editor editor, LineRange range, boolean down) {
        PsiClass aClass;
        int destLine;
        int n = destLine = down ? range.endLine + 1 : range.startLine - 1;
        if (!(range.firstElement instanceof PsiStatement)) {
            return destLine;
        }
        PsiElement sibling = JavaStatementMover.firstNonWhiteElement((PsiElement)(down ? range.lastElement.getNextSibling() : range.firstElement.getPrevSibling()), (boolean)down);
        if (sibling != null && (aClass = (PsiClass)PsiTreeUtil.findChildOfType((PsiElement)sibling, PsiClass.class, (boolean)true, PsiStatement.class)) != null && PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiStatement.class) == sibling) {
            destLine = editor.getDocument().getLineNumber(down ? sibling.getTextRange().getEndOffset() + 1 : sibling.getTextRange().getStartOffset());
        }
        return destLine;
    }

    private static boolean calcInsertOffset(PsiFile file, Editor editor, LineRange range, StatementUpDownMover.MoveInfo info, boolean down) {
        int startLine;
        int destLine = JavaStatementMover.getDestLineForAnonymous(editor, range, down);
        int n = startLine = down ? range.endLine : range.startLine - 1;
        if (destLine < 0 || startLine < 0) {
            return false;
        }
        do {
            int offset = editor.logicalPositionToOffset(new LogicalPosition(destLine, 0));
            for (PsiElement element = JavaStatementMover.firstNonWhiteElement((int)offset, (PsiFile)file, (boolean)true); element != null && !(element instanceof PsiFile); element = element.getParent()) {
                TextRange elementTextRange = element.getTextRange();
                if (!elementTextRange.isEmpty() && elementTextRange.grown(-1).shiftRight(1).contains(offset)) continue;
                PsiElement elementToSurround = null;
                boolean found = false;
                if ((element instanceof PsiStatement || element instanceof PsiComment) && JavaStatementMover.statementCanBePlacedAlong(element)) {
                    found = true;
                    if (!JavaStatementMover.statementsCanBeMovedWithin(element.getParent())) {
                        elementToSurround = element;
                    }
                } else if (PsiUtil.isJavaToken(element, JavaTokenType.RBRACE) && JavaStatementMover.statementsCanBeMovedWithin(element.getParent())) {
                    found = true;
                }
                if (!found) continue;
                STATEMENT_TO_SURROUND_WITH_CODE_BLOCK_KEY.set((UserDataHolder)info, (Object)elementToSurround);
                info.toMove = range;
                int endLine = destLine;
                if (startLine > endLine) {
                    int tmp = endLine;
                    endLine = startLine;
                    startLine = tmp;
                }
                info.toMove2 = down ? new LineRange(startLine, endLine) : new LineRange(startLine, endLine + 1);
                return true;
            }
        } while ((destLine += down ? 1 : -1) >= 0 && destLine < editor.getDocument().getLineCount());
        return false;
    }

    private static boolean statementCanBePlacedAlong(PsiElement element) {
        if (element instanceof IJspTemplateStatement) {
            PsiElement neighbour = element.getPrevSibling();
            return neighbour != null && !(neighbour instanceof IJspTemplateStatement);
        }
        PsiElement parent = element.getParent();
        if (element instanceof PsiBlockStatement && !(parent instanceof PsiCodeBlock)) {
            return false;
        }
        if (parent instanceof IJspClassLevelDeclarationStatement) {
            return false;
        }
        if (JavaStatementMover.statementsCanBeMovedWithin(parent)) {
            return true;
        }
        if (parent instanceof PsiIfStatement && (element == ((PsiIfStatement)parent).getThenBranch() || element == ((PsiIfStatement)parent).getElseBranch())) {
            return true;
        }
        if (parent instanceof PsiWhileStatement && element == ((PsiWhileStatement)parent).getBody()) {
            return true;
        }
        return parent instanceof PsiDoWhileStatement && element == ((PsiDoWhileStatement)parent).getBody();
    }

    private static boolean statementsCanBeMovedWithin(PsiElement parent) {
        return parent instanceof PsiCodeBlock || parent instanceof PsiJavaModule;
    }

    private static boolean checkMovingInsideOutside(PsiFile file, Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (info == null) {
            JavaStatementMover.$$$reportNull$$$0(5);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAtOffset = file.getViewProvider().findElementAt(offset, (Language)JavaLanguage.INSTANCE);
        if (elementAtOffset == null) {
            return false;
        }
        PsiElement guard = JavaStatementMover.findGuard(elementAtOffset);
        PsiElement brace = JavaStatementMover.itIsTheClosingCurlyBraceWeAreMoving(file, editor);
        if (brace != null) {
            int line = editor.getDocument().getLineNumber(offset);
            LineRange toMove = new LineRange(line, line + 1);
            toMove.firstElement = toMove.lastElement = brace;
            info.toMove = toMove;
        }
        if (!JavaStatementMover.calcInsertOffset(file, editor, info.toMove, info, down)) {
            return false;
        }
        int insertOffset = down ? JavaStatementMover.getLineStartSafeOffset((Document)editor.getDocument(), (int)info.toMove2.endLine) : editor.getDocument().getLineStartOffset(info.toMove2.startLine);
        PsiElement elementAtInsertOffset = file.getViewProvider().findElementAt(insertOffset, (Language)JavaLanguage.INSTANCE);
        PsiElement newGuard = JavaStatementMover.findGuard(elementAtInsertOffset);
        if (brace != null && PsiTreeUtil.getParentOfType((PsiElement)brace, PsiCodeBlock.class, (boolean)false) != PsiTreeUtil.getParentOfType((PsiElement)elementAtInsertOffset, PsiCodeBlock.class, (boolean)false)) {
            info.indentSource = true;
        }
        if (newGuard == guard && JavaStatementMover.isInside(insertOffset, newGuard) == JavaStatementMover.isInside(offset, guard)) {
            return true;
        }
        if (guard instanceof PsiClass && guard.getParent() instanceof PsiClass) {
            return true;
        }
        return newGuard instanceof PsiClass && newGuard.getParent() instanceof PsiClass;
    }

    private static PsiElement findGuard(PsiElement element) {
        PsiElement guard = element;
        while ((guard = PsiTreeUtil.getParentOfType((PsiElement)guard, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class, PsiClass.class, PsiComment.class})) instanceof PsiAnonymousClass) {
        }
        return guard;
    }

    private static boolean isInside(int offset, PsiElement guard) {
        TextRange inside;
        if (guard == null) {
            return false;
        }
        if (guard instanceof PsiMethod) {
            PsiCodeBlock body = ((PsiMethod)guard).getBody();
            inside = body != null ? body.getTextRange() : null;
        } else if (guard instanceof PsiClassInitializer) {
            inside = ((PsiClassInitializer)guard).getBody().getTextRange();
        } else if (guard instanceof PsiClass) {
            PsiElement left = ((PsiClass)guard).getLBrace();
            PsiElement right = ((PsiClass)guard).getRBrace();
            inside = left != null && right != null ? new TextRange(left.getTextOffset(), right.getTextOffset()) : null;
        } else {
            inside = guard.getTextRange();
        }
        return inside != null && inside.contains(offset);
    }

    private static LineRange expandLineRangeToCoverPsiElements(LineRange range, Editor editor, PsiFile file) {
        int endLine;
        Document document;
        Pair psiRange = JavaStatementMover.getElementRange((Editor)editor, (PsiFile)file, (LineRange)range);
        if (psiRange == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)((PsiElement)psiRange.getFirst()), (PsiElement)((PsiElement)psiRange.getSecond()));
        Pair elementRange = JavaStatementMover.getElementRange((PsiElement)parent, (PsiElement)((PsiElement)psiRange.getFirst()), (PsiElement)((PsiElement)psiRange.getSecond()));
        if (elementRange == null) {
            return null;
        }
        int endOffset = ((PsiElement)elementRange.getSecond()).getTextRange().getEndOffset();
        if (endOffset > (document = editor.getDocument()).getTextLength()) {
            LOG.assertTrue(!PsiDocumentManager.getInstance((Project)file.getProject()).isUncommited(document));
            LOG.assertTrue(PsiDocumentManagerBase.checkConsistency((PsiFile)file, (Document)document));
        }
        if (endOffset == document.getTextLength()) {
            endLine = document.getLineCount();
        } else {
            endLine = editor.offsetToLogicalPosition((int)endOffset).line + 1;
            endLine = Math.min(endLine, document.getLineCount());
        }
        int startLine = Math.min(range.startLine, editor.offsetToLogicalPosition((int)((PsiElement)elementRange.getFirst()).getTextOffset()).line);
        endLine = Math.max(endLine, range.endLine);
        return new LineRange(startLine, endLine);
    }

    private static PsiElement itIsTheClosingCurlyBraceWeAreMoving(PsiFile file, Editor editor) {
        LineRange range = JavaStatementMover.getLineRangeFromSelection((Editor)editor);
        if (range.endLine - range.startLine != 1) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int line = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(line);
        String lineText = document.getText().substring(lineStartOffset, document.getLineEndOffset(line));
        if (!lineText.trim().equals("}")) {
            return null;
        }
        return file.findElementAt(lineStartOffset + lineText.indexOf(125));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/moveUpDown/JavaStatementMover";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeMove";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMovingInsideOutside";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

