/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.connection.throwable.KnownDatabaseException;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcDriverManagerImpl;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseFastConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseSshTunnelEstablisher;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.remote.jdbc.TypedKey;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSshConnectionInterceptor
extends DatabaseFastConnectionInterceptor {
    protected static final TypedKey<Boolean> SSH_TUNNEL_PROCESSED = TypedKey.create((String)"SSH_TUNNEL_PROCESSED");

    public boolean handleConnectionFailureFast(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @NotNull Throwable e, boolean silent, int attempt) {
        Throwable state;
        if (proto2 == null) {
            BaseSshConnectionInterceptor.$$$reportNull$$$0(0);
        }
        if (e == null) {
            BaseSshConnectionInterceptor.$$$reportNull$$$0(1);
        }
        if ((state = ((JdbcDriverManagerImpl)JdbcDriverManager.getDriverManager(proto2.getProject())).getTunnelsState(proto2.getConnectionPoint().getDataSource())) != null) {
            BaseDatabaseErrorHandler.SshFailedErrorInfo info2 = new BaseDatabaseErrorHandler.SshFailedErrorInfo(proto2.getConnectionPoint().getDataSource(), state, state);
            throw new KnownDatabaseException((ErrorInfo)info2);
        }
        return false;
    }

    protected static List<DatabaseSshTunnelEstablisher.SshTunnel> getTunnels(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2) {
        if (proto2 == null) {
            BaseSshConnectionInterceptor.$$$reportNull$$$0(2);
        }
        JdbcDriverManager driverManager = JdbcDriverManager.getDriverManager(proto2.getProject());
        DatabaseConnectionPoint connectionPoint = proto2.getConnectionPoint();
        return driverManager.getTunnels(connectionPoint.getDataSource());
    }

    protected static boolean checkSshConfiguration(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @NotNull List<DatabaseSshTunnelEstablisher.SshTunnel> tunnels) {
        if (proto2 == null) {
            BaseSshConnectionInterceptor.$$$reportNull$$$0(3);
        }
        if (tunnels == null) {
            BaseSshConnectionInterceptor.$$$reportNull$$$0(4);
        }
        if (tunnels.isEmpty()) {
            DataSourceSshTunnelConfiguration ssh = DataSourceSshTunnelConfiguration.getEnabledSshConfiguration((DatabaseConnectionPoint)proto2.getConnectionPoint());
            if (ssh != null && proto2.getDriver() != null) {
                RuntimeException exception = new RuntimeException("No SSH tunnel, available");
                BaseDatabaseErrorHandler.SshFailedErrorInfo info2 = new BaseDatabaseErrorHandler.SshFailedErrorInfo(proto2.getConnectionPoint().getDataSource(), (Throwable)exception, (Throwable)exception);
                throw new KnownDatabaseException((ErrorInfo)info2);
            }
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tunnels";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/BaseSshConnectionInterceptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleConnectionFailureFast";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTunnels";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSshConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

