/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.console.OffsetSavingBuilder;
import com.intellij.database.data.types.ConsumerColumnRef;
import com.intellij.database.data.types.EqualsPredicateOperation;
import com.intellij.database.data.types.NullPredicateValue;
import com.intellij.database.data.types.ObjectPredicateValue;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.datagrid.mutating.RowUpdateData;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.mongo.MongoScriptUtilKt;
import com.intellij.database.dialects.mongo.generator.dml.UtilKt;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.InsertRowsTask;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002 \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0002\u0012\u0004\u0012\u00020\u00060\u0001B\u0017\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/mongo/generator/dml/MongoInsertRowsGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "Lcom/intellij/database/dataSource/connection/Either;", "", "", "Lcom/intellij/database/datagrid/mutating/RowUpdateData;", "Lcom/intellij/database/script/generator/dml/InsertRowsTask;", "task", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/script/generator/dml/InsertRowsTask;Lcom/intellij/database/Dbms;)V", "generate", "intellij.database.dialects.mongo"})
@SourceDebugExtension(value={"SMAP\nMongoInsertRowsGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoInsertRowsGenerator.kt\ncom/intellij/database/dialects/mongo/generator/dml/MongoInsertRowsGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1#2:50\n1#2:61\n1617#3,9:51\n1869#3:60\n1870#3:62\n1626#3:63\n*S KotlinDebug\n*F\n+ 1 MongoInsertRowsGenerator.kt\ncom/intellij/database/dialects/mongo/generator/dml/MongoInsertRowsGenerator\n*L\n36#1:61\n36#1:51,9\n36#1:60\n36#1:62\n36#1:63\n*E\n"})
public class MongoInsertRowsGenerator
extends DmlGenerator<Either<String, List<RowUpdateData>>, InsertRowsTask> {
    @NotNull
    private final Dbms dbms;

    public MongoInsertRowsGenerator(@NotNull InsertRowsTask task, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super((DmlTask)task);
        this.dbms = dbms;
    }

    @NotNull
    public Either<String, List<RowUpdateData>> generate() {
        DatabaseDialectEx databaseDialectEx = DbImplUtilCore.getDatabaseDialect((Dbms)this.dbms);
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"getDatabaseDialect(...)");
        DatabaseDialectEx dialect = databaseDialectEx;
        OffsetSavingBuilder builder = new OffsetSavingBuilder(DbImplUtilCore.createBuilderForUIExec((DatabaseDialectEx)dialect));
        List data = new ArrayList();
        Set equalsOperation = SetsKt.setOf((Object)new EqualsPredicateOperation(null, 1, null));
        for (RowMutation mutation : ((InsertRowsTask)this.getTask()).getMutations()) {
            String sql;
            List list = mutation.getData();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getData(...)");
            String string = DmlUtilKt.checkUnparsed((List)list);
            if (string != null) {
                String it = string;
                boolean bl = false;
                return Either.Companion.left((Object)it);
            }
            DdlBuilder ddlBuilder = UtilKt.dbCollection(this.dbms, (DdlBuilder)builder, ((InsertRowsTask)this.getTask()).getTable()).symbol(".").plain("insertOne");
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"plain(...)");
            MongoScriptUtilKt.inParenth$default(ddlBuilder, false, () -> MongoInsertRowsGenerator.generate$lambda$3(mutation, this, builder, equalsOperation), 1, null);
            Intrinsics.checkNotNullExpressionValue((Object)builder.getStatement(), (String)"getStatement(...)");
            RowQueryData qData = new RowQueryData(CollectionsKt.emptyList(), builder.getOffsets(), sql, new BitSet(0));
            data.add(new RowUpdateData(qData, 1));
            builder.clear();
        }
        return Either.Companion.right((Object)data);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generate$lambda$3(RowMutation $mutation, MongoInsertRowsGenerator this$0, OffsetSavingBuilder $builder, Set $equalsOperation) {
        void $this$mapNotNullTo$iv$iv;
        List list = $mutation.getData();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getData(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Triple triple;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ColumnQueryData datum = (ColumnQueryData)element$iv$iv;
            boolean bl2 = false;
            if (datum.getObject() == ReservedCellValue.UNSET) {
                triple = null;
            } else {
                PredicateValue predicateValue;
                GridColumn gridColumn = datum.getColumn();
                Intrinsics.checkNotNull((Object)gridColumn, (String)"null cannot be cast to non-null type com.intellij.database.datagrid.DataConsumer.Column");
                ConsumerColumnRef consumerColumnRef = new ConsumerColumnRef((GridColumn)((DataConsumer.Column)gridColumn), ((InsertRowsTask)this$0.getTask()).getTable());
                if (datum.getObject() != null) {
                    void it;
                    ConsumerColumnRef consumerColumnRef2 = consumerColumnRef;
                    boolean bl3 = false;
                    consumerColumnRef = consumerColumnRef2;
                    predicateValue = (PredicateValue)new ObjectPredicateValue((Object)it);
                } else {
                    predicateValue = (PredicateValue)NullPredicateValue.INSTANCE;
                }
                Set set = $equalsOperation;
                PredicateValue predicateValue2 = predicateValue;
                ConsumerColumnRef consumerColumnRef3 = consumerColumnRef;
                triple = new Triple((Object)consumerColumnRef3, (Object)predicateValue2, (Object)set);
            }
            if (triple == null) continue;
            Triple it$iv$iv = triple;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List v = (List)destination$iv$iv;
        UtilKt.generateWhere(this$0.dbms, (WhereClause)new ValuesWhereClause(v, "AND", null), (DdlBuilder)$builder, this$0.getTask());
        return Unit.INSTANCE;
    }
}

