/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.commands;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.scientific.py.tables.commands.DSFrameAccessorCommandExecutor;
import com.intellij.scientific.py.tables.util.UtilKt;
import com.intellij.scientific.tables.DSTableBundle;
import com.intellij.scientific.tables.DSTableDataException;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.editor.DSTableVirtualFile;
import com.intellij.scientific.tables.panel.actions.DSOpenInNewTabActionKt;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.pydev.tables.PyNumericContainerPopupCustomizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/scientific/py/tables/commands/DSNumericContainerPopupCustomizer;", "Lcom/jetbrains/python/debugger/pydev/tables/PyNumericContainerPopupCustomizer;", "<init>", "()V", "showFullValuePopup", "", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "debugValue", "Lcom/jetbrains/python/debugger/PyDebugValue;", "intellij.scientific.py.tables"})
public final class DSNumericContainerPopupCustomizer
implements PyNumericContainerPopupCustomizer {
    public boolean showFullValuePopup(@NotNull PyFrameAccessor frameAccessor, @NotNull PyDebugValue debugValue) {
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        Intrinsics.checkNotNullParameter((Object)debugValue, (String)"debugValue");
        Project project = frameAccessor.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        if (!PlatformUtils.isDataSpell() || DSOpenInNewTabActionKt.isPowerfulTableEnabled()) {
            return false;
        }
        DSFrameAccessorCommandExecutor commandExecutor = new DSFrameAccessorCommandExecutor(frameAccessor);
        DSTableDataType dSTableDataType = UtilKt.getDSTableDataType(debugValue);
        if (dSTableDataType == null) {
            Object[] objectArray = new Object[]{String.valueOf(debugValue.getType())};
            throw new DSTableDataException(DSTableBundle.message((String)"ds.table.type.is.not.supported", (Object[])objectArray));
        }
        DSTableDataType type = dSTableDataType;
        String string = debugValue.getEvaluationExpression();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEvaluationExpression(...)");
        String string2 = debugValue.getEvaluationExpression();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEvaluationExpression(...)");
        DSTableVirtualFile file = new DSTableVirtualFile(string, string2, type, (DSTableCommandExecutor)commandExecutor);
        FileEditorManager.getInstance((Project)project2).openEditor(new OpenFileDescriptor(project2, (VirtualFile)file), true);
        return true;
    }
}

