# Release Notes - v2.8.30

**Date**: 2026-01-24

## 📝 Executive Summary

```text
2.8.30 2026-01-24

- feat: add InnoDB transaction isolation levels and metrics (active count, longest duration)
- feat: add MariaDB innodb_snapshot_isolation detection and recommendation
- feat: implement robust container transport support (--container)
- feat: skip kernel tuning recommendations in container mode or when running in Docker
- feat: dynamic MySQL/MariaDB client detection in containers/remote hosts
- feat: automatic database password retrieval from container environment (MYSQL_ROOT_PASSWORD/MARIADB_ROOT_PASSWORD)
- fix: incorrect skip-name-resolve recommendations for cPanel systems (issue #863)
- fix: noisy system command failures when absolute paths are used for whitelisted commands (issue #874)
- fix: resolve syntax error and Perl compilation warnings in `mysqltuner.pl`
- fix: ensure shell commands (pipes, redirections) work correctly in containers using `sh -c`
- docs: synchronize all README files with authentication mismatch troubleshooting guide
- ci: update package.json test script and create remember workflow
- ci: consolidate testing laboratory scripts into unified build/test_envs.sh and update Makefile
- ci: enhance `build/test_envs.sh` to capture and link all infrastructure logs (Docker start, DB injection, container logs, inspect data) in HTML reports for full audit traceability
- ci: make HTML reports self-sufficient by embedding logs directly and reordering sections
- ci: implement tripartite testing scenarios (Standard, Container, Dumpdir) per configuration with horizontal scenario selector in HTML reports
- ci: normalize HTML log panels with consistent Raw/Log links and improved UI layout
- ci: harden laboratory execution script with rigorous return code checking and log portability (copy vs symlink)
- ci: automate cleanup of `examples/` directory to keep only the 10 most recent results
- ci: add `/examples-cleanup` workflow for manual laboratory maintenance
- ci: implement automated technical release notes system via `build/release_gen.py` and `/release-notes-gen` workflow
- ci: add automated `.agent/README.md` synchronization via `build/doc_sync.py` and `/doc-sync` workflow
- test: add unit test tests/innodb_isolation.t for new transaction metrics
- test: add regression test tests/repro_issue_863.t for cPanel name resolution logic
- test: add unit test tests/test_issue_874.t to verify system command whitelisting and unix_socket logic
- test: add unit test tests/issue_869.t to verify InnoDB chunk breakdown on MariaDB 11.4+ (issue #869)
- test: validate MySQLTuner compatibility with MariaDB 11.8 (detected 11.8.5)
```

## 📈 Diagnostic Growth Indicators

| Metric | Current | Progress | Status |
| :--- | :--- | :--- | :--- |
| Total Indicators | 8 | +8 | 🚀 |
| Efficiency Checks | 0 | 0 | 🛡️ |
| Risk Detections | 1 | +1 | 🚀 |
| Information Points | 7 | +7 | 🚀 |

## 🧪 New Diagnostic Capabilities

### 🛑 New Risk Detections
- Table $dbname.$tbname has no index defined
- innodb_snapshot_isolation is OFF with REPEATABLE-READ (Stricter snapshot isolation is disabled)

### ℹ️ New Information Points
- Dumpdir: $opt{dumpdir}
- Dumping information schema
- Dumping performance schema
- Dumping sys schema
- General MyIsam metrics:
- InnoDB Snapshot Isolation: 
- SKIPPING $sys_view
- Transaction Isolation Level: $isolation
- table_definition_cache (

## 🛠️ Internal Commit History

Initial release or no previous tag found.

## ⚙️ Technical Evolutions

### ➕ CLI Options Added
- `--azure`
- `--bannedports`
- `--buffers`
- `--checkversion`
- `--cloud`
- `--color`
- `--colstat`
- `--container`
- `--dbgpattern`
- `--dbstat`
- `--debug`
- `--defaultarch`
- `--defaults-extra-file`
- `--defaults-file`
- `--dumpdir`
- `--experimental`
- `--feature`
- `--forcemem`
- `--forceswap`
- `--host`
- `--idxstat`
- `--ignore-tables`
- `--json`
- `--max-password-checks`
- `--maxportallowed`
- `--noask`
- `--nobad`
- `--nocolor`
- `--nocolstat`
- `--nodbstat`
- `--nogood`
- `--noidxstat`
- `--noinfo`
- `--nomyisamstat`
- `--nondedicated`
- `--nopfstat`
- `--noplugininfo`
- `--noprettyicon`
- `--noprocess`
- `--nostructstat`
- `--nosysstat`
- `--notbstat`
- `--outputfile`
- `--pass`
- `--password`
- `--passwordfile`
- `--pfstat`
- `--pipe`
- `--pipe_name`
- `--plugininfo`
- `--port`
- `--prettyjson`
- `--protocol`
- `--reportfile`
- `--server-log`
- `--silent`
- `--skippassword`
- `--skipsize`
- `--socket`
- `--ssh-host`
- `--ssh-identity-file`
- `--ssh-password`
- `--ssh-user`
- `--ssl-ca`
- `--sysstat`
- `--tbstat`
- `--template`
- `--updateversion`
- `--user`
- `--verbose`

## ✅ Laboratory Verification Results

- [x] Automated TDD suite passed.
- [x] Multi-DB version laboratory execution validated.
- [x] Performance indicator delta analysis completed.
