<?php
/**
 * Script to update list of supported lexers.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * http://www.gnu.org/copyleft/gpl.html
 *
 * @file
 * @author Ori Livneh <ori@wikimedia.org>
 * @ingroup Maintenance
 */

namespace MediaWiki\SyntaxHighlight\Maintenance;

use MediaWiki\Maintenance\Maintenance;
use MediaWiki\SyntaxHighlight\Pygmentize;
use MediaWiki\SyntaxHighlight\PygmentsException;
use Wikimedia\StaticArrayWriter;

// @codeCoverageIgnoreStart
$IP = getenv( 'MW_INSTALL_PATH' ) ?: __DIR__ . '/../../..';

require_once "$IP/maintenance/Maintenance.php";
// @codeCoverageIgnoreEnd

class UpdateLexerList extends Maintenance {
	public function __construct() {
		parent::__construct();

		$this->requireExtension( 'SyntaxHighlight' );
		$this->addDescription( 'Update list of lexers supported by SyntaxHighlight' );
	}

	public function execute() {
		$header = 'Generated by ' . basename( __FILE__ );

		try {
			$data = Pygmentize::fetchLexers();
		} catch ( PygmentsException $e ) {
			$this->fatalError( "Error when getting lexers:\n" . $e->getMessage() );
		}

		$writer = new StaticArrayWriter();
		$code = $writer->create( $data, $header );

		file_put_contents( __DIR__ . '/../SyntaxHighlight.lexers.php', $code );
		$this->output( "Updated language list written to SyntaxHighlight.lexers.php\n" );
	}
}

// @codeCoverageIgnoreStart
$maintClass = UpdateLexerList::class;
require_once RUN_MAINTENANCE_IF_MAIN;
// @codeCoverageIgnoreEnd
