/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.time.DateTimeException;
import java.time.ZoneOffset;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.consumer.ChunkHeader;

final class TimeConverter {
    private final long startTicks;
    private final long startNanos;
    private final double divisor;
    private final ZoneOffset zoneOffet;

    TimeConverter(ChunkHeader chunkHeader, int n) {
        this.startTicks = chunkHeader.getStartTicks();
        this.startNanos = chunkHeader.getStartNanos();
        this.divisor = chunkHeader.getTicksPerSecond() / 1.0E9;
        this.zoneOffet = this.zoneOfSet(n);
    }

    private ZoneOffset zoneOfSet(int n) {
        try {
            return ZoneOffset.ofTotalSeconds(n / 1000);
        }
        catch (DateTimeException dateTimeException) {
            Logger.log(LogTag.JFR_SYSTEM_PARSER, LogLevel.INFO, "Could not create ZoneOffset from raw offset " + n);
            return ZoneOffset.UTC;
        }
    }

    public long convertTimestamp(long l) {
        return this.startNanos + (long)((double)(l - this.startTicks) / this.divisor);
    }

    public long convertTimespan(long l) {
        return (long)((double)l / this.divisor);
    }

    public ZoneOffset getZoneOffset() {
        return this.zoneOffet;
    }
}

