/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6NamedImports;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.validation.JSBundleMessageHighlighter;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6UnusedImportsInspection
extends JSInspection {
    public static final String SHORT_NAME = ES6UnusedImportsInspection.calcShortNameFromClass(ES6UnusedImportsInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6UnusedImportsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6UnusedImportsInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(this){

            public void visitTypeScriptImportStatement(@NotNull TypeScriptImportStatement importStatement) {
                if (importStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ES6UnusedImportsHelper.INSTANCE.isUnusedTypeScriptImport(importStatement, Collections.emptySet())) {
                    LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("javascript.unused.import.remove", (PsiElement)importStatement);
                    holder.registerProblem((PsiElement)importStatement, JSUnusedLocalSymbolsInspection.unusedMessage((PsiElement)importStatement), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{fix});
                }
            }

            public void visitES6ImportDeclaration(@NotNull ES6ImportDeclaration importDeclaration) {
                if (importDeclaration == null) {
                    1.$$$reportNull$$$0(1);
                }
                JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)importDeclaration, () -> {
                    ES6UnusedImportsHelper.UnusedInfo info = ES6UnusedImportsHelper.INSTANCE.getInfo(importDeclaration);
                    if (info.isAllUnused() && !PsiTreeUtil.hasErrorElements((PsiElement)importDeclaration)) {
                        String message = ((JSBundleMessageHighlighter)importDeclaration.getProject().getService(JSBundleMessageHighlighter.class)).message("js.unused.symbol.full", importDeclaration);
                        LocalQuickFixAndIntentionActionOnPsiElement fix = ES6UnusedImportsInspection.createRemoveImportFix(importDeclaration);
                        TextRange range = info.isEmpty() ? ES6UnusedImportsInspection.getSpecifiersRange(importDeclaration) : null;
                        holder.registerProblem((PsiElement)importDeclaration, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, range, new LocalQuickFix[]{fix});
                    } else {
                        for (ES6ImportedBinding binding : info.getUnusedBindings()) {
                            holder.registerProblem((PsiElement)binding, JSUnusedLocalSymbolsInspection.unusedMessage((PsiElement)binding), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new DeleteImportPartFix((PsiElement)binding)});
                        }
                        for (ES6ImportSpecifier specifier : info.getUnusedSpecifiers()) {
                            holder.registerProblem((PsiElement)specifier, JSUnusedLocalSymbolsInspection.unusedMessage((PsiElement)specifier), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new DeleteImportPartFix((PsiElement)specifier)});
                        }
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "importStatement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "importDeclaration";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6UnusedImportsInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeScriptImportStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6ImportDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static TextRange getSpecifiersRange(@NotNull ES6ImportDeclaration es6ImportDeclaration) {
        ES6NamedImports imports;
        if (es6ImportDeclaration == null) {
            ES6UnusedImportsInspection.$$$reportNull$$$0(2);
        }
        if ((imports = es6ImportDeclaration.getNamedImports()) == null) {
            return null;
        }
        TextRange range = imports.getTextRange();
        int parent = imports.getStartOffsetInParent();
        return new TextRange(parent, parent + range.getLength());
    }

    @NotNull
    private static LocalQuickFixAndIntentionActionOnPsiElement createRemoveImportFix(@NotNull ES6ImportDeclaration importDeclaration) {
        if (importDeclaration == null) {
            ES6UnusedImportsInspection.$$$reportNull$$$0(3);
        }
        LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement = JSFixFactory.getInstance().removeASTNodeFix("javascript.unused.import.remove", (PsiElement)importDeclaration);
        if (localQuickFixAndIntentionActionOnPsiElement == null) {
            ES6UnusedImportsInspection.$$$reportNull$$$0(4);
        }
        return localQuickFixAndIntentionActionOnPsiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "es6ImportDeclaration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDeclaration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6UnusedImportsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6UnusedImportsInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoveImportFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSpecifiersRange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveImportFix";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class DeleteImportPartFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected DeleteImportPartFix(@Nullable PsiElement element2) {
            super(element2);
        }

        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message((String)"javascript.unused.import.remove.specifier", (Object[])new Object[0]);
            if (string == null) {
                DeleteImportPartFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                DeleteImportPartFix.$$$reportNull$$$0(1);
            }
            if (psiFile == null) {
                DeleteImportPartFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                DeleteImportPartFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                DeleteImportPartFix.$$$reportNull$$$0(4);
            }
            if (startElement instanceof ES6ImportExportDeclarationPart) {
                startElement.delete();
            }
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                DeleteImportPartFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6UnusedImportsInspection$DeleteImportPartFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6UnusedImportsInspection$DeleteImportPartFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

