/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.database.connection;

import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.liquibase.common.LiquibaseGenerationContextRegistry;
import com.intellij.liquibase.common.ddl.LiquibaseGenerator;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import liquibase.ext.intellij.database.connection.FakeStatement;
import liquibase.ext.intellij.database.connection.IntellijConnectionMetadata;
import liquibase.resource.ResourceAccessor;

public class IntellijConnection
implements Connection {
    public static final String CONTEXT_PROP = "generationContext";
    public static final String DBMS_TYPE_PROP = "dbmsType";
    public static final String DBMS_VERSION_PROP = "dbmsVersion";
    private final String url;
    private final ResourceAccessor resourceAccessor;
    private final Properties properties;
    private final Project project;
    private final DbType dbType;
    private final LiquibaseGenerationContext generationContext;

    public IntellijConnection(String url, ResourceAccessor resourceAccessor) {
        this.url = url;
        this.resourceAccessor = resourceAccessor;
        this.properties = new Properties();
        int queryIndex = url.indexOf(63);
        if (queryIndex >= 0) {
            this.properties.putAll((Map<?, ?>)this.readProperties(url.substring(queryIndex + 1)));
        }
        this.generationContext = LiquibaseGenerationContextRegistry.INSTANCE.get(UUID.fromString(this.properties.getProperty(CONTEXT_PROP)));
        this.project = this.generationContext.getProject();
        this.dbType = this.generationContext.getMainDbType();
    }

    public LiquibaseGenerationContext getGenerationContext() {
        return this.generationContext;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public LiquibaseGenerator getLiquibaseGenerator() {
        return this.generationContext.getGenerator(this.getDbType());
    }

    public Project getProject() {
        return this.project;
    }

    protected Properties readProperties(String queryString) {
        Properties properties2 = new Properties();
        queryString = queryString.replaceAll("&", System.lineSeparator());
        try {
            queryString = URLDecoder.decode(queryString, StandardCharsets.UTF_8);
            properties2.load(new StringReader(queryString));
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Failed to read properties from url", ioe);
        }
        return properties2;
    }

    public String getUrl() {
        return this.url;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new FakeStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return null;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new IntellijConnectionMetadata(this.url);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return "JPA_BUDDY";
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties2) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public void abort(Executor arg0) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public String getSchema() throws SQLException {
        return "JPA_BUDDY";
    }

    @Override
    public void setNetworkTimeout(Executor arg0, int arg1) throws SQLException {
    }

    @Override
    public void setSchema(String arg0) throws SQLException {
    }

    public ResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }
}

