/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.spring.factories.resolvers.AbstractProxiedTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopedProxyFactoryBeanTypeResolver
extends AbstractProxiedTypeResolver {
    @NonNls
    private static final String FACTORY_CLASS = "org.springframework.aop.scope.ScopedProxyFactoryBean";
    @NonNls
    private static final String TARGET_BEAN_NAME_PROPERTY_NAME = "targetBeanName";

    @Override
    @NotNull
    public Set<PsiType> getObjectType(@Nullable CommonSpringBean context) {
        SpringBean springBean;
        PsiClassType type;
        if (context instanceof SpringBean && (type = this.getTargetType(springBean = (SpringBean)context)) != null) {
            Set<String> targetInterfaceNames;
            if (this.isBooleanPropertySetAndFalse(springBean, "proxyTargetClass") && !(targetInterfaceNames = ScopedProxyFactoryBeanTypeResolver.getAllInterfaceNames((PsiType)type)).isEmpty()) {
                Set<PsiType> set = SpringBeanCoreUtils.convertToNonNullTypes(targetInterfaceNames, context);
                if (set == null) {
                    ScopedProxyFactoryBeanTypeResolver.$$$reportNull$$$0(0);
                }
                return set;
            }
            Set<PsiClassType> set = Collections.singleton(type);
            if (set == null) {
                ScopedProxyFactoryBeanTypeResolver.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set<PsiType> set = Collections.emptySet();
        if (set == null) {
            ScopedProxyFactoryBeanTypeResolver.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Nullable
    private PsiClassType getTargetType(@NotNull SpringBean context) {
        PsiClassType fromTargetName;
        String targetBeanName;
        if (context == null) {
            ScopedProxyFactoryBeanTypeResolver.$$$reportNull$$$0(3);
        }
        if ((targetBeanName = this.getPropertyValue((CommonSpringBean)context, TARGET_BEAN_NAME_PROPERTY_NAME)) != null && (fromTargetName = ScopedProxyFactoryBeanTypeResolver.getTypeFromBeanName(context, targetBeanName)) != null) {
            return fromTargetName;
        }
        return null;
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            ScopedProxyFactoryBeanTypeResolver.$$$reportNull$$$0(4);
        }
        return FACTORY_CLASS.equals(factoryClassName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/resolvers/ScopedProxyFactoryBeanTypeResolver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/resolvers/ScopedProxyFactoryBeanTypeResolver";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTargetType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

