/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.service.ui.ExternalSystemJdkComboBox;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.updateSettings.impl.LabelTextReplacingUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenHomeType;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.StaticResolvedMavenHomeType;
import org.jetbrains.idea.maven.project.actions.LookForNestedToggleAction;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenImportingSettingsForm {
    private JPanel myPanel;
    private JCheckBox mySearchRecursivelyCheckBox;
    private JComboBox<String> myUpdateFoldersOnImportPhaseComboBox;
    private JCheckBox myUseMavenOutputCheckBox;
    private JCheckBox myDownloadSourcesCheckBox;
    private JCheckBox myDownloadDocsCheckBox;
    private JCheckBox myDownloadAnnotationsCheckBox;
    private JPanel myAdditionalSettingsPanel;
    private JComboBox<MavenImportingSettings.GeneratedSourcesFolder> myGeneratedSourcesComboBox;
    private JCheckBox myExcludeTargetFolderCheckBox;
    private JTextField myDependencyTypes;
    private JBTextField myVMOptionsForImporter;
    private ExternalSystemJdkComboBox myJdkForImporterComboBox;
    private JBLabel myImporterJdkWarning;
    private JCheckBox myAutoDetectCompilerCheckBox;
    private JCheckBox runPluginsCompat;
    private final ComponentValidator myImporterJdkValidator;
    private volatile boolean myMuteJdkValidation;

    public MavenImportingSettingsForm(Project project, @NotNull Disposable disposable) {
        if (disposable == null) {
            MavenImportingSettingsForm.$$$reportNull$$$0(0);
        }
        this.myMuteJdkValidation = false;
        this.$$$setupUI$$$();
        this.myJdkForImporterComboBox.setProject(project);
        this.mySearchRecursivelyCheckBox.setVisible(project.isDefault());
        this.myUpdateFoldersOnImportPhaseComboBox.setModel(new DefaultComboBoxModel<String>(MavenImportingSettings.UPDATE_FOLDERS_PHASES));
        this.myGeneratedSourcesComboBox.setModel((ComboBoxModel<MavenImportingSettings.GeneratedSourcesFolder>)new EnumComboBoxModel(MavenImportingSettings.GeneratedSourcesFolder.class));
        this.myGeneratedSourcesComboBox.setRenderer(BuilderKt.textListCellRenderer((String)"", value -> value.getTitle()));
        LabelTextReplacingUtil.replaceText((JComponent)this.myPanel);
        this.myAutoDetectCompilerCheckBox.setVisible(Registry.is((String)"maven.import.compiler.arguments", (boolean)true));
        this.runPluginsCompat.setVisible(Registry.is((String)"maven.use.plugins.m2e.compat"));
        this.myJdkForImporterComboBox.setHighlightInternalJdk(false);
        ActionListener validatorListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenImportingSettingsForm.this.validateImporterJDK();
            }
        };
        this.myJdkForImporterComboBox.addActionListener(validatorListener);
        this.myImporterJdkValidator = new ComponentValidator(disposable).withValidator(() -> {
            StaticResolvedMavenHomeType staticResolvedMavenHomeType;
            String version;
            if (JavaSdkVersionUtil.isAtLeast((Sdk)this.myJdkForImporterComboBox.getSelectedJdk(), (JavaSdkVersion)JavaSdkVersion.JDK_17)) {
                return null;
            }
            MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(project).getSettings();
            MavenHomeType type = settings.getGeneralSettings().getMavenHomeType();
            if (type instanceof StaticResolvedMavenHomeType && (version = MavenUtil.getMavenVersion(staticResolvedMavenHomeType = (StaticResolvedMavenHomeType)type)) != null && version.startsWith("4")) {
                return new ValidationInfo(MavenConfigurableBundle.message("maven.settings.importing.jdk.too.old.error.4", new Object[0]), (JComponent)this.myJdkForImporterComboBox);
            }
            if (!JavaSdkVersionUtil.isAtLeast((Sdk)this.myJdkForImporterComboBox.getSelectedJdk(), (JavaSdkVersion)JavaSdkVersion.JDK_1_8)) {
                return new ValidationInfo(MavenConfigurableBundle.message("maven.settings.importing.jdk.too.old.error", new Object[0]), (JComponent)this.myJdkForImporterComboBox);
            }
            return null;
        }).installOn((JComponent)this.myJdkForImporterComboBox);
        this.myImporterJdkWarning.setVisible(false);
    }

    private void updateModuleDirControls() {
        this.validateImporterJDK();
    }

    public String getDefaultModuleDir() {
        return "";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public void getData(@NotNull MavenImportingSettings data) {
        if (data == null) {
            MavenImportingSettingsForm.$$$reportNull$$$0(1);
        }
        data.setLookForNested(this.mySearchRecursivelyCheckBox.isSelected());
        LookForNestedToggleAction.setSelected(this.mySearchRecursivelyCheckBox.isSelected());
        data.setExcludeTargetFolder(this.myExcludeTargetFolderCheckBox.isSelected());
        data.setUseMavenOutput(this.myUseMavenOutputCheckBox.isSelected());
        data.setUpdateFoldersOnImportPhase((String)this.myUpdateFoldersOnImportPhaseComboBox.getSelectedItem());
        data.setGeneratedSourcesFolder((MavenImportingSettings.GeneratedSourcesFolder)((Object)this.myGeneratedSourcesComboBox.getSelectedItem()));
        data.setDownloadSourcesAutomatically(this.myDownloadSourcesCheckBox.isSelected());
        data.setDownloadDocsAutomatically(this.myDownloadDocsCheckBox.isSelected());
        data.setDownloadAnnotationsAutomatically(this.myDownloadAnnotationsCheckBox.isSelected());
        data.setAutoDetectCompiler(this.myAutoDetectCompilerCheckBox.isSelected());
        data.setRunPluginsCompatibilityOnSyncAndBuild(this.runPluginsCompat.isSelected());
        data.setVmOptionsForImporter(this.myVMOptionsForImporter.getText());
        data.setJdkForImporter(this.myJdkForImporterComboBox.getSelectedValue());
        data.setDependencyTypes(this.myDependencyTypes.getText());
    }

    public void setData(MavenImportingSettings data, @Nullable Project project) {
        this.mySearchRecursivelyCheckBox.setSelected(LookForNestedToggleAction.isSelected());
        this.myExcludeTargetFolderCheckBox.setSelected(data.isExcludeTargetFolder());
        this.myUseMavenOutputCheckBox.setSelected(data.isUseMavenOutput());
        this.myUpdateFoldersOnImportPhaseComboBox.setSelectedItem(data.getUpdateFoldersOnImportPhase());
        this.myGeneratedSourcesComboBox.setSelectedItem((Object)data.getGeneratedSourcesFolder());
        this.myDownloadSourcesCheckBox.setSelected(data.isDownloadSourcesAutomatically());
        this.myDownloadDocsCheckBox.setSelected(data.isDownloadDocsAutomatically());
        this.myDownloadAnnotationsCheckBox.setSelected(data.isDownloadAnnotationsAutomatically());
        this.myAutoDetectCompilerCheckBox.setSelected(data.isAutoDetectCompiler());
        this.runPluginsCompat.setSelected(data.isRunPluginsCompatibilityOnSyncAndBuild());
        this.myDependencyTypes.setText(data.getDependencyTypes());
        this.myVMOptionsForImporter.setText(data.getVmOptionsForImporter());
        this.skipValidationDuring(() -> this.myJdkForImporterComboBox.refreshData(data.getJdkForImporter()));
        this.updateModuleDirControls();
    }

    private void skipValidationDuring(Runnable r) {
        this.myMuteJdkValidation = true;
        try {
            r.run();
        }
        finally {
            this.myMuteJdkValidation = false;
            this.validateImporterJDK();
        }
    }

    private static boolean isCurrentlyStoredExternally(@Nullable Project project) {
        return project == null || ExternalStorageConfigurationManager.getInstance((Project)project).isEnabled();
    }

    public boolean isModified(@NotNull MavenImportingSettings settings) {
        if (settings == null) {
            MavenImportingSettingsForm.$$$reportNull$$$0(2);
        }
        MavenImportingSettings formData = new MavenImportingSettings();
        this.getData(formData);
        return !formData.equals(settings);
    }

    public JPanel getAdditionalSettingsPanel() {
        return this.myAdditionalSettingsPanel;
    }

    private void validateImporterJDK() {
        if (this.myMuteJdkValidation) {
            return;
        }
        this.myImporterJdkValidator.revalidate();
        if (this.myImporterJdkValidator.getValidationInfo() == null) {
            this.myImporterJdkWarning.setVisible(false);
        } else {
            this.myImporterJdkWarning.setVisible(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/MavenImportingSettingsForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        JCheckBox jCheckBox2;
        ExternalSystemJdkComboBox externalSystemJdkComboBox;
        JBTextField jBTextField;
        JTextField jTextField;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(22, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySearchRecursivelyCheckBox = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.search.recursively"));
        jPanel2.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myUseMavenOutputCheckBox = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.use.output.directories"));
        jCheckBox6.setToolTipText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.use.output.directories.tooltip"));
        jPanel2.add((Component)jCheckBox6, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.phase.for.source.updates.notes"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(9, 0, 1, 3, 0, 1, 3, 0, null, null, null, 3));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel3.setFocusable(true);
        jPanel2.add((Component)jPanel3, new GridConstraints(11, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.auto.download"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDownloadSourcesCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.auto.download.sources"));
        jPanel3.add((Component)jCheckBox5, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDownloadDocsCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.auto.download.documentation"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JBCheckBox jBCheckBox = new JBCheckBox();
        this.myDownloadAnnotationsCheckBox = jBCheckBox;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.auto.download.annotations"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myAdditionalSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(15, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(20, 0, 1, 3, 8, 2, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(11, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(21, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(8, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myUpdateFoldersOnImportPhaseComboBox = jComboBox;
        jPanel4.add(jComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.phase.for.source.updates"));
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel2.add((Component)spacer5, new GridConstraints(7, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer6 = new Spacer();
        jPanel2.add((Component)spacer6, new GridConstraints(1, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.generated.source.folders"));
        jPanel5.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel5.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myGeneratedSourcesComboBox = jComboBox2;
        jPanel5.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myExcludeTargetFolderCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.project.exclude.build.directory"));
        jCheckBox3.setToolTipText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.project.exclude.build.directory.tooltip"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.dependency.type"));
        jLabel4.setToolTipText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.dependency.type.tooltip"));
        jPanel2.add((Component)jLabel4, new GridConstraints(12, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDependencyTypes = jTextField = new JTextField();
        jTextField.setColumns(0);
        jTextField.setToolTipText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.dependency.type.tooltip"));
        jPanel2.add((Component)jTextField, new GridConstraints(12, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel3.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel3.setHorizontalTextPosition(4);
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.dependency.type.tooltip"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(13, 1, 1, 2, 9, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel2.add((Component)spacer8, new GridConstraints(14, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer9 = new Spacer();
        jPanel2.add((Component)spacer9, new GridConstraints(10, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.vm.options"));
        jPanel2.add((Component)jBLabel4, new GridConstraints(15, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVMOptionsForImporter = jBTextField = new JBTextField();
        jPanel2.add((Component)jBTextField, new GridConstraints(15, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.jdk"));
        jPanel2.add((Component)jBLabel5, new GridConstraints(17, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJdkForImporterComboBox = externalSystemJdkComboBox = new ExternalSystemJdkComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        externalSystemJdkComboBox.setModel(defaultComboBoxModel);
        jPanel2.add((Component)externalSystemJdkComboBox, new GridConstraints(17, 1, 1, 2, 0, 1, 2, 2, null, null, null));
        this.myAutoDetectCompilerCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.detect.compiler"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel6.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel6.setHorizontalTextPosition(4);
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.vm.options.tooltip"));
        jPanel2.add((Component)jBLabel6, new GridConstraints(16, 1, 1, 2, 9, 0, 0, 0, null, null, null));
        this.myImporterJdkWarning = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.jdk.fallback.warning"));
        jPanel2.add((Component)jBLabel, new GridConstraints(19, 1, 1, 1, 9, 0, 0, 0, null, null, null));
        this.runPluginsCompat = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.use.plugin.compat"));
        jCheckBox.setToolTipText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.use.plugin.compat.tooltip"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jLabel4.setLabelFor(jTextField);
        jBLabel3.setLabelFor(jTextField);
        jBLabel6.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

