/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint;

import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AbstractConstraintAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaConstraintAnnotation;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.constraint.Constraint;
import com.intellij.jpa.jpb.model.model.constraint.DigitsConstraint;
import com.intellij.openapi.module.Module;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DigitsAnnotation
extends AbstractConstraintAnnotation {
    public static final String INTEGER = "integer";
    public static final String FRACTION = "fraction";

    public DigitsAnnotation() {
        super(JpaConstraintAnnotation.Digits);
    }

    @Override
    public LinkedHashMap<String, String> getParams(@NotNull EntityAttribute attribute, Module module) {
        String annotationFraction;
        if (attribute == null) {
            DigitsAnnotation.$$$reportNull$$$0(0);
        }
        LinkedHashMap<String, String> params = super.getParams(attribute, module);
        String annotationInteger = this.digitsAnnotationInteger(attribute);
        if (annotationInteger != null) {
            params.put(INTEGER, annotationInteger);
        }
        if ((annotationFraction = this.digitsAnnotationFraction(attribute)) != null) {
            params.put(FRACTION, annotationFraction);
        }
        return params;
    }

    @Nullable
    private String digitsAnnotationInteger(EntityAttribute attribute) {
        Constraint c = this.getConstraint(attribute);
        if (c instanceof DigitsConstraint) {
            Integer integer = ((DigitsConstraint)c).getInteger();
            return integer != null ? integer.toString() : null;
        }
        return null;
    }

    @Nullable
    private String digitsAnnotationFraction(EntityAttribute attribute) {
        Constraint c = this.getConstraint(attribute);
        if (c instanceof DigitsConstraint) {
            Integer fraction = ((DigitsConstraint)c).getFraction();
            return fraction != null ? fraction.toString() : null;
        }
        return null;
    }

    @Override
    public List<String> knownAttributes(EntityAttribute attribute) {
        List<String> knownAttributes = super.knownAttributes(attribute);
        knownAttributes.add(INTEGER);
        knownAttributes.add(FRACTION);
        return knownAttributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/jpa/jpb/model/backend/ed/annotation/attr/constraint/DigitsAnnotation", "getParams"));
    }
}

