/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.CustomJdbcTypeMapper;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdbcTypesUtil {
    @NonNls
    public static final String CHAR_ARR = "char[]";
    @NonNls
    public static final String BYTE_ARR = "byte[]";
    public static final String BOOLEAN = "java.lang.Boolean";
    public static final String BYTE = "java.lang.Byte";
    public static final String SHORT = "java.lang.Short";
    public static final String INTEGER = "java.lang.Integer";
    public static final String LONG = "java.lang.Long";
    public static final String BIGINT = "java.math.BigInteger";
    public static final String BIGDECIMAL = "java.math.BigDecimal";
    public static final String FLOAT = "java.lang.Float";
    public static final String DOUBLE = "java.lang.Double";
    public static final String STRING = "java.lang.String";
    public static final String BLOB = "java.sql.Blob";
    public static final String SQL_DATE = "java.sql.Date";
    public static final String UTIL_DATE = "java.util.Date";
    public static final String SQL_TIME = "java.sql.Time";
    public static final String SQL_TIMESTAMP = "java.sql.Timestamp";
    public static final String CLOB = "java.sql.Clob";
    public static final String SQL_ARRAY = "java.sql.Array";
    public static final String SQL_REF = "java.sql.Ref";
    public static final String OBJECT = "java.lang.Object";
    public static final String SQL_STRUCT = "java.sql.Struct";
    public static final String SERIALIZABLE = "java.io.Serializable";
    public static final String MAP = "java.util.Map";

    private JdbcTypesUtil() {
    }

    public static int getJdbcType(@NotNull DasTypedObject column, @Nullable DatabaseDialect dialect) {
        if (column == null) {
            JdbcTypesUtil.$$$reportNull$$$0(0);
        }
        return JdbcTypesUtil.getJdbcType(column.getDasType().toDataType(), dialect);
    }

    @NotNull
    public static @NotNull String @NotNull [] getJavaTypeVariants(@NotNull DasTypedObject column, @Nullable DatabaseDialect dialect, boolean preferUnboxed, @Nullable Project project) {
        if (column == null) {
            JdbcTypesUtil.$$$reportNull$$$0(1);
        }
        DataType dataType = column.getDasType().toDataType();
        boolean isNotNull = column.isNotNull();
        boolean unboxed = preferUnboxed && isNotNull;
        Object[] defaultVariants = JdbcTypesUtil.getJavaTypeVariants(dataType, dialect, unboxed);
        if (project == null || !(column instanceof DasColumn)) {
            if (defaultVariants == null) {
                JdbcTypesUtil.$$$reportNull$$$0(2);
            }
            return defaultVariants;
        }
        String[] stringArray = (String[])((StreamEx)StreamEx.of((Collection)CustomJdbcTypeMapper.EP_NAME.getExtensionList()).flatMap(extension -> extension.getMappedJavaTypeFor((DasColumn)column, project).stream()).append(defaultVariants).distinct()).toArray((Object[])ArrayUtilRt.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            JdbcTypesUtil.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @NotNull
    public static @NotNull String @NotNull [] getJavaTypeVariants(@NotNull DataType dataType, @Nullable DatabaseDialect dialect, boolean unboxed) {
        String[] stringArray;
        if (dataType == null) {
            JdbcTypesUtil.$$$reportNull$$$0(4);
        }
        int jdbcType = JdbcTypesUtil.getJdbcType(dataType, dialect);
        switch (jdbcType) {
            case -7: 
            case 16: {
                String[] stringArray2 = new String[10];
                stringArray2[0] = BOOLEAN;
                stringArray2[1] = BYTE;
                stringArray2[2] = SHORT;
                stringArray2[3] = INTEGER;
                stringArray2[4] = LONG;
                stringArray2[5] = BIGINT;
                stringArray2[6] = FLOAT;
                stringArray2[7] = DOUBLE;
                stringArray2[8] = BIGDECIMAL;
                stringArray = stringArray2;
                stringArray2[9] = STRING;
                break;
            }
            case -6: {
                String[] stringArray3 = new String[10];
                stringArray3[0] = BYTE;
                stringArray3[1] = SHORT;
                stringArray3[2] = INTEGER;
                stringArray3[3] = LONG;
                stringArray3[4] = BIGINT;
                stringArray3[5] = BOOLEAN;
                stringArray3[6] = FLOAT;
                stringArray3[7] = DOUBLE;
                stringArray3[8] = BIGDECIMAL;
                stringArray = stringArray3;
                stringArray3[9] = STRING;
                break;
            }
            case 5: {
                String[] stringArray4 = new String[10];
                stringArray4[0] = SHORT;
                stringArray4[1] = INTEGER;
                stringArray4[2] = LONG;
                stringArray4[3] = BIGINT;
                stringArray4[4] = BOOLEAN;
                stringArray4[5] = BYTE;
                stringArray4[6] = FLOAT;
                stringArray4[7] = DOUBLE;
                stringArray4[8] = BIGDECIMAL;
                stringArray = stringArray4;
                stringArray4[9] = STRING;
                break;
            }
            case 4: {
                String[] stringArray5 = new String[10];
                stringArray5[0] = INTEGER;
                stringArray5[1] = LONG;
                stringArray5[2] = BIGINT;
                stringArray5[3] = BOOLEAN;
                stringArray5[4] = BYTE;
                stringArray5[5] = SHORT;
                stringArray5[6] = FLOAT;
                stringArray5[7] = DOUBLE;
                stringArray5[8] = BIGDECIMAL;
                stringArray = stringArray5;
                stringArray5[9] = STRING;
                break;
            }
            case -5: {
                String[] stringArray6 = new String[10];
                stringArray6[0] = LONG;
                stringArray6[1] = BIGINT;
                stringArray6[2] = BOOLEAN;
                stringArray6[3] = BYTE;
                stringArray6[4] = SHORT;
                stringArray6[5] = INTEGER;
                stringArray6[6] = FLOAT;
                stringArray6[7] = DOUBLE;
                stringArray6[8] = BIGDECIMAL;
                stringArray = stringArray6;
                stringArray6[9] = STRING;
                break;
            }
            case 7: {
                String[] stringArray7 = new String[10];
                stringArray7[0] = FLOAT;
                stringArray7[1] = DOUBLE;
                stringArray7[2] = BIGDECIMAL;
                stringArray7[3] = BOOLEAN;
                stringArray7[4] = BYTE;
                stringArray7[5] = SHORT;
                stringArray7[6] = INTEGER;
                stringArray7[7] = LONG;
                stringArray7[8] = BIGINT;
                stringArray = stringArray7;
                stringArray7[9] = STRING;
                break;
            }
            case 6: 
            case 8: {
                String[] stringArray8 = new String[10];
                stringArray8[0] = DOUBLE;
                stringArray8[1] = FLOAT;
                stringArray8[2] = BIGDECIMAL;
                stringArray8[3] = BOOLEAN;
                stringArray8[4] = BYTE;
                stringArray8[5] = SHORT;
                stringArray8[6] = INTEGER;
                stringArray8[7] = LONG;
                stringArray8[8] = BIGINT;
                stringArray = stringArray8;
                stringArray8[9] = STRING;
                break;
            }
            case 2: 
            case 3: {
                int bytesRequired;
                int precision = dataType.getPrecision();
                int n = bytesRequired = precision > 0 ? (int)((double)precision / Math.log(2.0) / 8.0 + 0.5) : 0;
                if (bytesRequired > 0) {
                    if (dataType.getScale() == 0) {
                        if (bytesRequired <= 4) {
                            String[] stringArray9 = new String[10];
                            stringArray9[0] = INTEGER;
                            stringArray9[1] = BOOLEAN;
                            stringArray9[2] = BYTE;
                            stringArray9[3] = SHORT;
                            stringArray9[4] = LONG;
                            stringArray9[5] = BIGINT;
                            stringArray9[6] = FLOAT;
                            stringArray9[7] = DOUBLE;
                            stringArray9[8] = BIGDECIMAL;
                            stringArray = stringArray9;
                            stringArray9[9] = STRING;
                            break;
                        }
                        if (bytesRequired <= 8) {
                            String[] stringArray10 = new String[10];
                            stringArray10[0] = LONG;
                            stringArray10[1] = BOOLEAN;
                            stringArray10[2] = BYTE;
                            stringArray10[3] = SHORT;
                            stringArray10[4] = INTEGER;
                            stringArray10[5] = BIGINT;
                            stringArray10[6] = FLOAT;
                            stringArray10[7] = DOUBLE;
                            stringArray10[8] = BIGDECIMAL;
                            stringArray = stringArray10;
                            stringArray10[9] = STRING;
                            break;
                        }
                        String[] stringArray11 = new String[10];
                        stringArray11[0] = BIGINT;
                        stringArray11[1] = BOOLEAN;
                        stringArray11[2] = BYTE;
                        stringArray11[3] = SHORT;
                        stringArray11[4] = INTEGER;
                        stringArray11[5] = LONG;
                        stringArray11[6] = FLOAT;
                        stringArray11[7] = DOUBLE;
                        stringArray11[8] = BIGDECIMAL;
                        stringArray = stringArray11;
                        stringArray11[9] = STRING;
                        break;
                    }
                    String[] stringArray12 = new String[10];
                    stringArray12[0] = BIGDECIMAL;
                    stringArray12[1] = BOOLEAN;
                    stringArray12[2] = BYTE;
                    stringArray12[3] = SHORT;
                    stringArray12[4] = INTEGER;
                    stringArray12[5] = LONG;
                    stringArray12[6] = BIGINT;
                    stringArray12[7] = FLOAT;
                    stringArray12[8] = DOUBLE;
                    stringArray = stringArray12;
                    stringArray12[9] = STRING;
                    break;
                }
                if (dataType.getScale() == 0) {
                    String[] stringArray13 = new String[10];
                    stringArray13[0] = BIGINT;
                    stringArray13[1] = BOOLEAN;
                    stringArray13[2] = BYTE;
                    stringArray13[3] = SHORT;
                    stringArray13[4] = INTEGER;
                    stringArray13[5] = LONG;
                    stringArray13[6] = FLOAT;
                    stringArray13[7] = DOUBLE;
                    stringArray13[8] = BIGDECIMAL;
                    stringArray = stringArray13;
                    stringArray13[9] = STRING;
                    break;
                }
                String[] stringArray14 = new String[10];
                stringArray14[0] = BIGDECIMAL;
                stringArray14[1] = BOOLEAN;
                stringArray14[2] = BYTE;
                stringArray14[3] = SHORT;
                stringArray14[4] = INTEGER;
                stringArray14[5] = LONG;
                stringArray14[6] = BIGINT;
                stringArray14[7] = FLOAT;
                stringArray14[8] = DOUBLE;
                stringArray = stringArray14;
                stringArray14[9] = STRING;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                if (dataType.getLength() == 1) {
                    String[] stringArray15 = new String[7];
                    stringArray15[0] = STRING;
                    stringArray15[1] = BOOLEAN;
                    stringArray15[2] = BYTE;
                    stringArray15[3] = SHORT;
                    stringArray15[4] = INTEGER;
                    stringArray15[5] = CHAR_ARR;
                    stringArray = stringArray15;
                    stringArray15[6] = BYTE_ARR;
                    break;
                }
                String[] stringArray16 = new String[7];
                stringArray16[0] = STRING;
                stringArray16[1] = CHAR_ARR;
                stringArray16[2] = BYTE_ARR;
                stringArray16[3] = SQL_DATE;
                stringArray16[4] = SQL_TIME;
                stringArray16[5] = SQL_TIMESTAMP;
                stringArray = stringArray16;
                stringArray16[6] = UTIL_DATE;
                break;
            }
            case 91: {
                String[] stringArray17 = new String[3];
                stringArray17[0] = SQL_DATE;
                stringArray17[1] = UTIL_DATE;
                stringArray = stringArray17;
                stringArray17[2] = STRING;
                break;
            }
            case 92: {
                String[] stringArray18 = new String[2];
                stringArray18[0] = SQL_TIME;
                stringArray = stringArray18;
                stringArray18[1] = STRING;
                break;
            }
            case 93: {
                String[] stringArray19 = new String[2];
                stringArray19[0] = SQL_TIMESTAMP;
                stringArray = stringArray19;
                stringArray19[1] = STRING;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                String[] stringArray20 = new String[2];
                stringArray20[0] = BYTE_ARR;
                stringArray = stringArray20;
                stringArray20[1] = STRING;
                break;
            }
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: {
                String[] stringArray21 = new String[2];
                stringArray21[0] = OBJECT;
                stringArray = stringArray21;
                stringArray21[1] = SERIALIZABLE;
                break;
            }
            case 2002: {
                String[] stringArray22 = new String[3];
                stringArray22[0] = SQL_STRUCT;
                stringArray22[1] = MAP;
                stringArray = stringArray22;
                stringArray22[2] = OBJECT;
                break;
            }
            case 2003: {
                String[] stringArray23 = new String[2];
                stringArray23[0] = SQL_ARRAY;
                stringArray = stringArray23;
                stringArray23[1] = OBJECT;
                break;
            }
            case 2004: {
                String[] stringArray24 = new String[2];
                stringArray24[0] = BYTE_ARR;
                stringArray = stringArray24;
                stringArray24[1] = BLOB;
                break;
            }
            case 2005: 
            case 2011: {
                String[] stringArray25 = new String[3];
                stringArray25[0] = STRING;
                stringArray25[1] = CHAR_ARR;
                stringArray = stringArray25;
                stringArray25[2] = CLOB;
                break;
            }
            case 2006: {
                String[] stringArray26 = new String[3];
                stringArray26[0] = SQL_REF;
                stringArray26[1] = OBJECT;
                stringArray = stringArray26;
                stringArray26[2] = SERIALIZABLE;
                break;
            }
            default: {
                String[] stringArray27 = new String[2];
                stringArray27[0] = OBJECT;
                stringArray = stringArray27;
                stringArray27[1] = SERIALIZABLE;
            }
        }
        String[] result = stringArray;
        String[] stringArray28 = unboxed ? JdbcTypesUtil.unboxJavaTypes(result) : result;
        if (stringArray28 == null) {
            JdbcTypesUtil.$$$reportNull$$$0(5);
        }
        return stringArray28;
    }

    private static String[] unboxJavaTypes(String[] types) {
        for (int i = 0; i < types.length; ++i) {
            types[i] = PsiTypesUtil.unboxIfPossible((String)types[i]);
        }
        return types;
    }

    @Nullable
    public static String getJavaType(@NotNull DasColumn column, boolean preferPrimitiveTypes, @Nullable DatabaseDialect dialect, @Nullable Project project) {
        String[] javaType;
        if (column == null) {
            JdbcTypesUtil.$$$reportNull$$$0(6);
        }
        return (javaType = JdbcTypesUtil.getJavaTypeVariants((DasTypedObject)column, dialect, preferPrimitiveTypes, project)).length > 0 ? javaType[0] : OBJECT;
    }

    public static int getJdbcType(@NotNull DataType dataType, @Nullable DatabaseDialect dialect) {
        int jdbcType;
        if (dataType == null) {
            JdbcTypesUtil.$$$reportNull$$$0(7);
        }
        if ((jdbcType = dataType.jdbcType) == 1111 || jdbcType == 0) {
            jdbcType = dialect != null ? dialect.getJavaTypeForNativeType(dataType.getSpecification()) : JdbcUtil.guessJdbcTypeByName((String)dataType.getSpecification());
        }
        return jdbcType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/persistence/util/JdbcTypesUtil";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/persistence/util/JdbcTypesUtil";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaTypeVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJdbcType";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeVariants";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getJavaType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

