/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.SortedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

public class RatedResolveResult
implements ResolveResult {
    private final int myRate;
    private final PsiElement myWhat;
    public static final RatedResolveResult[] EMPTY_ARRAY = new RatedResolveResult[0];
    public static final int RATE_HIGH = 1000;
    public static final int RATE_NORMAL = 0;
    @ApiStatus.Experimental
    public static final int RATE_PY_FILE_OVERLOAD = -200;
    public static final int RATE_LOW = -1000;

    public RatedResolveResult(int rate, PsiElement what) {
        this.myRate = rate;
        this.myWhat = what;
    }

    public PsiElement getElement() {
        return this.myWhat;
    }

    public boolean isValidResult() {
        return this.myWhat != null;
    }

    public int getRate() {
        return this.myRate;
    }

    public RatedResolveResult replace(PsiElement what) {
        return new RatedResolveResult(this.myRate, what);
    }

    public String toString() {
        return String.valueOf(this.myWhat) + "@" + this.myRate;
    }

    public static List<RatedResolveResult> sorted(List<RatedResolveResult> targets) {
        if (targets.size() == 1) {
            return targets;
        }
        SortedList ret = new SortedList((one, another) -> another.getRate() - one.getRate());
        ret.addAll(targets);
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RatedResolveResult result = (RatedResolveResult)o;
        return this.myRate == result.myRate && Objects.equals(this.myWhat, result.myWhat);
    }

    public int hashCode() {
        return Objects.hash(this.myRate, this.myWhat);
    }
}

