/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.environment;

import com.intellij.httpClient.http.request.environment.FileDistance;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentsProviderKt;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/http/request/environment/DistanceFromFileComparator;", "Ljava/util/Comparator;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/Comparator;", "anchor", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "compare", "", "o1", "o2", "intellij.restClient"})
final class DistanceFromFileComparator
implements Comparator<VirtualFile> {
    @NotNull
    private final VirtualFile anchor;

    public DistanceFromFileComparator(@NotNull VirtualFile anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        this.anchor = anchor;
    }

    @Override
    public int compare(@NotNull VirtualFile o1, @NotNull VirtualFile o2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        FileDistance d1 = HttpClientEnvironmentsProviderKt.access$distance(this.anchor, o1);
        FileDistance d2 = HttpClientEnvironmentsProviderKt.access$distance(this.anchor, o2);
        int comparatorResult = HttpClientEnvironmentsProviderKt.access$getFILE_DISTANCE_COMPARATOR$p().compare(d1, d2);
        if (comparatorResult != 0) {
            n = comparatorResult;
        } else {
            String string = o1.getPath();
            String string2 = o2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            n = string.compareTo(string2);
        }
        return n;
    }
}

