/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.psi.references;

import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.converter.utils.HttpRequestPsiConverterUtilsKt;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestWebReference
extends WebReference {
    public HttpRequestWebReference(@NotNull PsiElement element, @Nullable String host) {
        if (element == null) {
            HttpRequestWebReference.$$$reportNull$$$0(0);
        }
        super(element, host);
    }

    public PsiElement resolve() {
        PsiElement parent = this.getElement().getParent();
        if (parent instanceof HttpRequest) {
            PsiFile contextFile = parent.getContainingFile();
            HttpRequestVariableSubstitutor substitutor2 = HttpRequestVariableSubstitutor.getDefault(parent.getProject(), contextFile);
            String url = ((HttpRequest)parent).getHttpUrl(substitutor2);
            if (StringUtil.isNotEmpty((String)url)) {
                return new HttpRequestFakePsiElement(url + HttpRequestPsiConverterUtilsKt.getEncodedQueryString((HttpRequest)parent, substitutor2));
            }
        }
        return null;
    }

    protected TextRange calculateDefaultRangeInElement() {
        return new TextRange(0, this.getElement().getTextLength());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/httpClient/http/request/psi/references/HttpRequestWebReference", "<init>"));
    }

    public class HttpRequestFakePsiElement
    extends FakePsiElement {
        private final String myFullUrl;

        public HttpRequestFakePsiElement(String fullUrl) {
            if (fullUrl == null) {
                HttpRequestFakePsiElement.$$$reportNull$$$0(0);
            }
            this.myFullUrl = fullUrl;
        }

        public PsiElement getParent() {
            return HttpRequestWebReference.this.myElement;
        }

        public void navigate(boolean requestFocus) {
            BrowserUtil.browse((String)this.myFullUrl);
        }

        public String getPresentableText() {
            return this.myFullUrl;
        }

        public String getName() {
            return this.myFullUrl;
        }

        public TextRange getTextRange() {
            TextRange rangeInElement = HttpRequestWebReference.this.getRangeInElement();
            TextRange elementRange = HttpRequestWebReference.this.myElement.getTextRange();
            return elementRange != null ? rangeInElement.shiftRight(elementRange.getStartOffset()) : rangeInElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullUrl", "com/intellij/httpClient/http/request/psi/references/HttpRequestWebReference$HttpRequestFakePsiElement", "<init>"));
        }
    }
}

