/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.console;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.httpClient.http.request.run.console.HttpClientMessagePrinter;
import com.intellij.httpClient.http.request.run.console.HttpClientOutputPrinter;
import com.intellij.httpClient.http.request.run.console.HttpResponsePrinter;
import com.intellij.httpClient.http.request.run.console.HttpResponseScriptConsoleWriter;
import com.intellij.httpClient.http.request.run.console.HttpResponseScriptProcessWriter;
import com.intellij.httpClient.http.request.run.test.HttpClientTestViewInfo;
import com.intellij.httpClient.http.request.run.test.HttpResponseTestAdapter;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.fileTypes.FileType;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpResponseOutputAdapter
implements HttpClientMessagePrinter,
HttpClientOutputPrinter {
    private final HttpResponsePrinter myPrinter;

    public HttpResponseOutputAdapter(@NotNull HttpResponsePrinter printer2) {
        if (printer2 == null) {
            HttpResponseOutputAdapter.$$$reportNull$$$0(0);
        }
        this.myPrinter = printer2;
    }

    @Override
    public void print(@NotNull String message, @NotNull HttpClientOutputPrinter.TextType type) {
        if (message == null) {
            HttpResponseOutputAdapter.$$$reportNull$$$0(1);
        }
        if (type == null) {
            HttpResponseOutputAdapter.$$$reportNull$$$0(2);
        }
        if (type == HttpClientOutputPrinter.TextType.JSON_OUTPUT) {
            this.printAsFileType(message, (FileType)JsonFileType.INSTANCE);
        } else {
            this.print(message, HttpResponseOutputAdapter.fromTextType(type));
        }
    }

    @Contract(pure=true)
    @NotNull
    private static ConsoleViewContentType fromTextType(@NotNull HttpClientOutputPrinter.TextType type) {
        if (type == null) {
            HttpResponseOutputAdapter.$$$reportNull$$$0(3);
        }
        ConsoleViewContentType consoleViewContentType = switch (type) {
            default -> throw new MatchException(null, null);
            case HttpClientOutputPrinter.TextType.NORMAL_OUTPUT -> ConsoleViewContentType.NORMAL_OUTPUT;
            case HttpClientOutputPrinter.TextType.ERROR_OUTPUT -> ConsoleViewContentType.ERROR_OUTPUT;
            case HttpClientOutputPrinter.TextType.LOG_INFO_OUTPUT -> ConsoleViewContentType.LOG_INFO_OUTPUT;
            case HttpClientOutputPrinter.TextType.JSON_OUTPUT -> throw new AssertionError((Object)"Should check JSON separately");
        };
        if (consoleViewContentType == null) {
            HttpResponseOutputAdapter.$$$reportNull$$$0(4);
        }
        return consoleViewContentType;
    }

    @NotNull
    public static HttpResponseOutputAdapter create(@NotNull ConsoleView console2) {
        if (console2 == null) {
            HttpResponseOutputAdapter.$$$reportNull$$$0(5);
        }
        HttpResponseScriptConsoleWriter stdout = new HttpResponseScriptConsoleWriter(console2, false);
        HttpResponseScriptConsoleWriter stderr = new HttpResponseScriptConsoleWriter(console2, true);
        return new HttpResponseOutputAdapter(new HttpResponsePrinter(stdout, stderr));
    }

    @NotNull
    public static HttpResponseOutputAdapter createTest(@NotNull ProcessHandler processHandler, @Nullable HttpClientTestViewInfo testView) {
        if (processHandler == null) {
            HttpResponseOutputAdapter.$$$reportNull$$$0(6);
        }
        HttpResponseScriptProcessWriter testStdout = new HttpResponseScriptProcessWriter(processHandler, false);
        HttpResponseScriptProcessWriter testStderr = new HttpResponseScriptProcessWriter(processHandler, true);
        return new HttpResponseTestAdapter(new HttpResponsePrinter(testStdout, testStderr), testView);
    }

    @Override
    public void printStart(@NotNull String name) {
        if (name == null) {
            HttpResponseOutputAdapter.$$$reportNull$$$0(7);
        }
    }

    @Override
    public void printEnd(@NotNull String name, long duration) {
        if (name == null) {
            HttpResponseOutputAdapter.$$$reportNull$$$0(8);
        }
    }

    @Override
    public void print(@NotNull String text2) {
        if (text2 == null) {
            HttpResponseOutputAdapter.$$$reportNull$$$0(9);
        }
        this.myPrinter.print(text2);
    }

    @Override
    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            HttpResponseOutputAdapter.$$$reportNull$$$0(10);
        }
        if (contentType == null) {
            HttpResponseOutputAdapter.$$$reportNull$$$0(11);
        }
        this.myPrinter.print(text2, contentType);
    }

    @Override
    public void printAsFileType(@NotNull String text2, @NotNull FileType fileType) {
        if (text2 == null) {
            HttpResponseOutputAdapter.$$$reportNull$$$0(12);
        }
        if (fileType == null) {
            HttpResponseOutputAdapter.$$$reportNull$$$0(13);
        }
        this.myPrinter.printAsFileType(text2, fileType);
    }

    @NotNull
    public HttpResponseOutputAdapter delayedIfNeeded(final Consumer<Runnable> delayedQueueAdder) {
        return new HttpResponseOutputAdapter(this.myPrinter){

            @Override
            public void printStart(@NotNull String name) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                delayedQueueAdder.accept(() -> HttpResponseOutputAdapter.this.printStart(name));
            }

            @Override
            public void printEnd(@NotNull String name, long duration) {
                if (name == null) {
                    1.$$$reportNull$$$0(1);
                }
                delayedQueueAdder.accept(() -> HttpResponseOutputAdapter.this.printEnd(name, duration));
            }

            @Override
            public void print(@NotNull String text2) {
                if (text2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                delayedQueueAdder.accept(() -> HttpResponseOutputAdapter.this.print(text2));
            }

            @Override
            public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
                if (text2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (contentType == null) {
                    1.$$$reportNull$$$0(4);
                }
                delayedQueueAdder.accept(() -> HttpResponseOutputAdapter.this.print(text2, contentType));
            }

            @Override
            public void printAsFileType(@NotNull String text2, @NotNull FileType fileType) {
                if (text2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (fileType == null) {
                    1.$$$reportNull$$$0(6);
                }
                delayedQueueAdder.accept(() -> HttpResponseOutputAdapter.this.printAsFileType(text2, fileType));
            }

            @Override
            @NotNull
            public HttpResponseOutputAdapter delayedIfNeeded(Consumer<Runnable> delayedQueueAdder2) {
                HttpResponseOutputAdapter httpResponseOutputAdapter = HttpResponseOutputAdapter.this.delayedIfNeeded(delayedQueueAdder2);
                if (httpResponseOutputAdapter == null) {
                    1.$$$reportNull$$$0(7);
                }
                return httpResponseOutputAdapter;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 7 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contentType";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileType";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/httpClient/http/request/run/console/HttpResponseOutputAdapter$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpResponseOutputAdapter$1";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "delayedIfNeeded";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "printStart";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "printEnd";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "print";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "printAsFileType";
                        break;
                    }
                    case 7: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 7 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/console/HttpResponseOutputAdapter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpResponseOutputAdapter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTextType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromTextType";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTest";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "printStart";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "printEnd";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "printAsFileType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

