/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.models.utils;

import com.intellij.aiplayground.models.LlmProvider;
import com.intellij.aiplayground.models.LlmProviderId;
import com.intellij.aiplayground.models.extension.LlmServiceExtension;
import com.intellij.aiplayground.models.utils.ModelInfo;
import com.intellij.aiplayground.models.utils.ProviderInfo;
import com.intellij.openapi.diagnostic.Logger;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/aiplayground/models/utils/ModelDescriptionReader;", "", "<init>", "()V", "providers", "", "Lcom/intellij/aiplayground/models/utils/ProviderInfo;", "getProviders", "getProviderInfo", "provider", "Lcom/intellij/aiplayground/models/LlmProvider;", "getModelsForProvider", "Lcom/intellij/aiplayground/models/utils/ModelInfo;", "getModelInfo", "modelId", "", "loadModelDescriptions", "", "parseXml", "inputStream", "Ljava/io/InputStream;", "parseModels", "modelElements", "Lorg/w3c/dom/NodeList;", "intellij.aiplayground.models"})
@SourceDebugExtension(value={"SMAP\nModelDescriptionReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelDescriptionReader.kt\ncom/intellij/aiplayground/models/utils/ModelDescriptionReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,153:1\n1#2:154\n23#3:155\n23#3:156\n23#3:157\n23#3:158\n23#3:159\n*S KotlinDebug\n*F\n+ 1 ModelDescriptionReader.kt\ncom/intellij/aiplayground/models/utils/ModelDescriptionReader\n*L\n78#1:155\n81#1:156\n84#1:157\n121#1:158\n125#1:159\n*E\n"})
public final class ModelDescriptionReader {
    @Nullable
    private List<ProviderInfo> providers;

    @NotNull
    public final List<ProviderInfo> getProviders() {
        List list;
        if (this.providers == null) {
            this.loadModelDescriptions();
        }
        if ((list = this.providers) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final ProviderInfo getProviderInfo(@NotNull LlmProvider provider) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Iterable iterable = this.getProviders();
            for (Object t : iterable) {
                ProviderInfo it = (ProviderInfo)t;
                boolean bl = false;
                if (!LlmProviderId.equals-impl0(it.getId().getId-rTbPaiE(), provider.getId-rTbPaiE())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final List<ModelInfo> getModelsForProvider(@NotNull LlmProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Object object = this.getProviderInfo(provider);
        if (object == null || (object = ((ProviderInfo)object).getModels()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public final ModelInfo getModelInfo(@NotNull LlmProvider provider, @NotNull String modelId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
            Iterable iterable = this.getModelsForProvider(provider);
            for (Object t : iterable) {
                ModelInfo it = (ModelInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)modelId)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadModelDescriptions() {
        try {
            InputStream inputStream = ModelDescriptionReader.class.getClassLoader().getResourceAsStream("META-INF/models-description.xml");
            if (inputStream != null) {
                int n;
                this.providers = this.parseXml(inputStream);
                ModelDescriptionReader $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ModelDescriptionReader.class);
                Logger logger2 = logger;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                List<ProviderInfo> list = this.providers;
                Integer n2 = list != null ? Integer.valueOf(list.size()) : null;
                List<ProviderInfo> list2 = this.providers;
                if (list2 != null) {
                    int n3;
                    Iterable iterable = list2;
                    Integer n4 = n2;
                    Logger logger3 = logger2;
                    int n5 = 0;
                    for (Object t : iterable) {
                        void it;
                        ProviderInfo providerInfo = (ProviderInfo)t;
                        n3 = n5;
                        boolean bl = false;
                        int n6 = it.getModels().size();
                        n5 = n3 + n6;
                    }
                    n3 = n5;
                    logger2 = logger3;
                    n2 = n4;
                    n = n3;
                } else {
                    n = 0;
                }
                logger2.info("Loaded " + n2 + " providers with " + n + " models");
            } else {
                ModelDescriptionReader $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ModelDescriptionReader.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Could not find models-description.xml");
            }
        }
        catch (Exception e) {
            ModelDescriptionReader $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ModelDescriptionReader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to load model descriptions", (Throwable)e);
            this.providers = CollectionsKt.emptyList();
        }
    }

    private final List<ProviderInfo> parseXml(InputStream inputStream) {
        List result = new ArrayList();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            NodeList providerElements = document.getElementsByTagName("provider");
            int n = providerElements.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = providerElements.item(i);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element providerElement = (Element)node;
                String string = providerElement.getAttribute("id");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttribute(...)");
                String providerId = LlmProviderId.constructor-impl(string);
                String providerName = providerElement.getAttribute("name");
                String website = providerElement.getAttribute("website");
                try {
                    LlmProvider providerType;
                    if (LlmServiceExtension.Companion.getProviderById-zfSeq9g(providerId) == null) {
                        throw new IllegalArgumentException("Unknown provider ID: " + LlmProviderId.toString-impl(providerId));
                    }
                    NodeList nodeList = providerElement.getElementsByTagName("model");
                    Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(...)");
                    List<ModelInfo> models = this.parseModels(nodeList);
                    Intrinsics.checkNotNull((Object)providerName);
                    Intrinsics.checkNotNull((Object)website);
                    result.add(new ProviderInfo(providerType, providerName, website, models));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    ModelDescriptionReader $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(ModelDescriptionReader.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Unknown provider ID: " + LlmProviderId.toString-impl(providerId));
                }
            }
        }
        catch (Exception e) {
            ModelDescriptionReader $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ModelDescriptionReader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Error parsing model descriptions XML", (Throwable)e);
        }
        return result;
    }

    private final List<ModelInfo> parseModels(NodeList modelElements) {
        List models = new ArrayList();
        int n = modelElements.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = modelElements.item(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element modelElement = (Element)node;
            String modelId = modelElement.getAttribute("id");
            String modelName = modelElement.getAttribute("name");
            String description = modelElement.getAttribute("description");
            Intrinsics.checkNotNull((Object)modelId);
            Intrinsics.checkNotNull((Object)modelName);
            Intrinsics.checkNotNull((Object)description);
            models.add(new ModelInfo(modelId, modelName, description));
        }
        return models;
    }
}

